<?php $__env->startSection('content'); ?>
<style>
	a:hover {
		color: #ffffff;
	}
	</style>
<div class="row">
    <form action="<?php echo e(url('whatsapp/send-whatsapp')); ?>" class="validate" autocomplete="off" method="post" accept-charset="utf-8">
		<div class="col-md-8">				
			<div class="panel panel-default">
				<div class="panel-heading">
					<div class="panel-title" >
						<?php echo e(_lang('Compose WhatsApp Message')); ?>

					</div>
				</div>
				<div class="panel-body">
					<?php echo csrf_field(); ?>
					<div class="col-md-12">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('User Type')); ?></label>			
							<select name="user_type" id="user_type" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<option value="Admin"><?php echo e(_lang('Admin')); ?></option>
								<option value="Student"><?php echo e(_lang('Student')); ?></option>
								<option value="Parent"><?php echo e(_lang('Parent')); ?></option>
								<option value="Teacher"><?php echo e(_lang('Teacher')); ?></option>
								<option value="Accountant"><?php echo e(_lang('Accountant')); ?></option>
								<option value="Librarian"><?php echo e(_lang('Librarian')); ?></option>
								<option value="Employee"><?php echo e(_lang('Employee')); ?></option>
							</select>						
						</div>
					</div>
					
					<div class="col-sm-6 student-group">
					   <div class="form-group">
							<label class="control-label"><?php echo e(_lang('Select Floor')); ?></label>
							<select name="class_id" onchange="getSection();" class="form-control select2">
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<option value="all"><?php echo e(_lang('Select All')); ?></option>
								<?php echo e(create_option('classes','id','class_name',old('class_id'))); ?>

							</select>
						</div>
					</div>
					
					<div class="col-sm-6 room-group">
					   <div class="form-group">
							<label class="control-label"><?php echo e(_lang('Select Room')); ?></label>
							<select name="section_id" onchange="get_students();" id="section_id" class="form-control select2">
								<option value=""><?php echo e(_lang('Select One')); ?></option>
							</select>
						</div>
					</div>		
					
					<div class="col-sm-12 student-group">
					   <div class="form-group">
							<label class="control-label"><?php echo e(_lang('Select Student')); ?></label>
							<select name="student_id" id="student_id" onchange="get_all_students();" class="form-control select2">
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<option value="all"><?php echo e(_lang('Select All')); ?></option>
							</select>
						</div>
					</div>
					
					<div class="col-sm-12 general-group">
					   <div class="form-group">
							<label class="control-label"><?php echo e(_lang('Select Receiver')); ?></label>
							<select name="user_id" id="user_id" onchange="get_all_users();" class="form-control select2">
								<option value=""><?php echo e(_lang('Select One')); ?></option>
							</select>
						</div>
					</div>
										
					<div class="col-md-12">
					<div class="form-group">
    <label class="control-label"><?php echo e(_lang('Message')); ?> ( <?php echo e(_lang('MAX 4000')); ?> )</label>
    <textarea class="form-control" name="body" id="body_message" required><?php echo e(old('body')); ?></textarea>
</div>


					</div>
										
					<div class="col-md-12">
						<div class="form-group">
							<button type="submit" name="action" value="whatsapp" class="btn btn-primary"><?php echo e(_lang('Send WhatsApp')); ?></button>
							
						</div>
					</div>
				</div>
			</div>
		</div>
	
		<div class="col-md-4">
			<div class="panel panel-default">
				<div class="panel-heading"><?php echo e(_lang('User List')); ?></div>
				<div class="panel-body" id="user_list">    
				</div>
			</div>	
		</div>
	</form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script  type="text/javascript">

    $(document).on('change','#user_type',function(){
		var user_type = $(this).val();
		
		if( user_type == "Student" ){
			$(".student-group").fadeIn();
			$(".general-group").css("display","none");
			$(".room-group").css("display","none");
			$("#student_id").prop("required",true);
			$("#user_id").prop("required",false);
		}else{
			$(".student-group").css("display","none");
			$(".general-group").fadeIn();
			$(".room-group").css("display","none");
			$("#student_id").prop("required",false);
			$("#user_id").prop("required",true);
			getUsers( user_type );
		}
	});
	
	function getUsers( type ) {
		$.ajax({
			url: "<?php echo e(url('users/get_users')); ?>/"+type,
			beforeSend: function(){
			    $("#preloader").css("display","block");
			},success: function(data){
				$("#preloader").css("display","none");
				var json =JSON.parse(data);
			    $('select[name=user_id]').html("");
				$('#user_list').html(""); 
					   
				jQuery.each( json, function( i, val ) {
					$('select[name=user_id]').append("<option value='"+val['id']+"'>"+val['name']+"</option>");
				});

				if( $('#user_id').has('option').length > 0 ) {
					$('select[name=user_id]').prepend("<option value='all'>All "+type+"</option>");
				}				
			}
		});
	}

	function getSection() {
		if( $('select[name=class_id]').val() == "all" ){
			
			$(".room-group").css("display","none");
			var class_id = $('select[name=class_id]').val() == "all" ;
			var _token=$('input[name=_token]').val();
			$.ajax({
				url: "<?php echo e(url('sections/all_section')); ?>",
				data:{_token:_token,class_id:class_id},				beforeSend: function(){
					$("#preloader").css("display","block");
				},success: function(data){
					$("#preloader").css("display","none");
					$('select[name=section_id]').html(data);
					
									
				}
			});
		}
		else if( $('select[name=class_id]').val() != "" ){
			$(".room-group").css("display","block");
			console.log('jifjods');
			var _token=$('input[name=_token]').val();
			var class_id=$('select[name=class_id]').val();
			$.ajax({
				type: "POST",
				url: "<?php echo e(url('sections/section')); ?>",
				data:{_token:_token,class_id:class_id},
				beforeSend: function(){
					$("#preloader").css("display","block");
				},success: function(data){
					$("#preloader").css("display","none");
					$('select[name=section_id]').html(data);				
				}
			});
		} 
	}
	
	
	function get_students(){
    	if( $("#user_type").val() == "Student" && $('select[name=section_id]').val() =="all" && $('select[name=class_id]').val() == "all"){	
			var class_id = "/"+$('select[name=class_id]').val();
			var section_id = "/"+$('select[name=section_id]').val();
			var link = "<?php echo e(url('students/get_all_students')); ?>";
			$.ajax({
				url: link,
				beforeSend: function(){
					$("#preloader").css("display","block");
				},success: function(data){
					console.log(data);
					$("#preloader").css("display","none");
					var json =JSON.parse(data);
					
					   $('select[name=student_id]').html("");
					   $('#user_list').html(""); 
					   
					jQuery.each( json, function( i, val ) {
					   $('select[name=student_id]').append("<option value='"+val['id']+"'>"+val['roll']+" - "+val['first_name']+" "+val['last_name']+"</option>");
				
					   console.log(val.phone, val.first_name + ' ' + val.last_name, val.address);	});

					if( $('#student_id').has('option').length > 0 ) {
						$('select[name=student_id]').prepend("<option value='all'><?php echo e(_lang('All Student')); ?></option>");
					}				
				}
			});
		}
		else if( $("#user_type").val() == "Student" && $('select[name=section_id]').val() !=""){	
			var class_id = "/"+$('select[name=class_id]').val();
			var section_id = "/"+$('select[name=section_id]').val();
			var link = "<?php echo e(url('students/get_students')); ?>"+class_id+section_id;
			$.ajax({
				url: link,
				beforeSend: function(){
					$("#preloader").css("display","block");
				},success: function(data){
					$("#preloader").css("display","none");
					var json =JSON.parse(data);
					   $('select[name=student_id]').html("");
					   $('#user_list').html(""); 
					   
					jQuery.each( json, function( i, val ) {
					   $('select[name=student_id]').append("<option value='"+val['id']+"'>"+val['roll']+" - "+val['first_name']+" "+val['last_name']+"</option>");
					
    			console.log(val.phone, val.first_name + ' ' + val.last_name, val.address);});

					if( $('#student_id').has('option').length > 0 ) {
						$('select[name=student_id]').prepend("<option value='all'><?php echo e(_lang('All Student')); ?></option>");
					}				
				}
			});
		}	
	}
	
	function get_all_students(){
		if($("#student_id").val() == "all" && $('select[name=class_id]').val() == "" &&  $('select[name=section_id]').val() == "" ){		
			var class_id = "/"+$('select[name=class_id]').val();
			var section_id = "/"+$('select[name=section_id]').val();
			var link = "<?php echo e(url('students/get_all_students')); ?>";
			$.ajax({
				url: link,
				beforeSend: function(){
					$("#preloader").css("display","block");
				},success: function(data){
					console.log(data.phone, data.first_name, data.last_name)
					$("#preloader").css("display","none");
					var json =JSON.parse(data);
					$('#user_list').html(""); 
					
					jQuery.each(json, function(i, val) {
						$('#user_list').append(
							'<div class="col-md-12">' +
								'<label class="c-container">' +
									'<input type="checkbox" value="' + val['id'] + '" name="students[]" checked="true">' +
									val['roll'] + " - " + val['first_name'] + " " + val['last_name'] +
									'<span class="checkmark"></span>' +
								'</label>' +
							'</div>'
						);

						// Log to console
						console.log(val.phone, val.first_name + ' ' + val.last_name, val.address);
					});

	
				}
			});
		}
		
		else if($("#student_id").val() == "all"  && $('select[name=class_id]').val() != "" &&  $('select[name=section_id]').val() != ""){		
			var class_id = "/"+$('select[name=class_id]').val();
			var section_id = "/"+$('select[name=section_id]').val();
			var link = "<?php echo e(url('students/get_students')); ?>"+class_id+section_id;
			$.ajax({
				url: link,
				beforeSend: function(){
					$("#preloader").css("display","block");
				},success: function(data){
					console.log(data.phone, data.first_name, data.last_name);
					$("#preloader").css("display","none");
					var json =JSON.parse(data);
					$('#user_list').html(""); 
					
					jQuery.each(json, function(i, val) {
						$('#user_list').append(
							'<div class="col-md-12">' +
								'<label class="c-container">' +
									'<input type="checkbox" value="' + val['id'] + '" name="students[]" checked="true">' +
									val['roll'] + " - " + val['first_name'] + " " + val['last_name'] +
									'<span class="checkmark"></span>' +
								'</label>' +
							'</div>'
						);

						// Log to console
						console.log(val.phone, val.first_name + ' ' + val.last_name, val.address);
					});

	
				}
			});
		}
		else{
		  $('#user_list').html("");
		}
	}
	
	function get_all_users(){
		if($("#user_id").val() == "all"){		
			var user_type = "/"+$('select[name=user_type]').val();
			var link = "<?php echo e(url('users/get_users')); ?>"+user_type;
			$.ajax({
				url: link,
				beforeSend: function(){
					$("#preloader").css("display","block");
				},success: function(data){
					$("#preloader").css("display","none");
					var json =JSON.parse(data);
					$('#user_list').html(""); 
					
					jQuery.each( json, function( i, val ) {
					   $('#user_list')
					   .append('<div class="col-md-12">'+
									'<label class="c-container">'+
									   '<input type="checkbox" value="'+val['id']+'" name="users[]" checked="true">'+val['name']+
									   '<span class="checkmark"></span>'+
									'</label>'+
								'</div>');
					});
	
				}
			});
		}else{
		  $('#user_list').html("");
		}
	}


	// $('form').on('submit', function(e) {
    // // Get message from textarea
    // let message = $('#body_message').val();

    // // Get selected student names and their corresponding father's names
    // let selectedNames = [];
    // let selectfatherName = [];

    // $('select[name="student_id"] option:selected').each(function() {
    //     let val = $(this).val();
	// 	// console.log(val);
    //     if (val !== 'all') {
    //         let text = $(this).text(); // e.g. "10 - John Doe"
    //         let name = text.split('-').slice(1).join('-').trim(); // Get "John Doe"
    //         selectedNames.push(name);
            
    //         // Assume the father's name is in the input field
    //         let fatherName = $('input[name="body"]').val(); // or a similar logic for individual students
    //         selectfatherName.push(fatherName); 
    //     }
    // });

    // Create name string
//     let names = selectedNames.join(', ');
//     let father = selectfatherName.join(', ');

//     // Replace `student_name` and `father_name` with actual names
//     let finalMessage = message.replace(/student_name/g, names);
//     let finaMessage = finalMessage.replace(/father_name/g, father);

//     // Set to hidden input
//     $('#final_body').val(finaMessage);

//     // Optional: remove original 'body' field so only `final_body` is submitted
//     $('#body_message').attr('name', ''); // prevent submitting old textarea
// });


</script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hostelmanager/public_html/test.hostelmanager.pk/resources/views/backend/Whatsapp/create.blade.php ENDPATH**/ ?>