
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-4">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<span class="panel-title" >
					<?php echo e(_lang('Add New Room')); ?>

				</span>
			</div>
			<div class="panel-body">
				<form action="<?php echo e(route('sections.store')); ?>" autocomplete="off" class="form-horizontal form-groups-bordered validate" enctype="multipart/form-data" method="post" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<div class="form-group">
					    <div class="col-sm-12">
						    <label class="control-label"><?php echo e(_lang('Name')); ?></label>						
							<input type="text" class="form-control" name="section_name" required value="<?php echo e(old('section_name')); ?>">
						</div>
					</div>
					
					<div class="form-group">
					   <div class="col-sm-12">
						    <label class="control-label">Floor</label>
							<select name="class_id" class="form-control select2" required>
								<option value="">Select One</option>
								<?php echo e(create_option('classes','id','class_name',old('class_id'))); ?>

							</select>
						</div>
					</div>
					
					<div class="form-group">
					    <div class="col-sm-12">
						    <label class="control-label"><?php echo e(_lang('Capacity')); ?></label>						
							<input type="number" class="form-control" min="1" name="capacity" value="<?php echo e(old('capacity')); ?>" required>
						</div>
					</div>

					
					<div class="form-group">
					    <div class="col-sm-12">
						    <label class="control-label"><?php echo e(_lang('Room No/Name')); ?></label>						
							<input type="text" class="form-control" name="room_no" value="<?php echo e(old('room_no')); ?>">
						</div>
					</div>

					<div class="form-group">
					    <div class="col-sm-12">
						    <label class="control-label"><?php echo e(_lang('Room Rent')); ?></label>						
							<input type="text" class="form-control" name="room_rent" value="<?php echo e(old('room_rent')); ?>">
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-sm-5">
							<button type="submit" class="btn btn-info"><?php echo e(_lang('Add Room')); ?></button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
	<div class="col-md-8">
	    <div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<span class="panel-title" >
					<?php echo e(_lang('Room List')); ?>

				</span>
				
				<select id="class" class="select_class pull-right" onchange="showClass(this);">
				   <option value=""><?php echo e(_lang('Select Floor')); ?></option>
				   <?php echo e(create_option('classes','id','class_name',$class)); ?>

				</select>
			</div>
			<div class="panel-body no-export">
				<table class="table table-bordered data-table">
					<thead>
						<th><?php echo e(_lang('Floor Name')); ?></th>
						<th><?php echo e(_lang('Room Name')); ?></th>
						<th><?php echo e(_lang('Capacity')); ?></th>
						<th><?php echo e(_lang('Rent')); ?></th>
						<th><?php echo e(_lang('Action')); ?></th>
					</thead>
					<tbody>
						<?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						 <tr>
							<td><?php echo e($data->class_name); ?></td>
							<td><?php echo e($data->section_name); ?></td>
							<td><?php echo e($data->capacity); ?></td>
							<td><?php echo e($data->room_rent); ?></td>
							<td>
								<form action="<?php echo e(route('sections.destroy',$data->id)); ?>" method="post">
								    <a href="<?php echo e(route('sections.edit',$data->id)); ?>" class="btn btn-warning btn-xs"><i class="fa fa-pencil" aria-hidden="true"></i></a>
									<?php echo e(method_field('DELETE')); ?>

    								<?php echo csrf_field(); ?>
    								<button type="submit" class="btn btn-danger btn-xs btn-remove"><i class="fa fa-eraser" aria-hidden="true"></i></button>
								</form>
							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
function showClass(elem){
	if($(elem).val() == ""){
		return;
	}
	window.location = "<?php echo url('sections/class') ?>/"+$(elem).val();
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hostelmanager/public_html/test.hostelmanager.pk/resources/views/backend/sections/section-add.blade.php ENDPATH**/ ?>