<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo e(@$title); ?></title>
    <?php echo $__env->make('backend.pdf.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body >
<?php echo $__env->make('backend.pdf.layouts.report-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<main>
    <table class="table" width="100%" cellspacing="0">
        <thead>
        <tr>
            <th style="text-align: left;" width="5%"><?php echo e(_lang('SL#')); ?></th>
            <th style="text-align: left;" width="10%"><?php echo e(_lang('Reg No#')); ?></th>
            <th style="text-align: left;" width="25%"><?php echo e(_lang('Student Information')); ?></th>
            <th style="text-align: left;" width="15%"><?php echo e(_lang('Floor')); ?></th>
            <th style="text-align: left;" width="15%"><?php echo e(_lang('Room')); ?></th>
            <th style="text-align: left;" width="20%"><?php echo e(_lang('Contact')); ?></th>
            <th class="text-center" width="10%"><?php echo e(_lang('Months')); ?></th>
            <th class="text-right" width="10%"><?php echo e(_lang('Total')); ?></th>
        </tr>
        </thead>
        <tbody>
            <?php $grandTotal=0; ?>
            <?php if(count($invoices)>0): ?>
            <?php $count=0 ?>
            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <th style="text-align: left;"><?php echo e(++$count); ?></th>
                <th style="text-align: left;"><?php echo e($invoice[0]->register_no); ?></th>
                <th style="text-align: left;"><?php echo e($invoice[0]->first_name); ?></th>
                <th style="text-align: left;"><?php echo e($invoice[0]->class_name); ?></th>
                <th style="text-align: left;"><?php echo e($invoice[0]->section_name); ?></th>
                <td style="text-align: left;">
                    <?php echo e($invoice[0]->phone); ?><br/>
                    <?php if($invoice[0]->home_phone): ?>
                    <?php echo e(_lang('Home Phone')); ?> : <?php echo e($invoice[0]->home_phone); ?>

                    <?php endif; ?>
                </td>
                <td><?php echo e(count($invoice)); ?></td>
                <td class="text-right">
                    <?php echo e(collect($invoice)->sum('total')-collect($invoice)->sum('paid')); ?>

                    <?php $grandTotal= $grandTotal + (collect($invoice)->sum('total')-collect($invoice)->sum('paid')); ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            <tr>
                <th colspan="7">Grand Total: </th>
                <th colspan=""><?php echo $grandTotal; ?> </th>
            </tr>
        </tbody>
    </table>
</main>
<?php echo $__env->make('backend.pdf.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/hostelmanager/public_html/test.hostelmanager.pk/resources/views/backend/pdf/reports/unpaid_details.blade.php ENDPATH**/ ?>