

<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading"><span class="panel-title"><?php echo e(_lang('List Department')); ?></span>
			<a class="btn btn-primary btn-sm pull-right" data-title="<?php echo e(_lang('Add Department')); ?>" href="<?php echo e(route('departments.create')); ?>"><?php echo e(_lang('Add New')); ?></a>
			</div>

			<div class="panel-body">
			 <?php if(\Session::has('success')): ?>
			  <div class="alert alert-success">
				<p><?php echo e(\Session::get('success')); ?></p>
			  </div>
			  <br />
			 <?php endif; ?>
			<table class="table table-bordered data-table">
			<thead>
			  <tr>
				<th>#</th>
				<th><?php echo e(_lang('Department Name')); ?></th>
				<th><?php echo e(_lang('Bank Name')); ?></th>
				<th><?php echo e(_lang('Bank Account')); ?></th>
				<th><?php echo e(_lang('Bank Logo')); ?></th>
				<th><?php echo e(_lang('Hostel Logo')); ?></th>
				<th><?php echo e(_lang('Action')); ?></th>
			  </tr>
			</thead>
			<tbody>
			  
			  <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			  <tr id="row_<?php echo e($department->id); ?>">
				<td class='id'><?php echo e(++$key); ?></td>
				<td class='group_name'><?php echo e($department->department_name); ?></td>
				<td class='group_name'><?php echo e($department->bank_name); ?></td>
				<td class='group_name'><?php echo e($department->bank_account); ?></td>
				<td class='group_name'><img src="<?php echo e(asset('uploads/'.$department->bank_logo)); ?>" width="120px" alt=""></td>
				<td class='group_name'><img src="<?php echo e(asset('uploads/'.$department->school_logo)); ?>" width="120px" alt=""></td>	
				<td>
				  <form action="<?php echo e(action('DepartmentController@destroy', $department['id'])); ?>" method="post">
					<a href="<?php echo e(action('DepartmentController@edit', $department['id'])); ?>" data-title="<?php echo e(_lang('Update Department')); ?>" class="btn btn-warning btn-sm"><?php echo e(_lang('Edit')); ?></a>
					<?php echo e(csrf_field()); ?>

					<input name="_method" type="hidden" value="DELETE">
					<button class="btn btn-danger btn-sm btn-remove" type="submit"><?php echo e(_lang('Delete')); ?></button>
				  </form>
				</td>
			  </tr>
			  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		  </table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hostelmanager/public_html/test.hostelmanager.pk/resources/views/backend/administration/department/list.blade.php ENDPATH**/ ?>