<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\StudentPayment;
use App\Invoice;
use App\Transaction;
use Auth;
use Validator;
use Illuminate\Validation\Rule;

class StudentPaymentController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($class="all")
    {
		$studentpayments = array();
		if($class !="all" ){
			$studentpayments = StudentPayment::join('invoices','invoices.id','=','student_payments.invoice_id')
									->select('invoices.*','student_payments.*','student_payments.id as id')						
									->where('invoices.session_id',get_option('academic_year'))
									->where('invoices.class_id',$class)
									->where('student_payments.school_id',schoolId())
									->orderBy('student_payments.id', 'DESC')
									->get();
        }else{
            $studentpayments = StudentPayment::join('invoices','invoices.id','=','student_payments.invoice_id')
                                    ->select('invoices.*','student_payments.*','student_payments.id as id')                     
                                    ->where('invoices.session_id',get_option('academic_year'))
                                    ->where('student_payments.school_id',schoolId())
                                    ->orderBy('student_payments.id', 'DESC')
                                    ->get();
        }								
        return view('backend.student_payment.list',compact('studentpayments','class'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, $invoice_id = "")
    {   
	    $invoice = Invoice::find($invoice_id);
        
        if ($invoice->school_id != schoolId()) {
            return redirect()->back()->with('error','access denied');
        }
	    $history = StudentPayment::where("invoice_id",$invoice_id)->get();
		if( ! $request->ajax()){
		   return view('backend.student_payment.create',compact('invoice_id','invoice','history'));
		}else{
           return view('backend.student_payment.modal.create',compact('invoice_id','invoice','history'));
		}
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
		
		$validator = Validator::make($request->all(), [
			'invoice_id' => 'required',
			'date' => 'required',
            'account_id' => 'required',
            'chart_id' => 'required',
			'amount' => 'required|numeric'
		]);
		
		if ($validator->fails()) {
			if($request->ajax()){ 
			    return response()->json(['result'=>'error','message'=>$validator->errors()->all()]);
			}else{
				return redirect('student_payments/create')
							->withErrors($validator)
							->withInput();
			}			
		}
		
        
        if (checkSchoolId('invoices',$request->invoice_id) != schoolId()) {
            return redirect()->back()->with('error','access denied');
        }

        if (checkSchoolId('bank_cash_accounts',$request->account_id) != schoolId() || checkSchoolId('chart_of_accounts',$request->chart_id) != schoolId()) {
            return redirect()->back()->with('error','access denied');
        }

        if ($request->payee_payer_id) {
            if (checkSchoolId('payee_payers',$request->payee_payer_id) != schoolId()) {
                return redirect()->back()->with('error','access denied');
            }
        }

        if ($request->payment_method_id) {
            if (checkSchoolId('payment_methods',$request->payment_method_id) != schoolId()) {
                return redirect()->back()->with('error','access denied');
            }
        }
        //Update Invoice
        $invoice = Invoice::find($request->input('invoice_id')); 

        if ($request->input('amount') > ($invoice->total -$invoice->paid)) {
            if(! $request->ajax()){
                return redirect('student_payments/create')->with('error', _lang('Invalid payable amount'));
            }else{
               return response()->json(['result'=>'error','message'=>_lang('Invalid payable amount')]);
            }
        }
		

        $studentpayment= new StudentPayment();
	    $studentpayment->school_id = schoolId();
	    $studentpayment->invoice_id = $request->input('invoice_id');
		$studentpayment->date = $request->input('date');
		$studentpayment->amount = $request->input('amount');
		$studentpayment->note = $request->input('note');
	
        $studentpayment->save();

        $transaction= new Transaction();
        $transaction->school_id = schoolId();
        $transaction->trans_date = $request->input('date');
        $transaction->account_id = $request->input('account_id');
        $transaction->trans_type = $request->input('trans_type');
        $transaction->trans_source_type = $request->input('trans_source_type');
        $transaction->amount = $request->input('amount');
        $transaction->dr_cr = $request->input('dr_cr');
        $transaction->chart_id = $request->input('chart_id');
        $transaction->payee_payer_id = $invoice->student_id;
        $transaction->invoice_id = $invoice->id;
        $transaction->payment_method_id = $request->input('payment_method_id');
        $transaction->create_user_id = Auth::user()->id;
        $transaction->note = $request->input('note');
    
        $transaction->save();
		
		
			
		if(($invoice->paid + $studentpayment->amount) >= $invoice->total){
			$invoice->status = "Paid";
		}
		$invoice->paid = $invoice->paid + $studentpayment->amount;
        $invoice->payment_date = now();
        $invoice->save();
		
		if(! $request->ajax()){
           return redirect('student_payments/create')->with('success', _lang('Information has been added sucessfully'));
        }else{
		   return response()->json(['result'=>'success','action'=>'store2','message'=>_lang('Information has been added sucessfully'),'data'=>$studentpayment]);
		}
        
   }
	

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id)
    {
        $studentpayment = StudentPayment::find($id);
        
        if ($studentpayment->school_id != schoolId()) {
            return redirect()->back()->with('error','access denied');
        }
		if(! $request->ajax()){
		    return view('backend.student_payment.view',compact('studentpayment','id'));
		}else{
			return view('backend.student_payment.modal.view',compact('studentpayment','id'));
		} 
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request,$id)
    {
        $studentpayment = StudentPayment::find($id);
        
        if ($studentpayment->school_id != schoolId()) {
            return redirect()->back()->with('error','access denied');
        }
	    $history = StudentPayment::where("invoice_id",$studentpayment->invoice_id)->get();
		if(! $request->ajax()){
		   return view('backend.student_payment.edit',compact('studentpayment','id','history'));
		}else{
           return view('backend.student_payment.modal.edit',compact('studentpayment','id','history'));
		}         
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
	
		$validator = Validator::make($request->all(), [
			'invoice_id' => 'required',
			'date' => 'required',
			'amount' => 'required|numeric'
		]);
		
		if ($validator->fails()) {
			if($request->ajax()){ 
			    return response()->json(['result'=>'error','message'=>$validator->errors()->all()]);
			}else{
				return redirect()->route('student_payments.edit', $id)
							->withErrors($validator)
							->withInput();
			}			
		}
	
        	
        $studentpayment = StudentPayment::find($id);
        
        if ($studentpayment->school_id != schoolId()) {
            return redirect()->back()->with('error','access denied');
        }
		$previous_amount = $studentpayment->amount;
		$studentpayment->invoice_id = $request->input('invoice_id');
		$studentpayment->date = $request->input('date');
		$studentpayment->amount = $request->input('amount');
		$studentpayment->note = $request->input('note');
	
        $studentpayment->save();
		
		//Update Invoice
		$invoice = Invoice::find($studentpayment->invoice_id);		
		if((($invoice->paid + $studentpayment->amount) - $previous_amount) >= $invoice->total){
			$invoice->status = "Paid";
		}else{
			$invoice->status = "Unpaid";
		}
		$invoice->paid = (($invoice->paid + $studentpayment->amount) - $previous_amount);
        $invoice->save();
		
		if(! $request->ajax()){
           return redirect('student_payments')->with('success', _lang('Information has been updated sucessfully'));
        }else{
		   return response()->json(['result'=>'success','action'=>'update', 'message'=>_lang('Information has been updated sucessfully'),'data'=>$studentpayment]);
		}
	    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $studentpayment = StudentPayment::find($id);
        $inv = Invoice::find($studentpayment->invoice_id);
        $inv->paid = $inv->paid - $studentpayment->amount;
        $inv->update();

        if ($studentpayment->school_id != schoolId()) {
            return redirect()->back()->with('error','access denied');
        }
        $studentpayment->delete();
        return redirect('student_payments')->with('success',_lang('Information has been deleted sucessfully'));
    }
}
