DROP TABLE IF EXISTS academic_years;

CREATE TABLE `academic_years` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `session` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `school_id` int(11) NOT NULL,
  `year` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO academic_years VALUES('1','2023-2024','1','2023-2024','2021-09-30 13:51:00','2023-08-03 12:44:30');



DROP TABLE IF EXISTS assign_subjects;

CREATE TABLE `assign_subjects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject_id` int(11) NOT NULL,
  `teacher_id` int(11) DEFAULT NULL,
  `section_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS assignments;

CREATE TABLE `assignments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deadline` date NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS bank_cash_accounts;

CREATE TABLE `bank_cash_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `account_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opening_balance` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `create_user_id` int(11) NOT NULL,
  `update_user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO bank_cash_accounts VALUES('1','1','cash in hand','0.00','','319','','2021-10-05 12:38:14','2021-10-05 12:38:14');
INSERT INTO bank_cash_accounts VALUES('2','1','sir amir','0.00','','319','','2021-10-05 12:44:06','2021-10-05 12:44:06');



DROP TABLE IF EXISTS book_categories;

CREATE TABLE `book_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `category_name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS book_issues;

CREATE TABLE `book_issues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `library_id` int(11) NOT NULL,
  `book_id` int(11) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `return_date` date DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS books;

CREATE TABLE `books` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` int(11) NOT NULL,
  `author` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publisher` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rack_no` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publish_date` date NOT NULL,
  `photo` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'book.png',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS chart_of_accounts;

CREATE TABLE `chart_of_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO chart_of_accounts VALUES('1','1','Salary and Wages','expense','2021-10-05 12:42:19','2023-04-09 17:35:46');
INSERT INTO chart_of_accounts VALUES('2','1','Security Fee','income','2021-10-05 13:28:12','2021-10-05 13:28:22');
INSERT INTO chart_of_accounts VALUES('3','1','Monthly Fee','income','2021-10-05 13:28:45','2021-10-05 13:28:45');
INSERT INTO chart_of_accounts VALUES('4','1','Miscellaneous','expense','2023-04-09 17:36:58','2023-04-09 17:36:58');
INSERT INTO chart_of_accounts VALUES('5','1','Kitchen Exp','expense','2023-04-09 17:37:23','2023-04-09 17:37:23');
INSERT INTO chart_of_accounts VALUES('6','1','Maintinance','expense','2023-04-09 17:37:49','2023-04-09 17:37:49');
INSERT INTO chart_of_accounts VALUES('7','1','Building Rent','expense','2023-04-09 17:38:18','2023-04-09 17:38:18');
INSERT INTO chart_of_accounts VALUES('8','1','Amir Sb Receiving','expense','2023-04-09 17:38:50','2023-04-09 17:38:50');
INSERT INTO chart_of_accounts VALUES('9','1','Utility Bill','expense','2023-04-09 17:39:28','2023-04-09 17:39:28');
INSERT INTO chart_of_accounts VALUES('10','1','New Purchase','expense','2023-04-09 17:40:33','2023-04-09 17:40:33');



DROP TABLE IF EXISTS class_days;

CREATE TABLE `class_days` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `day` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS class_routines;

CREATE TABLE `class_routines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `day` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS classes;

CREATE TABLE `classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `class_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO classes VALUES('1','1','BASEMENT','1','2021-10-04 23:18:26','2021-12-04 17:39:28');
INSERT INTO classes VALUES('2','1','FIRST FLOOR','1','2021-12-04 17:39:45','2021-12-04 17:39:45');
INSERT INTO classes VALUES('3','1','GROUND FLOOR','1','2022-04-17 05:40:30','2022-04-17 05:40:30');



DROP TABLE IF EXISTS custom_fields;

CREATE TABLE `custom_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `field_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_data` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS departments;

CREATE TABLE `departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `school_logo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_logo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO departments VALUES('1','1','Jobian','1940201715_1638711062.jpg','ABL','1212121212','174509112_1638711062.jpg','','2021-12-05 18:31:02');
INSERT INTO departments VALUES('2','1','Student','1253443839_1638711006.jpg','Nil','1234567890','212349707_1638711006.jpg','','2021-12-05 18:30:06');
INSERT INTO departments VALUES('8','1','Professional\'s','1939665915_1638710980.jpg','ABL','1234567890','1021924189_1638710980.jpg','2021-10-03 12:41:14','2021-12-05 18:29:40');



DROP TABLE IF EXISTS email_logs;

CREATE TABLE `email_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `receiver_email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS events;

CREATE TABLE `events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS exam_attendances;

CREATE TABLE `exam_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `attendance` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS exam_schedules;

CREATE TABLE `exam_schedules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `room` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS exams;

CREATE TABLE `exams` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `session_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS fee_types;

CREATE TABLE `fee_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `fee_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO fee_types VALUES('1','1','Monthly Rent','01','','2021-10-05 10:37:37','2021-12-05 11:30:37');
INSERT INTO fee_types VALUES('2','1','Security Fee','02','','2021-10-05 10:37:53','2021-10-05 10:37:53');
INSERT INTO fee_types VALUES('3','1','Admission Fee','03','','2022-08-13 07:00:05','2022-08-13 07:16:10');
INSERT INTO fee_types VALUES('4','1','Ac Charges','04','','2022-08-13 07:16:36','2022-08-13 07:16:36');



DROP TABLE IF EXISTS grades;

CREATE TABLE `grades` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `grade_name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `marks_from` decimal(8,2) NOT NULL,
  `marks_to` decimal(8,2) NOT NULL,
  `point` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS hostel_categories;

CREATE TABLE `hostel_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `hostel_id` int(11) NOT NULL,
  `standard` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hostel_fee` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS hostel_members;

CREATE TABLE `hostel_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `hostel_id` int(11) NOT NULL,
  `hostel_category_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS hostels;

CREATE TABLE `hostels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL DEFAULT 0,
  `hostel_name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS invoice_items;

CREATE TABLE `invoice_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `fee_id` int(11) NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `discount` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1674 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO invoice_items VALUES('1','1','1','2','20000.00','0.00','2021-10-05 13:18:20','2021-10-05 13:18:20');
INSERT INTO invoice_items VALUES('92','1','31','1','17000.00','0.00','2021-12-05 18:03:31','2021-12-05 18:03:31');
INSERT INTO invoice_items VALUES('4','1','3','1','17000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('49','1','4','2','17500.00','0.00','2021-12-05 14:07:03','2021-12-05 14:07:03');
INSERT INTO invoice_items VALUES('6','1','5','1','22000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('32','1','6','1','11000.00','0.00','2021-12-05 13:50:13','2021-12-05 13:50:13');
INSERT INTO invoice_items VALUES('59','1','32','1','17500.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('9','1','8','1','50000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('50','1','9','1','6166.00','0.00','2021-12-05 14:09:37','2021-12-05 14:09:37');
INSERT INTO invoice_items VALUES('31','1','10','1','18500.00','0.00','2021-12-05 13:29:12','2021-12-05 13:29:12');
INSERT INTO invoice_items VALUES('12','1','11','1','18000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('13','1','12','1','18000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('56','1','13','1','10000.00','0.00','2021-12-05 16:25:36','2021-12-05 16:25:36');
INSERT INTO invoice_items VALUES('15','1','14','1','17000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('16','1','15','1','18500.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('34','1','16','1','19000.00','0.00','2021-12-05 13:54:58','2021-12-05 13:54:58');
INSERT INTO invoice_items VALUES('44','1','17','1','8500.00','0.00','2021-12-05 14:01:24','2021-12-05 14:01:24');
INSERT INTO invoice_items VALUES('42','1','18','1','8500.00','0.00','2021-12-05 14:00:49','2021-12-05 14:00:49');
INSERT INTO invoice_items VALUES('39','1','19','2','10000.00','0.00','2021-12-05 13:59:12','2021-12-05 13:59:12');
INSERT INTO invoice_items VALUES('40','1','20','1','8500.00','0.00','2021-12-05 14:00:08','2021-12-05 14:00:08');
INSERT INTO invoice_items VALUES('22','1','21','1','18000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('33','1','22','2','10000.00','0.00','2021-12-05 13:53:31','2021-12-05 13:53:31');
INSERT INTO invoice_items VALUES('54','1','23','1','9250.00','0.00','2021-12-05 14:31:56','2021-12-05 14:31:56');
INSERT INTO invoice_items VALUES('25','1','24','1','17000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('26','1','25','1','17000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('27','1','26','1','18000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('52','1','27','1','17000.00','0.00','2021-12-05 14:24:19','2021-12-05 14:24:19');
INSERT INTO invoice_items VALUES('29','1','28','1','18000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('30','1','29','1','17000.00','0.00','2021-12-05 13:18:23','2021-12-05 13:18:23');
INSERT INTO invoice_items VALUES('35','1','16','2','19000.00','0.00','2021-12-05 13:54:58','2021-12-05 13:54:58');
INSERT INTO invoice_items VALUES('38','1','19','1','8500.00','0.00','2021-12-05 13:59:12','2021-12-05 13:59:12');
INSERT INTO invoice_items VALUES('41','1','20','2','10000.00','0.00','2021-12-05 14:00:08','2021-12-05 14:00:08');
INSERT INTO invoice_items VALUES('43','1','18','2','10000.00','0.00','2021-12-05 14:00:49','2021-12-05 14:00:49');
INSERT INTO invoice_items VALUES('45','1','17','2','10000.00','0.00','2021-12-05 14:01:24','2021-12-05 14:01:24');
INSERT INTO invoice_items VALUES('48','1','4','1','5830.00','0.00','2021-12-05 14:07:03','2021-12-05 14:07:03');
INSERT INTO invoice_items VALUES('51','1','9','2','18500.00','0.00','2021-12-05 14:09:37','2021-12-05 14:09:37');
INSERT INTO invoice_items VALUES('53','1','27','2','17000.00','0.00','2021-12-05 14:24:19','2021-12-05 14:24:19');
INSERT INTO invoice_items VALUES('55','1','23','2','18500.00','0.00','2021-12-05 14:31:56','2021-12-05 14:31:56');
INSERT INTO invoice_items VALUES('57','1','30','1','18000.00','0.00','2021-12-05 16:50:11','2021-12-05 16:50:11');
INSERT INTO invoice_items VALUES('60','1','33','1','22000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('106','1','34','1','17500.00','0.00','2021-12-05 19:11:11','2021-12-05 19:11:11');
INSERT INTO invoice_items VALUES('62','1','35','1','50000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('63','1','36','1','18500.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('64','1','37','1','18500.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('65','1','38','1','18000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('66','1','39','1','18000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('67','1','40','1','17000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('141','1','69','1','17000.00','0.00','2021-12-17 20:46:53','2021-12-17 20:46:53');
INSERT INTO invoice_items VALUES('69','1','42','1','18500.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('70','1','43','1','19000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('71','1','44','1','15000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('72','1','45','1','15000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('73','1','46','1','15000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('74','1','47','1','15000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('75','1','48','1','18000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('136','1','49','1','18500.00','0.00','2021-12-08 17:40:14','2021-12-08 17:40:14');
INSERT INTO invoice_items VALUES('77','1','50','1','18500.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('98','1','51','1','17000.00','0.00','2021-12-05 18:18:07','2021-12-05 18:18:07');
INSERT INTO invoice_items VALUES('96','1','52','1','17000.00','0.00','2021-12-05 18:17:06','2021-12-05 18:17:06');
INSERT INTO invoice_items VALUES('116','1','53','2','17000.00','0.00','2021-12-07 11:17:50','2021-12-07 11:17:50');
INSERT INTO invoice_items VALUES('81','1','54','1','17000.00','0.00','2021-12-05 17:56:02','2021-12-05 17:56:02');
INSERT INTO invoice_items VALUES('114','1','55','1','17000.00','0.00','2021-12-07 11:09:34','2021-12-07 11:09:34');
INSERT INTO invoice_items VALUES('104','1','56','1','17000.00','0.00','2021-12-05 18:22:49','2021-12-05 18:22:49');
INSERT INTO invoice_items VALUES('88','1','57','1','19000.00','0.00','2021-12-05 17:59:26','2021-12-05 17:59:26');
INSERT INTO invoice_items VALUES('107','1','58','1','17000.00','0.00','2021-12-07 10:56:51','2021-12-07 10:56:51');
INSERT INTO invoice_items VALUES('125','1','59','1','17000.00','0.00','2021-12-07 20:23:13','2021-12-07 20:23:13');
INSERT INTO invoice_items VALUES('127','1','60','2','17000.00','0.00','2021-12-07 20:23:41','2021-12-07 20:23:41');
INSERT INTO invoice_items VALUES('89','1','57','2','19000.00','0.00','2021-12-05 17:59:26','2021-12-05 17:59:26');
INSERT INTO invoice_items VALUES('140','1','68','1','15000.00','0.00','2021-12-17 20:46:06','2021-12-17 20:46:06');
INSERT INTO invoice_items VALUES('93','1','31','2','17000.00','0.00','2021-12-05 18:03:31','2021-12-05 18:03:31');
INSERT INTO invoice_items VALUES('115','1','53','1','17000.00','0.00','2021-12-07 11:17:50','2021-12-07 11:17:50');
INSERT INTO invoice_items VALUES('97','1','52','2','17000.00','0.00','2021-12-05 18:17:06','2021-12-05 18:17:06');
INSERT INTO invoice_items VALUES('99','1','51','2','17000.00','0.00','2021-12-05 18:18:07','2021-12-05 18:18:07');
INSERT INTO invoice_items VALUES('113','1','55','2','17000.00','0.00','2021-12-07 11:09:34','2021-12-07 11:09:34');
INSERT INTO invoice_items VALUES('105','1','56','2','17000.00','0.00','2021-12-05 18:22:49','2021-12-05 18:22:49');
INSERT INTO invoice_items VALUES('108','1','58','2','8000.00','0.00','2021-12-07 10:56:51','2021-12-07 10:56:51');
INSERT INTO invoice_items VALUES('126','1','60','1','17000.00','0.00','2021-12-07 20:23:41','2021-12-07 20:23:41');
INSERT INTO invoice_items VALUES('124','1','59','2','17000.00','0.00','2021-12-07 20:23:13','2021-12-07 20:23:13');
INSERT INTO invoice_items VALUES('117','1','61','1','17500.00','1500.00','2021-12-07 11:44:25','2021-12-07 11:44:25');
INSERT INTO invoice_items VALUES('118','1','61','2','17500.00','7500.00','2021-12-07 11:44:25','2021-12-07 11:44:25');
INSERT INTO invoice_items VALUES('119','1','62','1','17500.00','0.00','2021-12-07 12:15:02','2021-12-07 12:15:02');
INSERT INTO invoice_items VALUES('129','1','63','2','12500.00','0.00','2021-12-07 21:03:26','2021-12-07 21:03:26');
INSERT INTO invoice_items VALUES('128','1','63','1','17500.00','0.00','2021-12-07 21:03:26','2021-12-07 21:03:26');
INSERT INTO invoice_items VALUES('146','1','66','1','22000.00','0.00','2021-12-17 22:20:43','2021-12-17 22:20:43');
INSERT INTO invoice_items VALUES('144','1','64','1','15000.00','0.00','2021-12-17 21:59:46','2021-12-17 21:59:46');
INSERT INTO invoice_items VALUES('147','1','65','2','7500.00','0.00','2021-12-17 22:21:31','2021-12-17 22:21:31');
INSERT INTO invoice_items VALUES('145','1','66','2','7500.00','0.00','2021-12-17 22:20:43','2021-12-17 22:20:43');
INSERT INTO invoice_items VALUES('142','1','67','2','15000.00','0.00','2021-12-17 21:50:18','2021-12-17 21:50:18');
INSERT INTO invoice_items VALUES('143','1','67','1','12000.00','0.00','2021-12-17 21:50:18','2021-12-17 21:50:18');
INSERT INTO invoice_items VALUES('148','1','65','1','22000.00','0.00','2021-12-17 22:21:31','2021-12-17 22:21:31');
INSERT INTO invoice_items VALUES('203','1','116','1','18500.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('198','1','111','1','17500.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('199','1','112','1','22000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('197','1','110','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('248','1','113','1','17500.00','0.00','2022-01-03 12:55:43','2022-01-03 12:55:43');
INSERT INTO invoice_items VALUES('246','1','115','1','18500.00','0.00','2022-01-03 12:52:06','2022-01-03 12:52:06');
INSERT INTO invoice_items VALUES('206','1','119','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('204','1','117','1','18000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('247','1','120','1','18500.00','0.00','2022-01-03 12:54:23','2022-01-03 12:54:23');
INSERT INTO invoice_items VALUES('208','1','121','1','19000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('205','1','118','1','18000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('210','1','123','1','15000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('211','1','124','1','15000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('1379','1','1141','1','24500.00','0.00','2023-04-12 18:26:08','2023-04-12 18:26:08');
INSERT INTO invoice_items VALUES('213','1','126','1','18000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('252','1','127','1','18500.00','0.00','2022-01-06 12:06:06','2022-01-06 12:06:06');
INSERT INTO invoice_items VALUES('250','1','128','1','18500.00','0.00','2022-01-03 12:58:34','2022-01-03 12:58:34');
INSERT INTO invoice_items VALUES('216','1','129','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('212','1','125','1','15000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('220','1','133','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('217','1','130','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('218','1','131','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('209','1','122','1','15000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('219','1','132','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('223','1','136','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('222','1','135','1','19000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('221','1','134','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('225','1','138','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('224','1','137','1','17000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('457','1','307','1','6000.00','0.00','2022-04-18 08:10:25','2022-04-18 08:10:25');
INSERT INTO invoice_items VALUES('228','1','141','1','15000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('226','1','139','1','17500.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('229','1','142','1','22000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('230','1','143','1','22000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('251','1','144','1','17000.00','0.00','2022-01-06 10:39:17','2022-01-06 10:39:17');
INSERT INTO invoice_items VALUES('232','1','145','1','18000.00','0.00','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoice_items VALUES('238','1','151','1','18500.00','0.00','2022-01-02 21:33:40','2022-01-02 21:33:40');
INSERT INTO invoice_items VALUES('189','1','107','1','17000.00','0.00','2022-01-02 16:57:49','2022-01-02 16:57:49');
INSERT INTO invoice_items VALUES('242','1','149','1','17500.00','0.00','2022-01-03 12:43:17','2022-01-03 12:43:17');
INSERT INTO invoice_items VALUES('239','1','151','2','6000.00','0.00','2022-01-02 21:33:40','2022-01-02 21:33:40');
INSERT INTO invoice_items VALUES('190','1','107','2','17000.00','0.00','2022-01-02 16:57:49','2022-01-02 16:57:49');
INSERT INTO invoice_items VALUES('253','1','154','1','17500.00','0.00','2022-01-10 11:30:27','2022-01-10 11:30:27');
INSERT INTO invoice_items VALUES('249','1','150','1','17500.00','0.00','2022-01-03 12:56:48','2022-01-03 12:56:48');
INSERT INTO invoice_items VALUES('244','1','146','1','17500.00','0.00','2022-01-03 12:46:50','2022-01-03 12:46:50');
INSERT INTO invoice_items VALUES('240','1','152','1','18500.00','0.00','2022-01-02 21:37:07','2022-01-02 21:37:07');
INSERT INTO invoice_items VALUES('243','1','149','2','10500.00','0.00','2022-01-03 12:43:17','2022-01-03 12:43:17');
INSERT INTO invoice_items VALUES('254','1','154','2','17500.00','0.00','2022-01-10 11:30:27','2022-01-10 11:30:27');
INSERT INTO invoice_items VALUES('255','1','156','1','5000.00','0.00','2022-01-23 19:14:00','2022-01-23 19:14:00');
INSERT INTO invoice_items VALUES('256','1','156','2','15000.00','0.00','2022-01-23 19:14:00','2022-01-23 19:14:00');
INSERT INTO invoice_items VALUES('257','1','157','1','4800.00','0.00','2022-01-27 20:28:57','2022-01-27 20:28:57');
INSERT INTO invoice_items VALUES('258','1','157','2','15000.00','0.00','2022-01-27 20:28:57','2022-01-27 20:28:57');
INSERT INTO invoice_items VALUES('259','1','158','1','4800.00','0.00','2022-01-28 20:54:51','2022-01-28 20:54:51');
INSERT INTO invoice_items VALUES('260','1','158','2','15000.00','0.00','2022-01-28 20:54:51','2022-01-28 20:54:51');
INSERT INTO invoice_items VALUES('261','1','159','1','4500.00','0.00','2022-01-31 20:27:27','2022-01-31 20:27:27');
INSERT INTO invoice_items VALUES('262','1','159','2','10000.00','0.00','2022-01-31 20:27:27','2022-01-31 20:27:27');
INSERT INTO invoice_items VALUES('263','1','160','1','17000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('322','1','161','1','22500.00','0.00','2022-02-20 12:40:10','2022-02-20 12:40:10');
INSERT INTO invoice_items VALUES('265','1','162','1','17500.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('266','1','163','1','50000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('267','1','164','1','18500.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('268','1','165','1','18500.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('269','1','166','1','18000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('388','1','251','2','17500.00','0.00','2022-03-05 17:05:55','2022-03-05 17:05:55');
INSERT INTO invoice_items VALUES('271','1','168','1','18500.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('272','1','169','1','19000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('273','1','170','1','15000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('274','1','171','1','15000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('275','1','172','1','15000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('276','1','173','1','15000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('277','1','174','1','18500.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('278','1','175','1','17000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('279','1','176','1','17000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('280','1','177','1','17000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('281','1','178','1','17000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('282','1','179','1','17000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('283','1','180','1','17000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('284','1','181','1','17500.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('320','1','182','1','17000.00','0.00','2022-02-20 12:29:26','2022-02-20 12:29:26');
INSERT INTO invoice_items VALUES('340','1','183','1','17000.00','0.00','2022-02-26 17:00:58','2022-02-26 17:00:58');
INSERT INTO invoice_items VALUES('387','1','251','1','17500.00','0.00','2022-03-05 17:05:55','2022-03-05 17:05:55');
INSERT INTO invoice_items VALUES('288','1','185','1','15000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('289','1','186','1','22000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('290','1','187','1','22000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('291','1','188','1','17000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('305','1','189','1','19000.00','0.00','2022-02-03 16:59:34','2022-02-03 16:59:34');
INSERT INTO invoice_items VALUES('312','1','190','1','19000.00','0.00','2022-02-17 12:16:58','2022-02-17 12:16:58');
INSERT INTO invoice_items VALUES('294','1','191','1','17500.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('295','1','192','1','17500.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('316','1','193','1','17500.00','0.00','2022-02-20 11:18:01','2022-02-20 11:18:01');
INSERT INTO invoice_items VALUES('767','1','560','3','2000.00','0.00','2022-08-13 07:28:29','2022-08-13 07:28:29');
INSERT INTO invoice_items VALUES('315','1','195','1','17000.00','0.00','2022-02-17 17:50:04','2022-02-17 17:50:04');
INSERT INTO invoice_items VALUES('299','1','196','1','18000.00','0.00','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoice_items VALUES('460','1','309','1','25000.00','0.00','2022-04-28 08:39:48','2022-04-28 08:39:48');
INSERT INTO invoice_items VALUES('302','1','198','1','17500.00','0.00','2022-02-02 17:07:48','2022-02-02 17:07:48');
INSERT INTO invoice_items VALUES('303','1','198','2','15000.00','0.00','2022-02-02 17:07:48','2022-02-02 17:07:48');
INSERT INTO invoice_items VALUES('306','1','199','1','17500.00','0.00','2022-02-03 17:52:11','2022-02-03 17:52:11');
INSERT INTO invoice_items VALUES('307','1','199','2','17500.00','0.00','2022-02-03 17:52:11','2022-02-03 17:52:11');
INSERT INTO invoice_items VALUES('336','1','167','1','18000.00','0.00','2022-02-23 18:17:36','2022-02-23 18:17:36');
INSERT INTO invoice_items VALUES('317','1','193','2','3500.00','0.00','2022-02-20 11:18:01','2022-02-20 11:18:01');
INSERT INTO invoice_items VALUES('321','1','182','2','8000.00','0.00','2022-02-20 12:29:26','2022-02-20 12:29:26');
INSERT INTO invoice_items VALUES('326','1','201','2','10000.00','0.00','2022-02-20 13:18:02','2022-02-20 13:18:02');
INSERT INTO invoice_items VALUES('325','1','201','1','12000.00','0.00','2022-02-20 13:18:02','2022-02-20 13:18:02');
INSERT INTO invoice_items VALUES('327','1','202','1','11670.00','0.00','2022-02-20 13:42:52','2022-02-20 13:42:52');
INSERT INTO invoice_items VALUES('328','1','202','2','17500.00','0.00','2022-02-20 13:42:52','2022-02-20 13:42:52');
INSERT INTO invoice_items VALUES('329','1','203','1','18500.00','0.00','2022-02-20 19:37:41','2022-02-20 19:37:41');
INSERT INTO invoice_items VALUES('330','1','203','2','10000.00','0.00','2022-02-20 19:37:41','2022-02-20 19:37:41');
INSERT INTO invoice_items VALUES('332','1','204','1','11700.00','0.00','2022-02-20 20:20:01','2022-02-20 20:20:01');
INSERT INTO invoice_items VALUES('333','1','204','2','17500.00','0.00','2022-02-20 20:20:01','2022-02-20 20:20:01');
INSERT INTO invoice_items VALUES('334','1','205','1','18000.00','0.00','2022-02-20 20:24:13','2022-02-20 20:24:13');
INSERT INTO invoice_items VALUES('335','1','206','1','5500.00','0.00','2022-02-22 14:03:07','2022-02-22 14:03:07');
INSERT INTO invoice_items VALUES('339','1','208','2','8000.00','0.00','2022-02-26 16:42:41','2022-02-26 16:42:41');
INSERT INTO invoice_items VALUES('398','1','209','1','22500.00','0.00','2022-04-01 09:03:32','2022-04-01 09:03:32');
INSERT INTO invoice_items VALUES('342','1','210','1','17500.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('343','1','211','1','18500.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('344','1','212','1','18500.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('345','1','213','1','18000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('346','1','214','1','18000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('347','1','215','1','18500.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('458','1','308','1','10000.00','0.00','2022-04-23 14:58:46','2022-04-23 14:58:46');
INSERT INTO invoice_items VALUES('349','1','217','1','15000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('350','1','218','1','15000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('351','1','219','1','15000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('352','1','220','1','15000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('353','1','221','1','18500.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('354','1','222','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('355','1','223','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('356','1','224','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('357','1','225','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('358','1','226','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('359','1','227','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('391','1','228','1','17000.00','0.00','2022-03-12 13:19:42','2022-03-12 13:19:42');
INSERT INTO invoice_items VALUES('361','1','229','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('362','1','230','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('363','1','231','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('364','1','232','1','15000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('365','1','233','1','22000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('366','1','234','1','22000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('367','1','235','1','17000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('368','1','236','1','17500.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('369','1','237','1','19000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('370','1','238','1','17500.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('371','1','239','1','17500.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('382','1','240','1','19000.00','0.00','2022-03-03 12:02:57','2022-03-03 12:02:57');
INSERT INTO invoice_items VALUES('386','1','241','1','17000.00','0.00','2022-03-05 15:01:32','2022-03-05 15:01:32');
INSERT INTO invoice_items VALUES('374','1','242','1','18000.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('375','1','243','1','17500.00','0.00','2022-03-03 11:38:36','2022-03-03 11:38:36');
INSERT INTO invoice_items VALUES('459','1','308','2','15000.00','0.00','2022-04-23 14:58:46','2022-04-23 14:58:46');
INSERT INTO invoice_items VALUES('392','1','245','1','19000.00','0.00','2022-03-12 13:23:19','2022-03-12 13:23:19');
INSERT INTO invoice_items VALUES('390','1','246','1','14000.00','0.00','2022-03-12 13:15:20','2022-03-12 13:15:20');
INSERT INTO invoice_items VALUES('379','1','247','1','17500.00','0.00','2022-03-03 11:50:03','2022-03-03 11:50:03');
INSERT INTO invoice_items VALUES('380','1','248','1','17500.00','0.00','2022-03-03 11:50:49','2022-03-03 11:50:49');
INSERT INTO invoice_items VALUES('381','1','249','1','18000.00','0.00','2022-03-03 11:52:48','2022-03-03 11:52:48');
INSERT INTO invoice_items VALUES('383','1','250','1','17500.00','0.00','2022-03-03 12:16:38','2022-03-03 12:16:38');
INSERT INTO invoice_items VALUES('384','1','250','2','10000.00','0.00','2022-03-03 12:16:38','2022-03-03 12:16:38');
INSERT INTO invoice_items VALUES('393','1','257','1','10400.00','0.00','2022-03-15 07:07:09','2022-03-15 07:07:09');
INSERT INTO invoice_items VALUES('394','1','257','2','18500.00','0.00','2022-03-15 07:07:09','2022-03-15 07:07:09');
INSERT INTO invoice_items VALUES('395','1','258','1','12300.00','0.00','2022-03-15 07:39:48','2022-03-15 07:39:48');
INSERT INTO invoice_items VALUES('396','1','258','2','18500.00','0.00','2022-03-15 07:39:48','2022-03-15 07:39:48');
INSERT INTO invoice_items VALUES('399','1','259','1','22500.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('400','1','260','1','17500.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('401','1','261','1','18500.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('402','1','262','1','18500.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('454','1','263','1','18500.00','0.00','2022-04-08 10:43:35','2022-04-08 10:43:35');
INSERT INTO invoice_items VALUES('404','1','264','1','15000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('405','1','265','1','15000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('406','1','266','1','15000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('407','1','267','1','15000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('408','1','268','1','18500.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('409','1','269','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('410','1','270','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('411','1','271','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('412','1','272','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('413','1','273','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('414','1','274','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('415','1','275','1','17500.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('416','1','276','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('417','1','277','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('418','1','278','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('419','1','279','1','15000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('420','1','280','1','22000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('421','1','281','1','22000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('422','1','282','1','17000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('423','1','283','1','17500.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('424','1','284','1','19000.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('425','1','285','1','17500.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('426','1','286','1','17500.00','0.00','2022-04-04 07:23:17','2022-04-04 07:23:17');
INSERT INTO invoice_items VALUES('1607','1','1344','1','24500.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('456','1','288','1','17000.00','0.00','2022-04-08 11:04:19','2022-04-08 11:04:19');
INSERT INTO invoice_items VALUES('429','1','289','1','18000.00','0.00','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoice_items VALUES('430','1','290','1','18000.00','0.00','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoice_items VALUES('431','1','291','1','17500.00','0.00','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoice_items VALUES('432','1','292','1','17500.00','0.00','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoice_items VALUES('433','1','293','1','17500.00','0.00','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoice_items VALUES('450','1','294','1','16500.00','0.00','2022-04-08 09:26:45','2022-04-08 09:26:45');
INSERT INTO invoice_items VALUES('451','1','295','1','16500.00','0.00','2022-04-08 09:28:16','2022-04-08 09:28:16');
INSERT INTO invoice_items VALUES('436','1','296','1','17500.00','0.00','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoice_items VALUES('461','1','309','2','20000.00','0.00','2022-04-28 08:39:48','2022-04-28 08:39:48');
INSERT INTO invoice_items VALUES('603','1','298','1','18000.00','0.00','2022-06-11 13:13:10','2022-06-11 13:13:10');
INSERT INTO invoice_items VALUES('439','1','299','1','16000.00','0.00','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoice_items VALUES('440','1','300','1','18500.00','0.00','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoice_items VALUES('441','1','301','1','18500.00','0.00','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoice_items VALUES('452','1','305','1','18500.00','0.00','2022-04-08 09:33:51','2022-04-08 09:33:51');
INSERT INTO invoice_items VALUES('449','1','302','1','20000.00','0.00','2022-04-06 13:58:30','2022-04-06 13:58:30');
INSERT INTO invoice_items VALUES('445','1','303','1','17000.00','0.00','2022-04-05 14:53:13','2022-04-05 14:53:13');
INSERT INTO invoice_items VALUES('448','1','304','1','20000.00','0.00','2022-04-06 13:57:54','2022-04-06 13:57:54');
INSERT INTO invoice_items VALUES('462','1','310','1','22500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('463','1','311','1','17500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('464','1','312','1','18500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('465','1','313','1','18500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('466','1','314','1','15000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('467','1','315','1','15000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('468','1','316','1','15000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('469','1','317','1','15000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('470','1','318','1','18500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('471','1','319','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('472','1','320','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('473','1','321','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('474','1','322','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('475','1','323','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('476','1','324','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('477','1','325','1','17500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('478','1','326','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('479','1','327','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('480','1','328','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('481','1','329','1','15000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('482','1','330','1','22000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('483','1','331','1','22000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('484','1','332','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('485','1','333','1','17500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('1381','1','1143','1','21000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('487','1','335','1','17500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('488','1','336','1','17500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('489','1','337','1','19000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('490','1','338','1','17500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('491','1','339','1','18000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('492','1','340','1','18000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('493','1','341','1','17500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('494','1','342','1','17500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('495','1','343','1','17500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('496','1','344','1','16500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('497','1','345','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('498','1','346','1','17000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('499','1','347','1','16000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('500','1','348','1','18500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('501','1','349','1','18500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('502','1','350','1','20000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('503','1','351','1','20000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('504','1','352','1','18500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('505','1','353','1','18500.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('506','1','354','1','20000.00','0.00','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoice_items VALUES('1367','1','355','1','4000.00','0.00','2023-04-07 12:11:44','2023-04-07 12:11:44');
INSERT INTO invoice_items VALUES('1605','1','287','1','19000.00','0.00','2023-07-30 12:39:18','2023-07-30 12:39:18');
INSERT INTO invoice_items VALUES('513','1','357','2','17500.00','0.00','2022-05-10 15:32:28','2022-05-10 15:32:28');
INSERT INTO invoice_items VALUES('512','1','357','1','11500.00','0.00','2022-05-10 15:32:28','2022-05-10 15:32:28');
INSERT INTO invoice_items VALUES('514','1','358','1','11500.00','0.00','2022-05-11 07:12:11','2022-05-11 07:12:11');
INSERT INTO invoice_items VALUES('515','1','358','2','17500.00','0.00','2022-05-11 07:12:11','2022-05-11 07:12:11');
INSERT INTO invoice_items VALUES('517','1','359','1','11500.00','0.00','2022-05-11 07:37:17','2022-05-11 07:37:17');
INSERT INTO invoice_items VALUES('518','1','359','2','17500.00','0.00','2022-05-11 07:37:17','2022-05-11 07:37:17');
INSERT INTO invoice_items VALUES('519','1','360','1','11500.00','0.00','2022-05-11 12:12:46','2022-05-11 12:12:46');
INSERT INTO invoice_items VALUES('520','1','360','2','17500.00','0.00','2022-05-11 12:12:46','2022-05-11 12:12:46');
INSERT INTO invoice_items VALUES('521','1','361','1','11500.00','0.00','2022-05-11 12:36:50','2022-05-11 12:36:50');
INSERT INTO invoice_items VALUES('522','1','361','2','17500.00','0.00','2022-05-11 12:36:50','2022-05-11 12:36:50');
INSERT INTO invoice_items VALUES('523','1','362','1','10000.00','0.00','2022-05-22 12:59:12','2022-05-22 12:59:12');
INSERT INTO invoice_items VALUES('524','1','362','2','20000.00','0.00','2022-05-22 12:59:12','2022-05-22 12:59:12');
INSERT INTO invoice_items VALUES('525','1','363','1','5000.00','0.00','2022-05-22 13:12:46','2022-05-22 13:12:46');
INSERT INTO invoice_items VALUES('526','1','363','2','20000.00','0.00','2022-05-22 13:12:46','2022-05-22 13:12:46');
INSERT INTO invoice_items VALUES('527','1','364','1','10000.00','0.00','2022-05-23 08:12:38','2022-05-23 08:12:38');
INSERT INTO invoice_items VALUES('528','1','365','1','5000.00','0.00','2022-05-31 07:51:39','2022-05-31 07:51:39');
INSERT INTO invoice_items VALUES('529','1','365','2','17000.00','0.00','2022-05-31 07:51:39','2022-05-31 07:51:39');
INSERT INTO invoice_items VALUES('533','1','366','2','20000.00','0.00','2022-06-02 10:37:24','2022-06-02 10:37:24');
INSERT INTO invoice_items VALUES('532','1','366','1','10000.00','0.00','2022-06-02 10:37:24','2022-06-02 10:37:24');
INSERT INTO invoice_items VALUES('534','1','367','1','22500.00','0.00','2022-06-02 11:02:03','2022-06-02 11:02:03');
INSERT INTO invoice_items VALUES('535','1','368','1','17500.00','0.00','2022-06-02 11:02:03','2022-06-02 11:02:03');
INSERT INTO invoice_items VALUES('536','1','369','1','18500.00','0.00','2022-06-02 11:02:03','2022-06-02 11:02:03');
INSERT INTO invoice_items VALUES('537','1','370','1','18500.00','0.00','2022-06-02 11:02:03','2022-06-02 11:02:03');
INSERT INTO invoice_items VALUES('538','1','371','1','15000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('539','1','372','1','15000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('540','1','373','1','15000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('541','1','374','1','15000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('542','1','375','1','18500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('543','1','376','1','17000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('958','1','745','4','1200.00','0.00','2022-10-05 08:03:01','2022-10-05 08:03:01');
INSERT INTO invoice_items VALUES('546','1','379','1','15000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('547','1','380','1','22000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('548','1','381','1','22000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('550','1','383','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('551','1','384','1','19000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('552','1','385','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('553','1','386','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('554','1','387','1','19000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('608','1','388','1','17000.00','0.00','2022-06-12 10:54:13','2022-06-12 10:54:13');
INSERT INTO invoice_items VALUES('556','1','389','1','18000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('557','1','390','1','18000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('558','1','391','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('559','1','392','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('560','1','393','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('561','1','394','1','16500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('600','1','395','1','16500.00','0.00','2022-06-09 06:39:27','2022-06-09 06:39:27');
INSERT INTO invoice_items VALUES('563','1','396','1','17000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('564','1','397','1','18000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('565','1','398','1','16000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('566','1','399','1','18500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('567','1','400','1','18500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('568','1','401','1','20000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('569','1','402','1','20000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('570','1','403','1','18500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('571','1','404','1','18500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('605','1','427','1','18000.00','0.00','2022-06-11 13:14:43','2022-06-11 13:14:43');
INSERT INTO invoice_items VALUES('573','1','406','1','25000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('574','1','407','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('575','1','408','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('576','1','409','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('577','1','410','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('578','1','411','1','17500.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('579','1','412','1','20000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('1028','1','429','2','15000.00','0.00','2022-11-06 14:27:37','2022-11-06 14:27:37');
INSERT INTO invoice_items VALUES('581','1','414','1','17000.00','0.00','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoice_items VALUES('1109','1','879','1','24000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('592','1','420','2','17500.00','0.00','2022-06-04 06:11:01','2022-06-04 06:11:01');
INSERT INTO invoice_items VALUES('591','1','420','1','17500.00','0.00','2022-06-04 06:11:01','2022-06-04 06:11:01');
INSERT INTO invoice_items VALUES('585','1','417','1','20000.00','0.00','2022-06-04 05:22:45','2022-06-04 05:22:45');
INSERT INTO invoice_items VALUES('586','1','417','2','18000.00','0.00','2022-06-04 05:22:45','2022-06-04 05:22:45');
INSERT INTO invoice_items VALUES('587','1','418','1','17000.00','0.00','2022-06-04 05:34:43','2022-06-04 05:34:43');
INSERT INTO invoice_items VALUES('588','1','418','2','17000.00','0.00','2022-06-04 05:34:43','2022-06-04 05:34:43');
INSERT INTO invoice_items VALUES('589','1','419','1','17000.00','0.00','2022-06-04 05:45:38','2022-06-04 05:45:38');
INSERT INTO invoice_items VALUES('590','1','419','2','17000.00','0.00','2022-06-04 05:45:38','2022-06-04 05:45:38');
INSERT INTO invoice_items VALUES('766','1','559','4','2185.00','0.00','2022-08-13 07:25:25','2022-08-13 07:25:25');
INSERT INTO invoice_items VALUES('765','1','558','4','2185.00','0.00','2022-08-13 07:25:25','2022-08-13 07:25:25');
INSERT INTO invoice_items VALUES('595','1','422','1','22000.00','0.00','2022-06-05 14:38:28','2022-06-05 14:38:28');
INSERT INTO invoice_items VALUES('596','1','422','2','20000.00','0.00','2022-06-05 14:38:28','2022-06-05 14:38:28');
INSERT INTO invoice_items VALUES('597','1','423','1','22000.00','0.00','2022-06-05 14:48:14','2022-06-05 14:48:14');
INSERT INTO invoice_items VALUES('598','1','423','2','20000.00','0.00','2022-06-05 14:48:14','2022-06-05 14:48:14');
INSERT INTO invoice_items VALUES('599','1','424','1','16500.00','0.00','2022-06-06 13:38:37','2022-06-06 13:38:37');
INSERT INTO invoice_items VALUES('601','1','425','1','16500.00','0.00','2022-06-09 06:41:45','2022-06-09 06:41:45');
INSERT INTO invoice_items VALUES('602','1','426','1','6000.00','0.00','2022-06-09 13:58:42','2022-06-09 13:58:42');
INSERT INTO invoice_items VALUES('606','1','428','1','20000.00','0.00','2022-06-11 13:28:17','2022-06-11 13:28:17');
INSERT INTO invoice_items VALUES('1027','1','429','1','13300.00','0.00','2022-11-06 14:27:37','2022-11-06 14:27:37');
INSERT INTO invoice_items VALUES('1591','1','430','2','10000.00','0.00','2023-07-09 08:53:05','2023-07-09 08:53:05');
INSERT INTO invoice_items VALUES('1590','1','430','1','20000.00','0.00','2023-07-09 08:53:05','2023-07-09 08:53:05');
INSERT INTO invoice_items VALUES('613','1','431','1','18000.00','0.00','2022-07-03 07:51:02','2022-07-03 07:51:02');
INSERT INTO invoice_items VALUES('614','1','431','2','17000.00','0.00','2022-07-03 07:51:02','2022-07-03 07:51:02');
INSERT INTO invoice_items VALUES('615','1','432','1','22500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('616','1','433','1','18500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('617','1','434','1','18500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('618','1','435','1','15000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('619','1','436','1','15000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('620','1','437','1','15000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('621','1','438','1','15000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('622','1','439','1','18500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('623','1','440','1','17000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('624','1','441','1','15000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('625','1','442','1','17000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('626','1','443','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('627','1','444','1','19000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('628','1','445','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('629','1','446','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('630','1','447','1','19000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('631','1','448','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('632','1','449','1','18000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('633','1','450','1','18000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('635','1','452','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('636','1','453','1','16500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('637','1','454','1','16500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('638','1','455','1','18000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('1673','1','1409','1','30000.00','0.00','2023-08-05 11:23:59','2023-08-05 11:23:59');
INSERT INTO invoice_items VALUES('640','1','457','1','18500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('641','1','458','1','18500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('642','1','459','1','20000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('643','1','460','1','20000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('644','1','461','1','18500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('957','1','744','4','1200.00','0.00','2022-10-05 08:03:01','2022-10-05 08:03:01');
INSERT INTO invoice_items VALUES('646','1','463','1','25000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('647','1','464','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('648','1','465','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('649','1','466','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('650','1','467','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('651','1','468','1','17500.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('652','1','469','1','20000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('653','1','470','1','17000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('773','1','562','2','10000.00','0.00','2022-09-02 10:31:28','2022-09-02 10:31:28');
INSERT INTO invoice_items VALUES('655','1','472','1','20000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('656','1','473','1','17000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('658','1','475','1','17000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('659','1','476','1','20000.00','0.00','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoice_items VALUES('683','1','477','1','6000.00','0.00','2022-07-21 08:58:30','2022-07-21 08:58:30');
INSERT INTO invoice_items VALUES('661','1','478','1','22000.00','0.00','2022-07-14 10:13:35','2022-07-14 10:13:35');
INSERT INTO invoice_items VALUES('662','1','478','2','10000.00','0.00','2022-07-14 10:13:35','2022-07-14 10:13:35');
INSERT INTO invoice_items VALUES('663','1','479','1','22000.00','0.00','2022-07-14 10:19:03','2022-07-14 10:19:03');
INSERT INTO invoice_items VALUES('664','1','479','2','15000.00','0.00','2022-07-14 10:19:03','2022-07-14 10:19:03');
INSERT INTO invoice_items VALUES('665','1','480','1','17500.00','0.00','2022-07-14 10:36:18','2022-07-14 10:36:18');
INSERT INTO invoice_items VALUES('666','1','480','2','15000.00','0.00','2022-07-14 10:36:18','2022-07-14 10:36:18');
INSERT INTO invoice_items VALUES('667','1','481','1','20000.00','0.00','2022-07-14 10:47:52','2022-07-14 10:47:52');
INSERT INTO invoice_items VALUES('668','1','482','1','20000.00','0.00','2022-07-16 06:43:44','2022-07-16 06:43:44');
INSERT INTO invoice_items VALUES('669','1','482','2','20000.00','0.00','2022-07-16 06:43:44','2022-07-16 06:43:44');
INSERT INTO invoice_items VALUES('670','1','483','1','17500.00','0.00','2022-07-16 06:56:50','2022-07-16 06:56:50');
INSERT INTO invoice_items VALUES('671','1','483','2','15000.00','0.00','2022-07-16 06:56:50','2022-07-16 06:56:50');
INSERT INTO invoice_items VALUES('672','1','484','1','17500.00','0.00','2022-07-16 08:14:17','2022-07-16 08:14:17');
INSERT INTO invoice_items VALUES('673','1','485','1','8000.00','0.00','2022-07-20 05:41:49','2022-07-20 05:41:49');
INSERT INTO invoice_items VALUES('674','1','485','2','15000.00','0.00','2022-07-20 05:41:49','2022-07-20 05:41:49');
INSERT INTO invoice_items VALUES('675','1','486','1','6000.00','0.00','2022-07-20 05:54:18','2022-07-20 05:54:18');
INSERT INTO invoice_items VALUES('676','1','486','2','10000.00','0.00','2022-07-20 05:54:18','2022-07-20 05:54:18');
INSERT INTO invoice_items VALUES('677','1','487','1','6000.00','0.00','2022-07-20 05:59:58','2022-07-20 05:59:58');
INSERT INTO invoice_items VALUES('678','1','487','2','18000.00','0.00','2022-07-20 05:59:58','2022-07-20 05:59:58');
INSERT INTO invoice_items VALUES('679','1','488','1','7000.00','0.00','2022-07-20 06:08:46','2022-07-20 06:08:46');
INSERT INTO invoice_items VALUES('680','1','488','2','17500.00','0.00','2022-07-20 06:08:46','2022-07-20 06:08:46');
INSERT INTO invoice_items VALUES('681','1','489','1','5000.00','0.00','2022-07-21 08:47:59','2022-07-21 08:47:59');
INSERT INTO invoice_items VALUES('682','1','489','2','17500.00','0.00','2022-07-21 08:47:59','2022-07-21 08:47:59');
INSERT INTO invoice_items VALUES('684','1','490','1','6000.00','0.00','2022-07-21 09:56:53','2022-07-21 09:56:53');
INSERT INTO invoice_items VALUES('685','1','490','2','17000.00','0.00','2022-07-21 09:56:53','2022-07-21 09:56:53');
INSERT INTO invoice_items VALUES('686','1','491','1','4500.00','0.00','2022-07-23 08:37:59','2022-07-23 08:37:59');
INSERT INTO invoice_items VALUES('687','1','491','2','17500.00','0.00','2022-07-23 08:37:59','2022-07-23 08:37:59');
INSERT INTO invoice_items VALUES('691','1','494','1','4000.00','0.00','2022-07-24 08:36:06','2022-07-24 08:36:06');
INSERT INTO invoice_items VALUES('689','1','493','1','4000.00','0.00','2022-07-23 08:47:19','2022-07-23 08:47:19');
INSERT INTO invoice_items VALUES('690','1','493','2','17500.00','0.00','2022-07-23 08:47:19','2022-07-23 08:47:19');
INSERT INTO invoice_items VALUES('692','1','494','2','17500.00','0.00','2022-07-24 08:36:06','2022-07-24 08:36:06');
INSERT INTO invoice_items VALUES('693','1','495','1','5250.00','0.00','2022-07-24 08:41:57','2022-07-24 08:41:57');
INSERT INTO invoice_items VALUES('694','1','495','2','17500.00','0.00','2022-07-24 08:41:57','2022-07-24 08:41:57');
INSERT INTO invoice_items VALUES('695','1','496','1','22500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('696','1','497','1','18500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('772','1','561','1','10000.00','0.00','2022-09-02 10:28:09','2022-09-02 10:28:09');
INSERT INTO invoice_items VALUES('698','1','499','1','15000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('761','1','557','1','12300.00','0.00','2022-08-11 06:30:45','2022-08-11 06:30:45');
INSERT INTO invoice_items VALUES('700','1','501','1','15000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('701','1','502','1','15000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('702','1','503','1','18500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('703','1','504','1','17000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('704','1','505','1','15000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('705','1','506','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('706','1','507','1','19000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('707','1','508','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('708','1','509','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('709','1','510','1','19000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('710','1','511','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('711','1','512','1','18000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('712','1','513','1','18000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('713','1','514','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('714','1','515','1','18000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('715','1','516','1','18500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('716','1','517','1','18500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('717','1','518','1','20000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('718','1','519','1','20000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('1041','1','816','1','13500.00','0.00','2022-11-16 17:25:28','2022-11-16 17:25:28');
INSERT INTO invoice_items VALUES('720','1','521','1','25000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('721','1','522','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('722','1','523','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('723','1','524','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('724','1','525','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('725','1','526','1','20000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('726','1','527','1','17000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('964','1','750','1','24000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('728','1','529','1','17000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('757','1','555','1','17500.00','0.00','2022-08-06 16:43:38','2022-08-06 16:43:38');
INSERT INTO invoice_items VALUES('730','1','531','1','17000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('731','1','532','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('732','1','533','1','20000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('733','1','534','1','20000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('734','1','535','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('735','1','536','1','22000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('736','1','537','1','22000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('737','1','538','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('738','1','539','1','20000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('739','1','540','1','20000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('740','1','541','1','20000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('741','1','542','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('742','1','543','1','18500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('743','1','544','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('744','1','545','1','17000.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('745','1','546','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('749','1','550','1','17500.00','0.00','2022-08-02 10:08:34','2022-08-02 10:08:34');
INSERT INTO invoice_items VALUES('747','1','548','1','17500.00','0.00','2022-08-02 10:01:10','2022-08-02 10:01:10');
INSERT INTO invoice_items VALUES('762','1','557','2','18500.00','0.00','2022-08-11 06:30:45','2022-08-11 06:30:45');
INSERT INTO invoice_items VALUES('764','1','551','2','3000.00','0.00','2022-08-13 07:03:16','2022-08-13 07:03:16');
INSERT INTO invoice_items VALUES('763','1','551','1','20000.00','0.00','2022-08-13 07:03:16','2022-08-13 07:03:16');
INSERT INTO invoice_items VALUES('752','1','552','1','18500.00','0.00','2022-08-03 06:05:57','2022-08-03 06:05:57');
INSERT INTO invoice_items VALUES('753','1','552','2','16500.00','0.00','2022-08-03 06:05:57','2022-08-03 06:05:57');
INSERT INTO invoice_items VALUES('756','1','554','1','17500.00','0.00','2022-08-04 18:34:13','2022-08-04 18:34:13');
INSERT INTO invoice_items VALUES('758','1','555','2','17500.00','0.00','2022-08-06 16:43:38','2022-08-06 16:43:38');
INSERT INTO invoice_items VALUES('882','1','672','1','21500.00','0.00','2022-09-05 21:01:14','2022-09-05 21:01:14');
INSERT INTO invoice_items VALUES('912','1','697','1','19500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('905','1','690','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('904','1','689','1','21000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('1043','1','675','1','22000.00','0.00','2022-12-04 12:39:15','2022-12-04 12:39:15');
INSERT INTO invoice_items VALUES('932','1','717','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('901','1','686','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('887','1','674','2','20000.00','0.00','2022-09-06 06:19:50','2022-09-06 06:19:50');
INSERT INTO invoice_items VALUES('928','1','713','1','21500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('893','1','678','4','4220.00','0.00','2022-09-07 09:10:31','2022-09-07 09:10:31');
INSERT INTO invoice_items VALUES('927','1','712','1','21500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('911','1','696','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('892','1','678','1','21000.00','0.00','2022-09-07 09:10:31','2022-09-07 09:10:31');
INSERT INTO invoice_items VALUES('900','1','685','1','19500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('956','1','743','2','15000.00','0.00','2022-10-05 07:48:58','2022-10-05 07:48:58');
INSERT INTO invoice_items VALUES('955','1','743','1','21500.00','0.00','2022-10-05 07:48:58','2022-10-05 07:48:58');
INSERT INTO invoice_items VALUES('926','1','711','1','16500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('929','1','714','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('831','1','622','1','16500.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('830','1','621','1','20000.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('885','1','673','2','20000.00','0.00','2022-09-06 06:19:50','2022-09-06 06:19:50');
INSERT INTO invoice_items VALUES('884','1','673','1','20000.00','0.00','2022-09-06 06:19:50','2022-09-06 06:19:50');
INSERT INTO invoice_items VALUES('903','1','688','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('936','1','721','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('934','1','719','1','21500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('935','1','720','1','21500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('933','1','718','1','20000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('907','1','692','1','21000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('924','1','709','1','18700.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('897','1','682','1','16500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('965','1','751','1','20000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('925','1','710','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('886','1','674','1','20000.00','0.00','2022-09-06 06:19:50','2022-09-06 06:19:50');
INSERT INTO invoice_items VALUES('909','1','694','1','19500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('896','1','681','1','20000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('906','1','691','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('899','1','684','1','16500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('919','1','704','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('1022','1','671','1','23000.00','0.00','2022-11-01 07:10:49','2022-11-01 07:10:49');
INSERT INTO invoice_items VALUES('963','1','749','1','26000.00','0.00','2022-10-07 08:19:14','2022-10-07 08:19:14');
INSERT INTO invoice_items VALUES('918','1','703','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('960','1','746','1','24500.00','0.00','2022-10-07 07:45:13','2022-10-07 07:45:13');
INSERT INTO invoice_items VALUES('894','1','679','1','12000.00','0.00','2022-09-10 08:49:20','2022-09-10 08:49:20');
INSERT INTO invoice_items VALUES('921','1','706','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('910','1','695','1','19500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('916','1','701','1','21500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('920','1','705','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('908','1','693','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('883','1','672','2','21500.00','0.00','2022-09-05 21:01:14','2022-09-05 21:01:14');
INSERT INTO invoice_items VALUES('915','1','700','1','21500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('829','1','620','1','24000.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('914','1','699','1','20000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('898','1','683','1','16500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('913','1','698','1','20000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('832','1','623','1','16500.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('833','1','624','1','16500.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('834','1','625','1','19500.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('835','1','626','1','19000.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('836','1','627','1','16500.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('837','1','628','1','19000.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('891','1','677','4','4220.00','0.00','2022-09-07 09:10:31','2022-09-07 09:10:31');
INSERT INTO invoice_items VALUES('839','1','630','1','19000.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('840','1','631','1','19000.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('890','1','677','1','21000.00','0.00','2022-09-07 09:10:31','2022-09-07 09:10:31');
INSERT INTO invoice_items VALUES('842','1','633','1','19000.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('843','1','634','1','19500.00','0.00','2022-09-03 18:43:36','2022-09-03 18:43:36');
INSERT INTO invoice_items VALUES('844','1','635','1','19500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('845','1','636','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('846','1','637','1','19500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('847','1','638','1','20000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('848','1','639','1','20000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('849','1','640','1','21500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('850','1','641','1','21500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('902','1','687','1','16500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('852','1','643','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('853','1','644','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('854','1','645','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('855','1','646','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('856','1','647','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('857','1','648','1','21500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('1523','1','1275','1','13000.00','0.00','2023-06-15 08:36:41','2023-06-15 08:36:41');
INSERT INTO invoice_items VALUES('859','1','650','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('860','1','651','1','16500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('861','1','652','1','21500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('862','1','653','1','21500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('863','1','654','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('1021','1','671','2','10000.00','0.00','2022-11-01 07:10:49','2022-11-01 07:10:49');
INSERT INTO invoice_items VALUES('865','1','656','1','23500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('866','1','657','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('889','1','676','1','26000.00','0.00','2022-09-07 08:33:22','2022-09-07 08:33:22');
INSERT INTO invoice_items VALUES('868','1','659','1','21500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('869','1','660','1','21500.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('870','1','661','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('871','1','662','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('872','1','663','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('873','1','664','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('874','1','665','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('875','1','666','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('876','1','667','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('877','1','668','1','20000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('878','1','669','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('879','1','670','1','19000.00','0.00','2022-09-03 18:43:37','2022-09-03 18:43:37');
INSERT INTO invoice_items VALUES('937','1','722','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('938','1','723','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('961','1','747','1','18700.00','0.00','2022-10-07 07:57:55','2022-10-07 07:57:55');
INSERT INTO invoice_items VALUES('940','1','725','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('941','1','726','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('942','1','727','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('943','1','728','1','20000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('944','1','729','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('945','1','730','1','19000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('946','1','731','1','21500.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('947','1','732','1','20000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('948','1','733','1','20000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('954','1','742','1','23000.00','0.00','2022-10-05 07:38:32','2022-10-05 07:38:32');
INSERT INTO invoice_items VALUES('950','1','735','1','12000.00','0.00','2022-10-02 09:37:04','2022-10-02 09:37:04');
INSERT INTO invoice_items VALUES('953','1','741','1','23000.00','0.00','2022-10-05 07:38:32','2022-10-05 07:38:32');
INSERT INTO invoice_items VALUES('952','1','737','1','15000.00','0.00','2022-10-05 07:04:16','2022-10-05 07:04:16');
INSERT INTO invoice_items VALUES('962','1','748','1','18500.00','0.00','2022-10-07 08:09:18','2022-10-07 08:09:18');
INSERT INTO invoice_items VALUES('1034','1','752','1','16500.00','0.00','2022-11-15 17:41:38','2022-11-15 17:41:38');
INSERT INTO invoice_items VALUES('967','1','753','1','16500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('968','1','754','1','16500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('969','1','755','1','19500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('970','1','756','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('971','1','757','1','16500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('972','1','758','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('973','1','759','1','21000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('974','1','760','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('975','1','761','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('976','1','762','1','21000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('1110','1','880','1','20000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('978','1','764','1','19500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('979','1','765','1','19500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('980','1','766','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('981','1','767','1','19500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('982','1','768','1','20000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('983','1','769','1','20000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('1516','1','810','2','10000.00','0.00','2023-06-13 17:20:37','2023-06-13 17:20:37');
INSERT INTO invoice_items VALUES('1040','1','815','2','21500.00','0.00','2022-11-16 17:06:27','2022-11-16 17:06:27');
INSERT INTO invoice_items VALUES('986','1','772','1','21500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('1031','1','811','1','26000.00','0.00','2022-11-08 10:03:53','2022-11-08 10:03:53');
INSERT INTO invoice_items VALUES('988','1','774','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('989','1','775','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('990','1','776','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('991','1','777','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('1023','1','808','1','19000.00','0.00','2022-11-03 06:31:11','2022-11-03 06:31:11');
INSERT INTO invoice_items VALUES('993','1','779','1','18700.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('994','1','780','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('995','1','781','1','16500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('996','1','782','1','21500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('997','1','783','1','21500.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('998','1','784','1','19000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('999','1','785','1','23000.00','0.00','2022-11-01 07:09:42','2022-11-01 07:09:42');
INSERT INTO invoice_items VALUES('1000','1','786','1','23000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1001','1','787','1','19000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1606','1','788','1','20000.00','0.00','2023-07-30 12:43:40','2023-07-30 12:43:40');
INSERT INTO invoice_items VALUES('1003','1','789','1','21500.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1004','1','790','1','21500.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1005','1','791','1','19000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1006','1','792','1','19000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1007','1','793','1','19000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1025','1','809','1','18700.00','0.00','2022-11-04 12:58:20','2022-11-04 12:58:20');
INSERT INTO invoice_items VALUES('1009','1','795','1','19000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1010','1','796','1','19000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1011','1','797','1','19000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1012','1','798','1','20000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1013','1','799','1','19000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1014','1','800','1','19000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1015','1','801','1','21500.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1016','1','802','1','20000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1017','1','803','1','20000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1018','1','804','1','15000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1019','1','805','1','12000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1020','1','806','1','15000.00','0.00','2022-11-01 07:09:43','2022-11-01 07:09:43');
INSERT INTO invoice_items VALUES('1024','1','808','2','17000.00','0.00','2022-11-03 06:31:11','2022-11-03 06:31:11');
INSERT INTO invoice_items VALUES('1515','1','810','1','21500.00','0.00','2023-06-13 17:20:37','2023-06-13 17:20:37');
INSERT INTO invoice_items VALUES('1035','1','813','1','7500.00','0.00','2022-11-16 16:52:26','2022-11-16 16:52:26');
INSERT INTO invoice_items VALUES('1036','1','813','2','10000.00','0.00','2022-11-16 16:52:26','2022-11-16 16:52:26');
INSERT INTO invoice_items VALUES('1039','1','815','1','21500.00','0.00','2022-11-16 17:06:27','2022-11-16 17:06:27');
INSERT INTO invoice_items VALUES('1042','1','816','2','20000.00','0.00','2022-11-16 17:25:28','2022-11-16 17:25:28');
INSERT INTO invoice_items VALUES('1045','1','817','1','20000.00','0.00','2022-12-10 08:29:24','2022-12-10 08:29:24');
INSERT INTO invoice_items VALUES('1046','1','818','1','20000.00','0.00','2022-12-10 08:29:24','2022-12-10 08:29:24');
INSERT INTO invoice_items VALUES('1047','1','819','1','21500.00','0.00','2022-12-22 05:42:10','2022-12-22 05:42:10');
INSERT INTO invoice_items VALUES('1048','1','819','2','21500.00','0.00','2022-12-22 05:42:10','2022-12-22 05:42:10');
INSERT INTO invoice_items VALUES('1049','1','820','1','24000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1050','1','821','1','20000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1051','1','822','1','15000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1052','1','823','1','15000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1053','1','824','1','15000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1054','1','825','1','19500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1055','1','826','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1056','1','827','1','15000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1057','1','828','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1058','1','829','1','21000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1059','1','830','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1060','1','831','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1061','1','832','1','21000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1062','1','833','1','19500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1063','1','834','1','19500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1064','1','835','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1065','1','836','1','19500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1066','1','837','1','20000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1067','1','838','1','20000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1107','1','877','1','26000.00','0.00','2022-12-28 16:19:38','2022-12-28 16:19:38');
INSERT INTO invoice_items VALUES('1069','1','840','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1070','1','841','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1071','1','842','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1072','1','843','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1073','1','844','1','18500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1074','1','845','1','18700.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1075','1','846','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1076','1','847','1','15000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1077','1','848','1','21500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1078','1','849','1','21500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1079','1','850','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1080','1','851','1','23000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1081','1','852','1','23000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1082','1','853','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1083','1','854','1','22000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1084','1','855','1','21500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1085','1','856','1','21500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1086','1','857','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1087','1','858','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1088','1','859','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1108','1','878','1','18500.00','0.00','2022-12-28 16:28:00','2022-12-28 16:28:00');
INSERT INTO invoice_items VALUES('1090','1','861','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1091','1','862','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1092','1','863','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1093','1','864','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1094','1','865','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1095','1','866','1','21500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1096','1','867','1','20000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1097','1','868','1','20000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1098','1','869','1','15000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1099','1','870','1','12000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1100','1','871','1','15000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1101','1','872','1','19000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1102','1','873','1','21500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1103','1','874','1','15000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1104','1','875','1','21500.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1105','1','876','1','20000.00','0.00','2022-12-22 05:43:30','2022-12-22 05:43:30');
INSERT INTO invoice_items VALUES('1111','1','881','1','15000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1112','1','882','1','15000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1113','1','883','1','15000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1114','1','884','1','19500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1173','1','942','1','24000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1116','1','886','1','15000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1117','1','887','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1118','1','888','1','21000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1119','1','889','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1120','1','890','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1121','1','891','1','21000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1122','1','892','1','19500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1123','1','893','1','19500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1124','1','894','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1125','1','895','1','19500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1126','1','896','1','20000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1127','1','897','1','20000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1128','1','898','1','26000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1129','1','899','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1130','1','900','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1131','1','901','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1132','1','902','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1133','1','903','1','18500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1134','1','904','1','18700.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1135','1','905','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1136','1','906','1','15000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1137','1','907','1','21500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1138','1','908','1','21500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1139','1','909','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1140','1','910','1','23000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1141','1','911','1','23000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1142','1','912','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1143','1','913','1','22000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1144','1','914','1','21500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1145','1','915','1','21500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1146','1','916','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1147','1','917','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1148','1','918','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1149','1','919','1','18500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1150','1','920','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1151','1','921','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1152','1','922','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1153','1','923','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1154','1','924','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1155','1','925','1','21500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1156','1','926','1','20000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1157','1','927','1','20000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1158','1','928','1','15000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1159','1','929','1','12000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1160','1','930','1','15000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1161','1','931','1','19000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1162','1','932','1','21500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1163','1','933','1','15000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1164','1','934','1','21500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1165','1','935','1','20000.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1172','1','941','1','10000.00','0.00','2023-01-24 14:13:20','2023-01-24 14:13:20');
INSERT INTO invoice_items VALUES('1171','1','940','1','10000.00','0.00','2023-01-24 14:13:20','2023-01-24 14:13:20');
INSERT INTO invoice_items VALUES('1168','1','938','1','21500.00','0.00','2023-01-06 07:13:21','2023-01-06 07:13:21');
INSERT INTO invoice_items VALUES('1169','1','939','1','19000.00','0.00','2023-01-06 10:45:34','2023-01-06 10:45:34');
INSERT INTO invoice_items VALUES('1170','1','939','2','19000.00','0.00','2023-01-06 10:45:34','2023-01-06 10:45:34');
INSERT INTO invoice_items VALUES('1174','1','943','1','20000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1175','1','944','1','15000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1176','1','945','1','15000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1177','1','946','1','15000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1178','1','947','1','19500.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1179','1','948','1','15000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1180','1','949','1','19000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1181','1','950','1','21000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1182','1','951','1','19000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1183','1','952','1','19000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1184','1','953','1','21000.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1185','1','954','1','19500.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1186','1','955','1','19500.00','0.00','2023-02-03 11:53:43','2023-02-03 11:53:43');
INSERT INTO invoice_items VALUES('1187','1','956','1','19000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1188','1','957','1','19500.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1189','1','958','1','20000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1190','1','959','1','20000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1191','1','960','1','26000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1192','1','961','1','19000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1193','1','962','1','19000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1194','1','963','1','19000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1195','1','964','1','19000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1196','1','965','1','18500.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1197','1','966','1','18700.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1198','1','967','1','19000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1199','1','968','1','15000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1200','1','969','1','21500.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1201','1','970','1','21500.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1202','1','971','1','19000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1203','1','972','1','23000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1204','1','973','1','23000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1205','1','974','1','19000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1206','1','975','1','22000.00','0.00','2023-02-03 11:53:44','2023-02-03 11:53:44');
INSERT INTO invoice_items VALUES('1207','1','976','1','21500.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1208','1','977','1','21500.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1209','1','978','1','19000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1210','1','979','1','19000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1211','1','980','1','19000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1212','1','981','1','18500.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1213','1','982','1','19000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1214','1','983','1','19000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1215','1','984','1','19000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1216','1','985','1','19000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1217','1','986','1','19000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1218','1','987','1','21500.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1219','1','988','1','20000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1220','1','989','1','20000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1221','1','990','1','15000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1222','1','991','1','12000.00','0.00','2023-02-03 11:53:45','2023-02-03 11:53:45');
INSERT INTO invoice_items VALUES('1223','1','992','1','15000.00','0.00','2023-02-03 11:53:46','2023-02-03 11:53:46');
INSERT INTO invoice_items VALUES('1224','1','993','1','19000.00','0.00','2023-02-03 11:53:46','2023-02-03 11:53:46');
INSERT INTO invoice_items VALUES('1225','1','994','1','21500.00','0.00','2023-02-03 11:53:46','2023-02-03 11:53:46');
INSERT INTO invoice_items VALUES('1226','1','995','1','15000.00','0.00','2023-02-03 11:53:46','2023-02-03 11:53:46');
INSERT INTO invoice_items VALUES('1227','1','996','1','21500.00','0.00','2023-02-03 11:53:46','2023-02-03 11:53:46');
INSERT INTO invoice_items VALUES('1228','1','997','1','20000.00','0.00','2023-02-03 11:53:46','2023-02-03 11:53:46');
INSERT INTO invoice_items VALUES('1237','1','1005','2','20000.00','0.00','2023-03-07 19:03:00','2023-03-07 19:03:00');
INSERT INTO invoice_items VALUES('1238','1','1006','2','20000.00','0.00','2023-03-07 19:03:01','2023-03-07 19:03:01');
INSERT INTO invoice_items VALUES('1231','1','1000','1','21500.00','0.00','2023-02-03 11:53:46','2023-02-03 11:53:46');
INSERT INTO invoice_items VALUES('1232','1','1001','1','19000.00','0.00','2023-02-03 11:53:46','2023-02-03 11:53:46');
INSERT INTO invoice_items VALUES('1518','1','1002','1','18000.00','0.00','2023-06-13 17:36:06','2023-06-13 17:36:06');
INSERT INTO invoice_items VALUES('1517','1','1002','2','15000.00','0.00','2023-06-13 17:36:06','2023-06-13 17:36:06');
INSERT INTO invoice_items VALUES('1235','1','1003','1','18000.00','0.00','2023-02-09 10:50:27','2023-02-09 10:50:27');
INSERT INTO invoice_items VALUES('1236','1','1004','1','18000.00','0.00','2023-02-09 10:51:34','2023-02-09 10:51:34');
INSERT INTO invoice_items VALUES('1239','1','1007','1','24000.00','0.00','2023-03-07 19:16:26','2023-03-07 19:16:26');
INSERT INTO invoice_items VALUES('1240','1','1008','1','20000.00','0.00','2023-03-07 19:16:26','2023-03-07 19:16:26');
INSERT INTO invoice_items VALUES('1241','1','1009','1','15000.00','0.00','2023-03-07 19:16:26','2023-03-07 19:16:26');
INSERT INTO invoice_items VALUES('1242','1','1010','1','15000.00','0.00','2023-03-07 19:16:26','2023-03-07 19:16:26');
INSERT INTO invoice_items VALUES('1243','1','1011','1','15000.00','0.00','2023-03-07 19:16:26','2023-03-07 19:16:26');
INSERT INTO invoice_items VALUES('1244','1','1012','1','19500.00','0.00','2023-03-07 19:16:26','2023-03-07 19:16:26');
INSERT INTO invoice_items VALUES('1245','1','1013','1','15000.00','0.00','2023-03-07 19:16:26','2023-03-07 19:16:26');
INSERT INTO invoice_items VALUES('1246','1','1014','1','19000.00','0.00','2023-03-07 19:16:26','2023-03-07 19:16:26');
INSERT INTO invoice_items VALUES('1247','1','1015','1','21000.00','0.00','2023-03-07 19:16:26','2023-03-07 19:16:26');
INSERT INTO invoice_items VALUES('1248','1','1016','1','19000.00','0.00','2023-03-07 19:16:27','2023-03-07 19:16:27');
INSERT INTO invoice_items VALUES('1249','1','1017','1','19000.00','0.00','2023-03-07 19:16:27','2023-03-07 19:16:27');
INSERT INTO invoice_items VALUES('1250','1','1018','1','21000.00','0.00','2023-03-07 19:16:27','2023-03-07 19:16:27');
INSERT INTO invoice_items VALUES('1251','1','1019','1','19500.00','0.00','2023-03-07 19:16:27','2023-03-07 19:16:27');
INSERT INTO invoice_items VALUES('1252','1','1020','1','19500.00','0.00','2023-03-07 19:16:27','2023-03-07 19:16:27');
INSERT INTO invoice_items VALUES('1253','1','1021','1','19000.00','0.00','2023-03-07 19:16:27','2023-03-07 19:16:27');
INSERT INTO invoice_items VALUES('1254','1','1022','1','19500.00','0.00','2023-03-07 19:16:27','2023-03-07 19:16:27');
INSERT INTO invoice_items VALUES('1255','1','1023','1','20000.00','0.00','2023-03-07 19:16:28','2023-03-07 19:16:28');
INSERT INTO invoice_items VALUES('1256','1','1024','1','20000.00','0.00','2023-03-07 19:16:28','2023-03-07 19:16:28');
INSERT INTO invoice_items VALUES('1257','1','1025','1','26000.00','0.00','2023-03-07 19:16:28','2023-03-07 19:16:28');
INSERT INTO invoice_items VALUES('1258','1','1026','1','19000.00','0.00','2023-03-07 19:16:28','2023-03-07 19:16:28');
INSERT INTO invoice_items VALUES('1259','1','1027','1','19000.00','0.00','2023-03-07 19:16:28','2023-03-07 19:16:28');
INSERT INTO invoice_items VALUES('1260','1','1028','1','19000.00','0.00','2023-03-07 19:16:28','2023-03-07 19:16:28');
INSERT INTO invoice_items VALUES('1261','1','1029','1','19000.00','0.00','2023-03-07 19:16:29','2023-03-07 19:16:29');
INSERT INTO invoice_items VALUES('1262','1','1030','1','18500.00','0.00','2023-03-07 19:16:29','2023-03-07 19:16:29');
INSERT INTO invoice_items VALUES('1446','1','1207','1','24500.00','0.00','2023-05-11 10:53:06','2023-05-11 10:53:06');
INSERT INTO invoice_items VALUES('1264','1','1032','1','19000.00','0.00','2023-03-07 19:16:29','2023-03-07 19:16:29');
INSERT INTO invoice_items VALUES('1265','1','1033','1','15000.00','0.00','2023-03-07 19:16:29','2023-03-07 19:16:29');
INSERT INTO invoice_items VALUES('1266','1','1034','1','21500.00','0.00','2023-03-07 19:16:29','2023-03-07 19:16:29');
INSERT INTO invoice_items VALUES('1267','1','1035','1','21500.00','0.00','2023-03-07 19:16:30','2023-03-07 19:16:30');
INSERT INTO invoice_items VALUES('1268','1','1036','1','19000.00','0.00','2023-03-07 19:16:30','2023-03-07 19:16:30');
INSERT INTO invoice_items VALUES('1269','1','1037','1','23000.00','0.00','2023-03-07 19:16:30','2023-03-07 19:16:30');
INSERT INTO invoice_items VALUES('1270','1','1038','1','23000.00','0.00','2023-03-07 19:16:30','2023-03-07 19:16:30');
INSERT INTO invoice_items VALUES('1271','1','1039','1','19000.00','0.00','2023-03-07 19:16:30','2023-03-07 19:16:30');
INSERT INTO invoice_items VALUES('1272','1','1040','1','22000.00','0.00','2023-03-07 19:16:31','2023-03-07 19:16:31');
INSERT INTO invoice_items VALUES('1273','1','1041','1','21500.00','0.00','2023-03-07 19:16:31','2023-03-07 19:16:31');
INSERT INTO invoice_items VALUES('1274','1','1042','1','21500.00','0.00','2023-03-07 19:16:31','2023-03-07 19:16:31');
INSERT INTO invoice_items VALUES('1275','1','1043','1','19000.00','0.00','2023-03-07 19:16:31','2023-03-07 19:16:31');
INSERT INTO invoice_items VALUES('1276','1','1044','1','19000.00','0.00','2023-03-07 19:16:31','2023-03-07 19:16:31');
INSERT INTO invoice_items VALUES('1277','1','1045','1','19000.00','0.00','2023-03-07 19:16:31','2023-03-07 19:16:31');
INSERT INTO invoice_items VALUES('1278','1','1046','1','18500.00','0.00','2023-03-07 19:16:32','2023-03-07 19:16:32');
INSERT INTO invoice_items VALUES('1279','1','1047','1','19000.00','0.00','2023-03-07 19:16:32','2023-03-07 19:16:32');
INSERT INTO invoice_items VALUES('1280','1','1048','1','19000.00','0.00','2023-03-07 19:16:32','2023-03-07 19:16:32');
INSERT INTO invoice_items VALUES('1281','1','1049','1','19000.00','0.00','2023-03-07 19:16:32','2023-03-07 19:16:32');
INSERT INTO invoice_items VALUES('1282','1','1050','1','19000.00','0.00','2023-03-07 19:16:32','2023-03-07 19:16:32');
INSERT INTO invoice_items VALUES('1283','1','1051','1','19000.00','0.00','2023-03-07 19:16:32','2023-03-07 19:16:32');
INSERT INTO invoice_items VALUES('1284','1','1052','1','21500.00','0.00','2023-03-07 19:16:33','2023-03-07 19:16:33');
INSERT INTO invoice_items VALUES('1285','1','1053','1','20000.00','0.00','2023-03-07 19:16:33','2023-03-07 19:16:33');
INSERT INTO invoice_items VALUES('1286','1','1054','1','20000.00','0.00','2023-03-07 19:16:33','2023-03-07 19:16:33');
INSERT INTO invoice_items VALUES('1287','1','1055','1','15000.00','0.00','2023-03-07 19:16:33','2023-03-07 19:16:33');
INSERT INTO invoice_items VALUES('1288','1','1056','1','12000.00','0.00','2023-03-07 19:16:33','2023-03-07 19:16:33');
INSERT INTO invoice_items VALUES('1289','1','1057','1','15000.00','0.00','2023-03-07 19:16:33','2023-03-07 19:16:33');
INSERT INTO invoice_items VALUES('1290','1','1058','1','19000.00','0.00','2023-03-07 19:16:33','2023-03-07 19:16:33');
INSERT INTO invoice_items VALUES('1291','1','1059','1','21500.00','0.00','2023-03-07 19:16:33','2023-03-07 19:16:33');
INSERT INTO invoice_items VALUES('1292','1','1060','1','15000.00','0.00','2023-03-07 19:16:34','2023-03-07 19:16:34');
INSERT INTO invoice_items VALUES('1293','1','1061','1','21500.00','0.00','2023-03-07 19:16:34','2023-03-07 19:16:34');
INSERT INTO invoice_items VALUES('1294','1','1062','1','20000.00','0.00','2023-03-07 19:16:34','2023-03-07 19:16:34');
INSERT INTO invoice_items VALUES('1295','1','1063','1','18000.00','0.00','2023-03-07 19:16:34','2023-03-07 19:16:34');
INSERT INTO invoice_items VALUES('1296','1','1064','1','18000.00','0.00','2023-03-07 19:16:34','2023-03-07 19:16:34');
INSERT INTO invoice_items VALUES('1297','1','1065','1','21500.00','0.00','2023-03-07 19:16:34','2023-03-07 19:16:34');
INSERT INTO invoice_items VALUES('1298','1','1066','1','19000.00','0.00','2023-03-07 19:16:34','2023-03-07 19:16:34');
INSERT INTO invoice_items VALUES('1299','1','1067','1','18000.00','0.00','2023-03-07 19:16:34','2023-03-07 19:16:34');
INSERT INTO invoice_items VALUES('1300','1','1068','1','21500.00','0.00','2023-03-07 19:16:35','2023-03-07 19:16:35');
INSERT INTO invoice_items VALUES('1672','1','1408','2','20000.00','0.00','2023-08-04 17:42:52','2023-08-04 17:42:52');
INSERT INTO invoice_items VALUES('1303','1','1071','1','20000.00','0.00','2023-04-01 12:19:12','2023-04-01 12:19:12');
INSERT INTO invoice_items VALUES('1304','1','1072','1','15000.00','0.00','2023-04-01 12:19:12','2023-04-01 12:19:12');
INSERT INTO invoice_items VALUES('1305','1','1073','1','15000.00','0.00','2023-04-01 12:19:12','2023-04-01 12:19:12');
INSERT INTO invoice_items VALUES('1306','1','1074','1','15000.00','0.00','2023-04-01 12:19:12','2023-04-01 12:19:12');
INSERT INTO invoice_items VALUES('1307','1','1075','1','19500.00','0.00','2023-04-01 12:19:12','2023-04-01 12:19:12');
INSERT INTO invoice_items VALUES('1308','1','1076','1','15000.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1309','1','1077','1','19000.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1310','1','1078','1','21000.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1311','1','1079','1','19000.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1312','1','1080','1','19000.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1313','1','1081','1','21000.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1314','1','1082','1','19500.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1315','1','1083','1','19500.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1316','1','1084','1','19000.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1317','1','1085','1','19500.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1318','1','1086','1','20000.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1319','1','1087','1','20000.00','0.00','2023-04-01 12:19:13','2023-04-01 12:19:13');
INSERT INTO invoice_items VALUES('1320','1','1088','1','26000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1321','1','1089','1','19000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1322','1','1090','1','19000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1323','1','1091','1','19000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1324','1','1092','1','19000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1325','1','1093','1','18500.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1365','1','1133','1','9350.00','0.00','2023-04-02 08:08:49','2023-04-02 08:08:49');
INSERT INTO invoice_items VALUES('1327','1','1095','1','19000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1328','1','1096','1','15000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1329','1','1097','1','21500.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1366','1','1098','1','19000.00','0.00','2023-04-07 12:06:16','2023-04-07 12:06:16');
INSERT INTO invoice_items VALUES('1331','1','1099','1','19000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1332','1','1100','1','23000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1333','1','1101','1','23000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1334','1','1102','1','19000.00','0.00','2023-04-01 12:19:14','2023-04-01 12:19:14');
INSERT INTO invoice_items VALUES('1335','1','1103','1','22000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1336','1','1104','1','21500.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1337','1','1105','1','21500.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1338','1','1106','1','19000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1339','1','1107','1','19000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1340','1','1108','1','19000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1341','1','1109','1','18500.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1342','1','1110','1','19000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1343','1','1111','1','19000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1344','1','1112','1','19000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1345','1','1113','1','19000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1346','1','1114','1','19000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1347','1','1115','1','21500.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1348','1','1116','1','20000.00','0.00','2023-04-01 12:19:15','2023-04-01 12:19:15');
INSERT INTO invoice_items VALUES('1349','1','1117','1','20000.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1350','1','1118','1','15000.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1351','1','1119','1','12000.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1352','1','1120','1','15000.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1353','1','1121','1','19000.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1354','1','1122','1','21500.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1355','1','1123','1','15000.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1356','1','1124','1','21500.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1382','1','1144','1','15000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1377','1','1139','1','20000.00','0.00','2023-04-12 18:22:34','2023-04-12 18:22:34');
INSERT INTO invoice_items VALUES('1383','1','1145','1','15000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1360','1','1128','1','21500.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1361','1','1129','1','19000.00','0.00','2023-04-01 12:19:16','2023-04-01 12:19:16');
INSERT INTO invoice_items VALUES('1378','1','1140','1','20000.00','0.00','2023-04-12 18:22:34','2023-04-12 18:22:34');
INSERT INTO invoice_items VALUES('1363','1','1131','1','21500.00','0.00','2023-04-01 12:19:17','2023-04-01 12:19:17');
INSERT INTO invoice_items VALUES('1384','1','1146','1','15000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1370','1','1135','1','21500.00','0.00','2023-04-07 15:20:30','2023-04-07 15:20:30');
INSERT INTO invoice_items VALUES('1374','1','1137','2','21000.00','0.00','2023-04-09 11:19:34','2023-04-09 11:19:34');
INSERT INTO invoice_items VALUES('1373','1','1137','1','14700.00','0.00','2023-04-09 11:19:34','2023-04-09 11:19:34');
INSERT INTO invoice_items VALUES('1375','1','1138','2','16000.00','0.00','2023-04-09 21:31:30','2023-04-09 21:31:30');
INSERT INTO invoice_items VALUES('1376','1','1138','2','23000.00','0.00','2023-04-09 21:31:30','2023-04-09 21:31:30');
INSERT INTO invoice_items VALUES('1385','1','1147','1','19500.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1386','1','1148','1','15000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1387','1','1149','1','19000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1388','1','1150','1','21000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1389','1','1151','1','19000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1390','1','1152','1','19000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1391','1','1153','1','21000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1392','1','1154','1','19500.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1393','1','1155','1','19500.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1394','1','1156','1','19000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1395','1','1157','1','19500.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1396','1','1158','1','20000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1397','1','1159','1','20000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1398','1','1160','1','26000.00','0.00','2023-05-07 12:12:30','2023-05-07 12:12:30');
INSERT INTO invoice_items VALUES('1399','1','1161','1','19000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1400','1','1162','1','19000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1401','1','1163','1','19000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1402','1','1164','1','19000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1403','1','1165','1','18500.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1404','1','1166','1','19000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1405','1','1167','1','15000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1406','1','1168','1','21500.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1407','1','1169','1','19000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1408','1','1170','1','19000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1409','1','1171','1','23000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1410','1','1172','1','23000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1411','1','1173','1','19000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1412','1','1174','1','22000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1413','1','1175','1','21500.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1414','1','1176','1','21500.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1415','1','1177','1','19000.00','0.00','2023-05-07 12:12:31','2023-05-07 12:12:31');
INSERT INTO invoice_items VALUES('1416','1','1178','1','19000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1449','1','1209','1','24500.00','0.00','2023-06-01 10:05:07','2023-06-01 10:05:07');
INSERT INTO invoice_items VALUES('1418','1','1180','1','18500.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1419','1','1181','1','19000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1420','1','1182','1','19000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1421','1','1183','1','19000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1422','1','1184','1','19000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1423','1','1185','1','19000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1424','1','1186','1','21500.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1450','1','1210','1','15000.00','0.00','2023-06-01 15:25:22','2023-06-01 15:25:22');
INSERT INTO invoice_items VALUES('1426','1','1188','1','20000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1427','1','1189','1','15000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1428','1','1190','1','12000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1429','1','1191','1','15000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1430','1','1192','1','19000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1431','1','1193','1','21500.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1432','1','1194','1','15000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1433','1','1195','1','21500.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1444','1','1205','1','20000.00','0.00','2023-05-11 10:08:13','2023-05-11 10:08:13');
INSERT INTO invoice_items VALUES('1435','1','1197','1','21500.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1436','1','1198','1','19000.00','0.00','2023-05-07 12:12:32','2023-05-07 12:12:32');
INSERT INTO invoice_items VALUES('1445','1','1206','1','20000.00','0.00','2023-05-11 10:08:13','2023-05-11 10:08:13');
INSERT INTO invoice_items VALUES('1438','1','1200','1','21500.00','0.00','2023-05-07 12:12:33','2023-05-07 12:12:33');
INSERT INTO invoice_items VALUES('1439','1','1201','1','21500.00','0.00','2023-05-07 12:12:33','2023-05-07 12:12:33');
INSERT INTO invoice_items VALUES('1440','1','1202','1','21000.00','0.00','2023-05-07 12:12:33','2023-05-07 12:12:33');
INSERT INTO invoice_items VALUES('1441','1','1203','1','23000.00','0.00','2023-05-07 12:12:33','2023-05-07 12:12:33');
INSERT INTO invoice_items VALUES('1442','1','1204','1','20000.00','0.00','2023-05-11 09:08:20','2023-05-11 09:08:20');
INSERT INTO invoice_items VALUES('1443','1','1204','2','20000.00','0.00','2023-05-11 09:08:20','2023-05-11 09:08:20');
INSERT INTO invoice_items VALUES('1447','1','1208','1','19000.00','0.00','2023-05-23 10:55:06','2023-05-23 10:55:06');
INSERT INTO invoice_items VALUES('1448','1','1208','2','15000.00','0.00','2023-05-23 10:55:06','2023-05-23 10:55:06');
INSERT INTO invoice_items VALUES('1451','1','1211','1','15000.00','0.00','2023-06-01 15:25:22','2023-06-01 15:25:22');
INSERT INTO invoice_items VALUES('1452','1','1212','1','15000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1453','1','1213','1','19500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1454','1','1214','1','15000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1455','1','1215','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1456','1','1216','1','21000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1457','1','1217','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1458','1','1218','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1459','1','1219','1','21000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1460','1','1220','1','19500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1461','1','1221','1','19500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1462','1','1222','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1463','1','1223','1','19500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1464','1','1224','1','20000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1465','1','1225','1','20000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1466','1','1226','1','26000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1467','1','1227','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1468','1','1228','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1469','1','1229','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1470','1','1230','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1471','1','1231','1','18500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1472','1','1232','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1473','1','1233','1','15000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1474','1','1234','1','21500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1475','1','1235','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1476','1','1236','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1477','1','1237','1','23000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1478','1','1238','1','23000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1479','1','1239','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1480','1','1240','1','22000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1481','1','1241','1','21500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1482','1','1242','1','21500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1483','1','1243','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1484','1','1244','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1485','1','1245','1','18500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1486','1','1246','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1487','1','1247','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1488','1','1248','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1489','1','1249','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1490','1','1250','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1491','1','1251','1','21500.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1492','1','1252','1','20000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1493','1','1253','1','15000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1494','1','1254','1','12000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1495','1','1255','1','15000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1496','1','1256','1','19000.00','0.00','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoice_items VALUES('1497','1','1257','1','21500.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1498','1','1258','1','15000.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1499','1','1259','1','21500.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1500','1','1260','1','20000.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1501','1','1261','1','21500.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1502','1','1262','1','19000.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1503','1','1263','1','20000.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1504','1','1264','1','21500.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1505','1','1265','1','21500.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1519','1','1273','1','10800.00','0.00','2023-06-13 17:59:16','2023-06-13 17:59:16');
INSERT INTO invoice_items VALUES('1507','1','1267','1','23000.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1508','1','1268','1','20000.00','0.00','2023-06-01 15:25:24','2023-06-01 15:25:24');
INSERT INTO invoice_items VALUES('1514','1','1272','1','20000.00','0.00','2023-06-05 09:07:29','2023-06-05 09:07:29');
INSERT INTO invoice_items VALUES('1510','1','1270','1','19000.00','0.00','2023-06-01 16:35:17','2023-06-01 16:35:17');
INSERT INTO invoice_items VALUES('1511','1','1270','2','19000.00','0.00','2023-06-01 16:35:17','2023-06-01 16:35:17');
INSERT INTO invoice_items VALUES('1512','1','1271','1','20000.00','0.00','2023-06-01 16:36:54','2023-06-01 16:36:54');
INSERT INTO invoice_items VALUES('1513','1','1271','2','20000.00','0.00','2023-06-01 16:36:54','2023-06-01 16:36:54');
INSERT INTO invoice_items VALUES('1520','1','1273','2','21500.00','0.00','2023-06-13 17:59:16','2023-06-13 17:59:16');
INSERT INTO invoice_items VALUES('1521','1','1274','1','17000.00','0.00','2023-06-14 15:41:38','2023-06-14 15:41:38');
INSERT INTO invoice_items VALUES('1522','1','1274','2','20000.00','0.00','2023-06-14 15:41:38','2023-06-14 15:41:38');
INSERT INTO invoice_items VALUES('1524','1','1275','2','20000.00','0.00','2023-06-15 08:36:41','2023-06-15 08:36:41');
INSERT INTO invoice_items VALUES('1525','1','1276','1','24500.00','0.00','2023-07-08 08:46:06','2023-07-08 08:46:06');
INSERT INTO invoice_items VALUES('1526','1','1277','1','15000.00','0.00','2023-07-08 08:46:06','2023-07-08 08:46:06');
INSERT INTO invoice_items VALUES('1527','1','1278','1','15000.00','0.00','2023-07-08 08:46:06','2023-07-08 08:46:06');
INSERT INTO invoice_items VALUES('1528','1','1279','1','15000.00','0.00','2023-07-08 08:46:06','2023-07-08 08:46:06');
INSERT INTO invoice_items VALUES('1529','1','1280','1','19500.00','0.00','2023-07-08 08:46:06','2023-07-08 08:46:06');
INSERT INTO invoice_items VALUES('1530','1','1281','1','15000.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1531','1','1282','1','19000.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1532','1','1283','1','21000.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1533','1','1284','1','19000.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1534','1','1285','1','19000.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1535','1','1286','1','21000.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1536','1','1287','1','19500.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1537','1','1288','1','19500.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1538','1','1289','1','19000.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1539','1','1290','1','19500.00','0.00','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoice_items VALUES('1540','1','1291','1','20000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1541','1','1292','1','20000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1542','1','1293','1','26000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1543','1','1294','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1544','1','1295','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1545','1','1296','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1546','1','1297','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1547','1','1298','1','18500.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1548','1','1299','1','25000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1549','1','1300','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1550','1','1301','1','15000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1551','1','1302','1','21500.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1552','1','1303','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1553','1','1304','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1554','1','1305','1','23000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1555','1','1306','1','23000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1556','1','1307','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1599','1','1308','2','12000.00','0.00','2023-07-09 09:17:00','2023-07-09 09:17:00');
INSERT INTO invoice_items VALUES('1671','1','1408','1','20000.00','0.00','2023-08-04 17:42:52','2023-08-04 17:42:52');
INSERT INTO invoice_items VALUES('1559','1','1310','1','21500.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1560','1','1311','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1561','1','1312','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1562','1','1313','1','18500.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1563','1','1314','1','19000.00','0.00','2023-07-08 08:46:08','2023-07-08 08:46:08');
INSERT INTO invoice_items VALUES('1564','1','1315','1','19000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1565','1','1316','1','19000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1566','1','1317','1','19000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1567','1','1318','1','19000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1568','1','1319','1','21500.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1569','1','1320','1','20000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1570','1','1321','1','15000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1571','1','1322','1','12000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1572','1','1323','1','15000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1573','1','1324','1','19000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1574','1','1325','1','21500.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1575','1','1326','1','15000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1576','1','1327','1','21500.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1577','1','1328','1','20000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1578','1','1329','1','21500.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1579','1','1330','1','19000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1580','1','1331','1','20000.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1581','1','1332','1','21500.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1582','1','1333','1','21500.00','0.00','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoice_items VALUES('1583','1','1334','1','23000.00','0.00','2023-07-08 08:46:10','2023-07-08 08:46:10');
INSERT INTO invoice_items VALUES('1584','1','1335','1','20000.00','0.00','2023-07-08 08:46:10','2023-07-08 08:46:10');
INSERT INTO invoice_items VALUES('1585','1','1336','1','20000.00','0.00','2023-07-08 08:46:10','2023-07-08 08:46:10');
INSERT INTO invoice_items VALUES('1586','1','1337','1','19000.00','0.00','2023-07-08 08:46:10','2023-07-08 08:46:10');
INSERT INTO invoice_items VALUES('1587','1','1338','1','20000.00','0.00','2023-07-08 08:46:10','2023-07-08 08:46:10');
INSERT INTO invoice_items VALUES('1604','1','1339','1','19000.00','0.00','2023-07-30 11:44:57','2023-07-30 11:44:57');
INSERT INTO invoice_items VALUES('1608','1','1345','1','15000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1598','1','1308','1','24000.00','0.00','2023-07-09 09:17:00','2023-07-09 09:17:00');
INSERT INTO invoice_items VALUES('1600','1','1341','1','23000.00','0.00','2023-07-22 07:46:08','2023-07-22 07:46:08');
INSERT INTO invoice_items VALUES('1601','1','1341','2','10000.00','0.00','2023-07-22 07:46:08','2023-07-22 07:46:08');
INSERT INTO invoice_items VALUES('1602','1','1342','2','25000.00','0.00','2023-07-26 14:35:39','2023-07-26 14:35:39');
INSERT INTO invoice_items VALUES('1603','1','1343','2','20000.00','0.00','2023-07-28 15:38:34','2023-07-28 15:38:34');
INSERT INTO invoice_items VALUES('1609','1','1346','1','15000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1610','1','1347','1','15000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1611','1','1348','1','19500.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1612','1','1349','1','15000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1613','1','1350','1','19000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1614','1','1351','1','21000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1615','1','1352','1','19000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1616','1','1353','1','19000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1617','1','1354','1','21000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1618','1','1355','1','19500.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1619','1','1356','1','19000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1620','1','1357','1','19500.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1621','1','1358','1','20000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1622','1','1359','1','20000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1623','1','1360','1','26000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1624','1','1361','1','19000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1625','1','1362','1','19000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1626','1','1363','1','19000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1627','1','1364','1','19000.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1628','1','1365','1','18500.00','0.00','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoice_items VALUES('1629','1','1366','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1630','1','1367','1','15000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1631','1','1368','1','21500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1632','1','1369','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1633','1','1370','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1634','1','1371','1','23000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1635','1','1372','1','23000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1636','1','1373','1','19500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1637','1','1374','1','25000.00','1000.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1638','1','1375','1','21500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1639','1','1376','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1640','1','1377','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1641','1','1378','1','18500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1642','1','1379','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1643','1','1380','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1644','1','1381','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1645','1','1382','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1646','1','1383','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1647','1','1384','1','21500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1648','1','1385','1','20000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1649','1','1386','1','15000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1650','1','1387','1','12000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1651','1','1388','1','15000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1652','1','1389','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1653','1','1390','1','21500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1654','1','1391','1','15000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1655','1','1392','1','21500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1656','1','1393','1','21500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1657','1','1394','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1658','1','1395','1','21500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1659','1','1396','1','21500.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1660','1','1397','1','20000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1661','1','1398','1','20000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1662','1','1399','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1663','1','1400','1','20000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1664','1','1401','1','19000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1665','1','1402','1','25000.00','2000.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1666','1','1403','1','25000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1667','1','1404','1','20000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1668','1','1405','1','22000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1669','1','1406','1','22000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoice_items VALUES('1670','1','1407','1','25000.00','0.00','2023-08-03 06:07:33','2023-08-03 06:07:33');



DROP TABLE IF EXISTS invoices;

CREATE TABLE `invoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `due_date` date NOT NULL,
  `payment_date` datetime DEFAULT NULL,
  `receipt_no` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(8,2) NOT NULL,
  `paid` decimal(8,2) DEFAULT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1410 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO invoices VALUES('1','1','1','1','8','1','2021-10-05','2021-10-05 09:30:28','','Security Fee','','20000.00','20000.00','Paid','2021-10-05 13:18:20','2021-10-05 13:30:28');
INSERT INTO invoices VALUES('31','1','1','1','9','1','2021-12-06','2021-12-17 16:52:27','','M/O DECEMBER 2021','','34000.00','17000.00','Unpaid','2021-12-05 17:56:02','2021-12-17 21:52:27');
INSERT INTO invoices VALUES('3','1','1','1','9','1','2021-11-05','2021-12-05 08:27:00','','M/O NOVEMBER 2021','','17000.00','17000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:27:00');
INSERT INTO invoices VALUES('4','1','2','1','2','1','2021-11-05','2021-12-05 09:08:33','','M/O NOVEMBER 2021','','23330.00','23330.00','Paid','2021-12-05 13:18:23','2021-12-05 14:08:33');
INSERT INTO invoices VALUES('5','1','3','2','15','1','2021-11-05','2021-12-05 08:34:14','','M/O NOVEMBER 2021','','22000.00','22000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:34:14');
INSERT INTO invoices VALUES('6','1','4','1','13','1','2021-11-05','2021-12-05 08:51:47','','M/O NOVEMBER 2021','','11000.00','11000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:51:47');
INSERT INTO invoices VALUES('32','1','2','1','2','1','2021-12-06','2021-12-07 06:16:34','','M/O DECEMBER 2021','','17500.00','17500.00','Paid','2021-12-05 17:56:02','2021-12-07 11:16:34');
INSERT INTO invoices VALUES('8','1','6','2','17','1','2021-11-05','2021-12-23 09:03:23','06','M/O NOVEMBER 2021','','50000.00','50000.00','Paid','2021-12-05 13:18:23','2021-12-23 14:03:23');
INSERT INTO invoices VALUES('9','1','7','1','3','1','2021-11-05','2021-12-05 09:12:08','','M/O NOVEMBER 2021','','24666.00','24666.00','Paid','2021-12-05 13:18:23','2021-12-05 14:12:08');
INSERT INTO invoices VALUES('10','1','8','1','1','1','2021-11-05','2021-12-05 08:30:59','','M/O NOVEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 13:18:23','2021-12-05 13:30:59');
INSERT INTO invoices VALUES('11','1','9','1','1','1','2021-11-05','2021-12-05 08:20:16','','M/O NOVEMBER 2021','','18000.00','18000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:20:16');
INSERT INTO invoices VALUES('12','1','10','1','1','1','2021-11-05','2021-12-05 09:25:55','','M/O NOVEMBER 2021','','18000.00','18000.00','Paid','2021-12-05 13:18:23','2021-12-05 14:25:55');
INSERT INTO invoices VALUES('13','1','11','1','2','1','2021-11-05','2021-12-05 11:26:44','','M/O NOVEMBER 2021','','10000.00','10000.00','Paid','2021-12-05 13:18:23','2021-12-05 16:26:44');
INSERT INTO invoices VALUES('14','1','12','1','3','1','2021-11-05','2021-12-05 09:28:09','','M/O NOVEMBER 2021','','17000.00','17000.00','Paid','2021-12-05 13:18:23','2021-12-05 14:28:09');
INSERT INTO invoices VALUES('15','1','13','1','3','1','2021-11-05','2021-12-05 13:11:18','','M/O NOVEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 13:18:23','2021-12-05 18:11:18');
INSERT INTO invoices VALUES('16','1','14','1','5','1','2021-11-05','2021-12-05 08:55:19','','M/O NOVEMBER 2021','','38000.00','38000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:55:19');
INSERT INTO invoices VALUES('17','1','15','1','7','1','2021-11-05','2021-12-05 09:04:01','','M/O NOVEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 13:18:23','2021-12-05 14:04:01');
INSERT INTO invoices VALUES('18','1','16','1','7','1','2021-11-05','2021-12-05 09:03:33','','M/O NOVEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 13:18:23','2021-12-05 14:03:33');
INSERT INTO invoices VALUES('19','1','17','1','7','1','2021-11-05','2021-12-05 09:01:48','','M/O NOVEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 13:18:23','2021-12-05 14:01:48');
INSERT INTO invoices VALUES('20','1','18','1','7','1','2021-11-05','2021-12-05 09:03:05','','M/O NOVEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 13:18:23','2021-12-05 14:03:05');
INSERT INTO invoices VALUES('21','1','19','1','8','1','2021-11-05','2021-12-05 08:32:07','','M/O NOVEMBER 2021','','18000.00','18000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:32:07');
INSERT INTO invoices VALUES('22','1','20','1','8','1','2021-11-05','2021-12-05 08:54:15','','M/O NOVEMBER 2021','','10000.00','10000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:54:15');
INSERT INTO invoices VALUES('23','1','21','1','8','1','2021-11-05','2021-12-05 09:32:36','','M/O NOVEMBER 2021','','27750.00','27750.00','Paid','2021-12-05 13:18:23','2021-12-05 14:32:36');
INSERT INTO invoices VALUES('24','1','22','1','9','1','2021-11-05','2021-12-05 08:23:18','','M/O NOVEMBER 2021','','17000.00','17000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:23:18');
INSERT INTO invoices VALUES('25','1','23','1','9','1','2021-11-05','2021-12-05 08:26:31','','M/O NOVEMBER 2021','','17000.00','17000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:26:31');
INSERT INTO invoices VALUES('26','1','24','1','9','1','2021-11-05','2021-12-05 12:53:56','','M/O NOVEMBER 2021','','18000.00','18000.00','Paid','2021-12-05 13:18:23','2021-12-05 17:53:56');
INSERT INTO invoices VALUES('27','1','25','1','10','1','2021-11-05','2021-12-05 09:24:42','','M/O NOVEMBER 2021','','34000.00','34000.00','Paid','2021-12-05 13:18:23','2021-12-05 14:24:42');
INSERT INTO invoices VALUES('28','1','26','1','10','1','2021-11-05','2021-12-05 08:25:09','','M/O NOVEMBER 2021','','18000.00','18000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:25:09');
INSERT INTO invoices VALUES('29','1','27','1','10','1','2021-11-05','2021-12-05 08:25:51','','M/O NOVEMBER 2021','','17000.00','17000.00','Paid','2021-12-05 13:18:23','2021-12-05 13:25:51');
INSERT INTO invoices VALUES('30','1','29','1','5','1','2021-11-05','2021-12-05 11:50:57','','M/O NOVEMBER 2021','ONE MONTH STAY','18000.00','18000.00','Paid','2021-12-05 16:50:11','2021-12-05 16:50:57');
INSERT INTO invoices VALUES('33','1','3','2','15','1','2021-12-06','2021-12-17 16:53:25','','M/O DECEMBER 2021','','22000.00','22000.00','Paid','2021-12-05 17:56:02','2021-12-17 21:53:25');
INSERT INTO invoices VALUES('34','1','4','1','2','1','2021-12-06','2021-12-08 13:40:58','','M/O DECEMBER 2021','','17500.00','17500.00','Paid','2021-12-05 17:56:02','2021-12-08 18:40:58');
INSERT INTO invoices VALUES('35','1','6','2','17','1','2021-12-06','2021-12-23 08:58:21','','M/O DECEMBER 2021','','50000.00','50000.00','Paid','2021-12-05 17:56:02','2021-12-23 13:58:21');
INSERT INTO invoices VALUES('36','1','7','1','3','1','2021-12-06','2021-12-07 06:06:15','','M/O DECEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 17:56:02','2021-12-07 11:06:15');
INSERT INTO invoices VALUES('37','1','8','1','1','1','2021-12-06','2021-12-08 13:39:33','','M/O DECEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 17:56:02','2021-12-08 18:39:33');
INSERT INTO invoices VALUES('38','1','9','1','1','1','2021-12-06','2021-12-08 13:47:51','','M/O DECEMBER 2021','','18000.00','18000.00','Paid','2021-12-05 17:56:02','2021-12-08 18:47:51');
INSERT INTO invoices VALUES('39','1','10','1','1','1','2021-12-06','2021-12-17 16:53:51','','M/O DECEMBER 2021','','18000.00','18000.00','Paid','2021-12-05 17:56:02','2021-12-17 21:53:51');
INSERT INTO invoices VALUES('40','1','11','1','2','1','2021-12-06','2021-12-07 06:22:16','','M/O DECEMBER 2021','','17000.00','17000.00','Paid','2021-12-05 17:56:02','2021-12-07 11:22:16');
INSERT INTO invoices VALUES('68','1','39','1','3','1','2021-12-10','2021-12-17 15:50:44','','M/O DEC-12','3000 PAID IN AMBASSADOR','15000.00','15000.00','Paid','2021-12-17 20:46:06','2021-12-17 20:50:44');
INSERT INTO invoices VALUES('42','1','13','1','3','1','2021-12-06','2021-12-07 06:07:33','','M/O DECEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 17:56:02','2021-12-07 11:07:33');
INSERT INTO invoices VALUES('43','1','14','1','5','1','2021-12-06','2021-12-17 16:54:31','','M/O DECEMBER 2021','','19000.00','19000.00','Paid','2021-12-05 17:56:02','2021-12-17 21:54:31');
INSERT INTO invoices VALUES('44','1','15','1','7','1','2021-12-06','2021-12-09 06:20:49','','M/O DECEMBER 2021','','15000.00','15000.00','Paid','2021-12-05 17:56:02','2021-12-09 11:20:49');
INSERT INTO invoices VALUES('45','1','16','1','7','1','2021-12-06','2021-12-17 16:55:41','','M/O DECEMBER 2021','','15000.00','15000.00','Paid','2021-12-05 17:56:02','2021-12-17 21:55:41');
INSERT INTO invoices VALUES('46','1','17','1','7','1','2021-12-06','2021-12-07 06:06:39','','M/O DECEMBER 2021','','15000.00','15000.00','Paid','2021-12-05 17:56:02','2021-12-07 11:06:39');
INSERT INTO invoices VALUES('47','1','18','1','7','1','2021-12-06','2021-12-17 16:56:06','','M/O DECEMBER 2021','','15000.00','15000.00','Paid','2021-12-05 17:56:02','2021-12-17 21:56:06');
INSERT INTO invoices VALUES('48','1','19','1','8','1','2021-12-06','2021-12-08 14:11:50','','M/O DECEMBER 2021','','18000.00','18000.00','Paid','2021-12-05 17:56:02','2021-12-08 19:11:50');
INSERT INTO invoices VALUES('49','1','20','1','8','1','2021-12-06','2021-12-08 12:43:13','','M/O DECEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 17:56:02','2021-12-08 17:43:13');
INSERT INTO invoices VALUES('50','1','21','1','8','1','2021-12-06','2021-12-08 14:06:57','','M/O DECEMBER 2021','','18500.00','18500.00','Paid','2021-12-05 17:56:02','2021-12-08 19:06:57');
INSERT INTO invoices VALUES('51','1','22','1','9','1','2021-12-06','2021-12-08 13:44:14','','M/O DECEMBER 2021','','34000.00','34000.00','Paid','2021-12-05 17:56:02','2021-12-08 18:44:14');
INSERT INTO invoices VALUES('52','1','23','1','9','1','2021-12-06','2021-12-08 13:44:56','','M/O DECEMBER 2021','','34000.00','34000.00','Paid','2021-12-05 17:56:02','2021-12-08 18:44:56');
INSERT INTO invoices VALUES('53','1','24','1','9','1','2021-12-06','2021-12-08 13:42:05','','M/O DECEMBER 2021','','34000.00','34000.00','Paid','2021-12-05 17:56:02','2021-12-08 18:42:05');
INSERT INTO invoices VALUES('54','1','25','1','10','1','2021-12-06','2021-12-07 05:53:26','','M/O DECEMBER 2021','','17000.00','17000.00','Paid','2021-12-05 17:56:02','2021-12-07 10:53:26');
INSERT INTO invoices VALUES('55','1','26','1','10','1','2021-12-06','2021-12-08 13:42:51','','M/O DECEMBER 2021','','34000.00','34000.00','Paid','2021-12-05 17:56:02','2021-12-08 18:42:51');
INSERT INTO invoices VALUES('56','1','27','1','10','1','2021-12-06','2021-12-17 17:15:56','','M/O DECEMBER 2021','','34000.00','17000.00','Unpaid','2021-12-05 17:56:02','2021-12-17 22:15:56');
INSERT INTO invoices VALUES('57','1','29','1','5','1','2021-12-06','2022-02-06 15:19:48','','M/O DECEMBER 2021','','38000.00','38000.00','Paid','2021-12-05 17:56:02','2022-02-06 20:19:48');
INSERT INTO invoices VALUES('58','1','30','1','4','1','2021-12-06','2021-12-07 05:59:20','','M/O DECEMBER 2021','','25000.00','25000.00','Paid','2021-12-05 17:56:02','2021-12-07 10:59:20');
INSERT INTO invoices VALUES('59','1','31','1','4','1','2021-12-06','2022-02-05 13:02:16','','M/O DECEMBER 2021','','34000.00','34000.00','Paid','2021-12-05 17:56:02','2022-02-05 18:02:16');
INSERT INTO invoices VALUES('60','1','32','1','4','1','2021-12-06','2022-03-05 05:46:59','','M/O DECEMBER 2021','','34000.00','34000.00','Paid','2021-12-05 17:56:02','2022-03-05 10:46:59');
INSERT INTO invoices VALUES('61','1','28','1','11','1','2021-12-06','2021-12-07 06:45:50','','M/O DECEMBER2021','AMIR ALI SB REFRENCE LESS 1500 DUE TO CINEMA VENDOR EACH MONTH','26000.00','26000.00','Paid','2021-12-07 11:44:25','2021-12-07 11:45:50');
INSERT INTO invoices VALUES('62','1','33','1','2','1','2021-12-06','2021-12-07 07:16:11','','M/O DECEMBER 2021','','17500.00','17500.00','Paid','2021-12-07 12:15:02','2021-12-07 12:16:11');
INSERT INTO invoices VALUES('63','1','34','1','11','1','2021-12-07','2021-12-07 16:04:21','','M/O DECEMBER 2021','','30000.00','30000.00','Paid','2021-12-07 18:37:47','2021-12-07 21:04:21');
INSERT INTO invoices VALUES('64','1','35','1','7','1','2021-12-07','2021-12-17 17:01:44','','M/O DECEMBER 2021','','15000.00','15000.00','Paid','2021-12-08 11:30:02','2021-12-17 22:01:44');
INSERT INTO invoices VALUES('65','1','36','1','12','1','2021-12-07','2021-12-17 17:22:09','','M/O DECEMBER 2021','RELAXATION BY JAVED SIR','29500.00','29500.00','Paid','2021-12-08 18:16:11','2021-12-17 22:22:09');
INSERT INTO invoices VALUES('66','1','37','1','12','1','2021-12-08','2021-12-17 17:21:53','','M/O DECEMBER 2021','','29500.00','29500.00','Paid','2021-12-09 10:40:27','2021-12-17 22:21:53');
INSERT INTO invoices VALUES('67','1','38','1','11','1','2021-12-09','2021-12-17 16:50:41','','M/O DECEMBER 2021','21 DAYS STAY','27000.00','27000.00','Paid','2021-12-09 19:17:44','2021-12-17 21:50:41');
INSERT INTO invoices VALUES('69','1','40','1','11','1','2021-12-10','2021-12-17 16:48:49','','M/O DEC-21','','17000.00','17000.00','Paid','2021-12-17 20:46:53','2021-12-17 21:48:49');
INSERT INTO invoices VALUES('141','1','35','1','7','1','2022-01-05','2022-01-06 07:52:21','','M/O JAN2022','','15000.00','15000.00','Paid','2022-01-02 21:02:35','2022-01-06 12:52:21');
INSERT INTO invoices VALUES('307','1','14','1','5','1','2022-04-05','2022-04-18 08:11:14','','APR/22','PAY 10 DAYS','6000.00','6000.00','Paid','2022-04-18 08:10:25','2022-04-18 08:11:14');
INSERT INTO invoices VALUES('110','1','1','1','9','1','2022-01-05','','','M/O JAN2022','','17000.00','','Unpaid','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoices VALUES('111','1','2','1','2','1','2022-01-05','2022-01-06 06:23:14','','M/O JAN2022','','17500.00','17500.00','Paid','2022-01-02 21:02:35','2022-01-06 11:23:14');
INSERT INTO invoices VALUES('112','1','3','2','15','1','2022-01-05','2022-01-06 12:35:23','','M/O JAN2022','','22000.00','22000.00','Paid','2022-01-02 21:02:35','2022-01-06 17:35:23');
INSERT INTO invoices VALUES('113','1','4','1','2','1','2022-01-05','2022-01-06 07:56:02','','M/O JAN2022','','17500.00','17500.00','Paid','2022-01-02 21:02:35','2022-01-06 12:56:02');
INSERT INTO invoices VALUES('1141','1','3','2','14','1','2023-04-05','2023-04-12 18:27:25','','APR/23','','24500.00','24500.00','Paid','2023-04-12 18:26:08','2023-04-12 18:27:25');
INSERT INTO invoices VALUES('115','1','7','1','3','1','2022-01-05','2022-01-03 07:52:50','','M/O JAN2022','','18500.00','18500.00','Paid','2022-01-02 21:02:35','2022-01-03 12:52:50');
INSERT INTO invoices VALUES('116','1','8','1','1','1','2022-01-05','2022-01-07 06:35:38','','M/O JAN2022','','18500.00','18500.00','Paid','2022-01-02 21:02:35','2022-01-07 11:35:38');
INSERT INTO invoices VALUES('117','1','9','1','1','1','2022-01-05','2022-01-07 06:34:52','','M/O JAN2022','','18000.00','18000.00','Paid','2022-01-02 21:02:35','2022-01-07 11:34:52');
INSERT INTO invoices VALUES('118','1','10','1','1','1','2022-01-05','2022-01-10 06:17:48','','M/O JAN2022','','18000.00','18000.00','Paid','2022-01-02 21:02:35','2022-01-10 11:17:48');
INSERT INTO invoices VALUES('119','1','11','1','2','1','2022-01-05','2022-01-07 13:02:16','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-07 18:02:16');
INSERT INTO invoices VALUES('120','1','13','1','3','1','2022-01-05','2022-01-03 07:54:55','','M/O JAN2022','','18500.00','18500.00','Paid','2022-01-02 21:02:35','2022-01-03 12:54:55');
INSERT INTO invoices VALUES('121','1','14','1','5','1','2022-01-05','2022-01-15 10:35:59','','M/O JAN2022','','19000.00','19000.00','Paid','2022-01-02 21:02:35','2022-01-15 15:35:59');
INSERT INTO invoices VALUES('122','1','15','1','7','1','2022-01-05','2022-01-06 06:29:59','','M/O JAN2022','','15000.00','15000.00','Paid','2022-01-02 21:02:35','2022-01-06 11:29:59');
INSERT INTO invoices VALUES('123','1','16','1','7','1','2022-01-05','2022-01-06 12:38:26','','M/O JAN2022','','15000.00','15000.00','Paid','2022-01-02 21:02:35','2022-01-06 17:38:26');
INSERT INTO invoices VALUES('124','1','17','1','7','1','2022-01-05','2022-01-06 08:13:00','','M/O JAN2022','','15000.00','15000.00','Paid','2022-01-02 21:02:35','2022-01-06 13:13:00');
INSERT INTO invoices VALUES('125','1','18','1','7','1','2022-01-05','2022-01-06 06:29:05','','M/O JAN2022','','15000.00','15000.00','Paid','2022-01-02 21:02:35','2022-01-06 11:29:05');
INSERT INTO invoices VALUES('126','1','19','1','8','1','2022-01-05','2022-01-07 08:45:17','','M/O JAN2022','','18000.00','18000.00','Paid','2022-01-02 21:02:35','2022-01-07 13:45:17');
INSERT INTO invoices VALUES('127','1','20','1','8','1','2022-01-05','2022-01-06 12:44:06','','M/O JAN2022','','18500.00','18500.00','Paid','2022-01-02 21:02:35','2022-01-06 17:44:06');
INSERT INTO invoices VALUES('128','1','21','1','8','1','2022-01-05','2022-01-03 07:59:13','','M/O JAN2022','','18500.00','18500.00','Paid','2022-01-02 21:02:35','2022-01-03 12:59:13');
INSERT INTO invoices VALUES('129','1','22','1','9','1','2022-01-05','2022-01-08 12:50:05','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-08 17:50:05');
INSERT INTO invoices VALUES('130','1','23','1','9','1','2022-01-05','2022-01-05 14:00:48','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-05 19:00:48');
INSERT INTO invoices VALUES('131','1','24','1','9','1','2022-01-05','2022-01-05 14:01:23','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-05 19:01:23');
INSERT INTO invoices VALUES('132','1','25','1','10','1','2022-01-05','2022-01-06 06:32:12','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-06 11:32:12');
INSERT INTO invoices VALUES('133','1','26','1','10','1','2022-01-05','2022-01-05 13:58:53','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-05 18:58:53');
INSERT INTO invoices VALUES('134','1','27','1','10','1','2022-01-05','2022-01-06 07:00:43','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-06 12:00:43');
INSERT INTO invoices VALUES('135','1','29','1','5','1','2022-01-05','2022-01-06 07:58:45','','M/O JAN2022','','19000.00','19000.00','Paid','2022-01-02 21:02:35','2022-01-06 12:58:45');
INSERT INTO invoices VALUES('136','1','30','1','6','1','2022-01-05','2022-01-06 06:19:30','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-06 11:19:30');
INSERT INTO invoices VALUES('137','1','31','1','6','1','2022-01-05','2022-01-10 06:16:20','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-10 11:16:20');
INSERT INTO invoices VALUES('138','1','32','1','6','1','2022-01-05','2022-01-10 06:17:00','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-10 11:17:00');
INSERT INTO invoices VALUES('139','1','33','1','2','1','2022-01-05','2022-01-07 06:34:05','','M/O JAN2022','','17500.00','17500.00','Paid','2022-01-02 21:02:35','2022-01-07 11:34:05');
INSERT INTO invoices VALUES('107','1','41','1','11','1','2012-07-13','2022-01-02 11:58:23','','M/O JAN2022','','34000.00','34000.00','Paid','2021-12-31 13:11:37','2022-01-02 16:58:23');
INSERT INTO invoices VALUES('142','1','36','1','12','1','2022-01-05','2022-01-08 12:51:04','','M/O JAN2022','','22000.00','22000.00','Paid','2022-01-02 21:02:35','2022-01-08 17:51:04');
INSERT INTO invoices VALUES('143','1','37','1','12','1','2022-01-05','2022-01-08 07:55:41','','M/O JAN2022','','22000.00','22000.00','Paid','2022-01-02 21:02:35','2022-01-08 12:55:41');
INSERT INTO invoices VALUES('144','1','38','1','11','1','2022-01-05','2022-01-06 06:14:15','','M/O JAN2022','','17000.00','17000.00','Paid','2022-01-02 21:02:35','2022-01-06 11:14:15');
INSERT INTO invoices VALUES('145','1','39','1','3','1','2022-01-05','','','M/O JAN2022','','18000.00','','Unpaid','2022-01-02 21:02:35','2022-01-02 21:02:35');
INSERT INTO invoices VALUES('146','1','40','1','4','1','2022-01-05','2022-01-03 07:48:03','','M/O JAN2022','','20000.00','20000.00','Paid','2022-01-02 21:02:35','2022-01-03 12:48:03');
INSERT INTO invoices VALUES('151','1','45','1','8','1','2021-12-10','2022-01-02 16:34:55','','M/O DECEMBER 2021','','24500.00','24500.00','Paid','2022-01-02 21:33:40','2022-01-02 21:34:55');
INSERT INTO invoices VALUES('153','1','42','1','4','1','2022-01-01','2022-01-03 08:13:50','','M/O JAN 2022','','17500.00','17500.00','Paid','2022-01-03 13:12:57','2022-01-03 13:13:50');
INSERT INTO invoices VALUES('149','1','43','1','4','1','2022-01-05','2022-01-03 07:44:33','','M/O JAN2022','','28000.00','28000.00','Paid','2022-01-02 21:02:35','2022-01-03 12:44:33');
INSERT INTO invoices VALUES('150','1','44','1','11','1','2022-01-05','2022-01-03 07:57:39','','M/O JAN2022','','22500.00','22500.00','Paid','2022-01-02 21:02:35','2022-01-03 12:57:39');
INSERT INTO invoices VALUES('152','1','45','1','8','1','2022-01-05','2022-01-06 06:21:12','','M/O JAN2022','','18500.00','18500.00','Paid','2022-01-02 21:37:07','2022-01-06 11:21:12');
INSERT INTO invoices VALUES('154','1','47','1','10','1','2022-01-09','2022-01-10 06:32:53','','M/O JANVARY','','35000.00','29000.00','Unpaid','2022-01-10 11:30:27','2022-01-10 11:32:53');
INSERT INTO invoices VALUES('155','1','48','2','16','1','2022-01-11','2022-01-12 11:26:26','','M/O JANUARY 2022','','20000.00','20000.00','Paid','2022-01-12 16:25:29','2022-01-12 16:26:26');
INSERT INTO invoices VALUES('156','1','49','1','10','1','2022-01-23','2022-01-23 14:16:32','','MONTH OF JANVARY','','20000.00','20000.00','Paid','2022-01-23 19:14:00','2022-01-23 19:16:32');
INSERT INTO invoices VALUES('157','1','50','1','8','1','2022-01-25','2022-01-27 15:30:26','','M/O JANUARY 2022','8  DAYS RENT PAY','19800.00','19800.00','Paid','2022-01-27 20:28:57','2022-01-27 20:30:26');
INSERT INTO invoices VALUES('158','1','51','1','8','1','2022-01-23','2022-01-28 15:56:42','','PAY ONLY 8 DAYS.','','19800.00','19800.00','Paid','2022-01-28 20:54:51','2022-01-28 20:56:42');
INSERT INTO invoices VALUES('159','1','52','1','8','1','2022-01-23','2022-01-31 15:29:47','','ONLY 8 DAYS PAY','','14500.00','14500.00','Paid','2022-01-31 20:27:27','2022-01-31 20:29:47');
INSERT INTO invoices VALUES('160','1','1','1','9','1','2022-02-05','','','M/O FEBRUARY 2022','','17000.00','','Unpaid','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoices VALUES('161','1','3','2','15','1','2022-02-05','2022-02-20 07:41:03','','M/O FEBRUARY 2022','','22500.00','22500.00','Paid','2022-02-02 17:04:09','2022-02-20 12:41:03');
INSERT INTO invoices VALUES('162','1','4','1','2','1','2022-02-05','2022-02-03 12:22:48','','M/O FEBRUARY 2022','','17500.00','17500.00','Paid','2022-02-02 17:04:09','2022-02-03 17:22:48');
INSERT INTO invoices VALUES('163','1','6','2','17','1','2022-02-05','','','M/O FEBRUARY 2022','','50000.00','','Unpaid','2022-02-02 17:04:09','2022-02-02 17:04:09');
INSERT INTO invoices VALUES('164','1','7','1','3','1','2022-02-05','2022-02-05 12:56:08','','M/O FEBRUARY 2022','','18500.00','18500.00','Paid','2022-02-02 17:04:09','2022-02-05 17:56:08');
INSERT INTO invoices VALUES('165','1','8','1','1','1','2022-02-05','2022-02-04 08:00:09','','M/O FEBRUARY 2022','','18500.00','18500.00','Paid','2022-02-02 17:04:09','2022-02-04 13:00:09');
INSERT INTO invoices VALUES('166','1','9','1','1','1','2022-02-05','2022-02-17 12:56:07','','M/O FEBRUARY 2022','','18000.00','18000.00','Paid','2022-02-02 17:04:09','2022-02-17 17:56:07');
INSERT INTO invoices VALUES('167','1','10','1','1','1','2022-02-05','2022-02-23 13:18:46','','M/O FEBRUARY 2022','','18000.00','18000.00','Paid','2022-02-02 17:04:09','2022-02-23 18:18:46');
INSERT INTO invoices VALUES('168','1','13','1','3','1','2022-02-05','2022-02-04 08:02:31','','M/O FEBRUARY 2022','','18500.00','18500.00','Paid','2022-02-02 17:04:09','2022-02-04 13:02:31');
INSERT INTO invoices VALUES('169','1','14','1','5','1','2022-02-05','2022-02-20 06:19:41','','M/O FEBRUARY 2022','','19000.00','19000.00','Paid','2022-02-02 17:04:09','2022-02-20 11:19:41');
INSERT INTO invoices VALUES('170','1','15','1','7','1','2022-02-05','2022-02-04 08:01:25','','M/O FEBRUARY 2022','','15000.00','15000.00','Paid','2022-02-02 17:04:09','2022-02-04 13:01:25');
INSERT INTO invoices VALUES('171','1','16','1','7','1','2022-02-05','2022-02-17 12:52:09','','M/O FEBRUARY 2022','','15000.00','15000.00','Paid','2022-02-02 17:04:09','2022-02-17 17:52:09');
INSERT INTO invoices VALUES('172','1','17','1','7','1','2022-02-05','2022-02-06 05:16:42','','M/O FEBRUARY 2022','','15000.00','15000.00','Paid','2022-02-02 17:04:09','2022-02-06 10:16:42');
INSERT INTO invoices VALUES('173','1','18','1','7','1','2022-02-05','2022-02-04 08:00:40','','M/O FEBRUARY 2022','','15000.00','15000.00','Paid','2022-02-02 17:04:09','2022-02-04 13:00:40');
INSERT INTO invoices VALUES('174','1','21','1','8','1','2022-02-05','2022-02-02 13:10:10','','M/O FEBRUARY 2022','','18500.00','18500.00','Paid','2022-02-02 17:04:09','2022-02-02 18:10:10');
INSERT INTO invoices VALUES('175','1','22','1','9','1','2022-02-05','2022-02-03 11:28:00','','M/O FEBRUARY 2022','','17000.00','17000.00','Paid','2022-02-02 17:04:09','2022-02-03 16:28:00');
INSERT INTO invoices VALUES('176','1','23','1','9','1','2022-02-05','2022-02-03 11:00:35','','M/O FEBRUARY 2022','','17000.00','17000.00','Paid','2022-02-02 17:04:09','2022-02-03 16:00:35');
INSERT INTO invoices VALUES('177','1','24','1','9','1','2022-02-05','2022-02-17 12:54:14','','M/O FEBRUARY 2022','','17000.00','17000.00','Paid','2022-02-02 17:04:09','2022-02-17 17:54:14');
INSERT INTO invoices VALUES('178','1','25','1','10','1','2022-02-05','2022-02-04 08:02:05','','M/O FEBRUARY 2022','','17000.00','17000.00','Paid','2022-02-02 17:04:09','2022-02-04 13:02:05');
INSERT INTO invoices VALUES('179','1','26','1','10','1','2022-02-05','2022-02-05 12:47:39','','M/O FEBRUARY 2022','','17000.00','17000.00','Paid','2022-02-02 17:04:09','2022-02-05 17:47:39');
INSERT INTO invoices VALUES('180','1','27','1','10','1','2022-02-05','2022-02-17 11:13:31','','M/O FEBRUARY 2022','','17000.00','17000.00','Paid','2022-02-02 17:04:09','2022-02-17 16:13:31');
INSERT INTO invoices VALUES('181','1','29','1','6','1','2022-02-05','2022-02-04 08:04:02','','M/O FEBRUARY 2022','','17500.00','17000.00','Unpaid','2022-02-02 17:04:09','2022-02-04 13:04:02');
INSERT INTO invoices VALUES('182','1','30','1','6','1','2022-02-05','2022-02-20 07:30:55','','M/O FEBRUARY 2022','','25000.00','25000.00','Paid','2022-02-02 17:04:09','2022-02-20 12:30:55');
INSERT INTO invoices VALUES('183','1','32','1','6','1','2022-02-05','2022-02-26 11:59:22','','M/O FEBRUARY 2022','','25000.00','17000.00','Paid','2022-02-02 17:04:09','2022-02-26 17:00:58');
INSERT INTO invoices VALUES('251','1','62','1','10','1','2022-03-05','2022-03-05 12:07:52','','MAR/22','','35000.00','35000.00','Paid','2022-03-05 17:05:55','2022-03-05 17:07:52');
INSERT INTO invoices VALUES('185','1','35','1','7','1','2022-02-05','2022-02-05 12:55:37','','M/O FEBRUARY 2022','','15000.00','15000.00','Paid','2022-02-02 17:04:09','2022-02-05 17:55:37');
INSERT INTO invoices VALUES('186','1','36','1','12','1','2022-02-05','2022-02-17 12:57:45','','M/O FEBRUARY 2022','','22000.00','22000.00','Paid','2022-02-02 17:04:09','2022-02-17 17:57:45');
INSERT INTO invoices VALUES('187','1','37','1','12','1','2022-02-05','2022-02-20 06:00:49','','M/O FEBRUARY 2022','','22000.00','22000.00','Paid','2022-02-02 17:04:09','2022-02-20 11:00:49');
INSERT INTO invoices VALUES('188','1','38','1','11','1','2022-02-05','2022-02-17 11:30:03','','M/O FEBRUARY 2022','','17000.00','17000.00','Paid','2022-02-02 17:04:09','2022-02-17 16:30:03');
INSERT INTO invoices VALUES('189','1','46','1','4','1','2022-02-05','2022-02-06 05:15:38','','M/O FEBRUARY 2022','','19000.00','19000.00','Paid','2022-02-02 17:04:09','2022-02-06 10:15:38');
INSERT INTO invoices VALUES('190','1','42','1','4','1','2022-02-05','2022-02-17 12:50:57','','M/O FEBRUARY 2022','','19000.00','19000.00','Paid','2022-02-02 17:04:09','2022-02-17 17:50:57');
INSERT INTO invoices VALUES('191','1','43','1','4','1','2022-02-05','2022-02-17 12:57:18','','M/O FEBRUARY 2022','','17500.00','17500.00','Paid','2022-02-02 17:04:09','2022-02-17 17:57:18');
INSERT INTO invoices VALUES('192','1','44','1','11','1','2022-02-05','2022-02-17 11:26:03','','M/O FEBRUARY 2022','','17500.00','17500.00','Paid','2022-02-02 17:04:09','2022-02-17 16:26:03');
INSERT INTO invoices VALUES('193','1','40','1','4','1','2022-02-05','2022-02-20 07:26:07','','M/O FEBRUARY 2022','','21000.00','21000.00','Paid','2022-02-02 17:04:09','2022-02-20 12:26:07');
INSERT INTO invoices VALUES('559','1','46','2','15','1','2022-08-10','2022-08-13 07:26:52','','AUG/22','','2185.00','2185.00','Paid','2022-08-13 07:25:25','2022-08-13 07:26:52');
INSERT INTO invoices VALUES('195','1','49','1','10','1','2022-02-05','2022-02-17 12:53:37','','M/O FEBRUARY 2022','','17000.00','17000.00','Paid','2022-02-02 17:04:09','2022-02-17 17:53:37');
INSERT INTO invoices VALUES('196','1','50','1','8','1','2022-02-05','2022-02-02 12:51:03','','M/O FEBRUARY 2022','','18000.00','18000.00','Paid','2022-02-02 17:04:09','2022-02-02 17:51:03');
INSERT INTO invoices VALUES('198','1','53','1','11','1','2022-02-05','2022-02-02 12:50:24','','M/O FEBRUARY 2022','','32500.00','32500.00','Paid','2022-02-02 17:04:09','2022-02-02 17:50:24');
INSERT INTO invoices VALUES('199','1','54','1','2','1','2022-02-04','2022-02-06 05:14:13','','M/O FEBRUARY','','35000.00','35000.00','Paid','2022-02-03 17:52:11','2022-02-06 10:14:13');
INSERT INTO invoices VALUES('200','1','14','1','5','1','2022-02-09','2022-02-17 11:25:40','','M/O FEB 2022','20 DAYS STAY','19000.00','19000.00','Paid','2022-02-12 20:47:49','2022-02-17 16:25:40');
INSERT INTO invoices VALUES('201','1','55','1','5','1','2022-02-09','2022-02-20 08:19:20','','M/O FEB','','22000.00','22000.00','Paid','2022-02-20 13:13:43','2022-02-20 13:19:20');
INSERT INTO invoices VALUES('202','1','56','1','2','1','2022-02-13','2022-02-20 08:44:23','','M/O FEB','','29170.00','29170.00','Paid','2022-02-20 13:42:52','2022-02-20 13:44:23');
INSERT INTO invoices VALUES('203','1','57','1','3','1','2022-02-05','2022-02-20 14:38:45','','M/O FEB','','28500.00','28500.00','Paid','2022-02-20 19:37:41','2022-02-20 19:38:45');
INSERT INTO invoices VALUES('204','1','58','1','4','1','2022-02-05','2022-02-20 15:20:43','','M/O FEB','','29200.00','29200.00','Paid','2022-02-20 19:52:40','2022-02-20 20:20:43');
INSERT INTO invoices VALUES('205','1','51','1','8','1','2022-02-05','2022-02-20 15:33:21','','M/O FEB','','18000.00','18000.00','Paid','2022-02-20 20:24:13','2022-02-20 20:33:21');
INSERT INTO invoices VALUES('206','1','59','1','2','1','2022-02-22','2022-02-22 09:03:54','','PAY ONLY 5 DAYS','','5500.00','5500.00','Paid','2022-02-22 14:03:07','2022-02-22 14:03:54');
INSERT INTO invoices VALUES('207','1','60','1','2','1','2022-02-22','2022-02-23 13:19:01','','PAY ONLY 5 DAYS','','5500.00','5500.00','Paid','2022-02-22 14:09:23','2022-02-23 18:19:01');
INSERT INTO invoices VALUES('208','1','32','1','6','1','2022-02-20','2022-02-26 11:46:00','','M/O FEB','','8000.00','8000.00','Paid','2022-02-26 16:42:41','2022-02-26 16:46:00');
INSERT INTO invoices VALUES('209','1','3','2','14','1','2022-03-05','2022-04-01 09:04:03','','MAR/22','','22500.00','22500.00','Paid','2022-03-03 11:38:36','2022-04-01 09:04:03');
INSERT INTO invoices VALUES('210','1','4','1','2','1','2022-03-05','2022-03-03 15:16:25','','MAR/22','','17500.00','17500.00','Paid','2022-03-03 11:38:36','2022-03-03 20:16:25');
INSERT INTO invoices VALUES('211','1','7','1','3','1','2022-03-05','2022-03-05 09:41:54','','MAR/22','','18500.00','18500.00','Paid','2022-03-03 11:38:36','2022-03-05 14:41:54');
INSERT INTO invoices VALUES('212','1','8','1','1','1','2022-03-05','2022-03-12 07:07:25','','MAR/22','','18500.00','18500.00','Paid','2022-03-03 11:38:36','2022-03-12 12:07:25');
INSERT INTO invoices VALUES('213','1','9','1','1','1','2022-03-05','2022-03-14 13:43:48','','MAR/22','','18000.00','18000.00','Paid','2022-03-03 11:38:36','2022-03-14 13:43:48');
INSERT INTO invoices VALUES('214','1','10','1','1','1','2022-03-05','2022-03-14 13:43:00','','MAR/22','','18000.00','18000.00','Paid','2022-03-03 11:38:36','2022-03-14 13:43:00');
INSERT INTO invoices VALUES('215','1','13','1','3','1','2022-03-05','2022-03-03 15:17:02','','MAR/22','','18500.00','18500.00','Paid','2022-03-03 11:38:36','2022-03-03 20:17:02');
INSERT INTO invoices VALUES('308','1','71','1','16','1','2022-04-16','2022-04-23 14:59:54','','APR/22','','25000.00','25000.00','Paid','2022-04-23 14:58:46','2022-04-23 14:59:54');
INSERT INTO invoices VALUES('217','1','15','1','7','1','2022-03-05','2022-03-12 08:07:38','','MAR/22','','15000.00','15000.00','Paid','2022-03-03 11:38:36','2022-03-12 13:07:38');
INSERT INTO invoices VALUES('218','1','16','1','7','1','2022-03-05','2022-03-14 13:42:10','','MAR/22','','15000.00','15000.00','Paid','2022-03-03 11:38:36','2022-03-14 13:42:10');
INSERT INTO invoices VALUES('219','1','17','1','7','1','2022-03-05','2022-03-12 08:07:04','','MAR/22','','15000.00','15000.00','Paid','2022-03-03 11:38:36','2022-03-12 13:07:04');
INSERT INTO invoices VALUES('220','1','18','1','7','1','2022-03-05','2022-03-12 08:06:38','','MAR/22','','15000.00','15000.00','Paid','2022-03-03 11:38:36','2022-03-12 13:06:38');
INSERT INTO invoices VALUES('221','1','21','1','8','1','2022-03-05','2022-03-03 07:01:22','','MAR/22','','18500.00','18500.00','Paid','2022-03-03 11:38:36','2022-03-03 12:01:22');
INSERT INTO invoices VALUES('222','1','22','1','9','1','2022-03-05','2022-03-12 07:58:58','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-12 12:58:58');
INSERT INTO invoices VALUES('223','1','23','1','9','1','2022-03-05','2022-03-12 07:30:23','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-12 12:30:23');
INSERT INTO invoices VALUES('224','1','24','1','9','1','2022-03-05','2022-03-12 07:17:27','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-12 12:17:27');
INSERT INTO invoices VALUES('225','1','25','1','10','1','2022-03-05','2022-03-05 09:54:11','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-05 14:54:11');
INSERT INTO invoices VALUES('226','1','26','1','10','1','2022-03-05','2022-03-12 07:39:29','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-12 12:39:29');
INSERT INTO invoices VALUES('227','1','27','1','10','1','2022-03-05','2022-03-12 08:06:12','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-12 13:06:12');
INSERT INTO invoices VALUES('228','1','29','1','6','1','2022-03-05','2022-03-12 08:20:41','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-12 13:20:41');
INSERT INTO invoices VALUES('229','1','30','1','6','1','2022-03-05','2022-03-03 15:15:49','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-03 20:15:49');
INSERT INTO invoices VALUES('230','1','31','1','6','1','2022-03-05','2022-03-03 16:01:27','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-03 21:01:27');
INSERT INTO invoices VALUES('231','1','32','1','6','1','2022-03-05','2022-03-05 05:47:26','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-05 10:47:26');
INSERT INTO invoices VALUES('232','1','35','1','7','1','2022-03-05','2022-03-12 08:08:08','','MAR/22','','15000.00','15000.00','Paid','2022-03-03 11:38:36','2022-03-12 13:08:08');
INSERT INTO invoices VALUES('233','1','36','1','12','1','2022-03-05','2022-03-12 07:23:04','','MAR/22','','22000.00','22000.00','Paid','2022-03-03 11:38:36','2022-03-12 12:23:04');
INSERT INTO invoices VALUES('234','1','37','1','12','1','2022-03-05','2022-03-12 07:17:52','','MAR/22','','22000.00','22000.00','Paid','2022-03-03 11:38:36','2022-03-12 12:17:52');
INSERT INTO invoices VALUES('235','1','38','1','11','1','2022-03-05','2022-04-09 14:19:49','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-04-09 14:19:49');
INSERT INTO invoices VALUES('236','1','40','1','4','1','2022-03-05','2022-03-12 07:36:49','','MAR/22','','17500.00','17500.00','Paid','2022-03-03 11:38:36','2022-03-12 12:36:49');
INSERT INTO invoices VALUES('237','1','42','2','15','1','2022-03-05','2022-03-03 07:01:58','','MAR/22','','19000.00','19000.00','Paid','2022-03-03 11:38:36','2022-03-03 12:01:58');
INSERT INTO invoices VALUES('238','1','43','1','4','1','2022-03-05','2022-03-12 07:36:22','','MAR/22','','17500.00','17500.00','Paid','2022-03-03 11:38:36','2022-03-12 12:36:22');
INSERT INTO invoices VALUES('239','1','44','1','11','1','2022-03-05','2022-03-04 14:57:05','','MAR/22','','17500.00','17500.00','Paid','2022-03-03 11:38:36','2022-03-04 19:57:05');
INSERT INTO invoices VALUES('240','1','46','1','4','1','2022-03-05','2022-03-03 07:04:33','','MAR/22','','19000.00','19000.00','Paid','2022-03-03 11:38:36','2022-03-03 12:04:33');
INSERT INTO invoices VALUES('241','1','49','1','10','1','2022-03-05','2022-03-05 10:02:35','','MAR/22','','17000.00','17000.00','Paid','2022-03-03 11:38:36','2022-03-05 15:02:35');
INSERT INTO invoices VALUES('242','1','50','1','8','1','2022-03-05','2022-03-12 07:06:29','','MAR/22','','18000.00','18000.00','Paid','2022-03-03 11:38:36','2022-03-12 12:06:29');
INSERT INTO invoices VALUES('243','1','53','1','11','1','2022-03-05','2022-03-04 14:56:18','','MAR/22','','17500.00','17500.00','Paid','2022-03-03 11:38:36','2022-03-04 19:56:18');
INSERT INTO invoices VALUES('309','1','72','1','18','1','2022-04-22','2022-04-28 08:40:21','','APR/22','','45000.00','45000.00','Paid','2022-04-28 08:39:48','2022-04-28 08:40:21');
INSERT INTO invoices VALUES('245','1','55','1','5','1','2022-03-05','','','MAR/22','','19000.00','','Unpaid','2022-03-03 11:38:36','2022-03-12 13:23:19');
INSERT INTO invoices VALUES('246','1','57','1','3','1','2022-03-05','2022-03-12 08:17:06','','MAR/22','','14000.00','14000.00','Paid','2022-03-03 11:38:36','2022-03-12 13:17:06');
INSERT INTO invoices VALUES('247','1','58','1','4','1','2022-03-05','2022-03-12 07:35:53','','MAR/22','','17500.00','17500.00','Paid','2022-03-03 11:50:03','2022-03-12 12:35:53');
INSERT INTO invoices VALUES('248','1','56','1','11','1','2022-03-05','2022-03-12 08:05:12','','MAR/22','','17500.00','17500.00','Paid','2022-03-03 11:50:49','2022-03-12 13:05:12');
INSERT INTO invoices VALUES('249','1','51','1','8','1','2022-03-05','2022-03-12 07:06:05','','MAR/22','','18000.00','18000.00','Paid','2022-03-03 11:52:48','2022-03-12 12:06:05');
INSERT INTO invoices VALUES('250','1','61','1','2','1','2022-03-05','2022-03-03 07:17:37','','MAR/22','','27500.00','27500.00','Paid','2022-03-03 12:16:38','2022-03-03 12:17:37');
INSERT INTO invoices VALUES('252','1','60','1','2','1','2022-03-05','2022-03-12 07:13:36','','MAR/22','','17000.00','16000.00','Unpaid','2022-03-12 12:12:37','2022-03-12 12:13:36');
INSERT INTO invoices VALUES('253','1','59','1','2','1','2022-03-05','2022-03-12 07:16:39','','MAR/22','','17000.00','16000.00','Unpaid','2022-03-12 12:15:24','2022-03-12 12:16:39');
INSERT INTO invoices VALUES('254','1','63','1','8','1','2022-02-05','2022-03-12 10:08:04','','M/O FEB 22','','21000.00','21000.00','Paid','2022-03-12 15:07:17','2022-03-12 15:08:04');
INSERT INTO invoices VALUES('255','1','63','1','8','1','2022-03-05','2022-03-12 10:18:47','','MAR/22','','18000.00','18000.00','Paid','2022-03-12 15:10:33','2022-03-12 15:18:47');
INSERT INTO invoices VALUES('256','1','64','1','11','1','2022-03-05','2022-03-12 10:32:13','','MAR/22','','16000.00','16000.00','Paid','2022-03-12 15:31:14','2022-03-12 15:32:13');
INSERT INTO invoices VALUES('257','1','65','1','1','1','2022-03-05','2022-03-15 07:30:16','','MAR/22','PAY ONLY 
17 DAYS','28900.00','28900.00','Paid','2022-03-15 07:07:09','2022-03-15 07:30:16');
INSERT INTO invoices VALUES('258','1','66','1','1','1','2022-03-05','2022-03-15 07:40:39','','MAR/22','PAY ONLY 20 DAYS','30800.00','30800.00','Paid','2022-03-15 07:39:48','2022-03-15 07:40:39');
INSERT INTO invoices VALUES('259','1','3','2','14','1','2022-04-05','2022-05-10 15:00:12','','APR/22','','22500.00','22500.00','Paid','2022-04-04 07:23:17','2022-05-10 15:00:12');
INSERT INTO invoices VALUES('260','1','4','1','2','1','2022-04-05','2022-04-04 07:30:01','','APR/22','','17500.00','17500.00','Paid','2022-04-04 07:23:17','2022-04-04 07:30:01');
INSERT INTO invoices VALUES('261','1','7','1','3','1','2022-04-05','2022-04-08 09:14:08','','APR/22','','18500.00','18500.00','Paid','2022-04-04 07:23:17','2022-04-08 09:14:08');
INSERT INTO invoices VALUES('262','1','8','1','1','1','2022-04-05','2022-04-05 14:40:30','','APR/22','','18500.00','18500.00','Paid','2022-04-04 07:23:17','2022-04-05 14:40:30');
INSERT INTO invoices VALUES('263','1','70','1','3','1','2022-04-05','2022-04-08 10:44:15','','APR/22','','18500.00','18500.00','Paid','2022-04-04 07:23:17','2022-04-08 10:44:15');
INSERT INTO invoices VALUES('264','1','15','1','7','1','2022-04-05','2022-04-09 13:09:03','','APR/22','','15000.00','15000.00','Paid','2022-04-04 07:23:17','2022-04-09 13:09:03');
INSERT INTO invoices VALUES('265','1','16','1','7','1','2022-04-05','2022-04-09 13:09:22','','APR/22','','15000.00','15000.00','Paid','2022-04-04 07:23:17','2022-04-09 13:09:22');
INSERT INTO invoices VALUES('266','1','17','1','7','1','2022-04-05','2022-04-09 13:08:46','','APR/22','','15000.00','15000.00','Paid','2022-04-04 07:23:17','2022-04-09 13:08:46');
INSERT INTO invoices VALUES('267','1','18','1','7','1','2022-04-05','2022-04-09 13:08:20','','APR/22','','15000.00','15000.00','Paid','2022-04-04 07:23:17','2022-04-09 13:08:20');
INSERT INTO invoices VALUES('268','1','21','1','8','1','2022-04-05','2022-04-04 07:30:29','','APR/22','','18500.00','18500.00','Paid','2022-04-04 07:23:17','2022-04-04 07:30:29');
INSERT INTO invoices VALUES('269','1','22','1','9','1','2022-04-05','2022-04-05 14:26:30','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-04-05 14:26:30');
INSERT INTO invoices VALUES('270','1','23','1','9','1','2022-04-05','2022-04-05 14:29:15','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-04-05 14:29:15');
INSERT INTO invoices VALUES('271','1','24','1','9','1','2022-04-05','2022-04-05 14:31:48','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-04-05 14:31:48');
INSERT INTO invoices VALUES('272','1','25','1','10','1','2022-04-05','2022-05-10 15:21:10','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-05-10 15:21:10');
INSERT INTO invoices VALUES('273','1','26','1','9','1','2022-04-05','2022-04-05 14:32:17','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-04-05 14:32:17');
INSERT INTO invoices VALUES('274','1','27','1','10','1','2022-04-05','2022-04-08 10:49:24','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-04-08 10:49:24');
INSERT INTO invoices VALUES('275','1','29','1','6','1','2022-04-05','2022-04-18 08:13:05','','APR/22','','17500.00','17000.00','Unpaid','2022-04-04 07:23:17','2022-04-18 08:13:05');
INSERT INTO invoices VALUES('276','1','30','1','6','1','2022-04-05','2022-04-18 08:13:29','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-04-18 08:13:29');
INSERT INTO invoices VALUES('277','1','31','1','6','1','2022-04-05','2022-04-18 08:13:50','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-04-18 08:13:50');
INSERT INTO invoices VALUES('278','1','32','1','6','1','2022-04-05','2022-04-18 08:14:07','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-04-18 08:14:07');
INSERT INTO invoices VALUES('279','1','35','1','7','1','2022-04-05','2022-04-13 08:38:12','','APR/22','','15000.00','15000.00','Paid','2022-04-04 07:23:17','2022-04-13 08:38:12');
INSERT INTO invoices VALUES('280','1','36','1','12','1','2022-04-05','2022-04-12 12:09:30','','APR/22','','22000.00','22000.00','Paid','2022-04-04 07:23:17','2022-04-12 12:09:30');
INSERT INTO invoices VALUES('281','1','37','1','12','1','2022-04-05','2022-04-09 13:33:44','','APR/22','','22000.00','22000.00','Paid','2022-04-04 07:23:17','2022-04-09 13:33:44');
INSERT INTO invoices VALUES('282','1','38','1','11','1','2022-04-05','2022-04-13 08:37:43','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:17','2022-04-13 08:37:43');
INSERT INTO invoices VALUES('283','1','40','1','4','1','2022-04-05','2022-04-06 11:38:45','','APR/22','','17500.00','17500.00','Paid','2022-04-04 07:23:17','2022-04-06 11:38:45');
INSERT INTO invoices VALUES('284','1','42','2','15','1','2022-04-05','2022-04-04 07:24:51','','APR/22','','19000.00','19000.00','Paid','2022-04-04 07:23:17','2022-04-04 07:24:51');
INSERT INTO invoices VALUES('285','1','43','1','4','1','2022-04-05','2022-04-16 12:23:13','','APR/22','','17500.00','17500.00','Paid','2022-04-04 07:23:17','2022-04-16 12:23:13');
INSERT INTO invoices VALUES('286','1','44','1','11','1','2022-04-05','2022-04-08 09:14:40','','APR/22','','17500.00','17500.00','Paid','2022-04-04 07:23:17','2022-04-08 09:14:40');
INSERT INTO invoices VALUES('287','1','46','2','15','1','2022-04-05','2022-04-04 07:28:25','','APR/22','','19000.00','19000.00','Paid','2022-04-04 07:23:17','2023-07-30 12:39:18');
INSERT INTO invoices VALUES('288','1','49','1','10','1','2022-04-05','2022-04-08 11:05:01','','APR/22','','17000.00','17000.00','Paid','2022-04-04 07:23:18','2022-04-08 11:05:01');
INSERT INTO invoices VALUES('289','1','50','1','8','1','2022-04-05','2022-04-16 12:24:37','','APR/22','','18000.00','18000.00','Paid','2022-04-04 07:23:18','2022-04-16 12:24:37');
INSERT INTO invoices VALUES('290','1','51','1','8','1','2022-04-05','2023-04-07 12:34:04','','APR/22','','18000.00','18000.00','Paid','2022-04-04 07:23:18','2023-04-07 12:34:04');
INSERT INTO invoices VALUES('291','1','53','1','11','1','2022-04-05','2022-04-05 14:56:51','','APR/22','','17500.00','17500.00','Paid','2022-04-04 07:23:18','2022-04-05 14:56:51');
INSERT INTO invoices VALUES('292','1','56','1','4','1','2022-04-05','2022-04-08 09:18:13','','APR/22','','17500.00','17500.00','Paid','2022-04-04 07:23:18','2022-04-08 09:18:13');
INSERT INTO invoices VALUES('293','1','58','1','4','1','2022-04-05','2022-04-10 14:18:28','','APR/22','','17500.00','17500.00','Paid','2022-04-04 07:23:18','2022-04-10 14:18:28');
INSERT INTO invoices VALUES('294','1','59','1','2','1','2022-04-05','2022-04-08 09:27:25','','APR/22','','16500.00','16500.00','Paid','2022-04-04 07:23:18','2022-04-08 09:27:25');
INSERT INTO invoices VALUES('295','1','60','1','2','1','2022-04-05','2022-04-08 09:28:52','','APR/22','','16500.00','16500.00','Paid','2022-04-04 07:23:18','2022-04-08 09:28:52');
INSERT INTO invoices VALUES('296','1','61','1','2','1','2022-04-05','','','APR/22','','17500.00','','Unpaid','2022-04-04 07:23:18','2022-04-04 07:23:18');
INSERT INTO invoices VALUES('304','1','68','1','5','1','2022-04-05','2022-04-06 13:59:34','','APR/22','','20000.00','20000.00','Paid','2022-04-06 11:50:22','2022-04-06 13:59:34');
INSERT INTO invoices VALUES('298','1','63','1','8','1','2022-05-05','2022-06-11 13:12:27','','MAY/22','','18000.00','18000.00','Paid','2022-04-04 07:23:18','2022-06-11 13:13:10');
INSERT INTO invoices VALUES('299','1','64','1','11','1','2022-04-05','2022-04-16 12:24:15','','APR/22','','16000.00','16000.00','Paid','2022-04-04 07:23:18','2022-04-16 12:24:15');
INSERT INTO invoices VALUES('300','1','65','1','1','1','2022-04-05','2022-04-05 14:41:03','','APR/22','','18500.00','18500.00','Paid','2022-04-04 07:23:18','2022-04-05 14:41:03');
INSERT INTO invoices VALUES('301','1','66','1','1','1','2022-04-05','2022-04-05 14:35:41','','APR/22','','18500.00','18500.00','Paid','2022-04-04 07:23:18','2022-04-05 14:35:41');
INSERT INTO invoices VALUES('302','1','67','1','5','1','2022-04-05','2022-04-06 13:58:57','','APR/22','','20000.00','20000.00','Paid','2022-04-04 11:45:56','2022-04-06 13:58:57');
INSERT INTO invoices VALUES('303','1','62','1','10','1','2022-04-05','2022-04-05 14:56:20','','APR/22','','17000.00','17000.00','Paid','2022-04-05 14:53:13','2022-04-05 14:56:20');
INSERT INTO invoices VALUES('305','1','69','1','3','1','2022-04-05','2022-04-08 09:34:23','','APR/22','','18500.00','18500.00','Paid','2022-04-08 09:33:51','2022-04-08 09:34:23');
INSERT INTO invoices VALUES('310','1','3','2','14','1','2022-05-05','2022-05-10 15:00:42','','MAY/22','','22500.00','22500.00','Paid','2022-05-08 13:42:09','2022-05-10 15:00:42');
INSERT INTO invoices VALUES('311','1','4','1','2','1','2022-05-05','2022-05-10 15:01:28','','MAY/22','','17500.00','17500.00','Paid','2022-05-08 13:42:09','2022-05-10 15:01:28');
INSERT INTO invoices VALUES('312','1','7','1','3','1','2022-05-05','2022-05-10 15:12:34','','MAY/22','','18500.00','18500.00','Paid','2022-05-08 13:42:09','2022-05-10 15:12:34');
INSERT INTO invoices VALUES('313','1','8','1','1','1','2022-05-05','2022-05-23 07:52:35','','MAY/22','','18500.00','18500.00','Paid','2022-05-08 13:42:09','2022-05-23 07:52:35');
INSERT INTO invoices VALUES('314','1','15','1','7','1','2022-05-05','2022-05-11 07:15:15','','MAY/22','','15000.00','15000.00','Paid','2022-05-08 13:42:09','2022-05-11 07:15:15');
INSERT INTO invoices VALUES('315','1','16','1','7','1','2022-05-05','2022-05-23 07:54:37','','MAY/22','','15000.00','15000.00','Paid','2022-05-08 13:42:09','2022-05-23 07:54:37');
INSERT INTO invoices VALUES('316','1','17','1','7','1','2022-05-05','2022-05-10 15:03:03','','MAY/22','','15000.00','15000.00','Paid','2022-05-08 13:42:09','2022-05-10 15:03:03');
INSERT INTO invoices VALUES('317','1','18','1','7','1','2022-05-05','2022-05-10 15:02:35','','MAY/22','','15000.00','15000.00','Paid','2022-05-08 13:42:09','2022-05-10 15:02:35');
INSERT INTO invoices VALUES('318','1','21','1','8','1','2022-05-05','2022-05-10 14:45:16','','MAY/22','','18500.00','18500.00','Paid','2022-05-08 13:42:09','2022-05-10 14:45:16');
INSERT INTO invoices VALUES('319','1','22','1','9','1','2022-05-05','2022-05-10 15:15:57','','MAY/22','','17000.00','17000.00','Paid','2022-05-08 13:42:09','2022-05-10 15:15:57');
INSERT INTO invoices VALUES('320','1','23','1','9','1','2022-05-05','2022-05-23 07:50:23','','MAY/22','','17000.00','17000.00','Paid','2022-05-08 13:42:09','2022-05-23 07:50:23');
INSERT INTO invoices VALUES('321','1','24','1','9','1','2022-05-05','2022-05-23 07:55:08','','MAY/22','','17000.00','17000.00','Paid','2022-05-08 13:42:09','2022-05-23 07:55:08');
INSERT INTO invoices VALUES('322','1','25','1','10','1','2022-05-05','2022-05-10 15:22:28','','MAY/22','','17000.00','17000.00','Paid','2022-05-08 13:42:09','2022-05-10 15:22:28');
INSERT INTO invoices VALUES('323','1','26','1','9','1','2022-05-05','2022-05-23 07:43:48','','MAY/22','','17000.00','17000.00','Paid','2022-05-08 13:42:09','2022-05-23 07:43:48');
INSERT INTO invoices VALUES('324','1','27','1','10','1','2022-05-05','2022-05-23 07:47:16','','MAY/22','','17000.00','17000.00','Paid','2022-05-08 13:42:09','2022-05-23 07:47:16');
INSERT INTO invoices VALUES('325','1','29','1','6','1','2022-05-05','','','MAY/22','','17500.00','','Unpaid','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoices VALUES('326','1','30','1','6','1','2022-05-05','','','MAY/22','','17000.00','','Unpaid','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoices VALUES('327','1','31','1','6','1','2022-05-05','','','MAY/22','','17000.00','','Unpaid','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoices VALUES('328','1','32','1','6','1','2022-05-05','','','MAY/22','','17000.00','','Unpaid','2022-05-08 13:42:09','2022-05-08 13:42:09');
INSERT INTO invoices VALUES('329','1','35','1','7','1','2022-05-05','2022-05-29 08:40:09','','MAY/22','','15000.00','15000.00','Paid','2022-05-08 13:42:09','2022-05-29 08:40:09');
INSERT INTO invoices VALUES('330','1','36','1','12','1','2022-05-05','2022-05-23 07:46:12','','MAY/22','','22000.00','22000.00','Paid','2022-05-08 13:42:09','2022-05-23 07:46:12');
INSERT INTO invoices VALUES('331','1','37','1','12','1','2022-05-05','2022-05-23 07:58:30','','MAY/22','','22000.00','22000.00','Paid','2022-05-08 13:42:09','2022-05-23 07:58:30');
INSERT INTO invoices VALUES('332','1','38','1','11','1','2022-05-05','2022-05-25 12:10:33','','MAY/22','','17000.00','17000.00','Paid','2022-05-08 13:42:09','2022-05-25 12:10:33');
INSERT INTO invoices VALUES('333','1','40','1','4','1','2022-05-05','2022-05-10 14:48:00','','MAY/22','','17500.00','17500.00','Paid','2022-05-08 13:42:09','2022-05-10 14:48:00');
INSERT INTO invoices VALUES('335','1','43','1','4','1','2022-05-05','2022-05-10 15:20:48','','MAY/22','','17500.00','17500.00','Paid','2022-05-08 13:42:09','2022-05-10 15:20:48');
INSERT INTO invoices VALUES('336','1','44','1','11','1','2022-05-05','2022-05-23 07:51:06','','MAY/22','','17500.00','17500.00','Paid','2022-05-08 13:42:09','2022-05-23 07:51:06');
INSERT INTO invoices VALUES('337','1','46','2','15','1','2022-05-05','2022-05-10 14:58:15','','MAY/22','','19000.00','19000.00','Paid','2022-05-08 13:42:09','2022-05-10 14:58:15');
INSERT INTO invoices VALUES('338','1','49','1','10','1','2022-05-05','2022-05-23 07:48:58','','MAY/22','','17500.00','17000.00','Unpaid','2022-05-08 13:42:09','2022-05-23 07:48:58');
INSERT INTO invoices VALUES('339','1','50','1','8','1','2022-05-05','2022-06-11 13:00:51','','MAY/22','','18000.00','18000.00','Paid','2022-05-08 13:42:09','2022-06-11 13:00:51');
INSERT INTO invoices VALUES('340','1','51','1','8','1','2022-05-05','2022-05-23 07:53:19','','MAY/22','','18000.00','18000.00','Paid','2022-05-08 13:42:09','2022-05-23 07:53:19');
INSERT INTO invoices VALUES('341','1','53','1','11','1','2022-05-05','2022-05-23 07:51:50','','MAY/22','','17500.00','17500.00','Paid','2022-05-08 13:42:09','2022-05-23 07:51:50');
INSERT INTO invoices VALUES('342','1','56','1','4','1','2022-05-05','2022-06-04 06:39:16','','MAY/22','','17500.00','17500.00','Paid','2022-05-08 13:42:09','2022-06-04 06:39:16');
INSERT INTO invoices VALUES('343','1','58','1','4','1','2022-05-05','2022-05-10 14:45:43','','MAY/22','','17500.00','17500.00','Paid','2022-05-08 13:42:09','2022-05-10 14:45:43');
INSERT INTO invoices VALUES('344','1','59','1','2','1','2022-05-05','2022-05-29 08:41:02','','MAY/22','','16500.00','10000.00','Unpaid','2022-05-08 13:42:09','2022-05-29 08:41:02');
INSERT INTO invoices VALUES('345','1','60','1','2','1','2022-05-05','2022-05-29 08:41:46','','MAY/22','','17000.00','10000.00','Unpaid','2022-05-08 13:42:09','2022-05-29 08:41:46');
INSERT INTO invoices VALUES('346','1','62','1','10','1','2022-05-05','2022-05-10 15:16:56','','MAY/22','','17000.00','17000.00','Paid','2022-05-08 13:42:09','2022-05-10 15:16:56');
INSERT INTO invoices VALUES('347','1','64','1','11','1','2022-05-05','2022-05-23 11:39:40','','MAY/22','','16000.00','16000.00','Paid','2022-05-08 13:42:09','2022-05-23 11:39:40');
INSERT INTO invoices VALUES('348','1','65','1','1','1','2022-05-05','2022-05-10 15:07:43','','MAY/22','','18500.00','18500.00','Paid','2022-05-08 13:42:09','2022-05-10 15:07:43');
INSERT INTO invoices VALUES('349','1','66','1','1','1','2022-05-05','2022-05-10 15:12:05','','MAY/22','','18500.00','18500.00','Paid','2022-05-08 13:42:09','2022-05-10 15:12:05');
INSERT INTO invoices VALUES('350','1','67','1','5','1','2022-05-05','2022-05-10 15:20:28','','MAY/22','','20000.00','20000.00','Paid','2022-05-08 13:42:09','2022-05-10 15:20:28');
INSERT INTO invoices VALUES('351','1','68','1','5','1','2022-05-05','2022-05-10 15:19:05','','MAY/22','','20000.00','20000.00','Paid','2022-05-08 13:42:09','2022-05-10 15:19:05');
INSERT INTO invoices VALUES('352','1','69','1','3','1','2022-05-05','2022-05-23 07:49:32','','MAY/22','','18500.00','18500.00','Paid','2022-05-08 13:42:09','2022-05-23 07:49:32');
INSERT INTO invoices VALUES('353','1','70','1','3','1','2022-05-05','2022-05-11 12:42:32','','MAY/22','','18500.00','18500.00','Paid','2022-05-08 13:42:09','2022-05-11 12:42:32');
INSERT INTO invoices VALUES('354','1','71','1','16','1','2022-05-05','2022-05-10 15:09:57','','MAY/22','','20000.00','20000.00','Paid','2022-05-08 13:42:09','2022-05-10 15:09:57');
INSERT INTO invoices VALUES('355','1','72','1','18','1','2022-05-05','2023-04-07 12:12:52','','MAY/22','Due to month days rent adjust','4000.00','4000.00','Paid','2022-05-08 13:42:09','2023-04-07 12:12:52');
INSERT INTO invoices VALUES('356','1','46','2','15','1','2022-04-05','2022-05-10 14:58:36','','APR/22','','4000.00','4000.00','Paid','2022-05-10 14:53:31','2022-05-10 14:58:36');
INSERT INTO invoices VALUES('357','1','73','1','6','1','2022-05-05','2022-05-11 07:13:08','','MAY/22','ONLY 20 DAYS','29000.00','29000.00','Paid','2022-05-10 15:32:28','2022-05-11 07:13:08');
INSERT INTO invoices VALUES('358','1','74','1','6','1','2022-05-11','2022-05-23 07:56:55','','MAY/22','PAY ONLY 20 DAYS','29000.00','29000.00','Paid','2022-05-11 07:12:11','2022-05-23 07:56:55');
INSERT INTO invoices VALUES('359','1','75','1','6','1','2022-05-10','2022-06-11 13:04:40','','MAY/22','PAY ONLY 20 DAYS','29000.00','29000.00','Paid','2022-05-11 07:35:01','2022-06-11 13:04:40');
INSERT INTO invoices VALUES('360','1','76','1','2','1','2022-05-10','2022-05-11 12:41:19','','MAY/22','','29000.00','11500.00','Unpaid','2022-05-11 12:12:46','2022-05-11 12:41:19');
INSERT INTO invoices VALUES('361','1','77','1','6','1','2022-05-10','2022-05-30 13:27:59','','MAY/22','','29000.00','29000.00','Paid','2022-05-11 12:36:50','2022-05-30 13:27:59');
INSERT INTO invoices VALUES('362','1','78','3','17','1','2022-05-15','2022-05-23 07:55:51','','MAY /22','','30000.00','30000.00','Paid','2022-05-22 12:59:12','2022-05-23 07:55:51');
INSERT INTO invoices VALUES('363','1','79','1','16','1','2022-05-22','2022-07-03 08:04:33','','MAY/ 22','','25000.00','25000.00','Paid','2022-05-22 13:12:46','2022-07-03 08:04:33');
INSERT INTO invoices VALUES('364','1','80','3','13','1','2022-05-20','2022-05-23 08:13:46','','MAY/ 22','ONLY 10 DAYS PAY','10000.00','10000.00','Paid','2022-05-23 08:12:38','2022-05-23 08:13:46');
INSERT INTO invoices VALUES('365','1','81','3','13','1','2022-05-25','2022-08-19 10:24:16','','PAY ONLY SEVEN DAYS','','22000.00','22000.00','Paid','2022-05-31 07:51:39','2022-08-19 10:24:16');
INSERT INTO invoices VALUES('366','1','82','3','17','1','2022-05-20','2022-06-02 10:37:56','','MAY/22','','30000.00','20000.00','Unpaid','2022-06-02 10:36:19','2022-06-02 10:37:56');
INSERT INTO invoices VALUES('367','1','3','2','14','1','2022-06-05','2023-07-30 11:54:21','','JUN/22','','22500.00','22500.00','Paid','2022-06-02 11:02:03','2023-07-30 11:54:21');
INSERT INTO invoices VALUES('368','1','4','1','2','1','2022-06-05','2022-06-04 06:08:23','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:03','2022-06-04 06:08:23');
INSERT INTO invoices VALUES('369','1','7','1','3','1','2022-06-05','2022-06-06 13:04:29','','JUN/22','','18500.00','18500.00','Paid','2022-06-02 11:02:03','2022-06-06 13:04:29');
INSERT INTO invoices VALUES('370','1','8','1','1','1','2022-06-05','2022-06-06 06:43:27','','JUN/22','','18500.00','18500.00','Paid','2022-06-02 11:02:03','2022-06-06 06:43:27');
INSERT INTO invoices VALUES('371','1','15','1','7','1','2022-06-05','2022-06-10 14:35:55','','JUN/22','','15000.00','15000.00','Paid','2022-06-02 11:02:04','2022-06-10 14:35:55');
INSERT INTO invoices VALUES('372','1','16','1','7','1','2022-06-05','2022-06-06 12:59:40','','JUN/22','','15000.00','15000.00','Paid','2022-06-02 11:02:04','2022-06-06 12:59:40');
INSERT INTO invoices VALUES('373','1','17','1','7','1','2022-06-05','2022-06-10 14:37:13','','JUN/22','','15000.00','15000.00','Paid','2022-06-02 11:02:04','2022-06-10 14:37:13');
INSERT INTO invoices VALUES('374','1','18','1','7','1','2022-06-05','2022-06-06 13:00:37','','JUN/22','','15000.00','15000.00','Paid','2022-06-02 11:02:04','2022-06-06 13:00:37');
INSERT INTO invoices VALUES('375','1','21','1','8','1','2022-06-05','2022-06-09 14:07:05','','JUN/22','','18500.00','18500.00','Paid','2022-06-02 11:02:04','2022-06-09 14:07:05');
INSERT INTO invoices VALUES('376','1','25','1','10','1','2022-06-05','2022-06-06 13:03:04','','JUN/22','','17000.00','17000.00','Paid','2022-06-02 11:02:04','2022-06-06 13:03:04');
INSERT INTO invoices VALUES('379','1','35','1','7','1','2022-06-05','2022-06-06 13:00:12','','JUN/22','','15000.00','15000.00','Paid','2022-06-02 11:02:04','2022-06-06 13:00:12');
INSERT INTO invoices VALUES('380','1','36','1','12','1','2022-06-05','','','JUN/22','','22000.00','','Unpaid','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoices VALUES('381','1','37','1','12','1','2022-06-05','','','JUN/22','','22000.00','','Unpaid','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoices VALUES('383','1','40','1','4','1','2022-06-05','2022-06-06 13:05:34','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-06 13:05:34');
INSERT INTO invoices VALUES('384','1','42','2','15','1','2022-06-05','2022-06-04 05:51:58','','JUN/22','','19000.00','19000.00','Paid','2022-06-02 11:02:04','2022-06-04 05:51:58');
INSERT INTO invoices VALUES('385','1','43','1','4','1','2022-06-05','2022-06-04 06:06:07','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-04 06:06:07');
INSERT INTO invoices VALUES('386','1','44','1','11','1','2022-06-05','2022-06-25 15:41:58','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-25 15:41:58');
INSERT INTO invoices VALUES('387','1','46','2','15','1','2022-06-05','2022-06-04 05:50:18','','JUN/22','','19000.00','19000.00','Paid','2022-06-02 11:02:04','2022-06-04 05:50:18');
INSERT INTO invoices VALUES('388','1','49','1','10','1','2022-06-05','2022-06-09 14:07:49','','JUN/22','','17000.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-12 10:54:13');
INSERT INTO invoices VALUES('389','1','50','1','8','1','2022-06-05','2022-06-11 13:01:10','','JUN/22','','18000.00','18000.00','Paid','2022-06-02 11:02:04','2022-06-11 13:01:10');
INSERT INTO invoices VALUES('390','1','51','1','8','1','2022-06-05','2022-08-13 07:10:08','','JUN/22','','18000.00','18000.00','Paid','2022-06-02 11:02:04','2022-08-13 07:10:08');
INSERT INTO invoices VALUES('391','1','53','1','11','1','2022-06-05','2022-06-10 14:37:51','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-10 14:37:51');
INSERT INTO invoices VALUES('392','1','56','1','4','1','2022-06-05','2022-06-11 13:35:16','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-11 13:35:16');
INSERT INTO invoices VALUES('393','1','58','1','4','1','2022-06-05','2022-06-06 05:52:03','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-06 05:52:03');
INSERT INTO invoices VALUES('394','1','59','1','2','1','2022-06-05','','','JUN/22','','16500.00','','Unpaid','2022-06-02 11:02:04','2022-06-02 11:02:04');
INSERT INTO invoices VALUES('395','1','4','1','2','1','2022-06-05','','','JUN/22','','16500.00','','Unpaid','2022-06-02 11:02:04','2022-06-09 06:39:27');
INSERT INTO invoices VALUES('396','1','62','1','10','1','2022-06-05','2022-06-04 06:15:21','','JUN/22','','17000.00','17000.00','Paid','2022-06-02 11:02:04','2022-06-04 06:15:21');
INSERT INTO invoices VALUES('397','1','63','1','8','1','2022-06-05','2022-06-09 14:25:23','','JUN/22','','18000.00','18000.00','Paid','2022-06-02 11:02:04','2022-06-09 14:25:23');
INSERT INTO invoices VALUES('398','1','64','1','11','1','2022-06-05','2022-06-25 15:41:03','','JUN/22','','16000.00','16000.00','Paid','2022-06-02 11:02:04','2022-06-25 15:41:03');
INSERT INTO invoices VALUES('399','1','65','1','1','1','2022-06-05','2022-06-09 14:10:47','','JUN/22','','18500.00','18500.00','Paid','2022-06-02 11:02:04','2022-06-09 14:10:47');
INSERT INTO invoices VALUES('400','1','66','1','1','1','2022-06-05','2022-06-09 14:11:45','','JUN/22','','18500.00','18500.00','Paid','2022-06-02 11:02:04','2022-06-09 14:11:45');
INSERT INTO invoices VALUES('401','1','67','1','5','1','2022-06-05','2022-06-07 04:45:32','','JUN/22','','20000.00','20000.00','Paid','2022-06-02 11:02:04','2022-06-07 04:45:32');
INSERT INTO invoices VALUES('402','1','68','1','5','1','2022-06-05','2022-06-09 14:06:06','','JUN/22','','20000.00','20000.00','Paid','2022-06-02 11:02:04','2022-06-09 14:06:06');
INSERT INTO invoices VALUES('403','1','69','1','3','1','2022-06-05','2022-06-09 13:54:20','','JUN/22','','18500.00','18500.00','Paid','2022-06-02 11:02:04','2022-06-09 13:54:20');
INSERT INTO invoices VALUES('404','1','70','1','3','1','2022-06-05','2022-06-09 14:10:10','','JUN/22','','18500.00','18500.00','Paid','2022-06-02 11:02:04','2022-06-09 14:10:10');
INSERT INTO invoices VALUES('427','1','63','1','8','1','2022-04-05','2022-09-24 12:56:57','','APR/22','','18000.00','18000.00','Paid','2022-06-11 13:14:11','2022-09-24 12:56:57');
INSERT INTO invoices VALUES('406','1','72','1','18','1','2022-06-05','2022-06-09 14:14:56','','JUN/22','','25000.00','25000.00','Paid','2022-06-02 11:02:04','2022-06-09 14:14:56');
INSERT INTO invoices VALUES('407','1','73','1','6','1','2022-06-05','2022-06-07 09:02:13','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-07 09:02:13');
INSERT INTO invoices VALUES('408','1','74','1','6','1','2022-06-05','2022-06-11 13:05:13','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-11 13:05:13');
INSERT INTO invoices VALUES('409','1','75','1','6','1','2022-06-05','2023-07-30 12:06:16','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2023-07-30 12:06:16');
INSERT INTO invoices VALUES('410','1','76','1','2','1','2022-06-05','2022-06-04 06:17:49','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2022-06-04 06:17:49');
INSERT INTO invoices VALUES('411','1','77','1','6','1','2022-06-05','2023-07-30 12:03:12','','JUN/22','','17500.00','17500.00','Paid','2022-06-02 11:02:04','2023-07-30 12:03:12');
INSERT INTO invoices VALUES('412','1','79','1','16','1','2022-06-05','2022-06-04 05:53:29','','JUN/22','','20000.00','20000.00','Paid','2022-06-02 11:02:04','2022-06-04 05:53:29');
INSERT INTO invoices VALUES('429','1','69','3','13','1','2019-12-13','2022-06-25 16:04:07','','PAID ONLY 20 DAYS','','28300.00','23300.00','Paid','2022-06-25 16:01:16','2022-11-06 14:27:37');
INSERT INTO invoices VALUES('414','1','81','3','13','1','2022-06-05','2022-06-11 12:59:07','','JUN/22','','17000.00','17000.00','Paid','2022-06-02 11:02:04','2022-06-11 12:59:07');
INSERT INTO invoices VALUES('879','1','3','2','14','1','2023-01-05','2023-01-24 14:21:17','','JAN/23','','24000.00','24000.00','Paid','2023-01-06 07:13:21','2023-01-24 14:21:17');
INSERT INTO invoices VALUES('420','1','86','1','9','1','2022-06-01','2023-07-30 12:22:44','','JUNE/22','','35000.00','35000.00','Paid','2022-06-04 06:11:01','2023-07-30 12:22:44');
INSERT INTO invoices VALUES('417','1','84','3','13','1','2022-06-05','2022-06-04 06:01:30','','JUNE/22','','38000.00','30000.00','Unpaid','2022-06-04 05:22:45','2022-06-04 06:01:30');
INSERT INTO invoices VALUES('418','1','85','1','9','1','2022-06-05','2022-06-09 14:01:37','','JUNE/22','','34000.00','34000.00','Paid','2022-06-04 05:34:43','2022-06-09 14:01:37');
INSERT INTO invoices VALUES('419','1','83','1','9','1','2022-06-05','2022-06-09 14:02:11','','JUNE/22','','34000.00','34000.00','Paid','2022-06-04 05:45:38','2022-06-09 14:02:11');
INSERT INTO invoices VALUES('558','1','42','2','15','1','2022-08-10','2022-08-13 07:26:23','','AUG/22','','2185.00','2185.00','Paid','2022-08-13 07:25:25','2022-08-13 07:26:23');
INSERT INTO invoices VALUES('422','1','89','2','12','1','2022-06-05','2022-06-05 14:58:38','','JUNE/22','','42000.00','32000.00','Unpaid','2022-06-05 14:38:28','2022-06-05 14:58:38');
INSERT INTO invoices VALUES('423','1','90','2','12','1','2022-06-05','2022-06-05 14:59:49','','JUNE/22','','42000.00','22000.00','Unpaid','2022-06-05 14:48:14','2022-06-05 14:59:49');
INSERT INTO invoices VALUES('424','1','60','1','2','1','2022-06-05','2022-06-06 13:40:12','','JUNE/22','','16500.00','16500.00','Paid','2022-06-06 13:38:37','2022-06-06 13:40:12');
INSERT INTO invoices VALUES('425','1','60','1','2','1','2022-06-05','2022-06-09 06:53:09','','JUNE/22','','16500.00','16500.00','Paid','2022-06-09 06:41:45','2022-06-09 06:53:09');
INSERT INTO invoices VALUES('426','1','71','1','16','1','2022-06-05','2022-06-09 14:00:24','','JUNE/22','','6000.00','6000.00','Paid','2022-06-09 13:58:42','2022-06-09 14:00:24');
INSERT INTO invoices VALUES('428','1','78','3','17','1','2022-06-05','2022-06-11 13:29:02','','JUNE/22','','20000.00','20000.00','Paid','2022-06-11 13:28:17','2022-06-11 13:29:02');
INSERT INTO invoices VALUES('430','1','92','1','9','1','2022-06-05','2022-07-03 07:27:12','','JUNE/22','','30000.00','30000.00','Paid','2022-07-03 07:18:58','2023-07-09 08:53:05');
INSERT INTO invoices VALUES('431','1','93','2','12','1','2022-06-10','2022-07-03 07:52:10','','JUNE/22','','35000.00','17000.00','Unpaid','2022-07-03 07:51:02','2022-07-03 07:52:10');
INSERT INTO invoices VALUES('432','1','3','2','14','1','2022-07-05','2023-07-30 11:54:43','','JUL/22','','22500.00','22500.00','Paid','2022-07-03 11:08:16','2023-07-30 11:54:43');
INSERT INTO invoices VALUES('433','1','7','1','3','1','2022-07-05','2022-07-08 08:50:05','','JUL/22','','18500.00','18500.00','Paid','2022-07-03 11:08:16','2022-07-08 08:50:05');
INSERT INTO invoices VALUES('434','1','8','1','1','1','2022-07-05','2022-07-08 11:56:42','','JUL/22','','18500.00','18500.00','Paid','2022-07-03 11:08:16','2022-07-08 11:56:42');
INSERT INTO invoices VALUES('435','1','15','1','7','1','2022-07-05','2022-07-08 11:27:32','','JUL/22','','15000.00','15000.00','Paid','2022-07-03 11:08:16','2022-07-08 11:27:32');
INSERT INTO invoices VALUES('436','1','16','1','7','1','2022-07-05','2022-07-08 11:25:18','','JUL/22','','15000.00','15000.00','Paid','2022-07-03 11:08:16','2022-07-08 11:25:18');
INSERT INTO invoices VALUES('437','1','17','1','7','1','2022-07-05','2022-07-08 11:24:34','','JUL/22','','15000.00','15000.00','Paid','2022-07-03 11:08:16','2022-07-08 11:24:34');
INSERT INTO invoices VALUES('438','1','18','1','7','1','2022-07-05','2022-07-08 11:20:18','','JUL/22','','15000.00','15000.00','Paid','2022-07-03 11:08:16','2022-07-08 11:20:18');
INSERT INTO invoices VALUES('439','1','21','1','8','1','2022-07-05','2022-07-08 11:55:54','','JUL/22','','18500.00','18500.00','Paid','2022-07-03 11:08:16','2022-07-08 11:55:54');
INSERT INTO invoices VALUES('440','1','25','1','10','1','2022-07-05','2022-07-08 11:17:56','','JUL/22','','17000.00','17000.00','Paid','2022-07-03 11:08:16','2022-07-08 11:17:56');
INSERT INTO invoices VALUES('441','1','35','1','7','1','2022-07-05','2022-07-08 10:37:22','','JUL/22','','15000.00','15000.00','Paid','2022-07-03 11:08:16','2022-07-08 10:37:22');
INSERT INTO invoices VALUES('442','1','38','1','11','1','2022-07-05','2022-07-08 11:36:57','','JUL/22','','17000.00','17000.00','Paid','2022-07-03 11:08:16','2022-07-08 11:36:57');
INSERT INTO invoices VALUES('443','1','40','1','4','1','2022-07-05','2022-07-08 11:16:25','','JUL/22','','17500.00','17500.00','Paid','2022-07-03 11:08:16','2022-07-08 11:16:25');
INSERT INTO invoices VALUES('444','1','42','2','15','1','2022-07-05','2022-07-03 11:11:16','','JUL/22','','19000.00','19000.00','Paid','2022-07-03 11:08:16','2022-07-03 11:11:16');
INSERT INTO invoices VALUES('445','1','43','1','4','1','2022-07-05','2022-07-08 10:09:00','','JUL/22','','17500.00','17500.00','Paid','2022-07-03 11:08:16','2022-07-08 10:09:00');
INSERT INTO invoices VALUES('446','1','44','1','11','1','2022-07-05','2022-07-21 10:01:34','','JUL/22','','17500.00','17500.00','Paid','2022-07-03 11:08:16','2022-07-21 10:01:34');
INSERT INTO invoices VALUES('447','1','46','2','15','1','2022-07-05','2022-07-03 11:10:47','','JUL/22','','19000.00','19000.00','Paid','2022-07-03 11:08:16','2022-07-03 11:10:47');
INSERT INTO invoices VALUES('448','1','49','1','10','1','2022-07-05','2022-07-08 11:29:07','','JUL/22','','17500.00','17000.00','Unpaid','2022-07-03 11:08:16','2022-07-08 11:29:07');
INSERT INTO invoices VALUES('449','1','50','1','8','1','2022-07-05','2022-07-08 11:08:04','','JUL/22','','18000.00','18000.00','Paid','2022-07-03 11:08:16','2022-07-08 11:08:04');
INSERT INTO invoices VALUES('450','1','51','1','8','1','2022-07-05','2022-07-08 11:53:57','','JUL/22','','18000.00','18000.00','Paid','2022-07-03 11:08:16','2022-07-08 11:53:57');
INSERT INTO invoices VALUES('452','1','58','1','4','1','2022-07-05','2022-07-08 11:35:26','','JUL/22','','17500.00','17500.00','Paid','2022-07-03 11:08:16','2022-07-08 11:35:26');
INSERT INTO invoices VALUES('453','1','59','1','2','1','2022-07-05','2022-07-08 11:06:18','','JUL/22','','16500.00','16500.00','Paid','2022-07-03 11:08:16','2022-07-08 11:06:18');
INSERT INTO invoices VALUES('454','1','60','1','2','1','2022-07-05','','','JUL/22','','16500.00','','Unpaid','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoices VALUES('455','1','63','1','8','1','2022-07-05','2022-07-08 10:58:05','','JUL/22','','18000.00','18000.00','Paid','2022-07-03 11:08:16','2022-07-08 10:58:05');
INSERT INTO invoices VALUES('457','1','65','1','1','1','2022-07-05','2022-08-24 06:43:23','','JUL/22','','18500.00','18500.00','Paid','2022-07-03 11:08:16','2022-08-24 06:43:23');
INSERT INTO invoices VALUES('458','1','66','1','1','1','2022-07-05','2022-07-08 11:57:37','','JUL/22','','18500.00','18500.00','Paid','2022-07-03 11:08:16','2022-07-08 11:57:37');
INSERT INTO invoices VALUES('459','1','67','1','5','1','2022-07-05','2022-07-08 10:56:19','','JUL/22','','20000.00','20000.00','Paid','2022-07-03 11:08:16','2022-07-08 10:56:19');
INSERT INTO invoices VALUES('460','1','68','1','5','1','2022-07-05','2022-07-08 10:55:27','','JUL/22','','20000.00','20000.00','Paid','2022-07-03 11:08:16','2022-07-08 10:55:27');
INSERT INTO invoices VALUES('461','1','69','1','3','1','2022-07-05','2022-07-08 10:57:06','','JUL/22','','18500.00','18500.00','Paid','2022-07-03 11:08:16','2022-07-08 10:57:06');
INSERT INTO invoices VALUES('744','1','42','2','15','1','2022-10-05','2022-11-02 06:40:40','','OCT/22','','1200.00','1200.00','Paid','2022-10-05 08:03:01','2022-11-02 06:40:40');
INSERT INTO invoices VALUES('463','1','72','1','18','1','2022-07-05','2022-07-08 12:06:03','','JUL/22','','25000.00','25000.00','Paid','2022-07-03 11:08:16','2022-07-08 12:06:03');
INSERT INTO invoices VALUES('464','1','73','1','6','1','2022-07-05','2022-07-08 11:48:11','','JUL/22','','17500.00','17500.00','Paid','2022-07-03 11:08:16','2022-07-08 11:48:11');
INSERT INTO invoices VALUES('465','1','74','1','6','1','2022-07-05','2022-07-08 11:41:08','','JUL/22','','17500.00','17500.00','Paid','2022-07-03 11:08:16','2022-07-08 11:41:08');
INSERT INTO invoices VALUES('466','1','75','1','6','1','2022-07-05','2023-07-30 12:07:32','','JUL/22','','17500.00','17500.00','Paid','2022-07-03 11:08:16','2023-07-30 12:07:32');
INSERT INTO invoices VALUES('467','1','76','1','2','1','2022-07-05','','','JUL/22','','17500.00','','Unpaid','2022-07-03 11:08:16','2022-07-03 11:08:16');
INSERT INTO invoices VALUES('468','1','77','1','6','1','2022-07-05','2022-07-08 10:30:03','','JUL/22','','17500.00','17500.00','Paid','2022-07-03 11:08:16','2022-07-08 10:30:03');
INSERT INTO invoices VALUES('469','1','79','1','16','1','2022-07-05','2022-07-08 10:27:26','','JUL/22','','20000.00','20000.00','Paid','2022-07-03 11:08:16','2022-07-08 10:27:26');
INSERT INTO invoices VALUES('470','1','81','3','9','1','2022-07-05','2022-07-08 10:49:41','','JUL/22','','17000.00','17000.00','Paid','2022-07-03 11:08:16','2022-07-08 10:49:41');
INSERT INTO invoices VALUES('560','1','111','1','10','1','2022-08-05','2022-08-13 07:29:36','','AUG/22','','2000.00','2000.00','Paid','2022-08-13 07:28:29','2022-08-13 07:29:36');
INSERT INTO invoices VALUES('472','1','84','3','13','1','2022-07-05','2022-07-08 10:18:16','','JUL/22','','20000.00','20000.00','Paid','2022-07-03 11:08:16','2022-07-08 10:18:16');
INSERT INTO invoices VALUES('473','1','85','1','9','1','2022-07-05','2022-07-08 11:55:02','','JUL/22','','17000.00','17000.00','Paid','2022-07-03 11:08:16','2022-07-08 11:55:02');
INSERT INTO invoices VALUES('475','1','87','1','10','1','2022-07-05','2022-07-16 15:10:31','','JUL/22','','17000.00','17000.00','Paid','2022-07-03 11:08:16','2022-07-16 15:10:31');
INSERT INTO invoices VALUES('476','1','91','3','13','1','2022-07-05','2022-07-08 10:17:20','','JUL/22','','20000.00','20000.00','Paid','2022-07-03 11:08:16','2022-07-08 10:17:20');
INSERT INTO invoices VALUES('477','1','92','1','16','1','2022-07-16','2022-07-21 08:59:18','','JUL/22','','6000.00','6000.00','Paid','2022-07-03 11:08:16','2022-07-21 08:59:18');
INSERT INTO invoices VALUES('478','1','95','2','12','1','2022-07-05','2022-07-14 11:40:51','','JUL/22','','32000.00','32000.00','Paid','2022-07-14 10:13:35','2022-07-14 11:40:51');
INSERT INTO invoices VALUES('479','1','96','2','12','1','2022-07-05','2022-07-14 11:41:24','','JUL/22','','37000.00','37000.00','Paid','2022-07-14 10:19:03','2022-07-14 11:41:24');
INSERT INTO invoices VALUES('480','1','97','1','2','1','2022-07-05','2022-07-14 11:43:05','','JUL/22','','32500.00','32500.00','Paid','2022-07-14 10:36:18','2022-07-14 11:43:05');
INSERT INTO invoices VALUES('481','1','98','2','20','1','2022-07-05','2022-07-14 11:40:01','','JUL/22','','20000.00','20000.00','Paid','2022-07-14 10:47:52','2022-07-14 11:40:01');
INSERT INTO invoices VALUES('482','1','99','3','17','1','2022-07-05','2022-07-16 06:45:10','','JUL/22','','40000.00','40000.00','Paid','2022-07-16 06:43:44','2022-07-16 06:45:10');
INSERT INTO invoices VALUES('483','1','94','1','2','1','2022-07-05','2022-07-16 06:57:44','','JUL/22','','32500.00','32500.00','Paid','2022-07-16 06:56:50','2022-07-16 06:57:44');
INSERT INTO invoices VALUES('484','1','86','1','4','1','2022-07-05','2022-07-16 08:15:36','','JUL/22','','17500.00','17500.00','Paid','2022-07-16 08:14:17','2022-07-16 08:15:36');
INSERT INTO invoices VALUES('485','1','100','3','17','1','2022-07-19','2022-08-12 07:31:35','','JUL/22','','23000.00','23000.00','Paid','2022-07-20 05:41:49','2022-08-12 07:31:35');
INSERT INTO invoices VALUES('486','1','101','1','9','1','2022-07-19','2022-07-21 08:57:32','','JUL\\22','','16000.00','16000.00','Paid','2022-07-20 05:54:18','2022-07-21 08:57:32');
INSERT INTO invoices VALUES('487','1','102','1','3','1','2022-07-19','2022-08-07 07:03:34','','JUL/22','','24000.00','24000.00','Paid','2022-07-20 05:59:58','2022-08-07 07:03:34');
INSERT INTO invoices VALUES('488','1','103','1','2','1','2022-07-20','2022-07-27 10:51:54','','JUL/22','','24500.00','24500.00','Paid','2022-07-20 06:08:46','2022-07-27 10:51:54');
INSERT INTO invoices VALUES('489','1','89','1','11','1','2022-07-21','2022-08-13 06:54:31','','JUL/22','ONLY 10 DAYS','22500.00','22500.00','Paid','2022-07-21 08:47:59','2022-08-13 06:54:31');
INSERT INTO invoices VALUES('490','1','104','1','9','1','2022-07-21','2022-08-09 09:34:27','','JUL/22','','23000.00','23000.00','Paid','2022-07-21 09:56:53','2022-08-09 09:34:27');
INSERT INTO invoices VALUES('491','1','105','1','11','1','2022-07-23','2022-07-23 08:39:57','','JUL/22','','22000.00','22000.00','Paid','2022-07-23 08:37:59','2022-07-23 08:39:57');
INSERT INTO invoices VALUES('494','1','107','1','11','1','2022-07-24','2022-08-13 07:13:35','','JUL/22','','21500.00','21500.00','Paid','2022-07-24 08:36:06','2022-08-13 07:13:35');
INSERT INTO invoices VALUES('493','1','106','1','2','1','2022-07-23','2022-07-23 08:49:19','','JUL/22','','21500.00','21500.00','Paid','2022-07-23 08:47:19','2022-07-23 08:49:19');
INSERT INTO invoices VALUES('495','1','108','1','2','1','2022-07-23','2022-07-24 08:43:05','','JUL/22','','22750.00','15250.00','Unpaid','2022-07-24 08:41:57','2022-07-24 08:43:05');
INSERT INTO invoices VALUES('496','1','3','2','14','1','2022-08-05','2022-08-13 07:11:56','','AUG/22','','22500.00','22500.00','Paid','2022-08-02 10:01:10','2022-08-13 07:11:56');
INSERT INTO invoices VALUES('497','1','7','1','3','1','2022-08-05','2022-08-06 16:55:25','','AUG/22','','18500.00','18500.00','Paid','2022-08-02 10:01:10','2022-08-06 16:55:25');
INSERT INTO invoices VALUES('561','1','112','1','3','1','2022-08-22','2022-09-02 10:29:03','','AUG/22','','10000.00','10000.00','Paid','2022-09-02 10:28:09','2022-09-02 10:29:03');
INSERT INTO invoices VALUES('499','1','15','1','7','1','2022-08-05','2022-08-09 09:37:49','','AUG/22','','15000.00','15000.00','Paid','2022-08-02 10:01:10','2022-08-09 09:37:49');
INSERT INTO invoices VALUES('557','1','111','1','10','1','2022-08-11','2022-08-11 06:31:38','','AUG/22','','30800.00','30800.00','Paid','2022-08-11 06:30:45','2022-08-11 06:31:38');
INSERT INTO invoices VALUES('501','1','17','1','7','1','2022-08-05','2022-08-09 09:36:36','','AUG/22','','15000.00','15000.00','Paid','2022-08-02 10:01:10','2022-08-09 09:36:36');
INSERT INTO invoices VALUES('502','1','18','1','7','1','2022-08-05','2022-08-09 09:37:10','','AUG/22','','15000.00','15000.00','Paid','2022-08-02 10:01:10','2022-08-09 09:37:10');
INSERT INTO invoices VALUES('503','1','21','1','8','1','2022-08-05','2022-08-02 10:11:51','','AUG/22','','18500.00','18500.00','Paid','2022-08-02 10:01:10','2022-08-02 10:11:51');
INSERT INTO invoices VALUES('504','1','25','1','10','1','2022-08-05','2022-08-06 16:36:46','','AUG/22','','17000.00','17000.00','Paid','2022-08-02 10:01:10','2022-08-06 16:36:46');
INSERT INTO invoices VALUES('505','1','35','1','7','1','2022-08-05','2022-08-13 07:14:16','','AUG/22','','15000.00','15000.00','Paid','2022-08-02 10:01:10','2022-08-13 07:14:16');
INSERT INTO invoices VALUES('506','1','40','1','4','1','2022-08-05','2022-08-11 06:33:01','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-11 06:33:01');
INSERT INTO invoices VALUES('507','1','42','2','15','1','2022-08-05','2022-08-03 06:09:23','','AUG/22','','19000.00','19000.00','Paid','2022-08-02 10:01:10','2022-08-03 06:09:23');
INSERT INTO invoices VALUES('508','1','43','1','4','1','2022-08-05','2022-08-04 18:37:14','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-04 18:37:14');
INSERT INTO invoices VALUES('509','1','44','1','11','1','2022-08-05','2022-08-13 06:53:39','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-13 06:53:39');
INSERT INTO invoices VALUES('510','1','46','2','15','1','2022-08-05','2022-08-03 06:10:19','','AUG/22','','19000.00','19000.00','Paid','2022-08-02 10:01:10','2022-08-03 06:10:19');
INSERT INTO invoices VALUES('511','1','49','1','10','1','2022-08-05','2022-08-06 16:48:42','','AUG/22','','17500.00','17000.00','Unpaid','2022-08-02 10:01:10','2022-08-06 16:48:42');
INSERT INTO invoices VALUES('512','1','50','1','8','1','2022-08-05','2022-08-13 07:11:11','','AUG/22','','18000.00','18000.00','Paid','2022-08-02 10:01:10','2022-08-13 07:11:11');
INSERT INTO invoices VALUES('513','1','51','1','8','1','2022-08-05','2022-08-13 07:10:37','','AUG/22','','18000.00','18000.00','Paid','2022-08-02 10:01:10','2022-08-13 07:10:37');
INSERT INTO invoices VALUES('514','1','58','1','4','1','2022-08-05','2022-08-06 16:51:40','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-06 16:51:40');
INSERT INTO invoices VALUES('515','1','63','1','8','1','2022-08-05','2022-08-03 06:08:26','','AUG/22','','18000.00','18000.00','Paid','2022-08-02 10:01:10','2022-08-03 06:08:26');
INSERT INTO invoices VALUES('516','1','65','1','1','1','2022-08-05','2022-08-07 06:57:10','','AUG/22','','18500.00','18500.00','Paid','2022-08-02 10:01:10','2022-08-07 06:57:10');
INSERT INTO invoices VALUES('517','1','66','1','1','1','2022-08-05','2022-08-09 09:35:00','','AUG/22','','18500.00','18500.00','Paid','2022-08-02 10:01:10','2022-08-09 09:35:00');
INSERT INTO invoices VALUES('518','1','67','1','5','1','2022-08-05','2022-08-14 19:32:51','','AUG/22','','20000.00','20000.00','Paid','2022-08-02 10:01:10','2022-08-14 19:32:51');
INSERT INTO invoices VALUES('519','1','68','1','5','1','2022-08-05','2022-08-09 09:35:42','','AUG/22','','20000.00','20000.00','Paid','2022-08-02 10:01:10','2022-08-09 09:35:42');
INSERT INTO invoices VALUES('816','1','123','1','1','1','2022-11-05','2022-11-16 17:26:54','','Nov/22','20 days rent','33500.00','33500.00','Paid','2022-11-16 17:25:28','2022-11-16 17:26:54');
INSERT INTO invoices VALUES('521','1','72','1','18','1','2022-08-05','2022-08-29 10:59:10','','AUG/22','','25000.00','25000.00','Paid','2022-08-02 10:01:10','2022-08-29 10:59:10');
INSERT INTO invoices VALUES('522','1','73','1','6','1','2022-08-05','2022-08-06 16:53:41','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-06 16:53:41');
INSERT INTO invoices VALUES('523','1','74','1','6','1','2022-08-05','2022-08-04 18:47:35','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-04 18:47:35');
INSERT INTO invoices VALUES('524','1','75','1','6','1','2022-08-05','2022-08-04 18:48:30','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-04 18:48:30');
INSERT INTO invoices VALUES('525','1','77','1','6','1','2022-08-05','2022-08-02 10:10:38','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-02 10:10:38');
INSERT INTO invoices VALUES('526','1','79','1','16','1','2022-08-05','2022-08-02 10:10:00','','AUG/22','','20000.00','20000.00','Paid','2022-08-02 10:01:10','2022-08-02 10:10:00');
INSERT INTO invoices VALUES('527','1','81','3','9','1','2022-08-05','2022-08-04 18:45:58','','AUG/22','','17000.00','17000.00','Paid','2022-08-02 10:01:10','2022-08-04 18:45:58');
INSERT INTO invoices VALUES('750','1','3','2','14','1','2022-11-05','2022-11-08 12:23:24','','NOV/22','','24000.00','24000.00','Paid','2022-11-01 07:09:42','2022-11-08 12:23:24');
INSERT INTO invoices VALUES('529','1','85','1','9','1','2022-08-05','2022-08-04 18:46:41','','AUG/22','','17000.00','17000.00','Paid','2022-08-02 10:01:10','2022-08-04 18:46:41');
INSERT INTO invoices VALUES('554','1','86','1','4','1','2022-08-05','2022-08-04 18:36:17','','AUG/22','','17500.00','17500.00','Paid','2022-08-04 18:34:13','2022-08-04 18:36:17');
INSERT INTO invoices VALUES('531','1','87','1','10','1','2022-08-05','2022-08-07 07:15:47','','AUG/22','','17000.00','17000.00','Paid','2022-08-02 10:01:10','2022-08-07 07:15:47');
INSERT INTO invoices VALUES('532','1','89','1','11','1','2022-08-05','2022-08-07 08:10:05','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-07 08:10:05');
INSERT INTO invoices VALUES('533','1','91','3','13','1','2022-08-05','2022-08-07 06:55:36','','AUG/22','','20000.00','20000.00','Paid','2022-08-02 10:01:10','2022-08-07 06:55:36');
INSERT INTO invoices VALUES('534','1','92','1','16','1','2022-08-05','2022-08-11 06:32:33','','AUG/22','','20000.00','20000.00','Paid','2022-08-02 10:01:10','2022-08-11 06:32:33');
INSERT INTO invoices VALUES('535','1','94','1','10','1','2022-08-05','2022-08-06 16:49:36','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-06 16:49:36');
INSERT INTO invoices VALUES('536','1','95','2','12','1','2022-08-05','2022-08-06 16:52:12','','AUG/22','','22000.00','22000.00','Paid','2022-08-02 10:01:10','2022-08-06 16:52:12');
INSERT INTO invoices VALUES('537','1','96','2','12','1','2022-08-05','2022-08-06 16:52:46','','AUG/22','','22000.00','22000.00','Paid','2022-08-02 10:01:10','2022-08-06 16:52:46');
INSERT INTO invoices VALUES('538','1','97','1','2','1','2022-08-05','2022-08-04 18:50:30','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-04 18:50:30');
INSERT INTO invoices VALUES('539','1','98','2','20','1','2022-08-05','2022-08-02 10:12:19','','AUG/22','','20000.00','20000.00','Paid','2022-08-02 10:01:10','2022-08-02 10:12:19');
INSERT INTO invoices VALUES('540','1','99','3','17','1','2022-08-05','2022-08-11 06:32:03','','AUG/22','','20000.00','20000.00','Paid','2022-08-02 10:01:10','2022-08-11 06:32:03');
INSERT INTO invoices VALUES('541','1','100','3','17','1','2022-08-05','2022-08-06 16:50:22','','AUG/22','','20000.00','20000.00','Paid','2022-08-02 10:01:10','2022-08-06 16:50:22');
INSERT INTO invoices VALUES('542','1','101','1','9','1','2022-08-05','2022-08-04 18:45:08','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-04 18:45:08');
INSERT INTO invoices VALUES('543','1','102','1','3','1','2022-08-05','2022-08-07 07:04:08','','AUG/22','','18500.00','18500.00','Paid','2022-08-02 10:01:10','2022-08-07 07:04:08');
INSERT INTO invoices VALUES('544','1','103','1','2','1','2022-08-05','2022-08-06 16:47:45','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-06 16:47:45');
INSERT INTO invoices VALUES('545','1','104','1','9','1','2022-08-05','2022-08-07 07:56:18','','AUG/22','','17000.00','17000.00','Paid','2022-08-02 10:01:10','2022-08-07 07:56:18');
INSERT INTO invoices VALUES('546','1','105','1','11','1','2022-08-05','2022-08-04 18:49:45','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-04 18:49:45');
INSERT INTO invoices VALUES('550','1','106','1','11','1','2022-08-05','2022-08-02 10:09:11','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:08:34','2022-08-02 10:09:11');
INSERT INTO invoices VALUES('548','1','107','1','11','1','2022-08-05','2022-08-07 06:58:49','','AUG/22','','17500.00','17500.00','Paid','2022-08-02 10:01:10','2022-08-07 06:58:49');
INSERT INTO invoices VALUES('562','1','92','1','16','1','2022-08-05','2022-09-02 10:32:21','','AUG/22','','10000.00','10000.00','Paid','2022-09-02 10:31:28','2022-09-02 10:32:21');
INSERT INTO invoices VALUES('551','1','83','3','13','1','2022-08-05','2022-08-13 07:07:30','','AUG/22','','23000.00','23000.00','Paid','2022-08-03 06:00:16','2022-08-13 07:07:30');
INSERT INTO invoices VALUES('552','1','109','1','1','1','2022-08-05','2022-08-03 06:07:12','','AUG/22','','35000.00','35000.00','Paid','2022-08-03 06:05:57','2022-08-03 06:07:12');
INSERT INTO invoices VALUES('555','1','110','1','2','1','2022-08-05','2022-08-06 16:44:49','','AUG/22','','35000.00','35000.00','Paid','2022-08-06 16:43:38','2022-08-06 16:44:49');
INSERT INTO invoices VALUES('672','1','113','1','16','1','2022-09-05','2022-09-05 21:02:28','','SEP/22','','43000.00','43000.00','Paid','2022-09-05 21:01:14','2022-09-05 21:02:28');
INSERT INTO invoices VALUES('718','1','98','2','20','1','2022-10-05','2022-10-05 07:42:26','','OCT/22','','20000.00','20000.00','Paid','2022-10-02 09:37:04','2022-10-05 07:42:26');
INSERT INTO invoices VALUES('717','1','97','1','2','1','2022-10-05','2022-10-05 07:55:09','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 07:55:09');
INSERT INTO invoices VALUES('748','1','81','3','9','1','2022-10-05','2022-10-07 08:10:09','','OCT/22','','18500.00','18500.00','Paid','2022-10-07 08:09:18','2022-10-07 08:10:09');
INSERT INTO invoices VALUES('743','1','69','3','13','1','2022-10-05','2022-10-17 12:19:37','','OCT/22','','36500.00','36500.00','Paid','2022-10-05 07:48:58','2022-10-17 12:19:37');
INSERT INTO invoices VALUES('705','1','75','1','6','1','2022-10-05','2022-10-07 07:41:24','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-07 07:41:24');
INSERT INTO invoices VALUES('706','1','77','1','6','1','2022-10-05','2022-10-05 07:59:49','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 07:59:49');
INSERT INTO invoices VALUES('752','1','15','1','7','1','2022-11-05','2022-11-08 09:55:54','','NOV/22','','16500.00','16500.00','Paid','2022-11-01 07:09:42','2022-11-15 17:41:38');
INSERT INTO invoices VALUES('684','1','18','1','7','1','2022-10-05','2022-10-13 09:30:09','','OCT/22','','16500.00','16500.00','Paid','2022-10-02 09:37:04','2022-10-13 09:30:09');
INSERT INTO invoices VALUES('685','1','21','1','8','1','2022-10-05','2022-11-01 07:12:24','','OCT/22','','19500.00','19500.00','Paid','2022-10-02 09:37:04','2022-11-01 07:12:24');
INSERT INTO invoices VALUES('686','1','25','1','10','1','2022-10-05','2022-10-05 07:56:01','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 07:56:01');
INSERT INTO invoices VALUES('679','1','117','2','21','1','2022-09-05','2022-09-10 08:49:49','','SEP/22','','12000.00','12000.00','Paid','2022-09-10 08:49:20','2022-09-10 08:49:49');
INSERT INTO invoices VALUES('746','1','3','2','14','1','2022-10-05','2022-10-07 07:46:03','','OCT/22','','24500.00','24500.00','Paid','2022-10-07 07:45:13','2022-10-07 07:46:03');
INSERT INTO invoices VALUES('681','1','7','1','3','1','2022-10-05','2022-10-07 08:05:59','','OCT/22','','20000.00','20000.00','Paid','2022-10-02 09:37:04','2022-10-07 08:05:59');
INSERT INTO invoices VALUES('682','1','15','1','7','1','2022-10-05','2022-10-07 08:17:37','','OCT/22','','16500.00','16500.00','Paid','2022-10-02 09:37:04','2022-10-07 08:17:37');
INSERT INTO invoices VALUES('683','1','17','1','7','1','2022-10-05','2022-10-07 08:16:36','','OCT/22','','16500.00','16500.00','Paid','2022-10-02 09:37:04','2022-10-07 08:16:36');
INSERT INTO invoices VALUES('623','1','17','1','7','1','2022-09-05','2022-09-07 08:39:34','','SEP/22','','16500.00','16500.00','Paid','2022-09-03 18:43:36','2022-09-07 08:39:34');
INSERT INTO invoices VALUES('622','1','15','1','7','1','2022-09-05','2022-09-07 08:39:10','','SEP/22','','16500.00','16500.00','Paid','2022-09-03 18:43:36','2022-09-07 08:39:10');
INSERT INTO invoices VALUES('674','1','115','1','3','1','2022-09-06','2022-09-07 08:38:15','','SEP/22','','40000.00','40000.00','Paid','2022-09-06 06:19:50','2022-09-07 08:38:15');
INSERT INTO invoices VALUES('673','1','114','1','3','1','2022-09-06','2022-09-07 08:37:34','','SEP/22','','40000.00','40000.00','Paid','2022-09-06 06:19:50','2022-09-07 08:37:34');
INSERT INTO invoices VALUES('745','1','46','2','15','1','2022-10-05','2022-11-02 16:35:53','','OCT/22','','1200.00','1200.00','Paid','2022-10-05 08:03:01','2022-11-02 16:35:53');
INSERT INTO invoices VALUES('709','1','85','1','9','1','2022-10-05','2022-10-07 08:20:23','','OCT/22','','18700.00','18700.00','Paid','2022-10-02 09:37:04','2022-10-07 08:20:23');
INSERT INTO invoices VALUES('710','1','86','1','4','1','2022-10-05','2022-10-05 07:41:43','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 07:41:43');
INSERT INTO invoices VALUES('711','1','87','1','7','1','2022-10-05','2022-10-09 05:58:49','','OCT/22','','16500.00','16500.00','Paid','2022-10-02 09:37:04','2022-10-09 05:58:49');
INSERT INTO invoices VALUES('712','1','91','3','13','1','2022-10-05','2022-10-08 07:01:19','','OCT/22','','21500.00','21500.00','Paid','2022-10-02 09:37:04','2022-10-08 07:01:19');
INSERT INTO invoices VALUES('713','1','92','1','16','1','2022-10-05','2022-10-05 08:08:15','','OCT/22','','21500.00','21500.00','Paid','2022-10-02 09:37:04','2022-10-05 08:08:15');
INSERT INTO invoices VALUES('700','1','67','1','5','1','2022-10-05','2022-10-07 08:04:12','','OCT/22','','21500.00','21500.00','Paid','2022-10-02 09:37:04','2022-10-07 08:04:12');
INSERT INTO invoices VALUES('701','1','68','1','5','1','2022-10-05','2022-10-08 07:00:09','','OCT/22','','21500.00','21500.00','Paid','2022-10-02 09:37:04','2022-10-08 07:00:09');
INSERT INTO invoices VALUES('675','1','98','2','20','1','2022-09-05','2022-11-08 09:55:02','','SEP/22','','22000.00','22000.00','Paid','2022-09-07 08:20:03','2022-11-08 09:55:02');
INSERT INTO invoices VALUES('714','1','94','1','10','1','2022-10-05','2022-10-07 08:14:04','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-07 08:14:04');
INSERT INTO invoices VALUES('694','1','50','1','8','1','2022-10-05','2022-10-13 09:32:01','','OCT/22','','19500.00','19500.00','Paid','2022-10-02 09:37:04','2022-10-13 09:32:01');
INSERT INTO invoices VALUES('695','1','51','1','8','1','2022-10-05','2022-10-13 09:32:37','','OCT/22','','19500.00','19500.00','Paid','2022-10-02 09:37:04','2022-10-13 09:32:37');
INSERT INTO invoices VALUES('696','1','58','1','4','1','2022-10-05','2022-10-05 08:07:53','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 08:07:53');
INSERT INTO invoices VALUES('697','1','63','1','8','1','2022-10-05','2022-10-07 07:42:26','','OCT/22','','19500.00','19500.00','Paid','2022-10-02 09:37:04','2022-10-07 07:42:26');
INSERT INTO invoices VALUES('698','1','65','1','1','1','2022-10-05','2022-10-16 13:24:56','','OCT/22','','20000.00','20000.00','Paid','2022-10-02 09:37:04','2022-10-16 13:24:56');
INSERT INTO invoices VALUES('699','1','66','1','1','1','2022-10-05','2022-10-05 08:07:29','','OCT/22','','20000.00','20000.00','Paid','2022-10-02 09:37:04','2022-10-05 08:07:29');
INSERT INTO invoices VALUES('693','1','49','1','10','1','2022-10-05','2022-10-07 08:06:23','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-07 08:06:23');
INSERT INTO invoices VALUES('687','1','35','1','7','1','2022-10-05','2022-10-07 08:13:11','','OCT/22','','16500.00','16500.00','Paid','2022-10-02 09:37:04','2022-10-07 08:13:11');
INSERT INTO invoices VALUES('688','1','40','1','4','1','2022-10-05','2022-10-05 08:00:28','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 08:00:28');
INSERT INTO invoices VALUES('689','1','42','2','15','1','2022-10-05','2022-10-05 08:05:31','','OCT/22','','21000.00','21000.00','Paid','2022-10-02 09:37:04','2022-10-05 08:05:31');
INSERT INTO invoices VALUES('690','1','43','1','4','1','2022-10-05','2022-10-05 08:01:04','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 08:01:04');
INSERT INTO invoices VALUES('691','1','44','1','11','1','2022-10-05','2022-10-13 09:31:28','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-13 09:31:28');
INSERT INTO invoices VALUES('692','1','46','2','15','1','2022-10-05','2022-10-05 08:05:53','','OCT/22','','21000.00','21000.00','Paid','2022-10-02 09:37:04','2022-10-05 08:05:53');
INSERT INTO invoices VALUES('620','1','3','2','14','1','2022-09-05','2022-09-05 08:50:10','','SEP/22','','24000.00','24000.00','Paid','2022-09-03 18:43:36','2022-09-05 08:50:10');
INSERT INTO invoices VALUES('719','1','99','3','17','1','2022-10-05','2022-10-07 08:15:40','','OCT/22','','21500.00','21500.00','Paid','2022-10-02 09:37:04','2022-10-07 08:15:40');
INSERT INTO invoices VALUES('749','1','72','1','18','1','2022-10-05','2022-10-07 08:20:00','','OCT/22','','26000.00','26000.00','Paid','2022-10-07 08:19:14','2022-10-07 08:20:00');
INSERT INTO invoices VALUES('703','1','73','1','6','1','2022-10-05','2022-10-05 07:59:20','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 07:59:20');
INSERT INTO invoices VALUES('704','1','74','1','6','1','2022-10-05','2022-10-05 07:56:29','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 07:56:29');
INSERT INTO invoices VALUES('621','1','7','1','3','1','2022-09-05','2022-09-03 19:46:20','','SEP/22','','20000.00','20000.00','Paid','2022-09-03 18:43:36','2022-09-03 19:46:20');
INSERT INTO invoices VALUES('624','1','18','1','7','1','2022-09-05','2022-09-07 08:39:55','','SEP/22','','16500.00','16500.00','Paid','2022-09-03 18:43:36','2022-09-07 08:39:55');
INSERT INTO invoices VALUES('625','1','21','1','8','1','2022-09-05','2022-10-13 09:33:53','','SEP/22','','19500.00','19500.00','Paid','2022-09-03 18:43:36','2022-10-13 09:33:53');
INSERT INTO invoices VALUES('626','1','25','1','10','1','2022-09-05','2022-09-07 08:46:00','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:36','2022-09-07 08:46:00');
INSERT INTO invoices VALUES('627','1','35','1','7','1','2022-09-05','2022-09-05 21:08:46','','SEP/22','','16500.00','16500.00','Paid','2022-09-03 18:43:36','2022-09-05 21:08:46');
INSERT INTO invoices VALUES('628','1','40','1','4','1','2022-09-05','2022-09-03 19:25:36','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:36','2022-09-03 19:25:36');
INSERT INTO invoices VALUES('678','1','46','2','15','1','2022-09-05','2023-07-30 11:56:39','','SEP/22','','25220.00','25220.00','Paid','2022-09-07 09:10:31','2023-07-30 11:56:39');
INSERT INTO invoices VALUES('630','1','43','1','4','1','2022-09-05','2022-09-03 19:38:35','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:36','2022-09-03 19:38:35');
INSERT INTO invoices VALUES('631','1','44','1','11','1','2022-09-05','2022-09-05 19:22:14','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:36','2022-09-05 19:22:14');
INSERT INTO invoices VALUES('677','1','42','2','15','1','2022-09-05','2023-07-30 11:56:00','','SEP/22','','25220.00','25220.00','Paid','2022-09-07 09:10:31','2023-07-30 11:56:00');
INSERT INTO invoices VALUES('633','1','49','1','10','1','2022-09-05','2022-09-24 12:59:44','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:36','2022-09-24 12:59:44');
INSERT INTO invoices VALUES('634','1','50','1','8','1','2022-09-05','2022-09-10 07:58:00','','SEP/22','','19500.00','19500.00','Paid','2022-09-03 18:43:36','2022-09-10 07:58:00');
INSERT INTO invoices VALUES('635','1','51','1','8','1','2022-09-05','2022-09-20 07:02:59','','SEP/22','','19500.00','19500.00','Paid','2022-09-03 18:43:36','2022-09-20 07:02:59');
INSERT INTO invoices VALUES('636','1','58','1','4','1','2022-09-05','2022-09-03 19:44:52','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-03 19:44:52');
INSERT INTO invoices VALUES('637','1','63','1','8','1','2022-09-05','2022-09-03 19:03:48','','SEP/22','','19500.00','19500.00','Paid','2022-09-03 18:43:37','2022-09-03 19:03:48');
INSERT INTO invoices VALUES('638','1','65','1','1','1','2022-09-05','2022-09-22 05:57:06','','SEP/22','','20000.00','20000.00','Paid','2022-09-03 18:43:37','2022-09-22 05:57:06');
INSERT INTO invoices VALUES('639','1','66','1','1','1','2022-09-05','2022-09-07 08:36:17','','SEP/22','','20000.00','20000.00','Paid','2022-09-03 18:43:37','2022-09-07 08:36:17');
INSERT INTO invoices VALUES('640','1','67','1','5','1','2022-09-05','2022-09-05 21:10:37','','SEP/22','','21500.00','21500.00','Paid','2022-09-03 18:43:37','2022-09-05 21:10:37');
INSERT INTO invoices VALUES('641','1','68','1','5','1','2022-09-05','2022-09-07 08:38:42','','SEP/22','','21500.00','21500.00','Paid','2022-09-03 18:43:37','2022-09-07 08:38:42');
INSERT INTO invoices VALUES('751','1','7','1','3','1','2022-11-05','2022-11-06 14:33:23','','NOV/22','','20000.00','20000.00','Paid','2022-11-01 07:09:42','2022-11-06 14:33:23');
INSERT INTO invoices VALUES('643','1','73','1','6','1','2022-09-05','2022-09-03 19:37:56','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-03 19:37:56');
INSERT INTO invoices VALUES('644','1','74','1','6','1','2022-09-05','2022-09-03 18:57:47','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-03 18:57:47');
INSERT INTO invoices VALUES('645','1','75','1','6','1','2022-09-05','2022-09-03 19:36:59','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-03 19:36:59');
INSERT INTO invoices VALUES('646','1','77','1','6','1','2022-09-05','2022-09-03 19:44:19','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-03 19:44:19');
INSERT INTO invoices VALUES('647','1','81','3','9','1','2022-09-05','2022-09-07 08:42:42','','SEP/22','','19000.00','18500.00','Unpaid','2022-09-03 18:43:37','2022-09-07 08:42:42');
INSERT INTO invoices VALUES('648','1','83','3','13','1','2022-09-05','2022-09-07 08:49:04','','SEP/22','','21500.00','21500.00','Paid','2022-09-03 18:43:37','2022-09-07 08:49:04');
INSERT INTO invoices VALUES('1275','1','138','3','24','1','2023-06-16','2023-06-15 08:37:38','','HALF MONTH JUNE 2023','NEW SEAT','33000.00','33000.00','Paid','2023-06-15 08:36:41','2023-06-15 08:37:38');
INSERT INTO invoices VALUES('650','1','86','1','4','1','2022-09-05','2022-09-03 19:03:07','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-03 19:03:07');
INSERT INTO invoices VALUES('651','1','87','1','7','1','2022-09-05','2022-09-05 21:08:09','','SEP/22','','16500.00','16500.00','Paid','2022-09-03 18:43:37','2022-09-05 21:08:09');
INSERT INTO invoices VALUES('652','1','91','3','13','1','2022-09-05','2022-09-07 08:49:44','','SEP/22','','21500.00','21500.00','Paid','2022-09-03 18:43:37','2022-09-07 08:49:44');
INSERT INTO invoices VALUES('653','1','92','1','16','1','2022-09-05','2022-09-22 05:56:04','','SEP/22','','21500.00','21500.00','Paid','2022-09-03 18:43:37','2022-09-22 05:56:04');
INSERT INTO invoices VALUES('654','1','94','1','10','1','2022-09-05','2022-09-07 08:47:02','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-07 08:47:02');
INSERT INTO invoices VALUES('671','1','95','2','12','1','2022-09-05','2022-11-01 07:11:34','','SEP/22','','33000.00','33000.00','Paid','2022-09-03 19:11:06','2022-11-01 07:11:34');
INSERT INTO invoices VALUES('656','1','96','2','12','1','2022-09-05','2022-09-03 19:14:14','','SEP/22','','23500.00','23500.00','Paid','2022-09-03 18:43:37','2022-09-03 19:14:14');
INSERT INTO invoices VALUES('657','1','97','1','2','1','2022-09-05','2022-09-03 19:42:50','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-03 19:42:50');
INSERT INTO invoices VALUES('676','1','72','1','18','1','2022-09-05','2022-09-07 08:35:39','','SEP/22','','26000.00','26000.00','Paid','2022-09-07 08:33:22','2022-09-07 08:35:39');
INSERT INTO invoices VALUES('659','1','99','3','17','1','2022-09-05','2022-09-08 19:01:16','','SEP/22','','21500.00','21500.00','Paid','2022-09-03 18:43:37','2022-09-08 19:01:16');
INSERT INTO invoices VALUES('660','1','100','3','17','1','2022-09-05','2022-09-07 08:50:46','','SEP/22','','21500.00','21500.00','Paid','2022-09-03 18:43:37','2022-09-07 08:50:46');
INSERT INTO invoices VALUES('661','1','101','1','9','1','2022-09-05','2022-09-12 06:24:49','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-12 06:24:49');
INSERT INTO invoices VALUES('662','1','102','1','11','1','2022-09-05','2022-09-05 08:48:20','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-05 08:48:20');
INSERT INTO invoices VALUES('663','1','103','1','2','1','2022-09-05','2022-09-07 08:36:55','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-07 08:36:55');
INSERT INTO invoices VALUES('664','1','104','1','9','1','2022-09-05','2022-09-03 19:07:24','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-03 19:07:24');
INSERT INTO invoices VALUES('665','1','105','1','11','1','2022-09-05','2022-09-05 19:23:45','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-05 19:23:45');
INSERT INTO invoices VALUES('666','1','106','1','11','1','2022-09-05','2022-09-05 08:49:17','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-05 08:49:17');
INSERT INTO invoices VALUES('667','1','107','1','2','1','2022-09-05','2022-09-05 20:49:43','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-05 20:49:43');
INSERT INTO invoices VALUES('668','1','109','1','1','1','2022-09-05','2022-10-16 13:24:26','','SEP/22','','20000.00','20000.00','Paid','2022-09-03 18:43:37','2022-10-16 13:24:26');
INSERT INTO invoices VALUES('669','1','110','1','2','1','2022-09-05','2022-09-05 19:24:28','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-05 19:24:28');
INSERT INTO invoices VALUES('670','1','111','1','10','1','2022-09-05','2022-09-07 08:47:55','','SEP/22','','19000.00','19000.00','Paid','2022-09-03 18:43:37','2022-09-07 08:47:55');
INSERT INTO invoices VALUES('720','1','100','3','17','1','2022-10-05','2022-10-07 08:10:50','','OCT/22','','21500.00','21500.00','Paid','2022-10-02 09:37:04','2022-10-07 08:10:50');
INSERT INTO invoices VALUES('721','1','101','1','9','1','2022-10-05','2022-10-05 08:08:51','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 08:08:51');
INSERT INTO invoices VALUES('722','1','102','1','11','1','2022-10-05','2022-10-05 07:57:45','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-05 07:57:45');
INSERT INTO invoices VALUES('723','1','103','1','2','1','2022-10-05','2022-10-08 07:00:39','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-08 07:00:39');
INSERT INTO invoices VALUES('747','1','104','1','9','1','2022-10-05','2022-11-04 13:02:32','','OCT/22','','18700.00','18700.00','Paid','2022-10-07 07:57:55','2022-11-04 13:02:32');
INSERT INTO invoices VALUES('725','1','105','1','11','1','2022-10-05','2022-10-07 08:05:22','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-07 08:05:22');
INSERT INTO invoices VALUES('726','1','106','1','11','1','2022-10-05','2022-10-13 09:30:59','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-13 09:30:59');
INSERT INTO invoices VALUES('727','1','107','1','2','1','2022-10-05','2022-10-07 07:41:58','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-07 07:41:58');
INSERT INTO invoices VALUES('728','1','109','1','1','1','2022-10-05','2022-11-21 10:18:21','','OCT/22','','20000.00','20000.00','Paid','2022-10-02 09:37:04','2022-11-21 10:18:21');
INSERT INTO invoices VALUES('729','1','110','1','2','1','2022-10-05','2022-10-07 08:04:45','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-07 08:04:45');
INSERT INTO invoices VALUES('730','1','111','1','10','1','2022-10-05','2022-10-07 08:03:46','','OCT/22','','19000.00','19000.00','Paid','2022-10-02 09:37:04','2022-10-07 08:03:46');
INSERT INTO invoices VALUES('731','1','113','1','16','1','2022-10-05','2022-10-07 08:00:18','','OCT/22','','21500.00','21500.00','Paid','2022-10-02 09:37:04','2022-10-07 08:00:18');
INSERT INTO invoices VALUES('732','1','114','1','3','1','2022-10-05','2022-10-16 13:25:29','','OCT/22','','20000.00','20000.00','Paid','2022-10-02 09:37:04','2022-10-16 13:25:29');
INSERT INTO invoices VALUES('733','1','115','1','3','1','2022-10-05','2022-10-05 07:54:35','','OCT/22','','20000.00','20000.00','Paid','2022-10-02 09:37:04','2022-10-05 07:54:35');
INSERT INTO invoices VALUES('739','1','116','2','21','1','2022-10-05','2022-10-16 13:26:56','','OCT/22','','15000.00','15000.00','Paid','2022-10-05 07:28:36','2022-10-16 13:26:56');
INSERT INTO invoices VALUES('735','1','117','2','21','1','2022-10-05','2022-10-16 13:27:36','','OCT/22','','12000.00','12000.00','Paid','2022-10-02 09:37:04','2022-10-16 13:27:36');
INSERT INTO invoices VALUES('738','1','118','2','21','1','2022-09-05','2022-10-05 07:07:51','','SEP/22','','15000.00','15000.00','Paid','2022-10-05 07:06:54','2022-10-05 07:07:51');
INSERT INTO invoices VALUES('737','1','116','2','21','1','2022-09-05','2022-10-05 07:07:30','','SEP/22','','15000.00','15000.00','Paid','2022-10-05 07:04:16','2022-10-05 07:07:30');
INSERT INTO invoices VALUES('740','1','118','2','21','1','2022-10-05','2023-03-07 18:58:53','','OCT/22','','15000.00','15000.00','Paid','2022-10-05 07:30:10','2023-03-07 18:58:53');
INSERT INTO invoices VALUES('741','1','95','2','12','1','2022-10-05','2022-10-05 07:40:15','','OCT/22','','23000.00','23000.00','Paid','2022-10-05 07:38:32','2022-10-05 07:40:15');
INSERT INTO invoices VALUES('742','1','96','2','12','1','2022-10-05','2022-10-05 07:41:02','','OCT/22','','23000.00','23000.00','Paid','2022-10-05 07:38:32','2022-10-05 07:41:02');
INSERT INTO invoices VALUES('753','1','17','1','7','1','2022-11-05','2022-11-06 15:20:46','','NOV/22','','16500.00','16500.00','Paid','2022-11-01 07:09:42','2022-11-06 15:20:46');
INSERT INTO invoices VALUES('754','1','18','1','7','1','2022-11-05','2022-11-08 09:56:40','','NOV/22','','16500.00','16500.00','Paid','2022-11-01 07:09:42','2022-11-08 09:56:40');
INSERT INTO invoices VALUES('755','1','21','1','8','1','2022-11-05','2022-11-01 07:13:12','','NOV/22','','19500.00','19500.00','Paid','2022-11-01 07:09:42','2022-11-01 07:13:12');
INSERT INTO invoices VALUES('756','1','25','1','10','1','2022-11-05','2022-11-21 10:13:45','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-21 10:13:45');
INSERT INTO invoices VALUES('757','1','35','1','7','1','2022-11-05','2022-11-06 15:19:48','','NOV/22','','16500.00','16500.00','Paid','2022-11-01 07:09:42','2022-11-06 15:19:48');
INSERT INTO invoices VALUES('758','1','40','1','4','1','2022-11-05','2022-11-02 06:42:35','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-02 06:42:35');
INSERT INTO invoices VALUES('759','1','42','2','15','1','2022-11-05','2022-11-02 06:41:06','','NOV/22','','21000.00','21000.00','Paid','2022-11-01 07:09:42','2022-11-02 06:41:06');
INSERT INTO invoices VALUES('760','1','43','1','4','1','2022-11-05','2022-11-02 16:36:55','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-02 16:36:55');
INSERT INTO invoices VALUES('761','1','44','1','11','1','2022-11-05','2022-11-16 16:55:07','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-16 16:55:07');
INSERT INTO invoices VALUES('762','1','46','2','15','1','2022-11-05','2022-11-02 16:36:29','','NOV/22','','21000.00','21000.00','Paid','2022-11-01 07:09:42','2022-11-02 16:36:29');
INSERT INTO invoices VALUES('880','1','7','1','3','1','2023-01-05','2023-01-06 10:15:08','','JAN/23','','20000.00','20000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:15:08');
INSERT INTO invoices VALUES('764','1','50','1','8','1','2022-11-05','2022-11-21 10:14:15','','NOV/22','','19500.00','19500.00','Paid','2022-11-01 07:09:42','2022-11-21 10:14:15');
INSERT INTO invoices VALUES('765','1','51','1','8','1','2022-11-05','2022-11-21 10:14:39','','NOV/22','','19500.00','19500.00','Paid','2022-11-01 07:09:42','2022-11-21 10:14:39');
INSERT INTO invoices VALUES('766','1','58','1','4','1','2022-11-05','2022-11-02 16:51:26','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-02 16:51:26');
INSERT INTO invoices VALUES('767','1','63','1','8','1','2022-11-05','2022-11-02 06:43:01','','NOV/22','','19500.00','19500.00','Paid','2022-11-01 07:09:42','2022-11-02 06:43:01');
INSERT INTO invoices VALUES('768','1','65','1','1','1','2022-11-05','2022-11-21 10:16:13','','NOV/22','','20000.00','20000.00','Paid','2022-11-01 07:09:42','2022-11-21 10:16:13');
INSERT INTO invoices VALUES('769','1','66','1','1','1','2022-11-05','2022-11-08 09:57:42','','NOV/22','','20000.00','20000.00','Paid','2022-11-01 07:09:42','2022-11-08 09:57:42');
INSERT INTO invoices VALUES('810','1','120','1','5','1','2022-11-05','2023-06-13 17:26:22','','NOV/22','','31500.00','31500.00','Paid','2022-11-06 14:51:34','2023-06-13 17:26:22');
INSERT INTO invoices VALUES('815','1','122','1','5','1','2022-11-05','2022-12-28 16:53:14','','Nov/22','','43000.00','43000.00','Paid','2022-11-16 17:06:27','2022-12-28 16:53:14');
INSERT INTO invoices VALUES('772','1','69','3','13','1','2022-11-05','2022-11-21 10:15:09','','NOV/22','','21500.00','21500.00','Paid','2022-11-01 07:09:42','2022-11-21 10:15:09');
INSERT INTO invoices VALUES('811','1','72','1','18','1','2022-11-05','2022-11-08 10:04:19','','NOV/22','','26000.00','26000.00','Paid','2022-11-08 10:03:53','2022-11-08 10:04:19');
INSERT INTO invoices VALUES('774','1','73','1','6','1','2022-11-05','2022-11-06 14:36:02','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-06 14:36:02');
INSERT INTO invoices VALUES('775','1','74','1','6','1','2022-11-05','2022-11-02 16:51:04','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-02 16:51:04');
INSERT INTO invoices VALUES('776','1','75','1','6','1','2022-11-05','2022-11-06 14:56:10','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-06 14:56:10');
INSERT INTO invoices VALUES('777','1','77','1','6','1','2022-11-05','2022-11-02 06:41:58','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-02 06:41:58');
INSERT INTO invoices VALUES('807','1','81','1','9','1','2022-11-05','2022-11-02 16:50:22','','NOV/22','','18500.00','18500.00','Paid','2022-11-02 16:49:49','2022-11-02 16:50:22');
INSERT INTO invoices VALUES('779','1','85','1','9','1','2022-11-05','2022-11-08 09:59:37','','NOV/22','','18700.00','18700.00','Paid','2022-11-01 07:09:42','2022-11-08 09:59:37');
INSERT INTO invoices VALUES('780','1','86','1','4','1','2022-11-05','2022-11-02 16:51:47','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-02 16:51:47');
INSERT INTO invoices VALUES('781','1','87','1','7','1','2022-11-05','2022-11-06 15:20:27','','NOV/22','','16500.00','16500.00','Paid','2022-11-01 07:09:42','2022-11-06 15:20:27');
INSERT INTO invoices VALUES('782','1','91','3','13','1','2022-11-05','2022-11-04 13:04:38','','NOV/22','','21500.00','21500.00','Paid','2022-11-01 07:09:42','2022-11-04 13:04:38');
INSERT INTO invoices VALUES('783','1','92','1','16','1','2022-11-05','2022-11-08 10:00:32','','NOV/22','','21500.00','21500.00','Paid','2022-11-01 07:09:42','2022-11-08 10:00:32');
INSERT INTO invoices VALUES('784','1','94','1','10','1','2022-11-05','2022-11-08 09:54:12','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:42','2022-11-08 09:54:12');
INSERT INTO invoices VALUES('785','1','95','2','12','1','2022-11-05','2022-11-01 07:11:58','','NOV/22','','23000.00','23000.00','Paid','2022-11-01 07:09:42','2022-11-01 07:11:58');
INSERT INTO invoices VALUES('786','1','96','2','12','1','2022-11-05','2023-03-08 13:52:49','','NOV/22','','23000.00','23000.00','Paid','2022-11-01 07:09:43','2023-03-08 13:52:49');
INSERT INTO invoices VALUES('787','1','97','1','2','1','2022-11-05','2022-11-06 14:56:44','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:43','2022-11-06 14:56:44');
INSERT INTO invoices VALUES('788','1','98','3','24','1','2022-11-05','2022-11-08 09:55:24','','NOV/22','','20000.00','20000.00','Paid','2022-11-01 07:09:43','2023-07-30 12:43:40');
INSERT INTO invoices VALUES('789','1','99','3','17','1','2022-11-05','2022-11-08 10:00:59','','NOV/22','','21500.00','21500.00','Paid','2022-11-01 07:09:43','2022-11-08 10:00:59');
INSERT INTO invoices VALUES('790','1','100','3','17','1','2022-11-05','2022-11-06 15:20:10','','NOV/22','','21500.00','21500.00','Paid','2022-11-01 07:09:43','2022-11-06 15:20:10');
INSERT INTO invoices VALUES('791','1','101','1','9','1','2022-11-05','2022-11-08 09:59:08','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:43','2022-11-08 09:59:08');
INSERT INTO invoices VALUES('792','1','102','1','11','1','2022-11-05','2022-11-06 14:58:43','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:43','2022-11-06 14:58:43');
INSERT INTO invoices VALUES('793','1','103','1','2','1','2022-11-05','2022-11-06 15:19:25','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:43','2022-11-06 15:19:25');
INSERT INTO invoices VALUES('809','1','104','1','9','1','2022-11-05','2022-11-04 13:01:53','','NOV/22','','18700.00','18700.00','Paid','2022-11-04 12:58:20','2022-11-04 13:01:53');
INSERT INTO invoices VALUES('795','1','105','1','11','1','2022-11-05','2022-11-08 10:01:50','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:43','2022-11-08 10:01:50');
INSERT INTO invoices VALUES('796','1','106','1','11','1','2022-11-05','2022-11-01 07:13:59','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:43','2022-11-01 07:13:59');
INSERT INTO invoices VALUES('797','1','107','1','2','1','2022-11-05','2022-11-06 14:33:55','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:43','2022-11-06 14:33:55');
INSERT INTO invoices VALUES('798','1','109','1','1','1','2022-11-05','2022-11-21 10:19:11','','NOV/22','','20000.00','6600.00','Unpaid','2022-11-01 07:09:43','2022-11-21 10:19:11');
INSERT INTO invoices VALUES('799','1','110','1','2','1','2022-11-05','2022-11-08 09:57:12','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:43','2022-11-08 09:57:12');
INSERT INTO invoices VALUES('800','1','111','1','10','1','2022-11-05','2022-11-06 14:35:25','','NOV/22','','19000.00','19000.00','Paid','2022-11-01 07:09:43','2022-11-06 14:35:25');
INSERT INTO invoices VALUES('801','1','113','1','16','1','2022-11-05','2022-11-06 14:34:40','','NOV/22','','21500.00','21500.00','Paid','2022-11-01 07:09:43','2022-11-06 14:34:40');
INSERT INTO invoices VALUES('802','1','114','1','3','1','2022-11-05','2022-11-16 17:14:38','','NOV/22','','20000.00','20000.00','Paid','2022-11-01 07:09:43','2022-11-16 17:14:38');
INSERT INTO invoices VALUES('803','1','115','1','3','1','2022-11-05','2022-11-06 14:55:40','','NOV/22','','20000.00','20000.00','Paid','2022-11-01 07:09:43','2022-11-06 14:55:40');
INSERT INTO invoices VALUES('804','1','116','2','21','1','2022-11-05','2022-12-04 08:07:12','','NOV/22','','15000.00','15000.00','Paid','2022-11-01 07:09:43','2022-12-04 08:07:12');
INSERT INTO invoices VALUES('805','1','117','2','21','1','2022-11-05','2022-11-06 14:55:14','','NOV/22','','12000.00','12000.00','Paid','2022-11-01 07:09:43','2022-11-06 14:55:14');
INSERT INTO invoices VALUES('806','1','118','2','21','1','2022-11-05','2022-12-04 08:07:39','','NOV/22','','15000.00','15000.00','Paid','2022-11-01 07:09:43','2022-12-04 08:07:39');
INSERT INTO invoices VALUES('808','1','119','1','10','1','2022-11-05','2022-11-03 06:32:02','','Nov/22','','36000.00','36000.00','Paid','2022-11-03 06:31:11','2022-11-03 06:32:02');
INSERT INTO invoices VALUES('813','1','121','1','7','1','2022-11-05','2022-11-16 16:55:42','','Nov/22','only 15 days rent','17500.00','17500.00','Paid','2022-11-16 16:52:26','2022-11-16 16:55:42');
INSERT INTO invoices VALUES('817','1','124','2','22','1','2022-11-05','2022-12-10 08:30:14','','NOV/22','','20000.00','20000.00','Paid','2022-12-10 08:29:24','2022-12-10 08:30:14');
INSERT INTO invoices VALUES('818','1','125','2','22','1','2022-11-05','2022-12-10 08:30:57','','NOV/22','','20000.00','20000.00','Paid','2022-12-10 08:29:24','2022-12-10 08:30:57');
INSERT INTO invoices VALUES('819','1','126','3','13','1','2022-12-05','2023-01-09 14:29:54','','DEC/22','','43000.00','43000.00','Paid','2022-12-22 05:42:10','2023-01-09 14:29:54');
INSERT INTO invoices VALUES('820','1','3','2','14','1','2022-12-05','2022-12-28 16:52:29','','DEC/22','','24000.00','24000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:52:29');
INSERT INTO invoices VALUES('821','1','7','1','3','1','2022-12-05','2022-12-22 06:52:33','','DEC/22','','20000.00','20000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:52:33');
INSERT INTO invoices VALUES('822','1','15','1','7','1','2022-12-05','2022-12-28 16:23:42','','DEC/22','','15000.00','15000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:23:42');
INSERT INTO invoices VALUES('823','1','17','1','7','1','2022-12-05','2022-12-28 17:18:19','','DEC/22','','15000.00','15000.00','Paid','2022-12-22 05:43:30','2022-12-28 17:18:19');
INSERT INTO invoices VALUES('824','1','18','1','7','1','2022-12-05','2022-12-28 16:25:15','','DEC/22','','15000.00','15000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:25:15');
INSERT INTO invoices VALUES('825','1','21','1','8','1','2022-12-05','2022-12-22 06:52:04','','DEC/22','','19500.00','19500.00','Paid','2022-12-22 05:43:30','2022-12-22 06:52:04');
INSERT INTO invoices VALUES('826','1','25','1','10','1','2022-12-05','2022-12-22 06:46:46','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:46:46');
INSERT INTO invoices VALUES('827','1','35','1','7','1','2022-12-05','2022-12-28 16:48:30','','DEC/22','','15000.00','15000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:48:30');
INSERT INTO invoices VALUES('828','1','40','1','4','1','2022-12-05','2022-12-22 06:59:07','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:59:07');
INSERT INTO invoices VALUES('829','1','42','2','15','1','2022-12-05','2022-12-22 06:44:58','','DEC/22','','21000.00','21000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:44:58');
INSERT INTO invoices VALUES('830','1','43','1','4','1','2022-12-05','2022-12-22 06:47:13','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:47:13');
INSERT INTO invoices VALUES('831','1','44','1','11','1','2022-12-05','2022-12-28 16:46:56','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:46:56');
INSERT INTO invoices VALUES('832','1','46','2','15','1','2022-12-05','2022-12-22 06:45:33','','DEC/22','','21000.00','21000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:45:33');
INSERT INTO invoices VALUES('833','1','50','1','8','1','2022-12-05','2022-12-28 17:15:57','','DEC/22','','19500.00','19500.00','Paid','2022-12-22 05:43:30','2022-12-28 17:15:57');
INSERT INTO invoices VALUES('834','1','51','1','8','1','2022-12-05','2022-12-28 17:11:28','','DEC/22','','19500.00','19500.00','Paid','2022-12-22 05:43:30','2022-12-28 17:11:28');
INSERT INTO invoices VALUES('835','1','58','1','4','1','2022-12-05','2022-12-22 06:58:03','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:58:03');
INSERT INTO invoices VALUES('836','1','63','1','8','1','2022-12-05','2022-12-28 17:14:36','','DEC/22','','19500.00','19500.00','Paid','2022-12-22 05:43:30','2022-12-28 17:14:36');
INSERT INTO invoices VALUES('837','1','65','1','1','1','2022-12-05','2022-12-28 17:19:42','','DEC/22','','20000.00','20000.00','Paid','2022-12-22 05:43:30','2022-12-28 17:19:42');
INSERT INTO invoices VALUES('838','1','66','1','1','1','2022-12-05','2022-12-22 07:03:59','','DEC/22','','20000.00','20000.00','Paid','2022-12-22 05:43:30','2022-12-22 07:03:59');
INSERT INTO invoices VALUES('877','1','72','1','18','1','2022-12-05','2022-12-28 16:20:24','','DEC/22','','26000.00','26000.00','Paid','2022-12-28 16:19:38','2022-12-28 16:20:24');
INSERT INTO invoices VALUES('840','1','73','1','6','1','2022-12-05','2022-12-22 06:58:33','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:58:33');
INSERT INTO invoices VALUES('841','1','74','1','6','1','2022-12-05','2022-12-22 06:46:08','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:46:08');
INSERT INTO invoices VALUES('842','1','75','1','6','1','2022-12-05','2022-12-22 06:57:36','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:57:36');
INSERT INTO invoices VALUES('843','1','77','1','6','1','2022-12-05','2022-12-22 06:44:15','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:44:15');
INSERT INTO invoices VALUES('844','1','81','1','9','1','2022-12-05','2022-12-28 17:18:46','','DEC/22','','18500.00','18500.00','Paid','2022-12-22 05:43:30','2022-12-28 17:18:46');
INSERT INTO invoices VALUES('845','1','85','1','9','1','2022-12-05','2022-12-28 16:46:10','','DEC/22','','18700.00','18700.00','Paid','2022-12-22 05:43:30','2022-12-28 16:46:10');
INSERT INTO invoices VALUES('846','1','86','1','4','1','2022-12-05','2022-12-22 06:47:35','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:47:35');
INSERT INTO invoices VALUES('847','1','87','1','7','1','2022-12-05','2022-12-28 16:47:24','','DEC/22','','15000.00','15000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:47:24');
INSERT INTO invoices VALUES('848','1','91','3','13','1','2022-12-05','2022-12-28 17:17:41','','DEC/22','','21500.00','21500.00','Paid','2022-12-22 05:43:30','2022-12-28 17:17:41');
INSERT INTO invoices VALUES('849','1','92','1','16','1','2022-12-05','2022-12-28 17:05:13','','DEC/22','','21500.00','21500.00','Paid','2022-12-22 05:43:30','2022-12-28 17:05:13');
INSERT INTO invoices VALUES('850','1','94','1','10','1','2022-12-05','2022-12-28 17:13:28','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-28 17:13:28');
INSERT INTO invoices VALUES('851','1','95','2','12','1','2022-12-05','2022-12-22 06:43:54','','DEC/22','','23000.00','22000.00','Unpaid','2022-12-22 05:43:30','2022-12-22 06:43:54');
INSERT INTO invoices VALUES('852','1','96','2','12','1','2022-12-05','2022-12-22 06:55:14','','DEC/22','','23000.00','20000.00','Unpaid','2022-12-22 05:43:30','2022-12-22 06:55:14');
INSERT INTO invoices VALUES('853','1','97','1','2','1','2022-12-05','2022-12-28 17:12:24','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-28 17:12:24');
INSERT INTO invoices VALUES('854','1','98','2','20','1','2022-12-05','2022-12-28 17:10:24','','DEC/22','','22000.00','22000.00','Paid','2022-12-22 05:43:30','2022-12-28 17:10:24');
INSERT INTO invoices VALUES('855','1','99','3','17','1','2022-12-05','2022-12-28 16:59:33','','DEC/22','','21500.00','21500.00','Paid','2022-12-22 05:43:30','2022-12-28 16:59:33');
INSERT INTO invoices VALUES('856','1','100','3','17','1','2022-12-05','2022-12-28 17:09:51','','DEC/22','','21500.00','21500.00','Paid','2022-12-22 05:43:30','2022-12-28 17:09:51');
INSERT INTO invoices VALUES('857','1','101','1','9','1','2022-12-05','2022-12-28 17:19:11','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-28 17:19:11');
INSERT INTO invoices VALUES('858','1','102','1','11','1','2022-12-05','2022-12-28 16:50:50','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:50:50');
INSERT INTO invoices VALUES('859','1','103','1','2','1','2022-12-05','2022-12-28 16:54:56','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:54:56');
INSERT INTO invoices VALUES('878','1','104','1','9','1','2022-12-05','2022-12-28 16:28:41','','DEC/22','','18500.00','18500.00','Paid','2022-12-28 16:28:00','2022-12-28 16:28:41');
INSERT INTO invoices VALUES('861','1','105','1','11','1','2022-12-05','2022-12-22 06:56:03','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:56:03');
INSERT INTO invoices VALUES('862','1','106','1','11','1','2022-12-05','2022-12-28 16:51:27','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:51:27');
INSERT INTO invoices VALUES('863','1','107','1','2','1','2022-12-05','2022-12-22 07:29:54','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 07:29:54');
INSERT INTO invoices VALUES('864','1','110','1','2','1','2022-12-05','2022-12-22 07:09:19','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-22 07:09:19');
INSERT INTO invoices VALUES('865','1','111','1','10','1','2022-12-05','2022-12-28 16:23:10','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:23:10');
INSERT INTO invoices VALUES('866','1','113','1','16','1','2022-12-05','2022-12-22 07:03:01','','DEC/22','','21500.00','21500.00','Paid','2022-12-22 05:43:30','2022-12-22 07:03:01');
INSERT INTO invoices VALUES('867','1','114','1','3','1','2022-12-05','2022-12-28 17:12:53','','DEC/22','','20000.00','20000.00','Paid','2022-12-22 05:43:30','2022-12-28 17:12:53');
INSERT INTO invoices VALUES('868','1','115','1','3','1','2022-12-05','2022-12-22 06:56:38','','DEC/22','','20000.00','20000.00','Paid','2022-12-22 05:43:30','2022-12-22 06:56:38');
INSERT INTO invoices VALUES('869','1','116','2','21','1','2022-12-05','2023-03-07 19:00:17','','DEC/22','','15000.00','15000.00','Paid','2022-12-22 05:43:30','2023-03-07 19:00:17');
INSERT INTO invoices VALUES('870','1','117','2','21','1','2022-12-05','2022-12-22 07:00:35','','DEC/22','','12000.00','12000.00','Paid','2022-12-22 05:43:30','2022-12-22 07:00:35');
INSERT INTO invoices VALUES('871','1','118','2','21','1','2022-12-05','2023-01-06 10:13:17','','DEC/22','','15000.00','15000.00','Paid','2022-12-22 05:43:30','2023-01-06 10:13:17');
INSERT INTO invoices VALUES('872','1','119','1','10','1','2022-12-05','2022-12-28 17:13:56','','DEC/22','','19000.00','19000.00','Paid','2022-12-22 05:43:30','2022-12-28 17:13:56');
INSERT INTO invoices VALUES('873','1','120','1','5','1','2022-12-05','2023-01-06 10:30:47','','DEC/22','','21500.00','21500.00','Paid','2022-12-22 05:43:30','2023-01-06 10:30:47');
INSERT INTO invoices VALUES('874','1','121','1','7','1','2022-12-05','2022-12-28 16:24:46','','DEC/22','','15000.00','15000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:24:46');
INSERT INTO invoices VALUES('875','1','122','1','5','1','2022-12-05','2022-12-28 16:53:32','','DEC/22','','21500.00','21500.00','Paid','2022-12-22 05:43:30','2022-12-28 16:53:32');
INSERT INTO invoices VALUES('876','1','123','1','1','1','2022-12-05','2022-12-28 16:22:29','','DEC/22','','20000.00','20000.00','Paid','2022-12-22 05:43:30','2022-12-28 16:22:29');
INSERT INTO invoices VALUES('881','1','15','1','7','1','2023-01-05','2023-01-06 10:50:37','','JAN/23','','15000.00','15000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:50:37');
INSERT INTO invoices VALUES('882','1','17','1','7','1','2023-01-05','2023-01-06 10:50:14','','JAN/23','','15000.00','15000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:50:14');
INSERT INTO invoices VALUES('883','1','18','1','7','1','2023-01-05','2023-01-20 11:43:57','','JAN/23','','15000.00','15000.00','Paid','2023-01-06 07:13:21','2023-01-20 11:43:57');
INSERT INTO invoices VALUES('884','1','21','1','8','1','2023-01-05','2023-02-03 11:59:44','','JAN/23','','19500.00','19500.00','Paid','2023-01-06 07:13:21','2023-02-03 11:59:44');
INSERT INTO invoices VALUES('942','1','3','2','14','1','2023-02-05','2023-02-09 12:17:34','','FEB/23','','24000.00','24000.00','Paid','2023-02-03 11:53:43','2023-02-09 12:17:34');
INSERT INTO invoices VALUES('886','1','35','1','7','1','2023-01-05','2023-01-24 15:10:05','','JAN/23','','15000.00','15000.00','Paid','2023-01-06 07:13:21','2023-01-24 15:10:05');
INSERT INTO invoices VALUES('887','1','40','1','4','1','2023-01-05','2023-01-24 14:19:44','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-24 14:19:44');
INSERT INTO invoices VALUES('888','1','42','2','15','1','2023-01-05','2023-01-06 10:11:21','','JAN/23','','21000.00','21000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:11:21');
INSERT INTO invoices VALUES('889','1','43','1','4','1','2023-01-05','2023-01-06 10:24:21','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:24:21');
INSERT INTO invoices VALUES('890','1','44','1','11','1','2023-01-05','2023-01-06 10:48:27','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:48:27');
INSERT INTO invoices VALUES('891','1','46','2','15','1','2023-01-05','2023-01-06 10:11:42','','JAN/23','','21000.00','21000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:11:42');
INSERT INTO invoices VALUES('892','1','50','1','8','1','2023-01-05','2023-01-20 11:46:05','','JAN/23','','19500.00','19500.00','Paid','2023-01-06 07:13:21','2023-01-20 11:46:05');
INSERT INTO invoices VALUES('893','1','51','1','8','1','2023-01-05','2023-01-20 11:48:46','','JAN/23','','19500.00','19500.00','Paid','2023-01-06 07:13:21','2023-01-20 11:48:46');
INSERT INTO invoices VALUES('894','1','58','1','4','1','2023-01-05','2023-01-06 10:31:47','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:31:47');
INSERT INTO invoices VALUES('895','1','63','1','8','1','2023-01-05','2023-01-06 10:25:31','','JAN/23','','19500.00','19500.00','Paid','2023-01-06 07:13:21','2023-01-06 10:25:31');
INSERT INTO invoices VALUES('896','1','65','1','1','1','2023-01-05','2023-04-07 11:17:47','','JAN/23','','20000.00','20000.00','Paid','2023-01-06 07:13:21','2023-04-07 11:17:47');
INSERT INTO invoices VALUES('897','1','66','1','1','1','2023-01-05','2023-01-06 10:47:32','','JAN/23','','20000.00','20000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:47:32');
INSERT INTO invoices VALUES('898','1','72','1','18','1','2023-01-05','2023-01-10 14:31:55','','JAN/23','','26000.00','26000.00','Paid','2023-01-06 07:13:21','2023-01-10 14:31:55');
INSERT INTO invoices VALUES('899','1','73','1','6','1','2023-01-05','2023-01-06 10:24:51','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:24:51');
INSERT INTO invoices VALUES('900','1','74','1','6','1','2023-01-05','2023-01-06 10:10:42','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:10:42');
INSERT INTO invoices VALUES('901','1','75','1','6','1','2023-01-05','2023-01-24 14:16:33','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-24 14:16:33');
INSERT INTO invoices VALUES('902','1','77','1','6','1','2023-01-05','2023-01-06 10:10:16','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:10:16');
INSERT INTO invoices VALUES('903','1','81','1','9','1','2023-01-05','2023-01-20 11:51:08','','JAN/23','','18500.00','18500.00','Paid','2023-01-06 07:13:21','2023-01-20 11:51:08');
INSERT INTO invoices VALUES('904','1','85','1','9','1','2023-01-05','2023-01-20 11:49:25','','JAN/23','','18700.00','18700.00','Paid','2023-01-06 07:13:21','2023-01-20 11:49:25');
INSERT INTO invoices VALUES('905','1','86','1','4','1','2023-01-05','2023-01-06 10:23:58','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:23:58');
INSERT INTO invoices VALUES('906','1','87','1','7','1','2023-01-05','2023-01-20 11:47:20','','JAN/23','','15000.00','15000.00','Paid','2023-01-06 07:13:21','2023-01-20 11:47:20');
INSERT INTO invoices VALUES('907','1','91','3','13','1','2023-01-05','2023-01-10 17:49:04','','JAN/23','','21500.00','21500.00','Paid','2023-01-06 07:13:21','2023-01-10 17:49:04');
INSERT INTO invoices VALUES('908','1','92','1','16','1','2023-01-05','2023-01-10 17:43:47','','JAN/23','','21500.00','21500.00','Paid','2023-01-06 07:13:21','2023-01-10 17:43:47');
INSERT INTO invoices VALUES('909','1','94','1','10','1','2023-01-05','2023-01-07 06:28:44','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-07 06:28:44');
INSERT INTO invoices VALUES('910','1','95','2','12','1','2023-01-05','2023-01-06 10:09:45','','JAN/23','','23000.00','20000.00','Unpaid','2023-01-06 07:13:21','2023-01-06 10:09:45');
INSERT INTO invoices VALUES('911','1','96','2','12','1','2023-01-05','2023-01-06 10:32:37','','JAN/23','','23000.00','20000.00','Unpaid','2023-01-06 07:13:21','2023-01-06 10:32:37');
INSERT INTO invoices VALUES('912','1','97','1','2','1','2023-01-05','2023-01-06 10:23:26','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:23:26');
INSERT INTO invoices VALUES('913','1','98','2','20','1','2023-01-05','2023-01-26 15:09:20','','JAN/23','','22000.00','22000.00','Paid','2023-01-06 07:13:21','2023-01-26 15:09:20');
INSERT INTO invoices VALUES('914','1','99','3','17','1','2023-01-05','2023-01-20 11:48:03','','JAN/23','','21500.00','21500.00','Paid','2023-01-06 07:13:21','2023-01-20 11:48:03');
INSERT INTO invoices VALUES('915','1','100','3','17','1','2023-01-05','2023-01-09 19:02:26','','JAN/23','','21500.00','21500.00','Paid','2023-01-06 07:13:21','2023-01-09 19:02:26');
INSERT INTO invoices VALUES('916','1','101','1','9','1','2023-01-05','2023-01-06 10:48:56','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:48:56');
INSERT INTO invoices VALUES('917','1','102','1','11','1','2023-01-05','2023-02-09 10:30:26','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-02-09 10:30:26');
INSERT INTO invoices VALUES('918','1','103','1','2','1','2023-01-05','2023-01-20 11:51:48','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-20 11:51:48');
INSERT INTO invoices VALUES('919','1','104','1','9','1','2023-01-05','2023-01-20 11:50:19','','JAN/23','','18500.00','18500.00','Paid','2023-01-06 07:13:21','2023-01-20 11:50:19');
INSERT INTO invoices VALUES('920','1','105','1','11','1','2023-01-05','2023-01-26 15:01:06','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-26 15:01:06');
INSERT INTO invoices VALUES('921','1','106','1','11','1','2023-01-05','2023-01-20 11:44:45','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-20 11:44:45');
INSERT INTO invoices VALUES('922','1','107','1','2','1','2023-01-05','2023-01-06 10:26:33','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:26:33');
INSERT INTO invoices VALUES('923','1','110','1','2','1','2023-01-05','2023-01-06 16:25:05','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-06 16:25:05');
INSERT INTO invoices VALUES('924','1','111','1','10','1','2023-01-05','2023-01-20 11:42:59','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-20 11:42:59');
INSERT INTO invoices VALUES('925','1','113','1','16','1','2023-01-05','2023-01-26 15:08:28','','JAN/23','','21500.00','21500.00','Paid','2023-01-06 07:13:21','2023-01-26 15:08:28');
INSERT INTO invoices VALUES('926','1','114','1','3','1','2023-01-05','2023-02-03 12:05:53','','JAN/23','','20000.00','20000.00','Paid','2023-01-06 07:13:21','2023-02-03 12:05:53');
INSERT INTO invoices VALUES('927','1','115','1','3','1','2023-01-05','2023-01-06 10:51:06','','JAN/23','','20000.00','20000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:51:06');
INSERT INTO invoices VALUES('928','1','116','2','21','1','2023-01-05','2023-01-24 14:56:30','','JAN/23','','15000.00','15000.00','Paid','2023-01-06 07:13:21','2023-01-24 14:56:30');
INSERT INTO invoices VALUES('929','1','117','2','21','1','2023-01-05','2023-01-06 10:12:36','','JAN/23','','12000.00','12000.00','Paid','2023-01-06 07:13:21','2023-01-06 10:12:36');
INSERT INTO invoices VALUES('930','1','118','2','21','1','2023-01-05','2023-01-24 14:56:58','','JAN/23','','15000.00','15000.00','Paid','2023-01-06 07:13:21','2023-01-24 14:56:58');
INSERT INTO invoices VALUES('931','1','119','1','10','1','2023-01-05','2023-01-07 16:10:47','','JAN/23','','19000.00','19000.00','Paid','2023-01-06 07:13:21','2023-01-07 16:10:47');
INSERT INTO invoices VALUES('932','1','120','1','5','1','2023-01-05','2023-01-06 10:29:55','','JAN/23','','21500.00','21500.00','Paid','2023-01-06 07:13:21','2023-01-06 10:29:55');
INSERT INTO invoices VALUES('933','1','121','1','7','1','2023-01-05','2023-01-24 15:12:13','','JAN/23','','15000.00','15000.00','Paid','2023-01-06 07:13:21','2023-01-24 15:12:13');
INSERT INTO invoices VALUES('934','1','122','1','5','1','2023-01-05','2023-01-24 15:17:11','','JAN/23','','21500.00','21500.00','Paid','2023-01-06 07:13:21','2023-01-24 15:17:11');
INSERT INTO invoices VALUES('935','1','123','1','1','1','2023-01-05','2023-01-07 16:12:34','','JAN/23','','20000.00','20000.00','Paid','2023-01-06 07:13:21','2023-01-07 16:12:34');
INSERT INTO invoices VALUES('940','1','124','2','22','1','2023-01-05','2023-01-24 14:20:29','','JAN/23','ONLY FIFTEEN DAYS RENT','10000.00','10000.00','Paid','2023-01-24 14:13:20','2023-01-24 14:20:29');
INSERT INTO invoices VALUES('938','1','126','3','13','1','2023-01-05','2023-06-07 16:40:28','','JAN/23','','21500.00','21500.00','Paid','2023-01-06 07:13:21','2023-06-07 16:40:28');
INSERT INTO invoices VALUES('939','1','127','1','10','1','2023-01-05','2023-03-07 18:55:29','','JAN/23','','38000.00','38000.00','Paid','2023-01-06 10:45:34','2023-03-07 18:55:29');
INSERT INTO invoices VALUES('941','1','125','2','22','1','2023-01-05','2023-01-24 14:55:47','','JAN/23','ONLY FIFTEEN DAYS RENT','10000.00','10000.00','Paid','2023-01-24 14:13:20','2023-01-24 14:55:47');
INSERT INTO invoices VALUES('943','1','7','1','3','1','2023-02-05','2023-02-03 12:09:16','','FEB/23','','20000.00','20000.00','Paid','2023-02-03 11:53:43','2023-02-03 12:09:16');
INSERT INTO invoices VALUES('944','1','15','1','7','1','2023-02-05','2023-02-09 10:16:21','','FEB/23','','15000.00','15000.00','Paid','2023-02-03 11:53:43','2023-02-09 10:16:21');
INSERT INTO invoices VALUES('945','1','17','1','7','1','2023-02-05','2023-02-09 10:14:42','','FEB/23','','15000.00','15000.00','Paid','2023-02-03 11:53:43','2023-02-09 10:14:42');
INSERT INTO invoices VALUES('946','1','18','1','7','1','2023-02-05','2023-02-09 12:10:55','','FEB/23','','15000.00','15000.00','Paid','2023-02-03 11:53:43','2023-02-09 12:10:55');
INSERT INTO invoices VALUES('947','1','21','1','8','1','2023-02-05','2023-02-03 12:00:21','','FEB/23','','19500.00','19500.00','Paid','2023-02-03 11:53:43','2023-02-03 12:00:21');
INSERT INTO invoices VALUES('948','1','35','1','7','1','2023-02-05','2023-02-09 10:13:20','','FEB/23','','15000.00','15000.00','Paid','2023-02-03 11:53:43','2023-02-09 10:13:20');
INSERT INTO invoices VALUES('949','1','40','1','4','1','2023-02-05','2023-02-03 12:05:20','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:43','2023-02-03 12:05:20');
INSERT INTO invoices VALUES('950','1','42','2','15','1','2023-02-05','2023-02-03 14:00:25','','FEB/23','','21000.00','21000.00','Paid','2023-02-03 11:53:43','2023-02-03 14:00:25');
INSERT INTO invoices VALUES('951','1','43','1','4','1','2023-02-05','2023-02-09 10:12:46','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:43','2023-02-09 10:12:46');
INSERT INTO invoices VALUES('952','1','44','1','11','1','2023-02-05','2023-02-09 12:28:01','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:43','2023-02-09 12:28:01');
INSERT INTO invoices VALUES('953','1','46','2','15','1','2023-02-05','2023-02-03 13:58:27','','FEB/23','','21000.00','21000.00','Paid','2023-02-03 11:53:43','2023-02-03 13:58:27');
INSERT INTO invoices VALUES('954','1','50','1','8','1','2023-02-05','2023-03-07 18:37:57','','FEB/23','','19500.00','19500.00','Paid','2023-02-03 11:53:43','2023-03-07 18:37:57');
INSERT INTO invoices VALUES('955','1','51','1','8','1','2023-02-05','2023-03-07 18:53:33','','FEB/23','','19500.00','19500.00','Paid','2023-02-03 11:53:43','2023-03-07 18:53:33');
INSERT INTO invoices VALUES('956','1','58','1','4','1','2023-02-05','2023-02-09 10:17:00','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:44','2023-02-09 10:17:00');
INSERT INTO invoices VALUES('957','1','63','1','8','1','2023-02-05','2023-02-09 12:16:20','','FEB/23','','19500.00','19500.00','Paid','2023-02-03 11:53:44','2023-02-09 12:16:20');
INSERT INTO invoices VALUES('958','1','65','1','1','1','2023-02-05','2023-03-08 13:14:03','','FEB/23','','20000.00','20000.00','Paid','2023-02-03 11:53:44','2023-03-08 13:14:03');
INSERT INTO invoices VALUES('959','1','66','1','1','1','2023-02-05','2023-02-09 10:19:47','','FEB/23','','20000.00','20000.00','Paid','2023-02-03 11:53:44','2023-02-09 10:19:47');
INSERT INTO invoices VALUES('960','1','72','1','18','1','2023-02-05','2023-02-09 12:18:39','','FEB/23','','26000.00','26000.00','Paid','2023-02-03 11:53:44','2023-02-09 12:18:39');
INSERT INTO invoices VALUES('961','1','73','1','6','1','2023-02-05','2023-02-03 12:04:40','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:44','2023-02-03 12:04:40');
INSERT INTO invoices VALUES('962','1','74','1','6','1','2023-02-05','2023-02-09 08:02:35','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:44','2023-02-09 08:02:35');
INSERT INTO invoices VALUES('963','1','75','1','6','1','2023-02-05','2023-03-07 18:57:58','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:44','2023-03-07 18:57:58');
INSERT INTO invoices VALUES('964','1','77','1','6','1','2023-02-05','2023-02-03 11:57:08','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:44','2023-02-03 11:57:08');
INSERT INTO invoices VALUES('965','1','81','1','9','1','2023-02-05','2023-02-03 12:07:10','','FEB/23','','18500.00','18500.00','Paid','2023-02-03 11:53:44','2023-02-03 12:07:10');
INSERT INTO invoices VALUES('966','1','85','1','9','1','2023-02-05','2023-03-07 18:56:50','','FEB/23','','18700.00','18700.00','Paid','2023-02-03 11:53:44','2023-03-07 18:56:50');
INSERT INTO invoices VALUES('967','1','86','1','4','1','2023-02-05','2023-02-03 11:57:53','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:44','2023-02-03 11:57:53');
INSERT INTO invoices VALUES('968','1','87','1','7','1','2023-02-05','2023-02-09 12:11:32','','FEB/23','','15000.00','15000.00','Paid','2023-02-03 11:53:44','2023-02-09 12:11:32');
INSERT INTO invoices VALUES('969','1','91','3','13','1','2023-02-05','2023-02-09 12:15:06','','FEB/23','','21500.00','21500.00','Paid','2023-02-03 11:53:44','2023-02-09 12:15:06');
INSERT INTO invoices VALUES('970','1','92','1','16','1','2023-02-05','2023-02-09 19:43:11','','FEB/23','','21500.00','21500.00','Paid','2023-02-03 11:53:44','2023-02-09 19:43:11');
INSERT INTO invoices VALUES('971','1','94','1','10','1','2023-02-05','2023-02-09 12:20:59','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:44','2023-02-09 12:20:59');
INSERT INTO invoices VALUES('972','1','95','2','12','1','2023-02-05','2023-02-03 11:56:04','','FEB/23','','23000.00','23000.00','Paid','2023-02-03 11:53:44','2023-02-03 11:56:04');
INSERT INTO invoices VALUES('973','1','96','2','12','1','2023-02-05','2023-02-09 10:15:41','','FEB/23','','23000.00','20000.00','Unpaid','2023-02-03 11:53:44','2023-02-09 10:15:41');
INSERT INTO invoices VALUES('974','1','97','1','2','1','2023-02-05','2023-03-07 18:38:55','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:44','2023-03-07 18:38:55');
INSERT INTO invoices VALUES('975','1','98','2','20','1','2023-02-05','2023-03-09 07:26:09','','FEB/23','','22000.00','22000.00','Paid','2023-02-03 11:53:44','2023-03-09 07:26:09');
INSERT INTO invoices VALUES('976','1','99','3','17','1','2023-02-05','2023-03-09 07:23:21','','FEB/23','','21500.00','21500.00','Paid','2023-02-03 11:53:45','2023-03-09 07:23:21');
INSERT INTO invoices VALUES('977','1','100','3','17','1','2023-02-05','2023-03-09 10:27:12','','FEB/23','','21500.00','21500.00','Paid','2023-02-03 11:53:45','2023-03-09 10:27:12');
INSERT INTO invoices VALUES('978','1','101','1','9','1','2023-02-05','2023-03-09 10:22:05','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:45','2023-03-09 10:22:05');
INSERT INTO invoices VALUES('979','1','102','1','11','1','2023-02-05','2023-02-09 10:31:34','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:45','2023-02-09 10:31:34');
INSERT INTO invoices VALUES('980','1','103','1','2','1','2023-02-05','2023-02-09 12:13:58','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:45','2023-02-09 12:13:58');
INSERT INTO invoices VALUES('981','1','104','1','9','1','2023-02-05','2023-02-09 12:14:34','','FEB/23','','18500.00','18500.00','Paid','2023-02-03 11:53:45','2023-02-09 12:14:34');
INSERT INTO invoices VALUES('982','1','105','1','11','1','2023-02-05','2023-02-09 10:14:01','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:45','2023-02-09 10:14:01');
INSERT INTO invoices VALUES('983','1','106','1','11','1','2023-02-05','2023-02-09 10:20:27','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:45','2023-02-09 10:20:27');
INSERT INTO invoices VALUES('984','1','107','1','2','1','2023-02-05','2023-02-03 12:08:48','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:45','2023-02-03 12:08:48');
INSERT INTO invoices VALUES('985','1','110','1','2','1','2023-02-05','2023-02-09 12:25:33','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:45','2023-02-09 12:25:33');
INSERT INTO invoices VALUES('986','1','111','1','10','1','2023-02-05','2023-02-09 12:15:46','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:45','2023-02-09 12:15:46');
INSERT INTO invoices VALUES('987','1','113','1','16','1','2023-02-05','2023-02-09 10:20:57','','FEB/23','','21500.00','21500.00','Paid','2023-02-03 11:53:45','2023-02-09 10:20:57');
INSERT INTO invoices VALUES('988','1','114','1','3','1','2023-02-05','2023-02-03 12:06:21','','FEB/23','','20000.00','20000.00','Paid','2023-02-03 11:53:45','2023-02-03 12:06:21');
INSERT INTO invoices VALUES('989','1','115','1','3','1','2023-02-05','2023-02-03 12:10:46','','FEB/23','','20000.00','20000.00','Paid','2023-02-03 11:53:45','2023-02-03 12:10:46');
INSERT INTO invoices VALUES('990','1','116','2','21','1','2023-02-05','2023-03-07 19:01:22','','FEB/23','','15000.00','15000.00','Paid','2023-02-03 11:53:45','2023-03-07 19:01:22');
INSERT INTO invoices VALUES('991','1','117','2','21','1','2023-02-05','2023-02-03 11:55:26','','FEB/23','','12000.00','12000.00','Paid','2023-02-03 11:53:45','2023-02-03 11:55:26');
INSERT INTO invoices VALUES('992','1','118','2','21','1','2023-02-05','2023-03-07 18:59:34','','FEB/23','','15000.00','15000.00','Paid','2023-02-03 11:53:46','2023-03-07 18:59:34');
INSERT INTO invoices VALUES('993','1','119','1','10','1','2023-02-05','2023-02-09 12:28:45','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:46','2023-02-09 12:28:45');
INSERT INTO invoices VALUES('994','1','120','1','5','1','2023-02-05','2023-03-07 18:30:35','','FEB/23','','21500.00','21500.00','Paid','2023-02-03 11:53:46','2023-03-07 18:30:35');
INSERT INTO invoices VALUES('995','1','121','1','7','1','2023-02-05','2023-02-09 10:17:57','','FEB/23','','15000.00','15000.00','Paid','2023-02-03 11:53:46','2023-02-09 10:17:57');
INSERT INTO invoices VALUES('996','1','122','1','5','1','2023-02-05','2023-04-07 10:30:21','','FEB/23','','21500.00','21500.00','Paid','2023-02-03 11:53:46','2023-04-07 10:30:21');
INSERT INTO invoices VALUES('997','1','123','1','1','1','2023-02-05','2023-02-09 12:26:35','','FEB/23','','20000.00','10000.00','Unpaid','2023-02-03 11:53:46','2023-02-09 12:26:35');
INSERT INTO invoices VALUES('1005','1','129','1','23','1','2023-02-05','2023-03-08 13:24:56','','FEB/23','','20000.00','20000.00','Paid','2023-03-07 19:03:00','2023-03-08 13:24:56');
INSERT INTO invoices VALUES('1006','1','130','1','23','1','2023-02-05','2023-03-07 19:05:02','','FEB/23','','20000.00','20000.00','Paid','2023-03-07 19:03:01','2023-03-07 19:05:02');
INSERT INTO invoices VALUES('1000','1','126','3','13','1','2023-02-05','2023-02-09 12:13:24','','FEB/23','','21500.00','21500.00','Paid','2023-02-03 11:53:46','2023-02-09 12:13:24');
INSERT INTO invoices VALUES('1001','1','127','1','10','1','2023-02-05','2023-02-09 12:24:45','','FEB/23','','19000.00','19000.00','Paid','2023-02-03 11:53:46','2023-02-09 12:24:45');
INSERT INTO invoices VALUES('1002','1','124','2','22','1','2023-02-05','2023-02-09 12:20:00','','FEB/23','','33000.00','28000.00','Paid','2023-02-09 10:49:28','2023-06-13 17:36:06');
INSERT INTO invoices VALUES('1003','1','124','2','22','1','2023-02-05','2023-03-09 07:27:27','','FEB/23','','18000.00','18000.00','Paid','2023-02-09 10:50:27','2023-03-09 07:27:27');
INSERT INTO invoices VALUES('1004','1','125','2','22','1','2023-02-05','2023-02-09 12:22:17','','FEB/23','','18000.00','18000.00','Paid','2023-02-09 10:51:34','2023-02-09 12:22:17');
INSERT INTO invoices VALUES('1007','1','3','2','14','1','2023-03-05','2023-03-09 07:30:31','','MAR/23','','24000.00','24000.00','Paid','2023-03-07 19:16:26','2023-03-09 07:30:31');
INSERT INTO invoices VALUES('1008','1','7','1','3','1','2023-03-05','2023-03-07 19:17:38','','MAR/23','','20000.00','20000.00','Paid','2023-03-07 19:16:26','2023-03-07 19:17:38');
INSERT INTO invoices VALUES('1009','1','15','1','7','1','2023-03-05','2023-03-08 13:29:11','','MAR/23','','15000.00','15000.00','Paid','2023-03-07 19:16:26','2023-03-08 13:29:11');
INSERT INTO invoices VALUES('1010','1','17','1','7','1','2023-03-05','2023-03-09 07:04:58','','MAR/23','','15000.00','15000.00','Paid','2023-03-07 19:16:26','2023-03-09 07:04:58');
INSERT INTO invoices VALUES('1011','1','18','1','7','1','2023-03-05','2023-03-08 13:27:48','','MAR/23','','15000.00','15000.00','Paid','2023-03-07 19:16:26','2023-03-08 13:27:48');
INSERT INTO invoices VALUES('1012','1','21','1','8','1','2023-03-05','2023-03-08 13:11:50','','MAR/23','','19500.00','19500.00','Paid','2023-03-07 19:16:26','2023-03-08 13:11:50');
INSERT INTO invoices VALUES('1013','1','35','1','7','1','2023-03-05','2023-03-08 13:49:43','','MAR/23','','15000.00','15000.00','Paid','2023-03-07 19:16:26','2023-03-08 13:49:43');
INSERT INTO invoices VALUES('1014','1','40','1','4','1','2023-03-05','2023-03-09 07:10:55','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:26','2023-03-09 07:10:55');
INSERT INTO invoices VALUES('1015','1','42','2','15','1','2023-03-05','2023-03-08 13:17:39','','MAR/23','','21000.00','21000.00','Paid','2023-03-07 19:16:26','2023-03-08 13:17:39');
INSERT INTO invoices VALUES('1016','1','43','1','4','1','2023-03-05','2023-03-09 07:17:26','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:27','2023-03-09 07:17:26');
INSERT INTO invoices VALUES('1017','1','44','1','11','1','2023-03-05','2023-03-09 07:33:10','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:27','2023-03-09 07:33:10');
INSERT INTO invoices VALUES('1018','1','46','2','15','1','2023-03-05','2023-04-02 07:18:57','','MAR/23','','21000.00','21000.00','Paid','2023-03-07 19:16:27','2023-04-02 07:18:57');
INSERT INTO invoices VALUES('1019','1','50','1','8','1','2023-03-05','2023-03-12 08:18:56','','MAR/23','','19500.00','19500.00','Paid','2023-03-07 19:16:27','2023-03-12 08:18:56');
INSERT INTO invoices VALUES('1020','1','51','1','8','1','2023-03-05','2023-04-07 12:30:10','','MAR/23','','19500.00','19500.00','Paid','2023-03-07 19:16:27','2023-04-07 12:30:10');
INSERT INTO invoices VALUES('1021','1','58','1','4','1','2023-03-05','2023-03-08 13:06:21','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:27','2023-03-08 13:06:21');
INSERT INTO invoices VALUES('1022','1','63','1','8','1','2023-03-05','2023-03-08 13:34:25','','MAR/23','','19500.00','19500.00','Paid','2023-03-07 19:16:27','2023-03-08 13:34:25');
INSERT INTO invoices VALUES('1023','1','65','1','1','1','2023-03-05','2023-03-08 13:36:41','','MAR/23','','20000.00','20000.00','Paid','2023-03-07 19:16:28','2023-03-08 13:36:41');
INSERT INTO invoices VALUES('1024','1','66','1','1','1','2023-03-05','2023-04-02 07:20:53','','MAR/23','','20000.00','20000.00','Paid','2023-03-07 19:16:28','2023-04-02 07:20:53');
INSERT INTO invoices VALUES('1025','1','72','1','18','1','2023-03-05','2023-03-09 10:01:46','','MAR/23','','26000.00','26000.00','Paid','2023-03-07 19:16:28','2023-03-09 10:01:46');
INSERT INTO invoices VALUES('1026','1','73','1','6','1','2023-03-05','2023-04-02 07:22:53','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:28','2023-04-02 07:22:53');
INSERT INTO invoices VALUES('1027','1','74','1','6','1','2023-03-05','2023-03-09 07:04:05','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:28','2023-03-09 07:04:05');
INSERT INTO invoices VALUES('1028','1','75','1','6','1','2023-03-05','2023-04-07 11:22:13','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:28','2023-04-07 11:22:13');
INSERT INTO invoices VALUES('1029','1','77','1','6','1','2023-03-05','2023-04-02 07:22:04','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:29','2023-04-02 07:22:04');
INSERT INTO invoices VALUES('1030','1','81','1','9','1','2023-03-05','2023-03-14 12:25:43','','MAR/23','','18500.00','18500.00','Paid','2023-03-07 19:16:29','2023-03-14 12:25:43');
INSERT INTO invoices VALUES('1032','1','86','1','4','1','2023-03-05','2023-03-08 13:05:34','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:29','2023-03-08 13:05:34');
INSERT INTO invoices VALUES('1033','1','87','1','7','1','2023-03-05','2023-03-08 13:53:36','','MAR/23','','15000.00','15000.00','Paid','2023-03-07 19:16:29','2023-03-08 13:53:36');
INSERT INTO invoices VALUES('1034','1','91','3','13','1','2023-03-05','2023-03-09 07:05:42','','MAR/23','','21500.00','21500.00','Paid','2023-03-07 19:16:29','2023-03-09 07:05:42');
INSERT INTO invoices VALUES('1035','1','92','1','16','1','2023-03-05','2023-03-09 07:06:24','','MAR/23','','21500.00','21500.00','Paid','2023-03-07 19:16:30','2023-03-09 07:06:24');
INSERT INTO invoices VALUES('1036','1','94','1','10','1','2023-03-05','2023-03-09 07:34:52','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:30','2023-03-09 07:34:52');
INSERT INTO invoices VALUES('1037','1','95','2','12','1','2023-03-05','2023-03-08 11:00:13','','MAR/23','','23000.00','22000.00','Unpaid','2023-03-07 19:16:30','2023-03-08 11:00:13');
INSERT INTO invoices VALUES('1038','1','96','2','12','1','2023-03-05','2023-07-30 12:59:01','','MAR/23','','23000.00','23000.00','Paid','2023-03-07 19:16:30','2023-07-30 12:59:01');
INSERT INTO invoices VALUES('1039','1','97','1','2','1','2023-03-05','2023-03-09 07:11:44','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:30','2023-03-09 07:11:44');
INSERT INTO invoices VALUES('1040','1','98','2','20','1','2023-03-05','2023-03-09 07:20:46','','MAR/23','','22000.00','22000.00','Paid','2023-03-07 19:16:31','2023-03-09 07:20:46');
INSERT INTO invoices VALUES('1041','1','99','3','17','1','2023-03-05','2023-03-09 07:19:35','','MAR/23','','21500.00','21500.00','Paid','2023-03-07 19:16:31','2023-03-09 07:19:35');
INSERT INTO invoices VALUES('1042','1','100','3','17','1','2023-03-05','2023-03-12 08:26:01','','MAR/23','','21500.00','21500.00','Paid','2023-03-07 19:16:31','2023-03-12 08:26:01');
INSERT INTO invoices VALUES('1043','1','101','1','9','1','2023-03-05','2023-03-09 10:09:51','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:31','2023-03-09 10:09:51');
INSERT INTO invoices VALUES('1044','1','102','1','11','1','2023-03-05','2023-03-09 09:57:19','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:31','2023-03-09 09:57:19');
INSERT INTO invoices VALUES('1045','1','103','1','2','1','2023-03-05','2023-03-09 07:12:38','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:31','2023-03-09 07:12:38');
INSERT INTO invoices VALUES('1046','1','104','1','9','1','2023-03-05','2023-03-09 07:07:19','','MAR/23','','18500.00','18500.00','Paid','2023-03-07 19:16:32','2023-03-09 07:07:19');
INSERT INTO invoices VALUES('1047','1','105','1','11','1','2023-03-05','2023-03-09 07:34:07','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:32','2023-03-09 07:34:07');
INSERT INTO invoices VALUES('1048','1','106','1','11','1','2023-03-05','2023-03-09 08:25:44','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:32','2023-03-09 08:25:44');
INSERT INTO invoices VALUES('1049','1','107','1','2','1','2023-03-05','2023-03-08 13:31:34','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:32','2023-03-08 13:31:34');
INSERT INTO invoices VALUES('1050','1','110','1','2','1','2023-03-05','2023-03-09 10:10:42','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:32','2023-03-09 10:10:42');
INSERT INTO invoices VALUES('1051','1','111','1','10','1','2023-03-05','2023-03-08 13:40:35','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:32','2023-03-08 13:40:35');
INSERT INTO invoices VALUES('1052','1','113','1','16','1','2023-03-05','2023-03-08 13:50:36','','MAR/23','','21500.00','21500.00','Paid','2023-03-07 19:16:33','2023-03-08 13:50:36');
INSERT INTO invoices VALUES('1053','1','114','1','3','1','2023-03-05','2023-04-04 17:54:10','','MAR/23','','20000.00','20000.00','Paid','2023-03-07 19:16:33','2023-04-04 17:54:10');
INSERT INTO invoices VALUES('1054','1','115','1','3','1','2023-03-05','2023-03-12 08:25:11','','MAR/23','','20000.00','20000.00','Paid','2023-03-07 19:16:33','2023-03-12 08:25:11');
INSERT INTO invoices VALUES('1055','1','116','2','21','1','2023-03-05','2023-04-02 08:29:21','','MAR/23','','15000.00','15000.00','Paid','2023-03-07 19:16:33','2023-04-02 08:29:21');
INSERT INTO invoices VALUES('1056','1','117','2','21','1','2023-03-05','2023-03-08 13:23:24','','MAR/23','','12000.00','12000.00','Paid','2023-03-07 19:16:33','2023-03-08 13:23:24');
INSERT INTO invoices VALUES('1057','1','118','2','21','1','2023-03-05','2023-04-02 08:16:01','','MAR/23','','15000.00','15000.00','Paid','2023-03-07 19:16:33','2023-04-02 08:16:01');
INSERT INTO invoices VALUES('1058','1','119','1','10','1','2023-03-05','2023-03-09 10:06:22','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:33','2023-03-09 10:06:22');
INSERT INTO invoices VALUES('1059','1','120','1','5','1','2023-03-05','2023-04-02 07:27:54','','MAR/23','','21500.00','21500.00','Paid','2023-03-07 19:16:33','2023-04-02 07:27:54');
INSERT INTO invoices VALUES('1060','1','121','1','7','1','2023-03-05','2023-03-09 07:18:14','','MAR/23','','15000.00','15000.00','Paid','2023-03-07 19:16:34','2023-03-09 07:18:14');
INSERT INTO invoices VALUES('1061','1','122','1','5','1','2023-03-05','2023-03-09 09:59:52','','MAR/23','','21500.00','21500.00','Paid','2023-03-07 19:16:34','2023-03-09 09:59:52');
INSERT INTO invoices VALUES('1062','1','123','1','1','1','2023-03-05','2023-03-08 13:55:27','','MAR/23','','20000.00','20000.00','Paid','2023-03-07 19:16:34','2023-03-08 13:55:27');
INSERT INTO invoices VALUES('1063','1','124','2','22','1','2023-03-05','2023-03-09 07:28:12','','MAR/23','','18000.00','18000.00','Paid','2023-03-07 19:16:34','2023-03-09 07:28:12');
INSERT INTO invoices VALUES('1064','1','125','2','22','1','2023-03-05','2023-03-09 08:27:58','','MAR/23','','18000.00','18000.00','Paid','2023-03-07 19:16:34','2023-03-09 08:27:58');
INSERT INTO invoices VALUES('1065','1','126','3','13','1','2023-03-05','2023-03-09 07:35:28','','MAR/23','','21500.00','21500.00','Paid','2023-03-07 19:16:34','2023-03-09 07:35:28');
INSERT INTO invoices VALUES('1066','1','127','1','10','1','2023-03-05','2023-03-08 13:22:15','','MAR/23','','19000.00','19000.00','Paid','2023-03-07 19:16:34','2023-03-08 13:22:15');
INSERT INTO invoices VALUES('1067','1','128','2','22','1','2023-03-05','2023-03-09 07:29:32','','MAR/23','','18000.00','18000.00','Paid','2023-03-07 19:16:34','2023-03-09 07:29:32');
INSERT INTO invoices VALUES('1068','1','129','1','23','1','2023-03-05','2023-03-08 13:25:58','','MAR/23','','21500.00','21500.00','Paid','2023-03-07 19:16:35','2023-03-08 13:25:58');
INSERT INTO invoices VALUES('1409','1','146','2','20','1','2023-08-03','2023-08-05 11:26:01','','AUG/23','','30000.00','30000.00','Paid','2023-08-05 11:23:59','2023-08-05 11:26:01');
INSERT INTO invoices VALUES('1071','1','7','1','3','1','2023-04-05','2023-04-02 14:50:50','','APR/23','','20000.00','20000.00','Paid','2023-04-01 12:19:12','2023-04-02 14:50:50');
INSERT INTO invoices VALUES('1072','1','15','1','7','1','2023-04-05','2023-04-08 07:43:50','','APR/23','','15000.00','15000.00','Paid','2023-04-01 12:19:12','2023-04-08 07:43:50');
INSERT INTO invoices VALUES('1073','1','17','1','7','1','2023-04-05','2023-04-08 07:44:49','','APR/23','','15000.00','15000.00','Paid','2023-04-01 12:19:12','2023-04-08 07:44:49');
INSERT INTO invoices VALUES('1074','1','18','1','7','1','2023-04-05','2023-04-08 07:45:20','','APR/23','','15000.00','15000.00','Paid','2023-04-01 12:19:12','2023-04-08 07:45:20');
INSERT INTO invoices VALUES('1075','1','21','1','8','1','2023-04-05','2023-04-02 15:11:06','','APR/23','','19500.00','19500.00','Paid','2023-04-01 12:19:12','2023-04-02 15:11:06');
INSERT INTO invoices VALUES('1076','1','35','1','7','1','2023-04-05','2023-04-04 17:32:50','','APR/23','','15000.00','15000.00','Paid','2023-04-01 12:19:13','2023-04-04 17:32:50');
INSERT INTO invoices VALUES('1077','1','40','1','4','1','2023-04-05','2023-04-05 14:08:46','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:13','2023-04-05 14:08:46');
INSERT INTO invoices VALUES('1078','1','42','2','15','1','2023-04-05','2023-04-04 11:14:06','','APR/23','','21000.00','21000.00','Paid','2023-04-01 12:19:13','2023-04-04 11:14:06');
INSERT INTO invoices VALUES('1079','1','43','1','4','1','2023-04-05','2023-04-04 17:01:52','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:13','2023-04-04 17:01:52');
INSERT INTO invoices VALUES('1080','1','44','1','11','1','2023-04-05','2023-04-05 14:09:20','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:13','2023-04-05 14:09:20');
INSERT INTO invoices VALUES('1081','1','46','2','15','1','2023-04-05','2023-04-05 14:08:00','','APR/23','','21000.00','21000.00','Paid','2023-04-01 12:19:13','2023-04-05 14:08:00');
INSERT INTO invoices VALUES('1082','1','50','1','8','1','2023-04-05','2023-04-12 18:16:49','','APR/23','','19500.00','19500.00','Paid','2023-04-01 12:19:13','2023-04-12 18:16:49');
INSERT INTO invoices VALUES('1083','1','51','1','8','1','2023-04-05','2023-04-12 18:17:52','','APR/23','','19500.00','19500.00','Paid','2023-04-01 12:19:13','2023-04-12 18:17:52');
INSERT INTO invoices VALUES('1084','1','58','1','4','1','2023-04-05','2023-04-03 16:05:39','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:13','2023-04-03 16:05:39');
INSERT INTO invoices VALUES('1085','1','63','1','8','1','2023-04-05','2023-05-31 17:46:45','','APR/23','','19500.00','19500.00','Paid','2023-04-01 12:19:13','2023-05-31 17:46:45');
INSERT INTO invoices VALUES('1086','1','65','1','1','1','2023-04-05','2023-04-28 05:54:22','','APR/23','','20000.00','20000.00','Paid','2023-04-01 12:19:13','2023-04-28 05:54:22');
INSERT INTO invoices VALUES('1087','1','66','1','1','1','2023-04-05','2023-04-28 05:55:46','','APR/23','','20000.00','20000.00','Paid','2023-04-01 12:19:13','2023-04-28 05:55:46');
INSERT INTO invoices VALUES('1088','1','72','1','18','1','2023-04-05','2023-04-04 17:34:56','','APR/23','','26000.00','26000.00','Paid','2023-04-01 12:19:14','2023-04-04 17:34:56');
INSERT INTO invoices VALUES('1089','1','73','1','6','1','2023-04-05','2023-04-28 06:01:09','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:14','2023-04-28 06:01:09');
INSERT INTO invoices VALUES('1090','1','74','1','6','1','2023-04-05','2023-04-04 17:51:57','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:14','2023-04-04 17:51:57');
INSERT INTO invoices VALUES('1091','1','75','1','6','1','2023-04-05','2023-04-05 14:07:35','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:14','2023-04-05 14:07:35');
INSERT INTO invoices VALUES('1092','1','77','1','6','1','2023-04-05','2023-04-03 16:08:41','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:14','2023-04-03 16:08:41');
INSERT INTO invoices VALUES('1093','1','81','1','9','1','2023-04-05','2023-04-11 15:29:53','','APR/23','','18500.00','18500.00','Paid','2023-04-01 12:19:14','2023-04-11 15:29:53');
INSERT INTO invoices VALUES('1133','1','85','1','9','1','2023-03-05','2023-04-02 08:10:29','','MAR/23','ONLY FIFTEEN DAYS RENT','9350.00','9350.00','Paid','2023-04-02 08:08:49','2023-04-02 08:10:29');
INSERT INTO invoices VALUES('1095','1','86','1','4','1','2023-04-05','2023-04-10 15:42:08','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:14','2023-04-10 15:42:08');
INSERT INTO invoices VALUES('1096','1','87','1','7','1','2023-04-05','2023-04-07 10:25:59','','APR/23','','15000.00','15000.00','Paid','2023-04-01 12:19:14','2023-04-07 10:25:59');
INSERT INTO invoices VALUES('1097','1','91','3','13','1','2023-04-05','2023-04-04 08:43:55','','APR/23','','21500.00','21500.00','Paid','2023-04-01 12:19:14','2023-04-04 08:43:55');
INSERT INTO invoices VALUES('1098','1','92','1','9','1','2023-04-05','2023-04-14 09:20:39','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:14','2023-04-14 09:20:39');
INSERT INTO invoices VALUES('1099','1','94','1','10','1','2023-04-05','2023-04-07 14:45:01','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:14','2023-04-07 14:45:01');
INSERT INTO invoices VALUES('1100','1','95','2','12','1','2023-04-05','2023-04-07 12:18:41','','APR/23','','23000.00','22000.00','Unpaid','2023-04-01 12:19:14','2023-04-07 12:18:41');
INSERT INTO invoices VALUES('1101','1','96','2','12','1','2023-04-05','2023-07-30 11:50:36','','APR/23','','23000.00','23000.00','Paid','2023-04-01 12:19:14','2023-07-30 11:50:36');
INSERT INTO invoices VALUES('1102','1','97','1','2','1','2023-04-05','2023-04-05 14:07:09','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:14','2023-04-05 14:07:09');
INSERT INTO invoices VALUES('1103','1','98','2','20','1','2023-04-05','2023-05-31 17:45:45','','APR/23','','22000.00','22000.00','Paid','2023-04-01 12:19:15','2023-05-31 17:45:45');
INSERT INTO invoices VALUES('1104','1','99','3','17','1','2023-04-05','2023-04-16 14:47:08','','APR/23','','21500.00','21500.00','Paid','2023-04-01 12:19:15','2023-04-16 14:47:08');
INSERT INTO invoices VALUES('1105','1','100','3','17','1','2023-04-05','2023-04-11 00:07:51','','APR/23','','21500.00','21500.00','Paid','2023-04-01 12:19:15','2023-04-11 00:07:51');
INSERT INTO invoices VALUES('1106','1','101','1','9','1','2023-04-05','2023-04-06 07:21:18','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:15','2023-04-06 07:21:18');
INSERT INTO invoices VALUES('1107','1','102','1','11','1','2023-04-05','2023-04-06 07:22:29','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:15','2023-04-06 07:22:29');
INSERT INTO invoices VALUES('1108','1','103','1','2','1','2023-04-05','2023-04-12 18:30:00','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:15','2023-04-12 18:30:00');
INSERT INTO invoices VALUES('1109','1','104','1','9','1','2023-04-05','2023-04-08 07:41:19','','APR/23','','18500.00','18500.00','Paid','2023-04-01 12:19:15','2023-04-08 07:41:19');
INSERT INTO invoices VALUES('1110','1','105','1','11','1','2023-04-05','2023-04-07 10:26:31','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:15','2023-04-07 10:26:31');
INSERT INTO invoices VALUES('1111','1','106','1','11','1','2023-04-05','2023-04-12 18:28:13','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:15','2023-04-12 18:28:13');
INSERT INTO invoices VALUES('1112','1','107','1','2','1','2023-04-05','2023-04-03 16:10:46','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:15','2023-04-03 16:10:46');
INSERT INTO invoices VALUES('1113','1','110','1','2','1','2023-04-05','2023-04-06 12:07:27','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:15','2023-04-06 12:07:27');
INSERT INTO invoices VALUES('1114','1','111','1','10','1','2023-04-05','2023-04-07 11:57:42','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:15','2023-04-07 11:57:42');
INSERT INTO invoices VALUES('1115','1','113','1','16','1','2023-04-05','2023-04-08 07:42:25','','APR/23','','21500.00','21500.00','Paid','2023-04-01 12:19:15','2023-04-08 07:42:25');
INSERT INTO invoices VALUES('1116','1','114','1','3','1','2023-04-05','2023-04-04 17:54:46','','APR/23','','20000.00','20000.00','Paid','2023-04-01 12:19:15','2023-04-04 17:54:46');
INSERT INTO invoices VALUES('1117','1','115','1','3','1','2023-04-05','2023-04-05 14:06:07','','APR/23','','20000.00','20000.00','Paid','2023-04-01 12:19:16','2023-04-05 14:06:07');
INSERT INTO invoices VALUES('1118','1','116','2','21','1','2023-04-05','2023-04-27 08:19:13','','APR/23','','15000.00','15000.00','Paid','2023-04-01 12:19:16','2023-04-27 08:19:13');
INSERT INTO invoices VALUES('1119','1','117','2','21','1','2023-04-05','2023-04-04 17:44:08','','APR/23','','12000.00','12000.00','Paid','2023-04-01 12:19:16','2023-04-04 17:44:08');
INSERT INTO invoices VALUES('1120','1','118','2','21','1','2023-04-05','2023-04-27 08:18:10','','APR/23','','15000.00','15000.00','Paid','2023-04-01 12:19:16','2023-04-27 08:18:10');
INSERT INTO invoices VALUES('1121','1','119','1','10','1','2023-04-05','2023-04-07 14:44:37','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:16','2023-04-07 14:44:37');
INSERT INTO invoices VALUES('1122','1','120','1','5','1','2023-04-05','2023-04-06 07:21:48','','APR/23','','21500.00','21500.00','Paid','2023-04-01 12:19:16','2023-04-06 07:21:48');
INSERT INTO invoices VALUES('1123','1','121','1','7','1','2023-04-05','2023-04-07 10:31:30','','APR/23','','15000.00','15000.00','Paid','2023-04-01 12:19:16','2023-04-07 10:31:30');
INSERT INTO invoices VALUES('1124','1','122','1','5','1','2023-04-05','2023-04-07 10:30:52','','APR/23','','21500.00','21500.00','Paid','2023-04-01 12:19:16','2023-04-07 10:30:52');
INSERT INTO invoices VALUES('1143','1','7','1','1','1','2023-05-05','2023-05-07 17:28:03','','May/23','','21000.00','21000.00','Paid','2023-05-07 12:12:30','2023-05-07 17:28:03');
INSERT INTO invoices VALUES('1139','1','124','2','22','1','2023-04-05','2023-04-28 06:02:41','','APR/23','','20000.00','20000.00','Paid','2023-04-12 18:22:34','2023-04-28 06:02:41');
INSERT INTO invoices VALUES('1140','1','128','2','22','1','2023-04-05','2023-04-12 18:23:16','','APR/23','','20000.00','20000.00','Paid','2023-04-12 18:22:34','2023-04-12 18:23:16');
INSERT INTO invoices VALUES('1128','1','126','3','13','1','2023-04-05','2023-04-07 14:46:24','','APR/23','','21500.00','21500.00','Paid','2023-04-01 12:19:16','2023-04-07 14:46:24');
INSERT INTO invoices VALUES('1129','1','127','1','10','1','2023-04-05','2023-04-12 18:30:41','','APR/23','','19000.00','19000.00','Paid','2023-04-01 12:19:16','2023-04-12 18:30:41');
INSERT INTO invoices VALUES('1144','1','15','1','7','1','2023-05-05','2023-05-11 09:48:30','','May/23','','15000.00','15000.00','Paid','2023-05-07 12:12:30','2023-05-11 09:48:30');
INSERT INTO invoices VALUES('1131','1','129','1','23','1','2023-04-05','2023-04-09 21:33:05','','APR/23','','21500.00','21500.00','Paid','2023-04-01 12:19:17','2023-04-09 21:33:05');
INSERT INTO invoices VALUES('1207','1','3','2','14','1','2023-05-05','2023-05-11 10:53:46','','May/23','','24500.00','24500.00','Paid','2023-05-11 10:53:06','2023-05-11 10:53:46');
INSERT INTO invoices VALUES('1135','1','131','1','16','1','2023-04-05','2023-04-07 15:22:27','','APR/23','','21500.00','21500.00','Paid','2023-04-07 15:20:29','2023-04-07 15:22:27');
INSERT INTO invoices VALUES('1137','1','132','1','3','1','2023-04-05','2023-04-09 11:20:42','','APR/23','Only 21 days rent','35700.00','35700.00','Paid','2023-04-09 11:19:34','2023-04-09 11:20:42');
INSERT INTO invoices VALUES('1138','1','133','1','23','1','2023-04-05','2023-04-09 21:32:34','','APR/23','ONLY 21 DAYS RENT.','39000.00','39000.00','Paid','2023-04-09 21:31:30','2023-04-09 21:32:34');
INSERT INTO invoices VALUES('1145','1','17','1','7','1','2023-05-05','2023-05-11 09:52:42','','May/23','','15000.00','15000.00','Paid','2023-05-07 12:12:30','2023-05-11 09:52:42');
INSERT INTO invoices VALUES('1146','1','18','1','7','1','2023-05-05','2023-05-11 09:49:03','','May/23','','15000.00','15000.00','Paid','2023-05-07 12:12:30','2023-05-11 09:49:03');
INSERT INTO invoices VALUES('1147','1','21','1','8','1','2023-05-05','2023-05-07 12:14:28','','May/23','','19500.00','19500.00','Paid','2023-05-07 12:12:30','2023-05-07 12:14:28');
INSERT INTO invoices VALUES('1148','1','35','1','7','1','2023-05-05','2023-05-11 10:00:48','','May/23','','15000.00','15000.00','Paid','2023-05-07 12:12:30','2023-05-11 10:00:48');
INSERT INTO invoices VALUES('1149','1','40','1','4','1','2023-05-05','2023-05-11 09:45:22','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:30','2023-05-11 09:45:22');
INSERT INTO invoices VALUES('1150','1','42','2','15','1','2023-05-05','2023-05-24 12:31:15','','May/23','','21000.00','21000.00','Paid','2023-05-07 12:12:30','2023-05-24 12:31:15');
INSERT INTO invoices VALUES('1151','1','43','1','4','1','2023-05-05','2023-05-31 17:24:14','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:30','2023-05-31 17:24:14');
INSERT INTO invoices VALUES('1152','1','44','1','11','1','2023-05-05','2023-05-08 17:45:43','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:30','2023-05-08 17:45:43');
INSERT INTO invoices VALUES('1153','1','46','2','15','1','2023-05-05','2023-05-24 12:30:10','','May/23','','21000.00','21000.00','Paid','2023-05-07 12:12:30','2023-05-24 12:30:10');
INSERT INTO invoices VALUES('1154','1','50','1','8','1','2023-05-05','2023-05-11 10:57:25','','May/23','','19500.00','19500.00','Paid','2023-05-07 12:12:30','2023-05-11 10:57:25');
INSERT INTO invoices VALUES('1155','1','51','1','8','1','2023-05-05','2023-05-13 15:21:44','','May/23','','19500.00','19500.00','Paid','2023-05-07 12:12:30','2023-05-13 15:21:44');
INSERT INTO invoices VALUES('1156','1','58','1','4','1','2023-05-05','2023-05-11 09:54:37','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:30','2023-05-11 09:54:37');
INSERT INTO invoices VALUES('1157','1','63','1','8','1','2023-05-05','2023-05-13 15:20:05','','May/23','','19500.00','19500.00','Paid','2023-05-07 12:12:30','2023-05-13 15:20:05');
INSERT INTO invoices VALUES('1158','1','65','1','1','1','2023-05-05','2023-05-29 14:31:44','','May/23','','20000.00','20000.00','Paid','2023-05-07 12:12:30','2023-05-29 14:31:44');
INSERT INTO invoices VALUES('1159','1','66','1','1','1','2023-05-05','2023-05-11 10:19:17','','May/23','','20000.00','20000.00','Paid','2023-05-07 12:12:30','2023-05-11 10:19:17');
INSERT INTO invoices VALUES('1160','1','72','1','18','1','2023-05-05','2023-05-11 09:45:57','','May/23','','26000.00','26000.00','Paid','2023-05-07 12:12:30','2023-05-11 09:45:57');
INSERT INTO invoices VALUES('1161','1','73','1','6','1','2023-05-05','2023-05-31 17:24:38','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:31','2023-05-31 17:24:38');
INSERT INTO invoices VALUES('1162','1','74','1','6','1','2023-05-05','2023-05-11 09:56:06','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:31','2023-05-11 09:56:06');
INSERT INTO invoices VALUES('1163','1','75','1','6','1','2023-05-05','2023-05-31 17:31:01','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:31','2023-05-31 17:31:01');
INSERT INTO invoices VALUES('1164','1','77','1','6','1','2023-05-05','2023-05-31 17:25:08','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:31','2023-05-31 17:25:08');
INSERT INTO invoices VALUES('1165','1','81','1','9','1','2023-05-05','2023-05-22 15:44:18','','May/23','','18500.00','18500.00','Paid','2023-05-07 12:12:31','2023-05-22 15:44:18');
INSERT INTO invoices VALUES('1166','1','86','1','4','1','2023-05-05','2023-05-11 09:44:55','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:31','2023-05-11 09:44:55');
INSERT INTO invoices VALUES('1167','1','87','1','7','1','2023-05-05','2023-05-11 10:01:17','','May/23','','15000.00','15000.00','Paid','2023-05-07 12:12:31','2023-05-11 10:01:17');
INSERT INTO invoices VALUES('1168','1','91','3','13','1','2023-05-05','2023-05-11 10:03:11','','May/23','','21500.00','21500.00','Paid','2023-05-07 12:12:31','2023-05-11 10:03:11');
INSERT INTO invoices VALUES('1169','1','92','1','9','1','2023-05-05','2023-05-11 09:59:20','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:31','2023-05-11 09:59:20');
INSERT INTO invoices VALUES('1170','1','94','1','10','1','2023-05-05','2023-05-11 10:13:23','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:31','2023-05-11 10:13:23');
INSERT INTO invoices VALUES('1171','1','95','2','12','1','2023-05-05','2023-07-30 11:51:32','','May/23','','23000.00','22000.00','Unpaid','2023-05-07 12:12:31','2023-07-30 11:51:32');
INSERT INTO invoices VALUES('1172','1','96','2','12','1','2023-05-05','2023-07-30 11:49:42','','May/23','','23000.00','23000.00','Paid','2023-05-07 12:12:31','2023-07-30 11:49:42');
INSERT INTO invoices VALUES('1173','1','97','1','2','1','2023-05-05','2023-05-11 09:58:46','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:31','2023-05-11 09:58:46');
INSERT INTO invoices VALUES('1174','1','98','2','20','1','2023-05-05','2023-05-11 09:57:41','','May/23','','22000.00','22000.00','Paid','2023-05-07 12:12:31','2023-05-11 09:57:41');
INSERT INTO invoices VALUES('1175','1','99','3','17','1','2023-05-05','2023-05-11 10:18:28','','May/23','','21500.00','21500.00','Paid','2023-05-07 12:12:31','2023-05-11 10:18:28');
INSERT INTO invoices VALUES('1176','1','100','3','17','1','2023-05-05','2023-05-09 13:26:59','','May/23','','21500.00','21500.00','Paid','2023-05-07 12:12:31','2023-05-09 13:26:59');
INSERT INTO invoices VALUES('1177','1','101','1','9','1','2023-05-05','2023-05-11 10:17:53','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:31','2023-05-11 10:17:53');
INSERT INTO invoices VALUES('1178','1','102','1','11','1','2023-05-05','2023-05-08 17:44:23','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:32','2023-05-08 17:44:23');
INSERT INTO invoices VALUES('1209','1','3','2','14','1','2023-06-05','2023-06-13 17:41:05','','JUN/23','','24500.00','24500.00','Paid','2023-06-01 10:05:07','2023-06-13 17:41:05');
INSERT INTO invoices VALUES('1180','1','104','1','9','1','2023-05-05','2023-05-23 16:25:07','','May/23','','18500.00','18500.00','Paid','2023-05-07 12:12:32','2023-05-23 16:25:07');
INSERT INTO invoices VALUES('1181','1','105','1','11','1','2023-05-05','2023-05-08 17:46:04','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:32','2023-05-08 17:46:04');
INSERT INTO invoices VALUES('1182','1','106','1','11','1','2023-05-05','2023-05-08 17:41:59','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:32','2023-05-08 17:41:59');
INSERT INTO invoices VALUES('1183','1','107','1','2','1','2023-05-05','2023-05-11 09:59:46','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:32','2023-05-11 09:59:46');
INSERT INTO invoices VALUES('1184','1','110','1','2','1','2023-05-05','2023-05-11 10:00:17','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:32','2023-05-11 10:00:17');
INSERT INTO invoices VALUES('1185','1','111','1','10','1','2023-05-05','2023-05-11 10:01:48','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:32','2023-05-11 10:01:48');
INSERT INTO invoices VALUES('1186','1','113','1','16','1','2023-05-05','2023-05-11 10:09:44','','May/23','','21500.00','21500.00','Paid','2023-05-07 12:12:32','2023-05-11 10:09:44');
INSERT INTO invoices VALUES('1210','1','15','1','7','1','2023-06-05','2023-06-13 15:24:37','','JUN/23','','15000.00','15000.00','Paid','2023-06-01 15:25:22','2023-06-13 15:24:37');
INSERT INTO invoices VALUES('1188','1','115','1','3','1','2023-05-05','2023-05-31 17:27:39','','May/23','','20000.00','20000.00','Paid','2023-05-07 12:12:32','2023-05-31 17:27:39');
INSERT INTO invoices VALUES('1189','1','116','2','21','1','2023-05-05','2023-05-11 10:14:36','','May/23','','15000.00','15000.00','Paid','2023-05-07 12:12:32','2023-05-11 10:14:36');
INSERT INTO invoices VALUES('1190','1','117','2','21','1','2023-05-05','2023-05-31 17:28:53','','May/23','','12000.00','12000.00','Paid','2023-05-07 12:12:32','2023-05-31 17:28:53');
INSERT INTO invoices VALUES('1191','1','118','2','21','1','2023-05-05','2023-05-31 17:31:40','','May/23','','15000.00','15000.00','Paid','2023-05-07 12:12:32','2023-05-31 17:31:40');
INSERT INTO invoices VALUES('1192','1','119','1','10','1','2023-05-05','2023-05-11 10:13:47','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:32','2023-05-11 10:13:47');
INSERT INTO invoices VALUES('1193','1','120','1','5','1','2023-05-05','2023-05-11 10:54:42','','May/23','','21500.00','21500.00','Paid','2023-05-07 12:12:32','2023-05-11 10:54:42');
INSERT INTO invoices VALUES('1194','1','121','1','7','1','2023-05-05','2023-05-11 09:55:04','','May/23','','15000.00','15000.00','Paid','2023-05-07 12:12:32','2023-05-11 09:55:04');
INSERT INTO invoices VALUES('1195','1','122','1','5','1','2023-05-05','2023-05-31 17:32:12','','May/23','','21500.00','21500.00','Paid','2023-05-07 12:12:32','2023-05-31 17:32:12');
INSERT INTO invoices VALUES('1205','1','124','2','22','1','2023-05-05','2023-05-31 17:29:59','','May/23','','20000.00','20000.00','Paid','2023-05-11 10:08:13','2023-05-31 17:29:59');
INSERT INTO invoices VALUES('1197','1','126','3','13','1','2023-05-05','2023-05-11 10:12:43','','May/23','','21500.00','21500.00','Paid','2023-05-07 12:12:32','2023-05-11 10:12:43');
INSERT INTO invoices VALUES('1198','1','127','1','10','1','2023-05-05','2023-05-11 10:18:50','','May/23','','19000.00','19000.00','Paid','2023-05-07 12:12:32','2023-05-11 10:18:50');
INSERT INTO invoices VALUES('1206','1','128','2','22','1','2023-05-05','2023-05-11 10:08:42','','May/23','','20000.00','20000.00','Paid','2023-05-11 10:08:13','2023-05-11 10:08:42');
INSERT INTO invoices VALUES('1200','1','129','1','23','1','2023-05-05','2023-05-11 10:55:16','','May/23','','21500.00','21500.00','Paid','2023-05-07 12:12:33','2023-05-11 10:55:16');
INSERT INTO invoices VALUES('1201','1','131','1','16','1','2023-05-05','2023-05-11 09:56:46','','May/23','','21500.00','21500.00','Paid','2023-05-07 12:12:33','2023-05-11 09:56:46');
INSERT INTO invoices VALUES('1202','1','132','1','3','1','2023-05-05','2023-05-31 17:20:49','','May/23','','21000.00','21000.00','Paid','2023-05-07 12:12:33','2023-05-31 17:20:49');
INSERT INTO invoices VALUES('1203','1','133','1','23','1','2023-05-05','2023-05-11 10:31:33','','May/23','','23000.00','23000.00','Paid','2023-05-07 12:12:33','2023-05-11 10:31:33');
INSERT INTO invoices VALUES('1204','1','134','1','3','1','2023-05-05','2023-05-31 17:29:25','','May/23','','40000.00','40000.00','Paid','2023-05-11 09:08:20','2023-05-31 17:29:25');
INSERT INTO invoices VALUES('1208','1','135','1','2','1','2023-05-05','2023-05-23 10:55:47','','MAY/23','','34000.00','34000.00','Paid','2023-05-23 10:55:06','2023-05-23 10:55:47');
INSERT INTO invoices VALUES('1211','1','17','1','7','1','2023-06-05','2023-06-13 15:25:13','','JUN/23','','15000.00','15000.00','Paid','2023-06-01 15:25:22','2023-06-13 15:25:13');
INSERT INTO invoices VALUES('1212','1','18','1','7','1','2023-06-05','2023-06-13 15:26:14','','JUN/23','','15000.00','15000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:26:14');
INSERT INTO invoices VALUES('1213','1','21','1','8','1','2023-06-05','2023-06-03 07:03:28','','JUN/23','','19500.00','19500.00','Paid','2023-06-01 15:25:23','2023-06-03 07:03:28');
INSERT INTO invoices VALUES('1214','1','35','1','7','1','2023-06-05','2023-06-13 15:27:28','','JUN/23','','15000.00','15000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:27:28');
INSERT INTO invoices VALUES('1215','1','40','1','4','1','2023-06-05','2023-06-01 15:27:32','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-01 15:27:32');
INSERT INTO invoices VALUES('1216','1','42','2','15','1','2023-06-05','2023-06-01 15:28:36','','JUN/23','','21000.00','21000.00','Paid','2023-06-01 15:25:23','2023-06-01 15:28:36');
INSERT INTO invoices VALUES('1217','1','43','1','4','1','2023-06-05','2023-06-07 16:42:04','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-07 16:42:04');
INSERT INTO invoices VALUES('1218','1','44','1','11','1','2023-06-05','2023-06-13 17:42:20','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-13 17:42:20');
INSERT INTO invoices VALUES('1219','1','46','2','15','1','2023-06-05','2023-06-01 15:28:59','','JUN/23','','21000.00','21000.00','Paid','2023-06-01 15:25:23','2023-06-01 15:28:59');
INSERT INTO invoices VALUES('1220','1','50','1','8','1','2023-06-05','2023-06-13 15:34:15','','JUN/23','','19500.00','19500.00','Paid','2023-06-01 15:25:23','2023-06-13 15:34:15');
INSERT INTO invoices VALUES('1221','1','51','1','8','1','2023-06-05','2023-06-13 15:35:54','','JUN/23','','19500.00','19500.00','Paid','2023-06-01 15:25:23','2023-06-13 15:35:54');
INSERT INTO invoices VALUES('1222','1','58','1','4','1','2023-06-05','2023-06-01 15:26:45','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-01 15:26:45');
INSERT INTO invoices VALUES('1223','1','63','1','8','1','2023-06-05','2023-06-13 18:07:51','','JUN/23','','19500.00','19500.00','Paid','2023-06-01 15:25:23','2023-06-13 18:07:51');
INSERT INTO invoices VALUES('1224','1','65','1','1','1','2023-06-05','2023-07-22 07:25:41','','JUN/23','','20000.00','20000.00','Paid','2023-06-01 15:25:23','2023-07-22 07:25:41');
INSERT INTO invoices VALUES('1225','1','66','1','1','1','2023-06-05','2023-06-13 15:09:49','','JUN/23','','20000.00','20000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:09:49');
INSERT INTO invoices VALUES('1226','1','72','1','18','1','2023-06-05','2023-06-13 15:13:14','','JUN/23','','26000.00','26000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:13:14');
INSERT INTO invoices VALUES('1227','1','73','1','6','1','2023-06-05','2023-06-01 15:27:11','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-01 15:27:11');
INSERT INTO invoices VALUES('1228','1','74','1','6','1','2023-06-05','2023-06-12 12:20:05','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-12 12:20:05');
INSERT INTO invoices VALUES('1229','1','75','1','6','1','2023-06-05','2023-06-01 15:27:59','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-01 15:27:59');
INSERT INTO invoices VALUES('1230','1','77','1','6','1','2023-06-05','2023-06-13 15:23:06','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:23:06');
INSERT INTO invoices VALUES('1231','1','81','1','9','1','2023-06-05','2023-06-05 13:24:52','','JUN/23','','18500.00','18500.00','Paid','2023-06-01 15:25:23','2023-06-05 13:24:52');
INSERT INTO invoices VALUES('1232','1','86','1','4','1','2023-06-05','2023-06-01 15:26:22','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-01 15:26:22');
INSERT INTO invoices VALUES('1233','1','87','1','7','1','2023-06-05','2023-06-13 15:29:06','','JUN/23','','15000.00','15000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:29:06');
INSERT INTO invoices VALUES('1234','1','91','3','13','1','2023-06-05','2023-07-30 11:41:39','','JUN/23','','21500.00','21500.00','Paid','2023-06-01 15:25:23','2023-07-30 11:41:39');
INSERT INTO invoices VALUES('1235','1','92','1','9','1','2023-06-05','2023-07-09 08:45:12','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-07-09 08:45:12');
INSERT INTO invoices VALUES('1236','1','94','1','10','1','2023-06-05','2023-06-08 19:23:18','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-08 19:23:18');
INSERT INTO invoices VALUES('1237','1','95','2','12','1','2023-06-05','2023-07-30 11:46:37','','JUN/23','','23000.00','23000.00','Paid','2023-06-01 15:25:23','2023-07-30 11:46:37');
INSERT INTO invoices VALUES('1238','1','96','2','12','1','2023-06-05','2023-07-30 11:48:51','','JUN/23','','23000.00','23000.00','Paid','2023-06-01 15:25:23','2023-07-30 11:48:51');
INSERT INTO invoices VALUES('1239','1','97','1','2','1','2023-06-05','2023-06-13 15:14:21','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:14:21');
INSERT INTO invoices VALUES('1240','1','98','2','20','1','2023-06-05','2023-07-09 09:02:22','','JUN/23','','22000.00','22000.00','Paid','2023-06-01 15:25:23','2023-07-09 09:02:22');
INSERT INTO invoices VALUES('1241','1','99','3','17','1','2023-06-05','','','JUN/23','','21500.00','','Unpaid','2023-06-01 15:25:23','2023-06-01 15:25:23');
INSERT INTO invoices VALUES('1242','1','100','3','17','1','2023-06-05','2023-06-14 10:05:49','','JUN/23','','21500.00','21500.00','Paid','2023-06-01 15:25:23','2023-06-14 10:05:49');
INSERT INTO invoices VALUES('1243','1','101','1','9','1','2023-06-05','2023-07-30 12:23:26','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-07-30 12:23:26');
INSERT INTO invoices VALUES('1244','1','102','1','11','1','2023-06-05','2023-06-05 09:08:42','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-05 09:08:42');
INSERT INTO invoices VALUES('1245','1','104','1','9','1','2023-06-05','2023-07-30 12:21:30','','JUN/23','','18500.00','18500.00','Paid','2023-06-01 15:25:23','2023-07-30 12:21:30');
INSERT INTO invoices VALUES('1246','1','105','1','11','1','2023-06-05','2023-06-05 09:37:56','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-05 09:37:56');
INSERT INTO invoices VALUES('1247','1','106','1','11','1','2023-06-05','2023-06-01 15:30:12','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-01 15:30:12');
INSERT INTO invoices VALUES('1248','1','107','1','2','1','2023-06-05','2023-06-13 15:15:04','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:15:04');
INSERT INTO invoices VALUES('1249','1','110','1','2','1','2023-06-05','2023-06-13 15:15:54','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:15:54');
INSERT INTO invoices VALUES('1250','1','111','1','10','1','2023-06-05','2023-07-30 12:19:43','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-07-30 12:19:43');
INSERT INTO invoices VALUES('1251','1','113','1','16','1','2023-06-05','2023-06-14 06:38:46','','JUN/23','','21500.00','21500.00','Paid','2023-06-01 15:25:23','2023-06-14 06:38:46');
INSERT INTO invoices VALUES('1252','1','115','1','3','1','2023-06-05','2023-06-13 15:19:01','','JUN/23','','20000.00','20000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:19:01');
INSERT INTO invoices VALUES('1253','1','116','2','21','1','2023-06-05','2023-07-30 11:57:34','','JUN/23','','15000.00','15000.00','Paid','2023-06-01 15:25:23','2023-07-30 11:57:34');
INSERT INTO invoices VALUES('1254','1','117','2','21','1','2023-06-05','2023-06-01 15:29:45','','JUN/23','','12000.00','12000.00','Paid','2023-06-01 15:25:23','2023-06-01 15:29:45');
INSERT INTO invoices VALUES('1255','1','118','2','21','1','2023-06-05','2023-07-30 11:57:54','','JUN/23','','15000.00','15000.00','Paid','2023-06-01 15:25:23','2023-07-30 11:57:54');
INSERT INTO invoices VALUES('1256','1','119','1','10','1','2023-06-05','2023-06-13 15:31:21','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:23','2023-06-13 15:31:21');
INSERT INTO invoices VALUES('1257','1','120','1','5','1','2023-06-05','2023-06-07 10:00:08','','JUN/23','','21500.00','21500.00','Paid','2023-06-01 15:25:24','2023-06-07 10:00:08');
INSERT INTO invoices VALUES('1258','1','121','1','7','1','2023-06-05','2023-06-06 18:11:37','','JUN/23','','15000.00','15000.00','Paid','2023-06-01 15:25:24','2023-06-06 18:11:37');
INSERT INTO invoices VALUES('1259','1','122','1','5','1','2023-06-05','2023-06-09 09:27:49','','JUN/23','','21500.00','21500.00','Paid','2023-06-01 15:25:24','2023-06-09 09:27:49');
INSERT INTO invoices VALUES('1260','1','124','2','22','1','2023-06-05','2023-06-13 17:43:31','','JUN/23','','20000.00','20000.00','Paid','2023-06-01 15:25:24','2023-06-13 17:43:31');
INSERT INTO invoices VALUES('1261','1','126','3','13','1','2023-06-05','2023-06-07 16:40:50','','JUN/23','','21500.00','21500.00','Paid','2023-06-01 15:25:24','2023-06-07 16:40:50');
INSERT INTO invoices VALUES('1262','1','127','1','10','1','2023-06-05','2023-07-30 12:19:01','','JUN/23','','19000.00','19000.00','Paid','2023-06-01 15:25:24','2023-07-30 12:19:01');
INSERT INTO invoices VALUES('1263','1','128','2','22','1','2023-06-05','2023-06-13 17:43:59','','JUN/23','','20000.00','20000.00','Paid','2023-06-01 15:25:24','2023-06-13 17:43:59');
INSERT INTO invoices VALUES('1264','1','129','1','23','1','2023-06-05','2023-07-30 12:17:07','','JUN/23','','21500.00','21500.00','Paid','2023-06-01 15:25:24','2023-07-30 12:17:07');
INSERT INTO invoices VALUES('1265','1','131','1','16','1','2023-06-05','2023-06-13 17:46:36','','JUN/23','','21500.00','21500.00','Paid','2023-06-01 15:25:24','2023-06-13 17:46:36');
INSERT INTO invoices VALUES('1273','1','131','1','16','1','2023-03-15','2023-06-13 18:00:15','','Mar/23','only 15 days rent','32300.00','32300.00','Paid','2023-06-13 17:59:16','2023-06-13 18:00:15');
INSERT INTO invoices VALUES('1267','1','133','1','23','1','2023-06-05','2023-07-30 12:15:58','','JUN/23','','23000.00','23000.00','Paid','2023-06-01 15:25:24','2023-07-30 12:15:58');
INSERT INTO invoices VALUES('1268','1','134','1','3','1','2023-06-05','2023-06-13 15:20:05','','JUN/23','','20000.00','20000.00','Paid','2023-06-01 15:25:24','2023-06-13 15:20:05');
INSERT INTO invoices VALUES('1272','1','135','1','1','1','2023-06-05','2023-06-05 09:08:18','','jun/23','','20000.00','20000.00','Paid','2023-06-05 09:07:29','2023-06-05 09:08:18');
INSERT INTO invoices VALUES('1270','1','136','1','2','1','2023-06-05','2023-06-13 15:16:47','','JUN/23','','38000.00','38000.00','Paid','2023-06-01 16:35:17','2023-06-13 15:16:47');
INSERT INTO invoices VALUES('1271','1','137','1','3','1','2023-06-05','2023-06-13 15:18:29','','JUN/23','','40000.00','40000.00','Paid','2023-06-01 16:36:54','2023-06-13 15:18:29');
INSERT INTO invoices VALUES('1274','1','85','3','24','1','2023-06-10','2023-06-14 15:42:39','','security + 20 days rent','','37000.00','37000.00','Paid','2023-06-14 15:41:38','2023-06-14 15:42:39');
INSERT INTO invoices VALUES('1276','1','3','2','14','1','2023-07-05','2023-07-30 11:53:50','','jul/23','','24500.00','24500.00','Paid','2023-07-08 08:46:06','2023-07-30 11:53:50');
INSERT INTO invoices VALUES('1277','1','15','1','7','1','2023-07-05','2023-07-16 12:44:15','','jul/23','','15000.00','15000.00','Paid','2023-07-08 08:46:06','2023-07-16 12:44:15');
INSERT INTO invoices VALUES('1278','1','17','1','7','1','2023-07-05','2023-07-16 12:42:45','','jul/23','','15000.00','15000.00','Paid','2023-07-08 08:46:06','2023-07-16 12:42:45');
INSERT INTO invoices VALUES('1279','1','18','1','7','1','2023-07-05','2023-07-30 12:13:09','','jul/23','','15000.00','15000.00','Paid','2023-07-08 08:46:06','2023-07-30 12:13:09');
INSERT INTO invoices VALUES('1280','1','21','1','8','1','2023-07-05','2023-07-16 12:25:48','','jul/23','','19500.00','19500.00','Paid','2023-07-08 08:46:06','2023-07-16 12:25:48');
INSERT INTO invoices VALUES('1281','1','35','1','7','1','2023-07-05','2023-07-30 12:24:36','','jul/23','','15000.00','15000.00','Paid','2023-07-08 08:46:07','2023-07-30 12:24:36');
INSERT INTO invoices VALUES('1282','1','40','1','4','1','2023-07-05','2023-07-16 12:35:30','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:07','2023-07-16 12:35:30');
INSERT INTO invoices VALUES('1283','1','42','2','15','1','2023-07-05','2023-07-16 12:56:15','','jul/23','','21000.00','21000.00','Paid','2023-07-08 08:46:07','2023-07-16 12:56:15');
INSERT INTO invoices VALUES('1284','1','43','1','4','1','2023-07-05','2023-07-16 12:34:55','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:07','2023-07-16 12:34:55');
INSERT INTO invoices VALUES('1285','1','44','1','11','1','2023-07-05','2023-07-19 09:22:38','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:07','2023-07-19 09:22:38');
INSERT INTO invoices VALUES('1286','1','46','2','15','1','2023-07-05','2023-07-13 19:18:48','','jul/23','','21000.00','21000.00','Paid','2023-07-08 08:46:07','2023-07-13 19:18:48');
INSERT INTO invoices VALUES('1287','1','50','1','8','1','2023-07-05','','','jul/23','','19500.00','','Unpaid','2023-07-08 08:46:07','2023-07-08 08:46:07');
INSERT INTO invoices VALUES('1288','1','51','1','8','1','2023-07-05','2023-07-19 09:19:26','','jul/23','','19500.00','19500.00','Paid','2023-07-08 08:46:07','2023-07-19 09:19:26');
INSERT INTO invoices VALUES('1289','1','58','1','4','1','2023-07-05','2023-07-16 12:58:38','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:07','2023-07-16 12:58:38');
INSERT INTO invoices VALUES('1290','1','63','1','8','1','2023-07-05','2023-08-03 18:20:30','','jul/23','','19500.00','19000.00','Unpaid','2023-07-08 08:46:07','2023-08-03 18:20:30');
INSERT INTO invoices VALUES('1291','1','65','1','1','1','2023-07-05','2023-07-22 07:27:44','','jul/23','','20000.00','18000.00','Unpaid','2023-07-08 08:46:08','2023-07-22 07:27:44');
INSERT INTO invoices VALUES('1292','1','66','1','1','1','2023-07-05','2023-07-16 12:39:05','','jul/23','','20000.00','20000.00','Paid','2023-07-08 08:46:08','2023-07-16 12:39:05');
INSERT INTO invoices VALUES('1293','1','72','1','18','1','2023-07-05','2023-07-16 12:24:19','','jul/23','','26000.00','25500.00','Unpaid','2023-07-08 08:46:08','2023-07-16 12:24:19');
INSERT INTO invoices VALUES('1294','1','73','1','6','1','2023-07-05','2023-07-30 12:04:17','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-30 12:04:17');
INSERT INTO invoices VALUES('1295','1','74','1','6','1','2023-07-05','2023-07-16 12:53:09','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-16 12:53:09');
INSERT INTO invoices VALUES('1296','1','75','1','6','1','2023-07-05','2023-07-16 12:36:56','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-16 12:36:56');
INSERT INTO invoices VALUES('1297','1','77','1','6','1','2023-07-05','2023-07-16 12:36:10','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-16 12:36:10');
INSERT INTO invoices VALUES('1298','1','81','1','9','1','2023-07-05','2023-07-10 16:25:35','','jul/23','','18500.00','18500.00','Paid','2023-07-08 08:46:08','2023-07-10 16:25:35');
INSERT INTO invoices VALUES('1299','1','85','3','24','1','2023-07-05','2023-07-28 15:10:41','','jul/23','','25000.00','25000.00','Paid','2023-07-08 08:46:08','2023-07-28 15:10:41');
INSERT INTO invoices VALUES('1300','1','86','1','4','1','2023-07-05','2023-07-10 14:56:18','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-10 14:56:18');
INSERT INTO invoices VALUES('1301','1','87','1','7','1','2023-07-05','2023-07-19 09:12:15','','jul/23','','15000.00','15000.00','Paid','2023-07-08 08:46:08','2023-07-19 09:12:15');
INSERT INTO invoices VALUES('1302','1','91','3','13','1','2023-07-05','2023-07-30 11:42:11','','jul/23','','21500.00','20500.00','Unpaid','2023-07-08 08:46:08','2023-07-30 11:42:11');
INSERT INTO invoices VALUES('1303','1','92','1','9','1','2023-07-05','2023-07-09 08:46:45','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-09 08:46:45');
INSERT INTO invoices VALUES('1304','1','94','1','10','1','2023-07-05','2023-07-30 12:20:14','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-30 12:20:14');
INSERT INTO invoices VALUES('1305','1','95','2','12','1','2023-07-05','2023-07-30 11:47:07','','jul/23','','23000.00','23000.00','Paid','2023-07-08 08:46:08','2023-07-30 11:47:07');
INSERT INTO invoices VALUES('1306','1','96','2','12','1','2023-07-05','2023-07-30 11:48:01','','jul/23','','23000.00','23000.00','Paid','2023-07-08 08:46:08','2023-07-30 11:48:01');
INSERT INTO invoices VALUES('1307','1','97','1','2','1','2023-07-05','2023-07-30 12:01:42','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-30 12:01:42');
INSERT INTO invoices VALUES('1308','1','98','3','24','1','2023-07-05','2023-08-07 09:51:54','','jul/23','','36000.00','36000.00','Paid','2023-07-08 08:46:08','2023-08-07 09:51:54');
INSERT INTO invoices VALUES('1408','1','145','2','22','1','2023-08-04','2023-08-04 19:24:41','','AUG/23','NEW SEAT','40000.00','30000.00','Unpaid','2023-08-04 17:42:52','2023-08-04 19:24:41');
INSERT INTO invoices VALUES('1310','1','100','3','17','1','2023-07-05','2023-07-16 12:30:58','','jul/23','','21500.00','21500.00','Paid','2023-07-08 08:46:08','2023-07-16 12:30:58');
INSERT INTO invoices VALUES('1311','1','101','1','9','1','2023-07-05','2023-07-16 13:01:31','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-16 13:01:31');
INSERT INTO invoices VALUES('1312','1','102','1','11','1','2023-07-05','2023-07-30 12:20:41','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-30 12:20:41');
INSERT INTO invoices VALUES('1313','1','104','1','9','1','2023-07-05','2023-07-30 12:22:14','','jul/23','','18500.00','18500.00','Paid','2023-07-08 08:46:08','2023-07-30 12:22:14');
INSERT INTO invoices VALUES('1314','1','105','1','11','1','2023-07-05','2023-07-16 12:37:42','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:08','2023-07-16 12:37:42');
INSERT INTO invoices VALUES('1315','1','106','1','11','1','2023-07-05','2023-07-16 12:47:33','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:09','2023-07-16 12:47:33');
INSERT INTO invoices VALUES('1316','1','107','1','2','1','2023-07-05','2023-07-19 09:14:00','','jul/23','','19000.00','18500.00','Unpaid','2023-07-08 08:46:09','2023-07-19 09:14:00');
INSERT INTO invoices VALUES('1317','1','110','1','2','1','2023-07-05','2023-07-16 12:31:52','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:09','2023-07-16 12:31:52');
INSERT INTO invoices VALUES('1318','1','111','1','10','1','2023-07-05','2023-07-16 12:33:52','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:09','2023-07-16 12:33:52');
INSERT INTO invoices VALUES('1319','1','113','1','16','1','2023-07-05','2023-07-16 12:51:15','','jul/23','','21500.00','21000.00','Unpaid','2023-07-08 08:46:09','2023-07-16 12:51:15');
INSERT INTO invoices VALUES('1320','1','115','1','3','1','2023-07-05','2023-08-04 19:20:36','','jul/23','','20000.00','20000.00','Paid','2023-07-08 08:46:09','2023-08-04 19:20:36');
INSERT INTO invoices VALUES('1321','1','116','2','21','1','2023-07-05','','','jul/23','','15000.00','','Unpaid','2023-07-08 08:46:09','2023-07-08 08:46:09');
INSERT INTO invoices VALUES('1322','1','117','2','21','1','2023-07-05','2023-07-30 11:58:32','','jul/23','','12000.00','12000.00','Paid','2023-07-08 08:46:09','2023-07-30 11:58:32');
INSERT INTO invoices VALUES('1323','1','118','2','21','1','2023-07-05','2023-07-30 11:58:16','','jul/23','','15000.00','15000.00','Paid','2023-07-08 08:46:09','2023-07-30 11:58:16');
INSERT INTO invoices VALUES('1324','1','119','1','10','1','2023-07-05','2023-07-19 09:15:45','','jul/23','','19000.00','18500.00','Unpaid','2023-07-08 08:46:09','2023-07-19 09:15:45');
INSERT INTO invoices VALUES('1325','1','120','1','5','1','2023-07-05','2023-07-30 12:29:00','','jul/23','','21500.00','20000.00','Unpaid','2023-07-08 08:46:09','2023-07-30 12:29:00');
INSERT INTO invoices VALUES('1326','1','121','1','7','1','2023-07-05','2023-07-30 12:25:54','','jul/23','','15000.00','15000.00','Paid','2023-07-08 08:46:09','2023-07-30 12:25:54');
INSERT INTO invoices VALUES('1327','1','122','1','5','1','2023-07-05','2023-07-09 17:44:28','','jul/23','','21500.00','20000.00','Unpaid','2023-07-08 08:46:09','2023-07-09 17:44:28');
INSERT INTO invoices VALUES('1328','1','124','2','22','1','2023-07-05','2023-07-24 06:56:42','','jul/23','','20000.00','19000.00','Unpaid','2023-07-08 08:46:09','2023-07-24 06:56:42');
INSERT INTO invoices VALUES('1329','1','126','3','13','1','2023-07-05','2023-07-16 12:57:26','','jul/23','','21500.00','21000.00','Unpaid','2023-07-08 08:46:09','2023-07-16 12:57:26');
INSERT INTO invoices VALUES('1330','1','127','1','10','1','2023-07-05','2023-07-19 09:09:28','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:09','2023-07-19 09:09:28');
INSERT INTO invoices VALUES('1331','1','128','2','22','1','2023-07-05','2023-07-16 12:28:14','','jul/23','','20000.00','20000.00','Paid','2023-07-08 08:46:09','2023-07-16 12:28:14');
INSERT INTO invoices VALUES('1332','1','129','1','23','1','2023-07-05','2023-07-30 12:18:13','','jul/23','','21500.00','21500.00','Paid','2023-07-08 08:46:09','2023-07-30 12:18:13');
INSERT INTO invoices VALUES('1333','1','131','1','16','1','2023-07-05','2023-07-22 07:30:19','','jul/23','','21500.00','21500.00','Paid','2023-07-08 08:46:09','2023-07-22 07:30:19');
INSERT INTO invoices VALUES('1334','1','133','1','23','1','2023-07-05','2023-07-30 12:16:28','','jul/23','','23000.00','23000.00','Paid','2023-07-08 08:46:10','2023-07-30 12:16:28');
INSERT INTO invoices VALUES('1335','1','134','1','3','1','2023-07-05','2023-07-30 11:23:21','','jul/23','','20000.00','20000.00','Paid','2023-07-08 08:46:10','2023-07-30 11:23:21');
INSERT INTO invoices VALUES('1336','1','135','1','1','1','2023-07-05','2023-07-10 07:02:46','','jul/23','','20000.00','20000.00','Paid','2023-07-08 08:46:10','2023-07-10 07:02:46');
INSERT INTO invoices VALUES('1337','1','136','1','2','1','2023-07-05','2023-07-16 12:46:23','','jul/23','','19000.00','19000.00','Paid','2023-07-08 08:46:10','2023-07-16 12:46:23');
INSERT INTO invoices VALUES('1338','1','137','1','3','1','2023-07-05','2023-07-30 11:25:05','','jul/23','','20000.00','20000.00','Paid','2023-07-08 08:46:10','2023-07-30 11:25:05');
INSERT INTO invoices VALUES('1339','1','138','1','2','1','2023-07-05','2023-07-16 13:05:00','','JUL/23','','19000.00','19000.00','Unpaid','2023-07-08 08:46:10','2023-07-30 11:44:57');
INSERT INTO invoices VALUES('1344','1','3','2','14','1','2023-08-03','2023-08-07 09:57:09','','AUG/23','','24500.00','24500.00','Paid','2023-08-03 06:07:32','2023-08-07 09:57:09');
INSERT INTO invoices VALUES('1341','1','139','3','24','1','2023-07-15','2023-08-07 09:53:55','','JUL/23','NEW SEAT','33000.00','30000.00','Unpaid','2023-07-22 07:46:08','2023-08-07 09:53:55');
INSERT INTO invoices VALUES('1342','1','140','3','24','1','2023-07-26','2023-07-26 14:38:56','','SECURITY FEE','','25000.00','25000.00','Paid','2023-07-26 14:35:38','2023-07-26 14:38:56');
INSERT INTO invoices VALUES('1343','1','141','2','20','1','2023-07-28','2023-07-28 15:39:18','','SECURITY FOR ROOM','','20000.00','20000.00','Paid','2023-07-28 15:38:34','2023-07-28 15:39:18');
INSERT INTO invoices VALUES('1345','1','15','1','7','1','2023-08-03','2023-08-05 18:58:29','','AUG/23','','15000.00','15000.00','Paid','2023-08-03 06:07:32','2023-08-05 18:58:29');
INSERT INTO invoices VALUES('1346','1','17','1','7','1','2023-08-03','2023-08-05 19:00:07','','AUG/23','','15000.00','15000.00','Paid','2023-08-03 06:07:32','2023-08-05 19:00:07');
INSERT INTO invoices VALUES('1347','1','18','1','7','1','2023-08-03','','','AUG/23','','15000.00','','Unpaid','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoices VALUES('1348','1','21','1','8','1','2023-08-03','2023-08-03 18:21:29','','AUG/23','','19500.00','19500.00','Paid','2023-08-03 06:07:32','2023-08-03 18:21:29');
INSERT INTO invoices VALUES('1349','1','35','1','7','1','2023-08-03','2023-08-05 19:02:34','','AUG/23','','15000.00','15000.00','Paid','2023-08-03 06:07:32','2023-08-05 19:02:34');
INSERT INTO invoices VALUES('1350','1','40','1','4','1','2023-08-03','2023-08-04 19:18:53','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:32','2023-08-04 19:18:53');
INSERT INTO invoices VALUES('1351','1','42','2','15','1','2023-08-03','2023-08-04 19:11:08','','AUG/23','','21000.00','21000.00','Paid','2023-08-03 06:07:32','2023-08-04 19:11:08');
INSERT INTO invoices VALUES('1352','1','43','1','4','1','2023-08-03','2023-08-04 19:17:35','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:32','2023-08-04 19:17:35');
INSERT INTO invoices VALUES('1353','1','44','1','11','1','2023-08-03','','','AUG/23','','19000.00','','Unpaid','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoices VALUES('1354','1','46','2','15','1','2023-08-03','2023-08-04 19:16:57','','AUG/23','','21000.00','21000.00','Paid','2023-08-03 06:07:32','2023-08-04 19:16:57');
INSERT INTO invoices VALUES('1355','1','51','1','8','1','2023-08-03','2023-08-04 19:33:45','','AUG/23','','19500.00','19500.00','Paid','2023-08-03 06:07:32','2023-08-04 19:33:45');
INSERT INTO invoices VALUES('1356','1','58','1','4','1','2023-08-03','2023-08-04 19:09:34','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:32','2023-08-04 19:09:34');
INSERT INTO invoices VALUES('1357','1','63','1','8','1','2023-08-03','2023-08-03 18:22:31','','AUG/23','','19500.00','19500.00','Paid','2023-08-03 06:07:32','2023-08-03 18:22:31');
INSERT INTO invoices VALUES('1358','1','65','1','1','1','2023-08-03','','','AUG/23','','20000.00','','Unpaid','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoices VALUES('1359','1','66','1','1','1','2023-08-03','2023-08-09 07:31:16','','AUG/23','','20000.00','12000.00','Unpaid','2023-08-03 06:07:32','2023-08-09 07:31:16');
INSERT INTO invoices VALUES('1360','1','72','1','18','1','2023-08-03','2023-08-04 19:36:05','','AUG/23','','26000.00','26000.00','Paid','2023-08-03 06:07:32','2023-08-04 19:36:05');
INSERT INTO invoices VALUES('1361','1','73','1','6','1','2023-08-03','','','AUG/23','','19000.00','','Unpaid','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoices VALUES('1362','1','74','1','6','1','2023-08-03','2023-08-07 08:14:22','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:32','2023-08-07 08:14:22');
INSERT INTO invoices VALUES('1363','1','75','1','6','1','2023-08-03','','','AUG/23','','19000.00','','Unpaid','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoices VALUES('1364','1','77','1','6','1','2023-08-03','2023-08-07 08:13:13','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:32','2023-08-07 08:13:13');
INSERT INTO invoices VALUES('1365','1','81','1','9','1','2023-08-03','','','AUG/23','','18500.00','','Unpaid','2023-08-03 06:07:32','2023-08-03 06:07:32');
INSERT INTO invoices VALUES('1366','1','86','1','4','1','2023-08-03','2023-08-04 19:10:23','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:10:23');
INSERT INTO invoices VALUES('1367','1','87','1','7','1','2023-08-03','2023-08-05 19:03:17','','AUG/23','','15000.00','15000.00','Paid','2023-08-03 06:07:33','2023-08-05 19:03:17');
INSERT INTO invoices VALUES('1368','1','91','3','13','1','2023-08-03','','','AUG/23','','21500.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1369','1','92','1','9','1','2023-08-03','','','AUG/23','','19000.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1370','1','94','1','10','1','2023-08-03','2023-08-07 10:22:56','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-07 10:22:56');
INSERT INTO invoices VALUES('1371','1','95','2','12','1','2023-08-03','2023-08-04 19:22:57','','AUG/23','','23000.00','23000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:22:57');
INSERT INTO invoices VALUES('1372','1','96','2','12','1','2023-08-03','','','AUG/23','','23000.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1373','1','97','1','8','1','2023-08-03','2023-08-04 19:25:42','','AUG/23','','19500.00','19500.00','Paid','2023-08-03 06:07:33','2023-08-04 19:25:42');
INSERT INTO invoices VALUES('1374','1','98','3','24','1','2023-08-03','2023-08-07 09:49:55','','AUG/23','','24000.00','24000.00','Paid','2023-08-03 06:07:33','2023-08-07 09:49:55');
INSERT INTO invoices VALUES('1375','1','100','3','17','1','2023-08-03','2023-08-04 19:31:22','','AUG/23','','21500.00','21500.00','Paid','2023-08-03 06:07:33','2023-08-04 19:31:22');
INSERT INTO invoices VALUES('1376','1','101','1','9','1','2023-08-03','2023-08-07 09:46:00','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-07 09:46:00');
INSERT INTO invoices VALUES('1377','1','102','1','11','1','2023-08-03','','','AUG/23','','19000.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1378','1','104','1','9','1','2023-08-03','2023-08-04 19:32:02','','AUG/23','','18500.00','18500.00','Paid','2023-08-03 06:07:33','2023-08-04 19:32:02');
INSERT INTO invoices VALUES('1379','1','105','1','11','1','2023-08-03','','','AUG/23','','19000.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1380','1','106','1','11','1','2023-08-03','','','AUG/23','','19000.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1381','1','107','1','2','1','2023-08-03','2023-08-04 19:16:26','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:16:26');
INSERT INTO invoices VALUES('1382','1','110','1','2','1','2023-08-03','2023-08-04 19:30:22','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:30:22');
INSERT INTO invoices VALUES('1383','1','111','1','10','1','2023-08-03','2023-08-09 07:28:18','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-09 07:28:18');
INSERT INTO invoices VALUES('1384','1','113','1','16','1','2023-08-03','','','AUG/23','','21500.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1385','1','115','1','3','1','2023-08-03','2023-08-04 19:22:20','','AUG/23','','20000.00','20000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:22:20');
INSERT INTO invoices VALUES('1386','1','116','2','21','1','2023-08-03','','','AUG/23','','15000.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1387','1','117','2','21','1','2023-08-03','2023-08-05 18:59:01','','AUG/23','','12000.00','12000.00','Paid','2023-08-03 06:07:33','2023-08-05 18:59:01');
INSERT INTO invoices VALUES('1388','1','118','2','21','1','2023-08-03','','','AUG/23','','15000.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1389','1','119','1','10','1','2023-08-03','2023-08-09 07:24:12','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-09 07:24:12');
INSERT INTO invoices VALUES('1390','1','120','1','5','1','2023-08-03','','','AUG/23','','21500.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1391','1','121','1','7','1','2023-08-03','2023-08-05 19:00:54','','AUG/23','','15000.00','15000.00','Paid','2023-08-03 06:07:33','2023-08-05 19:00:54');
INSERT INTO invoices VALUES('1392','1','122','1','5','1','2023-08-03','2023-08-09 07:29:39','','AUG/23','','21500.00','21500.00','Paid','2023-08-03 06:07:33','2023-08-09 07:29:39');
INSERT INTO invoices VALUES('1393','1','126','3','13','1','2023-08-03','2023-08-04 19:29:38','','AUG/23','','21500.00','21500.00','Paid','2023-08-03 06:07:33','2023-08-04 19:29:38');
INSERT INTO invoices VALUES('1394','1','127','1','10','1','2023-08-03','2023-08-09 07:26:38','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-09 07:26:38');
INSERT INTO invoices VALUES('1395','1','129','1','17','1','2023-08-03','','','AUG/23','','21500.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1396','1','131','1','16','1','2023-08-03','2023-08-05 19:01:55','','AUG/23','','21500.00','21500.00','Paid','2023-08-03 06:07:33','2023-08-05 19:01:55');
INSERT INTO invoices VALUES('1397','1','133','1','3','1','2023-08-03','2023-08-04 19:39:09','','AUG/23','','20000.00','20000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:39:09');
INSERT INTO invoices VALUES('1398','1','135','1','1','1','2023-08-03','','','AUG/23','','20000.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1399','1','136','1','2','1','2023-08-03','2023-08-04 19:25:10','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:25:10');
INSERT INTO invoices VALUES('1400','1','137','1','3','1','2023-08-03','2023-08-04 19:28:54','','AUG/23','','20000.00','20000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:28:54');
INSERT INTO invoices VALUES('1401','1','138','1','2','1','2023-08-03','2023-08-04 19:23:59','','AUG/23','','19000.00','19000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:23:59');
INSERT INTO invoices VALUES('1402','1','139','3','24','1','2023-08-03','2023-08-07 09:54:47','','AUG/23','','23000.00','23000.00','Paid','2023-08-03 06:07:33','2023-08-07 09:54:47');
INSERT INTO invoices VALUES('1403','1','140','3','24','1','2023-08-03','','','AUG/23','','25000.00','','Unpaid','2023-08-03 06:07:33','2023-08-03 06:07:33');
INSERT INTO invoices VALUES('1404','1','141','2','22','1','2023-08-03','2023-08-04 19:18:15','','AUG/23','','20000.00','20000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:18:15');
INSERT INTO invoices VALUES('1405','1','142','1','23','1','2023-08-03','2023-08-04 19:26:35','','AUG/23','','22000.00','22000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:26:35');
INSERT INTO invoices VALUES('1406','1','143','1','23','1','2023-08-03','2023-08-04 19:27:08','','AUG/23','','22000.00','22000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:27:08');
INSERT INTO invoices VALUES('1407','1','144','3','24','1','2023-08-03','2023-08-04 19:19:46','','AUG/23','','25000.00','25000.00','Paid','2023-08-03 06:07:33','2023-08-04 19:19:46');



DROP TABLE IF EXISTS library_members;

CREATE TABLE `library_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `school_id` int(11) NOT NULL,
  `library_id` int(11) NOT NULL,
  `member_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS mark_details;

CREATE TABLE `mark_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `mark_id` int(11) NOT NULL,
  `mark_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mark_value` decimal(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS mark_distributions;

CREATE TABLE `mark_distributions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `mark_distribution_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mark_percentage` decimal(8,2) NOT NULL,
  `is_exam` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `is_active` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS marks;

CREATE TABLE `marks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS messages;

CREATE TABLE `messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS migrations;

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS notices;

CREATE TABLE `notices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO notices VALUES('3','1','LEAVING NOTICE 102','<p>NOTICE <a href=\"DATE:13/01/2022\">DATE:13/01/2022</a></p><p><a href=\"NAME:HARIS\">NAME: HARIS</a> SHEHROZ</p><p>ROOM#102 </p><p>EXIT <a href=\"DATE:17/01/2022\">DATE:17/01/2022</a></p><p>SECURITY: 6000<br></p>','2022-01-19 18:29:39','2022-01-19 18:29:39');
INSERT INTO notices VALUES('2','1','LEAVING NOTICE ROOM#102','<p>MUHAMMAD ALI</p><p>ROOM#102</p><p>31/01/2022<br></p>','2022-01-19 18:24:14','2022-01-19 18:25:50');
INSERT INTO notices VALUES('4','1','LEAVING NOTICE  110','<p><span style=\"background-color: rgb(239, 239, 239);\">NOTICE DATE :&nbsp; 13-1-2022</span></p><p><span style=\"background-color: rgb(239, 239, 239);\">NAME&nbsp;&nbsp; :&nbsp;&nbsp;&nbsp;&nbsp; ABDULLAH ALTAF</span></p><p><span style=\"background-color: rgb(239, 239, 239);\">ROON NUM : 110</span></p><p><span style=\"background-color: rgb(239, 239, 239);\">EXIT&nbsp; DATE&nbsp;&nbsp; : 14-1-2022</span></p><p><span style=\"background-color: rgb(239, 239, 239);\">SECURITY&nbsp;&nbsp;&nbsp; : 17500</span><br></p>','2022-01-19 19:21:57','2022-01-19 19:21:57');
INSERT INTO notices VALUES('5','1','LEAVING NOTICE 108','<p>NOTICE DATE: 16-1-2022</p><p>NAME &nbsp;&nbsp; : HASHAM TAYYAB</p><p>ROON NUM&nbsp; : 108</p><p>EXIT DATE : 16-1-2022</p><p>SECRUITY&nbsp; :18000<br></p>','2022-01-19 19:39:25','2022-01-19 19:39:25');
INSERT INTO notices VALUES('6','1','LEAVING  NOTICE 108','<p>NOTICE DATE : 13-1-2022</p><p>NAME&nbsp;&nbsp;&nbsp; :&nbsp; MUHAMMAD ZEESHAN </p><p>ROOM NUM : 108</p><p>EXIT DATE : 31-1-2022</p><p>SECURITY&nbsp; : 10000<br></p>','2022-01-19 19:49:32','2022-01-19 19:49:32');
INSERT INTO notices VALUES('7','1','LEAVING NOTICE 108','<p>NOTICE DATE :&nbsp;&nbsp; 13-1-2022</p><p>NAME&nbsp; : AFAF MUZAMMIL</p><p>ROOM NUM :&nbsp; 108</p><p>EXIT DATE : 31-1-2022</p><p>SECURITY&nbsp; : 18500<br></p>','2022-01-19 19:52:35','2022-01-19 19:52:35');
INSERT INTO notices VALUES('8','1','LEAVING NOTICE 102','<p>NOTICE DATE :&nbsp; 13-1-2022</p><p>NAME&nbsp; : MUHAMMAD UMAR SHAHID</p><p>ROOM NUM : 102</p><p>EXIT DATE&nbsp; : 15-1-2022</p><p>SECURITY :17500<br></p>','2022-01-19 19:55:14','2022-01-19 19:55:14');
INSERT INTO notices VALUES('9','1','Ignore Notice','This notice is only for testing purposes so just ignore it.<br>','2022-02-24 10:59:25','2022-02-24 10:59:25');



DROP TABLE IF EXISTS packages;

CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `max_user` int(11) DEFAULT 0,
  `price` double DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS page_contents;

CREATE TABLE `page_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(11) NOT NULL,
  `page_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_content` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seo_meta_keywords` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seo_meta_description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'english',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS pages;

CREATE TABLE `pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_template` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `featured_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS parents;

CREATE TABLE `parents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `parent_name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `f_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `m_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `f_profession` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `m_profession` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO parents VALUES('2','1','638','Default','Default','Default','','','03111689150','','2021-10-05 10:53:50','2021-10-05 10:53:50');



DROP TABLE IF EXISTS password_resets;

CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS payee_payers;

CREATE TABLE `payee_payers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payee_payers VALUES('1','1','Bank (AmirSb)','payer','','2021-10-05 12:39:30','2023-04-09 17:43:54');
INSERT INTO payee_payers VALUES('2','1','Account Head','payee','','2023-04-08 09:20:46','2023-04-08 09:20:46');
INSERT INTO payee_payers VALUES('3','1','Cash In Hand','payer','','2023-04-09 17:44:27','2023-04-09 17:44:27');



DROP TABLE IF EXISTS payment_methods;

CREATE TABLE `payment_methods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `school_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_methods VALUES('1','BANK','1','2021-06-17 01:43:59','2021-06-17 01:43:59');
INSERT INTO payment_methods VALUES('4','CASH','1','2021-06-17 01:49:06','2021-06-17 01:49:06');



DROP TABLE IF EXISTS permission_roles;

CREATE TABLE `permission_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `role_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permission_roles VALUES('1','1','Accountant','','2020-01-04 15:04:31','2020-01-05 14:53:21');
INSERT INTO permission_roles VALUES('2','1','admin 2','','2020-04-11 13:50:52','2020-04-11 13:50:52');
INSERT INTO permission_roles VALUES('3','1','Super Admin','','2020-04-11 14:14:21','2020-04-11 14:14:21');
INSERT INTO permission_roles VALUES('5','1','Testing','','2020-04-11 15:20:39','2020-04-11 15:20:39');
INSERT INTO permission_roles VALUES('6','1','students','','2021-03-07 09:09:23','2021-03-07 09:09:23');
INSERT INTO permission_roles VALUES('7','1','Manager','','2021-06-17 02:13:04','2021-06-17 02:13:04');
INSERT INTO permission_roles VALUES('8','1','Chef','','2021-06-17 02:13:17','2021-06-17 02:13:17');
INSERT INTO permission_roles VALUES('9','1','Cook','','2021-06-17 02:13:26','2021-06-17 02:13:26');
INSERT INTO permission_roles VALUES('10','1','Cook Helper','','2021-06-17 02:13:37','2021-06-17 02:13:37');
INSERT INTO permission_roles VALUES('11','1','Sweeper','','2021-06-17 02:13:48','2021-06-17 02:13:48');
INSERT INTO permission_roles VALUES('12','1','Guard','','2021-06-17 02:13:57','2021-06-17 02:13:57');
INSERT INTO permission_roles VALUES('13','1','HOUSE KEEPER','','2022-03-01 18:00:24','2022-03-01 18:00:24');
INSERT INTO permission_roles VALUES('14','1','WAITER','','2022-03-01 18:00:42','2022-03-01 18:00:42');
INSERT INTO permission_roles VALUES('15','1','SUPERVISOR','','2022-03-01 18:00:57','2022-03-01 18:00:57');



DROP TABLE IF EXISTS permissions;

CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1353 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES('432','1','1','invoices.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('431','1','1','fee_types.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('4','2','1','users.edit','2020-01-04 15:04:55','2020-01-04 15:04:55');
INSERT INTO permissions VALUES('430','1','1','fee_types.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('429','1','1','fee_types.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('428','1','1','fee_types.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('427','1','1','fee_types.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('426','1','1','transactions.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('425','1','1','transactions.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('424','1','1','transactions.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('423','1','1','transactions.store','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('422','1','1','transactions.add_expense','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('421','1','1','transactions.add_income','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('420','1','1','transactions.manage_expense','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('419','1','1','transactions.manage_income','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('418','1','1','payee_payers.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('417','1','1','payee_payers.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('416','1','1','payee_payers.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('415','1','1','payee_payers.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('414','1','1','payee_payers.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('413','1','1','payment_methods.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('412','1','1','payment_methods.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('411','1','1','payment_methods.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('410','1','1','payment_methods.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('409','1','1','payment_methods.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('408','1','1','chart_of_accounts.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('407','1','1','chart_of_accounts.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('406','1','1','chart_of_accounts.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('405','1','1','chart_of_accounts.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('404','1','1','chart_of_accounts.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('403','1','1','accounts.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('402','1','1','accounts.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('401','1','1','accounts.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('400','1','1','accounts.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('399','1','1','accounts.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('398','1','1','users.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('360','1','2','students.promote','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('359','1','2','students.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('358','1','2','students.view_id_card','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('357','1','2','parents.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('356','1','2','parents.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('355','1','2','parents.show','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('354','1','2','parents.create','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('353','1','2','parents.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('352','1','2','teachers.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('351','1','2','teachers.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('350','1','2','teachers.show','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('349','1','2','teachers.create','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('348','1','2','teachers.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('347','1','2','users.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('346','1','2','users.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('345','1','2','users.show','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('344','1','2','users.create','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('343','1','2','users.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('1348','1','3','permission_roles.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1347','1','3','permission_roles.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1346','1','3','permission_roles.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1345','1','3','permission_roles.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1344','1','3','permission_roles.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1343','1','3','permission.manage','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1342','1','3','reports.generate_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1341','1','3','reports.report_area','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1340','1','3','reports.account_balance','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1339','1','3','reports.expense_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1338','1','3','reports.income_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1337','1','3','reports.exam_routine','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1336','1','3','reports.class_routine','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1335','1','3','reports.progress_card','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1334','1','3','reports.exam_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1333','1','3','reports.student_id_card','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1332','1','3','reports.staff_attendance_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1331','1','3','reports.student_attendance_report','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1330','1','3','events.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1329','1','3','events.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1328','1','3','events.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1327','1','3','events.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1326','1','3','notices.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1325','1','3','notices.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1324','1','3','notices.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1323','1','3','notices.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1322','1','3','email.view_logs','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1321','1','3','email.compose','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1320','1','3','sms.view_logs','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1319','1','3','sms.compose','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1318','1','3','student_payments.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1317','1','3','student_payments.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1316','1','3','student_payments.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1315','1','3','student_payments.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1314','1','3','student_payments.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1313','1','3','student_ledger_print','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1312','1','3','student_ledger','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1311','1','3','invoices.fee_receipt_store','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1310','1','3','invoices.fee_receipt','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1309','1','3','invoices.as_assigned','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1308','1','3','invoices.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1307','1','3','invoices.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1306','1','3','invoices.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1305','1','3','invoices.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1304','1','3','invoices.feeBill','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1303','1','3','invoices.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1302','1','3','fee_types.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1301','1','3','fee_types.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1300','1','3','fee_types.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1299','1','3','fee_types.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1298','1','3','fee_types.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1297','1','3','transactions.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1296','1','3','transactions.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1295','1','3','transactions.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1294','1','3','transactions.store','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1293','1','3','transactions.add_expense','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1292','1','3','transactions.add_income','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1291','1','3','transactions.manage_expense','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1290','1','3','transactions.manage_income','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1289','1','3','payee_payers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1288','1','3','payee_payers.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1287','1','3','payee_payers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1286','1','3','payee_payers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1285','1','3','payee_payers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1284','1','3','payment_methods.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1283','1','3','payment_methods.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1282','1','3','payment_methods.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1281','1','3','payment_methods.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1280','1','3','payment_methods.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1279','1','3','chart_of_accounts.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1278','1','3','chart_of_accounts.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1277','1','3','chart_of_accounts.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1276','1','3','chart_of_accounts.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1275','1','3','chart_of_accounts.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1274','1','3','accounts.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1273','1','3','accounts.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1272','1','3','accounts.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1271','1','3','accounts.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1270','1','3','accounts.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1269','1','3','marks.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1268','1','3','marks.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1267','1','3','marks.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1266','1','3','marks.view_student_rank','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1265','1','3','mark_distributions.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1264','1','3','mark_distributions.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1263','1','3','mark_distributions.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1262','1','3','mark_distributions.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1261','1','3','mark_distributions.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1260','1','3','grades.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1259','1','3','grades.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1258','1','3','grades.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1257','1','3','grades.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1256','1','3','grades.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1255','1','3','exams.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1254','1','3','exams.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1253','1','3','exams.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1252','1','3','exams.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1251','1','3','exams.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1250','1','3','exams.store_exam_schedule','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1249','1','3','exams.store_exam_attendance','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1248','1','3','exams.view_schedule','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1247','1','3','hostelmembers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1246','1','3','hostelmembers.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1245','1','3','hostelmembers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1244','1','3','hostelmembers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1243','1','3','hostelmembers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1242','1','3','hostelcategories.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1241','1','3','hostelcategories.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1240','1','3','hostelcategories.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1239','1','3','hostelcategories.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1238','1','3','hostelcategories.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1237','1','3','hostels.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1236','1','3','hostels.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1235','1','3','hostels.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1234','1','3','hostels.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1233','1','3','hostels.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1232','1','3','transportmembers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1231','1','3','transportmembers.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1230','1','3','transportmembers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1229','1','3','transportmembers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1228','1','3','transportmembers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1227','1','3','transports.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1226','1','3','transports.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1225','1','3','transports.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1224','1','3','transports.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1223','1','3','transports.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1222','1','3','transportvehicles.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1221','1','3','transportvehicles.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1220','1','3','transportvehicles.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1219','1','3','transportvehicles.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1218','1','3','transportvehicles.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1217','1','3','bookcategories.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1216','1','3','bookcategories.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1215','1','3','bookcategories.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1214','1','3','bookcategories.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1213','1','3','bookcategories.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1212','1','3','bookissues.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1211','1','3','bookissues.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1210','1','3','bookissues.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1209','1','3','bookissues.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1208','1','3','bookissues.return','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1207','1','3','bookissues.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1206','1','3','books.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1205','1','3','books.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1204','1','3','books.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1203','1','3','books.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1202','1','3','books.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1201','1','3','librarymembers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1200','1','3','librarymembers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1199','1','3','librarymembers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1198','1','3','librarymembers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1197','1','3','librarymembers.view_library_card','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1196','1','3','picklists.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1195','1','3','picklists.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1194','1','3','picklists.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1193','1','3','picklists.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1192','1','3','picklists.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1191','1','3','languages.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1190','1','3','languages.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1189','1','3','languages.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1188','1','3','languages.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1184','1','3','staff_attendance.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1185','1','3','general_settings.update','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1186','1','3','theme_option.update','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1187','1','3','utility.backup_database','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('361','1','2','students.create','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('362','1','2','students.show','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('363','1','2','students.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('364','1','2','students.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('365','1','2','class.index','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('366','1','2','class.store','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('367','1','2','class.edit','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('368','1','2','class.destroy','2020-04-11 15:05:18','2020-04-11 15:05:18');
INSERT INTO permissions VALUES('369','1','4','students.view_id_card','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('370','1','4','students.index','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('371','1','4','students.promote','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('372','1','4','students.create','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('373','1','4','students.show','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('374','1','4','students.edit','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('375','1','4','students.destroy','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('376','1','4','class.index','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('377','1','4','class.store','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('378','1','4','class.edit','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('379','1','4','class.destroy','2020-04-11 15:09:41','2020-04-11 15:09:41');
INSERT INTO permissions VALUES('380','1','5','transports.index','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('381','1','5','transports.create','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('382','1','5','transports.show','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('383','1','5','transports.edit','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('384','1','5','transports.destroy','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('385','1','5','transactions.manage_income','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('386','1','5','transactions.manage_expense','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('387','1','5','transactions.add_income','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('388','1','5','transactions.add_expense','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('389','1','5','transactions.store','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('390','1','5','transactions.show','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('391','1','5','transactions.edit','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('392','1','5','transactions.destroy','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('393','1','5','student_payments.create','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('394','1','5','student_payments.index','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('395','1','5','student_payments.show','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('396','1','5','student_payments.edit','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('397','1','5','student_payments.destroy','2020-04-11 15:22:50','2020-04-11 15:22:50');
INSERT INTO permissions VALUES('433','1','1','invoices.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('434','1','1','invoices.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('435','1','1','invoices.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('436','1','1','student_payments.create','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('437','1','1','student_payments.index','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('438','1','1','student_payments.show','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('439','1','1','student_payments.edit','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('440','1','1','student_payments.destroy','2021-01-21 05:09:01','2021-01-21 05:09:01');
INSERT INTO permissions VALUES('1350','1','6','student_ledger','2023-04-06 10:02:55','2023-04-06 10:02:55');
INSERT INTO permissions VALUES('1349','1','6','invoices.show','2023-04-06 10:02:55','2023-04-06 10:02:55');
INSERT INTO permissions VALUES('1183','1','3','student_attendance.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1182','1','3','class_routines.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1181','1','3','class_routines.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1180','1','3','class_routines.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1178','1','3','student_groups.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1179','1','3','student_groups.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1177','1','3','student_groups.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1176','1','3','student_groups.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1175','1','3','student_groups.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1174','1','3','academic_years.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1173','1','3','academic_years.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1171','1','3','academic_years.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1172','1','3','academic_years.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1170','1','3','academic_years.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1169','1','3','assignments.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1168','1','3','assignments.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1167','1','3','assignments.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1166','1','3','assignments.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1165','1','3','assignments.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1164','1','3','syllabus.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1163','1','3','syllabus.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1162','1','3','syllabus.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1161','1','3','syllabus.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1160','1','3','syllabus.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1159','1','3','assignsubjects.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1158','1','3','assignsubjects.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1156','1','3','assignsubjects.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1157','1','3','assignsubjects.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1155','1','3','assignsubjects.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1154','1','3','subjects.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1153','1','3','subjects.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1152','1','3','subjects.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1151','1','3','subjects.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1150','1','3','subjects.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1149','1','3','sections.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1148','1','3','sections.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1147','1','3','sections.store','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1146','1','3','sections.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1145','1','3','class.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1144','1','3','class.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1143','1','3','class.store','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1142','1','3','class.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1141','1','3','students.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1140','1','3','students.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1139','1','3','students.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1138','1','3','students.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1137','1','3','students.promote','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1136','1','3','students.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1135','1','3','students.view_id_card','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1134','1','3','parents.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1133','1','3','parents.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1132','1','3','parents.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1131','1','3','parents.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1130','1','3','parents.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1129','1','3','teachers.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1128','1','3','teachers.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1127','1','3','teachers.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1126','1','3','teachers.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1125','1','3','teachers.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1124','1','3','users.destroy','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1123','1','3','users.edit','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1122','1','3','users.show','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1121','1','3','users.create','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1120','1','3','users.index','2021-04-05 22:27:30','2021-04-05 22:27:30');
INSERT INTO permissions VALUES('1351','1','6','notices.index','2023-04-06 10:02:55','2023-04-06 10:02:55');
INSERT INTO permissions VALUES('1352','1','6','notices.create','2023-04-06 10:02:55','2023-04-06 10:02:55');



DROP TABLE IF EXISTS picklists;

CREATE TABLE `picklists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO picklists VALUES('1','1','Religion','MUSLIM','2021-08-04 18:46:14','2021-08-04 18:46:14');
INSERT INTO picklists VALUES('2','1','Religion','NON MUSLIM','2021-08-04 18:46:55','2021-08-04 18:46:55');
INSERT INTO picklists VALUES('3','1','Designation','MANAGER','2021-08-04 18:47:32','2021-08-04 18:47:32');
INSERT INTO picklists VALUES('4','1','Designation','COOK','2021-08-04 18:47:57','2021-08-04 18:47:57');
INSERT INTO picklists VALUES('5','1','Designation','SWEEPER','2021-08-04 18:48:22','2021-08-04 18:48:22');
INSERT INTO picklists VALUES('6','1','Designation','MALI','2021-08-04 18:48:41','2022-03-01 18:07:09');
INSERT INTO picklists VALUES('7','1','Designation','SUPERVISOR','2022-03-01 18:03:32','2022-03-01 18:03:32');
INSERT INTO picklists VALUES('8','1','Designation','RECEPTIONIST','2022-03-01 18:03:52','2022-03-01 18:03:52');
INSERT INTO picklists VALUES('9','1','Designation','ACCOUNTANT','2022-03-01 18:04:04','2022-03-01 18:04:04');
INSERT INTO picklists VALUES('10','1','Designation','COOK HELPER','2022-03-01 18:05:14','2022-03-01 18:05:14');
INSERT INTO picklists VALUES('11','1','Designation','WAITER','2022-03-01 18:05:27','2022-03-01 18:05:27');
INSERT INTO picklists VALUES('12','1','Designation','HOUSE KEEPER','2022-03-01 18:05:48','2022-03-01 18:05:48');
INSERT INTO picklists VALUES('13','1','Designation','ELECTRICIAN','2022-03-01 18:06:08','2022-03-01 18:06:08');
INSERT INTO picklists VALUES('14','1','Designation','GUARD','2022-03-01 18:06:31','2022-03-01 18:06:31');



DROP TABLE IF EXISTS post_categories;

CREATE TABLE `post_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trans_category` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS post_contents;

CREATE TABLE `post_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_content` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'english',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS posts;

CREATE TABLE `posts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int(11) NOT NULL,
  `author_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS school_invoices;

CREATE TABLE `school_invoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `package_id` int(11) DEFAULT NULL,
  `invoice_no` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_period` int(11) DEFAULT 0,
  `invoice_date` date DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(8,2) DEFAULT 0.00,
  `paid` decimal(8,2) DEFAULT 0.00,
  `status` enum('Due','Paid') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS sections;

CREATE TABLE `sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) DEFAULT NULL,
  `section_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_no` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class_id` int(11) NOT NULL,
  `class_teacher_id` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `rank` int(11) DEFAULT NULL,
  `capacity` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO sections VALUES('1','1','101','Basement','1','','1','','3','2021-10-04 23:54:44','2021-10-04 23:54:44');
INSERT INTO sections VALUES('2','1','102','','1','','1','','4','2021-10-04 23:55:30','2021-10-04 23:55:30');
INSERT INTO sections VALUES('3','1','103','','1','','1','','3','2021-10-04 23:55:52','2021-10-04 23:55:52');
INSERT INTO sections VALUES('4','1','104','','1','','1','','4','2021-10-04 23:56:30','2021-10-04 23:56:30');
INSERT INTO sections VALUES('5','1','105','','1','','1','','2','2021-10-04 23:57:02','2021-10-04 23:57:02');
INSERT INTO sections VALUES('6','1','106','','1','','1','','4','2021-10-04 23:57:25','2021-10-04 23:57:25');
INSERT INTO sections VALUES('7','1','107','Attach bath','1','','1','','6','2021-10-04 23:58:36','2022-11-14 18:45:28');
INSERT INTO sections VALUES('8','1','108','Attach bath','1','','1','','4','2021-10-04 23:59:20','2021-10-04 23:59:20');
INSERT INTO sections VALUES('9','1','109','','1','','1','','4','2021-10-04 23:59:50','2021-10-04 23:59:50');
INSERT INTO sections VALUES('10','1','110','','1','','1','','4','2021-10-05 00:00:18','2021-10-05 00:00:18');
INSERT INTO sections VALUES('11','1','111','','1','','1','','4','2021-10-05 00:00:42','2021-10-05 00:00:42');
INSERT INTO sections VALUES('12','1','112','Guest house','2','','1','','2','2021-10-05 00:01:24','2022-06-28 08:46:08');
INSERT INTO sections VALUES('13','1','113','Guest house','3','','1','','2','2021-10-05 00:02:05','2022-04-17 05:41:08');
INSERT INTO sections VALUES('14','1','114','114','2','','1','','1','2021-12-04 17:41:33','2022-06-28 08:56:25');
INSERT INTO sections VALUES('15','1','115','','2','','1','','2','2021-12-04 17:41:50','2022-03-03 11:54:03');
INSERT INTO sections VALUES('16','1','116','','1','','1','','2','2021-12-04 17:42:11','2022-04-17 05:38:38');
INSERT INTO sections VALUES('17','1','117','','3','','1','','2','2021-12-04 17:42:46','2022-06-04 05:24:53');
INSERT INTO sections VALUES('18','1','119','118','1','','1','','1','2022-04-17 05:39:40','2022-06-28 08:52:46');
INSERT INTO sections VALUES('20','1','118','118','2','','1','','1','2022-07-14 10:41:22','2022-07-14 10:41:22');
INSERT INTO sections VALUES('21','1','120','120','2','','1','','3','2022-09-03 18:52:45','2022-09-03 18:53:50');
INSERT INTO sections VALUES('22','1','121','121','2','','1','','4','2022-11-15 17:44:44','2023-08-09 13:32:50');
INSERT INTO sections VALUES('23','1','122','122','1','','1','','2','2023-03-07 12:43:10','2023-03-07 12:43:10');
INSERT INTO sections VALUES('24','1','109 Ground','109','3','','1','','4','2023-06-14 15:34:06','2023-06-14 15:34:06');



DROP TABLE IF EXISTS settings;

CREATE TABLE `settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `academic_year` int(11) DEFAULT NULL,
  `timezone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_symbol` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backend_direction` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active_theme` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `disabled_website` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright_text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `school_name` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `package_id` int(11) DEFAULT NULL,
  `site_title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(70) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `home_page` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sidebar_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sidebar_text_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sidebar_border_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active_sidebar_background` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_backend_css` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `mail_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_host` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_port` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_username` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_password` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_encryption` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_footer` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TWILIO_SID` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TWILIO_TOKEN` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TWILIO_MOBILE` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_active` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_currency` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paypal_email` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_active` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_currency` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_secret_key` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_publishable_key` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO settings VALUES('1','academic_year','1','Asia/Karachi','Rs.','1556705924_1.png','ltr','default','','','The Ambassador-50 Boys Hostel','2021-10-24','5','The Ambassador-50 Boys Hostel','03170000352','saqiprince14@gmail.com','English','House #23, St #22, F-82, Islamabad','','#ffffff','#000000','#dddddd','#e78421','','1','smtp','saqiprince14@gmail.com','Ambassador Boys Hostel','Saqib','465','Saqib','123456','tls','Best Regards','','','','No','USD','test@gmail.com','No','USD','','','','2023-07-22 07:24:35');



DROP TABLE IF EXISTS site_navigation_items;

CREATE TABLE `site_navigation_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `navigation_id` int(11) NOT NULL,
  `menu_label` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_id` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `menu_order` int(11) NOT NULL DEFAULT 100,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS site_navigations;

CREATE TABLE `site_navigations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS sms_logs;

CREATE TABLE `sms_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `receiver` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sender_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS staff_attendances;

CREATE TABLE `staff_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `attendance` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO staff_attendances VALUES('1','1','641','2022-02-22','1','2022-02-22 15:25:55','2022-02-22 15:25:55');
INSERT INTO staff_attendances VALUES('2','1','319','2022-02-22','0','2022-02-22 15:25:55','2022-02-22 15:25:55');



DROP TABLE IF EXISTS student_attendances;

CREATE TABLE `student_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `attendance` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS student_fee_assigns;

CREATE TABLE `student_fee_assigns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `fee_id` int(11) NOT NULL,
  `amount` double(8,2) NOT NULL DEFAULT 0.00,
  `discount` double(8,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=338 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO student_fee_assigns VALUES('4','1','2','1','17500','0','2021-12-04 17:29:18','2021-12-04 17:29:18');
INSERT INTO student_fee_assigns VALUES('6','1','1','1','17000','0','2021-12-04 17:33:56','2021-12-04 17:33:56');
INSERT INTO student_fee_assigns VALUES('307','1','3','1','24500','0','2023-05-11 10:47:09','2023-05-11 10:47:09');
INSERT INTO student_fee_assigns VALUES('40','1','4','1','17500','0','2021-12-05 19:10:02','2021-12-05 19:10:02');
INSERT INTO student_fee_assigns VALUES('10','1','5','1','22500','0','2021-12-04 17:51:45','2021-12-04 17:51:45');
INSERT INTO student_fee_assigns VALUES('11','1','6','1','50000','0','2021-12-04 18:05:01','2021-12-04 18:05:01');
INSERT INTO student_fee_assigns VALUES('298','1','7','1','21000','0','2023-04-09 11:11:32','2023-04-09 11:11:32');
INSERT INTO student_fee_assigns VALUES('33','1','8','1','18500','0','2021-12-05 13:30:01','2021-12-05 13:30:01');
INSERT INTO student_fee_assigns VALUES('105','1','9','1','18000','0','2022-04-01 16:04:46','2022-04-01 16:04:46');
INSERT INTO student_fee_assigns VALUES('15','1','10','1','18000','0','2021-12-04 19:36:50','2021-12-04 19:36:50');
INSERT INTO student_fee_assigns VALUES('16','1','11','1','17000','0','2021-12-04 19:41:41','2021-12-04 19:41:41');
INSERT INTO student_fee_assigns VALUES('17','1','12','1','17000','0','2021-12-04 19:49:14','2021-12-04 19:49:14');
INSERT INTO student_fee_assigns VALUES('18','1','13','1','18500','0','2021-12-04 20:38:26','2021-12-04 20:38:26');
INSERT INTO student_fee_assigns VALUES('19','1','14','1','19000','0','2021-12-05 11:29:59','2021-12-05 11:29:59');
INSERT INTO student_fee_assigns VALUES('279','1','15','1','15000','0','2022-12-22 05:30:00','2022-12-22 05:30:00');
INSERT INTO student_fee_assigns VALUES('21','1','16','1','15000','0','2021-12-05 11:41:52','2021-12-05 11:41:52');
INSERT INTO student_fee_assigns VALUES('278','1','17','1','15000','0','2022-12-21 09:33:26','2022-12-21 09:33:26');
INSERT INTO student_fee_assigns VALUES('277','1','18','1','15000','0','2022-12-21 09:28:33','2022-12-21 09:28:33');
INSERT INTO student_fee_assigns VALUES('24','1','19','1','18000','0','2021-12-05 11:54:17','2021-12-05 11:54:17');
INSERT INTO student_fee_assigns VALUES('67','1','20','1','18500','0','2022-01-06 12:03:19','2022-01-06 12:03:19');
INSERT INTO student_fee_assigns VALUES('225','1','21','1','19500','0','2022-09-03 18:09:12','2022-09-03 18:09:12');
INSERT INTO student_fee_assigns VALUES('27','1','22','1','17000','0','2021-12-05 12:15:43','2021-12-05 12:15:43');
INSERT INTO student_fee_assigns VALUES('28','1','23','1','17000','0','2021-12-05 12:35:10','2021-12-05 12:35:10');
INSERT INTO student_fee_assigns VALUES('42','1','24','1','17000','0','2021-12-07 11:19:05','2021-12-07 11:19:05');
INSERT INTO student_fee_assigns VALUES('233','1','25','1','19000','0','2022-09-03 18:17:23','2022-09-03 18:17:23');
INSERT INTO student_fee_assigns VALUES('92','1','26','1','17000','0','2022-03-03 14:04:33','2022-03-03 14:04:33');
INSERT INTO student_fee_assigns VALUES('32','1','27','1','17000','0','2021-12-05 12:59:17','2021-12-05 12:59:17');
INSERT INTO student_fee_assigns VALUES('76','1','29','1','17500','0','2022-02-02 12:32:36','2022-02-02 12:32:36');
INSERT INTO student_fee_assigns VALUES('57','1','30','1','17000','0','2021-12-31 12:39:20','2021-12-31 12:39:20');
INSERT INTO student_fee_assigns VALUES('56','1','31','1','17000','0','2021-12-31 12:38:49','2021-12-31 12:38:49');
INSERT INTO student_fee_assigns VALUES('55','1','32','1','17000','0','2021-12-31 12:38:20','2021-12-31 12:38:20');
INSERT INTO student_fee_assigns VALUES('44','1','33','1','17500','0','2021-12-07 12:12:10','2021-12-07 12:12:10');
INSERT INTO student_fee_assigns VALUES('45','1','34','1','17500','0','2021-12-07 18:29:53','2021-12-07 18:29:53');
INSERT INTO student_fee_assigns VALUES('271','1','35','1','15000','0','2022-11-09 09:04:22','2022-11-09 09:04:22');
INSERT INTO student_fee_assigns VALUES('47','1','36','1','22000','0','2021-12-08 18:14:05','2021-12-08 18:14:05');
INSERT INTO student_fee_assigns VALUES('48','1','37','1','22000','0','2021-12-09 10:38:53','2021-12-09 10:38:53');
INSERT INTO student_fee_assigns VALUES('66','1','38','1','17000','0','2022-01-06 10:40:07','2022-01-06 10:40:07');
INSERT INTO student_fee_assigns VALUES('50','1','39','1','18000','0','2021-12-17 20:40:39','2021-12-17 20:40:39');
INSERT INTO student_fee_assigns VALUES('207','1','40','1','19000','0','2022-09-03 17:49:59','2022-09-03 17:49:59');
INSERT INTO student_fee_assigns VALUES('54','1','41','1','17000','0','2021-12-31 12:31:51','2021-12-31 12:31:51');
INSERT INTO student_fee_assigns VALUES('254','1','42','1','21000','0','2022-09-07 09:09:29','2022-09-07 09:09:29');
INSERT INTO student_fee_assigns VALUES('204','1','43','1','19000','0','2022-09-03 17:46:25','2022-09-03 17:46:25');
INSERT INTO student_fee_assigns VALUES('236','1','44','1','19000','0','2022-09-03 18:19:43','2022-09-03 18:19:43');
INSERT INTO student_fee_assigns VALUES('123','1','45','1','18500','0','2022-04-07 08:21:54','2022-04-07 08:21:54');
INSERT INTO student_fee_assigns VALUES('253','1','46','1','21000','0','2022-09-07 09:05:30','2022-09-07 09:05:30');
INSERT INTO student_fee_assigns VALUES('68','1','48','1','20000','0','2022-01-19 14:39:32','2022-01-19 14:39:32');
INSERT INTO student_fee_assigns VALUES('69','1','47','1','17500','0','2022-01-19 14:40:52','2022-01-19 14:40:52');
INSERT INTO student_fee_assigns VALUES('224','1','50','1','19500','0','2022-09-03 18:08:36','2022-09-03 18:08:36');
INSERT INTO student_fee_assigns VALUES('232','1','49','1','19000','0','2022-09-03 18:16:48','2022-09-03 18:16:48');
INSERT INTO student_fee_assigns VALUES('74','1','52','1','18000','0','2022-01-31 20:25:32','2022-01-31 20:25:32');
INSERT INTO student_fee_assigns VALUES('77','1','53','1','17500','0','2022-02-02 12:43:33','2022-02-02 12:43:33');
INSERT INTO student_fee_assigns VALUES('80','1','54','1','17500','0','2022-02-06 10:05:33','2022-02-06 10:05:33');
INSERT INTO student_fee_assigns VALUES('83','1','55','1','12000','0','2022-02-20 13:11:53','2022-02-20 13:11:53');
INSERT INTO student_fee_assigns VALUES('84','1','57','1','18500','0','2022-02-20 19:30:41','2022-02-20 19:30:41');
INSERT INTO student_fee_assigns VALUES('124','1','59','1','16500','0','2022-04-08 09:20:57','2022-04-08 09:20:57');
INSERT INTO student_fee_assigns VALUES('208','1','58','1','19000','0','2022-09-03 17:50:55','2022-09-03 17:50:55');
INSERT INTO student_fee_assigns VALUES('97','1','56','1','17500','0','2022-03-12 13:04:24','2022-03-12 13:04:24');
INSERT INTO student_fee_assigns VALUES('222','1','51','1','19500','0','2022-09-03 18:06:32','2022-09-03 18:06:32');
INSERT INTO student_fee_assigns VALUES('91','1','61','1','17500','0','2022-03-03 12:14:08','2022-03-03 12:14:08');
INSERT INTO student_fee_assigns VALUES('111','1','62','1','17000','0','2022-04-05 14:49:38','2022-04-05 14:49:38');
INSERT INTO student_fee_assigns VALUES('196','1','66','1','20000','0','2022-09-03 17:34:44','2022-09-03 17:34:44');
INSERT INTO student_fee_assigns VALUES('154','1','60','1','16500','0','2022-06-06 13:35:54','2022-06-06 13:35:54');
INSERT INTO student_fee_assigns VALUES('223','1','63','1','19500','0','2022-09-03 18:07:54','2022-09-03 18:07:54');
INSERT INTO student_fee_assigns VALUES('103','1','64','1','16000','0','2022-04-01 16:02:16','2022-04-01 16:02:16');
INSERT INTO student_fee_assigns VALUES('195','1','65','1','20000','0','2022-09-03 05:59:03','2022-09-03 05:59:03');
INSERT INTO student_fee_assigns VALUES('210','1','67','1','21500','0','2022-09-03 17:53:59','2022-09-03 17:53:59');
INSERT INTO student_fee_assigns VALUES('209','1','68','1','21500','0','2022-09-03 17:53:22','2022-09-03 17:53:22');
INSERT INTO student_fee_assigns VALUES('264','1','69','1','21500','0','2022-10-05 07:47:44','2022-10-05 07:47:44');
INSERT INTO student_fee_assigns VALUES('127','1','70','1','18500','0','2022-04-08 10:39:35','2022-04-08 10:39:35');
INSERT INTO student_fee_assigns VALUES('155','1','71','1','6000','0','2022-06-09 13:57:05','2022-06-09 13:57:05');
INSERT INTO student_fee_assigns VALUES('270','1','72','1','26000','0','2022-11-08 10:02:59','2022-11-08 10:02:59');
INSERT INTO student_fee_assigns VALUES('213','1','73','1','19000','0','2022-09-03 17:57:24','2022-09-03 17:57:24');
INSERT INTO student_fee_assigns VALUES('212','1','74','1','19000','0','2022-09-03 17:56:42','2022-09-03 17:56:42');
INSERT INTO student_fee_assigns VALUES('214','1','75','1','19000','0','2022-09-03 17:58:03','2022-09-03 17:58:03');
INSERT INTO student_fee_assigns VALUES('137','1','76','1','17500','0','2022-05-11 12:11:39','2022-05-11 12:11:39');
INSERT INTO student_fee_assigns VALUES('211','1','77','1','19000','0','2022-09-03 17:55:30','2022-09-03 17:55:30');
INSERT INTO student_fee_assigns VALUES('139','1','79','1','20000','0','2022-05-22 13:08:26','2022-05-22 13:08:26');
INSERT INTO student_fee_assigns VALUES('140','1','80','1','20000','0','2022-05-23 08:11:00','2022-05-23 08:11:00');
INSERT INTO student_fee_assigns VALUES('266','1','81','1','18500','0','2022-11-02 16:48:58','2022-11-02 16:48:58');
INSERT INTO student_fee_assigns VALUES('142','1','82','1','20000','0','2022-06-02 10:34:53','2022-06-02 10:34:53');
INSERT INTO student_fee_assigns VALUES('249','1','83','1','21500','0','2022-09-03 18:35:16','2022-09-03 18:35:16');
INSERT INTO student_fee_assigns VALUES('145','1','84','1','20000','0','2022-06-04 05:20:57','2022-06-04 05:20:57');
INSERT INTO student_fee_assigns VALUES('314','1','85','1','25000','0','2023-06-14 15:37:35','2023-06-14 15:37:35');
INSERT INTO student_fee_assigns VALUES('205','1','86','1','19000','0','2022-09-03 17:47:31','2022-09-03 17:47:31');
INSERT INTO student_fee_assigns VALUES('280','1','87','1','15000','0','2022-12-22 05:30:33','2022-12-22 05:30:33');
INSERT INTO student_fee_assigns VALUES('151','1','88','1','22000','0','2022-06-05 14:21:41','2022-06-05 14:21:41');
INSERT INTO student_fee_assigns VALUES('174','1','89','1','17500','0','2022-07-21 08:45:24','2022-07-21 08:45:24');
INSERT INTO student_fee_assigns VALUES('153','1','90','1','22000','0','2022-06-05 14:46:54','2022-06-05 14:46:54');
INSERT INTO student_fee_assigns VALUES('248','1','91','1','21500','0','2022-09-03 18:34:38','2022-09-03 18:34:38');
INSERT INTO student_fee_assigns VALUES('296','1','92','1','19000','0','2023-04-07 12:05:01','2023-04-07 12:05:01');
INSERT INTO student_fee_assigns VALUES('159','1','93','1','18000','0','2022-07-03 07:49:40','2022-07-03 07:49:40');
INSERT INTO student_fee_assigns VALUES('234','1','94','1','19000','0','2022-09-03 18:18:00','2022-09-03 18:18:00');
INSERT INTO student_fee_assigns VALUES('262','1','95','1','23000','0','2022-10-05 07:36:28','2022-10-05 07:36:28');
INSERT INTO student_fee_assigns VALUES('263','1','96','1','23000','0','2022-10-05 07:36:59','2022-10-05 07:36:59');
INSERT INTO student_fee_assigns VALUES('316','1','97','1','19500','0','2023-07-08 15:54:57','2023-07-08 15:54:57');
INSERT INTO student_fee_assigns VALUES('329','1','98','1','25000','1000','2023-08-03 05:55:34','2023-08-03 05:55:34');
INSERT INTO student_fee_assigns VALUES('245','1','99','1','21500','0','2022-09-03 18:32:00','2022-09-03 18:32:00');
INSERT INTO student_fee_assigns VALUES('246','1','100','1','21500','0','2022-09-03 18:32:43','2022-09-03 18:32:43');
INSERT INTO student_fee_assigns VALUES('226','1','101','1','19000','0','2022-09-03 18:11:48','2022-09-03 18:11:48');
INSERT INTO student_fee_assigns VALUES('203','1','102','1','19000','0','2022-09-03 17:44:46','2022-09-03 17:44:46');
INSERT INTO student_fee_assigns VALUES('200','1','103','1','19000','0','2022-09-03 17:38:17','2022-09-03 17:38:17');
INSERT INTO student_fee_assigns VALUES('283','1','104','1','18500','0','2022-12-28 16:27:04','2022-12-28 16:27:04');
INSERT INTO student_fee_assigns VALUES('235','1','105','1','19000','0','2022-09-03 18:19:06','2022-09-03 18:19:06');
INSERT INTO student_fee_assigns VALUES('237','1','106','1','19000','0','2022-09-03 18:20:33','2022-09-03 18:20:33');
INSERT INTO student_fee_assigns VALUES('202','1','107','1','19000','0','2022-09-03 17:41:14','2022-09-03 17:41:14');
INSERT INTO student_fee_assigns VALUES('180','1','108','1','17500','0','2022-07-24 08:40:43','2022-07-24 08:40:43');
INSERT INTO student_fee_assigns VALUES('197','1','109','1','20000','0','2022-09-03 17:35:32','2022-09-03 17:35:32');
INSERT INTO student_fee_assigns VALUES('199','1','110','1','19000','0','2022-09-03 17:37:25','2022-09-03 17:37:25');
INSERT INTO student_fee_assigns VALUES('231','1','111','1','19000','0','2022-09-03 18:15:47','2022-09-03 18:15:47');
INSERT INTO student_fee_assigns VALUES('191','1','112','1','10000','0','2022-09-02 10:26:58','2022-09-02 10:26:58');
INSERT INTO student_fee_assigns VALUES('250','1','113','1','21500','0','2022-09-05 21:00:00','2022-09-05 21:00:00');
INSERT INTO student_fee_assigns VALUES('294','1','114','1','20000','0','2023-04-04 17:59:37','2023-04-04 17:59:37');
INSERT INTO student_fee_assigns VALUES('252','1','115','1','20000','0','2022-09-05 21:26:01','2022-09-05 21:26:01');
INSERT INTO student_fee_assigns VALUES('261','1','116','1','15000','0','2022-10-05 07:02:37','2022-10-05 07:02:37');
INSERT INTO student_fee_assigns VALUES('295','1','117','1','12000','0','2023-04-06 10:04:26','2023-04-06 10:04:26');
INSERT INTO student_fee_assigns VALUES('260','1','118','1','15000','0','2022-10-05 06:40:48','2022-10-05 06:40:48');
INSERT INTO student_fee_assigns VALUES('267','1','119','1','19000','0','2022-11-03 06:26:38','2022-11-03 06:26:38');
INSERT INTO student_fee_assigns VALUES('269','1','120','1','21500','0','2022-11-06 14:50:38','2022-11-06 14:50:38');
INSERT INTO student_fee_assigns VALUES('272','1','121','1','15000','0','2022-11-16 16:49:35','2022-11-16 16:49:35');
INSERT INTO student_fee_assigns VALUES('273','1','122','1','21500','0','2022-11-16 17:02:12','2022-11-16 17:02:12');
INSERT INTO student_fee_assigns VALUES('274','1','123','1','20000','0','2022-11-16 17:24:21','2022-11-16 17:24:21');
INSERT INTO student_fee_assigns VALUES('306','1','124','1','20000','0','2023-05-11 10:05:37','2023-05-11 10:05:37');
INSERT INTO student_fee_assigns VALUES('288','1','125','1','18000','0','2023-02-09 10:42:34','2023-02-09 10:42:34');
INSERT INTO student_fee_assigns VALUES('282','1','126','1','21500','0','2022-12-22 05:40:56','2022-12-22 05:40:56');
INSERT INTO student_fee_assigns VALUES('305','1','128','1','20000','0','2023-05-11 10:04:57','2023-05-11 10:04:57');
INSERT INTO student_fee_assigns VALUES('286','1','127','1','19000','0','2023-01-06 10:44:23','2023-01-06 10:44:23');
INSERT INTO student_fee_assigns VALUES('332','1','129','1','21500','0','2023-08-03 14:38:54','2023-08-03 14:38:54');
INSERT INTO student_fee_assigns VALUES('292','1','130','1','21500','0','2023-03-07 13:01:25','2023-03-07 13:01:25');
INSERT INTO student_fee_assigns VALUES('297','1','131','1','21500','0','2023-04-07 15:16:55','2023-04-07 15:16:55');
INSERT INTO student_fee_assigns VALUES('301','1','132','1','21000','0','2023-04-09 11:34:47','2023-04-09 11:34:47');
INSERT INTO student_fee_assigns VALUES('324','1','133','1','20000','0','2023-08-02 08:10:35','2023-08-02 08:10:35');
INSERT INTO student_fee_assigns VALUES('303','1','134','1','20000','0','2023-05-11 09:07:23','2023-05-11 09:07:23');
INSERT INTO student_fee_assigns VALUES('312','1','135','1','20000','0','2023-06-05 09:06:17','2023-06-05 09:06:17');
INSERT INTO student_fee_assigns VALUES('310','1','136','1','19000','0','2023-06-01 16:09:43','2023-06-01 16:09:43');
INSERT INTO student_fee_assigns VALUES('311','1','137','1','20000','0','2023-06-01 16:33:26','2023-06-01 16:33:26');
INSERT INTO student_fee_assigns VALUES('317','1','138','1','19000','0','2023-07-09 08:12:56','2023-07-09 08:12:56');
INSERT INTO student_fee_assigns VALUES('330','1','139','1','25000','2000','2023-08-03 05:58:39','2023-08-03 05:58:39');
INSERT INTO student_fee_assigns VALUES('321','1','140','1','25000','0','2023-07-26 14:31:55','2023-07-26 14:31:55');
INSERT INTO student_fee_assigns VALUES('323','1','141','1','20000','0','2023-07-28 15:42:32','2023-07-28 15:42:32');
INSERT INTO student_fee_assigns VALUES('335','1','142','1','22000','0','2023-08-05 06:08:35','2023-08-05 06:08:35');
INSERT INTO student_fee_assigns VALUES('326','1','143','1','22000','0','2023-08-03 05:41:15','2023-08-03 05:41:15');
INSERT INTO student_fee_assigns VALUES('328','1','144','1','25000','0','2023-08-03 05:51:35','2023-08-03 05:51:35');
INSERT INTO student_fee_assigns VALUES('334','1','145','1','20000','0','2023-08-04 17:41:00','2023-08-04 17:41:00');
INSERT INTO student_fee_assigns VALUES('337','1','146','1','30000','0','2023-08-05 11:21:48','2023-08-05 11:21:48');



DROP TABLE IF EXISTS student_groups;

CREATE TABLE `student_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `group_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO student_groups VALUES('1','1','JOBIAN','2021-06-17 02:03:45','2021-06-17 02:03:45');
INSERT INTO student_groups VALUES('2','1','STUDENT','2021-06-17 02:04:04','2021-06-17 02:04:04');
INSERT INTO student_groups VALUES('3','1','DEFAULT','2021-06-17 02:04:21','2021-08-04 18:44:32');



DROP TABLE IF EXISTS student_payments;

CREATE TABLE `student_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1351 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO student_payments VALUES('29','1','15','2021-11-05','18500.00','','2021-12-05 18:11:18','2021-12-05 18:11:18');
INSERT INTO student_payments VALUES('2','1','1','2021-09-16','20000.00','','2021-10-05 13:30:28','2021-10-05 13:30:28');
INSERT INTO student_payments VALUES('3','1','11','2021-11-03','18000.00','','2021-12-05 13:20:16','2021-12-05 13:20:16');
INSERT INTO student_payments VALUES('4','1','24','2021-11-03','17000.00','','2021-12-05 13:23:18','2021-12-05 13:23:18');
INSERT INTO student_payments VALUES('5','1','28','2021-11-04','18000.00','','2021-12-05 13:25:09','2021-12-05 13:25:09');
INSERT INTO student_payments VALUES('6','1','29','2021-11-02','17000.00','','2021-12-05 13:25:51','2021-12-05 13:25:51');
INSERT INTO student_payments VALUES('7','1','25','2021-11-02','17000.00','','2021-12-05 13:26:31','2021-12-05 13:26:31');
INSERT INTO student_payments VALUES('8','1','3','2021-11-01','17000.00','','2021-12-05 13:27:00','2021-12-05 13:27:00');
INSERT INTO student_payments VALUES('9','1','10','2021-11-10','18500.00','','2021-12-05 13:30:59','2021-12-05 13:30:59');
INSERT INTO student_payments VALUES('10','1','21','2021-11-09','18000.00','','2021-12-05 13:32:07','2021-12-05 13:32:07');
INSERT INTO student_payments VALUES('11','1','5','2021-11-09','22000.00','','2021-12-05 13:34:14','2021-12-05 13:34:14');
INSERT INTO student_payments VALUES('12','1','6','2021-11-15','11000.00','','2021-12-05 13:51:47','2021-12-05 13:51:47');
INSERT INTO student_payments VALUES('13','1','22','2021-11-13','10000.00','','2021-12-05 13:54:15','2021-12-05 13:54:15');
INSERT INTO student_payments VALUES('14','1','16','2021-11-14','38000.00','','2021-12-05 13:55:19','2021-12-05 13:55:19');
INSERT INTO student_payments VALUES('15','1','19','2021-11-16','18500.00','','2021-12-05 14:01:48','2021-12-05 14:01:48');
INSERT INTO student_payments VALUES('16','1','20','2021-11-16','18500.00','','2021-12-05 14:03:05','2021-12-05 14:03:05');
INSERT INTO student_payments VALUES('17','1','18','2021-11-16','18500.00','','2021-12-05 14:03:33','2021-12-05 14:03:33');
INSERT INTO student_payments VALUES('18','1','17','2021-11-16','18500.00','','2021-12-05 14:04:01','2021-12-05 14:04:01');
INSERT INTO student_payments VALUES('19','1','4','2021-11-21','23330.00','','2021-12-05 14:08:33','2021-12-05 14:08:33');
INSERT INTO student_payments VALUES('20','1','9','2021-11-21','24666.00','','2021-12-05 14:12:08','2021-12-05 14:12:08');
INSERT INTO student_payments VALUES('21','1','27','2021-11-01','34000.00','','2021-12-05 14:24:42','2021-12-05 14:24:42');
INSERT INTO student_payments VALUES('22','1','12','2021-11-09','18000.00','','2021-12-05 14:25:55','2021-12-05 14:25:55');
INSERT INTO student_payments VALUES('23','1','14','2021-11-01','17000.00','','2021-12-05 14:28:09','2021-12-05 14:28:09');
INSERT INTO student_payments VALUES('24','1','23','2021-11-11','27750.00','','2021-12-05 14:32:36','2021-12-05 14:32:36');
INSERT INTO student_payments VALUES('25','1','13','2021-11-22','10000.00','BOOKING','2021-12-05 16:26:44','2021-12-05 16:26:44');
INSERT INTO student_payments VALUES('26','1','30','2021-11-03','18000.00','','2021-12-05 16:50:57','2021-12-05 16:50:57');
INSERT INTO student_payments VALUES('28','1','26','2021-11-05','18000.00','','2021-12-05 17:53:56','2021-12-05 17:53:56');
INSERT INTO student_payments VALUES('30','1','54','2021-12-04','17000.00','','2021-12-07 10:53:26','2021-12-07 10:53:26');
INSERT INTO student_payments VALUES('31','1','58','2021-12-02','24998.00','','2021-12-07 10:57:47','2021-12-07 10:57:47');
INSERT INTO student_payments VALUES('32','1','58','2021-12-02','2.00','','2021-12-07 10:59:20','2021-12-07 10:59:20');
INSERT INTO student_payments VALUES('33','1','60','2021-12-03','17000.00','','2021-12-07 11:03:41','2021-12-07 11:03:41');
INSERT INTO student_payments VALUES('34','1','59','2021-12-03','17000.00','','2021-12-07 11:05:09','2021-12-07 11:05:09');
INSERT INTO student_payments VALUES('35','1','36','2021-12-04','18500.00','','2021-12-07 11:06:15','2021-12-07 11:06:15');
INSERT INTO student_payments VALUES('36','1','46','2021-12-04','15000.00','','2021-12-07 11:06:39','2021-12-07 11:06:39');
INSERT INTO student_payments VALUES('37','1','42','2021-12-01','18500.00','','2021-12-07 11:07:33','2021-12-07 11:07:33');
INSERT INTO student_payments VALUES('38','1','55','2021-12-06','17000.00','','2021-12-07 11:14:10','2021-12-07 11:14:10');
INSERT INTO student_payments VALUES('39','1','32','2021-12-06','17500.00','','2021-12-07 11:16:34','2021-12-07 11:16:34');
INSERT INTO student_payments VALUES('40','1','53','2021-12-06','17000.00','','2021-12-07 11:18:26','2021-12-07 11:18:26');
INSERT INTO student_payments VALUES('41','1','51','2021-12-06','17000.00','','2021-12-07 11:20:52','2021-12-07 11:20:52');
INSERT INTO student_payments VALUES('42','1','52','2021-12-06','17000.00','','2021-12-07 11:21:20','2021-12-07 11:21:20');
INSERT INTO student_payments VALUES('43','1','40','2021-12-06','17000.00','','2021-12-07 11:22:16','2021-12-07 11:22:16');
INSERT INTO student_payments VALUES('44','1','61','2021-12-06','26000.00','','2021-12-07 11:45:50','2021-12-07 11:45:50');
INSERT INTO student_payments VALUES('45','1','62','2021-12-06','17500.00','','2021-12-07 12:16:11','2021-12-07 12:16:11');
INSERT INTO student_payments VALUES('46','1','59','2021-12-07','-17000.00','','2021-12-07 20:20:28','2021-12-07 20:20:28');
INSERT INTO student_payments VALUES('47','1','60','2021-12-07','-17000.00','','2021-12-07 20:21:43','2021-12-07 20:21:43');
INSERT INTO student_payments VALUES('48','1','59','2021-12-07','17000.00','','2021-12-07 20:25:20','2021-12-07 20:25:20');
INSERT INTO student_payments VALUES('49','1','60','2021-12-07','17000.00','','2021-12-07 20:25:43','2021-12-07 20:25:43');
INSERT INTO student_payments VALUES('50','1','59','2021-12-07','8000.00','','2021-12-07 21:02:13','2021-12-07 21:02:13');
INSERT INTO student_payments VALUES('51','1','60','2021-12-07','8000.00','','2021-12-07 21:02:39','2021-12-07 21:02:39');
INSERT INTO student_payments VALUES('52','1','63','2021-12-07','20000.00','ZEESHAN','2021-12-07 21:04:02','2021-12-07 21:04:02');
INSERT INTO student_payments VALUES('53','1','63','2021-12-07','10000.00','','2021-12-07 21:04:21','2021-12-07 21:04:21');
INSERT INTO student_payments VALUES('54','1','57','2021-12-06','19000.00','','2021-12-07 21:26:38','2021-12-07 21:26:38');
INSERT INTO student_payments VALUES('55','1','49','2021-12-08','18500.00','','2021-12-08 17:43:13','2021-12-08 17:43:13');
INSERT INTO student_payments VALUES('56','1','37','2021-12-08','18500.00','BANK ISLAMI','2021-12-08 18:39:33','2021-12-08 18:39:33');
INSERT INTO student_payments VALUES('57','1','34','2021-12-06','17500.00','','2021-12-08 18:40:58','2021-12-08 18:40:58');
INSERT INTO student_payments VALUES('58','1','53','2021-12-07','17000.00','','2021-12-08 18:42:05','2021-12-08 18:42:05');
INSERT INTO student_payments VALUES('59','1','55','2021-12-07','17000.00','','2021-12-08 18:42:51','2021-12-08 18:42:51');
INSERT INTO student_payments VALUES('60','1','51','2021-12-06','17000.00','','2021-12-08 18:44:14','2021-12-08 18:44:14');
INSERT INTO student_payments VALUES('61','1','52','2021-12-05','17000.00','','2021-12-08 18:44:56','2021-12-08 18:44:56');
INSERT INTO student_payments VALUES('62','1','38','2021-12-07','18000.00','','2021-12-08 18:47:51','2021-12-08 18:47:51');
INSERT INTO student_payments VALUES('63','1','50','2021-12-08','18500.00','BANK ISLAMI','2021-12-08 19:06:57','2021-12-08 19:06:57');
INSERT INTO student_payments VALUES('64','1','48','2021-12-08','18000.00','BANK ISLAMI','2021-12-08 19:11:50','2021-12-08 19:11:50');
INSERT INTO student_payments VALUES('65','1','44','2021-12-09','15000.00','BANK ISLAMI','2021-12-09 11:20:49','2021-12-09 11:20:49');
INSERT INTO student_payments VALUES('66','1','68','2021-12-13','15000.00','','2021-12-17 20:50:44','2021-12-17 20:50:44');
INSERT INTO student_payments VALUES('67','1','69','2021-12-10','17000.00','JAVAID SB','2021-12-17 21:48:49','2021-12-17 21:48:49');
INSERT INTO student_payments VALUES('68','1','67','2021-12-10','27000.00','','2021-12-17 21:50:41','2021-12-17 21:50:41');
INSERT INTO student_payments VALUES('69','1','31','2021-12-10','17000.00','','2021-12-17 21:52:27','2021-12-17 21:52:27');
INSERT INTO student_payments VALUES('70','1','33','2021-12-10','22000.00','','2021-12-17 21:53:25','2021-12-17 21:53:25');
INSERT INTO student_payments VALUES('71','1','39','2021-12-10','18000.00','','2021-12-17 21:53:51','2021-12-17 21:53:51');
INSERT INTO student_payments VALUES('72','1','43','2021-12-09','19000.00','','2021-12-17 21:54:31','2021-12-17 21:54:31');
INSERT INTO student_payments VALUES('73','1','57','2021-12-10','10000.00','','2021-12-17 21:55:11','2021-12-17 21:55:11');
INSERT INTO student_payments VALUES('74','1','45','2021-12-10','15000.00','','2021-12-17 21:55:41','2021-12-17 21:55:41');
INSERT INTO student_payments VALUES('75','1','47','2021-12-10','15000.00','','2021-12-17 21:56:06','2021-12-17 21:56:06');
INSERT INTO student_payments VALUES('76','1','64','2021-12-10','15000.00','','2021-12-17 22:01:44','2021-12-17 22:01:44');
INSERT INTO student_payments VALUES('77','1','56','2021-12-10','17000.00','','2021-12-17 22:15:56','2021-12-17 22:15:56');
INSERT INTO student_payments VALUES('78','1','66','2021-12-10','29500.00','','2021-12-17 22:21:53','2021-12-17 22:21:53');
INSERT INTO student_payments VALUES('79','1','65','2021-12-10','29500.00','','2021-12-17 22:22:09','2021-12-17 22:22:09');
INSERT INTO student_payments VALUES('80','1','35','2021-12-22','50000.00','','2021-12-23 13:58:21','2021-12-23 13:58:21');
INSERT INTO student_payments VALUES('81','1','8','2021-12-22','50000.00','','2021-12-23 14:03:23','2021-12-23 14:03:23');
INSERT INTO student_payments VALUES('82','1','107','2022-01-01','34000.00','','2022-01-02 16:58:23','2022-01-02 16:58:23');
INSERT INTO student_payments VALUES('83','1','151','2021-12-12','24500.00','','2022-01-02 21:34:55','2022-01-02 21:34:55');
INSERT INTO student_payments VALUES('84','1','149','2021-12-30','28000.00','M/O JAN 2022','2022-01-03 12:44:33','2022-01-03 12:44:33');
INSERT INTO student_payments VALUES('85','1','146','2021-12-30','20000.00','M/O JAN 2022','2022-01-03 12:48:03','2022-01-03 12:48:03');
INSERT INTO student_payments VALUES('86','1','115','2022-01-01','18500.00','M/O JAN2022','2022-01-03 12:52:50','2022-01-03 12:52:50');
INSERT INTO student_payments VALUES('87','1','120','2022-01-02','18500.00','','2022-01-03 12:54:55','2022-01-03 12:54:55');
INSERT INTO student_payments VALUES('88','1','150','2022-01-02','22500.00','SEC 5000','2022-01-03 12:57:39','2022-01-03 12:57:39');
INSERT INTO student_payments VALUES('89','1','128','2022-01-02','18500.00','','2022-01-03 12:59:13','2022-01-03 12:59:13');
INSERT INTO student_payments VALUES('90','1','153','2022-01-01','17500.00','','2022-01-03 13:13:50','2022-01-03 13:13:50');
INSERT INTO student_payments VALUES('91','1','133','2022-01-04','17000.00','M/O DECEMBER 2021','2022-01-05 18:58:53','2022-01-05 18:58:53');
INSERT INTO student_payments VALUES('92','1','130','2022-01-04','17000.00','M/O DECEMBER 2021','2022-01-05 19:00:48','2022-01-05 19:00:48');
INSERT INTO student_payments VALUES('93','1','131','2022-01-04','17000.00','M/O DECEMBER 2021','2022-01-05 19:01:23','2022-01-05 19:01:23');
INSERT INTO student_payments VALUES('94','1','144','2022-01-05','17000.00','','2022-01-06 11:14:15','2022-01-06 11:14:15');
INSERT INTO student_payments VALUES('95','1','136','2022-01-05','17000.00','','2022-01-06 11:19:30','2022-01-06 11:19:30');
INSERT INTO student_payments VALUES('96','1','152','2022-01-05','18500.00','','2022-01-06 11:21:12','2022-01-06 11:21:12');
INSERT INTO student_payments VALUES('97','1','111','2022-01-05','17500.00','','2022-01-06 11:23:14','2022-01-06 11:23:14');
INSERT INTO student_payments VALUES('98','1','125','2022-01-05','15000.00','','2022-01-06 11:29:05','2022-01-06 11:29:05');
INSERT INTO student_payments VALUES('99','1','122','2022-01-05','15000.00','','2022-01-06 11:29:59','2022-01-06 11:29:59');
INSERT INTO student_payments VALUES('100','1','132','2022-01-05','17000.00','','2022-01-06 11:32:12','2022-01-06 11:32:12');
INSERT INTO student_payments VALUES('101','1','134','2022-01-05','17000.00','','2022-01-06 12:00:43','2022-01-06 12:00:43');
INSERT INTO student_payments VALUES('102','1','141','2022-01-06','15000.00','','2022-01-06 12:52:21','2022-01-06 12:52:21');
INSERT INTO student_payments VALUES('103','1','113','2022-01-05','17500.00','','2022-01-06 12:56:02','2022-01-06 12:56:02');
INSERT INTO student_payments VALUES('104','1','135','2022-01-05','19000.00','','2022-01-06 12:58:45','2022-01-06 12:58:45');
INSERT INTO student_payments VALUES('105','1','124','2022-01-06','15000.00','','2022-01-06 13:13:00','2022-01-06 13:13:00');
INSERT INTO student_payments VALUES('106','1','112','2022-01-06','22000.00','','2022-01-06 17:35:23','2022-01-06 17:35:23');
INSERT INTO student_payments VALUES('107','1','123','2022-01-06','15000.00','','2022-01-06 17:38:26','2022-01-06 17:38:26');
INSERT INTO student_payments VALUES('108','1','127','2022-01-05','18500.00','','2022-01-06 17:44:06','2022-01-06 17:44:06');
INSERT INTO student_payments VALUES('109','1','139','2022-01-06','17500.00','','2022-01-07 11:34:05','2022-01-07 11:34:05');
INSERT INTO student_payments VALUES('110','1','117','2022-01-06','18000.00','','2022-01-07 11:34:52','2022-01-07 11:34:52');
INSERT INTO student_payments VALUES('111','1','116','2022-01-06','18500.00','','2022-01-07 11:35:38','2022-01-07 11:35:38');
INSERT INTO student_payments VALUES('112','1','126','2022-01-07','18000.00','','2022-01-07 13:45:17','2022-01-07 13:45:17');
INSERT INTO student_payments VALUES('113','1','119','2022-01-07','17000.00','','2022-01-07 18:02:16','2022-01-07 18:02:16');
INSERT INTO student_payments VALUES('114','1','143','2022-01-08','22000.00','','2022-01-08 12:55:41','2022-01-08 12:55:41');
INSERT INTO student_payments VALUES('115','1','129','2022-01-05','17000.00','','2022-01-08 17:50:05','2022-01-08 17:50:05');
INSERT INTO student_payments VALUES('116','1','142','2022-01-08','22000.00','','2022-01-08 17:51:04','2022-01-08 17:51:04');
INSERT INTO student_payments VALUES('117','1','137','2022-01-10','17000.00','','2022-01-10 11:16:20','2022-01-10 11:16:20');
INSERT INTO student_payments VALUES('118','1','138','2022-01-10','17000.00','','2022-01-10 11:17:00','2022-01-10 11:17:00');
INSERT INTO student_payments VALUES('119','1','118','2022-01-10','18000.00','','2022-01-10 11:17:48','2022-01-10 11:17:48');
INSERT INTO student_payments VALUES('120','1','154','2022-01-10','29000.00','20 DAYS PAID','2022-01-10 11:32:53','2022-01-10 11:32:53');
INSERT INTO student_payments VALUES('121','1','155','2022-01-11','20000.00','','2022-01-12 16:26:26','2022-01-12 16:26:26');
INSERT INTO student_payments VALUES('122','1','121','2022-01-15','19000.00','','2022-01-15 15:35:59','2022-01-15 15:35:59');
INSERT INTO student_payments VALUES('123','1','156','2022-01-23','20000.00','','2022-01-23 19:16:32','2022-01-23 19:16:32');
INSERT INTO student_payments VALUES('124','1','157','2022-01-23','19800.00','','2022-01-27 20:30:26','2022-01-27 20:30:26');
INSERT INTO student_payments VALUES('125','1','158','2022-01-23','19800.00','','2022-01-28 20:56:42','2022-01-28 20:56:42');
INSERT INTO student_payments VALUES('126','1','159','2022-01-23','14500.00','','2022-01-31 20:29:47','2022-01-31 20:29:47');
INSERT INTO student_payments VALUES('127','1','198','2022-02-01','32500.00','','2022-02-02 17:50:24','2022-02-02 17:50:24');
INSERT INTO student_payments VALUES('128','1','196','2022-02-02','18000.00','','2022-02-02 17:51:03','2022-02-02 17:51:03');
INSERT INTO student_payments VALUES('129','1','174','2022-02-01','18500.00','','2022-02-02 18:10:10','2022-02-02 18:10:10');
INSERT INTO student_payments VALUES('130','1','176','2022-02-02','17000.00','','2022-02-03 16:00:35','2022-02-03 16:00:35');
INSERT INTO student_payments VALUES('131','1','175','2022-02-02','17000.00','','2022-02-03 16:28:00','2022-02-03 16:28:00');
INSERT INTO student_payments VALUES('132','1','162','2022-02-03','17500.00','','2022-02-03 17:22:48','2022-02-03 17:22:48');
INSERT INTO student_payments VALUES('133','1','165','2022-02-04','18500.00','','2022-02-04 13:00:09','2022-02-04 13:00:09');
INSERT INTO student_payments VALUES('134','1','173','2022-02-04','15000.00','','2022-02-04 13:00:40','2022-02-04 13:00:40');
INSERT INTO student_payments VALUES('135','1','170','2022-02-04','15000.00','','2022-02-04 13:01:25','2022-02-04 13:01:25');
INSERT INTO student_payments VALUES('136','1','178','2022-02-04','17000.00','','2022-02-04 13:02:05','2022-02-04 13:02:05');
INSERT INTO student_payments VALUES('137','1','168','2022-02-04','18500.00','','2022-02-04 13:02:31','2022-02-04 13:02:31');
INSERT INTO student_payments VALUES('138','1','181','2022-02-04','17000.00','','2022-02-04 13:04:02','2022-02-04 13:04:02');
INSERT INTO student_payments VALUES('139','1','179','2022-02-04','17000.00','','2022-02-05 17:47:39','2022-02-05 17:47:39');
INSERT INTO student_payments VALUES('140','1','185','2022-02-05','15000.00','','2022-02-05 17:55:37','2022-02-05 17:55:37');
INSERT INTO student_payments VALUES('141','1','164','2022-02-05','18500.00','','2022-02-05 17:56:08','2022-02-05 17:56:08');
INSERT INTO student_payments VALUES('142','1','59','2022-02-03','9000.00','','2022-02-05 18:02:16','2022-02-05 18:02:16');
INSERT INTO student_payments VALUES('143','1','183','2022-02-03','16000.00','','2022-02-05 18:02:54','2022-02-05 18:02:54');
INSERT INTO student_payments VALUES('144','1','199','2022-01-25','17500.00','','2022-02-05 18:03:26','2022-02-05 18:03:26');
INSERT INTO student_payments VALUES('145','1','199','2022-02-05','17500.00','','2022-02-06 10:14:13','2022-02-06 10:14:13');
INSERT INTO student_payments VALUES('146','1','189','2022-02-04','19000.00','','2022-02-06 10:15:38','2022-02-06 10:15:38');
INSERT INTO student_payments VALUES('147','1','172','2022-02-03','15000.00','','2022-02-06 10:16:42','2022-02-06 10:16:42');
INSERT INTO student_payments VALUES('148','1','57','2021-12-17','9000.00','','2022-02-06 20:19:48','2022-02-06 20:19:48');
INSERT INTO student_payments VALUES('149','1','180','2022-02-03','10000.00','','2022-02-17 16:12:22','2022-02-17 16:12:22');
INSERT INTO student_payments VALUES('150','1','180','2022-02-14','7000.00','','2022-02-17 16:13:31','2022-02-17 16:13:31');
INSERT INTO student_payments VALUES('151','1','200','2022-02-10','19000.00','','2022-02-17 16:25:40','2022-02-17 16:25:40');
INSERT INTO student_payments VALUES('152','1','192','2022-02-10','17500.00','','2022-02-17 16:26:03','2022-02-17 16:26:03');
INSERT INTO student_payments VALUES('153','1','188','2022-02-07','17000.00','','2022-02-17 16:30:03','2022-02-17 16:30:03');
INSERT INTO student_payments VALUES('154','1','190','2022-02-05','19000.00','','2022-02-17 17:50:57','2022-02-17 17:50:57');
INSERT INTO student_payments VALUES('155','1','171','2022-02-08','15000.00','','2022-02-17 17:52:09','2022-02-17 17:52:09');
INSERT INTO student_payments VALUES('156','1','195','2022-02-08','17000.00','','2022-02-17 17:53:37','2022-02-17 17:53:37');
INSERT INTO student_payments VALUES('157','1','177','2022-02-09','17000.00','','2022-02-17 17:54:14','2022-02-17 17:54:14');
INSERT INTO student_payments VALUES('158','1','166','2022-02-09','18000.00','','2022-02-17 17:56:07','2022-02-17 17:56:07');
INSERT INTO student_payments VALUES('159','1','191','2022-02-08','17500.00','','2022-02-17 17:57:18','2022-02-17 17:57:18');
INSERT INTO student_payments VALUES('160','1','186','2022-02-08','22000.00','','2022-02-17 17:57:45','2022-02-17 17:57:45');
INSERT INTO student_payments VALUES('161','1','187','2022-02-08','22000.00','','2022-02-20 11:00:49','2022-02-20 11:00:49');
INSERT INTO student_payments VALUES('191','1','60','2022-03-03','1000.00','','2022-03-05 10:46:59','2022-03-05 10:46:59');
INSERT INTO student_payments VALUES('163','1','60','2022-02-03','8000.00','','2022-02-20 11:14:14','2022-02-20 11:14:14');
INSERT INTO student_payments VALUES('164','1','169','2022-02-10','19000.00','','2022-02-20 11:19:41','2022-02-20 11:19:41');
INSERT INTO student_payments VALUES('165','1','167','2022-02-09','20000.00','','2022-02-20 11:31:43','2022-02-20 11:31:43');
INSERT INTO student_payments VALUES('166','1','193','2022-02-04','21000.00','','2022-02-20 12:26:07','2022-02-20 12:26:07');
INSERT INTO student_payments VALUES('167','1','182','2022-02-05','25000.00','','2022-02-20 12:30:55','2022-02-20 12:30:55');
INSERT INTO student_payments VALUES('168','1','161','2022-02-11','22500.00','','2022-02-20 12:41:03','2022-02-20 12:41:03');
INSERT INTO student_payments VALUES('169','1','201','2022-02-09','22000.00','','2022-02-20 13:19:20','2022-02-20 13:19:20');
INSERT INTO student_payments VALUES('170','1','202','2022-02-14','29170.00','','2022-02-20 13:44:23','2022-02-20 13:44:23');
INSERT INTO student_payments VALUES('171','1','203','2022-02-11','28500.00','','2022-02-20 19:38:45','2022-02-20 19:38:45');
INSERT INTO student_payments VALUES('172','1','204','2022-01-11','17500.00','','2022-02-20 19:53:45','2022-02-20 19:53:45');
INSERT INTO student_payments VALUES('173','1','204','2022-02-11','11700.00','PAY 20 DAYS','2022-02-20 19:56:48','2022-02-20 19:56:48');
INSERT INTO student_payments VALUES('174','1','204','2022-02-05','0.00','','2022-02-20 20:20:43','2022-02-20 20:20:43');
INSERT INTO student_payments VALUES('175','1','205','2022-02-05','18000.00','','2022-02-20 20:33:21','2022-02-20 20:33:21');
INSERT INTO student_payments VALUES('176','1','206','2022-02-22','5500.00','','2022-02-22 14:03:54','2022-02-22 14:03:54');
INSERT INTO student_payments VALUES('177','1','167','2022-02-23','-2000.00','','2022-02-23 18:18:46','2022-02-23 18:18:46');
INSERT INTO student_payments VALUES('178','1','207','2022-02-22','5500.00','','2022-02-23 18:19:01','2022-02-23 18:19:01');
INSERT INTO student_payments VALUES('179','1','208','2022-02-20','8000.00','','2022-02-26 16:46:00','2022-02-26 16:46:00');
INSERT INTO student_payments VALUES('180','1','183','2022-02-03','1000.00','','2022-02-26 16:59:22','2022-02-26 16:59:22');
INSERT INTO student_payments VALUES('181','1','221','2022-03-01','18500.00','','2022-03-03 12:01:22','2022-03-03 12:01:22');
INSERT INTO student_payments VALUES('182','1','237','2022-03-02','19000.00','','2022-03-03 12:01:58','2022-03-03 12:01:58');
INSERT INTO student_payments VALUES('183','1','240','2022-03-02','19000.00','','2022-03-03 12:04:33','2022-03-03 12:04:33');
INSERT INTO student_payments VALUES('184','1','250','2022-03-01','27500.00','','2022-03-03 12:17:37','2022-03-03 12:17:37');
INSERT INTO student_payments VALUES('185','1','229','2022-03-03','17000.00','','2022-03-03 20:15:49','2022-03-03 20:15:49');
INSERT INTO student_payments VALUES('186','1','210','2022-03-03','17500.00','','2022-03-03 20:16:25','2022-03-03 20:16:25');
INSERT INTO student_payments VALUES('187','1','215','2022-03-03','18500.00','','2022-03-03 20:17:02','2022-03-03 20:17:02');
INSERT INTO student_payments VALUES('188','1','230','2022-03-03','17000.00','','2022-03-03 21:01:27','2022-03-03 21:01:27');
INSERT INTO student_payments VALUES('189','1','243','2022-03-04','17500.00','','2022-03-04 19:56:18','2022-03-04 19:56:18');
INSERT INTO student_payments VALUES('190','1','239','2022-03-04','17500.00','','2022-03-04 19:57:05','2022-03-04 19:57:05');
INSERT INTO student_payments VALUES('192','1','231','2022-03-03','17000.00','','2022-03-05 10:47:26','2022-03-05 10:47:26');
INSERT INTO student_payments VALUES('193','1','211','2022-03-05','18500.00','','2022-03-05 14:41:54','2022-03-05 14:41:54');
INSERT INTO student_payments VALUES('194','1','225','2022-03-05','17000.00','','2022-03-05 14:54:11','2022-03-05 14:54:11');
INSERT INTO student_payments VALUES('195','1','241','2022-03-05','17000.00','','2022-03-05 15:02:35','2022-03-05 15:02:35');
INSERT INTO student_payments VALUES('196','1','251','2022-03-05','35000.00','','2022-03-05 17:07:52','2022-03-05 17:07:52');
INSERT INTO student_payments VALUES('197','1','249','2022-03-09','18000.00','','2022-03-12 12:06:05','2022-03-12 12:06:05');
INSERT INTO student_payments VALUES('198','1','242','2022-03-09','18000.00','','2022-03-12 12:06:29','2022-03-12 12:06:29');
INSERT INTO student_payments VALUES('199','1','212','2022-03-09','18500.00','','2022-03-12 12:07:25','2022-03-12 12:07:25');
INSERT INTO student_payments VALUES('200','1','252','2022-03-09','16000.00','','2022-03-12 12:13:36','2022-03-12 12:13:36');
INSERT INTO student_payments VALUES('201','1','253','2022-03-09','16000.00','','2022-03-12 12:16:39','2022-03-12 12:16:39');
INSERT INTO student_payments VALUES('202','1','224','2022-03-09','17000.00','','2022-03-12 12:17:27','2022-03-12 12:17:27');
INSERT INTO student_payments VALUES('203','1','234','2022-03-09','22000.00','','2022-03-12 12:17:52','2022-03-12 12:17:52');
INSERT INTO student_payments VALUES('204','1','233','2022-03-09','22000.00','','2022-03-12 12:23:04','2022-03-12 12:23:04');
INSERT INTO student_payments VALUES('205','1','223','2022-03-09','17000.00','','2022-03-12 12:30:23','2022-03-12 12:30:23');
INSERT INTO student_payments VALUES('206','1','247','2022-03-07','17500.00','','2022-03-12 12:35:53','2022-03-12 12:35:53');
INSERT INTO student_payments VALUES('207','1','238','2022-03-07','17500.00','','2022-03-12 12:36:22','2022-03-12 12:36:22');
INSERT INTO student_payments VALUES('208','1','236','2022-03-07','17500.00','','2022-03-12 12:36:49','2022-03-12 12:36:49');
INSERT INTO student_payments VALUES('209','1','226','2022-03-08','17000.00','','2022-03-12 12:39:29','2022-03-12 12:39:29');
INSERT INTO student_payments VALUES('210','1','222','2022-03-08','17000.00','','2022-03-12 12:58:58','2022-03-12 12:58:58');
INSERT INTO student_payments VALUES('211','1','248','2022-03-09','17500.00','','2022-03-12 13:05:12','2022-03-12 13:05:12');
INSERT INTO student_payments VALUES('212','1','227','2022-03-08','17000.00','','2022-03-12 13:06:12','2022-03-12 13:06:12');
INSERT INTO student_payments VALUES('213','1','220','2022-03-08','15000.00','','2022-03-12 13:06:38','2022-03-12 13:06:38');
INSERT INTO student_payments VALUES('214','1','219','2022-03-08','15000.00','','2022-03-12 13:07:04','2022-03-12 13:07:04');
INSERT INTO student_payments VALUES('215','1','217','2022-03-08','15000.00','','2022-03-12 13:07:38','2022-03-12 13:07:38');
INSERT INTO student_payments VALUES('216','1','232','2022-03-08','15000.00','','2022-03-12 13:08:08','2022-03-12 13:08:08');
INSERT INTO student_payments VALUES('217','1','246','2022-03-07','14000.00','','2022-03-12 13:17:06','2022-03-12 13:17:06');
INSERT INTO student_payments VALUES('218','1','228','2022-03-09','17000.00','','2022-03-12 13:20:41','2022-03-12 13:20:41');
INSERT INTO student_payments VALUES('219','1','254','2022-02-22','21000.00','','2022-03-12 15:08:04','2022-03-12 15:08:04');
INSERT INTO student_payments VALUES('220','1','255','2022-03-09','18000.00','','2022-03-12 15:18:47','2022-03-12 15:18:47');
INSERT INTO student_payments VALUES('221','1','256','2022-03-10','16000.00','','2022-03-12 15:32:13','2022-03-12 15:32:13');
INSERT INTO student_payments VALUES('222','1','218','2022-03-14','15000.00','','2022-03-14 13:42:10','2022-03-14 13:42:10');
INSERT INTO student_payments VALUES('223','1','214','2022-03-08','18000.00','','2022-03-14 13:43:00','2022-03-14 13:43:00');
INSERT INTO student_payments VALUES('224','1','213','2022-03-08','18000.00','','2022-03-14 13:43:48','2022-03-14 13:43:48');
INSERT INTO student_payments VALUES('225','1','257','2022-03-13','28900.00','','2022-03-15 07:30:16','2022-03-15 07:30:16');
INSERT INTO student_payments VALUES('226','1','258','2022-03-13','30800.00','','2022-03-15 07:40:39','2022-03-15 07:40:39');
INSERT INTO student_payments VALUES('227','1','209','2022-03-29','22500.00','','2022-04-01 09:04:03','2022-04-01 09:04:03');
INSERT INTO student_payments VALUES('228','1','284','2022-04-01','19000.00','','2022-04-04 07:24:51','2022-04-04 07:24:51');
INSERT INTO student_payments VALUES('229','1','287','2022-04-01','19000.00','','2022-04-04 07:28:25','2022-04-04 07:28:25');
INSERT INTO student_payments VALUES('230','1','260','2022-04-01','17500.00','','2022-04-04 07:30:01','2022-04-04 07:30:01');
INSERT INTO student_payments VALUES('231','1','268','2022-04-01','18500.00','','2022-04-04 07:30:29','2022-04-04 07:30:29');
INSERT INTO student_payments VALUES('232','1','272','2022-04-03','16000.00','','2022-04-04 07:32:15','2022-04-04 07:32:15');
INSERT INTO student_payments VALUES('233','1','269','2022-04-04','17000.00','','2022-04-05 14:26:30','2022-04-05 14:26:30');
INSERT INTO student_payments VALUES('234','1','270','2022-04-04','17000.00','','2022-04-05 14:29:15','2022-04-05 14:29:15');
INSERT INTO student_payments VALUES('235','1','271','2022-04-04','17000.00','','2022-04-05 14:31:48','2022-04-05 14:31:48');
INSERT INTO student_payments VALUES('236','1','273','2022-04-04','17000.00','','2022-04-05 14:32:17','2022-04-05 14:32:17');
INSERT INTO student_payments VALUES('237','1','292','2022-04-04','15000.00','','2022-04-05 14:33:34','2022-04-05 14:33:34');
INSERT INTO student_payments VALUES('238','1','301','2022-04-04','18500.00','','2022-04-05 14:35:41','2022-04-05 14:35:41');
INSERT INTO student_payments VALUES('239','1','262','2022-04-04','18500.00','','2022-04-05 14:40:30','2022-04-05 14:40:30');
INSERT INTO student_payments VALUES('240','1','300','2022-04-04','18500.00','','2022-04-05 14:41:03','2022-04-05 14:41:03');
INSERT INTO student_payments VALUES('241','1','303','2022-04-05','17000.00','','2022-04-05 14:56:20','2022-04-05 14:56:20');
INSERT INTO student_payments VALUES('242','1','291','2022-04-05','17500.00','','2022-04-05 14:56:51','2022-04-05 14:56:51');
INSERT INTO student_payments VALUES('243','1','283','2022-04-06','17500.00','','2022-04-06 11:38:45','2022-04-06 11:38:45');
INSERT INTO student_payments VALUES('244','1','304','2022-04-01','20000.00','','2022-04-06 11:51:01','2022-04-06 11:51:01');
INSERT INTO student_payments VALUES('245','1','302','2022-04-01','20000.00','','2022-04-06 11:58:44','2022-04-06 11:58:44');
INSERT INTO student_payments VALUES('246','1','302','2022-04-06','0.00','','2022-04-06 13:58:57','2022-04-06 13:58:57');
INSERT INTO student_payments VALUES('247','1','304','2022-04-06','0.00','','2022-04-06 13:59:34','2022-04-06 13:59:34');
INSERT INTO student_payments VALUES('248','1','261','2022-04-07','18500.00','','2022-04-08 09:14:08','2022-04-08 09:14:08');
INSERT INTO student_payments VALUES('249','1','286','2022-04-07','17500.00','','2022-04-08 09:14:40','2022-04-08 09:14:40');
INSERT INTO student_payments VALUES('250','1','292','2022-04-07','2500.00','','2022-04-08 09:18:13','2022-04-08 09:18:13');
INSERT INTO student_payments VALUES('251','1','294','2022-04-08','16500.00','','2022-04-08 09:27:25','2022-04-08 09:27:25');
INSERT INTO student_payments VALUES('252','1','295','2022-04-08','16500.00','','2022-04-08 09:28:52','2022-04-08 09:28:52');
INSERT INTO student_payments VALUES('253','1','305','2022-04-07','18500.00','','2022-04-08 09:34:23','2022-04-08 09:34:23');
INSERT INTO student_payments VALUES('254','1','263','2022-04-05','18500.00','','2022-04-08 10:44:15','2022-04-08 10:44:15');
INSERT INTO student_payments VALUES('255','1','288','2022-04-08','17500.00','','2022-04-08 10:45:45','2022-04-08 10:45:45');
INSERT INTO student_payments VALUES('256','1','274','2022-04-04','17000.00','','2022-04-08 10:49:24','2022-04-08 10:49:24');
INSERT INTO student_payments VALUES('257','1','288','2022-04-08','-500.00','','2022-04-08 11:05:01','2022-04-08 11:05:01');
INSERT INTO student_payments VALUES('258','1','267','2022-04-09','15000.00','','2022-04-09 13:08:20','2022-04-09 13:08:20');
INSERT INTO student_payments VALUES('259','1','266','2022-04-09','15000.00','','2022-04-09 13:08:46','2022-04-09 13:08:46');
INSERT INTO student_payments VALUES('260','1','264','2022-04-09','15000.00','','2022-04-09 13:09:03','2022-04-09 13:09:03');
INSERT INTO student_payments VALUES('261','1','265','2022-04-09','15000.00','','2022-04-09 13:09:22','2022-04-09 13:09:22');
INSERT INTO student_payments VALUES('262','1','281','2022-04-09','22000.00','','2022-04-09 13:33:44','2022-04-09 13:33:44');
INSERT INTO student_payments VALUES('263','1','235','2022-04-08','17000.00','','2022-04-09 14:19:49','2022-04-09 14:19:49');
INSERT INTO student_payments VALUES('264','1','293','2022-04-09','17500.00','','2022-04-10 14:18:28','2022-04-10 14:18:28');
INSERT INTO student_payments VALUES('265','1','290','2022-04-11','15000.00','','2022-04-12 09:31:42','2022-04-12 09:31:42');
INSERT INTO student_payments VALUES('266','1','280','2022-04-12','22000.00','','2022-04-12 12:09:30','2022-04-12 12:09:30');
INSERT INTO student_payments VALUES('267','1','282','2022-04-09','17000.00','','2022-04-13 08:37:43','2022-04-13 08:37:43');
INSERT INTO student_payments VALUES('268','1','279','2022-04-10','15000.00','','2022-04-13 08:38:12','2022-04-13 08:38:12');
INSERT INTO student_payments VALUES('269','1','285','2022-04-15','17500.00','','2022-04-16 12:23:13','2022-04-16 12:23:13');
INSERT INTO student_payments VALUES('270','1','299','2022-04-15','16000.00','','2022-04-16 12:24:15','2022-04-16 12:24:15');
INSERT INTO student_payments VALUES('271','1','289','2022-04-12','18000.00','','2022-04-16 12:24:37','2022-04-16 12:24:37');
INSERT INTO student_payments VALUES('272','1','259','2022-04-15','22000.00','','2022-04-16 12:25:42','2022-04-16 12:25:42');
INSERT INTO student_payments VALUES('273','1','307','2022-04-16','6000.00','','2022-04-18 08:11:14','2022-04-18 08:11:14');
INSERT INTO student_payments VALUES('274','1','275','2022-04-16','17000.00','','2022-04-18 08:13:05','2022-04-18 08:13:05');
INSERT INTO student_payments VALUES('275','1','276','2022-04-16','17000.00','','2022-04-18 08:13:29','2022-04-18 08:13:29');
INSERT INTO student_payments VALUES('276','1','277','2022-04-16','17000.00','','2022-04-18 08:13:50','2022-04-18 08:13:50');
INSERT INTO student_payments VALUES('277','1','278','2022-04-16','17000.00','','2022-04-18 08:14:07','2022-04-18 08:14:07');
INSERT INTO student_payments VALUES('278','1','308','2022-04-18','25000.00','','2022-04-23 14:59:54','2022-04-23 14:59:54');
INSERT INTO student_payments VALUES('279','1','309','2022-04-24','45000.00','','2022-04-28 08:40:21','2022-04-28 08:40:21');
INSERT INTO student_payments VALUES('280','1','318','2022-05-01','18500.00','','2022-05-10 14:45:16','2022-05-10 14:45:16');
INSERT INTO student_payments VALUES('281','1','343','2022-05-01','17500.00','','2022-05-10 14:45:43','2022-05-10 14:45:43');
INSERT INTO student_payments VALUES('282','1','342','2022-05-01','16000.00','','2022-05-10 14:47:36','2022-05-10 14:47:36');
INSERT INTO student_payments VALUES('283','1','333','2022-05-01','17500.00','','2022-05-10 14:48:00','2022-05-10 14:48:00');
INSERT INTO student_payments VALUES('284','1','337','2022-05-01','19000.00','','2022-05-10 14:58:15','2022-05-10 14:58:15');
INSERT INTO student_payments VALUES('285','1','356','2022-05-01','4000.00','','2022-05-10 14:58:36','2022-05-10 14:58:36');
INSERT INTO student_payments VALUES('286','1','259','2022-05-01','500.00','','2022-05-10 15:00:12','2022-05-10 15:00:12');
INSERT INTO student_payments VALUES('287','1','310','2022-05-01','22500.00','','2022-05-10 15:00:42','2022-05-10 15:00:42');
INSERT INTO student_payments VALUES('288','1','311','2022-05-01','17500.00','','2022-05-10 15:01:28','2022-05-10 15:01:28');
INSERT INTO student_payments VALUES('289','1','347','2022-05-01','10000.00','','2022-05-10 15:01:55','2022-05-10 15:01:55');
INSERT INTO student_payments VALUES('290','1','317','2022-05-06','15000.00','','2022-05-10 15:02:35','2022-05-10 15:02:35');
INSERT INTO student_payments VALUES('291','1','316','2022-05-06','15000.00','','2022-05-10 15:03:03','2022-05-10 15:03:03');
INSERT INTO student_payments VALUES('292','1','348','2022-05-07','18500.00','','2022-05-10 15:07:43','2022-05-10 15:07:43');
INSERT INTO student_payments VALUES('293','1','354','2022-05-07','20000.00','','2022-05-10 15:09:57','2022-05-10 15:09:57');
INSERT INTO student_payments VALUES('294','1','349','2022-05-08','18500.00','','2022-05-10 15:12:05','2022-05-10 15:12:05');
INSERT INTO student_payments VALUES('295','1','312','2022-05-08','18500.00','','2022-05-10 15:12:34','2022-05-10 15:12:34');
INSERT INTO student_payments VALUES('296','1','319','2022-05-08','17000.00','','2022-05-10 15:15:57','2022-05-10 15:15:57');
INSERT INTO student_payments VALUES('297','1','346','2022-05-08','17000.00','','2022-05-10 15:16:56','2022-05-10 15:16:56');
INSERT INTO student_payments VALUES('298','1','351','2022-05-08','20000.00','','2022-05-10 15:19:05','2022-05-10 15:19:05');
INSERT INTO student_payments VALUES('299','1','350','2022-05-09','20000.00','','2022-05-10 15:20:28','2022-05-10 15:20:28');
INSERT INTO student_payments VALUES('300','1','335','2022-05-09','17500.00','','2022-05-10 15:20:48','2022-05-10 15:20:48');
INSERT INTO student_payments VALUES('301','1','272','2022-05-09','1000.00','','2022-05-10 15:21:10','2022-05-10 15:21:10');
INSERT INTO student_payments VALUES('302','1','322','2022-05-09','17000.00','','2022-05-10 15:22:28','2022-05-10 15:22:28');
INSERT INTO student_payments VALUES('303','1','357','2022-05-09','29000.00','','2022-05-11 07:13:08','2022-05-11 07:13:08');
INSERT INTO student_payments VALUES('304','1','358','2022-05-09','25000.00','','2022-05-11 07:13:33','2022-05-11 07:13:33');
INSERT INTO student_payments VALUES('305','1','314','2022-05-10','15000.00','','2022-05-11 07:15:15','2022-05-11 07:15:15');
INSERT INTO student_payments VALUES('306','1','359','2022-05-10','16500.00','','2022-05-11 07:38:08','2022-05-11 07:38:08');
INSERT INTO student_payments VALUES('307','1','361','2022-05-10','11500.00','','2022-05-11 12:40:50','2022-05-11 12:40:50');
INSERT INTO student_payments VALUES('308','1','360','2022-05-10','11500.00','','2022-05-11 12:41:19','2022-05-11 12:41:19');
INSERT INTO student_payments VALUES('309','1','353','2022-05-11','18500.00','','2022-05-11 12:42:32','2022-05-11 12:42:32');
INSERT INTO student_payments VALUES('310','1','323','2022-05-12','17000.00','','2022-05-23 07:43:48','2022-05-23 07:43:48');
INSERT INTO student_payments VALUES('311','1','298','2022-05-12','15000.00','','2022-05-23 07:45:08','2022-05-23 07:45:08');
INSERT INTO student_payments VALUES('312','1','330','2022-05-12','22000.00','','2022-05-23 07:46:12','2022-05-23 07:46:12');
INSERT INTO student_payments VALUES('313','1','324','2022-05-12','17000.00','','2022-05-23 07:47:16','2022-05-23 07:47:16');
INSERT INTO student_payments VALUES('314','1','338','2022-05-12','17000.00','','2022-05-23 07:48:58','2022-05-23 07:48:58');
INSERT INTO student_payments VALUES('315','1','352','2022-05-13','18500.00','','2022-05-23 07:49:32','2022-05-23 07:49:32');
INSERT INTO student_payments VALUES('316','1','320','2022-05-13','17000.00','','2022-05-23 07:50:23','2022-05-23 07:50:23');
INSERT INTO student_payments VALUES('317','1','336','2022-05-13','17500.00','','2022-05-23 07:51:06','2022-05-23 07:51:06');
INSERT INTO student_payments VALUES('318','1','341','2022-05-13','17500.00','','2022-05-23 07:51:50','2022-05-23 07:51:50');
INSERT INTO student_payments VALUES('319','1','313','2022-05-14','18500.00','','2022-05-23 07:52:35','2022-05-23 07:52:35');
INSERT INTO student_payments VALUES('320','1','340','2022-05-14','18000.00','','2022-05-23 07:53:19','2022-05-23 07:53:19');
INSERT INTO student_payments VALUES('321','1','329','2022-05-14','10000.00','','2022-05-23 07:54:08','2022-05-23 07:54:08');
INSERT INTO student_payments VALUES('322','1','315','2022-05-15','15000.00','','2022-05-23 07:54:37','2022-05-23 07:54:37');
INSERT INTO student_payments VALUES('323','1','321','2022-05-15','17000.00','','2022-05-23 07:55:08','2022-05-23 07:55:08');
INSERT INTO student_payments VALUES('324','1','362','2022-05-17','30000.00','','2022-05-23 07:55:51','2022-05-23 07:55:51');
INSERT INTO student_payments VALUES('325','1','358','2022-05-18','4000.00','','2022-05-23 07:56:55','2022-05-23 07:56:55');
INSERT INTO student_payments VALUES('326','1','363','2022-05-22','5000.00','','2022-05-23 07:58:01','2022-05-23 07:58:01');
INSERT INTO student_payments VALUES('327','1','331','2022-05-19','22000.00','','2022-05-23 07:58:30','2022-05-23 07:58:30');
INSERT INTO student_payments VALUES('328','1','364','2022-05-17','10000.00','','2022-05-23 08:13:46','2022-05-23 08:13:46');
INSERT INTO student_payments VALUES('329','1','347','2022-05-23','6000.00','','2022-05-23 11:39:40','2022-05-23 11:39:40');
INSERT INTO student_payments VALUES('330','1','332','2022-05-24','17000.00','','2022-05-25 12:10:33','2022-05-25 12:10:33');
INSERT INTO student_payments VALUES('331','1','329','2022-05-24','5000.00','','2022-05-29 08:40:09','2022-05-29 08:40:09');
INSERT INTO student_payments VALUES('332','1','344','2022-05-24','10000.00','','2022-05-29 08:41:02','2022-05-29 08:41:02');
INSERT INTO student_payments VALUES('333','1','345','2022-05-24','10000.00','','2022-05-29 08:41:46','2022-05-29 08:41:46');
INSERT INTO student_payments VALUES('334','1','361','2022-05-30','17500.00','','2022-05-30 13:27:59','2022-05-30 13:27:59');
INSERT INTO student_payments VALUES('335','1','365','2022-05-29','5000.00','','2022-05-31 07:54:55','2022-05-31 07:54:55');
INSERT INTO student_payments VALUES('336','1','366','2022-05-20','20000.00','','2022-06-02 10:37:56','2022-06-02 10:37:56');
INSERT INTO student_payments VALUES('337','1','411','2022-06-01','10000.00','','2022-06-04 05:47:52','2022-06-04 05:47:52');
INSERT INTO student_payments VALUES('338','1','387','2022-06-01','19000.00','','2022-06-04 05:50:18','2022-06-04 05:50:18');
INSERT INTO student_payments VALUES('339','1','384','2022-06-01','19000.00','','2022-06-04 05:51:58','2022-06-04 05:51:58');
INSERT INTO student_payments VALUES('340','1','412','2022-06-01','20000.00','','2022-06-04 05:53:29','2022-06-04 05:53:29');
INSERT INTO student_payments VALUES('341','1','417','2022-06-01','30000.00','','2022-06-04 06:01:30','2022-06-04 06:01:30');
INSERT INTO student_payments VALUES('342','1','419','2022-06-01','17000.00','','2022-06-04 06:04:19','2022-06-04 06:04:19');
INSERT INTO student_payments VALUES('343','1','418','2022-06-01','17000.00','','2022-06-04 06:05:06','2022-06-04 06:05:06');
INSERT INTO student_payments VALUES('344','1','385','2022-06-01','17500.00','','2022-06-04 06:06:07','2022-06-04 06:06:07');
INSERT INTO student_payments VALUES('345','1','368','2022-06-01','17500.00','','2022-06-04 06:08:23','2022-06-04 06:08:23');
INSERT INTO student_payments VALUES('346','1','420','2022-06-01','10000.00','','2022-06-04 06:12:51','2022-06-04 06:12:51');
INSERT INTO student_payments VALUES('347','1','396','2022-06-03','17000.00','','2022-06-04 06:15:21','2022-06-04 06:15:21');
INSERT INTO student_payments VALUES('348','1','410','2022-06-03','17500.00','','2022-06-04 06:17:49','2022-06-04 06:17:49');
INSERT INTO student_payments VALUES('396','1','386','2022-06-14','17500.00','','2022-06-25 15:41:58','2022-06-25 15:41:58');
INSERT INTO student_payments VALUES('350','1','342','2022-05-30','1500.00','','2022-06-04 06:39:16','2022-06-04 06:39:16');
INSERT INTO student_payments VALUES('395','1','398','2022-06-14','16000.00','','2022-06-25 15:41:03','2022-06-25 15:41:03');
INSERT INTO student_payments VALUES('352','1','422','2022-06-04','32000.00','','2022-06-05 14:58:38','2022-06-05 14:58:38');
INSERT INTO student_payments VALUES('353','1','423','2022-06-04','22000.00','','2022-06-05 14:59:49','2022-06-05 14:59:49');
INSERT INTO student_payments VALUES('354','1','393','2022-06-06','17500.00','','2022-06-06 05:52:03','2022-06-06 05:52:03');
INSERT INTO student_payments VALUES('355','1','370','2022-06-06','18500.00','','2022-06-06 06:43:27','2022-06-06 06:43:27');
INSERT INTO student_payments VALUES('356','1','372','2022-06-06','15000.00','','2022-06-06 12:59:40','2022-06-06 12:59:40');
INSERT INTO student_payments VALUES('357','1','379','2022-06-06','15000.00','','2022-06-06 13:00:12','2022-06-06 13:00:12');
INSERT INTO student_payments VALUES('358','1','374','2022-06-06','15000.00','','2022-06-06 13:00:37','2022-06-06 13:00:37');
INSERT INTO student_payments VALUES('510','1','540','2022-08-10','20000.00','','2022-08-11 06:32:03','2022-08-11 06:32:03');
INSERT INTO student_payments VALUES('360','1','376','2022-06-06','17000.00','','2022-06-06 13:03:04','2022-06-06 13:03:04');
INSERT INTO student_payments VALUES('361','1','369','2022-06-06','18500.00','','2022-06-06 13:04:29','2022-06-06 13:04:29');
INSERT INTO student_payments VALUES('362','1','383','2022-06-06','17500.00','','2022-06-06 13:05:34','2022-06-06 13:05:34');
INSERT INTO student_payments VALUES('363','1','424','2022-06-06','16500.00','','2022-06-06 13:40:12','2022-06-06 13:40:12');
INSERT INTO student_payments VALUES('364','1','401','2022-06-06','20000.00','','2022-06-07 04:45:32','2022-06-07 04:45:32');
INSERT INTO student_payments VALUES('365','1','407','2022-06-07','17500.00','','2022-06-07 09:02:13','2022-06-07 09:02:13');
INSERT INTO student_payments VALUES('366','1','420','2022-06-07','17000.00','','2022-06-07 09:06:07','2022-06-07 09:06:07');
INSERT INTO student_payments VALUES('367','1','425','2022-06-06','16500.00','','2022-06-09 06:53:09','2022-06-09 06:53:09');
INSERT INTO student_payments VALUES('368','1','403','2022-06-07','18500.00','','2022-06-09 13:54:20','2022-06-09 13:54:20');
INSERT INTO student_payments VALUES('369','1','426','2022-06-07','6000.00','','2022-06-09 14:00:24','2022-06-09 14:00:24');
INSERT INTO student_payments VALUES('370','1','418','2022-06-07','17000.00','','2022-06-09 14:01:37','2022-06-09 14:01:37');
INSERT INTO student_payments VALUES('371','1','419','2022-06-07','17000.00','','2022-06-09 14:02:11','2022-06-09 14:02:11');
INSERT INTO student_payments VALUES('372','1','402','2022-06-07','20000.00','','2022-06-09 14:06:06','2022-06-09 14:06:06');
INSERT INTO student_payments VALUES('373','1','375','2022-06-07','18500.00','','2022-06-09 14:07:05','2022-06-09 14:07:05');
INSERT INTO student_payments VALUES('374','1','388','2022-06-09','17500.00','','2022-06-09 14:07:49','2022-06-09 14:07:49');
INSERT INTO student_payments VALUES('375','1','404','2022-06-09','18500.00','','2022-06-09 14:10:10','2022-06-09 14:10:10');
INSERT INTO student_payments VALUES('376','1','399','2022-06-09','18500.00','','2022-06-09 14:10:47','2022-06-09 14:10:47');
INSERT INTO student_payments VALUES('377','1','400','2022-06-09','18500.00','','2022-06-09 14:11:45','2022-06-09 14:11:45');
INSERT INTO student_payments VALUES('378','1','406','2022-06-09','25000.00','','2022-06-09 14:14:56','2022-06-09 14:14:56');
INSERT INTO student_payments VALUES('379','1','355','2022-06-09','4000.00','','2022-06-09 14:15:44','2022-06-09 14:15:44');
INSERT INTO student_payments VALUES('380','1','397','2022-06-06','18000.00','','2022-06-09 14:25:23','2022-06-09 14:25:23');
INSERT INTO student_payments VALUES('381','1','367','2022-06-10','22430.00','','2022-06-10 14:32:37','2022-06-10 14:32:37');
INSERT INTO student_payments VALUES('382','1','371','2022-06-10','15000.00','','2022-06-10 14:35:55','2022-06-10 14:35:55');
INSERT INTO student_payments VALUES('383','1','373','2022-06-10','15000.00','','2022-06-10 14:37:13','2022-06-10 14:37:13');
INSERT INTO student_payments VALUES('384','1','391','2022-06-10','17500.00','','2022-06-10 14:37:51','2022-06-10 14:37:51');
INSERT INTO student_payments VALUES('385','1','414','2022-06-10','17000.00','','2022-06-11 12:59:07','2022-06-11 12:59:07');
INSERT INTO student_payments VALUES('386','1','339','2022-05-30','18000.00','','2022-06-11 13:00:51','2022-06-11 13:00:51');
INSERT INTO student_payments VALUES('387','1','389','2022-06-11','18000.00','','2022-06-11 13:01:10','2022-06-11 13:01:10');
INSERT INTO student_payments VALUES('388','1','409','2022-06-11','10000.00','','2022-06-11 13:04:14','2022-06-11 13:04:14');
INSERT INTO student_payments VALUES('389','1','359','2022-06-11','12500.00','','2022-06-11 13:04:40','2022-06-11 13:04:40');
INSERT INTO student_payments VALUES('390','1','408','2022-06-11','17500.00','','2022-06-11 13:05:13','2022-06-11 13:05:13');
INSERT INTO student_payments VALUES('391','1','298','2022-06-11','3000.00','','2022-06-11 13:12:27','2022-06-11 13:12:27');
INSERT INTO student_payments VALUES('392','1','427','2022-06-07','3000.00','','2022-06-11 13:15:41','2022-06-11 13:15:41');
INSERT INTO student_payments VALUES('393','1','428','2022-06-07','20000.00','','2022-06-11 13:29:02','2022-06-11 13:29:02');
INSERT INTO student_payments VALUES('394','1','392','2022-06-11','17500.00','','2022-06-11 13:35:16','2022-06-11 13:35:16');
INSERT INTO student_payments VALUES('397','1','429','2022-06-14','23300.00','','2022-06-25 16:04:07','2022-06-25 16:04:07');
INSERT INTO student_payments VALUES('398','1','430','2022-06-14','30000.00','','2022-07-03 07:27:12','2022-07-03 07:27:12');
INSERT INTO student_payments VALUES('399','1','431','2022-06-13','17000.00','','2022-07-03 07:52:10','2022-07-03 07:52:10');
INSERT INTO student_payments VALUES('400','1','363','2022-06-12','20000.00','','2022-07-03 08:04:33','2022-07-03 08:04:33');
INSERT INTO student_payments VALUES('401','1','447','2022-07-01','19000.00','','2022-07-03 11:10:47','2022-07-03 11:10:47');
INSERT INTO student_payments VALUES('402','1','444','2022-07-01','19000.00','','2022-07-03 11:11:16','2022-07-03 11:11:16');
INSERT INTO student_payments VALUES('403','1','433','2022-07-03','18500.00','','2022-07-08 08:50:05','2022-07-08 08:50:05');
INSERT INTO student_payments VALUES('404','1','445','2022-07-04','17500.00','','2022-07-08 10:09:00','2022-07-08 10:09:00');
INSERT INTO student_payments VALUES('405','1','476','2022-07-05','20000.00','','2022-07-08 10:17:20','2022-07-08 10:17:20');
INSERT INTO student_payments VALUES('406','1','472','2022-07-05','20000.00','','2022-07-08 10:18:16','2022-07-08 10:18:16');
INSERT INTO student_payments VALUES('407','1','469','2022-07-05','20000.00','','2022-07-08 10:27:26','2022-07-08 10:27:26');
INSERT INTO student_payments VALUES('408','1','468','2022-07-03','17500.00','','2022-07-08 10:30:03','2022-07-08 10:30:03');
INSERT INTO student_payments VALUES('409','1','441','2022-07-05','15000.00','','2022-07-08 10:37:22','2022-07-08 10:37:22');
INSERT INTO student_payments VALUES('410','1','470','2022-07-05','17000.00','','2022-07-08 10:49:41','2022-07-08 10:49:41');
INSERT INTO student_payments VALUES('411','1','460','2022-07-06','20000.00','','2022-07-08 10:55:27','2022-07-08 10:55:27');
INSERT INTO student_payments VALUES('412','1','459','2022-07-06','20000.00','','2022-07-08 10:56:19','2022-07-08 10:56:19');
INSERT INTO student_payments VALUES('413','1','461','2022-07-06','18500.00','','2022-07-08 10:57:06','2022-07-08 10:57:06');
INSERT INTO student_payments VALUES('414','1','455','2022-07-06','18000.00','','2022-07-08 10:58:05','2022-07-08 10:58:05');
INSERT INTO student_payments VALUES('415','1','453','2022-07-03','16500.00','','2022-07-08 11:06:18','2022-07-08 11:06:18');
INSERT INTO student_payments VALUES('416','1','449','2022-07-06','18000.00','','2022-07-08 11:08:04','2022-07-08 11:08:04');
INSERT INTO student_payments VALUES('417','1','443','2022-07-03','17500.00','','2022-07-08 11:16:25','2022-07-08 11:16:25');
INSERT INTO student_payments VALUES('418','1','440','2022-07-02','17000.00','','2022-07-08 11:17:56','2022-07-08 11:17:56');
INSERT INTO student_payments VALUES('419','1','438','2022-07-05','15000.00','','2022-07-08 11:20:18','2022-07-08 11:20:18');
INSERT INTO student_payments VALUES('420','1','437','2022-07-05','15000.00','','2022-07-08 11:24:34','2022-07-08 11:24:34');
INSERT INTO student_payments VALUES('421','1','436','2022-07-05','15000.00','','2022-07-08 11:25:18','2022-07-08 11:25:18');
INSERT INTO student_payments VALUES('422','1','435','2022-07-05','15000.00','','2022-07-08 11:27:32','2022-07-08 11:27:32');
INSERT INTO student_payments VALUES('423','1','448','2022-07-06','17000.00','','2022-07-08 11:29:07','2022-07-08 11:29:07');
INSERT INTO student_payments VALUES('424','1','452','2022-07-03','17500.00','','2022-07-08 11:35:26','2022-07-08 11:35:26');
INSERT INTO student_payments VALUES('425','1','442','2022-07-06','17000.00','','2022-07-08 11:36:57','2022-07-08 11:36:57');
INSERT INTO student_payments VALUES('426','1','466','2022-07-06','17000.00','','2022-07-08 11:40:29','2022-07-08 11:40:29');
INSERT INTO student_payments VALUES('427','1','465','2022-07-06','17500.00','','2022-07-08 11:41:08','2022-07-08 11:41:08');
INSERT INTO student_payments VALUES('428','1','464','2022-07-06','17500.00','','2022-07-08 11:48:11','2022-07-08 11:48:11');
INSERT INTO student_payments VALUES('429','1','450','2022-07-06','18000.00','','2022-07-08 11:53:57','2022-07-08 11:53:57');
INSERT INTO student_payments VALUES('430','1','473','2022-07-06','17000.00','','2022-07-08 11:55:02','2022-07-08 11:55:02');
INSERT INTO student_payments VALUES('431','1','439','2022-07-06','18500.00','','2022-07-08 11:55:54','2022-07-08 11:55:54');
INSERT INTO student_payments VALUES('432','1','434','2022-06-06','18500.00','','2022-07-08 11:56:42','2022-07-08 11:56:42');
INSERT INTO student_payments VALUES('433','1','458','2022-07-06','18500.00','','2022-07-08 11:57:37','2022-07-08 11:57:37');
INSERT INTO student_payments VALUES('434','1','463','2022-07-07','25000.00','','2022-07-08 12:06:03','2022-07-08 12:06:03');
INSERT INTO student_payments VALUES('435','1','390','2022-07-07','15000.00','','2022-07-08 12:10:21','2022-07-08 12:10:21');
INSERT INTO student_payments VALUES('436','1','457','2022-07-09','8500.00','','2022-07-09 13:49:27','2022-07-09 13:49:27');
INSERT INTO student_payments VALUES('437','1','481','2022-07-03','20000.00','','2022-07-14 11:40:01','2022-07-14 11:40:01');
INSERT INTO student_payments VALUES('438','1','478','2022-07-07','32000.00','','2022-07-14 11:40:51','2022-07-14 11:40:51');
INSERT INTO student_payments VALUES('439','1','479','2022-07-07','37000.00','','2022-07-14 11:41:24','2022-07-14 11:41:24');
INSERT INTO student_payments VALUES('440','1','480','2022-07-05','32500.00','','2022-07-14 11:43:05','2022-07-14 11:43:05');
INSERT INTO student_payments VALUES('441','1','482','2022-07-07','40000.00','','2022-07-16 06:45:10','2022-07-16 06:45:10');
INSERT INTO student_payments VALUES('442','1','483','2022-07-01','32500.00','','2022-07-16 06:57:44','2022-07-16 06:57:44');
INSERT INTO student_payments VALUES('443','1','484','2022-07-04','17500.00','','2022-07-16 08:15:36','2022-07-16 08:15:36');
INSERT INTO student_payments VALUES('444','1','432','2022-07-16','22400.00','','2022-07-16 10:22:41','2022-07-16 10:22:41');
INSERT INTO student_payments VALUES('445','1','475','2022-07-16','17000.00','','2022-07-16 15:10:31','2022-07-16 15:10:31');
INSERT INTO student_payments VALUES('446','1','488','2022-07-19','17000.00','','2022-07-20 06:13:55','2022-07-20 06:13:55');
INSERT INTO student_payments VALUES('447','1','489','2022-07-20','5000.00','','2022-07-21 08:48:58','2022-07-21 08:48:58');
INSERT INTO student_payments VALUES('448','1','487','2022-07-18','15000.00','','2022-07-21 08:56:57','2022-07-21 08:56:57');
INSERT INTO student_payments VALUES('449','1','486','2022-07-18','16000.00','','2022-07-21 08:57:32','2022-07-21 08:57:32');
INSERT INTO student_payments VALUES('450','1','477','2022-07-18','6000.00','','2022-07-21 08:59:18','2022-07-21 08:59:18');
INSERT INTO student_payments VALUES('451','1','485','2022-07-18','18000.00','','2022-07-21 09:00:55','2022-07-21 09:00:55');
INSERT INTO student_payments VALUES('452','1','490','2022-07-21','17000.00','','2022-07-21 09:58:36','2022-07-21 09:58:36');
INSERT INTO student_payments VALUES('453','1','446','2022-07-19','17500.00','','2022-07-21 10:01:34','2022-07-21 10:01:34');
INSERT INTO student_payments VALUES('454','1','491','2022-07-23','22000.00','','2022-07-23 08:39:57','2022-07-23 08:39:57');
INSERT INTO student_payments VALUES('455','1','493','2022-07-23','21500.00','','2022-07-23 08:49:19','2022-07-23 08:49:19');
INSERT INTO student_payments VALUES('456','1','495','2022-07-23','15250.00','','2022-07-24 08:43:05','2022-07-24 08:43:05');
INSERT INTO student_payments VALUES('457','1','494','2022-07-24','14000.00','','2022-07-24 08:45:06','2022-07-24 08:45:06');
INSERT INTO student_payments VALUES('458','1','488','2022-07-23','7500.00','','2022-07-27 10:51:54','2022-07-27 10:51:54');
INSERT INTO student_payments VALUES('459','1','427','2022-07-27','10000.00','','2022-07-28 06:29:26','2022-07-28 06:29:26');
INSERT INTO student_payments VALUES('460','1','550','2022-08-01','17500.00','','2022-08-02 10:09:11','2022-08-02 10:09:11');
INSERT INTO student_payments VALUES('461','1','526','2022-08-01','20000.00','','2022-08-02 10:10:00','2022-08-02 10:10:00');
INSERT INTO student_payments VALUES('462','1','525','2022-08-01','17500.00','','2022-08-02 10:10:38','2022-08-02 10:10:38');
INSERT INTO student_payments VALUES('463','1','503','2022-08-01','18500.00','','2022-08-02 10:11:51','2022-08-02 10:11:51');
INSERT INTO student_payments VALUES('464','1','539','2022-08-02','20000.00','','2022-08-02 10:12:19','2022-08-02 10:12:19');
INSERT INTO student_payments VALUES('465','1','552','2022-08-01','35000.00','','2022-08-03 06:07:12','2022-08-03 06:07:12');
INSERT INTO student_payments VALUES('466','1','515','2022-08-02','18000.00','','2022-08-03 06:08:26','2022-08-03 06:08:26');
INSERT INTO student_payments VALUES('467','1','507','2022-08-02','19000.00','','2022-08-03 06:09:23','2022-08-03 06:09:23');
INSERT INTO student_payments VALUES('468','1','510','2022-08-02','19000.00','','2022-08-03 06:10:19','2022-08-03 06:10:19');
INSERT INTO student_payments VALUES('469','1','554','2022-08-04','17500.00','','2022-08-04 18:36:17','2022-08-04 18:36:17');
INSERT INTO student_payments VALUES('470','1','508','2022-08-04','17500.00','','2022-08-04 18:37:14','2022-08-04 18:37:14');
INSERT INTO student_payments VALUES('471','1','542','2022-08-04','17500.00','','2022-08-04 18:45:08','2022-08-04 18:45:08');
INSERT INTO student_payments VALUES('472','1','527','2022-08-04','17000.00','','2022-08-04 18:45:58','2022-08-04 18:45:58');
INSERT INTO student_payments VALUES('473','1','529','2022-08-04','17000.00','','2022-08-04 18:46:41','2022-08-04 18:46:41');
INSERT INTO student_payments VALUES('474','1','523','2022-08-04','17500.00','','2022-08-04 18:47:35','2022-08-04 18:47:35');
INSERT INTO student_payments VALUES('475','1','524','2022-08-04','17500.00','','2022-08-04 18:48:30','2022-08-04 18:48:30');
INSERT INTO student_payments VALUES('476','1','546','2022-08-04','17500.00','','2022-08-04 18:49:45','2022-08-04 18:49:45');
INSERT INTO student_payments VALUES('477','1','538','2022-08-04','17500.00','','2022-08-04 18:50:30','2022-08-04 18:50:30');
INSERT INTO student_payments VALUES('478','1','504','2022-08-06','17000.00','','2022-08-06 16:36:46','2022-08-06 16:36:46');
INSERT INTO student_payments VALUES('479','1','555','2022-08-06','35000.00','','2022-08-06 16:44:49','2022-08-06 16:44:49');
INSERT INTO student_payments VALUES('480','1','551','2022-08-06','20000.00','','2022-08-06 16:45:45','2022-08-06 16:45:45');
INSERT INTO student_payments VALUES('481','1','544','2022-08-06','17500.00','','2022-08-06 16:47:45','2022-08-06 16:47:45');
INSERT INTO student_payments VALUES('482','1','511','2022-08-05','17000.00','','2022-08-06 16:48:42','2022-08-06 16:48:42');
INSERT INTO student_payments VALUES('483','1','535','2022-08-05','17500.00','','2022-08-06 16:49:36','2022-08-06 16:49:36');
INSERT INTO student_payments VALUES('484','1','541','2022-08-05','20000.00','','2022-08-06 16:50:22','2022-08-06 16:50:22');
INSERT INTO student_payments VALUES('485','1','514','2022-08-05','17500.00','','2022-08-06 16:51:40','2022-08-06 16:51:40');
INSERT INTO student_payments VALUES('486','1','536','2022-08-05','22000.00','','2022-08-06 16:52:12','2022-08-06 16:52:12');
INSERT INTO student_payments VALUES('487','1','537','2022-08-05','22000.00','','2022-08-06 16:52:46','2022-08-06 16:52:46');
INSERT INTO student_payments VALUES('488','1','522','2022-08-05','17500.00','','2022-08-06 16:53:41','2022-08-06 16:53:41');
INSERT INTO student_payments VALUES('489','1','497','2022-08-05','18500.00','','2022-08-06 16:55:25','2022-08-06 16:55:25');
INSERT INTO student_payments VALUES('490','1','533','2022-08-06','20000.00','','2022-08-07 06:55:36','2022-08-07 06:55:36');
INSERT INTO student_payments VALUES('491','1','457','2022-08-06','5000.00','','2022-08-07 06:56:44','2022-08-07 06:56:44');
INSERT INTO student_payments VALUES('492','1','516','2022-08-06','18500.00','','2022-08-07 06:57:10','2022-08-07 06:57:10');
INSERT INTO student_payments VALUES('493','1','494','2022-08-06','2500.00','','2022-08-07 06:58:07','2022-08-07 06:58:07');
INSERT INTO student_payments VALUES('494','1','548','2022-08-06','17500.00','','2022-08-07 06:58:49','2022-08-07 06:58:49');
INSERT INTO student_payments VALUES('495','1','487','2022-08-06','9000.00','','2022-08-07 07:03:34','2022-08-07 07:03:34');
INSERT INTO student_payments VALUES('496','1','543','2022-08-06','18500.00','','2022-08-07 07:04:08','2022-08-07 07:04:08');
INSERT INTO student_payments VALUES('509','1','557','2022-08-11','30800.00','','2022-08-11 06:31:38','2022-08-11 06:31:38');
INSERT INTO student_payments VALUES('498','1','531','2022-08-06','17000.00','','2022-08-07 07:15:47','2022-08-07 07:15:47');
INSERT INTO student_payments VALUES('499','1','365','2022-08-05','5000.00','','2022-08-07 07:47:41','2022-08-07 07:47:41');
INSERT INTO student_payments VALUES('720','1','815','2022-11-11','20000.00','','2022-11-16 17:15:12','2022-11-16 17:15:12');
INSERT INTO student_payments VALUES('501','1','545','2022-08-07','17000.00','','2022-08-07 07:56:18','2022-08-07 07:56:18');
INSERT INTO student_payments VALUES('502','1','532','2022-08-03','17500.00','','2022-08-07 08:10:05','2022-08-07 08:10:05');
INSERT INTO student_payments VALUES('503','1','490','2022-08-07','6000.00','','2022-08-09 09:34:27','2022-08-09 09:34:27');
INSERT INTO student_payments VALUES('504','1','517','2022-08-07','18500.00','','2022-08-09 09:35:00','2022-08-09 09:35:00');
INSERT INTO student_payments VALUES('505','1','519','2022-08-07','20000.00','','2022-08-09 09:35:42','2022-08-09 09:35:42');
INSERT INTO student_payments VALUES('506','1','501','2022-08-07','15000.00','','2022-08-09 09:36:36','2022-08-09 09:36:36');
INSERT INTO student_payments VALUES('507','1','502','2022-08-07','15000.00','','2022-08-09 09:37:10','2022-08-09 09:37:10');
INSERT INTO student_payments VALUES('508','1','499','2022-08-07','15000.00','','2022-08-09 09:37:49','2022-08-09 09:37:49');
INSERT INTO student_payments VALUES('511','1','534','2022-08-10','20000.00','','2022-08-11 06:32:33','2022-08-11 06:32:33');
INSERT INTO student_payments VALUES('512','1','506','2022-08-10','17500.00','','2022-08-11 06:33:01','2022-08-11 06:33:01');
INSERT INTO student_payments VALUES('513','1','485','2022-08-11','5000.00','','2022-08-12 07:31:35','2022-08-12 07:31:35');
INSERT INTO student_payments VALUES('514','1','521','2022-08-12','22000.00','','2022-08-13 06:44:51','2022-08-13 06:44:51');
INSERT INTO student_payments VALUES('719','1','802','2022-11-11','20000.00','','2022-11-16 17:14:38','2022-11-16 17:14:38');
INSERT INTO student_payments VALUES('516','1','509','2022-08-12','17500.00','','2022-08-13 06:53:39','2022-08-13 06:53:39');
INSERT INTO student_payments VALUES('517','1','489','2022-08-11','17500.00','','2022-08-13 06:54:31','2022-08-13 06:54:31');
INSERT INTO student_payments VALUES('518','1','551','2022-08-11','3000.00','','2022-08-13 07:07:30','2022-08-13 07:07:30');
INSERT INTO student_payments VALUES('519','1','390','2022-08-11','3000.00','','2022-08-13 07:10:08','2022-08-13 07:10:08');
INSERT INTO student_payments VALUES('520','1','513','2022-08-12','18000.00','','2022-08-13 07:10:37','2022-08-13 07:10:37');
INSERT INTO student_payments VALUES('521','1','512','2022-08-11','18000.00','','2022-08-13 07:11:11','2022-08-13 07:11:11');
INSERT INTO student_payments VALUES('522','1','496','2022-08-11','22500.00','','2022-08-13 07:11:56','2022-08-13 07:11:56');
INSERT INTO student_payments VALUES('523','1','494','2022-08-11','5000.00','','2022-08-13 07:13:35','2022-08-13 07:13:35');
INSERT INTO student_payments VALUES('524','1','505','2022-08-11','15000.00','','2022-08-13 07:14:16','2022-08-13 07:14:16');
INSERT INTO student_payments VALUES('525','1','558','2022-08-05','2185.00','','2022-08-13 07:26:23','2022-08-13 07:26:23');
INSERT INTO student_payments VALUES('526','1','559','2022-08-05','2185.00','','2022-08-13 07:26:52','2022-08-13 07:26:52');
INSERT INTO student_payments VALUES('527','1','560','2022-08-05','2000.00','','2022-08-13 07:29:36','2022-08-13 07:29:36');
INSERT INTO student_payments VALUES('528','1','518','2022-08-11','20000.00','','2022-08-14 19:32:51','2022-08-14 19:32:51');
INSERT INTO student_payments VALUES('529','1','365','2022-08-15','12000.00','','2022-08-19 10:24:16','2022-08-19 10:24:16');
INSERT INTO student_payments VALUES('530','1','457','2022-08-23','5000.00','','2022-08-24 06:43:23','2022-08-24 06:43:23');
INSERT INTO student_payments VALUES('531','1','521','2022-08-26','3000.00','','2022-08-29 10:59:10','2022-08-29 10:59:10');
INSERT INTO student_payments VALUES('532','1','561','2022-08-23','10000.00','','2022-09-02 10:29:03','2022-09-02 10:29:03');
INSERT INTO student_payments VALUES('533','1','562','2022-08-20','10000.00','','2022-09-02 10:32:21','2022-09-02 10:32:21');
INSERT INTO student_payments VALUES('534','1','644','2022-09-01','19000.00','','2022-09-03 18:57:47','2022-09-03 18:57:47');
INSERT INTO student_payments VALUES('535','1','625','2022-09-05','18500.00','','2022-09-03 19:00:35','2022-09-03 19:00:35');
INSERT INTO student_payments VALUES('536','1','650','2022-09-01','19000.00','','2022-09-03 19:03:07','2022-09-03 19:03:07');
INSERT INTO student_payments VALUES('537','1','637','2022-09-01','19500.00','','2022-09-03 19:03:48','2022-09-03 19:03:48');
INSERT INTO student_payments VALUES('538','1','664','2022-09-02','19000.00','','2022-09-03 19:07:24','2022-09-03 19:07:24');
INSERT INTO student_payments VALUES('539','1','671','2022-09-02','22000.00','','2022-09-03 19:12:40','2022-09-03 19:12:40');
INSERT INTO student_payments VALUES('540','1','671','2022-09-02','10000.00','','2022-09-03 19:13:17','2022-09-03 19:13:17');
INSERT INTO student_payments VALUES('541','1','656','2022-09-02','23500.00','','2022-09-03 19:14:14','2022-09-03 19:14:14');
INSERT INTO student_payments VALUES('542','1','628','2022-09-03','19000.00','','2022-09-03 19:25:36','2022-09-03 19:25:36');
INSERT INTO student_payments VALUES('543','1','645','2022-09-03','19000.00','','2022-09-03 19:36:59','2022-09-03 19:36:59');
INSERT INTO student_payments VALUES('544','1','643','2022-09-03','19000.00','','2022-09-03 19:37:56','2022-09-03 19:37:56');
INSERT INTO student_payments VALUES('545','1','630','2022-09-03','19000.00','','2022-09-03 19:38:35','2022-09-03 19:38:35');
INSERT INTO student_payments VALUES('546','1','657','2022-09-03','19000.00','','2022-09-03 19:42:50','2022-09-03 19:42:50');
INSERT INTO student_payments VALUES('547','1','646','2022-09-03','19000.00','','2022-09-03 19:44:19','2022-09-03 19:44:19');
INSERT INTO student_payments VALUES('548','1','636','2022-09-03','19000.00','','2022-09-03 19:44:52','2022-09-03 19:44:52');
INSERT INTO student_payments VALUES('549','1','621','2022-09-03','20000.00','','2022-09-03 19:46:20','2022-09-03 19:46:20');
INSERT INTO student_payments VALUES('550','1','634','2022-09-04','9500.00','','2022-09-05 08:46:05','2022-09-05 08:46:05');
INSERT INTO student_payments VALUES('551','1','662','2022-09-04','19000.00','','2022-09-05 08:48:20','2022-09-05 08:48:20');
INSERT INTO student_payments VALUES('552','1','666','2022-09-05','19000.00','','2022-09-05 08:49:17','2022-09-05 08:49:17');
INSERT INTO student_payments VALUES('553','1','620','2022-09-05','24000.00','','2022-09-05 08:50:10','2022-09-05 08:50:10');
INSERT INTO student_payments VALUES('554','1','631','2022-09-05','19000.00','','2022-09-05 19:22:14','2022-09-05 19:22:14');
INSERT INTO student_payments VALUES('555','1','665','2022-09-05','19000.00','','2022-09-05 19:23:45','2022-09-05 19:23:45');
INSERT INTO student_payments VALUES('556','1','669','2022-09-05','19000.00','','2022-09-05 19:24:28','2022-09-05 19:24:28');
INSERT INTO student_payments VALUES('557','1','667','2022-09-05','19000.00','','2022-09-05 20:49:43','2022-09-05 20:49:43');
INSERT INTO student_payments VALUES('558','1','672','2022-09-05','43000.00','','2022-09-05 21:02:28','2022-09-05 21:02:28');
INSERT INTO student_payments VALUES('559','1','651','2022-09-05','16500.00','','2022-09-05 21:08:09','2022-09-05 21:08:09');
INSERT INTO student_payments VALUES('560','1','627','2022-09-05','16500.00','','2022-09-05 21:08:46','2022-09-05 21:08:46');
INSERT INTO student_payments VALUES('561','1','640','2022-09-05','21500.00','','2022-09-05 21:10:37','2022-09-05 21:10:37');
INSERT INTO student_payments VALUES('562','1','675','2022-09-05','20000.00','','2022-09-07 08:21:03','2022-09-07 08:21:03');
INSERT INTO student_payments VALUES('563','1','676','2022-09-06','26000.00','','2022-09-07 08:35:39','2022-09-07 08:35:39');
INSERT INTO student_payments VALUES('564','1','639','2022-09-06','20000.00','','2022-09-07 08:36:17','2022-09-07 08:36:17');
INSERT INTO student_payments VALUES('565','1','663','2022-09-06','19000.00','','2022-09-07 08:36:55','2022-09-07 08:36:55');
INSERT INTO student_payments VALUES('566','1','673','2022-09-06','40000.00','','2022-09-07 08:37:34','2022-09-07 08:37:34');
INSERT INTO student_payments VALUES('567','1','674','2022-09-06','40000.00','','2022-09-07 08:38:15','2022-09-07 08:38:15');
INSERT INTO student_payments VALUES('568','1','641','2022-09-06','21500.00','','2022-09-07 08:38:42','2022-09-07 08:38:42');
INSERT INTO student_payments VALUES('569','1','622','2022-09-06','16500.00','','2022-09-07 08:39:10','2022-09-07 08:39:10');
INSERT INTO student_payments VALUES('570','1','623','2022-09-06','16500.00','','2022-09-07 08:39:34','2022-09-07 08:39:34');
INSERT INTO student_payments VALUES('571','1','624','2022-09-06','16500.00','','2022-09-07 08:39:55','2022-09-07 08:39:55');
INSERT INTO student_payments VALUES('1203','1','1275','2023-06-15','33000.00','','2023-06-15 08:37:38','2023-06-15 08:37:38');
INSERT INTO student_payments VALUES('573','1','647','2022-09-06','18500.00','','2022-09-07 08:42:42','2022-09-07 08:42:42');
INSERT INTO student_payments VALUES('574','1','626','2022-09-06','19000.00','','2022-09-07 08:46:00','2022-09-07 08:46:00');
INSERT INTO student_payments VALUES('575','1','633','2022-09-06','17000.00','','2022-09-07 08:46:34','2022-09-07 08:46:34');
INSERT INTO student_payments VALUES('576','1','654','2022-09-06','19000.00','','2022-09-07 08:47:02','2022-09-07 08:47:02');
INSERT INTO student_payments VALUES('577','1','670','2022-09-06','19000.00','','2022-09-07 08:47:55','2022-09-07 08:47:55');
INSERT INTO student_payments VALUES('578','1','648','2022-09-06','21500.00','','2022-09-07 08:49:04','2022-09-07 08:49:04');
INSERT INTO student_payments VALUES('579','1','652','2022-09-06','21500.00','','2022-09-07 08:49:44','2022-09-07 08:49:44');
INSERT INTO student_payments VALUES('580','1','660','2022-09-06','21500.00','','2022-09-07 08:50:46','2022-09-07 08:50:46');
INSERT INTO student_payments VALUES('581','1','677','2022-09-06','23000.00','','2022-09-07 09:11:06','2022-09-07 09:11:06');
INSERT INTO student_payments VALUES('582','1','678','2022-09-06','23000.00','','2022-09-07 09:11:31','2022-09-07 09:11:31');
INSERT INTO student_payments VALUES('583','1','659','2022-09-07','21500.00','','2022-09-08 19:01:16','2022-09-08 19:01:16');
INSERT INTO student_payments VALUES('584','1','668','2022-09-08','18000.00','','2022-09-08 19:01:49','2022-09-08 19:01:49');
INSERT INTO student_payments VALUES('585','1','634','2022-09-09','10000.00','','2022-09-10 07:58:00','2022-09-10 07:58:00');
INSERT INTO student_payments VALUES('586','1','635','2022-09-09','15000.00','','2022-09-10 07:58:31','2022-09-10 07:58:31');
INSERT INTO student_payments VALUES('587','1','679','2022-09-05','12000.00','','2022-09-10 08:49:49','2022-09-10 08:49:49');
INSERT INTO student_payments VALUES('588','1','661','2022-09-12','19000.00','','2022-09-12 06:24:49','2022-09-12 06:24:49');
INSERT INTO student_payments VALUES('589','1','638','2022-09-15','10000.00','','2022-09-20 07:01:58','2022-09-20 07:01:58');
INSERT INTO student_payments VALUES('590','1','635','2022-09-15','4500.00','','2022-09-20 07:02:59','2022-09-20 07:02:59');
INSERT INTO student_payments VALUES('591','1','653','2022-09-06','21500.00','','2022-09-22 05:56:04','2022-09-22 05:56:04');
INSERT INTO student_payments VALUES('592','1','638','2022-09-12','10000.00','','2022-09-22 05:57:06','2022-09-22 05:57:06');
INSERT INTO student_payments VALUES('593','1','427','2022-09-24','5000.00','','2022-09-24 12:56:57','2022-09-24 12:56:57');
INSERT INTO student_payments VALUES('1202','1','1274','2023-06-11','37000.00','','2023-06-14 15:42:39','2023-06-14 15:42:39');
INSERT INTO student_payments VALUES('595','1','633','2022-09-22','2000.00','','2022-09-24 12:59:44','2022-09-24 12:59:44');
INSERT INTO student_payments VALUES('596','1','737','2022-09-05','15000.00','','2022-10-05 07:07:30','2022-10-05 07:07:30');
INSERT INTO student_payments VALUES('597','1','738','2022-09-05','15000.00','','2022-10-05 07:07:51','2022-10-05 07:07:51');
INSERT INTO student_payments VALUES('598','1','671','2022-09-05','1000.00','','2022-10-05 07:32:44','2022-10-05 07:32:44');
INSERT INTO student_payments VALUES('599','1','741','2022-10-05','23000.00','','2022-10-05 07:40:15','2022-10-05 07:40:15');
INSERT INTO student_payments VALUES('600','1','742','2022-10-01','23000.00','','2022-10-05 07:41:02','2022-10-05 07:41:02');
INSERT INTO student_payments VALUES('601','1','710','2022-10-01','19000.00','','2022-10-05 07:41:43','2022-10-05 07:41:43');
INSERT INTO student_payments VALUES('602','1','718','2022-10-01','20000.00','','2022-10-05 07:42:26','2022-10-05 07:42:26');
INSERT INTO student_payments VALUES('603','1','743','2022-10-01','10000.00','','2022-10-05 07:51:57','2022-10-05 07:51:57');
INSERT INTO student_payments VALUES('604','1','694','2022-10-02','8500.00','','2022-10-05 07:52:53','2022-10-05 07:52:53');
INSERT INTO student_payments VALUES('605','1','733','2022-10-03','20000.00','','2022-10-05 07:54:35','2022-10-05 07:54:35');
INSERT INTO student_payments VALUES('606','1','717','2022-10-03','19000.00','','2022-10-05 07:55:09','2022-10-05 07:55:09');
INSERT INTO student_payments VALUES('607','1','686','2022-10-03','19000.00','','2022-10-05 07:56:01','2022-10-05 07:56:01');
INSERT INTO student_payments VALUES('608','1','704','2022-10-03','19000.00','','2022-10-05 07:56:29','2022-10-05 07:56:29');
INSERT INTO student_payments VALUES('609','1','722','2022-10-03','19000.00','','2022-10-05 07:57:45','2022-10-05 07:57:45');
INSERT INTO student_payments VALUES('610','1','703','2022-10-04','19000.00','','2022-10-05 07:59:20','2022-10-05 07:59:20');
INSERT INTO student_payments VALUES('611','1','706','2022-10-04','19000.00','','2022-10-05 07:59:49','2022-10-05 07:59:49');
INSERT INTO student_payments VALUES('612','1','688','2022-10-04','19000.00','','2022-10-05 08:00:28','2022-10-05 08:00:28');
INSERT INTO student_payments VALUES('613','1','690','2022-10-04','19000.00','','2022-10-05 08:01:04','2022-10-05 08:01:04');
INSERT INTO student_payments VALUES('614','1','677','2022-10-04','2000.00','','2022-10-05 08:04:41','2022-10-05 08:04:41');
INSERT INTO student_payments VALUES('615','1','678','2022-10-04','2000.00','','2022-10-05 08:05:07','2022-10-05 08:05:07');
INSERT INTO student_payments VALUES('616','1','689','2022-10-04','21000.00','','2022-10-05 08:05:31','2022-10-05 08:05:31');
INSERT INTO student_payments VALUES('617','1','692','2022-10-04','21000.00','','2022-10-05 08:05:53','2022-10-05 08:05:53');
INSERT INTO student_payments VALUES('618','1','699','2022-10-04','20000.00','','2022-10-05 08:07:29','2022-10-05 08:07:29');
INSERT INTO student_payments VALUES('619','1','696','2022-10-04','19000.00','','2022-10-05 08:07:53','2022-10-05 08:07:53');
INSERT INTO student_payments VALUES('620','1','713','2022-10-04','21500.00','','2022-10-05 08:08:15','2022-10-05 08:08:15');
INSERT INTO student_payments VALUES('621','1','721','2022-10-04','19000.00','','2022-10-05 08:08:51','2022-10-05 08:08:51');
INSERT INTO student_payments VALUES('622','1','705','2022-10-05','19000.00','','2022-10-07 07:41:24','2022-10-07 07:41:24');
INSERT INTO student_payments VALUES('623','1','727','2022-10-05','19000.00','','2022-10-07 07:41:58','2022-10-07 07:41:58');
INSERT INTO student_payments VALUES('624','1','697','2022-10-05','19500.00','','2022-10-07 07:42:26','2022-10-07 07:42:26');
INSERT INTO student_payments VALUES('625','1','746','2022-10-05','24500.00','','2022-10-07 07:46:03','2022-10-07 07:46:03');
INSERT INTO student_payments VALUES('626','1','747','2022-10-05','18500.00','','2022-10-07 07:59:57','2022-10-07 07:59:57');
INSERT INTO student_payments VALUES('627','1','731','2022-10-05','21500.00','','2022-10-07 08:00:18','2022-10-07 08:00:18');
INSERT INTO student_payments VALUES('628','1','730','2022-10-06','19000.00','','2022-10-07 08:03:46','2022-10-07 08:03:46');
INSERT INTO student_payments VALUES('629','1','700','2022-10-06','21500.00','','2022-10-07 08:04:12','2022-10-07 08:04:12');
INSERT INTO student_payments VALUES('630','1','729','2022-10-06','19000.00','','2022-10-07 08:04:45','2022-10-07 08:04:45');
INSERT INTO student_payments VALUES('631','1','725','2022-10-06','19000.00','','2022-10-07 08:05:22','2022-10-07 08:05:22');
INSERT INTO student_payments VALUES('632','1','681','2022-10-06','20000.00','','2022-10-07 08:05:59','2022-10-07 08:05:59');
INSERT INTO student_payments VALUES('633','1','693','2022-10-06','19000.00','','2022-10-07 08:06:23','2022-10-07 08:06:23');
INSERT INTO student_payments VALUES('634','1','748','2022-10-06','18500.00','','2022-10-07 08:10:09','2022-10-07 08:10:09');
INSERT INTO student_payments VALUES('635','1','720','2022-10-06','21500.00','','2022-10-07 08:10:50','2022-10-07 08:10:50');
INSERT INTO student_payments VALUES('636','1','687','2022-10-06','16500.00','','2022-10-07 08:13:11','2022-10-07 08:13:11');
INSERT INTO student_payments VALUES('637','1','714','2022-10-06','19000.00','','2022-10-07 08:14:04','2022-10-07 08:14:04');
INSERT INTO student_payments VALUES('638','1','719','2022-10-06','21500.00','','2022-10-07 08:15:40','2022-10-07 08:15:40');
INSERT INTO student_payments VALUES('639','1','683','2022-10-06','16500.00','','2022-10-07 08:16:36','2022-10-07 08:16:36');
INSERT INTO student_payments VALUES('640','1','682','2022-10-06','16500.00','','2022-10-07 08:17:37','2022-10-07 08:17:37');
INSERT INTO student_payments VALUES('641','1','749','2022-10-07','26000.00','','2022-10-07 08:20:00','2022-10-07 08:20:00');
INSERT INTO student_payments VALUES('642','1','709','2022-10-07','18700.00','','2022-10-07 08:20:23','2022-10-07 08:20:23');
INSERT INTO student_payments VALUES('643','1','701','2022-10-07','21500.00','','2022-10-08 07:00:09','2022-10-08 07:00:09');
INSERT INTO student_payments VALUES('644','1','723','2022-10-07','19000.00','','2022-10-08 07:00:39','2022-10-08 07:00:39');
INSERT INTO student_payments VALUES('645','1','712','2022-10-08','21500.00','','2022-10-08 07:01:19','2022-10-08 07:01:19');
INSERT INTO student_payments VALUES('646','1','711','2022-10-08','16500.00','','2022-10-09 05:58:49','2022-10-09 05:58:49');
INSERT INTO student_payments VALUES('647','1','684','2022-10-10','16500.00','','2022-10-13 09:30:09','2022-10-13 09:30:09');
INSERT INTO student_payments VALUES('648','1','726','2022-10-10','19000.00','','2022-10-13 09:30:59','2022-10-13 09:30:59');
INSERT INTO student_payments VALUES('649','1','691','2022-10-10','19000.00','','2022-10-13 09:31:28','2022-10-13 09:31:28');
INSERT INTO student_payments VALUES('650','1','694','2022-10-10','11000.00','','2022-10-13 09:32:01','2022-10-13 09:32:01');
INSERT INTO student_payments VALUES('651','1','695','2022-10-10','19500.00','','2022-10-13 09:32:37','2022-10-13 09:32:37');
INSERT INTO student_payments VALUES('652','1','743','2022-10-10','21500.00','','2022-10-13 09:33:18','2022-10-13 09:33:18');
INSERT INTO student_payments VALUES('653','1','625','2022-10-10','1000.00','','2022-10-13 09:33:53','2022-10-13 09:33:53');
INSERT INTO student_payments VALUES('654','1','685','2022-10-11','19000.00','','2022-10-13 09:34:32','2022-10-13 09:34:32');
INSERT INTO student_payments VALUES('655','1','668','2022-10-13','2000.00','','2022-10-16 13:24:26','2022-10-16 13:24:26');
INSERT INTO student_payments VALUES('656','1','698','2022-10-13','20000.00','','2022-10-16 13:24:56','2022-10-16 13:24:56');
INSERT INTO student_payments VALUES('657','1','732','2022-10-13','20000.00','','2022-10-16 13:25:29','2022-10-16 13:25:29');
INSERT INTO student_payments VALUES('658','1','739','2022-10-14','15000.00','','2022-10-16 13:26:56','2022-10-16 13:26:56');
INSERT INTO student_payments VALUES('659','1','735','2022-10-15','12000.00','','2022-10-16 13:27:36','2022-10-16 13:27:36');
INSERT INTO student_payments VALUES('660','1','728','2022-10-15','5000.00','','2022-10-16 13:28:59','2022-10-16 13:28:59');
INSERT INTO student_payments VALUES('661','1','743','2022-10-16','5000.00','','2022-10-17 12:19:37','2022-10-17 12:19:37');
INSERT INTO student_payments VALUES('662','1','728','2022-10-30','8000.00','','2022-10-31 16:12:18','2022-10-31 16:12:18');
INSERT INTO student_payments VALUES('663','1','740','2022-10-31','13000.00','','2022-10-31 16:13:14','2022-10-31 16:13:14');
INSERT INTO student_payments VALUES('664','1','671','2022-09-05','0.00','','2022-11-01 07:11:34','2022-11-01 07:11:34');
INSERT INTO student_payments VALUES('665','1','785','2022-11-01','23000.00','','2022-11-01 07:11:58','2022-11-01 07:11:58');
INSERT INTO student_payments VALUES('666','1','685','2022-11-01','500.00','','2022-11-01 07:12:24','2022-11-01 07:12:24');
INSERT INTO student_payments VALUES('667','1','755','2022-11-01','19500.00','','2022-11-01 07:13:12','2022-11-01 07:13:12');
INSERT INTO student_payments VALUES('668','1','796','2022-11-01','19000.00','','2022-11-01 07:13:59','2022-11-01 07:13:59');
INSERT INTO student_payments VALUES('669','1','744','2022-11-01','1200.00','','2022-11-02 06:40:40','2022-11-02 06:40:40');
INSERT INTO student_payments VALUES('670','1','759','2022-11-01','21000.00','','2022-11-02 06:41:06','2022-11-02 06:41:06');
INSERT INTO student_payments VALUES('671','1','777','2022-11-01','19000.00','','2022-11-02 06:41:58','2022-11-02 06:41:58');
INSERT INTO student_payments VALUES('672','1','758','2022-11-01','19000.00','','2022-11-02 06:42:35','2022-11-02 06:42:35');
INSERT INTO student_payments VALUES('673','1','767','2022-11-01','19500.00','','2022-11-02 06:43:01','2022-11-02 06:43:01');
INSERT INTO student_payments VALUES('674','1','745','2022-11-02','1200.00','','2022-11-02 16:35:53','2022-11-02 16:35:53');
INSERT INTO student_payments VALUES('675','1','762','2022-11-02','21000.00','','2022-11-02 16:36:29','2022-11-02 16:36:29');
INSERT INTO student_payments VALUES('676','1','760','2022-11-02','19000.00','','2022-11-02 16:36:55','2022-11-02 16:36:55');
INSERT INTO student_payments VALUES('677','1','807','2022-11-02','18500.00','','2022-11-02 16:50:22','2022-11-02 16:50:22');
INSERT INTO student_payments VALUES('678','1','775','2022-11-02','19000.00','','2022-11-02 16:51:04','2022-11-02 16:51:04');
INSERT INTO student_payments VALUES('679','1','766','2022-11-02','19000.00','','2022-11-02 16:51:26','2022-11-02 16:51:26');
INSERT INTO student_payments VALUES('680','1','780','2022-11-02','19000.00','','2022-11-02 16:51:47','2022-11-02 16:51:47');
INSERT INTO student_payments VALUES('681','1','808','2022-11-02','36000.00','','2022-11-03 06:32:02','2022-11-03 06:32:02');
INSERT INTO student_payments VALUES('682','1','809','2022-11-03','18700.00','','2022-11-04 13:01:53','2022-11-04 13:01:53');
INSERT INTO student_payments VALUES('683','1','747','2022-11-03','200.00','','2022-11-04 13:02:32','2022-11-04 13:02:32');
INSERT INTO student_payments VALUES('684','1','782','2022-11-03','21500.00','','2022-11-04 13:04:38','2022-11-04 13:04:38');
INSERT INTO student_payments VALUES('685','1','786','2022-11-03','22000.00','','2022-11-06 14:32:32','2022-11-06 14:32:32');
INSERT INTO student_payments VALUES('686','1','751','2022-11-04','20000.00','','2022-11-06 14:33:23','2022-11-06 14:33:23');
INSERT INTO student_payments VALUES('687','1','797','2022-11-04','19000.00','','2022-11-06 14:33:55','2022-11-06 14:33:55');
INSERT INTO student_payments VALUES('688','1','801','2022-11-04','21500.00','','2022-11-06 14:34:40','2022-11-06 14:34:40');
INSERT INTO student_payments VALUES('689','1','800','2022-11-04','19000.00','','2022-11-06 14:35:25','2022-11-06 14:35:25');
INSERT INTO student_payments VALUES('690','1','774','2022-11-04','19000.00','','2022-11-06 14:36:02','2022-11-06 14:36:02');
INSERT INTO student_payments VALUES('691','1','810','2022-11-04','10000.00','','2022-11-06 14:52:06','2022-11-06 14:52:06');
INSERT INTO student_payments VALUES('692','1','805','2022-11-04','12000.00','','2022-11-06 14:55:14','2022-11-06 14:55:14');
INSERT INTO student_payments VALUES('693','1','803','2022-11-04','20000.00','','2022-11-06 14:55:40','2022-11-06 14:55:40');
INSERT INTO student_payments VALUES('694','1','776','2022-11-04','19000.00','','2022-11-06 14:56:10','2022-11-06 14:56:10');
INSERT INTO student_payments VALUES('695','1','787','2022-11-04','19000.00','','2022-11-06 14:56:44','2022-11-06 14:56:44');
INSERT INTO student_payments VALUES('696','1','792','2022-11-05','19000.00','','2022-11-06 14:58:43','2022-11-06 14:58:43');
INSERT INTO student_payments VALUES('697','1','793','2022-11-05','19000.00','','2022-11-06 15:19:25','2022-11-06 15:19:25');
INSERT INTO student_payments VALUES('698','1','757','2022-11-05','16500.00','','2022-11-06 15:19:48','2022-11-06 15:19:48');
INSERT INTO student_payments VALUES('699','1','790','2022-11-06','21500.00','','2022-11-06 15:20:10','2022-11-06 15:20:10');
INSERT INTO student_payments VALUES('700','1','781','2022-11-06','16500.00','','2022-11-06 15:20:27','2022-11-06 15:20:27');
INSERT INTO student_payments VALUES('701','1','753','2022-11-06','16500.00','','2022-11-06 15:20:46','2022-11-06 15:20:46');
INSERT INTO student_payments VALUES('702','1','784','2022-11-06','19000.00','','2022-11-08 09:54:12','2022-11-08 09:54:12');
INSERT INTO student_payments VALUES('703','1','675','2022-11-06','2000.00','','2022-11-08 09:55:01','2022-11-08 09:55:01');
INSERT INTO student_payments VALUES('704','1','788','2022-11-06','20000.00','','2022-11-08 09:55:24','2022-11-08 09:55:24');
INSERT INTO student_payments VALUES('705','1','752','2022-11-06','16500.00','','2022-11-08 09:55:54','2022-11-08 09:55:54');
INSERT INTO student_payments VALUES('706','1','754','2022-11-06','16500.00','','2022-11-08 09:56:40','2022-11-08 09:56:40');
INSERT INTO student_payments VALUES('707','1','799','2022-11-07','19000.00','','2022-11-08 09:57:12','2022-11-08 09:57:12');
INSERT INTO student_payments VALUES('708','1','769','2022-11-07','20000.00','','2022-11-08 09:57:42','2022-11-08 09:57:42');
INSERT INTO student_payments VALUES('709','1','791','2022-11-07','19000.00','','2022-11-08 09:59:08','2022-11-08 09:59:08');
INSERT INTO student_payments VALUES('710','1','779','2022-11-07','18700.00','','2022-11-08 09:59:37','2022-11-08 09:59:37');
INSERT INTO student_payments VALUES('711','1','783','2022-11-07','21500.00','','2022-11-08 10:00:32','2022-11-08 10:00:32');
INSERT INTO student_payments VALUES('712','1','789','2022-11-07','21500.00','','2022-11-08 10:00:58','2022-11-08 10:00:58');
INSERT INTO student_payments VALUES('713','1','795','2022-11-07','19000.00','','2022-11-08 10:01:50','2022-11-08 10:01:50');
INSERT INTO student_payments VALUES('714','1','811','2022-11-08','26000.00','','2022-11-08 10:04:19','2022-11-08 10:04:19');
INSERT INTO student_payments VALUES('715','1','750','2022-11-08','24000.00','','2022-11-08 12:23:24','2022-11-08 12:23:24');
INSERT INTO student_payments VALUES('716','1','761','2022-11-08','19000.00','','2022-11-16 16:55:07','2022-11-16 16:55:07');
INSERT INTO student_payments VALUES('717','1','813','2022-11-08','17500.00','','2022-11-16 16:55:42','2022-11-16 16:55:42');
INSERT INTO student_payments VALUES('718','1','815','2022-11-10','18000.00','','2022-11-16 17:11:53','2022-11-16 17:11:53');
INSERT INTO student_payments VALUES('721','1','816','2022-11-11','33500.00','','2022-11-16 17:26:54','2022-11-16 17:26:54');
INSERT INTO student_payments VALUES('722','1','756','2022-11-11','19000.00','','2022-11-21 10:13:45','2022-11-21 10:13:45');
INSERT INTO student_payments VALUES('723','1','764','2022-11-11','19500.00','','2022-11-21 10:14:15','2022-11-21 10:14:15');
INSERT INTO student_payments VALUES('724','1','765','2022-11-11','19500.00','','2022-11-21 10:14:39','2022-11-21 10:14:39');
INSERT INTO student_payments VALUES('725','1','772','2022-11-11','21500.00','','2022-11-21 10:15:09','2022-11-21 10:15:09');
INSERT INTO student_payments VALUES('726','1','768','2022-11-12','20000.00','','2022-11-21 10:16:13','2022-11-21 10:16:13');
INSERT INTO student_payments VALUES('727','1','728','2022-11-13','7000.00','','2022-11-21 10:18:21','2022-11-21 10:18:21');
INSERT INTO student_payments VALUES('728','1','798','2022-11-13','6600.00','','2022-11-21 10:19:11','2022-11-21 10:19:11');
INSERT INTO student_payments VALUES('729','1','810','2022-11-14','21500.00','','2022-11-21 10:21:26','2022-11-21 10:21:26');
INSERT INTO student_payments VALUES('730','1','804','2022-11-26','15000.00','','2022-12-04 08:07:12','2022-12-04 08:07:12');
INSERT INTO student_payments VALUES('731','1','806','2022-11-26','15000.00','','2022-12-04 08:07:39','2022-12-04 08:07:39');
INSERT INTO student_payments VALUES('732','1','817','2022-11-05','20000.00','','2022-12-10 08:30:14','2022-12-10 08:30:14');
INSERT INTO student_payments VALUES('733','1','818','2022-11-05','20000.00','','2022-12-10 08:30:57','2022-12-10 08:30:57');
INSERT INTO student_payments VALUES('734','1','851','2022-12-01','22000.00','','2022-12-22 06:43:54','2022-12-22 06:43:54');
INSERT INTO student_payments VALUES('735','1','843','2022-12-01','19000.00','','2022-12-22 06:44:15','2022-12-22 06:44:15');
INSERT INTO student_payments VALUES('736','1','829','2022-12-01','21000.00','','2022-12-22 06:44:58','2022-12-22 06:44:58');
INSERT INTO student_payments VALUES('737','1','832','2022-12-01','21000.00','','2022-12-22 06:45:33','2022-12-22 06:45:33');
INSERT INTO student_payments VALUES('738','1','841','2022-12-01','19000.00','','2022-12-22 06:46:08','2022-12-22 06:46:08');
INSERT INTO student_payments VALUES('739','1','826','2022-12-01','19000.00','','2022-12-22 06:46:46','2022-12-22 06:46:46');
INSERT INTO student_payments VALUES('740','1','830','2022-12-02','19000.00','','2022-12-22 06:47:13','2022-12-22 06:47:13');
INSERT INTO student_payments VALUES('741','1','846','2022-12-02','19000.00','','2022-12-22 06:47:35','2022-12-22 06:47:35');
INSERT INTO student_payments VALUES('742','1','853','2022-12-02','9000.00','','2022-12-22 06:51:37','2022-12-22 06:51:37');
INSERT INTO student_payments VALUES('743','1','825','2022-12-02','19500.00','','2022-12-22 06:52:04','2022-12-22 06:52:04');
INSERT INTO student_payments VALUES('744','1','821','2022-12-03','20000.00','','2022-12-22 06:52:33','2022-12-22 06:52:33');
INSERT INTO student_payments VALUES('745','1','833','2022-12-03','9500.00','','2022-12-22 06:53:04','2022-12-22 06:53:04');
INSERT INTO student_payments VALUES('746','1','852','2022-12-03','20000.00','','2022-12-22 06:55:14','2022-12-22 06:55:14');
INSERT INTO student_payments VALUES('747','1','861','2022-12-03','19000.00','','2022-12-22 06:56:03','2022-12-22 06:56:03');
INSERT INTO student_payments VALUES('748','1','868','2022-12-03','20000.00','','2022-12-22 06:56:38','2022-12-22 06:56:38');
INSERT INTO student_payments VALUES('749','1','842','2022-12-04','19000.00','','2022-12-22 06:57:36','2022-12-22 06:57:36');
INSERT INTO student_payments VALUES('750','1','835','2022-12-04','19000.00','','2022-12-22 06:58:03','2022-12-22 06:58:03');
INSERT INTO student_payments VALUES('751','1','840','2022-12-05','19000.00','','2022-12-22 06:58:33','2022-12-22 06:58:33');
INSERT INTO student_payments VALUES('752','1','828','2022-12-05','19000.00','','2022-12-22 06:59:07','2022-12-22 06:59:07');
INSERT INTO student_payments VALUES('753','1','870','2022-12-05','12000.00','','2022-12-22 07:00:35','2022-12-22 07:00:35');
INSERT INTO student_payments VALUES('754','1','866','2022-12-05','21500.00','','2022-12-22 07:03:01','2022-12-22 07:03:01');
INSERT INTO student_payments VALUES('755','1','838','2022-12-05','20000.00','','2022-12-22 07:03:59','2022-12-22 07:03:59');
INSERT INTO student_payments VALUES('759','1','877','2022-12-05','26000.00','','2022-12-28 16:20:24','2022-12-28 16:20:24');
INSERT INTO student_payments VALUES('757','1','864','2022-12-05','19000.00','','2022-12-22 07:09:19','2022-12-22 07:09:19');
INSERT INTO student_payments VALUES('758','1','863','2022-12-05','19000.00','','2022-12-22 07:29:54','2022-12-22 07:29:54');
INSERT INTO student_payments VALUES('760','1','876','2022-12-05','20000.00','','2022-12-28 16:22:29','2022-12-28 16:22:29');
INSERT INTO student_payments VALUES('761','1','865','2022-12-05','19000.00','','2022-12-28 16:23:10','2022-12-28 16:23:10');
INSERT INTO student_payments VALUES('762','1','822','2022-12-06','15000.00','','2022-12-28 16:23:42','2022-12-28 16:23:42');
INSERT INTO student_payments VALUES('763','1','874','2022-12-06','15000.00','','2022-12-28 16:24:46','2022-12-28 16:24:46');
INSERT INTO student_payments VALUES('764','1','824','2022-12-06','15000.00','','2022-12-28 16:25:15','2022-12-28 16:25:15');
INSERT INTO student_payments VALUES('765','1','878','2022-12-07','18500.00','','2022-12-28 16:28:41','2022-12-28 16:28:41');
INSERT INTO student_payments VALUES('766','1','845','2022-12-07','18700.00','','2022-12-28 16:46:10','2022-12-28 16:46:10');
INSERT INTO student_payments VALUES('767','1','831','2022-12-07','19000.00','','2022-12-28 16:46:56','2022-12-28 16:46:56');
INSERT INTO student_payments VALUES('768','1','847','2022-12-07','15000.00','','2022-12-28 16:47:24','2022-12-28 16:47:24');
INSERT INTO student_payments VALUES('769','1','827','2022-12-07','15000.00','','2022-12-28 16:48:30','2022-12-28 16:48:30');
INSERT INTO student_payments VALUES('770','1','873','2022-12-08','18500.00','','2022-12-28 16:49:01','2022-12-28 16:49:01');
INSERT INTO student_payments VALUES('771','1','819','2022-12-08','7000.00','','2022-12-28 16:50:03','2022-12-28 16:50:03');
INSERT INTO student_payments VALUES('772','1','858','2022-12-08','19000.00','','2022-12-28 16:50:50','2022-12-28 16:50:50');
INSERT INTO student_payments VALUES('773','1','862','2022-12-08','19000.00','','2022-12-28 16:51:27','2022-12-28 16:51:27');
INSERT INTO student_payments VALUES('774','1','820','2022-12-08','24000.00','','2022-12-28 16:52:29','2022-12-28 16:52:29');
INSERT INTO student_payments VALUES('775','1','815','2022-12-08','5000.00','','2022-12-28 16:53:14','2022-12-28 16:53:14');
INSERT INTO student_payments VALUES('776','1','875','2022-12-08','21500.00','','2022-12-28 16:53:32','2022-12-28 16:53:32');
INSERT INTO student_payments VALUES('777','1','859','2022-12-08','19000.00','','2022-12-28 16:54:56','2022-12-28 16:54:56');
INSERT INTO student_payments VALUES('778','1','855','2022-12-08','21500.00','','2022-12-28 16:59:33','2022-12-28 16:59:33');
INSERT INTO student_payments VALUES('779','1','836','2022-12-09','10000.00','','2022-12-28 17:04:44','2022-12-28 17:04:44');
INSERT INTO student_payments VALUES('780','1','849','2022-12-09','21500.00','','2022-12-28 17:05:13','2022-12-28 17:05:13');
INSERT INTO student_payments VALUES('781','1','856','2022-12-09','21500.00','','2022-12-28 17:09:51','2022-12-28 17:09:51');
INSERT INTO student_payments VALUES('782','1','854','2022-12-09','22000.00','','2022-12-28 17:10:24','2022-12-28 17:10:24');
INSERT INTO student_payments VALUES('783','1','837','2022-12-09','10000.00','','2022-12-28 17:11:01','2022-12-28 17:11:01');
INSERT INTO student_payments VALUES('784','1','834','2022-12-09','19500.00','','2022-12-28 17:11:28','2022-12-28 17:11:28');
INSERT INTO student_payments VALUES('785','1','853','2022-12-09','10000.00','','2022-12-28 17:12:24','2022-12-28 17:12:24');
INSERT INTO student_payments VALUES('786','1','867','2022-12-09','20000.00','','2022-12-28 17:12:53','2022-12-28 17:12:53');
INSERT INTO student_payments VALUES('787','1','850','2022-12-09','19000.00','','2022-12-28 17:13:28','2022-12-28 17:13:28');
INSERT INTO student_payments VALUES('788','1','872','2022-12-09','19000.00','','2022-12-28 17:13:56','2022-12-28 17:13:56');
INSERT INTO student_payments VALUES('789','1','836','2022-12-10','9500.00','','2022-12-28 17:14:36','2022-12-28 17:14:36');
INSERT INTO student_payments VALUES('790','1','833','2022-12-10','10000.00','','2022-12-28 17:15:57','2022-12-28 17:15:57');
INSERT INTO student_payments VALUES('791','1','848','2022-12-10','21500.00','','2022-12-28 17:17:41','2022-12-28 17:17:41');
INSERT INTO student_payments VALUES('792','1','823','2022-12-10','15000.00','','2022-12-28 17:18:18','2022-12-28 17:18:18');
INSERT INTO student_payments VALUES('793','1','844','2022-12-13','18500.00','','2022-12-28 17:18:46','2022-12-28 17:18:46');
INSERT INTO student_payments VALUES('794','1','857','2022-12-13','19000.00','','2022-12-28 17:19:11','2022-12-28 17:19:11');
INSERT INTO student_payments VALUES('795','1','837','2022-12-18','10000.00','','2022-12-28 17:19:42','2022-12-28 17:19:42');
INSERT INTO student_payments VALUES('796','1','819','2022-12-19','20000.00','','2022-12-28 17:20:13','2022-12-28 17:20:13');
INSERT INTO student_payments VALUES('797','1','910','2023-01-01','20000.00','','2023-01-06 10:09:45','2023-01-06 10:09:45');
INSERT INTO student_payments VALUES('798','1','902','2023-01-01','19000.00','','2023-01-06 10:10:16','2023-01-06 10:10:16');
INSERT INTO student_payments VALUES('799','1','900','2023-01-01','19000.00','','2023-01-06 10:10:42','2023-01-06 10:10:42');
INSERT INTO student_payments VALUES('800','1','888','2023-01-01','21000.00','','2023-01-06 10:11:21','2023-01-06 10:11:21');
INSERT INTO student_payments VALUES('801','1','891','2023-01-01','21000.00','','2023-01-06 10:11:42','2023-01-06 10:11:42');
INSERT INTO student_payments VALUES('802','1','929','2023-01-01','12000.00','','2023-01-06 10:12:36','2023-01-06 10:12:36');
INSERT INTO student_payments VALUES('803','1','871','2022-12-21','15000.00','','2023-01-06 10:13:17','2023-01-06 10:13:17');
INSERT INTO student_payments VALUES('804','1','869','2022-12-21','13000.00','','2023-01-06 10:13:45','2023-01-06 10:13:45');
INSERT INTO student_payments VALUES('805','1','884','2023-01-01','17000.00','','2023-01-06 10:14:22','2023-01-06 10:14:22');
INSERT INTO student_payments VALUES('806','1','880','2023-01-01','20000.00','','2023-01-06 10:15:08','2023-01-06 10:15:08');
INSERT INTO student_payments VALUES('807','1','819','2023-01-01','9000.00','','2023-01-06 10:22:57','2023-01-06 10:22:57');
INSERT INTO student_payments VALUES('808','1','912','2023-01-03','19000.00','','2023-01-06 10:23:26','2023-01-06 10:23:26');
INSERT INTO student_payments VALUES('809','1','905','2023-01-03','19000.00','','2023-01-06 10:23:58','2023-01-06 10:23:58');
INSERT INTO student_payments VALUES('810','1','889','2023-01-04','19000.00','','2023-01-06 10:24:21','2023-01-06 10:24:21');
INSERT INTO student_payments VALUES('811','1','899','2023-01-04','19000.00','','2023-01-06 10:24:51','2023-01-06 10:24:51');
INSERT INTO student_payments VALUES('812','1','895','2023-01-04','19500.00','','2023-01-06 10:25:31','2023-01-06 10:25:31');
INSERT INTO student_payments VALUES('813','1','922','2023-01-04','19000.00','','2023-01-06 10:26:33','2023-01-06 10:26:33');
INSERT INTO student_payments VALUES('814','1','932','2023-01-04','21500.00','','2023-01-06 10:29:55','2023-01-06 10:29:55');
INSERT INTO student_payments VALUES('815','1','873','2023-01-04','3000.00','','2023-01-06 10:30:47','2023-01-06 10:30:47');
INSERT INTO student_payments VALUES('816','1','894','2023-01-04','19000.00','','2023-01-06 10:31:47','2023-01-06 10:31:47');
INSERT INTO student_payments VALUES('817','1','911','2023-01-04','20000.00','','2023-01-06 10:32:37','2023-01-06 10:32:37');
INSERT INTO student_payments VALUES('818','1','939','2023-01-04','37000.00','','2023-01-06 10:46:35','2023-01-06 10:46:35');
INSERT INTO student_payments VALUES('819','1','897','2023-01-04','20000.00','','2023-01-06 10:47:32','2023-01-06 10:47:32');
INSERT INTO student_payments VALUES('820','1','890','2023-01-05','19000.00','','2023-01-06 10:48:27','2023-01-06 10:48:27');
INSERT INTO student_payments VALUES('821','1','916','2023-01-05','19000.00','','2023-01-06 10:48:56','2023-01-06 10:48:56');
INSERT INTO student_payments VALUES('822','1','913','2023-01-05','20000.00','','2023-01-06 10:49:27','2023-01-06 10:49:27');
INSERT INTO student_payments VALUES('823','1','892','2023-01-05','5500.00','','2023-01-06 10:49:55','2023-01-06 10:49:55');
INSERT INTO student_payments VALUES('824','1','882','2023-01-06','15000.00','','2023-01-06 10:50:14','2023-01-06 10:50:14');
INSERT INTO student_payments VALUES('825','1','881','2023-01-06','15000.00','','2023-01-06 10:50:37','2023-01-06 10:50:37');
INSERT INTO student_payments VALUES('826','1','927','2023-01-06','20000.00','','2023-01-06 10:51:06','2023-01-06 10:51:06');
INSERT INTO student_payments VALUES('827','1','923','2023-01-06','19000.00','','2023-01-06 16:25:05','2023-01-06 16:25:05');
INSERT INTO student_payments VALUES('828','1','909','2023-01-07','19000.00','','2023-01-07 06:28:44','2023-01-07 06:28:44');
INSERT INTO student_payments VALUES('829','1','931','2023-01-07','19000.00','','2023-01-07 16:10:47','2023-01-07 16:10:47');
INSERT INTO student_payments VALUES('830','1','935','2023-01-07','20000.00','','2023-01-07 16:12:34','2023-01-07 16:12:34');
INSERT INTO student_payments VALUES('831','1','819','2023-01-08','7000.00','','2023-01-09 14:29:54','2023-01-09 14:29:54');
INSERT INTO student_payments VALUES('832','1','938','2023-01-08','16000.00','','2023-01-09 14:31:04','2023-01-09 14:31:04');
INSERT INTO student_payments VALUES('833','1','915','2023-01-10','21500.00','','2023-01-09 19:02:26','2023-01-09 19:02:26');
INSERT INTO student_payments VALUES('834','1','898','2023-01-10','26000.00','','2023-01-10 14:31:55','2023-01-10 14:31:55');
INSERT INTO student_payments VALUES('835','1','908','2023-01-10','21500.00','','2023-01-10 17:43:47','2023-01-10 17:43:47');
INSERT INTO student_payments VALUES('836','1','907','2023-01-10','21500.00','','2023-01-10 17:49:04','2023-01-10 17:49:04');
INSERT INTO student_payments VALUES('837','1','896','2023-01-19','15000.00','','2023-01-20 11:42:17','2023-01-20 11:42:17');
INSERT INTO student_payments VALUES('838','1','924','2023-01-07','19000.00','','2023-01-20 11:42:59','2023-01-20 11:42:59');
INSERT INTO student_payments VALUES('839','1','883','2023-01-08','15000.00','','2023-01-20 11:43:57','2023-01-20 11:43:57');
INSERT INTO student_payments VALUES('840','1','921','2023-01-09','19000.00','','2023-01-20 11:44:45','2023-01-20 11:44:45');
INSERT INTO student_payments VALUES('841','1','892','2023-01-10','14000.00','','2023-01-20 11:46:05','2023-01-20 11:46:05');
INSERT INTO student_payments VALUES('842','1','906','2023-01-11','15000.00','','2023-01-20 11:47:20','2023-01-20 11:47:20');
INSERT INTO student_payments VALUES('843','1','914','2023-01-11','21500.00','','2023-01-20 11:48:03','2023-01-20 11:48:03');
INSERT INTO student_payments VALUES('844','1','893','2023-01-11','19500.00','','2023-01-20 11:48:46','2023-01-20 11:48:46');
INSERT INTO student_payments VALUES('845','1','904','2023-01-11','18700.00','','2023-01-20 11:49:25','2023-01-20 11:49:25');
INSERT INTO student_payments VALUES('846','1','919','2023-01-11','18500.00','','2023-01-20 11:50:19','2023-01-20 11:50:19');
INSERT INTO student_payments VALUES('847','1','903','2023-01-11','18500.00','','2023-01-20 11:51:08','2023-01-20 11:51:08');
INSERT INTO student_payments VALUES('848','1','918','2023-01-11','19000.00','','2023-01-20 11:51:48','2023-01-20 11:51:48');
INSERT INTO student_payments VALUES('849','1','901','2023-01-12','19000.00','','2023-01-24 14:16:33','2023-01-24 14:16:33');
INSERT INTO student_payments VALUES('850','1','887','2023-01-14','19000.00','','2023-01-24 14:19:44','2023-01-24 14:19:44');
INSERT INTO student_payments VALUES('851','1','940','2023-01-14','10000.00','','2023-01-24 14:20:29','2023-01-24 14:20:29');
INSERT INTO student_payments VALUES('852','1','879','2023-01-16','24000.00','','2023-01-24 14:21:17','2023-01-24 14:21:17');
INSERT INTO student_payments VALUES('853','1','941','2023-01-14','10000.00','','2023-01-24 14:55:47','2023-01-24 14:55:47');
INSERT INTO student_payments VALUES('854','1','928','2023-01-19','15000.00','','2023-01-24 14:56:30','2023-01-24 14:56:30');
INSERT INTO student_payments VALUES('855','1','930','2023-01-19','15000.00','','2023-01-24 14:56:58','2023-01-24 14:56:58');
INSERT INTO student_payments VALUES('856','1','926','2023-01-19','17000.00','','2023-01-24 14:57:31','2023-01-24 14:57:31');
INSERT INTO student_payments VALUES('857','1','886','2023-01-04','15000.00','','2023-01-24 15:10:05','2023-01-24 15:10:05');
INSERT INTO student_payments VALUES('858','1','933','2023-01-06','15000.00','','2023-01-24 15:12:13','2023-01-24 15:12:13');
INSERT INTO student_payments VALUES('859','1','934','2023-01-07','21500.00','','2023-01-24 15:17:11','2023-01-24 15:17:11');
INSERT INTO student_payments VALUES('860','1','920','2023-01-06','19000.00','','2023-01-26 15:01:06','2023-01-26 15:01:06');
INSERT INTO student_payments VALUES('861','1','925','2023-01-07','21500.00','','2023-01-26 15:08:28','2023-01-26 15:08:28');
INSERT INTO student_payments VALUES('862','1','913','2023-01-12','2000.00','','2023-01-26 15:09:20','2023-01-26 15:09:20');
INSERT INTO student_payments VALUES('863','1','991','2023-02-01','12000.00','','2023-02-03 11:55:26','2023-02-03 11:55:26');
INSERT INTO student_payments VALUES('864','1','972','2023-02-01','23000.00','','2023-02-03 11:56:04','2023-02-03 11:56:04');
INSERT INTO student_payments VALUES('865','1','964','2023-02-01','19000.00','','2023-02-03 11:57:08','2023-02-03 11:57:08');
INSERT INTO student_payments VALUES('866','1','967','2023-02-01','19000.00','','2023-02-03 11:57:53','2023-02-03 11:57:53');
INSERT INTO student_payments VALUES('867','1','957','2023-02-01','10000.00','','2023-02-03 11:58:49','2023-02-03 11:58:49');
INSERT INTO student_payments VALUES('868','1','884','2023-02-01','2500.00','','2023-02-03 11:59:44','2023-02-03 11:59:44');
INSERT INTO student_payments VALUES('869','1','947','2023-02-01','19500.00','','2023-02-03 12:00:21','2023-02-03 12:00:21');
INSERT INTO student_payments VALUES('870','1','961','2023-02-01','19000.00','','2023-02-03 12:04:40','2023-02-03 12:04:40');
INSERT INTO student_payments VALUES('871','1','949','2023-02-01','19000.00','','2023-02-03 12:05:20','2023-02-03 12:05:20');
INSERT INTO student_payments VALUES('872','1','926','2023-02-01','3000.00','','2023-02-03 12:05:53','2023-02-03 12:05:53');
INSERT INTO student_payments VALUES('873','1','988','2023-02-01','20000.00','','2023-02-03 12:06:21','2023-02-03 12:06:21');
INSERT INTO student_payments VALUES('874','1','965','2023-02-01','18500.00','','2023-02-03 12:07:10','2023-02-03 12:07:10');
INSERT INTO student_payments VALUES('875','1','962','2023-02-01','15000.00','','2023-02-03 12:08:02','2023-02-03 12:08:02');
INSERT INTO student_payments VALUES('876','1','984','2023-02-01','19000.00','','2023-02-03 12:08:48','2023-02-03 12:08:48');
INSERT INTO student_payments VALUES('877','1','943','2023-02-02','20000.00','','2023-02-03 12:09:16','2023-02-03 12:09:16');
INSERT INTO student_payments VALUES('878','1','989','2023-02-02','20000.00','','2023-02-03 12:10:46','2023-02-03 12:10:46');
INSERT INTO student_payments VALUES('879','1','953','2023-02-03','21000.00','','2023-02-03 13:58:27','2023-02-03 13:58:27');
INSERT INTO student_payments VALUES('880','1','950','2023-02-03','21000.00','','2023-02-03 14:00:25','2023-02-03 14:00:25');
INSERT INTO student_payments VALUES('881','1','962','2023-02-09','4000.00','','2023-02-09 08:02:35','2023-02-09 08:02:35');
INSERT INTO student_payments VALUES('882','1','951','2023-02-03','19000.00','','2023-02-09 10:12:46','2023-02-09 10:12:46');
INSERT INTO student_payments VALUES('883','1','948','2023-02-03','15000.00','','2023-02-09 10:13:20','2023-02-09 10:13:20');
INSERT INTO student_payments VALUES('884','1','982','2023-02-04','19000.00','','2023-02-09 10:14:01','2023-02-09 10:14:01');
INSERT INTO student_payments VALUES('885','1','945','2023-02-04','15000.00','','2023-02-09 10:14:42','2023-02-09 10:14:42');
INSERT INTO student_payments VALUES('886','1','973','2023-02-04','20000.00','','2023-02-09 10:15:41','2023-02-09 10:15:41');
INSERT INTO student_payments VALUES('887','1','944','2023-02-04','15000.00','','2023-02-09 10:16:21','2023-02-09 10:16:21');
INSERT INTO student_payments VALUES('888','1','956','2023-02-04','19000.00','','2023-02-09 10:17:00','2023-02-09 10:17:00');
INSERT INTO student_payments VALUES('889','1','995','2023-02-05','15000.00','','2023-02-09 10:17:57','2023-02-09 10:17:57');
INSERT INTO student_payments VALUES('890','1','974','2023-02-05','10000.00','','2023-02-09 10:19:01','2023-02-09 10:19:01');
INSERT INTO student_payments VALUES('891','1','959','2023-02-06','20000.00','','2023-02-09 10:19:47','2023-02-09 10:19:47');
INSERT INTO student_payments VALUES('892','1','983','2023-02-06','19000.00','','2023-02-09 10:20:27','2023-02-09 10:20:27');
INSERT INTO student_payments VALUES('893','1','987','2023-02-06','21500.00','','2023-02-09 10:20:57','2023-02-09 10:20:57');
INSERT INTO student_payments VALUES('894','1','917','2023-01-19','19000.00','','2023-02-09 10:30:26','2023-02-09 10:30:26');
INSERT INTO student_payments VALUES('895','1','979','2023-02-06','19000.00','','2023-02-09 10:31:34','2023-02-09 10:31:34');
INSERT INTO student_payments VALUES('896','1','946','2023-02-06','15000.00','','2023-02-09 12:10:55','2023-02-09 12:10:55');
INSERT INTO student_payments VALUES('897','1','968','2023-02-06','15000.00','','2023-02-09 12:11:32','2023-02-09 12:11:32');
INSERT INTO student_payments VALUES('898','1','977','2023-02-06','20000.00','','2023-02-09 12:12:23','2023-02-09 12:12:23');
INSERT INTO student_payments VALUES('899','1','1000','2023-02-06','21500.00','','2023-02-09 12:13:24','2023-02-09 12:13:24');
INSERT INTO student_payments VALUES('900','1','980','2023-02-06','19000.00','','2023-02-09 12:13:58','2023-02-09 12:13:58');
INSERT INTO student_payments VALUES('901','1','981','2023-02-06','18500.00','','2023-02-09 12:14:34','2023-02-09 12:14:34');
INSERT INTO student_payments VALUES('902','1','969','2023-02-07','21500.00','','2023-02-09 12:15:06','2023-02-09 12:15:06');
INSERT INTO student_payments VALUES('903','1','986','2023-02-07','19000.00','','2023-02-09 12:15:46','2023-02-09 12:15:46');
INSERT INTO student_payments VALUES('904','1','957','2023-02-07','9500.00','','2023-02-09 12:16:20','2023-02-09 12:16:20');
INSERT INTO student_payments VALUES('905','1','942','2023-02-07','24000.00','','2023-02-09 12:17:34','2023-02-09 12:17:34');
INSERT INTO student_payments VALUES('906','1','960','2023-02-07','26000.00','','2023-02-09 12:18:39','2023-02-09 12:18:39');
INSERT INTO student_payments VALUES('907','1','966','2023-02-07','12000.00','','2023-02-09 12:19:24','2023-02-09 12:19:24');
INSERT INTO student_payments VALUES('908','1','1002','2023-02-07','28000.00','','2023-02-09 12:20:00','2023-02-09 12:20:00');
INSERT INTO student_payments VALUES('909','1','971','2023-02-08','19000.00','','2023-02-09 12:20:59','2023-02-09 12:20:59');
INSERT INTO student_payments VALUES('910','1','1003','2023-02-08','17000.00','','2023-02-09 12:21:48','2023-02-09 12:21:48');
INSERT INTO student_payments VALUES('911','1','1004','2023-02-08','18000.00','','2023-02-09 12:22:17','2023-02-09 12:22:17');
INSERT INTO student_payments VALUES('912','1','1001','2023-02-08','19000.00','','2023-02-09 12:24:45','2023-02-09 12:24:45');
INSERT INTO student_payments VALUES('913','1','985','2023-02-08','19000.00','','2023-02-09 12:25:33','2023-02-09 12:25:33');
INSERT INTO student_payments VALUES('914','1','997','2023-02-08','10000.00','','2023-02-09 12:26:35','2023-02-09 12:26:35');
INSERT INTO student_payments VALUES('915','1','975','2023-02-09','19000.00','','2023-02-09 12:27:28','2023-02-09 12:27:28');
INSERT INTO student_payments VALUES('916','1','952','2023-02-09','19000.00','','2023-02-09 12:28:01','2023-02-09 12:28:01');
INSERT INTO student_payments VALUES('917','1','993','2023-02-09','19000.00','','2023-02-09 12:28:45','2023-02-09 12:28:45');
INSERT INTO student_payments VALUES('918','1','970','2023-02-10','21500.00','','2023-02-09 19:43:11','2023-02-09 19:43:11');
INSERT INTO student_payments VALUES('919','1','994','2023-02-10','21500.00','','2023-03-07 18:30:35','2023-03-07 18:30:35');
INSERT INTO student_payments VALUES('920','1','954','2023-02-10','19500.00','','2023-03-07 18:37:57','2023-03-07 18:37:57');
INSERT INTO student_payments VALUES('921','1','974','2023-02-11','9000.00','','2023-03-07 18:38:55','2023-03-07 18:38:55');
INSERT INTO student_payments VALUES('922','1','955','2023-02-11','19500.00','','2023-03-07 18:53:33','2023-03-07 18:53:33');
INSERT INTO student_payments VALUES('923','1','958','2023-02-11','10000.00','','2023-03-07 18:54:44','2023-03-07 18:54:44');
INSERT INTO student_payments VALUES('924','1','939','2023-02-12','1000.00','','2023-03-07 18:55:29','2023-03-07 18:55:29');
INSERT INTO student_payments VALUES('925','1','966','2023-02-13','6700.00','','2023-03-07 18:56:50','2023-03-07 18:56:50');
INSERT INTO student_payments VALUES('926','1','963','2023-02-14','19000.00','','2023-03-07 18:57:58','2023-03-07 18:57:58');
INSERT INTO student_payments VALUES('927','1','740','2023-02-21','2000.00','','2023-03-07 18:58:53','2023-03-07 18:58:53');
INSERT INTO student_payments VALUES('928','1','992','2023-02-21','15000.00','','2023-03-07 18:59:34','2023-03-07 18:59:34');
INSERT INTO student_payments VALUES('929','1','869','2023-03-21','2000.00','','2023-03-07 19:00:17','2023-03-07 19:00:17');
INSERT INTO student_payments VALUES('930','1','990','2023-02-21','15000.00','','2023-03-07 19:01:22','2023-03-07 19:01:22');
INSERT INTO student_payments VALUES('931','1','1006','2023-02-13','20000.00','','2023-03-07 19:05:02','2023-03-07 19:05:02');
INSERT INTO student_payments VALUES('932','1','1005','2023-02-13','15000.00','','2023-03-07 19:06:27','2023-03-07 19:06:27');
INSERT INTO student_payments VALUES('933','1','1008','2023-03-01','20000.00','','2023-03-07 19:17:38','2023-03-07 19:17:38');
INSERT INTO student_payments VALUES('934','1','1037','2023-03-01','22000.00','','2023-03-08 11:00:13','2023-03-08 11:00:13');
INSERT INTO student_payments VALUES('935','1','1032','2023-03-01','19000.00','','2023-03-08 13:05:34','2023-03-08 13:05:34');
INSERT INTO student_payments VALUES('936','1','1021','2023-03-01','19000.00','','2023-03-08 13:06:21','2023-03-08 13:06:21');
INSERT INTO student_payments VALUES('937','1','1012','2023-03-01','19500.00','','2023-03-08 13:11:50','2023-03-08 13:11:50');
INSERT INTO student_payments VALUES('938','1','958','2023-03-01','10000.00','','2023-03-08 13:14:03','2023-03-08 13:14:03');
INSERT INTO student_payments VALUES('939','1','1015','2023-03-01','21000.00','','2023-03-08 13:17:39','2023-03-08 13:17:39');
INSERT INTO student_payments VALUES('940','1','1066','2023-03-02','19000.00','','2023-03-08 13:22:15','2023-03-08 13:22:15');
INSERT INTO student_payments VALUES('941','1','1056','2023-03-02','12000.00','','2023-03-08 13:23:24','2023-03-08 13:23:24');
INSERT INTO student_payments VALUES('942','1','1005','2023-03-02','5000.00','','2023-03-08 13:24:56','2023-03-08 13:24:56');
INSERT INTO student_payments VALUES('943','1','1068','2023-03-02','21500.00','','2023-03-08 13:25:58','2023-03-08 13:25:58');
INSERT INTO student_payments VALUES('944','1','1011','2023-03-02','15000.00','','2023-03-08 13:27:48','2023-03-08 13:27:48');
INSERT INTO student_payments VALUES('945','1','1009','2023-03-03','15000.00','','2023-03-08 13:29:11','2023-03-08 13:29:11');
INSERT INTO student_payments VALUES('946','1','1049','2023-03-03','19000.00','','2023-03-08 13:31:34','2023-03-08 13:31:34');
INSERT INTO student_payments VALUES('947','1','1022','2023-03-03','19500.00','','2023-03-08 13:34:24','2023-03-08 13:34:24');
INSERT INTO student_payments VALUES('948','1','1023','2023-03-03','20000.00','','2023-03-08 13:36:41','2023-03-08 13:36:41');
INSERT INTO student_payments VALUES('949','1','1051','2023-03-03','19000.00','','2023-03-08 13:40:35','2023-03-08 13:40:35');
INSERT INTO student_payments VALUES('950','1','1013','2023-03-03','15000.00','','2023-03-08 13:49:43','2023-03-08 13:49:43');
INSERT INTO student_payments VALUES('951','1','1052','2023-03-05','21500.00','','2023-03-08 13:50:36','2023-03-08 13:50:36');
INSERT INTO student_payments VALUES('952','1','786','2023-03-05','1000.00','','2023-03-08 13:52:49','2023-03-08 13:52:49');
INSERT INTO student_payments VALUES('953','1','1033','2023-03-05','15000.00','','2023-03-08 13:53:36','2023-03-08 13:53:36');
INSERT INTO student_payments VALUES('954','1','1062','2023-03-05','20000.00','','2023-03-08 13:55:27','2023-03-08 13:55:27');
INSERT INTO student_payments VALUES('955','1','1027','2023-03-06','19000.00','','2023-03-09 07:04:05','2023-03-09 07:04:05');
INSERT INTO student_payments VALUES('956','1','1010','2023-03-06','15000.00','','2023-03-09 07:04:58','2023-03-09 07:04:58');
INSERT INTO student_payments VALUES('957','1','1034','2023-03-06','21500.00','','2023-03-09 07:05:42','2023-03-09 07:05:42');
INSERT INTO student_payments VALUES('958','1','1035','2023-03-06','21500.00','','2023-03-09 07:06:24','2023-03-09 07:06:24');
INSERT INTO student_payments VALUES('959','1','1046','2023-03-06','18500.00','','2023-03-09 07:07:19','2023-03-09 07:07:19');
INSERT INTO student_payments VALUES('960','1','1014','2023-03-07','19000.00','','2023-03-09 07:10:55','2023-03-09 07:10:55');
INSERT INTO student_payments VALUES('961','1','1039','2023-03-08','19000.00','','2023-03-09 07:11:44','2023-03-09 07:11:44');
INSERT INTO student_payments VALUES('962','1','1045','2023-03-08','19000.00','','2023-03-09 07:12:38','2023-03-09 07:12:38');
INSERT INTO student_payments VALUES('963','1','1016','2023-03-08','19000.00','','2023-03-09 07:17:26','2023-03-09 07:17:26');
INSERT INTO student_payments VALUES('964','1','1060','2023-03-08','15000.00','','2023-03-09 07:18:14','2023-03-09 07:18:14');
INSERT INTO student_payments VALUES('965','1','1041','2023-03-08','21500.00','','2023-03-09 07:19:35','2023-03-09 07:19:35');
INSERT INTO student_payments VALUES('966','1','1040','2023-03-08','22000.00','','2023-03-09 07:20:46','2023-03-09 07:20:46');
INSERT INTO student_payments VALUES('967','1','976','2023-02-13','21500.00','','2023-03-09 07:23:21','2023-03-09 07:23:21');
INSERT INTO student_payments VALUES('968','1','975','2023-02-09','3000.00','','2023-03-09 07:26:09','2023-03-09 07:26:09');
INSERT INTO student_payments VALUES('969','1','1003','2023-02-08','1000.00','','2023-03-09 07:27:27','2023-03-09 07:27:27');
INSERT INTO student_payments VALUES('970','1','1063','2023-03-08','18000.00','','2023-03-09 07:28:12','2023-03-09 07:28:12');
INSERT INTO student_payments VALUES('971','1','1067','2023-03-08','18000.00','','2023-03-09 07:29:32','2023-03-09 07:29:32');
INSERT INTO student_payments VALUES('972','1','1007','2023-03-08','24000.00','','2023-03-09 07:30:31','2023-03-09 07:30:31');
INSERT INTO student_payments VALUES('973','1','1028','2023-03-08','10000.00','','2023-03-09 07:32:27','2023-03-09 07:32:27');
INSERT INTO student_payments VALUES('974','1','1017','2023-03-08','19000.00','','2023-03-09 07:33:10','2023-03-09 07:33:10');
INSERT INTO student_payments VALUES('975','1','1047','2023-03-08','19000.00','','2023-03-09 07:34:07','2023-03-09 07:34:07');
INSERT INTO student_payments VALUES('976','1','1036','2023-03-08','19000.00','','2023-03-09 07:34:52','2023-03-09 07:34:52');
INSERT INTO student_payments VALUES('977','1','1065','2023-03-08','21500.00','','2023-03-09 07:35:28','2023-03-09 07:35:28');
INSERT INTO student_payments VALUES('978','1','1048','2023-03-08','19000.00','','2023-03-09 08:25:44','2023-03-09 08:25:44');
INSERT INTO student_payments VALUES('979','1','1064','2023-03-08','18000.00','','2023-03-09 08:27:58','2023-03-09 08:27:58');
INSERT INTO student_payments VALUES('980','1','1044','2023-03-08','19000.00','','2023-03-09 09:57:19','2023-03-09 09:57:19');
INSERT INTO student_payments VALUES('981','1','1061','2023-03-08','21500.00','','2023-03-09 09:59:52','2023-03-09 09:59:52');
INSERT INTO student_payments VALUES('982','1','1025','2023-03-08','26000.00','','2023-03-09 10:01:46','2023-03-09 10:01:46');
INSERT INTO student_payments VALUES('983','1','1058','2023-03-08','19000.00','','2023-03-09 10:06:22','2023-03-09 10:06:22');
INSERT INTO student_payments VALUES('984','1','1043','2023-03-08','19000.00','','2023-03-09 10:09:51','2023-03-09 10:09:51');
INSERT INTO student_payments VALUES('985','1','1050','2023-03-08','19000.00','','2023-03-09 10:10:42','2023-03-09 10:10:42');
INSERT INTO student_payments VALUES('986','1','978','2023-03-08','19000.00','','2023-03-09 10:22:05','2023-03-09 10:22:05');
INSERT INTO student_payments VALUES('987','1','977','2023-03-08','1500.00','','2023-03-09 10:27:12','2023-03-09 10:27:12');
INSERT INTO student_payments VALUES('988','1','1042','2023-03-08','500.00','','2023-03-09 10:28:04','2023-03-09 10:28:04');
INSERT INTO student_payments VALUES('989','1','1019','2023-03-10','19500.00','','2023-03-12 08:18:56','2023-03-12 08:18:56');
INSERT INTO student_payments VALUES('990','1','1054','2023-03-10','20000.00','','2023-03-12 08:25:11','2023-03-12 08:25:11');
INSERT INTO student_payments VALUES('991','1','1042','2023-03-10','21000.00','','2023-03-12 08:26:01','2023-03-12 08:26:01');
INSERT INTO student_payments VALUES('992','1','1020','2023-03-10','10000.00','','2023-03-12 08:37:03','2023-03-12 08:37:03');
INSERT INTO student_payments VALUES('993','1','1030','2023-03-13','18500.00','','2023-03-14 12:25:43','2023-03-14 12:25:43');
INSERT INTO student_payments VALUES('994','1','1018','2023-03-01','21000.00','','2023-04-02 07:18:57','2023-04-02 07:18:57');
INSERT INTO student_payments VALUES('995','1','1024','2023-03-03','20000.00','','2023-04-02 07:20:53','2023-04-02 07:20:53');
INSERT INTO student_payments VALUES('996','1','1029','2023-03-01','19000.00','','2023-04-02 07:22:04','2023-04-02 07:22:04');
INSERT INTO student_payments VALUES('997','1','1026','2023-03-01','19000.00','','2023-04-02 07:22:53','2023-04-02 07:22:53');
INSERT INTO student_payments VALUES('998','1','1053','2023-03-23','10000.00','','2023-04-02 07:25:02','2023-04-02 07:25:02');
INSERT INTO student_payments VALUES('999','1','1038','2023-03-05','22000.00','','2023-04-02 07:26:05','2023-04-02 07:26:05');
INSERT INTO student_payments VALUES('1000','1','1059','2023-03-05','21500.00','','2023-04-02 07:27:54','2023-04-02 07:27:54');
INSERT INTO student_payments VALUES('1001','1','1133','2023-03-18','9350.00','','2023-04-02 08:10:29','2023-04-02 08:10:29');
INSERT INTO student_payments VALUES('1002','1','1057','2023-03-21','15000.00','','2023-04-02 08:16:01','2023-04-02 08:16:01');
INSERT INTO student_payments VALUES('1003','1','1055','2023-03-15','15000.00','','2023-04-02 08:29:21','2023-04-02 08:29:21');
INSERT INTO student_payments VALUES('1004','1','1071','2023-04-02','20000.00','','2023-04-02 14:50:50','2023-04-02 14:50:50');
INSERT INTO student_payments VALUES('1005','1','1075','2023-04-01','19500.00','','2023-04-02 15:11:06','2023-04-02 15:11:06');
INSERT INTO student_payments VALUES('1006','1','1084','2023-04-03','19000.00','','2023-04-03 16:05:39','2023-04-03 16:05:39');
INSERT INTO student_payments VALUES('1007','1','1092','2023-04-03','19000.00','','2023-04-03 16:08:41','2023-04-03 16:08:41');
INSERT INTO student_payments VALUES('1008','1','1112','2023-04-03','19000.00','','2023-04-03 16:10:46','2023-04-03 16:10:46');
INSERT INTO student_payments VALUES('1009','1','1097','2023-04-04','21500.00','','2023-04-04 08:43:55','2023-04-04 08:43:55');
INSERT INTO student_payments VALUES('1010','1','1078','2023-04-04','21000.00','','2023-04-04 11:14:06','2023-04-04 11:14:06');
INSERT INTO student_payments VALUES('1011','1','1079','2023-04-04','19000.00','','2023-04-04 17:01:52','2023-04-04 17:01:52');
INSERT INTO student_payments VALUES('1012','1','1076','2023-04-04','15000.00','','2023-04-04 17:32:50','2023-04-04 17:32:50');
INSERT INTO student_payments VALUES('1013','1','1088','2023-04-04','26000.00','','2023-04-04 17:34:56','2023-04-04 17:34:56');
INSERT INTO student_payments VALUES('1014','1','1119','2023-04-01','12000.00','','2023-04-04 17:44:08','2023-04-04 17:44:08');
INSERT INTO student_payments VALUES('1015','1','1101','2023-04-01','22000.00','','2023-04-04 17:48:45','2023-04-04 17:48:45');
INSERT INTO student_payments VALUES('1016','1','1090','2023-04-01','19000.00','','2023-04-04 17:51:57','2023-04-04 17:51:57');
INSERT INTO student_payments VALUES('1017','1','1053','2023-04-01','10000.00','','2023-04-04 17:54:10','2023-04-04 17:54:10');
INSERT INTO student_payments VALUES('1018','1','1116','2023-04-03','20000.00','','2023-04-04 17:54:46','2023-04-04 17:54:46');
INSERT INTO student_payments VALUES('1019','1','1096','2023-04-05','10000.00','','2023-04-05 14:05:27','2023-04-05 14:05:27');
INSERT INTO student_payments VALUES('1020','1','1117','2023-04-05','20000.00','','2023-04-05 14:06:07','2023-04-05 14:06:07');
INSERT INTO student_payments VALUES('1021','1','1102','2023-04-05','19000.00','','2023-04-05 14:07:09','2023-04-05 14:07:09');
INSERT INTO student_payments VALUES('1022','1','1091','2023-04-05','19000.00','','2023-04-05 14:07:35','2023-04-05 14:07:35');
INSERT INTO student_payments VALUES('1023','1','1081','2023-04-05','21000.00','','2023-04-05 14:08:00','2023-04-05 14:08:00');
INSERT INTO student_payments VALUES('1024','1','1077','2023-04-05','19000.00','','2023-04-05 14:08:46','2023-04-05 14:08:46');
INSERT INTO student_payments VALUES('1025','1','1080','2023-04-05','19000.00','','2023-04-05 14:09:20','2023-04-05 14:09:20');
INSERT INTO student_payments VALUES('1026','1','1106','2023-04-05','19000.00','','2023-04-06 07:21:18','2023-04-06 07:21:18');
INSERT INTO student_payments VALUES('1027','1','1122','2023-04-05','21500.00','','2023-04-06 07:21:48','2023-04-06 07:21:48');
INSERT INTO student_payments VALUES('1028','1','1107','2023-04-05','19000.00','','2023-04-06 07:22:29','2023-04-06 07:22:29');
INSERT INTO student_payments VALUES('1029','1','1113','2023-04-06','19000.00','','2023-04-06 12:07:27','2023-04-06 12:07:27');
INSERT INTO student_payments VALUES('1030','1','1096','2023-04-06','5000.00','','2023-04-07 10:25:59','2023-04-07 10:25:59');
INSERT INTO student_payments VALUES('1031','1','1110','2023-04-05','19000.00','','2023-04-07 10:26:31','2023-04-07 10:26:31');
INSERT INTO student_payments VALUES('1032','1','996','2023-02-10','21500.00','','2023-04-07 10:30:21','2023-04-07 10:30:21');
INSERT INTO student_payments VALUES('1033','1','1124','2023-04-06','21500.00','','2023-04-07 10:30:52','2023-04-07 10:30:52');
INSERT INTO student_payments VALUES('1034','1','1123','2023-04-06','15000.00','','2023-04-07 10:31:30','2023-04-07 10:31:30');
INSERT INTO student_payments VALUES('1035','1','896','2023-01-28','5000.00','','2023-04-07 11:17:47','2023-04-07 11:17:47');
INSERT INTO student_payments VALUES('1036','1','1089','2023-04-04','18000.00','','2023-04-07 11:20:50','2023-04-07 11:20:50');
INSERT INTO student_payments VALUES('1037','1','1028','2023-03-15','9000.00','','2023-04-07 11:22:13','2023-04-07 11:22:13');
INSERT INTO student_payments VALUES('1038','1','1114','2023-04-06','19000.00','','2023-04-07 11:57:42','2023-04-07 11:57:42');
INSERT INTO student_payments VALUES('1039','1','355','2022-05-28','0.00','','2023-04-07 12:12:51','2023-04-07 12:12:51');
INSERT INTO student_payments VALUES('1040','1','1100','2023-04-01','22000.00','','2023-04-07 12:18:41','2023-04-07 12:18:41');
INSERT INTO student_payments VALUES('1041','1','1020','2023-03-13','9500.00','','2023-04-07 12:30:10','2023-04-07 12:30:10');
INSERT INTO student_payments VALUES('1042','1','290','2022-08-11','3000.00','','2023-04-07 12:34:04','2023-04-07 12:34:04');
INSERT INTO student_payments VALUES('1043','1','1121','2023-03-31','19000.00','','2023-04-07 14:44:37','2023-04-07 14:44:37');
INSERT INTO student_payments VALUES('1044','1','1099','2023-04-07','19000.00','','2023-04-07 14:45:01','2023-04-07 14:45:01');
INSERT INTO student_payments VALUES('1045','1','1128','2023-04-07','21500.00','','2023-04-07 14:46:24','2023-04-07 14:46:24');
INSERT INTO student_payments VALUES('1046','1','1135','2023-04-05','21500.00','','2023-04-07 15:22:27','2023-04-07 15:22:27');
INSERT INTO student_payments VALUES('1047','1','1109','2023-04-07','18500.00','','2023-04-08 07:41:19','2023-04-08 07:41:19');
INSERT INTO student_payments VALUES('1048','1','1115','2023-04-07','21500.00','','2023-04-08 07:42:25','2023-04-08 07:42:25');
INSERT INTO student_payments VALUES('1049','1','1072','2023-04-08','15000.00','','2023-04-08 07:43:50','2023-04-08 07:43:50');
INSERT INTO student_payments VALUES('1050','1','1073','2023-04-08','15000.00','','2023-04-08 07:44:49','2023-04-08 07:44:49');
INSERT INTO student_payments VALUES('1051','1','1074','2023-04-08','15000.00','','2023-04-08 07:45:20','2023-04-08 07:45:20');
INSERT INTO student_payments VALUES('1052','1','1137','2023-04-09','35700.00','','2023-04-09 11:20:42','2023-04-09 11:20:42');
INSERT INTO student_payments VALUES('1053','1','1138','2023-04-09','39000.00','','2023-04-09 21:32:34','2023-04-09 21:32:34');
INSERT INTO student_payments VALUES('1054','1','1131','2023-04-08','21500.00','','2023-04-09 21:33:05','2023-04-09 21:33:05');
INSERT INTO student_payments VALUES('1055','1','1095','2023-04-10','19000.00','','2023-04-10 15:42:08','2023-04-10 15:42:08');
INSERT INTO student_payments VALUES('1056','1','1105','2023-04-10','21500.00','','2023-04-11 00:07:51','2023-04-11 00:07:51');
INSERT INTO student_payments VALUES('1057','1','1093','2023-04-11','18500.00','','2023-04-11 15:29:53','2023-04-11 15:29:53');
INSERT INTO student_payments VALUES('1058','1','1082','2023-04-11','19500.00','','2023-04-12 18:16:49','2023-04-12 18:16:49');
INSERT INTO student_payments VALUES('1059','1','1083','2023-04-11','19500.00','','2023-04-12 18:17:52','2023-04-12 18:17:52');
INSERT INTO student_payments VALUES('1060','1','1085','2023-04-11','18500.00','','2023-04-12 18:18:28','2023-04-12 18:18:28');
INSERT INTO student_payments VALUES('1061','1','1140','2023-04-12','20000.00','','2023-04-12 18:23:16','2023-04-12 18:23:16');
INSERT INTO student_payments VALUES('1062','1','1086','2023-04-12','10000.00','','2023-04-12 18:24:17','2023-04-12 18:24:17');
INSERT INTO student_payments VALUES('1063','1','1141','2023-04-12','24500.00','','2023-04-12 18:27:25','2023-04-12 18:27:25');
INSERT INTO student_payments VALUES('1064','1','1111','2023-04-11','19000.00','','2023-04-12 18:28:13','2023-04-12 18:28:13');
INSERT INTO student_payments VALUES('1065','1','1103','2023-04-10','20000.00','','2023-04-12 18:29:04','2023-04-12 18:29:04');
INSERT INTO student_payments VALUES('1066','1','1108','2023-04-10','19000.00','','2023-04-12 18:30:00','2023-04-12 18:30:00');
INSERT INTO student_payments VALUES('1067','1','1129','2023-04-10','19000.00','','2023-04-12 18:30:41','2023-04-12 18:30:41');
INSERT INTO student_payments VALUES('1068','1','1087','2023-04-08','10000.00','','2023-04-12 18:31:38','2023-04-12 18:31:38');
INSERT INTO student_payments VALUES('1069','1','1098','2023-04-14','19000.00','','2023-04-14 09:20:39','2023-04-14 09:20:39');
INSERT INTO student_payments VALUES('1070','1','1104','2023-04-16','21500.00','','2023-04-16 14:47:08','2023-04-16 14:47:08');
INSERT INTO student_payments VALUES('1071','1','1120','2023-04-18','15000.00','','2023-04-27 08:18:10','2023-04-27 08:18:10');
INSERT INTO student_payments VALUES('1072','1','1118','2023-04-13','15000.00','','2023-04-27 08:19:13','2023-04-27 08:19:13');
INSERT INTO student_payments VALUES('1073','1','1086','2023-04-26','10000.00','','2023-04-28 05:54:22','2023-04-28 05:54:22');
INSERT INTO student_payments VALUES('1074','1','1087','2023-04-13','10000.00','','2023-04-28 05:55:46','2023-04-28 05:55:46');
INSERT INTO student_payments VALUES('1075','1','1089','2023-04-16','1000.00','','2023-04-28 06:01:09','2023-04-28 06:01:09');
INSERT INTO student_payments VALUES('1076','1','1139','2023-04-16','20000.00','','2023-04-28 06:02:41','2023-04-28 06:02:41');
INSERT INTO student_payments VALUES('1077','1','1147','2023-05-01','19500.00','','2023-05-07 12:14:28','2023-05-07 12:14:28');
INSERT INTO student_payments VALUES('1078','1','1171','2023-05-01','18000.00','','2023-05-07 12:16:32','2023-05-07 12:16:32');
INSERT INTO student_payments VALUES('1079','1','1172','2023-05-01','20000.00','','2023-05-07 12:17:15','2023-05-07 12:17:15');
INSERT INTO student_payments VALUES('1080','1','1143','2023-05-07','21000.00','','2023-05-07 17:28:03','2023-05-07 17:28:03');
INSERT INTO student_payments VALUES('1081','1','1182','2023-05-01','19000.00','','2023-05-08 17:41:59','2023-05-08 17:41:59');
INSERT INTO student_payments VALUES('1082','1','1178','2023-05-08','19000.00','','2023-05-08 17:44:23','2023-05-08 17:44:23');
INSERT INTO student_payments VALUES('1083','1','1152','2023-05-08','19000.00','','2023-05-08 17:45:43','2023-05-08 17:45:43');
INSERT INTO student_payments VALUES('1084','1','1181','2023-05-08','19000.00','','2023-05-08 17:46:04','2023-05-08 17:46:04');
INSERT INTO student_payments VALUES('1085','1','1176','2023-05-09','21500.00','','2023-05-09 13:26:59','2023-05-09 13:26:59');
INSERT INTO student_payments VALUES('1086','1','1164','2023-05-01','16000.00','','2023-05-11 09:44:18','2023-05-11 09:44:18');
INSERT INTO student_payments VALUES('1087','1','1166','2023-05-03','19000.00','','2023-05-11 09:44:55','2023-05-11 09:44:55');
INSERT INTO student_payments VALUES('1088','1','1149','2023-05-03','19000.00','','2023-05-11 09:45:22','2023-05-11 09:45:22');
INSERT INTO student_payments VALUES('1089','1','1160','2023-05-06','26000.00','','2023-05-11 09:45:57','2023-05-11 09:45:57');
INSERT INTO student_payments VALUES('1090','1','1144','2023-05-03','15000.00','','2023-05-11 09:48:30','2023-05-11 09:48:30');
INSERT INTO student_payments VALUES('1091','1','1146','2023-05-03','15000.00','','2023-05-11 09:49:03','2023-05-11 09:49:03');
INSERT INTO student_payments VALUES('1092','1','1145','2023-05-04','15000.00','','2023-05-11 09:52:42','2023-05-11 09:52:42');
INSERT INTO student_payments VALUES('1093','1','1161','2023-05-05','17000.00','','2023-05-11 09:53:22','2023-05-11 09:53:22');
INSERT INTO student_payments VALUES('1094','1','1156','2023-05-05','19000.00','','2023-05-11 09:54:37','2023-05-11 09:54:37');
INSERT INTO student_payments VALUES('1095','1','1194','2023-05-05','15000.00','','2023-05-11 09:55:04','2023-05-11 09:55:04');
INSERT INTO student_payments VALUES('1096','1','1162','2023-05-05','19000.00','','2023-05-11 09:56:06','2023-05-11 09:56:06');
INSERT INTO student_payments VALUES('1097','1','1201','2023-05-05','21500.00','','2023-05-11 09:56:46','2023-05-11 09:56:46');
INSERT INTO student_payments VALUES('1098','1','1174','2023-05-06','22000.00','','2023-05-11 09:57:41','2023-05-11 09:57:41');
INSERT INTO student_payments VALUES('1099','1','1173','2023-05-06','19000.00','','2023-05-11 09:58:46','2023-05-11 09:58:46');
INSERT INTO student_payments VALUES('1100','1','1169','2023-05-06','19000.00','','2023-05-11 09:59:20','2023-05-11 09:59:20');
INSERT INTO student_payments VALUES('1101','1','1183','2023-05-06','19000.00','','2023-05-11 09:59:46','2023-05-11 09:59:46');
INSERT INTO student_payments VALUES('1102','1','1184','2023-05-06','19000.00','','2023-05-11 10:00:17','2023-05-11 10:00:17');
INSERT INTO student_payments VALUES('1103','1','1148','2023-05-06','15000.00','','2023-05-11 10:00:48','2023-05-11 10:00:48');
INSERT INTO student_payments VALUES('1104','1','1167','2023-05-06','15000.00','','2023-05-11 10:01:17','2023-05-11 10:01:17');
INSERT INTO student_payments VALUES('1105','1','1185','2023-05-06','19000.00','','2023-05-11 10:01:48','2023-05-11 10:01:48');
INSERT INTO student_payments VALUES('1106','1','1168','2023-05-06','21500.00','','2023-05-11 10:03:11','2023-05-11 10:03:11');
INSERT INTO student_payments VALUES('1107','1','1206','2023-05-06','20000.00','','2023-05-11 10:08:42','2023-05-11 10:08:42');
INSERT INTO student_payments VALUES('1108','1','1186','2023-05-07','21500.00','','2023-05-11 10:09:44','2023-05-11 10:09:44');
INSERT INTO student_payments VALUES('1109','1','938','2023-05-07','2000.00','','2023-05-11 10:12:13','2023-05-11 10:12:13');
INSERT INTO student_payments VALUES('1110','1','1197','2023-05-07','21500.00','','2023-05-11 10:12:43','2023-05-11 10:12:43');
INSERT INTO student_payments VALUES('1111','1','1170','2023-05-07','19000.00','','2023-05-11 10:13:23','2023-05-11 10:13:23');
INSERT INTO student_payments VALUES('1112','1','1192','2023-05-07','19000.00','','2023-05-11 10:13:47','2023-05-11 10:13:47');
INSERT INTO student_payments VALUES('1113','1','1189','2023-05-07','15000.00','','2023-05-11 10:14:36','2023-05-11 10:14:36');
INSERT INTO student_payments VALUES('1114','1','1180','2023-05-08','15000.00','','2023-05-11 10:15:40','2023-05-11 10:15:40');
INSERT INTO student_payments VALUES('1115','1','1151','2023-05-08','15000.00','','2023-05-11 10:16:26','2023-05-11 10:16:26');
INSERT INTO student_payments VALUES('1116','1','1177','2023-05-08','19000.00','','2023-05-11 10:17:53','2023-05-11 10:17:53');
INSERT INTO student_payments VALUES('1117','1','1175','2023-05-08','21500.00','','2023-05-11 10:18:28','2023-05-11 10:18:28');
INSERT INTO student_payments VALUES('1118','1','1198','2023-05-08','19000.00','','2023-05-11 10:18:50','2023-05-11 10:18:50');
INSERT INTO student_payments VALUES('1119','1','1159','2023-05-09','20000.00','','2023-05-11 10:19:17','2023-05-11 10:19:17');
INSERT INTO student_payments VALUES('1120','1','1203','2023-05-09','23000.00','','2023-05-11 10:31:33','2023-05-11 10:31:33');
INSERT INTO student_payments VALUES('1121','1','1207','2023-05-09','24500.00','','2023-05-11 10:53:46','2023-05-11 10:53:46');
INSERT INTO student_payments VALUES('1122','1','1193','2023-05-10','21500.00','','2023-05-11 10:54:42','2023-05-11 10:54:42');
INSERT INTO student_payments VALUES('1123','1','1200','2023-05-10','21500.00','','2023-05-11 10:55:16','2023-05-11 10:55:16');
INSERT INTO student_payments VALUES('1124','1','1195','2023-05-10','10500.00','','2023-05-11 10:55:54','2023-05-11 10:55:54');
INSERT INTO student_payments VALUES('1125','1','1154','2023-05-10','19500.00','','2023-05-11 10:57:25','2023-05-11 10:57:25');
INSERT INTO student_payments VALUES('1126','1','1157','2023-05-12','19500.00','','2023-05-13 15:20:05','2023-05-13 15:20:05');
INSERT INTO student_payments VALUES('1127','1','1155','2023-05-13','19500.00','','2023-05-13 15:21:44','2023-05-13 15:21:44');
INSERT INTO student_payments VALUES('1128','1','1165','2023-05-14','18500.00','','2023-05-22 15:44:18','2023-05-22 15:44:18');
INSERT INTO student_payments VALUES('1129','1','1208','2023-05-04','34000.00','','2023-05-23 10:55:47','2023-05-23 10:55:47');
INSERT INTO student_payments VALUES('1130','1','1180','2023-05-23','3500.00','','2023-05-23 16:25:07','2023-05-23 16:25:07');
INSERT INTO student_payments VALUES('1131','1','1153','2023-05-24','21000.00','','2023-05-24 12:30:10','2023-05-24 12:30:10');
INSERT INTO student_payments VALUES('1132','1','1150','2023-05-24','21000.00','','2023-05-24 12:31:15','2023-05-24 12:31:15');
INSERT INTO student_payments VALUES('1133','1','1158','2023-05-11','20000.00','','2023-05-29 14:31:44','2023-05-29 14:31:44');
INSERT INTO student_payments VALUES('1134','1','1202','2023-05-21','21000.00','','2023-05-31 17:20:49','2023-05-31 17:20:49');
INSERT INTO student_payments VALUES('1135','1','1151','2023-05-27','4000.00','','2023-05-31 17:24:14','2023-05-31 17:24:14');
INSERT INTO student_payments VALUES('1136','1','1161','2023-05-27','2000.00','','2023-05-31 17:24:38','2023-05-31 17:24:38');
INSERT INTO student_payments VALUES('1137','1','1164','2023-05-27','3000.00','','2023-05-31 17:25:08','2023-05-31 17:25:08');
INSERT INTO student_payments VALUES('1138','1','1188','2023-05-14','20000.00','','2023-05-31 17:27:39','2023-05-31 17:27:39');
INSERT INTO student_payments VALUES('1139','1','1190','2023-05-18','12000.00','','2023-05-31 17:28:53','2023-05-31 17:28:53');
INSERT INTO student_payments VALUES('1140','1','1204','2023-05-07','40000.00','','2023-05-31 17:29:25','2023-05-31 17:29:25');
INSERT INTO student_payments VALUES('1141','1','1205','2023-05-10','20000.00','','2023-05-31 17:29:59','2023-05-31 17:29:59');
INSERT INTO student_payments VALUES('1142','1','1163','2023-05-10','19000.00','','2023-05-31 17:31:01','2023-05-31 17:31:01');
INSERT INTO student_payments VALUES('1143','1','1191','2023-05-15','15000.00','','2023-05-31 17:31:40','2023-05-31 17:31:40');
INSERT INTO student_payments VALUES('1144','1','1195','2023-05-27','11000.00','','2023-05-31 17:32:12','2023-05-31 17:32:12');
INSERT INTO student_payments VALUES('1145','1','1103','2023-05-27','2000.00','','2023-05-31 17:45:45','2023-05-31 17:45:45');
INSERT INTO student_payments VALUES('1146','1','1085','2023-05-27','1000.00','','2023-05-31 17:46:45','2023-05-31 17:46:45');
INSERT INTO student_payments VALUES('1147','1','1232','2023-06-01','19000.00','','2023-06-01 15:26:22','2023-06-01 15:26:22');
INSERT INTO student_payments VALUES('1148','1','1222','2023-06-01','19000.00','','2023-06-01 15:26:45','2023-06-01 15:26:45');
INSERT INTO student_payments VALUES('1149','1','1227','2023-06-01','19000.00','','2023-06-01 15:27:11','2023-06-01 15:27:11');
INSERT INTO student_payments VALUES('1150','1','1215','2023-06-01','19000.00','','2023-06-01 15:27:32','2023-06-01 15:27:32');
INSERT INTO student_payments VALUES('1151','1','1229','2023-06-01','19000.00','','2023-06-01 15:27:59','2023-06-01 15:27:59');
INSERT INTO student_payments VALUES('1152','1','1216','2023-06-01','21000.00','','2023-06-01 15:28:36','2023-06-01 15:28:36');
INSERT INTO student_payments VALUES('1153','1','1219','2023-06-01','21000.00','','2023-06-01 15:28:59','2023-06-01 15:28:59');
INSERT INTO student_payments VALUES('1154','1','1254','2023-06-01','12000.00','','2023-06-01 15:29:45','2023-06-01 15:29:45');
INSERT INTO student_payments VALUES('1155','1','1247','2023-06-01','19000.00','','2023-06-01 15:30:12','2023-06-01 15:30:12');
INSERT INTO student_payments VALUES('1156','1','1239','2023-06-01','10000.00','','2023-06-01 15:33:51','2023-06-01 15:33:51');
INSERT INTO student_payments VALUES('1157','1','1223','2023-06-01','5000.00','','2023-06-01 15:36:11','2023-06-01 15:36:11');
INSERT INTO student_payments VALUES('1158','1','1270','2023-06-01','19000.00','','2023-06-01 16:42:10','2023-06-01 16:42:10');
INSERT INTO student_payments VALUES('1159','1','1271','2023-06-01','20000.00','','2023-06-01 16:43:22','2023-06-01 16:43:22');
INSERT INTO student_payments VALUES('1160','1','1213','2023-06-02','19500.00','','2023-06-03 07:03:28','2023-06-03 07:03:28');
INSERT INTO student_payments VALUES('1161','1','1272','2023-06-05','20000.00','','2023-06-05 09:08:18','2023-06-05 09:08:18');
INSERT INTO student_payments VALUES('1162','1','1244','2023-06-05','19000.00','','2023-06-05 09:08:42','2023-06-05 09:08:42');
INSERT INTO student_payments VALUES('1163','1','1246','2023-06-05','19000.00','','2023-06-05 09:37:56','2023-06-05 09:37:56');
INSERT INTO student_payments VALUES('1164','1','1231','2023-06-05','18500.00','','2023-06-05 13:24:52','2023-06-05 13:24:52');
INSERT INTO student_payments VALUES('1165','1','1258','2023-06-06','15000.00','','2023-06-06 18:11:37','2023-06-06 18:11:37');
INSERT INTO student_payments VALUES('1166','1','1257','2023-06-07','21500.00','','2023-06-07 10:00:08','2023-06-07 10:00:08');
INSERT INTO student_payments VALUES('1167','1','938','2023-06-07','3500.00','','2023-06-07 16:40:28','2023-06-07 16:40:28');
INSERT INTO student_payments VALUES('1168','1','1261','2023-06-07','21500.00','','2023-06-07 16:40:50','2023-06-07 16:40:50');
INSERT INTO student_payments VALUES('1169','1','1217','2023-06-06','19000.00','','2023-06-07 16:42:04','2023-06-07 16:42:04');
INSERT INTO student_payments VALUES('1170','1','1236','2023-06-09','19000.00','','2023-06-08 19:23:18','2023-06-08 19:23:18');
INSERT INTO student_payments VALUES('1171','1','1259','2023-06-07','21500.00','','2023-06-09 09:27:49','2023-06-09 09:27:49');
INSERT INTO student_payments VALUES('1172','1','1228','2023-06-12','19000.00','','2023-06-12 12:20:05','2023-06-12 12:20:05');
INSERT INTO student_payments VALUES('1173','1','1225','2023-06-12','10000.00','','2023-06-13 15:09:45','2023-06-13 15:09:45');
INSERT INTO student_payments VALUES('1174','1','1225','2023-06-12','10000.00','','2023-06-13 15:09:49','2023-06-13 15:09:49');
INSERT INTO student_payments VALUES('1175','1','1226','2023-06-07','26000.00','','2023-06-13 15:13:14','2023-06-13 15:13:14');
INSERT INTO student_payments VALUES('1176','1','1239','2023-06-08','9000.00','','2023-06-13 15:14:21','2023-06-13 15:14:21');
INSERT INTO student_payments VALUES('1177','1','1248','2023-06-05','19000.00','','2023-06-13 15:15:04','2023-06-13 15:15:04');
INSERT INTO student_payments VALUES('1178','1','1249','2023-06-06','19000.00','','2023-06-13 15:15:54','2023-06-13 15:15:54');
INSERT INTO student_payments VALUES('1179','1','1270','2023-06-11','19000.00','','2023-06-13 15:16:47','2023-06-13 15:16:47');
INSERT INTO student_payments VALUES('1180','1','1271','2023-06-12','20000.00','','2023-06-13 15:18:29','2023-06-13 15:18:29');
INSERT INTO student_payments VALUES('1181','1','1252','2023-06-06','20000.00','','2023-06-13 15:19:01','2023-06-13 15:19:01');
INSERT INTO student_payments VALUES('1182','1','1268','2023-06-06','20000.00','','2023-06-13 15:20:05','2023-06-13 15:20:05');
INSERT INTO student_payments VALUES('1183','1','1230','2023-06-05','19000.00','','2023-06-13 15:23:06','2023-06-13 15:23:06');
INSERT INTO student_payments VALUES('1184','1','1210','2023-06-05','15000.00','','2023-06-13 15:24:37','2023-06-13 15:24:37');
INSERT INTO student_payments VALUES('1185','1','1211','2023-06-05','15000.00','','2023-06-13 15:25:13','2023-06-13 15:25:13');
INSERT INTO student_payments VALUES('1186','1','1212','2023-06-06','15000.00','','2023-06-13 15:26:14','2023-06-13 15:26:14');
INSERT INTO student_payments VALUES('1187','1','1214','2023-06-06','15000.00','','2023-06-13 15:27:28','2023-06-13 15:27:28');
INSERT INTO student_payments VALUES('1188','1','1233','2023-06-09','15000.00','','2023-06-13 15:29:06','2023-06-13 15:29:06');
INSERT INTO student_payments VALUES('1189','1','1256','2023-06-07','19000.00','','2023-06-13 15:31:21','2023-06-13 15:31:21');
INSERT INTO student_payments VALUES('1190','1','1220','2023-06-09','19500.00','','2023-06-13 15:34:15','2023-06-13 15:34:15');
INSERT INTO student_payments VALUES('1191','1','1221','2023-06-09','19500.00','','2023-06-13 15:35:54','2023-06-13 15:35:54');
INSERT INTO student_payments VALUES('1192','1','810','2023-06-13','0.00','','2023-06-13 17:26:22','2023-06-13 17:26:22');
INSERT INTO student_payments VALUES('1193','1','1209','2023-06-12','24500.00','','2023-06-13 17:41:05','2023-06-13 17:41:05');
INSERT INTO student_payments VALUES('1194','1','1218','2023-06-05','19000.00','','2023-06-13 17:42:20','2023-06-13 17:42:20');
INSERT INTO student_payments VALUES('1195','1','1260','2023-06-11','20000.00','','2023-06-13 17:43:31','2023-06-13 17:43:31');
INSERT INTO student_payments VALUES('1196','1','1263','2023-06-11','20000.00','','2023-06-13 17:43:59','2023-06-13 17:43:59');
INSERT INTO student_payments VALUES('1197','1','1265','2023-06-05','21500.00','','2023-06-13 17:46:36','2023-06-13 17:46:36');
INSERT INTO student_payments VALUES('1198','1','1273','2023-03-17','32300.00','','2023-06-13 18:00:15','2023-06-13 18:00:15');
INSERT INTO student_payments VALUES('1199','1','1223','2023-06-10','14500.00','','2023-06-13 18:07:51','2023-06-13 18:07:51');
INSERT INTO student_payments VALUES('1200','1','1251','2023-06-14','21500.00','','2023-06-14 06:38:46','2023-06-14 06:38:46');
INSERT INTO student_payments VALUES('1201','1','1242','2023-06-13','21500.00','','2023-06-14 10:05:49','2023-06-14 10:05:49');
INSERT INTO student_payments VALUES('1204','1','1235','2023-07-09','19000.00','','2023-07-09 08:45:12','2023-07-09 08:45:12');
INSERT INTO student_payments VALUES('1205','1','1303','2023-07-09','19000.00','JUNE RENT PAID','2023-07-09 08:46:45','2023-07-09 08:46:45');
INSERT INTO student_payments VALUES('1206','1','1240','2023-06-06','22000.00','','2023-07-09 09:02:22','2023-07-09 09:02:22');
INSERT INTO student_payments VALUES('1207','1','1308','2023-07-09','36000.00','','2023-07-09 09:05:18','2023-07-09 09:05:18');
INSERT INTO student_payments VALUES('1208','1','1308','2023-07-09','-6000.00','','2023-07-09 09:08:01','2023-07-09 09:08:01');
INSERT INTO student_payments VALUES('1209','1','1308','2023-07-09','0.00','','2023-07-09 09:09:18','2023-07-09 09:09:18');
INSERT INTO student_payments VALUES('1210','1','1327','2023-07-09','20000.00','','2023-07-09 17:44:28','2023-07-09 17:44:28');
INSERT INTO student_payments VALUES('1211','1','1336','2023-07-10','20000.00','','2023-07-10 07:02:46','2023-07-10 07:02:46');
INSERT INTO student_payments VALUES('1212','1','1333','2023-07-10','21000.00','','2023-07-10 08:50:15','2023-07-10 08:50:15');
INSERT INTO student_payments VALUES('1213','1','1300','2023-07-10','19000.00','','2023-07-10 14:56:18','2023-07-10 14:56:18');
INSERT INTO student_payments VALUES('1214','1','1298','2023-07-10','18500.00','','2023-07-10 16:25:35','2023-07-10 16:25:35');
INSERT INTO student_payments VALUES('1215','1','1307','2023-07-12','15000.00','','2023-07-12 05:35:54','2023-07-12 05:35:54');
INSERT INTO student_payments VALUES('1216','1','1286','2023-07-13','21000.00','','2023-07-13 19:18:48','2023-07-13 19:18:48');
INSERT INTO student_payments VALUES('1217','1','1293','2023-07-04','25500.00','','2023-07-16 12:24:19','2023-07-16 12:24:19');
INSERT INTO student_payments VALUES('1218','1','1280','2023-07-04','19500.00','','2023-07-16 12:25:48','2023-07-16 12:25:48');
INSERT INTO student_payments VALUES('1219','1','1331','2023-07-06','20000.00','','2023-07-16 12:28:14','2023-07-16 12:28:14');
INSERT INTO student_payments VALUES('1220','1','1310','2023-07-04','21500.00','','2023-07-16 12:30:58','2023-07-16 12:30:58');
INSERT INTO student_payments VALUES('1221','1','1317','2023-07-04','19000.00','','2023-07-16 12:31:52','2023-07-16 12:31:52');
INSERT INTO student_payments VALUES('1222','1','1318','2023-07-05','19000.00','','2023-07-16 12:33:52','2023-07-16 12:33:52');
INSERT INTO student_payments VALUES('1223','1','1284','2023-07-05','19000.00','','2023-07-16 12:34:55','2023-07-16 12:34:55');
INSERT INTO student_payments VALUES('1224','1','1282','2023-07-05','19000.00','','2023-07-16 12:35:30','2023-07-16 12:35:30');
INSERT INTO student_payments VALUES('1225','1','1297','2023-07-05','19000.00','','2023-07-16 12:36:10','2023-07-16 12:36:10');
INSERT INTO student_payments VALUES('1226','1','1296','2023-07-05','19000.00','','2023-07-16 12:36:56','2023-07-16 12:36:56');
INSERT INTO student_payments VALUES('1227','1','1314','2023-07-05','19000.00','','2023-07-16 12:37:42','2023-07-16 12:37:42');
INSERT INTO student_payments VALUES('1228','1','1292','2023-07-05','20000.00','','2023-07-16 12:39:05','2023-07-16 12:39:05');
INSERT INTO student_payments VALUES('1229','1','1313','2023-07-05','17000.00','','2023-07-16 12:41:05','2023-07-16 12:41:05');
INSERT INTO student_payments VALUES('1230','1','1278','2023-07-05','15000.00','','2023-07-16 12:42:45','2023-07-16 12:42:45');
INSERT INTO student_payments VALUES('1231','1','1277','2023-07-05','15000.00','','2023-07-16 12:44:15','2023-07-16 12:44:15');
INSERT INTO student_payments VALUES('1232','1','1337','2023-07-08','19000.00','','2023-07-16 12:46:23','2023-07-16 12:46:23');
INSERT INTO student_payments VALUES('1233','1','1315','2023-07-06','19000.00','','2023-07-16 12:47:33','2023-07-16 12:47:33');
INSERT INTO student_payments VALUES('1234','1','1319','2023-07-10','21000.00','','2023-07-16 12:51:15','2023-07-16 12:51:15');
INSERT INTO student_payments VALUES('1235','1','1295','2023-07-07','19000.00','','2023-07-16 12:53:09','2023-07-16 12:53:09');
INSERT INTO student_payments VALUES('1236','1','1283','2023-07-07','21000.00','','2023-07-16 12:56:15','2023-07-16 12:56:15');
INSERT INTO student_payments VALUES('1237','1','1329','2023-07-07','21000.00','','2023-07-16 12:57:26','2023-07-16 12:57:26');
INSERT INTO student_payments VALUES('1238','1','1289','2023-07-07','19000.00','','2023-07-16 12:58:38','2023-07-16 12:58:38');
INSERT INTO student_payments VALUES('1239','1','1294','2023-07-07','15000.00','','2023-07-16 12:59:36','2023-07-16 12:59:36');
INSERT INTO student_payments VALUES('1240','1','1311','2023-07-13','19000.00','','2023-07-16 13:01:31','2023-07-16 13:01:31');
INSERT INTO student_payments VALUES('1241','1','1339','2023-07-05','19000.00','','2023-07-16 13:05:00','2023-07-16 13:05:00');
INSERT INTO student_payments VALUES('1242','1','1330','2023-07-10','19000.00','','2023-07-19 09:09:28','2023-07-19 09:09:28');
INSERT INTO student_payments VALUES('1243','1','1301','2023-07-10','15000.00','','2023-07-19 09:12:15','2023-07-19 09:12:15');
INSERT INTO student_payments VALUES('1244','1','1316','2023-07-10','18500.00','','2023-07-19 09:14:00','2023-07-19 09:14:00');
INSERT INTO student_payments VALUES('1245','1','1324','2023-07-11','18500.00','','2023-07-19 09:15:45','2023-07-19 09:15:45');
INSERT INTO student_payments VALUES('1246','1','1288','2023-07-13','19500.00','','2023-07-19 09:19:26','2023-07-19 09:19:26');
INSERT INTO student_payments VALUES('1247','1','1285','2023-07-14','19000.00','','2023-07-19 09:22:38','2023-07-19 09:22:38');
INSERT INTO student_payments VALUES('1248','1','1224','2023-06-16','20000.00','','2023-07-22 07:25:41','2023-07-22 07:25:41');
INSERT INTO student_payments VALUES('1249','1','1291','2023-07-15','18000.00','','2023-07-22 07:27:44','2023-07-22 07:27:44');
INSERT INTO student_payments VALUES('1250','1','1333','2023-07-22','500.00','','2023-07-22 07:30:19','2023-07-22 07:30:19');
INSERT INTO student_payments VALUES('1251','1','1341','2023-07-20','23000.00','','2023-07-22 07:47:43','2023-07-22 07:47:43');
INSERT INTO student_payments VALUES('1252','1','1328','2023-07-09','19000.00','','2023-07-24 06:56:42','2023-07-24 06:56:42');
INSERT INTO student_payments VALUES('1253','1','1290','2023-07-12','18500.00','','2023-07-24 06:58:57','2023-07-24 06:58:57');
INSERT INTO student_payments VALUES('1254','1','1342','2023-07-26','25000.00','','2023-07-26 14:38:55','2023-07-26 14:38:55');
INSERT INTO student_payments VALUES('1255','1','1299','2023-07-27','25000.00','','2023-07-28 15:10:41','2023-07-28 15:10:41');
INSERT INTO student_payments VALUES('1256','1','1343','2023-07-28','20000.00','','2023-07-28 15:39:18','2023-07-28 15:39:18');
INSERT INTO student_payments VALUES('1257','1','1335','2023-07-11','20000.00','','2023-07-30 11:23:21','2023-07-30 11:23:21');
INSERT INTO student_payments VALUES('1258','1','1338','2023-07-10','20000.00','','2023-07-30 11:25:05','2023-07-30 11:25:05');
INSERT INTO student_payments VALUES('1259','1','1320','2023-07-10','15000.00','','2023-07-30 11:26:10','2023-07-30 11:26:10');
INSERT INTO student_payments VALUES('1260','1','1234','2023-07-10','21500.00','','2023-07-30 11:41:39','2023-07-30 11:41:39');
INSERT INTO student_payments VALUES('1261','1','1302','2023-07-23','20500.00','','2023-07-30 11:42:11','2023-07-30 11:42:11');
INSERT INTO student_payments VALUES('1262','1','1237','2023-07-15','23000.00','','2023-07-30 11:46:37','2023-07-30 11:46:37');
INSERT INTO student_payments VALUES('1263','1','1305','2023-07-12','23000.00','','2023-07-30 11:47:07','2023-07-30 11:47:07');
INSERT INTO student_payments VALUES('1264','1','1306','2023-07-19','23000.00','','2023-07-30 11:48:01','2023-07-30 11:48:01');
INSERT INTO student_payments VALUES('1265','1','1238','2023-07-18','23000.00','','2023-07-30 11:48:51','2023-07-30 11:48:51');
INSERT INTO student_payments VALUES('1266','1','1172','2023-07-21','3000.00','','2023-07-30 11:49:42','2023-07-30 11:49:42');
INSERT INTO student_payments VALUES('1267','1','1101','2023-07-13','1000.00','','2023-07-30 11:50:36','2023-07-30 11:50:36');
INSERT INTO student_payments VALUES('1268','1','1171','2023-07-16','4000.00','','2023-07-30 11:51:32','2023-07-30 11:51:32');
INSERT INTO student_payments VALUES('1269','1','1276','2023-07-15','24500.00','','2023-07-30 11:53:50','2023-07-30 11:53:50');
INSERT INTO student_payments VALUES('1270','1','367','2023-07-18','70.00','','2023-07-30 11:54:21','2023-07-30 11:54:21');
INSERT INTO student_payments VALUES('1271','1','432','2023-07-13','100.00','','2023-07-30 11:54:43','2023-07-30 11:54:43');
INSERT INTO student_payments VALUES('1272','1','677','2023-07-18','220.00','','2023-07-30 11:56:00','2023-07-30 11:56:00');
INSERT INTO student_payments VALUES('1273','1','678','2023-07-14','220.00','','2023-07-30 11:56:39','2023-07-30 11:56:39');
INSERT INTO student_payments VALUES('1274','1','1253','2023-07-13','15000.00','','2023-07-30 11:57:34','2023-07-30 11:57:34');
INSERT INTO student_payments VALUES('1275','1','1255','2023-07-14','15000.00','','2023-07-30 11:57:54','2023-07-30 11:57:54');
INSERT INTO student_payments VALUES('1276','1','1323','2023-07-14','15000.00','','2023-07-30 11:58:16','2023-07-30 11:58:16');
INSERT INTO student_payments VALUES('1277','1','1322','2023-07-15','12000.00','','2023-07-30 11:58:32','2023-07-30 11:58:32');
INSERT INTO student_payments VALUES('1278','1','1307','2023-07-20','4000.00','','2023-07-30 12:01:42','2023-07-30 12:01:42');
INSERT INTO student_payments VALUES('1279','1','411','2023-07-20','7500.00','','2023-07-30 12:03:12','2023-07-30 12:03:12');
INSERT INTO student_payments VALUES('1280','1','1294','2023-07-20','4000.00','','2023-07-30 12:04:17','2023-07-30 12:04:17');
INSERT INTO student_payments VALUES('1281','1','409','2023-07-17','7500.00','','2023-07-30 12:06:16','2023-07-30 12:06:16');
INSERT INTO student_payments VALUES('1282','1','466','2023-07-15','500.00','','2023-07-30 12:07:32','2023-07-30 12:07:32');
INSERT INTO student_payments VALUES('1283','1','1279','2023-07-13','15000.00','','2023-07-30 12:13:09','2023-07-30 12:13:09');
INSERT INTO student_payments VALUES('1284','1','1267','2023-07-19','23000.00','','2023-07-30 12:15:58','2023-07-30 12:15:58');
INSERT INTO student_payments VALUES('1285','1','1334','2023-07-19','23000.00','','2023-07-30 12:16:28','2023-07-30 12:16:28');
INSERT INTO student_payments VALUES('1286','1','1264','2023-07-15','21500.00','','2023-07-30 12:17:07','2023-07-30 12:17:07');
INSERT INTO student_payments VALUES('1287','1','1332','2023-07-15','21500.00','','2023-07-30 12:18:13','2023-07-30 12:18:13');
INSERT INTO student_payments VALUES('1288','1','1262','2023-07-13','19000.00','','2023-07-30 12:19:01','2023-07-30 12:19:01');
INSERT INTO student_payments VALUES('1289','1','1250','2023-07-14','19000.00','','2023-07-30 12:19:43','2023-07-30 12:19:43');
INSERT INTO student_payments VALUES('1290','1','1304','2023-07-15','19000.00','','2023-07-30 12:20:14','2023-07-30 12:20:14');
INSERT INTO student_payments VALUES('1291','1','1312','2023-07-15','19000.00','','2023-07-30 12:20:41','2023-07-30 12:20:41');
INSERT INTO student_payments VALUES('1292','1','1245','2023-07-15','18500.00','','2023-07-30 12:21:30','2023-07-30 12:21:30');
INSERT INTO student_payments VALUES('1293','1','1313','2023-07-15','1500.00','','2023-07-30 12:22:14','2023-07-30 12:22:14');
INSERT INTO student_payments VALUES('1294','1','420','2023-07-15','8000.00','','2023-07-30 12:22:44','2023-07-30 12:22:44');
INSERT INTO student_payments VALUES('1295','1','1243','2023-07-22','19000.00','','2023-07-30 12:23:26','2023-07-30 12:23:26');
INSERT INTO student_payments VALUES('1296','1','1281','2023-07-15','15000.00','','2023-07-30 12:24:36','2023-07-30 12:24:36');
INSERT INTO student_payments VALUES('1297','1','1326','2023-07-15','15000.00','','2023-07-30 12:25:54','2023-07-30 12:25:54');
INSERT INTO student_payments VALUES('1298','1','1325','2023-07-15','20000.00','','2023-07-30 12:29:00','2023-07-30 12:29:00');
INSERT INTO student_payments VALUES('1299','1','1038','2023-07-15','1000.00','','2023-07-30 12:59:01','2023-07-30 12:59:01');
INSERT INTO student_payments VALUES('1300','1','1290','2023-07-20','500.00','','2023-08-03 18:20:30','2023-08-03 18:20:30');
INSERT INTO student_payments VALUES('1301','1','1348','2023-08-02','19500.00','','2023-08-03 18:21:29','2023-08-03 18:21:29');
INSERT INTO student_payments VALUES('1302','1','1357','2023-08-03','19500.00','','2023-08-03 18:22:31','2023-08-03 18:22:31');
INSERT INTO student_payments VALUES('1303','1','1356','2023-08-01','19000.00','','2023-08-04 19:09:34','2023-08-04 19:09:34');
INSERT INTO student_payments VALUES('1304','1','1366','2023-08-01','19000.00','','2023-08-04 19:10:23','2023-08-04 19:10:23');
INSERT INTO student_payments VALUES('1305','1','1351','2023-08-02','21000.00','','2023-08-04 19:11:08','2023-08-04 19:11:08');
INSERT INTO student_payments VALUES('1306','1','1381','2023-08-01','19000.00','','2023-08-04 19:16:26','2023-08-04 19:16:26');
INSERT INTO student_payments VALUES('1307','1','1354','2023-08-02','21000.00','','2023-08-04 19:16:57','2023-08-04 19:16:57');
INSERT INTO student_payments VALUES('1308','1','1352','2023-08-02','19000.00','','2023-08-04 19:17:35','2023-08-04 19:17:35');
INSERT INTO student_payments VALUES('1309','1','1404','2023-08-02','20000.00','','2023-08-04 19:18:15','2023-08-04 19:18:15');
INSERT INTO student_payments VALUES('1310','1','1350','2023-08-02','19000.00','','2023-08-04 19:18:53','2023-08-04 19:18:53');
INSERT INTO student_payments VALUES('1311','1','1407','2023-08-03','25000.00','','2023-08-04 19:19:46','2023-08-04 19:19:46');
INSERT INTO student_payments VALUES('1312','1','1320','2023-08-03','5000.00','','2023-08-04 19:20:36','2023-08-04 19:20:36');
INSERT INTO student_payments VALUES('1313','1','1385','2023-08-03','20000.00','','2023-08-04 19:22:20','2023-08-04 19:22:20');
INSERT INTO student_payments VALUES('1314','1','1371','2023-08-02','23000.00','','2023-08-04 19:22:57','2023-08-04 19:22:57');
INSERT INTO student_payments VALUES('1315','1','1401','2023-08-03','19000.00','','2023-08-04 19:23:59','2023-08-04 19:23:59');
INSERT INTO student_payments VALUES('1316','1','1408','2023-08-03','30000.00','','2023-08-04 19:24:41','2023-08-04 19:24:41');
INSERT INTO student_payments VALUES('1317','1','1399','2023-08-03','19000.00','','2023-08-04 19:25:10','2023-08-04 19:25:10');
INSERT INTO student_payments VALUES('1318','1','1373','2023-08-03','19500.00','','2023-08-04 19:25:42','2023-08-04 19:25:42');
INSERT INTO student_payments VALUES('1319','1','1405','2023-08-04','22000.00','','2023-08-04 19:26:35','2023-08-04 19:26:35');
INSERT INTO student_payments VALUES('1320','1','1406','2023-08-04','22000.00','','2023-08-04 19:27:08','2023-08-04 19:27:08');
INSERT INTO student_payments VALUES('1321','1','1400','2023-08-04','20000.00','','2023-08-04 19:28:54','2023-08-04 19:28:54');
INSERT INTO student_payments VALUES('1322','1','1393','2023-08-04','21500.00','','2023-08-04 19:29:38','2023-08-04 19:29:38');
INSERT INTO student_payments VALUES('1323','1','1382','2023-08-04','19000.00','','2023-08-04 19:30:22','2023-08-04 19:30:22');
INSERT INTO student_payments VALUES('1324','1','1375','2023-08-04','21500.00','','2023-08-04 19:31:22','2023-08-04 19:31:22');
INSERT INTO student_payments VALUES('1325','1','1378','2023-08-04','18500.00','','2023-08-04 19:32:02','2023-08-04 19:32:02');
INSERT INTO student_payments VALUES('1326','1','1355','2023-08-04','19500.00','','2023-08-04 19:33:45','2023-08-04 19:33:45');
INSERT INTO student_payments VALUES('1327','1','1360','2023-08-02','26000.00','','2023-08-04 19:36:05','2023-08-04 19:36:05');
INSERT INTO student_payments VALUES('1328','1','1397','2023-08-04','20000.00','','2023-08-04 19:39:09','2023-08-04 19:39:09');
INSERT INTO student_payments VALUES('1329','1','1409','2023-08-05','30000.00','','2023-08-05 11:26:01','2023-08-05 11:26:01');
INSERT INTO student_payments VALUES('1330','1','1345','2023-08-05','15000.00','','2023-08-05 18:58:29','2023-08-05 18:58:29');
INSERT INTO student_payments VALUES('1331','1','1387','2023-08-05','12000.00','','2023-08-05 18:59:01','2023-08-05 18:59:01');
INSERT INTO student_payments VALUES('1332','1','1346','2023-08-05','15000.00','','2023-08-05 19:00:07','2023-08-05 19:00:07');
INSERT INTO student_payments VALUES('1333','1','1391','2023-08-05','15000.00','','2023-08-05 19:00:54','2023-08-05 19:00:54');
INSERT INTO student_payments VALUES('1334','1','1396','2023-08-05','21500.00','','2023-08-05 19:01:55','2023-08-05 19:01:55');
INSERT INTO student_payments VALUES('1335','1','1349','2023-08-04','15000.00','','2023-08-05 19:02:34','2023-08-05 19:02:34');
INSERT INTO student_payments VALUES('1336','1','1367','2023-08-05','15000.00','','2023-08-05 19:03:17','2023-08-05 19:03:17');
INSERT INTO student_payments VALUES('1337','1','1364','2023-08-06','19000.00','','2023-08-07 08:13:13','2023-08-07 08:13:13');
INSERT INTO student_payments VALUES('1338','1','1362','2023-08-06','19000.00','','2023-08-07 08:14:22','2023-08-07 08:14:22');
INSERT INTO student_payments VALUES('1339','1','1376','2023-08-06','19000.00','','2023-08-07 09:46:00','2023-08-07 09:46:00');
INSERT INTO student_payments VALUES('1340','1','1374','2023-08-06','24000.00','','2023-08-07 09:49:55','2023-08-07 09:49:55');
INSERT INTO student_payments VALUES('1341','1','1308','2023-08-06','6000.00','','2023-08-07 09:51:54','2023-08-07 09:51:54');
INSERT INTO student_payments VALUES('1342','1','1341','2023-08-06','7000.00','','2023-08-07 09:53:55','2023-08-07 09:53:55');
INSERT INTO student_payments VALUES('1343','1','1402','2023-08-06','23000.00','','2023-08-07 09:54:47','2023-08-07 09:54:47');
INSERT INTO student_payments VALUES('1344','1','1344','2023-08-07','24500.00','','2023-08-07 09:57:09','2023-08-07 09:57:09');
INSERT INTO student_payments VALUES('1345','1','1370','2023-08-07','19000.00','','2023-08-07 10:22:56','2023-08-07 10:22:56');
INSERT INTO student_payments VALUES('1346','1','1389','2023-08-08','19000.00','','2023-08-09 07:24:12','2023-08-09 07:24:12');
INSERT INTO student_payments VALUES('1347','1','1394','2023-08-08','19000.00','','2023-08-09 07:26:38','2023-08-09 07:26:38');
INSERT INTO student_payments VALUES('1348','1','1383','2023-08-07','19000.00','','2023-08-09 07:28:18','2023-08-09 07:28:18');
INSERT INTO student_payments VALUES('1349','1','1392','2023-08-08','21500.00','','2023-08-09 07:29:38','2023-08-09 07:29:38');
INSERT INTO student_payments VALUES('1350','1','1359','2023-08-08','12000.00','','2023-08-09 07:31:16','2023-08-09 07:31:16');



DROP TABLE IF EXISTS student_sessions;

CREATE TABLE `student_sessions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `roll` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `optional_subject` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO student_sessions VALUES('1','1','1','1','1','9','2','01','','2021-10-05 10:57:05','2021-12-04 17:32:52');
INSERT INTO student_sessions VALUES('2','1','1','2','1','2','2','','','2021-10-05 11:11:35','2021-12-04 17:29:18');
INSERT INTO student_sessions VALUES('3','1','1','3','2','14','2','03','','2021-12-04 17:38:22','2022-03-11 12:02:42');
INSERT INTO student_sessions VALUES('4','1','1','4','1','2','2','04','','2021-12-04 17:47:35','2021-12-05 19:10:02');
INSERT INTO student_sessions VALUES('5','1','1','5','1','13','2','05','','2021-12-04 17:51:45','2021-12-04 17:51:45');
INSERT INTO student_sessions VALUES('6','1','1','6','2','17','2','06','','2021-12-04 18:05:01','2021-12-04 18:05:01');
INSERT INTO student_sessions VALUES('7','1','1','7','1','1','2','7','','2021-12-04 18:34:10','2023-04-09 11:11:32');
INSERT INTO student_sessions VALUES('8','1','1','8','1','1','2','8','','2021-12-04 18:41:39','2021-12-04 18:41:39');
INSERT INTO student_sessions VALUES('9','1','1','9','1','1','2','9','','2021-12-04 18:49:17','2021-12-04 18:49:17');
INSERT INTO student_sessions VALUES('10','1','1','10','1','1','2','10','','2021-12-04 19:36:50','2021-12-04 19:36:50');
INSERT INTO student_sessions VALUES('11','1','1','11','1','2','1','11','','2021-12-04 19:41:41','2021-12-04 19:41:41');
INSERT INTO student_sessions VALUES('12','1','1','12','1','3','2','12','','2021-12-04 19:49:14','2021-12-04 19:49:14');
INSERT INTO student_sessions VALUES('13','1','1','13','1','3','1','13','','2021-12-04 20:38:26','2021-12-04 20:38:26');
INSERT INTO student_sessions VALUES('14','1','1','14','1','5','2','14','','2021-12-05 11:29:59','2021-12-05 11:29:59');
INSERT INTO student_sessions VALUES('15','1','1','15','1','7','2','15','','2021-12-05 11:37:49','2021-12-05 11:37:49');
INSERT INTO student_sessions VALUES('16','1','1','16','1','7','2','16','','2021-12-05 11:41:52','2021-12-05 11:41:52');
INSERT INTO student_sessions VALUES('17','1','1','17','1','7','2','17','','2021-12-05 11:44:34','2021-12-05 11:44:34');
INSERT INTO student_sessions VALUES('18','1','1','18','1','7','2','18','','2021-12-05 11:47:53','2021-12-05 11:47:53');
INSERT INTO student_sessions VALUES('19','1','1','19','1','8','2','19','','2021-12-05 11:54:17','2021-12-05 11:54:17');
INSERT INTO student_sessions VALUES('20','1','1','20','1','8','1','20','','2021-12-05 11:58:29','2021-12-05 11:58:29');
INSERT INTO student_sessions VALUES('21','1','1','21','1','8','1','21','','2021-12-05 12:03:45','2021-12-05 12:03:45');
INSERT INTO student_sessions VALUES('22','1','1','22','1','9','1','22','','2021-12-05 12:15:43','2021-12-05 12:15:43');
INSERT INTO student_sessions VALUES('23','1','1','23','1','9','1','23','','2021-12-05 12:35:10','2021-12-05 12:35:10');
INSERT INTO student_sessions VALUES('24','1','1','24','1','9','1','24','','2021-12-05 12:39:02','2021-12-05 12:39:02');
INSERT INTO student_sessions VALUES('25','1','1','25','1','10','2','26','','2021-12-05 12:52:37','2021-12-05 12:52:37');
INSERT INTO student_sessions VALUES('26','1','1','26','1','9','2','27','','2021-12-05 12:56:03','2022-03-03 14:04:33');
INSERT INTO student_sessions VALUES('27','1','1','27','1','10','2','28','','2021-12-05 12:59:17','2021-12-05 12:59:17');
INSERT INTO student_sessions VALUES('28','1','1','28','1','11','1','29','','2021-12-05 15:55:02','2021-12-05 15:55:02');
INSERT INTO student_sessions VALUES('29','1','1','29','1','6','2','30','','2021-12-05 16:40:10','2022-02-02 12:32:35');
INSERT INTO student_sessions VALUES('30','1','1','30','1','6','2','31','','2021-12-05 16:54:57','2021-12-31 12:39:20');
INSERT INTO student_sessions VALUES('31','1','1','31','1','6','2','32','','2021-12-05 17:01:59','2021-12-31 12:38:49');
INSERT INTO student_sessions VALUES('32','1','1','32','1','6','2','33','','2021-12-05 17:05:29','2021-12-31 12:38:20');
INSERT INTO student_sessions VALUES('33','1','1','33','1','2','2','34','','2021-12-07 11:40:21','2021-12-07 12:12:10');
INSERT INTO student_sessions VALUES('34','1','1','34','1','11','1','35','','2021-12-07 18:29:53','2021-12-07 18:29:53');
INSERT INTO student_sessions VALUES('35','1','1','35','1','7','1','36','','2021-12-08 11:27:12','2021-12-08 11:27:12');
INSERT INTO student_sessions VALUES('36','1','1','36','1','12','2','37','','2021-12-08 18:14:05','2021-12-08 18:14:05');
INSERT INTO student_sessions VALUES('37','1','1','37','1','12','2','38','','2021-12-09 10:38:53','2021-12-09 10:38:53');
INSERT INTO student_sessions VALUES('38','1','1','38','1','11','2','39','','2021-12-09 19:15:12','2021-12-09 19:15:12');
INSERT INTO student_sessions VALUES('39','1','1','39','1','3','2','41','','2021-12-17 20:40:39','2021-12-17 20:40:39');
INSERT INTO student_sessions VALUES('40','1','1','40','1','4','1','42','','2021-12-17 20:44:21','2021-12-30 19:33:56');
INSERT INTO student_sessions VALUES('41','1','1','41','1','11','1','43','','2021-12-31 12:30:45','2021-12-31 12:30:45');
INSERT INTO student_sessions VALUES('42','1','1','42','2','15','1','44','','2021-12-31 12:42:24','2022-02-17 12:18:22');
INSERT INTO student_sessions VALUES('43','1','1','43','1','4','1','45','','2021-12-31 12:46:06','2021-12-31 12:46:06');
INSERT INTO student_sessions VALUES('44','1','1','44','1','11','1','46','','2022-01-02 17:57:26','2022-01-02 17:57:26');
INSERT INTO student_sessions VALUES('45','1','1','45','1','8','1','47','','2022-01-02 21:30:17','2022-01-02 21:30:17');
INSERT INTO student_sessions VALUES('46','1','1','46','2','15','1','48','','2022-01-03 13:10:11','2022-03-03 12:03:50');
INSERT INTO student_sessions VALUES('47','1','1','47','1','10','1','49','','2022-01-10 11:23:56','2022-01-10 11:23:56');
INSERT INTO student_sessions VALUES('48','1','1','48','2','16','1','50','','2022-01-12 16:22:34','2022-01-12 16:22:34');
INSERT INTO student_sessions VALUES('49','1','1','49','1','10','2','51','','2022-01-23 19:11:08','2022-01-23 19:11:08');
INSERT INTO student_sessions VALUES('50','1','1','50','1','8','1','52','','2022-01-27 20:23:27','2022-01-27 20:23:27');
INSERT INTO student_sessions VALUES('51','1','1','51','1','8','1','53','','2022-01-28 20:46:21','2022-01-28 20:46:21');
INSERT INTO student_sessions VALUES('52','1','1','52','1','8','1','54','','2022-01-31 20:25:32','2022-01-31 20:25:32');
INSERT INTO student_sessions VALUES('53','1','1','53','1','11','2','55','','2022-02-02 12:43:33','2022-02-02 12:43:33');
INSERT INTO student_sessions VALUES('54','1','1','54','1','2','1','56','','2022-02-03 17:49:07','2022-02-03 17:49:07');
INSERT INTO student_sessions VALUES('55','1','1','55','1','5','1','57','','2022-02-12 20:46:04','2022-02-12 20:46:04');
INSERT INTO student_sessions VALUES('56','1','1','56','1','4','1','58','','2022-02-20 13:40:11','2022-03-12 13:02:31');
INSERT INTO student_sessions VALUES('57','1','1','57','1','3','1','59','','2022-02-20 19:30:41','2022-02-20 19:30:41');
INSERT INTO student_sessions VALUES('58','1','1','58','1','4','1','60','','2022-02-20 19:48:18','2022-02-20 19:48:18');
INSERT INTO student_sessions VALUES('59','1','1','59','1','2','1','61','','2022-02-22 14:01:10','2022-02-22 14:01:10');
INSERT INTO student_sessions VALUES('60','1','1','60','1','2','1','62','','2022-02-22 14:08:12','2022-02-22 14:08:12');
INSERT INTO student_sessions VALUES('61','1','1','61','1','2','2','33184044','','2022-03-03 12:14:08','2022-03-03 12:14:08');
INSERT INTO student_sessions VALUES('62','1','1','62','1','10','2','6440489','','2022-03-05 17:03:46','2022-03-05 17:03:46');
INSERT INTO student_sessions VALUES('63','1','1','63','1','8','1','42082225','','2022-03-12 15:05:52','2022-03-12 15:05:52');
INSERT INTO student_sessions VALUES('64','1','1','64','1','11','1','48237873','','2022-03-12 15:30:34','2022-03-12 15:30:34');
INSERT INTO student_sessions VALUES('65','1','1','65','1','1','1','79273340','','2022-03-15 07:05:56','2022-03-15 07:05:56');
INSERT INTO student_sessions VALUES('66','1','1','66','1','1','2','8305630','','2022-03-15 07:38:43','2022-03-15 07:38:43');
INSERT INTO student_sessions VALUES('67','1','1','67','1','5','1','42285228','','2022-04-04 11:44:25','2022-04-04 11:44:25');
INSERT INTO student_sessions VALUES('68','1','1','68','1','5','2','69680356','','2022-04-06 11:49:22','2022-04-06 11:49:22');
INSERT INTO student_sessions VALUES('69','1','1','69','3','13','2','79949505','','2022-04-08 09:33:16','2022-10-05 07:47:44');
INSERT INTO student_sessions VALUES('70','1','1','70','1','3','2','58640571','','2022-04-08 10:39:35','2022-04-08 10:39:35');
INSERT INTO student_sessions VALUES('71','1','1','71','1','16','1','28339600','','2022-04-23 14:54:32','2022-04-23 14:54:32');
INSERT INTO student_sessions VALUES('72','1','1','72','1','18','1','91351692','','2022-04-28 08:34:36','2022-04-28 08:38:10');
INSERT INTO student_sessions VALUES('73','1','1','73','1','6','1','47154611','','2022-05-10 15:28:46','2022-05-10 15:28:46');
INSERT INTO student_sessions VALUES('74','1','1','74','1','6','1','63987493','','2022-05-11 07:08:21','2022-05-11 07:08:21');
INSERT INTO student_sessions VALUES('75','1','1','75','1','6','1','42643245','','2022-05-11 07:23:42','2022-05-11 07:23:42');
INSERT INTO student_sessions VALUES('76','1','1','76','1','2','1','50163277','','2022-05-11 12:11:39','2022-05-11 12:11:39');
INSERT INTO student_sessions VALUES('77','1','1','77','1','6','1','96124247','','2022-05-11 12:35:56','2022-05-11 12:35:56');
INSERT INTO student_sessions VALUES('78','1','1','78','3','17','1','30124821','','2022-05-22 12:39:58','2022-05-22 12:39:58');
INSERT INTO student_sessions VALUES('79','1','1','79','1','16','1','63360019','','2022-05-22 13:08:26','2022-05-22 13:08:26');
INSERT INTO student_sessions VALUES('80','1','1','80','3','13','2','4135660','','2022-05-23 08:11:00','2022-05-23 08:11:00');
INSERT INTO student_sessions VALUES('81','1','1','81','1','9','1','43082387','','2022-05-31 07:49:48','2022-11-02 16:48:58');
INSERT INTO student_sessions VALUES('82','1','1','82','3','17','1','20248877','','2022-06-02 10:34:53','2022-06-02 10:34:53');
INSERT INTO student_sessions VALUES('83','1','1','83','3','13','1','33695193','','2022-06-02 14:47:49','2022-08-03 05:58:50');
INSERT INTO student_sessions VALUES('84','1','1','84','3','13','1','95268246','','2022-06-04 05:20:57','2022-06-04 05:20:57');
INSERT INTO student_sessions VALUES('85','1','1','85','3','24','1','28529082','','2022-06-04 05:32:40','2023-06-14 15:37:35');
INSERT INTO student_sessions VALUES('86','1','1','86','1','4','1','63585278','','2022-06-04 05:43:50','2022-07-14 10:52:25');
INSERT INTO student_sessions VALUES('87','1','1','87','1','7','1','65356284','','2022-06-05 14:01:26','2022-08-11 06:18:58');
INSERT INTO student_sessions VALUES('88','1','1','88','1','12','1','29996850','','2022-06-05 14:17:02','2022-06-05 14:17:02');
INSERT INTO student_sessions VALUES('89','1','1','89','1','11','1','17702957','','2022-06-05 14:36:08','2022-07-21 08:45:24');
INSERT INTO student_sessions VALUES('90','1','1','90','2','12','1','21753753','','2022-06-05 14:46:54','2022-06-05 14:46:54');
INSERT INTO student_sessions VALUES('91','1','1','91','3','13','1','54997139','','2022-06-25 15:55:13','2022-06-25 15:55:13');
INSERT INTO student_sessions VALUES('92','1','1','92','1','9','1','27519818','','2022-07-03 07:17:54','2023-04-02 08:13:54');
INSERT INTO student_sessions VALUES('93','1','1','93','2','12','1','15374725','','2022-07-03 07:47:06','2022-07-03 07:49:40');
INSERT INTO student_sessions VALUES('94','1','1','94','1','10','1','4934095','','2022-07-03 11:16:56','2022-07-23 08:27:02');
INSERT INTO student_sessions VALUES('95','1','1','95','2','12','1','24095334','','2022-07-14 10:11:22','2022-07-14 10:11:22');
INSERT INTO student_sessions VALUES('96','1','1','96','2','12','1','85862693','','2022-07-14 10:17:49','2022-07-14 10:17:49');
INSERT INTO student_sessions VALUES('97','1','1','97','1','8','2','25718045','','2022-07-14 10:34:49','2023-07-08 15:54:57');
INSERT INTO student_sessions VALUES('98','1','1','98','3','24','1','98020490','','2022-07-14 10:46:40','2023-07-09 09:00:21');
INSERT INTO student_sessions VALUES('99','1','1','99','3','17','1','35554160','','2022-07-16 06:16:40','2022-07-16 06:42:13');
INSERT INTO student_sessions VALUES('100','1','1','100','3','17','1','68329230','','2022-07-20 05:39:48','2022-07-20 05:39:48');
INSERT INTO student_sessions VALUES('101','1','1','101','1','9','1','52468343','','2022-07-20 05:51:52','2022-07-20 05:51:52');
INSERT INTO student_sessions VALUES('102','1','1','102','1','11','1','34065272','','2022-07-20 05:58:12','2022-09-03 17:44:46');
INSERT INTO student_sessions VALUES('103','1','1','103','1','2','1','76118216','','2022-07-20 06:07:46','2022-07-20 06:07:46');
INSERT INTO student_sessions VALUES('104','1','1','104','1','9','1','85952566','','2022-07-21 09:54:14','2022-07-21 09:54:14');
INSERT INTO student_sessions VALUES('105','1','1','105','1','11','1','85352930','','2022-07-23 08:36:24','2022-07-23 08:36:24');
INSERT INTO student_sessions VALUES('106','1','1','106','1','11','2','5102696','','2022-07-23 08:45:05','2022-08-02 10:04:20');
INSERT INTO student_sessions VALUES('107','1','1','107','1','2','1','20631178','','2022-07-24 08:34:34','2022-08-02 10:05:04');
INSERT INTO student_sessions VALUES('108','1','1','108','1','2','1','1536695','','2022-07-24 08:40:43','2022-07-24 08:40:43');
INSERT INTO student_sessions VALUES('109','1','1','109','1','1','2','60307973','','2022-08-03 06:04:50','2022-08-03 06:04:50');
INSERT INTO student_sessions VALUES('110','1','1','110','1','2','1','37538584','','2022-08-06 16:42:44','2022-08-06 16:42:44');
INSERT INTO student_sessions VALUES('111','1','1','111','1','10','1','87509632','','2022-08-11 06:28:41','2022-08-11 06:28:41');
INSERT INTO student_sessions VALUES('112','1','1','112','1','3','2','27918780','','2022-09-02 10:26:58','2022-09-02 10:26:58');
INSERT INTO student_sessions VALUES('113','1','1','113','1','16','1','51855834','','2022-09-05 20:58:13','2022-09-05 20:58:13');
INSERT INTO student_sessions VALUES('114','1','1','114','1','3','1','8683674','','2022-09-05 21:22:51','2022-09-05 21:22:51');
INSERT INTO student_sessions VALUES('115','1','1','115','1','3','1','70654408','','2022-09-05 21:26:01','2022-09-05 21:26:01');
INSERT INTO student_sessions VALUES('116','1','1','116','2','21','1','1227354','','2022-09-07 18:06:38','2022-09-07 18:06:38');
INSERT INTO student_sessions VALUES('117','1','1','117','2','21','1','60678601','','2022-09-07 18:17:49','2022-09-07 18:17:49');
INSERT INTO student_sessions VALUES('118','1','1','118','2','21','1','57693737','','2022-09-08 09:53:25','2022-09-08 09:53:25');
INSERT INTO student_sessions VALUES('119','1','1','119','1','10','1','58','','2022-11-03 06:26:38','2022-11-03 06:26:38');
INSERT INTO student_sessions VALUES('120','1','1','120','1','5','1','93714518','','2022-11-06 14:50:38','2022-11-06 14:50:38');
INSERT INTO student_sessions VALUES('121','1','1','121','1','7','1','40758331','','2022-11-16 16:49:35','2022-11-16 16:49:35');
INSERT INTO student_sessions VALUES('122','1','1','122','1','5','1','21699463','','2022-11-16 17:02:12','2022-11-16 17:02:12');
INSERT INTO student_sessions VALUES('123','1','1','123','1','1','1','59578682','','2022-11-16 17:24:21','2022-11-16 17:24:21');
INSERT INTO student_sessions VALUES('124','1','1','124','2','22','1','27795405','','2022-12-10 08:23:39','2022-12-10 08:23:39');
INSERT INTO student_sessions VALUES('125','1','1','125','2','22','1','76285198','','2022-12-10 08:28:00','2022-12-10 08:28:00');
INSERT INTO student_sessions VALUES('126','1','1','126','3','13','1','73783847','','2022-12-22 05:40:56','2022-12-22 05:40:56');
INSERT INTO student_sessions VALUES('127','1','1','127','1','10','1','71637678','','2023-01-06 10:43:31','2023-01-06 10:43:31');
INSERT INTO student_sessions VALUES('128','1','1','128','2','22','1','30885734','','2023-02-09 10:40:44','2023-02-09 10:40:44');
INSERT INTO student_sessions VALUES('129','1','1','129','1','17','1','70837907','','2023-03-07 12:52:23','2023-07-15 06:02:11');
INSERT INTO student_sessions VALUES('130','1','1','130','1','23','1','4870141','','2023-03-07 13:01:25','2023-03-07 13:01:25');
INSERT INTO student_sessions VALUES('131','1','1','131','1','16','1','96078089','','2023-04-07 15:16:55','2023-04-07 15:16:55');
INSERT INTO student_sessions VALUES('132','1','1','132','1','3','1','22023321','','2023-04-09 11:15:56','2023-04-09 11:15:56');
INSERT INTO student_sessions VALUES('133','1','1','133','1','3','1','61077864','','2023-04-09 21:30:16','2023-08-02 08:10:35');
INSERT INTO student_sessions VALUES('134','1','1','134','1','3','1','7038286','','2023-05-11 09:07:23','2023-05-11 09:07:23');
INSERT INTO student_sessions VALUES('135','1','1','135','1','1','2','83550831','','2023-05-23 10:53:47','2023-06-01 15:50:31');
INSERT INTO student_sessions VALUES('136','1','1','136','1','2','1','90005674','','2023-06-01 16:09:43','2023-06-01 16:09:43');
INSERT INTO student_sessions VALUES('137','1','1','137','1','3','1','1777653','','2023-06-01 16:33:26','2023-06-01 16:33:26');
INSERT INTO student_sessions VALUES('138','1','1','138','1','2','1','109-2','','2023-06-15 08:34:15','2023-07-09 08:12:56');
INSERT INTO student_sessions VALUES('139','1','1','139','3','24','1','96490401','','2023-07-20 07:28:34','2023-07-20 07:28:34');
INSERT INTO student_sessions VALUES('140','1','1','140','3','24','1','96040232','','2023-07-26 14:31:55','2023-07-26 14:31:55');
INSERT INTO student_sessions VALUES('141','1','1','141','2','22','1','50237368','','2023-07-28 15:32:45','2023-07-28 15:42:32');
INSERT INTO student_sessions VALUES('142','1','1','142','1','23','1','55349644','','2023-08-03 05:39:33','2023-08-03 05:39:33');
INSERT INTO student_sessions VALUES('143','1','1','143','1','23','1','23445633','','2023-08-03 05:41:15','2023-08-03 05:41:15');
INSERT INTO student_sessions VALUES('144','1','1','144','3','24','1','85882537','','2023-08-03 05:51:35','2023-08-03 05:51:35');
INSERT INTO student_sessions VALUES('145','1','1','145','2','22','1','63722881','','2023-08-04 17:30:20','2023-08-04 17:41:00');
INSERT INTO student_sessions VALUES('146','1','1','146','2','20','2','92561995','','2023-08-05 11:18:08','2023-08-05 11:21:48');



DROP TABLE IF EXISTS students;

CREATE TABLE `students` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `teacher_id` int(11) NOT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `father_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `birthday` date NOT NULL,
  `gender` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) DEFAULT 1,
  `blood_group` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `religion` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `home_phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `register_no` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activities` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO students VALUES('1','1','0','639','2','0','MONIS ALI','','BAQIR HUSSAIN','1998-05-05','Male','0','N/A','','923336865901','923166865901','BASTI BAGHPUR  P/O MANIKA SHAHJAMAL MUZAFFAR GARH','Punjab','Pakistan','01','','32304-9361752-1','SECURITY 17000','2021-10-05 10:57:05','2022-02-20 12:35:36');
INSERT INTO students VALUES('2','1','0','640','2','0','MUHAMMAD UMAIR SHAHID','','MUHAMMAD SHAHID HAFEEZ','1996-07-08','Male','0','N/A','MUSLIM','923314589200','923026757929','VPS RESIDENCE PAF COLLEGE SARGODHA','punjab','Pakistan','02','2','38403-8068871-1','SECURITY 17500','2021-10-05 11:11:35','2022-02-02 12:50:27');
INSERT INTO students VALUES('3','1','0','642','2','0','SYED MUHAMMAD ALI','','SYED ABID ALI SHAH','2003-07-24','Male','1','A+','MUSLIM','923478074730','923005710246','ABID HOUSE KARWAN ROAD MARDAN','PUNJAB','Pakistan','03','2','16101-3200951-5','SECURITY 20000','2021-12-04 17:38:22','2022-03-11 12:02:42');
INSERT INTO students VALUES('4','1','0','643','2','0','HAMD GHANI','','KASHIF JAVED','2002-09-05','Male','0','','','92314441111','923026666055','HOUSE#18 STREET#1 I.J. COLONY KHARIAN CANT','PUNJAB','Pakistan','04','','34202-3794702-5','SECURITY 20000','2021-12-04 17:47:35','2022-07-03 08:37:29');
INSERT INTO students VALUES('5','1','0','644','2','0','MAAZ KHAN','','BAKHT RO KHAN','2001-02-08','Male','0','A+','MUSLIM','923419331445','923344850966','MINGORA SWAT','KPK','Pakistan','05','','15602-7238059-5','SECURITY 22500','2021-12-04 17:51:45','2021-12-05 17:09:19');
INSERT INTO students VALUES('6','1','0','645','2','0','MUHAMMAD BILAL','','MUSTANSAR ATTA','1909-02-01','Male','0','A+','','923041844802','923055494686','1196 BLOCK L DHA PHASE6 LAHORE','PUNJAB','Pakistan','06','','11111111111111111','SECURITY 20000','2021-12-04 18:05:01','2022-02-17 15:42:47');
INSERT INTO students VALUES('7','1','0','646','2','0','SAAD JAVED','','MUHAMMAD JAVED','2005-01-30','Male','0','A+','MUSLIM','920340658928','9203465775939','HOUSE#J-65 NEW MODERN COLONY DARBAR ROAD KHEWRA','PUNJAB','Pakistan','7','2','37302-6970459-3','18500','2021-12-04 18:34:10','2023-06-01 15:48:53');
INSERT INTO students VALUES('8','1','0','647','2','0','MAJID ASLAM','','RIAZ  AHMED','1998-02-28','Male','0','A+','MUSLIM','9203087381833','92030567781300','WARIS HOUSE NASHAIMAN COLONY BOSAN ROAD MULTAN','PUNJAB','Pakistan','8','','36302-9897372-3','18500','2021-12-04 18:41:39','2022-08-03 06:00:48');
INSERT INTO students VALUES('9','1','0','648','2','0','HAAD ZUBAIR','','ZUBAIR AHMED','1900-02-21','Male','0','N/A','MUSLIM','92335659033','923216636716','HOUSE NO 20 3 BLOCK H SITIYANA ROAD FASILABAD','PUNJAB','Pakistan','9','','33100-7215524-1','18000','2021-12-04 18:49:17','2022-04-01 16:04:17');
INSERT INTO students VALUES('10','1','0','649','2','0','NABEEL AHMED','','FIAZ AHMED','2021-12-01','Male','0','A+','MUSLIM','923228895315','923028654950','534-B PEOPLE COLONY #1 FAISALABAD','PUNJAB','Pakistan','10','','33100-2142797-9','SECURITY 18000','2021-12-04 19:36:50','2022-03-15 06:59:28');
INSERT INTO students VALUES('11','1','0','650','2','0','MUHAMMAD ALI','','KALAB ABBAS','1996-04-23','Male','0','A+','MUSLIM','9233314952221','923127377006','NEAR DC HOUSE SIALKOT','PUNJAB','Pakistan','11','1','34602-6558724-7','SECURITY 10000','2021-12-04 19:41:41','2022-02-02 12:50:10');
INSERT INTO students VALUES('12','1','0','651','2','0','MUHAMMAD TALHA','','MUHAMMAD INAMULLAH','2002-06-27','Male','0','A+','MUSLIM','923145842415','923006443014','NASEEM INTERNATINAL STREET SIALKOT ROAD GUJJRANWALA','PUNJAB','Pakistan','12','2','42101-1351360-5','SECURIITY NILL','2021-12-04 19:49:14','2021-12-16 23:00:10');
INSERT INTO students VALUES('13','1','0','652','2','0','AHAD NASIR','','MUHAMMAD RAMZAN','1985-10-01','Male','0','A+','','923222736280','923433180356','DEFENCE VIEW PHASE 2 KORANGI EXPRESSWAY KARCHI','SINDH','Pakistan','13','1','42301-78628731-5','SEC 18500','2021-12-04 20:38:26','2022-04-08 10:29:43');
INSERT INTO students VALUES('14','1','0','653','2','0','SADAT KHAN','','ALLAH DADKHAN','2002-06-05','Male','0','A+','MUSLIM','923353021543','923128332345','SEHAR PETROLEUM SERVICE HOUSE#1 STREET KHUDADAD KHAN QUETTA','BALOCHISTAN','Pakistan','14','2','54401-4340599-7','security 19000','2021-12-05 11:29:59','2022-04-30 14:24:00');
INSERT INTO students VALUES('15','1','0','654','2','0','ALI USMAN','','MUHAMMAD ATEEQ REHMAN','1999-01-09','Male','1','A+','MUSLIM','923245725498','923217617920','HOUSE#2 BLOCK#4 GULSHAN COLONY TAXILA CANT','PUNJAB','Pakistan','15','2','37406-9603145-5','','2021-12-05 11:37:49','2021-12-05 11:37:49');
INSERT INTO students VALUES('16','1','0','655','2','0','WALEED AFZAL','','MUHAMMAD AFZAL','1997-08-04','Male','0','A+','MUSLIM','923166162629','96092626166130','ABC ROAD GULSHAN E HAYAT HOUSE NO. 90/A FAISALABAD','PUNJAB','Pakistan','16','2','36501-9564678-3','','2021-12-05 11:41:52','2022-08-11 06:17:48');
INSERT INTO students VALUES('17','1','0','656','2','0','ZAIN BIN KHALID','','SHEIKH KHALID MEHMOOD','1998-10-10','Male','1','A+','MUSLIM','923334742698','923077530736','HOUSE#15 CHAH MIRAN LAHORE','PUNJAB','Pakistan','17','2','35202-0211155-5','','2021-12-05 11:44:34','2021-12-05 13:57:31');
INSERT INTO students VALUES('18','1','0','657','2','0','MOIZ AHMED','','NADEEM ARSHAD','2037-05-21','Male','1','A+','MUSLIM','923024328496','923009615959','KHADIM ALI ROAD BEHRAM SIALKOT','PUNJAB','Pakistan','18','2','34603-9070883-7','','2021-12-05 11:47:53','2021-12-05 11:47:53');
INSERT INTO students VALUES('19','1','0','658','2','0','HASHAM TAYYAB','','MUHAMMAD TAYYAB ZAFAR','2002-09-12','Male','0','A+','MUSLIM','923207212423','923344409535','STREET#29 MOHALLAH GURU NANAK GUJJRANWALA','PUNJAB','Pakistan','19','2','34101-6615281-9','SECURITY 18000','2021-12-05 11:54:17','2022-01-27 20:14:48');
INSERT INTO students VALUES('20','1','0','659','2','0','MUHAMMAD ZEESHAN','','MUHAMMAD ILYAS','1996-07-15','Male','0','A+','MUSLIM','923453756634','923459617318','MANSEHRA','PUNJAB','Pakistan','20','1','13503-5358179-5','SECURITY 10000','2021-12-05 11:58:29','2022-01-27 20:14:35');
INSERT INTO students VALUES('21','1','0','660','2','0','ALI MURAD','','KHALID AHMED','1983-02-16','Male','1','A+','MUSLIM','923343599900','9211111111111','HYDERABAD','PUNJAB','Pakistan','21','','41303-1308714-1','SECURITY 18500','2021-12-05 12:03:45','2021-12-05 14:30:23');
INSERT INTO students VALUES('22','1','0','661','2','0','MUHAMMAD BILAL','','MUHAMMAD ASLAM','1998-08-27','Male','0','A+','MUSLIM','923037501835','923059432784','NEAR VPO KATHA SAGHRAL KHUSHAB','PUNJAB','Pakistan','22','1','38201-9825427-9','SECURITY NILL','2021-12-05 12:15:43','2022-06-02 10:38:40');
INSERT INTO students VALUES('23','1','0','662','2','0','MUHAMMAD TOUSEEF','','IMTIAZ AHMED','1998-02-16','Male','0','A+','MUSLIM','923233439188','923216642576','CHAK 200JB DISTRICT CHINIOT','PUNJAB','Pakistan','23','1','33201-9660491-7','SECURITY NILL','2021-12-05 12:35:10','2022-06-02 10:38:55');
INSERT INTO students VALUES('24','1','0','663','2','0','DANISH MUKHTAR','','AHMAD MUKHTAR','1997-02-28','Male','0','A+','MUSLIM','923317311904','923006627761','HOUSE CB 19 ST#1 ALLAMA IQBAL TOWN  CANT GUJRANWALA','PUNJAB','Pakistan','24','1','33102-6513634-7','SECURITY NILL','2021-12-05 12:39:02','2022-06-02 10:39:32');
INSERT INTO students VALUES('25','1','0','664','2','0','SAIM AHMED MIAN','','QAMAR UZ ZAMAN AHMED','2003-06-29','Male','0','A+','MUSLIM','923353064931','923007163060','HOUSE#17/33 MOHALLAH DANA ARIAN SIALKOT','PUNJAB','Pakistan','26','2','34603-5709803-3','SEC 17000','2021-12-05 12:52:37','2023-01-06 10:34:06');
INSERT INTO students VALUES('26','1','0','665','2','0','SYED MURSALEEN RIAZ','','SYED MUHAMAMD RIAZ SHAH','1998-05-06','Male','0','A+','MUSLIM','92301','923064488729','BUKHARI BROTHERS GRAIN MARKET HASILPUR','PUNJAB','Pakistan','27','2','31203-6877470-7','SEC 17000','2021-12-05 12:56:03','2022-06-02 11:03:05');
INSERT INTO students VALUES('27','1','0','666','2','0','ZEESHAN MUNIR','','MUNIR AHMED NASIR','1998-07-08','Male','0','A+','MUSLIM','923077837614','923006863732','PURANI BASTI TALKOT MUZAFAR GARH','PUNJAB','Pakistan','28','2','32304-0271632-9','SECURITY BALANCE','2021-12-05 12:59:17','2022-06-05 13:56:22');
INSERT INTO students VALUES('28','1','0','667','2','0','ABDUL REHMAN','','MUHAMMAD ASHRAF','1987-04-10','Male','0','','MUSLIM','923430999666','','PO GURUSAR CHAK 259/RB GURUPUR FASILABAD SADAR DISTRICT FASILABAD','PUNJAB','Pakistan','29','','33100-7119028-5','','2021-12-05 15:55:02','2021-12-31 12:34:04');
INSERT INTO students VALUES('29','1','0','668','2','0','BAHAR JAN','','SAEED AHMED','2000-02-03','Male','0','A+','MUSLIM','923337563023','923322226875','HOUSE#76 STREET #7 GREEN TOWN QUETTA','BALOCHISTAN','Pakistan','30','2','51301-3016247-2','SECURITY NILL','2021-12-05 16:40:10','2022-05-08 13:43:10');
INSERT INTO students VALUES('30','1','0','669','2','0','MUHAMMAD AMIN YOUSAF','','MUHAMMAD YOUSAF','2002-04-02','Male','0','A+','MUSLIM','923228182152','','LECTURER COLONY FLAT#2 JINAH ROAD QUETTA','BALOCHISTAN','Pakistan','31','2','52203-5213716-3','SECURTY 8000','2021-12-05 16:54:57','2022-05-08 13:43:37');
INSERT INTO students VALUES('31','1','0','670','2','0','ZEESHAN MAQBOOL','','MAQBOOL AHMED','2004-09-10','Male','0','A+','MUSLIM','923012308408','','GULSHN- E- IQBAL CRESENT COMPLEX BLOCK-11FLOOR F6','PUNJAB','Pakistan','32','2','52101-46066381','SECURITY 5000','2021-12-05 17:01:59','2022-05-08 13:43:25');
INSERT INTO students VALUES('32','1','0','671','2','0','SHAHZAIN MUSHTAQ','','MUSHTAQ AHMED','2004-05-05','Male','0','A+','MUSLIM','923426913900','923228101221','FLAT NO. B-50 FLOOR#06 GULSHAN E JOHAR KARACHI','SINDH','Pakistan','33','2','52204-4981769-7','SEC 5000','2021-12-05 17:05:29','2022-05-08 13:43:49');
INSERT INTO students VALUES('62','1','0','703','2','0','HARIS  SOHAIL','','MUHAMMAD SOHAIL ANWAR','2000-07-22','Male','0','A+','MUSLIM','923348168438','923224808181','159 EDEN COTTAGES PHASE 2 LAHORE CANTT','PUNJAB','Pakistan','6440489','2','35201-7627710-7','','2022-03-05 17:03:46','2022-07-03 08:40:25');
INSERT INTO students VALUES('33','1','0','672','2','0','HARIS SHEROZE KHAN','','IFTIKHAR AHMAD','1996-07-15','Male','0','','','03321524601','','HOUSE NO B2 542 STREET MASJID TAYYABA JHELUM ROAD CHAKWAL','PUNJAB','Pakistan','34','1','37201-3002548-5','','2021-12-07 11:40:21','2022-02-02 12:49:59');
INSERT INTO students VALUES('34','1','0','673','2','0','HAMZA LIAQAT','','LIAQAT ALI','1997-01-10','Male','0','','','03028961743','','CHAKWAL','PUNJAB','Pakistan','35','','37202-3790036-3','12500','2021-12-07 18:29:53','2022-02-02 12:39:36');
INSERT INTO students VALUES('35','1','0','674','2','0','MUHAMMAD ALI RAZA','','RAJA WAHEED SIKANDER','1999-09-11','Male','1','','','023085542883','03350729727','SHAHEEN ST NO 2 H NO 19 GULGHOST COLONY MULTAN','PUNJAB','Pakistan','36','','34402-4004651-9','SEC 10000','2021-12-08 11:27:12','2022-09-03 17:59:28');
INSERT INTO students VALUES('36','1','0','675','2','0','SHAHBAZ SALEEM KHAN','','MUHAMMAD SALEEM KHAN','2004-02-08','Male','0','','','03176218899','03101466999','MOH USMAN KHEL TAHIR BAGH TAKHTA BAND TEHSIL BABUZAI','KPK','Pakistan','37','','15602-5521909-9','M/O DECEMBER 2021','2021-12-08 18:14:05','2022-06-02 11:12:41');
INSERT INTO students VALUES('37','1','0','676','2','0','KAMIL RIAZ','','M RIAZ','2002-01-08','Male','0','','','03430934230','','SAWAT TEHSIL BARICOT','KPK','Pakistan','38','','15602-7400715-1','M/O DECEMBER 2021','2021-12-09 10:38:53','2022-06-02 11:10:12');
INSERT INTO students VALUES('38','1','0','677','2','0','M ALI ABBAS','','MANZOOR HUSSAIN','2003-08-03','Male','0','','','03136168223','03017453728','MAUZA FAZILPUR NAVIL PUR MULTAN','PUNJAB','Pakistan','39','','36303-4978521-1','M/O DECEMBER 2021','2021-12-09 19:15:12','2022-07-14 10:55:06');
INSERT INTO students VALUES('39','1','0','678','2','0','ABDULLAH HUSSAIN','','MAZHAR HUSSAIN','2003-04-30','Male','0','A+','MUSLIM','923109173987','','ABBOTABAD NAWA SHEHR','KPK','Pakistan','41','2','13101-6339092-1','','2021-12-17 20:40:39','2022-02-02 16:50:28');
INSERT INTO students VALUES('40','1','0','679','2','0','JAHANZAIB KHAN','','SAFDAR HUSSAIN KHAN','1981-01-01','Male','1','A+','MUSLIM','923007338840','923007338860','P.O SARGANA MOUZA SHAMAN VEHARI','PUNJAB','Pakistan','42','1','36602-6020195-7','SECURITY17000','2021-12-17 20:44:21','2021-12-17 20:44:21');
INSERT INTO students VALUES('41','1','0','680','2','0','ZAIN UL ABIDEEN BANGSH','','NOOR MUHAMMAD','1987-09-08','Male','0','A+','MUSLIM','923102329337','923332191267','KDA OFFICERS COLONY KOHAT KPK','KPK','Pakistan','43','','42401-7493217-3','SECURITY 17000','2021-12-31 12:30:45','2022-02-02 12:40:48');
INSERT INTO students VALUES('42','1','0','681','2','0','SYED ALI ABBAS GILLANI','','SYED RIAZ HUSSAIN','1982-04-05','Male','1','A+','MUSLIM','923006328500','','ADDA LAR MULTAN','PUNJAB','Pakistan','44','1','36303-2361586-1','SECURITY 17500','2021-12-31 12:42:24','2021-12-31 12:42:24');
INSERT INTO students VALUES('43','1','0','682','2','0','NASIR SHABBIR','','MALIK GHULAM SHABBIR','1981-04-01','Male','1','A+','MUSLIM','923007488846','923006568883','P/O NAWAB PUR KHAS MULTAN','PUNJAB','Pakistan','45','1','36302-5300956-9','SECURITY 17500','2021-12-31 12:46:06','2021-12-31 12:46:06');
INSERT INTO students VALUES('44','1','0','683','2','0','SHAH FAHAD RAHIM','','RAHIM DAD','1986-01-02','Male','1','','MUSLIM','023339147485','03339109449','HOUSE NO  631 STREET NO 20 SECTOR S6 PHASE 7 HAYATABAD PESHAWAR','KPK','Pakistan','46','1','17301-9419222-1','SECURITY 5000','2022-01-02 17:57:26','2022-09-03 18:19:43');
INSERT INTO students VALUES('45','1','0','684','2','0','AFAF AHMAD','','GBAKCFGBD','1111-01-01','Male','0','A+','MUSLIM','923224455299','','LAHORE','PUNJAB','Pakistan','47','1','11111-1111111','SECURITY 18500','2022-01-02 21:30:17','2022-04-07 07:45:16');
INSERT INTO students VALUES('46','1','0','685','2','0','MUHAMMAD IMRAN SIKANDER','','DEFAULT','1982-08-14','Male','1','N/A','MUSLIM','923217591121','923017570705','HOUSE#1941AKBAR ROAD MULTAN','PUNJAB','Pakistan','48','1','36302-0365545-3','SECURITY 17500','2022-01-03 13:10:11','2022-02-02 16:55:50');
INSERT INTO students VALUES('47','1','0','686','2','0','ABDULLAH ALTAF','','ALTAF QURESHI','1998-12-25','Male','0','A+','MUSLIM','03168424512','03129739186','HOUSE#60  ABUZAR STREET KEHAL ABBOTTABAD','K.P.K','Pakistan','49','1','13101-2070290-7','MONTH OF JANVARY','2022-01-10 11:23:56','2022-01-20 16:34:24');
INSERT INTO students VALUES('48','1','0','687','2','0','SARDAR SAQIB NAWAZ','','SARDAR M NAWAZ','1983-03-18','Male','0','A+','MUSLIM','03335720080','','ABBOTTABAD','KPK','Pakistan','50','1','13101-6302461-1','','2022-01-12 16:22:34','2022-02-02 17:52:46');
INSERT INTO students VALUES('49','1','0','688','2','0','AHMAD RAZA','','ALLAH BAKHASH','2021-12-01','Male','0','A-','MUSLIM','023441148159','03097710790','P/O BOSAL MASOOR DISTRICT MANDI BUDIN TEHSIL MALKWAL','PUNJAB','Pakistan','51','2','34403-8304102-1','9 DAYS PAY','2022-01-23 19:11:08','2022-11-03 06:21:43');
INSERT INTO students VALUES('50','1','0','689','2','0','AIZAZ RAHIM KHAN','','MISKEEN KHAN','1989-10-03','Male','0','A+','MUSLIM','923055500016','923339762144','HOUSE NO 742 STREET NO 20 SECTOR F9 PHASE 6 HAYATABAD PESHAWAR','PUNJAB','Pakistan','52','1','17301-4730646-3','15000','2022-01-27 20:23:27','2023-07-08 15:53:06');
INSERT INTO students VALUES('51','1','0','690','2','0','SYED SHAH HUSSAIN','','SYED SHAH MIRAN SHAH','1996-12-08','Male','1','A+','MUSLIM','92334','92334-9852186','HOUSE NO 634, SEC F9 ,PHASE -6 , HAYATABAD, PESHAWAR','PUNJAB','Pakistan','53','1','14101-4206296-5','','2022-01-28 20:46:21','2022-03-03 11:42:54');
INSERT INTO students VALUES('52','1','0','691','2','0','MUHAMMAD ASIM KHAN','','MUHAMAMD QASIM','1982-03-19','Male','0','A+','MUSLIM','0347-9700019','0333-9198189','HOUSE NUM 118 SECTOR E 1 STREET 7 PHASE 1 HAYATABAD PESHAWAR.','PUNJAB','Pakistan','54','1','17301-1469771-1','8 DAYS  PAY ONLY.','2022-01-31 20:25:32','2022-02-26 09:57:50');
INSERT INTO students VALUES('53','1','0','692','2','0','AHMAD AWAN','','SHAHID MEHMMOD','2002-01-01','Male','0','A+','MUSLIM','923019704767','923107132083','JAUHRABAD KHUSHAB','PUNJAB','Pakistan','55','2','34604-0485163-3','SECURITY 15000','2022-02-02 12:43:33','2022-07-14 10:54:18');
INSERT INTO students VALUES('54','1','0','693','2','0','MUHAMAMD MUSTAJAB GOHAR','','BASHARAT ALI','2000-09-12','Male','0','A+','MUSLIM','923038499807','03006202336','CHEEMA COLONY SIALKOT ROAD WAZIRABAD.','PUNJAB','Pakistan','56','1','34104-2201806-5','SECRUITY 17500','2022-02-03 17:49:07','2022-03-15 07:31:02');
INSERT INTO students VALUES('55','1','0','694','2','0','RASHID JAVED LODHI','','MUHAMMAD YAQOOB','1976-06-23','Male','0','A+','MUSLIM','923007427083','923217933300','247 N BLOCK SABZAZAR LAHORE','PUNJAB','Pakistan','57','1','35202-3199850-9','20 DAYS','2022-02-12 20:46:04','2022-04-01 09:05:09');
INSERT INTO students VALUES('56','1','0','695','2','0','SYED MURTAZA ABBAS','','SYED  MASOOR HUSSAIN SHAH','2001-08-06','Male','0','A+','MUSLIM','923215858598','923005497708','ATTOCK CITY.','PUNJAB','Pakistan','1','1','37101-3022423-1','20 DAYS PAY ONLY','2022-02-20 13:40:11','2022-06-28 08:43:44');
INSERT INTO students VALUES('57','1','0','696','2','0','SAVEED','','ALI KHAN','1991-09-12','Male','0','A+','MUSLIM','923111672088','923111672088','CHARSADDA  KPK','KPK','Pakistan','84209879','1','17101-2787326-1','','2022-02-20 19:30:41','2022-04-01 09:05:30');
INSERT INTO students VALUES('58','1','0','697','2','0','JUNAID HABIB','','HABIB UR REHMAN','1990-09-09','Male','1','A+','MUSLIM','923152295884','923452582344','HOUSE NO 142 SECTOR 4/E KARACHI','SINDH','Pakistan','48331770','1','42401-2945656-9','','2022-02-20 19:48:18','2022-02-20 19:48:18');
INSERT INTO students VALUES('59','1','0','698','2','0','IMAD KHAN','','SHAH JEHAN','1997-05-21','Male','0','A+','MUSLIM','92333874751','92346555321','HOUSE NUM 103 STREET 6 SECTOR F6 PHHASE 6 HAYATABAD PESHAWAR.','PUNJAB','Pakistan','5615432','1','17102-0186187-1','PAY ONLY 5 DAYS','2022-02-22 14:01:10','2022-07-23 08:27:53');
INSERT INTO students VALUES('60','1','0','699','2','0','ABDULLAH','','TOHSEEN ULLAH','1996-10-03','Male','0','A+','MUSLIM','923345729390','920435356353','SHERPAO TEHSIL JANGI  DISTRICT CHARSADDA','PUNJAB','Pakistan','11651656','1','17102-2118965-1','PAY ONLY 5 DASY','2022-02-22 14:08:12','2022-07-14 07:25:18');
INSERT INTO students VALUES('61','1','0','702','2','0','UMAMA ZAHOOR','','ZAHOOR AHMAD','1998-03-26','Male','0','A+','MUSLIM','923415937509','923010105319','VILLAGE DHAR DHARACH AFZAL ABAD DISTRIC SUDHNOTI TEHSIL AZAD KASHMIR','AZAD KASHMIR','Pakistan','33184044','2','82401-3491211-6','M/O MARCH 2022','2022-03-03 12:14:08','2022-04-09 14:09:55');
INSERT INTO students VALUES('63','1','0','704','2','0','ATTA ULLAH JAN','','MUHAMMAD DAOUD','1991-03-16','Male','1','A+','MUSLIM','923667676767','9235353535533','PO UTMANZAI  PAREECH KHEL TEH AND DISTRIC CHARSADDA','PUNJAB','Pakistan','42082225','1','17101-0102627-9','M/O FEB 22','2022-03-12 15:05:51','2022-05-22 12:19:26');
INSERT INTO students VALUES('64','1','0','705','2','0','MUHAMMAD USMAN NASEER','','MUHAMMAD NASEER','1976-10-10','Male','0','A+','MUSLIM','923218823151','923244272365','H# 29 -A FAROOQ STREET 21 MAIN JAIL ROAD LAHORE','PUNJAB','Pakistan','48237873','1','35202-9704105-5','','2022-03-12 15:30:34','2022-07-14 10:54:38');
INSERT INTO students VALUES('65','1','0','706','2','0','MUHAMMAD UMAR FAHIM','','FAHIM SHAHID','1993-02-06','Male','1','A+','MUSLIM','923009002693','923339336355','THE ONX E11/2 ISLAMABAD','KPK','Pakistan','79273340','1','17301-8287602-5','PAY ONLY 17 DAYS','2022-03-15 07:05:56','2022-03-15 07:05:56');
INSERT INTO students VALUES('66','1','0','707','2','0','AHMAD SUBHAN','','MUHAMMAD ASLAM','2000-11-29','Male','1','A+','MUSLIM','923055153606','923369890825','HOUSE# 12 ST # 123 BLOCK A JINNAH GARDEN ISLAMABAD','KPK','Pakistan','8305630','2','36102-8427322-1','PAY ONLY 20 DAYS','2022-03-15 07:38:43','2022-03-15 07:38:43');
INSERT INTO students VALUES('67','1','0','708','2','0','SHAHID RASHID','','MUHAMMAD RASHID KHAN','1975-04-06','Male','0','A+','MUSLIM','923325140706','923545565762','MUTIAL MARA RAWALAKOT AJK','PUNJAB','Pakistan','42285228','1','82303-1004460-1','','2022-04-04 11:44:25','2022-11-06 14:36:51');
INSERT INTO students VALUES('68','1','0','709','2','0','KASHIF ALI ZAMAN','','RAJA ZAMIN ABBAS KHAN','1998-01-10','Male','0','A+','MUSLIM','923055336764','923425080407','VILLAGE MEHMUN PUR POST OFFICE JALLAN MIR PUR A.K','KPK','Pakistan','69680356','2','81302-4709834-7','','2022-04-06 11:49:22','2022-11-16 16:57:32');
INSERT INTO students VALUES('69','1','0','710','2','0','ALLAH NAWAZ','','HAMEED AKHTAR','1998-05-20','Male','0','A+','MUSLIM','923000678283','923038608372','VILLAGE DARVI P/O 14 MB DISTRICT KUSHHAB','PUNJAB','Pakistan','79949505','','38202-2918710-7','','2022-04-08 09:33:16','2022-12-22 05:34:34');
INSERT INTO students VALUES('70','1','0','711','2','0','SHAHZAIB KHURSHID','','KHURSHID AHMAD','1997-12-08','Male','0','A+','','923170886491','92345675657','DUDIAL ROAD TELEPHONE EXCHANGE CHAKWAL','PUNJAB','Pakistan','58640571','2','37203-1524680-1','10000 SECRUITY PAY ANOTHER HOSTAL','2022-04-08 10:39:35','2022-07-14 10:50:28');
INSERT INTO students VALUES('73','1','0','714','2','0','MURTAZA ZAMAN','','SIBTAL HUSSAIN','1973-04-10','Male','1','A+','MUSLIM','923007334127','923344556444','BOHAR GATE MULTAN','PUNJAB','Pakistan','47154611','1','36302-7905119-1','','2022-05-10 15:28:46','2022-05-10 15:28:46');
INSERT INTO students VALUES('71','1','0','712','2','0','NOUMAN SAFIR','','SAFIR IQBAL','1996-12-11','Male','0','A+','MUSLIM','923178040898','923405436879','HOUSE 20 STREET 160 G 1313 ISLAMABAD','ISLAMABAD','Pakistan','28339600','2','37405-555478-1','ONLY PAID 9 DAYS','2022-04-23 14:54:32','2022-06-13 14:13:43');
INSERT INTO students VALUES('72','1','0','713','2','0','KASHIF KHAN LODHI','','M.RIAZ LODHI','1985-06-18','Male','1','A+','MUSLIM','922331986639','9236556565665','AZAM TOWN THANDA CHOA PMA ABBOTTABAD','KPK','Pakistan','91351692','1','13101-9198880-1','','2022-04-28 08:34:36','2022-04-28 08:34:36');
INSERT INTO students VALUES('74','1','0','715','2','0','SYED ASGHAR ABBAS','','SYED ABDUL HASSEB','1997-05-03','Male','1','','MUSLIM','923216311499','923645446645','GULSHAN COLONY HOUSE NUM 94 MULTAN','PUNJAB','Pakistan','63987493','1','36302-6101566-7','','2022-05-11 07:08:21','2022-05-11 07:08:21');
INSERT INTO students VALUES('75','1','0','716','2','0','SHOUKAT HUSSAIN','','M.BAKHSH','1978-05-16','Male','1','A+','MUSLIM','923116961723','923736736336','CHAH MANDAN WALA P/O CHAK TEHSIL SHUJASED DISTRIC MULTAN','PUNJAB','Pakistan','42643245','1','36304-1535858-1','','2022-05-11 07:23:42','2022-05-11 07:23:42');
INSERT INTO students VALUES('76','1','0','717','2','0','KASHIF AZIZ','','ABDUL AZIZ','1985-11-20','Male','0','A+','','923146555553','923146171717','NEAR INCOME TAX COLONY MULTAN','PUNJAB','Pakistan','50163277','1','36302-9395822-3','','2022-05-11 12:11:39','2022-07-14 07:26:12');
INSERT INTO students VALUES('77','1','0','718','2','0','M,WAQAS HASSAN','','KHARIR HAYAT','1985-09-06','Male','1','A+','MUSLIM','923249634462','9234534433331','HOUSE NUM 557/711 PAK GATE MULTAN','PUNJAB','Pakistan','96124247','1','36302-5709119-5','','2022-05-11 12:35:56','2022-05-11 12:35:56');
INSERT INTO students VALUES('78','1','0','719','2','0','ZAIN UL ABEDIN','','ZARRAR ALI','2000-02-18','Male','0','A+','MUSLIM','923350167670','096765565545','HOUSE #428 STREET 11 KHAYABAN GARDEN SARGOHDA ROAD FAISALABAD','PUNJAB','Pakistan','30124821','1','42101-7844430-1','MAY/22','2022-05-22 12:39:58','2022-07-14 10:36:55');
INSERT INTO students VALUES('79','1','0','720','2','0','FARZAUQ JANG','','ZAMIR JANG','1996-12-24','Male','0','A+','MUSLIM','923451200004','923315958485','HAYATABAD PHASE 7','PUNJAB','Pakistan','63360019','1','16101-1299798-3','','2022-05-22 13:08:26','2022-09-03 18:29:38');
INSERT INTO students VALUES('80','1','0','721','2','0','MUHAMMAD AMIN','','YOUSAF','2004-02-04','Male','0','A+','MUSLIM','923228182152','923313001462','BLOCK# JINNAH ROAD QUETTA','PUNJAB','Pakistan','4135660','2','52203-5213716-3','','2022-05-23 08:11:00','2022-06-25 15:53:07');
INSERT INTO students VALUES('81','1','0','722','2','0','BILAL ISHAQ','','MUHAMMAD ISHAQ','1986-03-23','Male','1','A+','MUSLIM','923036509371','923051170321','BASTI SAILABAD DISTRICT & TEHSIL MULTAN','PUNJAB','Pakistan','43082387','1','36303-7563315-8','','2022-05-31 07:49:48','2022-11-02 16:47:00');
INSERT INTO students VALUES('82','1','0','723','2','0','HASSAN','','M.ALI','2000-07-06','Male','0','A+','MUSLIM','920245435455','925554768678','MULTAN','PUNJAB','Pakistan','20248877','1','13242-2776565-4','','2022-06-02 10:34:53','2022-07-03 08:41:33');
INSERT INTO students VALUES('83','1','0','724','2','0','MOHSIN SAJJAD','','SAJJAD SDDQUE','1997-02-09','Male','0','A+','MUSLIM','923037015906','923016420466','MAHALLAH MUSLIM COLONY SATRAH ROOD KASOUR','PANJAB','Pakistan','33695193','1','34602-9768836-1','','2022-06-02 14:47:49','2022-10-05 07:43:41');
INSERT INTO students VALUES('84','1','0','725','2','0','ABDULLAH YOUNIS','','MUHAMMAD YOUNIS','1999-01-11','Male','0','A+','MUSLIM','923470962129','923441080657','MIRPUR AJK','PUNJAB','Pakistan','95268246','1','38302-8233673-1','','2022-06-04 05:20:57','2022-08-03 05:51:58');
INSERT INTO students VALUES('85','1','0','726','2','0','FEHNAN MUNIR','','MUNIR HUSSAIN','1996-08-27','Male','0','A+','MUSLIM','923012626413','923238553119','HOUSE NO D-20 AERO OFFICER COLONY HAZARA ROAD, HASSAN ABDAL ATTACK','PUNJAB','Pakistan','28529082','1','32304-7928752-1','','2022-06-04 05:32:40','2023-07-13 16:03:24');
INSERT INTO students VALUES('86','1','0','727','2','0','FIAZ HUSSAIN BOSIN','','FIDA HUSSAIN','1978-03-25','Male','1','A+','MUSLIM','923017503247','923450705804','GULGAShT COLONY, MULTAN.','PUNJAB','Pakistan','63585278','1','36303-0995874-1','','2022-06-04 05:43:50','2022-08-13 07:20:52');
INSERT INTO students VALUES('87','1','0','728','2','0','MUHAMMAD ABID IQBAL','','MUHAMMAD PERVAIZ AKHTER','1997-03-04','Male','1','A+','MUSLIM','923009874978','923187649881','CHAWA, TEHSL, BHERA,DISTT.SARGODHA','PUNJAB','Pakistan','65356284','1','38401-5596002-3','','2022-06-05 14:01:26','2022-06-05 14:01:26');
INSERT INTO students VALUES('88','1','0','729','2','0','RASHID NAWAZ','','ALI NAWAZ','1997-03-05','Male','0','A+','MUSLIM','923082745020','923003350228','SAMGHAR SINDH SFUDENT OF NARRAD UNIVESITY MIANWAH.','PUNJAB','Pakistan','29996850','1','44201-7753228-1','','2022-06-05 14:17:02','2022-06-05 14:26:56');
INSERT INTO students VALUES('89','1','0','730','2','0','MUHAMMAD ISRAR KHAN','','FAQIZ MUHAMMAD','2022-04-06','Male','0','A+','MUSLIM','923339696758','923333288838','VILLAGE SIWARA BASA, TEHSIL GAPRA,DISTT BUMER,KPK','PUNJAB','Pakistan','17702957','1','15101-0381529-9','','2022-06-05 14:36:08','2022-09-03 17:43:14');
INSERT INTO students VALUES('90','1','0','731','2','0','RASHID NAWAZ','','ALI NAWAZ','1997-03-05','Male','0','A+','MUSLIM','923082745020','923003350228','SANGHAR SINDH SFUDENT OF NARRAL UNIVESITY MIANWAH','PUNJAB','Pakistan','21753753','1','44201-7753228-1','','2022-06-05 14:46:54','2022-07-03 08:36:54');
INSERT INTO students VALUES('91','1','0','732','2','0','ZAKI HAFEEZ MALIK','','MUHAMMAD HAFEEZ MALIK','1990-02-07','Male','1','A+','MUSLIM','023403394354','03449522200','CANTT ABBOTTABAD','KPK','Pakistan','54997139','1','13101-2326754-4','','2022-06-25 15:55:13','2022-06-25 15:55:13');
INSERT INTO students VALUES('92','1','0','733','2','0','HARIS DILDAR','','DILDAR KHAN','1997-02-14','Male','1','A+','MUSLIM','923401595604','923477314750','HOUSE 55 PHASE 3 MEHRIA TOWN ATTOCK','PUNJAB','Pakistan','27519818','1','37101-0967946-7','','2022-07-03 07:17:54','2022-07-03 07:17:54');
INSERT INTO students VALUES('93','1','0','734','2','0','MALIK MUHARAM ZEB','','SHEHZADA','1996-03-25','Male','0','A+','MUSLIM','923109591324','923109591324','DAK KHALL TAHSEEL DARA TOORNAG','PUNJAB','Pakistan','15374725','1','15302-1896639-7','','2022-07-03 07:47:06','2022-07-03 08:36:36');
INSERT INTO students VALUES('94','1','0','735','2','0','MUHAMMAD SAJID RASHID','','RASHID AHMAD','1986-04-03','Male','1','A+','MUSLIM','923464116882','923456332431','ISLAM NAGAR CHACK NO 81 TEHSIL SHAHKOT','PUNJAB','Pakistan','4934095','1','35403-7222725-5','','2022-07-03 11:16:56','2022-07-03 11:16:56');
INSERT INTO students VALUES('95','1','0','736','2','0','M WASEEM ASHRAF RANA','','ASHRAF RANA','2027-09-13','Male','1','A+','MUSLIM','923016196704','9255555545','NICL BUILDING, JINNAH AVENUE ,F-7 ISLAMABAD','PUNJAB','Pakistan','24095334','','34502-4918044-3','','2022-07-14 10:11:22','2022-07-14 10:11:22');
INSERT INTO students VALUES('96','1','0','737','2','0','SYED ASIF ALI','','SYED ISRAR ALI','2017-05-07','Male','1','A+','MUSLIM','923370613479','92555555555','NICL BUILDING, JINNAH AVENUE F-7 ISLAMABAD','PUNJAB','Pakistan','85862693','1','35202-7945667-9','','2022-07-14 10:17:49','2022-07-14 10:17:49');
INSERT INTO students VALUES('97','1','0','738','2','0','M HAMZA','','M SAUD','2015-06-20','Male','1','A+','MUSLIM','923489666365','923339108623','CANAL ROAD NEAR TESCO STATION TAJABAD PESHAWAR','PUNJAB','Pakistan','25718045','2','14101-7682308-1','','2022-07-14 10:34:49','2022-07-14 10:34:49');
INSERT INTO students VALUES('98','1','0','739','2','0','HADI HASSAN RAFIQUE','','M RAFIQUE','2020-06-07','Male','1','A+','MUSLIM','923000881871','923457258950','H. NO 63 GULSHAN FAIZ COLONY BORON ROAD MULTAN','PUNJAB','Pakistan','98020490','1','36303-0346846-3','DISCOUNT 1000 REFFRENCE (ABID SB)','2022-07-14 10:46:40','2023-08-03 05:55:34');
INSERT INTO students VALUES('99','1','0','740','2','0','SARFRAZ NAWAZ','','MUHAMMAD NAWAZ','0008-09-05','Male','0','A+','MUSLIM','923007377826','923007377825','HOUSE NO CB-288/J, STREET BESIDES ALFALAH BANK, SHER SHAH ROAD GARDEN TOWN MULTAN','PUNJAB','Pakistan','35554160','1','36302-2493217-7','','2022-07-16 06:16:40','2023-07-10 06:21:48');
INSERT INTO students VALUES('100','1','0','741','2','0','ADNAN MASUD','','MASUD ZAFAR','1982-02-10','Male','1','A+','MUSLIM','923333201211','923224378467','SAUDI PAK TOWER ISLAMABAD','PUNJAB','Pakistan','68329230','1','42201-3261342-7','','2022-07-20 05:39:48','2022-07-20 05:39:48');
INSERT INTO students VALUES('101','1','0','742','2','0','ASAD IQBAL','','MUHAMMAD IQBAL','1986-12-11','Male','1','A+','MUSLIM','923335070107','923319866397','SAUDI PAK TOWER ISLAMABAD','PUNJAB','Pakistan','52468343','1','13504-1958286-1','','2022-07-20 05:51:52','2022-07-20 05:51:52');
INSERT INTO students VALUES('102','1','0','743','2','0','CH ALI MURTAZA','','CH GHULAM MURTAZA','2001-03-23','Male','1','A+','MUSLIM','923168527976','923465744623','CHAKWAL','PUNJAB','Pakistan','34065272','1','37201-2906766-5','','2022-07-20 05:58:12','2022-07-20 05:58:12');
INSERT INTO students VALUES('103','1','0','744','2','0','AHMAD NAEEM','','M NAEEM KHAN','1989-04-07','Male','0','A+','MUSLIM','923378020086','92334-2662023','PAK SAUDI TOWER ISLAMABAD','PUNJAB','Pakistan','76118216','1','41204-1902016-1','','2022-07-20 06:07:46','2023-05-11 09:01:36');
INSERT INTO students VALUES('104','1','0','745','2','0','M QAISAR','','M GOHAR','1992-10-20','Male','1','A+','MUSLIM','923469367146','923159320907','MARDAN','KPK','Pakistan','85952566','1','16101-8779235-3','','2022-07-21 09:54:14','2022-07-21 09:54:14');
INSERT INTO students VALUES('105','1','0','746','2','0','FAHAD NAEEM BABAR','','NAEEM ASAD BABAR','1998-04-26','Male','1','A+','MUSLIM','923075411764','920000056','H# 481/2 PO JHANGI ,ABBOTABAD ,KPK','KPK','Pakistan','85352930','1','13101-5687818-1','','2022-07-23 08:36:24','2022-07-23 08:36:24');
INSERT INTO students VALUES('106','1','0','747','2','0','SADDIQUE MUJTABA','','AZHAR HUSSAIN','2003-03-08','Male','1','A+','MUSLIM','923359016712','923348703960','UPO THOHA BAHADUR DISTRICT CHAKWAL','PUNJAB','Pakistan','5102696','2','37201-7070777-9','','2022-07-23 08:45:05','2022-07-23 08:45:05');
INSERT INTO students VALUES('107','1','0','748','2','0','DANIYAL MIR','','MUSHTAQ MIR','1985-07-12','Male','1','A+','MUSLIM','923085995390','923446618977','MUZAFARABAD AJK','PUNJAB','Pakistan','20631178','1','82203-4523293-7','','2022-07-24 08:34:34','2022-07-24 08:34:34');
INSERT INTO students VALUES('108','1','0','749','2','0','KAMRAN HUSSAIN','','GHULAM HUSSAIN','1992-09-03','Male','0','A+','MUSLIM','923129733366','923467202060','SAUDI PAK TOWER','PUNJAB','Pakistan','1536695','1','71501-8175988-5','','2022-07-24 08:40:43','2022-08-06 16:37:37');
INSERT INTO students VALUES('109','1','0','750','2','0','ABID KHAN','','M ALI','2020-06-19','Male','0','A+','MUSLIM','923403231673','923456153790','DISTRICT BARKHAN TEHSIL RAKHNI PROVINCE BALOCHISTAN','BALOCHISTAN','Pakistan','60307973','2','45503-1113982-3','','2022-08-03 06:04:50','2022-11-16 17:16:43');
INSERT INTO students VALUES('110','1','0','751','2','0','M AQIL BHATTI','','M ADEEL','0007-03-11','Male','1','A+','MUSLIM','923334372705','9233333333333','HOUSE# 218 SECTOR D ASKARI 10 LAHORE CANT','PUNJAB','Pakistan','37538584','1','17301-2003373-7','','2022-08-06 16:42:44','2022-08-06 16:42:44');
INSERT INTO students VALUES('111','1','0','752','2','0','AHMAD FAROOQ','','MALIK SOHAIL','2014-03-15','Male','1','A+','MUSLIM','923409225100','923009598241','SAUDI TOWER','PUNJAB','Pakistan','87509632','1','17301-1053834-5','','2022-08-11 06:28:41','2022-08-11 06:28:41');
INSERT INTO students VALUES('112','1','0','753','2','0','ABDULLAH','','SHABBIR','2014-03-15','Male','0','A+','MUSLIM','9233333336','9*255464545','SWABI','KPK','Pakistan','27918780','','36502-5645687-2','','2022-09-02 10:26:58','2022-09-03 17:42:12');
INSERT INTO students VALUES('113','1','0','754','2','0','AQEEL AHMAD ABBASI','','JAMIL AHMAD ABBASI','2035-10-13','Male','1','A+','MUSLIM','923462200062','03557126767','JOB HUWAEI','PUNJAN','Pakistan','51855834','1','82501-0353408-5','','2022-09-05 20:58:13','2022-09-05 21:00:00');
INSERT INTO students VALUES('114','1','0','755','2','0','NOMAN KHAN','','FAZAL MANAN KHAN','2019-04-20','Male','0','A+','MUSLIM','923431301146','921111111114','MOHALA MODEL TOWN D.I .KHAN','PUNJAB','Pakistan','8683674','1','12101-8192736-1','','2022-09-05 21:22:51','2023-05-11 09:00:53');
INSERT INTO students VALUES('115','1','0','756','2','0','AMIR SOHAIL','','AMANULLAH','2018-10-18','Male','1','A+','MUSLIM','923499285597','9233336654','CIVIL LINE DIST TANK','PUNJAB','Pakistan','70654408','1','12201-0599807-9','','2022-09-05 21:26:01','2022-09-05 21:26:01');
INSERT INTO students VALUES('116','1','0','757','2','0','ZAHID ALI KHAN','','FIAZ HUSSAIN','2023-01-13','Male','1','A+','MUSLIM','923017710200','92306771021','JUGAT PIR CHOLASTAN TEHSIL YENGER DIST BAHAWALPUR','PUNJAB','Pakistan','1227354','1','31204-6372907-5','','2022-09-07 18:06:38','2022-09-07 18:06:38');
INSERT INTO students VALUES('117','1','0','758','2','0','SHAN ALI','','AMANAT ALI','2014-12-15','Male','1','A+','MUSLIM','923007633339','923636363636','339 J.B TEHSIL GOJRA DISTRICT TOBA TAKE SINGH','PUNJAB','Pakistan','60678601','1','33301-9862115-3','','2022-09-07 18:17:49','2022-09-07 18:17:49');
INSERT INTO students VALUES('118','1','0','759','2','0','SABIH UL HUSNAIN','','MUBARAK ALI SHAH','0007-04-15','Male','1','A+','MUSLIM','923331952157','923335253138','GTV, FIRST FLOOR , ECOVER TRUST BUILDING G5 ISLAMABAD','PUNJAB','Pakistan','57693737','1','17301-4063250-5','','2022-09-08 09:53:25','2022-09-08 09:53:25');
INSERT INTO students VALUES('119','1','0','760','2','0','Hassan Nisar','','Nisar Ahmad','2017-01-16','Male','1','A+','MUSLIM','923317891171','923088897822','Faraq colony street no 09 Chistian district Bahawalnagar.','Punjab','Pakistan','74678010','1','31102-7098623-7','','2022-11-03 06:26:38','2022-11-03 06:26:38');
INSERT INTO students VALUES('120','1','0','761','2','0','YASIR MUSTAFA','','ASHFAQ HUSSAIN BHATTI','2022-03-02','Male','1','A+','MUSLIM','923214001845','92214001845','39-E TARIQ GARDEN ,NEAR WAPDA TOWN LAHORE','PUNJAB','Pakistan','93714518','1','32202-1507140-9','','2022-11-06 14:50:38','2022-11-06 14:50:38');
INSERT INTO students VALUES('121','1','0','762','2','0','Hamza Sahu','','Murtaza Nadeem','0006-06-23','Male','1','A+','MUSLIM','923440114254','923017592800','Chak no 15/9r kacha kuh khaniwal Multan','Punjab','Pakistan','40758331','1','36103-3621800-3','','2022-11-16 16:49:35','2022-11-16 16:49:35');
INSERT INTO students VALUES('122','1','0','763','2','0','Danyal Irshad','','Ch M Irshad','0009-08-21','Male','1','A+','MUSLIM','923138691484','923008691484','H#84 Sreet#5 Ghafor town chichawatni','Punjab','Pakistan','21699463','1','36501-8984048-7','','2022-11-16 17:02:12','2022-11-16 17:02:12');
INSERT INTO students VALUES('123','1','0','764','2','0','Waqar Ahmad','','Shabir Ahmad','2012-07-05','Male','0','A+','MUSLIM','923332515474','923332515474','A2391 phase 2 ,gulstan Hadeel phase 1 Bin karachi','Sindh','Pakistan','59578682','1','43213-9905087-5','','2022-11-16 17:24:21','2023-04-02 08:35:24');
INSERT INTO students VALUES('124','1','0','765','2','0','Abdul Moiz','','M Asghar khan','1999-02-27','Male','1','A+','MUSLIM','923349115535','923369250521','Gulberg Peshawar','KPK','Pakistan','27795405','','17301-1615018-3','','2022-12-10 08:23:39','2023-08-09 06:55:42');
INSERT INTO students VALUES('125','1','0','766','2','0','Shayan Nasir','','Jalal Nasir','1999-07-02','Male','0','A+','MUSLIM','923479001960','923367775363','Hayatabad Peshawar','KPK','Pakistan','76285198','1','17301-4461675-3','','2022-12-10 08:28:00','2023-04-02 08:33:42');
INSERT INTO students VALUES('126','1','0','767','2','0','NAEEM AHMAD SHEIKH','','SHAFAAT NOOR','0000-00-00','Male','1','A+','MUSLIM','923332621996','923153774034','House no B15 General Public Society Kohsar Hyderabad Sindh.','Sindh','Pakistan','73783847','1','41303-2859283-5','','2022-12-22 05:40:56','2022-12-22 05:40:56');
INSERT INTO students VALUES('127','1','0','768','2','0','TAZA GUL','','JANAT GUL','1996-10-14','Male','1','A+','MUSLIM','923329394438','92323-9555928','HOUSE NO 07, POLICE HQ PESHAWAR CANT.','KPK','Pakistan','71637678','1','17301-3668150-7','','2023-01-06 10:43:31','2023-01-06 10:43:31');
INSERT INTO students VALUES('128','1','0','769','2','0','MUHAMMAD ZOHAIB KHAN','','WISAL MUHAMMAD','1999-03-15','Male','1','A+','MUSLIM','923241994597','923458194956','KHALIL COLONY NEAR C.P MARDAN','KPK','Pakistan','30885734','1','16202-3075910-7','','2023-02-09 10:40:44','2023-08-09 06:57:08');
INSERT INTO students VALUES('129','1','0','770','2','0','MUHAMMAD TANVER','','MUHAMMAD ZAMAN','2017-01-14','Male','1','A+','','923015780559','923013751606','mohallah awanabad,mianwali road talagang','punjab','Pakistan','70837907','','37303-2842106-7','','2023-03-07 12:52:23','2023-03-07 12:52:23');
INSERT INTO students VALUES('130','1','0','771','2','0','SALMAN KHAN','','JALEELUREHMAN','1994-01-10','Male','0','A+','MUSLIM','923339300881','923005966934','HAYATABAD PESHAWAR','KPK','Pakistan','4870141','1','17301-4107906-9','','2023-03-07 13:01:25','2023-04-02 08:31:23');
INSERT INTO students VALUES('131','1','0','772','2','0','Umair Ijaz','','Ijaz Ahmad Zahid','2000-08-10','Male','1','A+','MUSLIM','923410067988','923007480415','House #  2/37, Muhallah Shah Lateef, Bhera Tehsil Bhalwal , District Sargodha.','Punjab','Pakistan','96078089','1','38401-3392108-3','','2023-04-07 15:16:55','2023-04-07 15:16:55');
INSERT INTO students VALUES('132','1','0','773','2','0','Usama Qayoum Kakar','','Abdul Qayoum Kakar','1997-04-02','Male','0','AB+','MUSLIM','923461234591','923318249324','Dera Ismail Khan','KPK','Pakistan','22023321','1','12101-2212492-7','','2023-04-09 11:15:56','2023-06-01 16:17:26');
INSERT INTO students VALUES('133','1','0','774','2','0','MUHAMMAD SOBAN BEHZAD','','MUHAMMAD SOHAIL SHEHZAD','1997-09-08','Male','1','A+','MUSLIM','923131600693','923017442542','STREET # 2, HOUSE# EX 392/50  MULTAN','PUNJAB','Pakistan','61077864','1','36302-0392777-9','','2023-04-09 21:30:16','2023-04-09 21:30:16');
INSERT INTO students VALUES('134','1','0','775','2','0','Adnan Aslam','','Muhammad Aslam','2000-10-18','Male','0','A+','MUSLIM','923029363101','923011521101','Chak# 101/10R, Dhori, Tehsil Jahanian District Khanewal','Punjab','Pakistan','7038286','1','36101-2277161-9','','2023-05-11 09:07:23','2023-08-03 09:48:09');
INSERT INTO students VALUES('135','1','0','776','2','0','HASEEB HUSSAIN','','MUBASHIR HUSSAIN','2007-03-08','Male','1','A+','MUSLIM','929115164268','923168527976','POST OFFICE THOHA BAHADUR DISTRICT CHAKWAL','PUNJAB','Pakistan','83550831','2','37201-4959992-7','','2023-05-23 10:53:47','2023-05-23 10:53:47');
INSERT INTO students VALUES('136','1','0','777','2','0','RASHID BASHIR','','BASHIR AHMAD','1998-07-20','Male','1','A+','MUSLIM','923125424485','923451553783','QILA DEWAN SINGH, P/O BOX NOKAR, TEHSIL NOWSHERA VIRKU DIST GUJARANWALA','PUNJAB','Pakistan','90005674','1','34103-6440424-7','','2023-06-01 16:09:43','2023-06-01 16:09:43');
INSERT INTO students VALUES('137','1','0','778','2','0','MUDASSAR KAMAL','','MUSTAFA KAMAL','2000-10-12','Male','1','A+','MUSLIM','923095092969','923359543230','PO CHABBAR TEHSIL AND DISTRICT CHAKWAL','PUNJAB','Pakistan','1777653','','37201-6510779-9','','2023-06-01 16:33:26','2023-06-01 16:33:26');
INSERT INTO students VALUES('138','1','0','779','2','0','AHMED ZAHOOR','','HAMID ZAHOOR','2000-01-19','Male','1','A+','MUSLIM','923241480822','923454533960','2-D CANAL BANK EXTENSION MUGHAL PURA LAHORE','PUNJAB','Pakistan','51567738','1','35202-5995666-9','sECURITY 20000','2023-06-15 08:34:15','2023-06-15 08:34:15');
INSERT INTO students VALUES('139','1','0','780','2','0','M Mehboob','','Abdul Hameed','1995-05-19','Male','1','','MUSLIM','923048419121','03005182127','chak No 541/E B Tehsil and District Vehari','punjab','Pakistan','96490401','','36603-6550070-5','DISCOUNT REFFRENCE TO ABID SB 2000','2023-07-20 07:28:33','2023-08-03 05:58:39');
INSERT INTO students VALUES('140','1','0','781','2','0','GHULAM ALI','','NOOR AHMED','1990-09-13','Male','1','A+','MUSLIM','923134210421','923016850915','MANDI AHMEDABAD NEAR GOVT HIGH SCHOOL OKARA','PUNJAB','Pakistan','96040232','1','35202-0963599-5','SEC25000K','2023-07-26 14:31:55','2023-07-26 14:31:55');
INSERT INTO students VALUES('141','1','0','782','2','0','MOTASIM BILLAH','','WAZIR-UL-HAQ','1999-02-01','Male','1','A+','MUSLIM','923068019962','03276493564','CHERAT,DAK ISMAIL KHELL,TEHSIL PIBBI, DISTRICT NOSHEHRA','KPK','Pakistan','50237368','1','17201-0370799-9','SEC20K','2023-07-28 15:32:45','2023-07-28 15:32:45');
INSERT INTO students VALUES('142','1','0','783','2','0','MUHAMMAD IMAD','','WISAL MUHAMMAD','1993-03-27','Male','1','N/A','MUSLIM','923458889868','92459304863','MOH: BABA ALI KHAIL CITY:SHER KALY  TEH:RAZAR,dIST: SWABI','KPK','Pakistan','55349644','1','16202-4804468-3','SEC 20K','2023-08-03 05:39:33','2023-08-05 06:08:35');
INSERT INTO students VALUES('143','1','0','784','2','0','WALEED','','ABSDEF','2004-08-03','Male','1','A+','MUSLIM','923459304863','','SWAT','KPK','Pakistan','23445633','1','33333-3333333-3','SEC20K','2023-08-03 05:41:15','2023-08-03 05:41:15');
INSERT INTO students VALUES('144','1','0','785','2','0','MOEEZ SHIRAZI','','ABCDEF','2004-08-03','Male','1','A+','MUSLIM','923111111111','','SARGODHA','PUNJAB','Pakistan','85882537','1','33333-3333333-3','','2023-08-03 05:51:35','2023-08-03 05:51:35');
INSERT INTO students VALUES('145','1','0','786','2','0','MUHAMMAD JUNAID BIN ATA','','ATAULLAH TABUSSAM','1983-12-24','Male','1','A+','MUSLIM','923002957403','','HOUSE#5 STREET#7 CHANAR GARDEN HARBANSPURA LAHORE','PUNJAB','Pakistan','63722881','1','35201-8665256-7','SEC 20K','2023-08-04 17:30:20','2023-08-04 17:30:20');
INSERT INTO students VALUES('146','1','0','788','2','0','RASHED ULLAH','','SANA ULLAH','1999-01-01','Male','1','N/A','','923322196858','','SHIKARPUR','PUNJAB','Pakistan','92561995','2','43304-3290032-7','','2023-08-05 11:18:08','2023-08-05 11:21:48');



DROP TABLE IF EXISTS subjects;

CREATE TABLE `subjects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `subject_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_type` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_id` int(11) NOT NULL,
  `full_mark` int(11) NOT NULL,
  `pass_mark` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS syllabus;

CREATE TABLE `syllabus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class_id` int(11) NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS teachers;

CREATE TABLE `teachers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `designation` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `birthday` date NOT NULL,
  `gender` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `religion` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `joining_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO teachers VALUES('1','1','281','M.SHAHBAZ','MANAGER','1996-01-25','Male','MUSLIM','923170000419','ISLAMABAD','2021-02-24','2021-08-04 18:54:40','2021-08-04 18:54:40');
INSERT INTO teachers VALUES('2','1','282','M.NASIR','COOK','2021-08-10','Male','MUSLIM','923009528624','LAHORE','2021-01-01','2021-08-04 18:56:56','2021-08-04 18:56:56');
INSERT INTO teachers VALUES('3','1','283','MATIUALLAH','COOK','1990-07-25','Male','MUSLIM','923411672629','HARIPUR','2021-01-01','2021-08-04 18:59:29','2021-08-04 18:59:29');
INSERT INTO teachers VALUES('4','1','284','MUZAMIL','QARI','1998-07-22','Male','MUSLIM','923117728227','VEHARI','2021-06-18','2021-08-04 19:02:21','2021-08-04 19:02:21');
INSERT INTO teachers VALUES('5','1','285','KHIZAR','COOK','1990-06-26','Male','MUSLIM','923497604118','HARIPUR','2021-07-01','2021-08-04 19:05:00','2021-08-04 19:05:00');
INSERT INTO teachers VALUES('6','1','286','IFTIKHAR','SWEEPER','1990-02-20','Male','NON MUSLIM','923035823453','ISLAMABAD','2021-01-11','2021-08-04 19:19:52','2021-08-04 19:19:52');
INSERT INTO teachers VALUES('7','1','287','SABAR','SWEEPER','1989-07-12','Male','NON MUSLIM','923412274725','RAWALPINDI','2021-06-22','2021-08-04 19:24:29','2021-08-04 19:24:29');
INSERT INTO teachers VALUES('8','1','635','Ahmed faraz','MANAGER','1998-04-25','Male','MUSLIM','03111689150','Pakpattan','2021-10-01','2021-10-04 23:28:41','2021-10-04 23:28:41');
INSERT INTO teachers VALUES('9','1','636','Muhammad maqsood','COOK','1988-02-26','Male','MUSLIM','03495826178','Dhk qasim po same, mohra noori dist Rawalpindi','2021-10-01','2021-10-04 23:33:18','2021-10-04 23:33:18');
INSERT INTO teachers VALUES('12','1','787','ELYAS KHAN','MANAGER','2000-02-20','Male','MUSLIM','923077178384','HATAN DHARA SARKO UPPER DIR','2023-06-15','2023-08-04 17:35:56','2023-08-04 17:35:56');



DROP TABLE IF EXISTS transactions;

CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `trans_date` date NOT NULL,
  `account_id` int(11) NOT NULL,
  `trans_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `receipt_no` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_id` int(11) DEFAULT NULL,
  `trans_source_type` enum('Income','Expense','Student','Teacher') COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `dr_cr` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `chart_id` int(11) NOT NULL,
  `payee_payer_id` int(11) DEFAULT NULL,
  `payment_method_id` int(11) DEFAULT NULL,
  `create_user_id` int(11) NOT NULL,
  `update_user_id` int(11) DEFAULT NULL,
  `reference` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1352 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO transactions VALUES('1','1','2021-09-19','1','income','','2','Student','20000.00','cr','2','2','4','319','','','','30,000 remaining','2021-10-05 13:29:35','2021-10-05 13:29:35');
INSERT INTO transactions VALUES('2','1','2021-09-16','1','income','','1','Student','20000.00','cr','2','1','4','319','','','','','2021-10-05 13:30:28','2021-10-05 13:30:28');
INSERT INTO transactions VALUES('3','1','2021-11-03','1','income','','11','Student','18000.00','cr','3','9','1','641','','','','','2021-12-05 13:20:16','2021-12-05 13:20:16');
INSERT INTO transactions VALUES('4','1','2021-11-03','1','income','','24','Student','17000.00','cr','3','22','1','641','','','','','2021-12-05 13:23:18','2021-12-05 13:23:18');
INSERT INTO transactions VALUES('5','1','2021-11-04','1','income','','28','Student','18000.00','cr','2','26','1','641','','','','','2021-12-05 13:25:09','2021-12-05 13:25:09');
INSERT INTO transactions VALUES('6','1','2021-11-02','1','income','','29','Student','17000.00','cr','3','27','1','641','','','','','2021-12-05 13:25:51','2021-12-05 13:25:51');
INSERT INTO transactions VALUES('7','1','2021-11-02','1','income','','25','Student','17000.00','cr','2','23','1','641','','','','','2021-12-05 13:26:31','2021-12-05 13:26:31');
INSERT INTO transactions VALUES('8','1','2021-11-01','1','income','','3','Student','17000.00','cr','2','1','1','641','','','','','2021-12-05 13:27:00','2021-12-05 13:27:00');
INSERT INTO transactions VALUES('9','1','2021-11-10','1','income','','10','Student','18500.00','cr','3','8','4','641','','','','','2021-12-05 13:30:59','2021-12-05 13:30:59');
INSERT INTO transactions VALUES('10','1','2021-11-09','1','income','','21','Student','18000.00','cr','3','19','1','641','','','','','2021-12-05 13:32:07','2021-12-05 13:32:07');
INSERT INTO transactions VALUES('11','1','2021-11-09','1','income','','5','Student','22000.00','cr','3','3','1','641','','','','','2021-12-05 13:34:14','2021-12-05 13:34:14');
INSERT INTO transactions VALUES('12','1','2021-11-15','1','income','','6','Student','11000.00','cr','3','4','1','641','','','','','2021-12-05 13:51:47','2021-12-05 13:51:47');
INSERT INTO transactions VALUES('13','1','2021-11-13','1','income','','22','Student','10000.00','cr','2','20','1','641','','','','','2021-12-05 13:54:15','2021-12-05 13:54:15');
INSERT INTO transactions VALUES('14','1','2021-11-14','1','income','','16','Student','38000.00','cr','2','14','1','641','','','','','2021-12-05 13:55:19','2021-12-05 13:55:19');
INSERT INTO transactions VALUES('15','1','2021-11-16','1','income','','19','Student','18500.00','cr','2','17','1','641','','','','','2021-12-05 14:01:48','2021-12-05 14:01:48');
INSERT INTO transactions VALUES('16','1','2021-11-16','1','income','','20','Student','18500.00','cr','3','18','1','641','','','','','2021-12-05 14:03:05','2021-12-05 14:03:05');
INSERT INTO transactions VALUES('17','1','2021-11-16','1','income','','18','Student','18500.00','cr','3','16','1','641','','','','','2021-12-05 14:03:33','2021-12-05 14:03:33');
INSERT INTO transactions VALUES('18','1','2021-11-16','1','income','','17','Student','18500.00','cr','2','15','1','641','','','','','2021-12-05 14:04:01','2021-12-05 14:04:01');
INSERT INTO transactions VALUES('19','1','2021-11-21','1','income','','4','Student','23330.00','cr','2','2','1','641','','','','','2021-12-05 14:08:33','2021-12-05 14:08:33');
INSERT INTO transactions VALUES('20','1','2021-11-21','1','income','','9','Student','24666.00','cr','2','7','1','641','','','','','2021-12-05 14:12:08','2021-12-05 14:12:08');
INSERT INTO transactions VALUES('21','1','2021-11-01','1','income','','27','Student','34000.00','cr','2','25','1','641','','','','','2021-12-05 14:24:42','2021-12-05 14:24:42');
INSERT INTO transactions VALUES('22','1','2021-11-09','1','income','','12','Student','18000.00','cr','3','10','1','641','','','','','2021-12-05 14:25:55','2021-12-05 14:25:55');
INSERT INTO transactions VALUES('23','1','2021-11-01','1','income','','14','Student','17000.00','cr','3','12','1','641','','','','','2021-12-05 14:28:09','2021-12-05 14:28:09');
INSERT INTO transactions VALUES('24','1','2021-11-11','1','income','','23','Student','27750.00','cr','2','21','1','641','','','','','2021-12-05 14:32:36','2021-12-05 14:32:36');
INSERT INTO transactions VALUES('25','1','2021-11-22','1','income','','13','Student','10000.00','cr','2','11','1','641','','','','BOOKING','2021-12-05 16:26:44','2021-12-05 16:26:44');
INSERT INTO transactions VALUES('26','1','2021-11-03','1','income','','30','Student','18000.00','cr','2','29','1','641','','','','','2021-12-05 16:50:57','2021-12-05 16:50:57');
INSERT INTO transactions VALUES('27','1','2021-10-12','1','income','','2','Student','-20000.00','cr','2','2','1','641','','','','','2021-12-05 17:11:12','2021-12-05 17:11:12');
INSERT INTO transactions VALUES('28','1','2021-11-05','1','income','','26','Student','18000.00','cr','3','24','1','641','','','','','2021-12-05 17:53:56','2021-12-05 17:53:56');
INSERT INTO transactions VALUES('29','1','2021-11-05','1','income','','15','Student','18500.00','cr','3','13','1','641','','','','','2021-12-05 18:11:18','2021-12-05 18:11:18');
INSERT INTO transactions VALUES('30','1','2021-12-04','1','income','','54','Student','17000.00','cr','3','25','1','641','','','','','2021-12-07 10:53:26','2021-12-07 10:53:26');
INSERT INTO transactions VALUES('31','1','2021-12-02','1','income','','58','Student','24998.00','cr','2','30','1','641','','','','','2021-12-07 10:57:47','2021-12-07 10:57:47');
INSERT INTO transactions VALUES('32','1','2021-12-02','1','income','','58','Student','2.00','cr','2','30','1','641','','','','','2021-12-07 10:59:20','2021-12-07 10:59:20');
INSERT INTO transactions VALUES('33','1','2021-12-03','1','income','','60','Student','17000.00','cr','2','32','1','641','','','','','2021-12-07 11:03:41','2021-12-07 11:03:41');
INSERT INTO transactions VALUES('34','1','2021-12-03','1','income','','59','Student','17000.00','cr','2','31','1','641','','','','','2021-12-07 11:05:09','2021-12-07 11:05:09');
INSERT INTO transactions VALUES('35','1','2021-12-04','1','income','','36','Student','18500.00','cr','2','7','1','641','','','','','2021-12-07 11:06:15','2021-12-07 11:06:15');
INSERT INTO transactions VALUES('36','1','2021-12-04','1','income','','46','Student','15000.00','cr','2','17','1','641','','','','','2021-12-07 11:06:39','2021-12-07 11:06:39');
INSERT INTO transactions VALUES('37','1','2021-12-01','1','income','','42','Student','18500.00','cr','2','13','1','641','','','','','2021-12-07 11:07:33','2021-12-07 11:07:33');
INSERT INTO transactions VALUES('38','1','2021-12-06','1','income','','55','Student','17000.00','cr','2','26','1','641','','','','','2021-12-07 11:14:10','2021-12-07 11:14:10');
INSERT INTO transactions VALUES('39','1','2021-12-06','1','income','','32','Student','17500.00','cr','2','2','1','641','','','','','2021-12-07 11:16:34','2021-12-07 11:16:34');
INSERT INTO transactions VALUES('40','1','2021-12-06','1','income','','53','Student','17000.00','cr','2','24','1','641','','','','','2021-12-07 11:18:26','2021-12-07 11:18:26');
INSERT INTO transactions VALUES('41','1','2021-12-06','1','income','','51','Student','17000.00','cr','2','22','1','641','','','','','2021-12-07 11:20:52','2021-12-07 11:20:52');
INSERT INTO transactions VALUES('42','1','2021-12-06','1','income','','52','Student','17000.00','cr','2','23','1','641','','','','','2021-12-07 11:21:20','2021-12-07 11:21:20');
INSERT INTO transactions VALUES('43','1','2021-12-06','2','income','','40','Student','17000.00','cr','2','11','1','641','','','','','2021-12-07 11:22:16','2021-12-07 11:22:16');
INSERT INTO transactions VALUES('44','1','2021-12-06','1','income','','61','Student','26000.00','cr','2','28','1','641','','','','','2021-12-07 11:45:50','2021-12-07 11:45:50');
INSERT INTO transactions VALUES('45','1','2021-12-06','2','income','','62','Student','17500.00','cr','2','33','1','641','','','','','2021-12-07 12:16:11','2021-12-07 12:16:11');
INSERT INTO transactions VALUES('46','1','2021-12-07','1','income','','59','Student','-17000.00','cr','2','31','1','641','','','','','2021-12-07 20:20:28','2021-12-07 20:20:28');
INSERT INTO transactions VALUES('47','1','2021-12-07','1','income','','60','Student','-17000.00','cr','2','32','1','641','','','','','2021-12-07 20:21:43','2021-12-07 20:21:43');
INSERT INTO transactions VALUES('48','1','2021-12-07','1','income','','59','Student','17000.00','cr','2','31','1','641','','','','','2021-12-07 20:25:20','2021-12-07 20:25:20');
INSERT INTO transactions VALUES('49','1','2021-12-07','1','income','','60','Student','17000.00','cr','2','32','1','641','','','','','2021-12-07 20:25:43','2021-12-07 20:25:43');
INSERT INTO transactions VALUES('50','1','2021-12-07','1','income','','59','Student','8000.00','cr','2','31','1','641','','','','','2021-12-07 21:02:13','2021-12-07 21:02:13');
INSERT INTO transactions VALUES('51','1','2021-12-07','1','income','','60','Student','8000.00','cr','2','32','1','641','','','','','2021-12-07 21:02:39','2021-12-07 21:02:39');
INSERT INTO transactions VALUES('52','1','2021-12-07','1','income','','63','Student','20000.00','cr','2','34','1','641','','','','ZEESHAN','2021-12-07 21:04:02','2021-12-07 21:04:02');
INSERT INTO transactions VALUES('53','1','2021-12-07','1','income','','63','Student','10000.00','cr','2','34','1','641','','','','','2021-12-07 21:04:21','2021-12-07 21:04:21');
INSERT INTO transactions VALUES('54','1','2021-12-06','1','income','','57','Student','19000.00','cr','3','29','1','641','','','','','2021-12-07 21:26:38','2021-12-07 21:26:38');
INSERT INTO transactions VALUES('55','1','2021-12-08','2','income','','49','Student','18500.00','cr','2','20','1','641','','','','','2021-12-08 17:43:13','2021-12-08 17:43:13');
INSERT INTO transactions VALUES('56','1','2021-12-08','2','income','','37','Student','18500.00','cr','3','8','1','641','','','','BANK ISLAMI','2021-12-08 18:39:33','2021-12-08 18:39:33');
INSERT INTO transactions VALUES('57','1','2021-12-06','1','income','','34','Student','17500.00','cr','3','4','1','641','','','','','2021-12-08 18:40:58','2021-12-08 18:40:58');
INSERT INTO transactions VALUES('58','1','2021-12-07','1','income','','53','Student','17000.00','cr','3','24','1','641','','','','','2021-12-08 18:42:05','2021-12-08 18:42:05');
INSERT INTO transactions VALUES('59','1','2021-12-07','1','income','','55','Student','17000.00','cr','3','26','1','641','','','','','2021-12-08 18:42:51','2021-12-08 18:42:51');
INSERT INTO transactions VALUES('60','1','2021-12-06','1','income','','51','Student','17000.00','cr','2','22','1','641','','','','','2021-12-08 18:44:14','2021-12-08 18:44:14');
INSERT INTO transactions VALUES('61','1','2021-12-05','1','income','','52','Student','17000.00','cr','3','23','1','641','','','','','2021-12-08 18:44:56','2021-12-08 18:44:56');
INSERT INTO transactions VALUES('62','1','2021-12-07','1','income','','38','Student','18000.00','cr','2','9','1','641','','','','','2021-12-08 18:47:51','2021-12-08 18:47:51');
INSERT INTO transactions VALUES('63','1','2021-12-08','2','income','','50','Student','18500.00','cr','2','21','1','641','','','','BANK ISLAMI','2021-12-08 19:06:57','2021-12-08 19:06:57');
INSERT INTO transactions VALUES('64','1','2021-12-08','2','income','','48','Student','18000.00','cr','3','19','1','641','','','','BANK ISLAMI','2021-12-08 19:11:50','2021-12-08 19:11:50');
INSERT INTO transactions VALUES('65','1','2021-12-09','2','income','','44','Student','15000.00','cr','2','15','1','641','','','','BANK ISLAMI','2021-12-09 11:20:49','2021-12-09 11:20:49');
INSERT INTO transactions VALUES('66','1','2021-12-13','1','income','','68','Student','15000.00','cr','2','39','1','641','','','','','2021-12-17 20:50:44','2021-12-17 20:50:44');
INSERT INTO transactions VALUES('67','1','2021-12-10','1','income','','69','Student','17000.00','cr','2','40','1','641','','','','JAVAID SB','2021-12-17 21:48:49','2021-12-17 21:48:49');
INSERT INTO transactions VALUES('68','1','2021-12-10','1','income','','67','Student','27000.00','cr','2','38','1','641','','','','','2021-12-17 21:50:41','2021-12-17 21:50:41');
INSERT INTO transactions VALUES('69','1','2021-12-10','1','income','','31','Student','17000.00','cr','2','1','1','641','','','','','2021-12-17 21:52:27','2021-12-17 21:52:27');
INSERT INTO transactions VALUES('70','1','2021-12-10','1','income','','33','Student','22000.00','cr','2','3','1','641','','','','','2021-12-17 21:53:25','2021-12-17 21:53:25');
INSERT INTO transactions VALUES('71','1','2021-12-10','1','income','','39','Student','18000.00','cr','2','10','1','641','','','','','2021-12-17 21:53:51','2021-12-17 21:53:51');
INSERT INTO transactions VALUES('72','1','2021-12-09','1','income','','43','Student','19000.00','cr','2','14','1','641','','','','','2021-12-17 21:54:31','2021-12-17 21:54:31');
INSERT INTO transactions VALUES('73','1','2021-12-10','1','income','','57','Student','10000.00','cr','2','29','1','641','','','','','2021-12-17 21:55:11','2021-12-17 21:55:11');
INSERT INTO transactions VALUES('74','1','2021-12-10','1','income','','45','Student','15000.00','cr','2','16','1','641','','','','','2021-12-17 21:55:41','2021-12-17 21:55:41');
INSERT INTO transactions VALUES('75','1','2021-12-10','1','income','','47','Student','15000.00','cr','2','18','1','641','','','','','2021-12-17 21:56:06','2021-12-17 21:56:06');
INSERT INTO transactions VALUES('76','1','2021-12-10','1','income','','64','Student','15000.00','cr','3','35','1','641','','','','','2021-12-17 22:01:44','2021-12-17 22:01:44');
INSERT INTO transactions VALUES('77','1','2021-12-10','1','income','','56','Student','17000.00','cr','2','27','1','641','','','','','2021-12-17 22:15:56','2021-12-17 22:15:56');
INSERT INTO transactions VALUES('78','1','2021-12-10','1','income','','66','Student','29500.00','cr','2','37','1','641','','','','','2021-12-17 22:21:53','2021-12-17 22:21:53');
INSERT INTO transactions VALUES('79','1','2021-12-10','1','income','','65','Student','29500.00','cr','2','36','1','641','','','','','2021-12-17 22:22:09','2021-12-17 22:22:09');
INSERT INTO transactions VALUES('80','1','2021-12-22','1','income','','35','Student','50000.00','cr','3','6','1','641','','','','','2021-12-23 13:58:21','2021-12-23 13:58:21');
INSERT INTO transactions VALUES('81','1','2021-12-22','1','income','06','','Student','50000.00','cr','2','6','1','641','','','','','2021-12-23 14:03:23','2021-12-23 14:03:23');
INSERT INTO transactions VALUES('82','1','2022-01-01','2','income','','107','Student','34000.00','cr','2','1','1','641','641','','','','2022-01-02 16:58:23','2022-01-19 21:40:04');
INSERT INTO transactions VALUES('83','1','2021-12-12','2','income','','151','Student','24500.00','cr','2','45','1','641','','','','','2022-01-02 21:34:55','2022-01-02 21:34:55');
INSERT INTO transactions VALUES('84','1','2021-12-30','1','income','','149','Student','28000.00','cr','3','43','1','641','','','','M/O JAN 2022','2022-01-03 12:44:33','2022-01-03 12:44:33');
INSERT INTO transactions VALUES('85','1','2021-12-30','1','income','','146','Student','20000.00','cr','3','40','1','641','','','','M/O JAN 2022','2022-01-03 12:48:03','2022-01-03 12:48:03');
INSERT INTO transactions VALUES('86','1','2022-01-01','2','income','','115','Student','18500.00','cr','3','7','1','641','','','','M/O JAN2022','2022-01-03 12:52:50','2022-01-03 12:52:50');
INSERT INTO transactions VALUES('87','1','2022-01-02','1','income','','120','Student','18500.00','cr','3','13','1','641','','','','','2022-01-03 12:54:55','2022-01-03 12:54:55');
INSERT INTO transactions VALUES('88','1','2022-01-02','1','income','','150','Student','22500.00','cr','3','44','1','641','','','','SEC 5000','2022-01-03 12:57:39','2022-01-03 12:57:39');
INSERT INTO transactions VALUES('89','1','2022-01-02','2','income','','128','Student','18500.00','cr','3','21','1','641','','','','','2022-01-03 12:59:13','2022-01-03 12:59:13');
INSERT INTO transactions VALUES('90','1','2022-01-01','1','income','','153','Student','17500.00','cr','3','42','1','641','','','','','2022-01-03 13:13:50','2022-01-03 13:13:50');
INSERT INTO transactions VALUES('91','1','2022-01-04','2','income','','133','Student','17000.00','cr','3','26','1','641','','','','M/O DECEMBER 2021','2022-01-05 18:58:53','2022-01-05 18:58:53');
INSERT INTO transactions VALUES('92','1','2022-01-04','2','income','','130','Student','17000.00','cr','2','23','1','641','','','','M/O DECEMBER 2021','2022-01-05 19:00:48','2022-01-05 19:00:48');
INSERT INTO transactions VALUES('93','1','2022-01-04','2','income','','131','Student','17000.00','cr','3','24','1','641','','','','M/O DECEMBER 2021','2022-01-05 19:01:23','2022-01-05 19:01:23');
INSERT INTO transactions VALUES('94','1','2022-01-05','1','income','','144','Student','17000.00','cr','3','38','1','641','','','','','2022-01-06 11:14:15','2022-01-06 11:14:15');
INSERT INTO transactions VALUES('95','1','2022-01-05','1','income','','136','Student','17000.00','cr','3','30','4','641','','','','','2022-01-06 11:19:30','2022-01-06 11:19:30');
INSERT INTO transactions VALUES('96','1','2022-01-05','2','income','','152','Student','18500.00','cr','3','45','1','641','','','','','2022-01-06 11:21:12','2022-01-06 11:21:12');
INSERT INTO transactions VALUES('97','1','2022-01-05','2','income','','111','Student','17500.00','cr','3','2','1','641','','','','','2022-01-06 11:23:14','2022-01-06 11:23:14');
INSERT INTO transactions VALUES('98','1','2022-01-05','1','income','','125','Student','15000.00','cr','3','18','4','641','','','','','2022-01-06 11:29:05','2022-01-06 11:29:05');
INSERT INTO transactions VALUES('99','1','2022-01-05','1','income','','122','Student','15000.00','cr','3','15','4','641','','','','','2022-01-06 11:29:59','2022-01-06 11:29:59');
INSERT INTO transactions VALUES('100','1','2022-01-05','1','income','','132','Student','17000.00','cr','3','25','4','641','','','','','2022-01-06 11:32:12','2022-01-06 11:32:12');
INSERT INTO transactions VALUES('101','1','2022-01-05','2','income','','134','Student','17000.00','cr','2','27','1','641','','','','','2022-01-06 12:00:43','2022-01-06 12:00:43');
INSERT INTO transactions VALUES('102','1','2022-01-06','2','income','','141','Student','15000.00','cr','3','35','1','641','','','','','2022-01-06 12:52:21','2022-01-06 12:52:21');
INSERT INTO transactions VALUES('103','1','2022-01-05','1','income','','113','Student','17500.00','cr','3','4','4','641','','','','','2022-01-06 12:56:02','2022-01-06 12:56:02');
INSERT INTO transactions VALUES('104','1','2022-01-05','1','income','','135','Student','19000.00','cr','3','29','4','641','','','','','2022-01-06 12:58:45','2022-01-06 12:58:45');
INSERT INTO transactions VALUES('105','1','2022-01-06','1','income','','124','Student','15000.00','cr','3','17','4','641','','','','','2022-01-06 13:13:00','2022-01-06 13:13:00');
INSERT INTO transactions VALUES('106','1','2022-01-06','1','income','','112','Student','22000.00','cr','2','3','4','641','','','','','2022-01-06 17:35:23','2022-01-06 17:35:23');
INSERT INTO transactions VALUES('107','1','2022-01-06','2','income','','123','Student','15000.00','cr','3','16','1','641','','','','','2022-01-06 17:38:26','2022-01-06 17:38:26');
INSERT INTO transactions VALUES('108','1','2022-01-05','1','income','','127','Student','18500.00','cr','3','20','1','641','','','','','2022-01-06 17:44:06','2022-01-06 17:44:06');
INSERT INTO transactions VALUES('109','1','2022-01-06','2','income','','139','Student','17500.00','cr','3','33','1','641','','','','','2022-01-07 11:34:05','2022-01-07 11:34:05');
INSERT INTO transactions VALUES('110','1','2022-01-06','1','income','','117','Student','18000.00','cr','3','9','4','641','','','','','2022-01-07 11:34:52','2022-01-07 11:34:52');
INSERT INTO transactions VALUES('111','1','2022-01-06','1','income','','116','Student','18500.00','cr','3','8','4','641','','','','','2022-01-07 11:35:38','2022-01-07 11:35:38');
INSERT INTO transactions VALUES('112','1','2022-01-07','2','income','','126','Student','18000.00','cr','3','19','1','641','','','','','2022-01-07 13:45:17','2022-01-07 13:45:17');
INSERT INTO transactions VALUES('113','1','2022-01-07','2','income','','119','Student','17000.00','cr','3','11','1','641','','','','','2022-01-07 18:02:16','2022-01-07 18:02:16');
INSERT INTO transactions VALUES('114','1','2022-01-08','1','income','','143','Student','22000.00','cr','3','37','4','641','','','','','2022-01-08 12:55:41','2022-01-08 12:55:41');
INSERT INTO transactions VALUES('115','1','2022-01-05','2','income','','129','Student','17000.00','cr','3','22','1','641','','','','','2022-01-08 17:50:05','2022-01-08 17:50:05');
INSERT INTO transactions VALUES('116','1','2022-01-08','1','income','','142','Student','22000.00','cr','3','36','4','641','','','','','2022-01-08 17:51:04','2022-01-08 17:51:04');
INSERT INTO transactions VALUES('117','1','2022-01-10','1','income','','137','Student','17000.00','cr','3','31','4','641','','','','','2022-01-10 11:16:20','2022-01-10 11:16:20');
INSERT INTO transactions VALUES('118','1','2022-01-10','1','income','','138','Student','17000.00','cr','3','32','4','641','','','','','2022-01-10 11:17:00','2022-01-10 11:17:00');
INSERT INTO transactions VALUES('119','1','2022-01-10','1','income','','118','Student','18000.00','cr','3','10','4','641','','','','','2022-01-10 11:17:48','2022-01-10 11:17:48');
INSERT INTO transactions VALUES('120','1','2022-01-10','1','income','','154','Student','29000.00','cr','3','47','4','641','','','','20 DAYS PAID','2022-01-10 11:32:53','2022-01-10 11:32:53');
INSERT INTO transactions VALUES('121','1','2022-01-11','1','income','','155','Student','20000.00','cr','3','48','1','641','','','','','2022-01-12 16:26:26','2022-01-12 16:26:26');
INSERT INTO transactions VALUES('122','1','2022-01-15','1','income','','121','Student','19000.00','cr','3','14','4','641','','','','','2022-01-15 15:35:59','2022-01-15 15:35:59');
INSERT INTO transactions VALUES('123','1','2022-01-23','1','income','','156','Student','20000.00','cr','3','49','4','641','','','','','2022-01-23 19:16:32','2022-01-23 19:16:32');
INSERT INTO transactions VALUES('124','1','2022-01-23','1','income','','157','Student','19800.00','cr','2','50','4','641','','','','','2022-01-27 20:30:26','2022-01-27 20:30:26');
INSERT INTO transactions VALUES('125','1','2022-01-23','1','income','','158','Student','19800.00','cr','2','51','4','641','','','','','2022-01-28 20:56:42','2022-01-28 20:56:42');
INSERT INTO transactions VALUES('126','1','2022-01-23','1','income','','159','Student','14500.00','cr','3','52','4','641','','','','','2022-01-31 20:29:47','2022-01-31 20:29:47');
INSERT INTO transactions VALUES('127','1','2022-02-01','1','income','','198','Student','32500.00','cr','3','53','4','641','','','','','2022-02-02 17:50:24','2022-02-02 17:50:24');
INSERT INTO transactions VALUES('128','1','2022-02-02','1','income','','196','Student','18000.00','cr','2','50','4','641','','','','','2022-02-02 17:51:03','2022-02-02 17:51:03');
INSERT INTO transactions VALUES('129','1','2022-02-01','2','income','','174','Student','18500.00','cr','2','21','1','641','','','','','2022-02-02 18:10:10','2022-02-02 18:10:10');
INSERT INTO transactions VALUES('130','1','2022-02-02','2','income','','176','Student','17000.00','cr','2','23','1','641','','','','','2022-02-03 16:00:35','2022-02-03 16:00:35');
INSERT INTO transactions VALUES('131','1','2022-02-02','2','income','','175','Student','17000.00','cr','2','22','1','641','','','','','2022-02-03 16:28:00','2022-02-03 16:28:00');
INSERT INTO transactions VALUES('132','1','2022-02-03','2','income','','162','Student','17500.00','cr','2','4','1','641','','','','','2022-02-03 17:22:48','2022-02-03 17:22:48');
INSERT INTO transactions VALUES('133','1','2022-02-04','1','income','','165','Student','18500.00','cr','2','8','4','641','','','','','2022-02-04 13:00:09','2022-02-04 13:00:09');
INSERT INTO transactions VALUES('134','1','2022-02-04','1','income','','173','Student','15000.00','cr','2','18','4','641','','','','','2022-02-04 13:00:40','2022-02-04 13:00:40');
INSERT INTO transactions VALUES('135','1','2022-02-04','1','income','','170','Student','15000.00','cr','2','15','4','641','','','','','2022-02-04 13:01:25','2022-02-04 13:01:25');
INSERT INTO transactions VALUES('136','1','2022-02-04','1','income','','178','Student','17000.00','cr','2','25','4','641','','','','','2022-02-04 13:02:05','2022-02-04 13:02:05');
INSERT INTO transactions VALUES('137','1','2022-02-04','1','income','','168','Student','18500.00','cr','2','13','4','641','','','','','2022-02-04 13:02:31','2022-02-04 13:02:31');
INSERT INTO transactions VALUES('138','1','2022-02-04','1','income','','181','Student','17000.00','cr','2','29','4','641','','','','','2022-02-04 13:04:02','2022-02-04 13:04:02');
INSERT INTO transactions VALUES('139','1','2022-02-04','2','income','','179','Student','17000.00','cr','2','26','1','641','','','','','2022-02-05 17:47:39','2022-02-05 17:47:39');
INSERT INTO transactions VALUES('140','1','2022-02-05','2','income','','185','Student','15000.00','cr','2','35','1','641','','','','','2022-02-05 17:55:37','2022-02-05 17:55:37');
INSERT INTO transactions VALUES('141','1','2022-02-05','2','income','','164','Student','18500.00','cr','2','7','1','641','','','','','2022-02-05 17:56:08','2022-02-05 17:56:08');
INSERT INTO transactions VALUES('142','1','2022-02-03','1','income','','59','Student','9000.00','cr','2','31','4','641','','','','','2022-02-05 18:02:16','2022-02-05 18:02:16');
INSERT INTO transactions VALUES('143','1','2022-02-03','1','income','','183','Student','16000.00','cr','2','31','4','641','','','','','2022-02-05 18:02:54','2022-02-05 18:02:54');
INSERT INTO transactions VALUES('144','1','2022-01-25','2','income','','199','Student','17500.00','cr','2','54','1','641','','','','','2022-02-05 18:03:26','2022-02-05 18:03:26');
INSERT INTO transactions VALUES('145','1','2022-02-05','1','income','','199','Student','17500.00','cr','2','54','4','641','','','','','2022-02-06 10:14:13','2022-02-06 10:14:13');
INSERT INTO transactions VALUES('146','1','2022-02-04','1','income','','189','Student','19000.00','cr','2','46','4','641','','','','','2022-02-06 10:15:38','2022-02-06 10:15:38');
INSERT INTO transactions VALUES('147','1','2022-02-03','1','income','','172','Student','15000.00','cr','2','17','4','641','','','','','2022-02-06 10:16:42','2022-02-06 10:16:42');
INSERT INTO transactions VALUES('148','1','2021-12-17','1','income','','57','Student','9000.00','cr','2','29','1','641','','','','','2022-02-06 20:19:48','2022-02-06 20:19:48');
INSERT INTO transactions VALUES('149','1','2022-02-03','2','income','','180','Student','10000.00','cr','2','27','1','641','','','','','2022-02-17 16:12:22','2022-02-17 16:12:22');
INSERT INTO transactions VALUES('150','1','2022-02-14','1','income','','180','Student','7000.00','cr','2','27','4','641','','','','','2022-02-17 16:13:31','2022-02-17 16:13:31');
INSERT INTO transactions VALUES('151','1','2022-02-10','1','income','','200','Student','19000.00','cr','2','14','4','641','','','','','2022-02-17 16:25:40','2022-02-17 16:25:40');
INSERT INTO transactions VALUES('152','1','2022-02-10','1','income','','192','Student','17500.00','cr','2','44','4','641','','','','','2022-02-17 16:26:03','2022-02-17 16:26:03');
INSERT INTO transactions VALUES('153','1','2022-02-07','1','income','','188','Student','17000.00','cr','2','38','4','641','','','','','2022-02-17 16:30:03','2022-02-17 16:30:03');
INSERT INTO transactions VALUES('154','1','2022-02-05','1','income','','190','Student','19000.00','cr','2','42','4','641','','','','','2022-02-17 17:50:57','2022-02-17 17:50:57');
INSERT INTO transactions VALUES('155','1','2022-02-08','2','income','','171','Student','15000.00','cr','2','16','1','641','','','','','2022-02-17 17:52:09','2022-02-17 17:52:09');
INSERT INTO transactions VALUES('156','1','2022-02-08','1','income','','195','Student','17000.00','cr','2','49','4','641','','','','','2022-02-17 17:53:37','2022-02-17 17:53:37');
INSERT INTO transactions VALUES('157','1','2022-02-09','2','income','','177','Student','17000.00','cr','2','24','1','641','','','','','2022-02-17 17:54:14','2022-02-17 17:54:14');
INSERT INTO transactions VALUES('158','1','2022-02-09','1','income','','166','Student','18000.00','cr','2','9','4','641','','','','','2022-02-17 17:56:07','2022-02-17 17:56:07');
INSERT INTO transactions VALUES('159','1','2022-02-08','1','income','','191','Student','17500.00','cr','2','43','4','641','','','','','2022-02-17 17:57:18','2022-02-17 17:57:18');
INSERT INTO transactions VALUES('160','1','2022-02-08','1','income','','186','Student','22000.00','cr','2','36','4','641','','','','','2022-02-17 17:57:45','2022-02-17 17:57:45');
INSERT INTO transactions VALUES('161','1','2022-02-08','1','income','','187','Student','22000.00','cr','2','37','4','641','','','','','2022-02-20 11:00:49','2022-02-20 11:00:49');
INSERT INTO transactions VALUES('162','1','2022-02-03','1','income','','184','Student','17000.00','cr','2','32','4','641','','','','','2022-02-20 11:10:29','2022-02-20 11:10:29');
INSERT INTO transactions VALUES('163','1','2022-02-03','1','income','','60','Student','8000.00','cr','2','32','4','641','','','','','2022-02-20 11:14:14','2022-02-20 11:14:14');
INSERT INTO transactions VALUES('164','1','2022-02-10','1','income','','169','Student','19000.00','cr','2','14','4','641','','','','','2022-02-20 11:19:41','2022-02-20 11:19:41');
INSERT INTO transactions VALUES('165','1','2022-02-09','1','income','','167','Student','20000.00','cr','2','10','4','641','','','','','2022-02-20 11:31:43','2022-02-20 11:31:43');
INSERT INTO transactions VALUES('166','1','2022-02-04','1','income','','193','Student','21000.00','cr','2','40','4','641','','','','','2022-02-20 12:26:07','2022-02-20 12:26:07');
INSERT INTO transactions VALUES('167','1','2022-02-05','1','income','','182','Student','25000.00','cr','2','30','4','641','','','','','2022-02-20 12:30:55','2022-02-20 12:30:55');
INSERT INTO transactions VALUES('168','1','2022-02-11','2','income','','161','Student','22500.00','cr','2','3','1','641','','','','','2022-02-20 12:41:03','2022-02-20 12:41:03');
INSERT INTO transactions VALUES('169','1','2022-02-09','1','income','','201','Student','22000.00','cr','2','55','4','641','','','','','2022-02-20 13:19:20','2022-02-20 13:19:20');
INSERT INTO transactions VALUES('170','1','2022-02-14','1','income','','202','Student','29170.00','cr','2','56','4','641','','','','','2022-02-20 13:44:23','2022-02-20 13:44:23');
INSERT INTO transactions VALUES('171','1','2022-02-11','2','income','','203','Student','28500.00','cr','2','57','1','641','','','','','2022-02-20 19:38:45','2022-02-20 19:38:45');
INSERT INTO transactions VALUES('172','1','2022-01-11','1','income','','204','Student','17500.00','cr','2','58','4','641','','','','','2022-02-20 19:53:45','2022-02-20 19:53:45');
INSERT INTO transactions VALUES('173','1','2022-02-11','1','income','','204','Student','11700.00','cr','2','58','4','641','','','','PAY 20 DAYS','2022-02-20 19:56:48','2022-02-20 19:56:48');
INSERT INTO transactions VALUES('174','1','2022-02-05','1','income','','204','Student','0.00','cr','2','58','1','641','','','','','2022-02-20 20:20:43','2022-02-20 20:20:43');
INSERT INTO transactions VALUES('175','1','2022-02-05','1','income','','205','Student','18000.00','cr','2','51','4','641','','','','','2022-02-20 20:33:21','2022-02-20 20:33:21');
INSERT INTO transactions VALUES('176','1','2022-02-22','1','income','','206','Student','5500.00','cr','2','59','4','641','','','','','2022-02-22 14:03:54','2022-02-22 14:03:54');
INSERT INTO transactions VALUES('177','1','2022-02-23','1','income','','167','Student','-2000.00','cr','2','10','1','641','','','','','2022-02-23 18:18:46','2022-02-23 18:18:46');
INSERT INTO transactions VALUES('178','1','2022-02-22','1','income','','207','Student','5500.00','cr','2','60','4','641','','','','','2022-02-23 18:19:01','2022-02-23 18:19:01');
INSERT INTO transactions VALUES('179','1','2022-02-20','1','income','','208','Student','8000.00','cr','2','32','4','641','','','','','2022-02-26 16:46:00','2022-02-26 16:46:00');
INSERT INTO transactions VALUES('180','1','2022-02-03','1','income','','183','Student','1000.00','cr','2','31','4','641','','','','','2022-02-26 16:59:22','2022-02-26 16:59:22');
INSERT INTO transactions VALUES('181','1','2022-03-01','2','income','','221','Student','18500.00','cr','2','21','1','641','','','','','2022-03-03 12:01:22','2022-03-03 12:01:22');
INSERT INTO transactions VALUES('182','1','2022-03-02','1','income','','237','Student','19000.00','cr','2','42','4','641','','','','','2022-03-03 12:01:58','2022-03-03 12:01:58');
INSERT INTO transactions VALUES('183','1','2022-03-02','1','income','','240','Student','19000.00','cr','2','46','4','641','','','','','2022-03-03 12:04:33','2022-03-03 12:04:33');
INSERT INTO transactions VALUES('184','1','2022-03-01','1','income','','250','Student','27500.00','cr','2','61','4','641','','','','','2022-03-03 12:17:37','2022-03-03 12:17:37');
INSERT INTO transactions VALUES('185','1','2022-03-03','1','income','','229','Student','17000.00','cr','2','30','4','641','','','','','2022-03-03 20:15:49','2022-03-03 20:15:49');
INSERT INTO transactions VALUES('186','1','2022-03-03','1','income','','210','Student','17500.00','cr','2','4','4','641','','','','','2022-03-03 20:16:25','2022-03-03 20:16:25');
INSERT INTO transactions VALUES('187','1','2022-03-03','1','income','','215','Student','18500.00','cr','2','13','4','641','','','','','2022-03-03 20:17:02','2022-03-03 20:17:02');
INSERT INTO transactions VALUES('188','1','2022-03-03','1','income','','230','Student','17000.00','cr','2','31','4','641','','','','','2022-03-03 21:01:27','2022-03-03 21:01:27');
INSERT INTO transactions VALUES('189','1','2022-03-04','1','income','','243','Student','17500.00','cr','2','53','4','641','','','','','2022-03-04 19:56:18','2022-03-04 19:56:18');
INSERT INTO transactions VALUES('190','1','2022-03-04','1','income','','239','Student','17500.00','cr','2','44','4','641','','','','','2022-03-04 19:57:05','2022-03-04 19:57:05');
INSERT INTO transactions VALUES('191','1','2022-03-03','1','income','','60','Student','1000.00','cr','2','32','1','641','','','','','2022-03-05 10:46:59','2022-03-05 10:46:59');
INSERT INTO transactions VALUES('192','1','2022-03-03','1','income','','231','Student','17000.00','cr','2','32','1','641','','','','','2022-03-05 10:47:26','2022-03-05 10:47:26');
INSERT INTO transactions VALUES('193','1','2022-03-05','2','income','','211','Student','18500.00','cr','2','7','1','641','','','','','2022-03-05 14:41:54','2022-03-05 14:41:54');
INSERT INTO transactions VALUES('194','1','2022-03-05','1','income','','225','Student','17000.00','cr','2','25','4','641','','','','','2022-03-05 14:54:11','2022-03-05 14:54:11');
INSERT INTO transactions VALUES('195','1','2022-03-05','1','income','','241','Student','17000.00','cr','2','49','4','641','','','','','2022-03-05 15:02:35','2022-03-05 15:02:35');
INSERT INTO transactions VALUES('196','1','2022-03-05','1','income','','251','Student','35000.00','cr','2','62','1','641','','','','','2022-03-05 17:07:52','2022-03-05 17:07:52');
INSERT INTO transactions VALUES('197','1','2022-03-09','1','income','','249','Student','18000.00','cr','2','51','4','641','','','','','2022-03-12 12:06:05','2022-03-12 12:06:05');
INSERT INTO transactions VALUES('198','1','2022-03-09','1','income','','242','Student','18000.00','cr','2','50','4','641','','','','','2022-03-12 12:06:29','2022-03-12 12:06:29');
INSERT INTO transactions VALUES('199','1','2022-03-09','1','income','','212','Student','18500.00','cr','2','8','4','641','','','','','2022-03-12 12:07:25','2022-03-12 12:07:25');
INSERT INTO transactions VALUES('200','1','2022-03-09','1','income','','252','Student','16000.00','cr','2','60','4','641','','','','','2022-03-12 12:13:36','2022-03-12 12:13:36');
INSERT INTO transactions VALUES('201','1','2022-03-09','1','income','','253','Student','16000.00','cr','2','59','4','641','','','','','2022-03-12 12:16:39','2022-03-12 12:16:39');
INSERT INTO transactions VALUES('202','1','2022-03-09','1','income','','224','Student','17000.00','cr','2','24','4','641','','','','','2022-03-12 12:17:27','2022-03-12 12:17:27');
INSERT INTO transactions VALUES('203','1','2022-03-09','1','income','','234','Student','22000.00','cr','2','37','4','641','','','','','2022-03-12 12:17:52','2022-03-12 12:17:52');
INSERT INTO transactions VALUES('204','1','2022-03-09','1','income','','233','Student','22000.00','cr','2','36','4','641','','','','','2022-03-12 12:23:04','2022-03-12 12:23:04');
INSERT INTO transactions VALUES('205','1','2022-03-09','1','income','','223','Student','17000.00','cr','2','23','4','641','','','','','2022-03-12 12:30:23','2022-03-12 12:30:23');
INSERT INTO transactions VALUES('206','1','2022-03-07','1','income','','247','Student','17500.00','cr','2','58','4','641','','','','','2022-03-12 12:35:53','2022-03-12 12:35:53');
INSERT INTO transactions VALUES('207','1','2022-03-07','1','income','','238','Student','17500.00','cr','2','43','4','641','','','','','2022-03-12 12:36:22','2022-03-12 12:36:22');
INSERT INTO transactions VALUES('208','1','2022-03-07','1','income','','236','Student','17500.00','cr','2','40','4','641','','','','','2022-03-12 12:36:49','2022-03-12 12:36:49');
INSERT INTO transactions VALUES('209','1','2022-03-08','1','income','','226','Student','17000.00','cr','2','26','4','641','','','','','2022-03-12 12:39:29','2022-03-12 12:39:29');
INSERT INTO transactions VALUES('210','1','2022-03-08','1','income','','222','Student','17000.00','cr','2','22','4','641','','','','','2022-03-12 12:58:58','2022-03-12 12:58:58');
INSERT INTO transactions VALUES('211','1','2022-03-09','1','income','','248','Student','17500.00','cr','2','56','4','641','','','','','2022-03-12 13:05:12','2022-03-12 13:05:12');
INSERT INTO transactions VALUES('212','1','2022-03-08','1','income','','227','Student','17000.00','cr','2','27','4','641','','','','','2022-03-12 13:06:12','2022-03-12 13:06:12');
INSERT INTO transactions VALUES('213','1','2022-03-08','1','income','','220','Student','15000.00','cr','2','18','4','641','','','','','2022-03-12 13:06:38','2022-03-12 13:06:38');
INSERT INTO transactions VALUES('214','1','2022-03-08','1','income','','219','Student','15000.00','cr','2','17','4','641','','','','','2022-03-12 13:07:04','2022-03-12 13:07:04');
INSERT INTO transactions VALUES('215','1','2022-03-08','1','income','','217','Student','15000.00','cr','2','15','4','641','','','','','2022-03-12 13:07:38','2022-03-12 13:07:38');
INSERT INTO transactions VALUES('216','1','2022-03-08','1','income','','232','Student','15000.00','cr','2','35','4','641','','','','','2022-03-12 13:08:08','2022-03-12 13:08:08');
INSERT INTO transactions VALUES('217','1','2022-03-07','1','income','','246','Student','14000.00','cr','2','57','4','641','','','','','2022-03-12 13:17:06','2022-03-12 13:17:06');
INSERT INTO transactions VALUES('218','1','2022-03-09','1','income','','228','Student','17000.00','cr','2','29','4','641','','','','','2022-03-12 13:20:41','2022-03-12 13:20:41');
INSERT INTO transactions VALUES('219','1','2022-02-22','1','income','','254','Student','21000.00','cr','2','63','4','641','','','','','2022-03-12 15:08:04','2022-03-12 15:08:04');
INSERT INTO transactions VALUES('220','1','2022-03-09','1','income','','255','Student','18000.00','cr','2','63','4','641','','','','','2022-03-12 15:18:47','2022-03-12 15:18:47');
INSERT INTO transactions VALUES('221','1','2022-03-10','1','income','','256','Student','16000.00','cr','2','64','4','641','','','','','2022-03-12 15:32:13','2022-03-12 15:32:13');
INSERT INTO transactions VALUES('222','1','2022-03-14','1','income','','218','Student','15000.00','cr','2','16','4','641','','','','','2022-03-14 13:42:10','2022-03-14 13:42:10');
INSERT INTO transactions VALUES('223','1','2022-03-08','1','income','','214','Student','18000.00','cr','2','10','4','641','','','','','2022-03-14 13:43:00','2022-03-14 13:43:00');
INSERT INTO transactions VALUES('224','1','2022-03-08','1','income','','213','Student','18000.00','cr','2','9','4','641','','','','','2022-03-14 13:43:48','2022-03-14 13:43:48');
INSERT INTO transactions VALUES('225','1','2022-03-13','1','income','','257','Student','28900.00','cr','2','65','4','641','','','','','2022-03-15 07:30:16','2022-03-15 07:30:16');
INSERT INTO transactions VALUES('226','1','2022-03-13','1','income','','258','Student','30800.00','cr','2','66','4','641','','','','','2022-03-15 07:40:39','2022-03-15 07:40:39');
INSERT INTO transactions VALUES('227','1','2022-03-29','1','income','','209','Student','22500.00','cr','2','3','4','641','','','','','2022-04-01 09:04:03','2022-04-01 09:04:03');
INSERT INTO transactions VALUES('228','1','2022-04-01','1','income','','284','Student','19000.00','cr','2','42','4','641','','','','','2022-04-04 07:24:51','2022-04-04 07:24:51');
INSERT INTO transactions VALUES('229','1','2022-04-01','1','income','','287','Student','19000.00','cr','2','46','4','641','','','','','2022-04-04 07:28:25','2022-04-04 07:28:25');
INSERT INTO transactions VALUES('230','1','2022-04-01','1','income','','260','Student','17500.00','cr','2','4','4','641','','','','','2022-04-04 07:30:01','2022-04-04 07:30:01');
INSERT INTO transactions VALUES('231','1','2022-04-01','1','income','','268','Student','18500.00','cr','2','21','4','641','','','','','2022-04-04 07:30:29','2022-04-04 07:30:29');
INSERT INTO transactions VALUES('232','1','2022-04-03','1','income','','272','Student','16000.00','cr','2','25','4','641','','','','','2022-04-04 07:32:15','2022-04-04 07:32:15');
INSERT INTO transactions VALUES('233','1','2022-04-04','1','income','','269','Student','17000.00','cr','2','22','4','641','','','','','2022-04-05 14:26:30','2022-04-05 14:26:30');
INSERT INTO transactions VALUES('234','1','2022-04-04','1','income','','270','Student','17000.00','cr','2','23','4','641','','','','','2022-04-05 14:29:15','2022-04-05 14:29:15');
INSERT INTO transactions VALUES('235','1','2022-04-04','1','income','','271','Student','17000.00','cr','2','24','4','641','','','','','2022-04-05 14:31:48','2022-04-05 14:31:48');
INSERT INTO transactions VALUES('236','1','2022-04-04','1','income','','273','Student','17000.00','cr','2','26','4','641','','','','','2022-04-05 14:32:17','2022-04-05 14:32:17');
INSERT INTO transactions VALUES('237','1','2022-04-04','1','income','','292','Student','15000.00','cr','2','56','4','641','','','','','2022-04-05 14:33:34','2022-04-05 14:33:34');
INSERT INTO transactions VALUES('238','1','2022-04-04','1','income','','301','Student','18500.00','cr','2','66','4','641','','','','','2022-04-05 14:35:41','2022-04-05 14:35:41');
INSERT INTO transactions VALUES('239','1','2022-04-04','1','income','','262','Student','18500.00','cr','2','8','4','641','','','','','2022-04-05 14:40:30','2022-04-05 14:40:30');
INSERT INTO transactions VALUES('240','1','2022-04-04','1','income','','300','Student','18500.00','cr','2','65','4','641','','','','','2022-04-05 14:41:03','2022-04-05 14:41:03');
INSERT INTO transactions VALUES('241','1','2022-04-05','1','income','','303','Student','17000.00','cr','2','62','4','641','','','','','2022-04-05 14:56:20','2022-04-05 14:56:20');
INSERT INTO transactions VALUES('242','1','2022-04-05','1','income','','291','Student','17500.00','cr','2','53','4','641','','','','','2022-04-05 14:56:51','2022-04-05 14:56:51');
INSERT INTO transactions VALUES('243','1','2022-04-06','1','income','','283','Student','17500.00','cr','2','40','4','641','','','','','2022-04-06 11:38:45','2022-04-06 11:38:45');
INSERT INTO transactions VALUES('244','1','2022-04-01','1','income','','304','Student','20000.00','cr','2','68','4','641','','','','','2022-04-06 11:51:01','2022-04-06 11:51:01');
INSERT INTO transactions VALUES('245','1','2022-04-01','1','income','','302','Student','20000.00','cr','2','67','4','641','','','','','2022-04-06 11:58:44','2022-04-06 11:58:44');
INSERT INTO transactions VALUES('246','1','2022-04-06','1','income','','302','Student','0.00','cr','2','67','1','641','','','','','2022-04-06 13:58:57','2022-04-06 13:58:57');
INSERT INTO transactions VALUES('247','1','2022-04-06','1','income','','304','Student','0.00','cr','2','68','1','641','','','','','2022-04-06 13:59:34','2022-04-06 13:59:34');
INSERT INTO transactions VALUES('248','1','2022-04-06','1','expense','','','Income','999999.99','dr','1','','1','641','','jfjfjfgkjg','','','2022-04-06 14:07:06','2022-04-06 14:07:06');
INSERT INTO transactions VALUES('249','1','2022-04-07','2','income','','261','Student','18500.00','cr','2','7','1','641','','','','','2022-04-08 09:14:08','2022-04-08 09:14:08');
INSERT INTO transactions VALUES('250','1','2022-04-07','1','income','','286','Student','17500.00','cr','2','44','4','641','','','','','2022-04-08 09:14:40','2022-04-08 09:14:40');
INSERT INTO transactions VALUES('251','1','2022-04-07','1','income','','292','Student','2500.00','cr','2','56','4','641','','','','','2022-04-08 09:18:13','2022-04-08 09:18:13');
INSERT INTO transactions VALUES('252','1','2022-04-08','1','income','','294','Student','16500.00','cr','2','59','4','641','','','','','2022-04-08 09:27:25','2022-04-08 09:27:25');
INSERT INTO transactions VALUES('253','1','2022-04-08','1','income','','295','Student','16500.00','cr','2','60','4','641','','','','','2022-04-08 09:28:52','2022-04-08 09:28:52');
INSERT INTO transactions VALUES('254','1','2022-04-07','1','income','','305','Student','18500.00','cr','2','69','4','641','','','','','2022-04-08 09:34:23','2022-04-08 09:34:23');
INSERT INTO transactions VALUES('255','1','2022-04-05','1','income','','263','Student','18500.00','cr','2','70','4','641','','','','','2022-04-08 10:44:15','2022-04-08 10:44:15');
INSERT INTO transactions VALUES('256','1','2022-04-08','1','income','','288','Student','17500.00','cr','2','49','4','641','','','','','2022-04-08 10:45:45','2022-04-08 10:45:45');
INSERT INTO transactions VALUES('257','1','2022-04-04','1','income','','274','Student','17000.00','cr','2','27','4','641','','','','','2022-04-08 10:49:24','2022-04-08 10:49:24');
INSERT INTO transactions VALUES('258','1','2022-04-08','1','income','','288','Student','-500.00','cr','2','49','1','641','','','','','2022-04-08 11:05:01','2022-04-08 11:05:01');
INSERT INTO transactions VALUES('259','1','2022-04-09','1','income','','267','Student','15000.00','cr','2','18','4','641','','','','','2022-04-09 13:08:20','2022-04-09 13:08:20');
INSERT INTO transactions VALUES('260','1','2022-04-09','1','income','','266','Student','15000.00','cr','2','17','4','641','','','','','2022-04-09 13:08:46','2022-04-09 13:08:46');
INSERT INTO transactions VALUES('261','1','2022-04-09','1','income','','264','Student','15000.00','cr','2','15','4','641','','','','','2022-04-09 13:09:03','2022-04-09 13:09:03');
INSERT INTO transactions VALUES('262','1','2022-04-09','1','income','','265','Student','15000.00','cr','2','16','4','641','','','','','2022-04-09 13:09:22','2022-04-09 13:09:22');
INSERT INTO transactions VALUES('263','1','2022-04-09','1','income','','281','Student','22000.00','cr','2','37','4','641','','','','','2022-04-09 13:33:44','2022-04-09 13:33:44');
INSERT INTO transactions VALUES('264','1','2022-04-08','1','income','','235','Student','17000.00','cr','3','38','1','641','','','','','2022-04-09 14:19:49','2022-04-09 14:19:49');
INSERT INTO transactions VALUES('265','1','2022-04-09','1','income','','293','Student','17500.00','cr','2','58','4','641','','','','','2022-04-10 14:18:28','2022-04-10 14:18:28');
INSERT INTO transactions VALUES('266','1','2022-04-11','1','income','','290','Student','15000.00','cr','2','51','4','641','','','','','2022-04-12 09:31:42','2022-04-12 09:31:42');
INSERT INTO transactions VALUES('267','1','2022-04-12','1','income','','280','Student','22000.00','cr','2','36','1','641','','','','','2022-04-12 12:09:30','2022-04-12 12:09:30');
INSERT INTO transactions VALUES('268','1','2022-04-09','1','income','','282','Student','17000.00','cr','2','38','4','641','','','','','2022-04-13 08:37:43','2022-04-13 08:37:43');
INSERT INTO transactions VALUES('269','1','2022-04-10','2','income','','279','Student','15000.00','cr','2','35','1','641','','','','','2022-04-13 08:38:12','2022-04-13 08:38:12');
INSERT INTO transactions VALUES('270','1','2022-04-15','1','income','','285','Student','17500.00','cr','2','43','4','641','','','','','2022-04-16 12:23:13','2022-04-16 12:23:13');
INSERT INTO transactions VALUES('271','1','2022-04-15','1','income','','299','Student','16000.00','cr','2','64','4','641','','','','','2022-04-16 12:24:15','2022-04-16 12:24:15');
INSERT INTO transactions VALUES('272','1','2022-04-12','1','income','','289','Student','18000.00','cr','2','50','4','641','','','','','2022-04-16 12:24:37','2022-04-16 12:24:37');
INSERT INTO transactions VALUES('273','1','2022-04-15','1','income','','259','Student','22000.00','cr','2','3','1','641','','','','','2022-04-16 12:25:42','2022-04-16 12:25:42');
INSERT INTO transactions VALUES('274','1','2022-04-16','1','income','','307','Student','6000.00','cr','2','14','4','641','','','','','2022-04-18 08:11:14','2022-04-18 08:11:14');
INSERT INTO transactions VALUES('275','1','2022-04-16','1','income','','275','Student','17000.00','cr','2','29','4','641','','','','','2022-04-18 08:13:05','2022-04-18 08:13:05');
INSERT INTO transactions VALUES('276','1','2022-04-16','1','income','','276','Student','17000.00','cr','2','30','4','641','','','','','2022-04-18 08:13:29','2022-04-18 08:13:29');
INSERT INTO transactions VALUES('277','1','2022-04-16','1','income','','277','Student','17000.00','cr','2','31','4','641','','','','','2022-04-18 08:13:50','2022-04-18 08:13:50');
INSERT INTO transactions VALUES('278','1','2022-04-16','1','income','','278','Student','17000.00','cr','2','32','4','641','','','','','2022-04-18 08:14:07','2022-04-18 08:14:07');
INSERT INTO transactions VALUES('279','1','2022-04-18','1','income','','308','Student','25000.00','cr','2','71','4','641','','','','','2022-04-23 14:59:54','2022-04-23 14:59:54');
INSERT INTO transactions VALUES('280','1','2022-04-24','1','income','','309','Student','45000.00','cr','2','72','4','641','','','','','2022-04-28 08:40:21','2022-04-28 08:40:21');
INSERT INTO transactions VALUES('281','1','2022-05-01','2','income','','318','Student','18500.00','cr','3','21','1','641','','','','','2022-05-10 14:45:16','2022-05-10 14:45:16');
INSERT INTO transactions VALUES('282','1','2022-05-01','1','income','','343','Student','17500.00','cr','2','58','4','641','','','','','2022-05-10 14:45:43','2022-05-10 14:45:43');
INSERT INTO transactions VALUES('283','1','2022-05-01','1','income','','342','Student','16000.00','cr','2','56','1','641','','','','','2022-05-10 14:47:36','2022-05-10 14:47:36');
INSERT INTO transactions VALUES('284','1','2022-05-01','2','income','','333','Student','17500.00','cr','2','40','1','641','','','','','2022-05-10 14:48:00','2022-05-10 14:48:00');
INSERT INTO transactions VALUES('285','1','2022-05-01','2','income','','337','Student','19000.00','cr','2','46','1','641','','','','','2022-05-10 14:58:15','2022-05-10 14:58:15');
INSERT INTO transactions VALUES('286','1','2022-05-01','2','income','','356','Student','4000.00','cr','2','46','1','641','','','','','2022-05-10 14:58:36','2022-05-10 14:58:36');
INSERT INTO transactions VALUES('287','1','2022-05-01','2','income','','259','Student','500.00','cr','2','3','1','641','','','','','2022-05-10 15:00:12','2022-05-10 15:00:12');
INSERT INTO transactions VALUES('288','1','2022-05-01','2','income','','310','Student','22500.00','cr','2','3','1','641','','','','','2022-05-10 15:00:42','2022-05-10 15:00:42');
INSERT INTO transactions VALUES('289','1','2022-05-01','1','income','','311','Student','17500.00','cr','2','4','4','641','','','','','2022-05-10 15:01:28','2022-05-10 15:01:28');
INSERT INTO transactions VALUES('290','1','2022-05-01','1','income','','347','Student','10000.00','cr','2','64','4','641','','','','','2022-05-10 15:01:55','2022-05-10 15:01:55');
INSERT INTO transactions VALUES('291','1','2022-05-06','1','income','','317','Student','15000.00','cr','2','18','4','641','','','','','2022-05-10 15:02:35','2022-05-10 15:02:35');
INSERT INTO transactions VALUES('292','1','2022-05-06','1','income','','316','Student','15000.00','cr','2','17','4','641','','','','','2022-05-10 15:03:03','2022-05-10 15:03:03');
INSERT INTO transactions VALUES('293','1','2022-05-07','1','income','','348','Student','18500.00','cr','2','65','4','641','','','','','2022-05-10 15:07:43','2022-05-10 15:07:43');
INSERT INTO transactions VALUES('294','1','2022-05-07','1','income','','354','Student','20000.00','cr','2','71','4','641','','','','','2022-05-10 15:09:57','2022-05-10 15:09:57');
INSERT INTO transactions VALUES('295','1','2022-05-08','1','income','','349','Student','18500.00','cr','2','66','4','641','','','','','2022-05-10 15:12:05','2022-05-10 15:12:05');
INSERT INTO transactions VALUES('296','1','2022-05-08','2','income','','312','Student','18500.00','cr','2','7','1','641','','','','','2022-05-10 15:12:34','2022-05-10 15:12:34');
INSERT INTO transactions VALUES('297','1','2022-05-08','2','income','','319','Student','17000.00','cr','2','22','1','641','','','','','2022-05-10 15:15:57','2022-05-10 15:15:57');
INSERT INTO transactions VALUES('298','1','2022-05-08','1','income','','346','Student','17000.00','cr','2','62','4','641','','','','','2022-05-10 15:16:56','2022-05-10 15:16:56');
INSERT INTO transactions VALUES('299','1','2022-05-08','1','income','','351','Student','20000.00','cr','2','68','4','641','','','','','2022-05-10 15:19:05','2022-05-10 15:19:05');
INSERT INTO transactions VALUES('300','1','2022-05-09','1','income','','350','Student','20000.00','cr','2','67','4','641','','','','','2022-05-10 15:20:28','2022-05-10 15:20:28');
INSERT INTO transactions VALUES('301','1','2022-05-09','1','income','','335','Student','17500.00','cr','2','43','4','641','','','','','2022-05-10 15:20:48','2022-05-10 15:20:48');
INSERT INTO transactions VALUES('302','1','2022-05-09','1','income','','272','Student','1000.00','cr','2','25','4','641','','','','','2022-05-10 15:21:10','2022-05-10 15:21:10');
INSERT INTO transactions VALUES('303','1','2022-05-09','1','income','','322','Student','17000.00','cr','3','25','4','641','','','','','2022-05-10 15:22:28','2022-05-10 15:22:28');
INSERT INTO transactions VALUES('304','1','2022-05-09','1','income','','357','Student','29000.00','cr','2','73','4','641','','','','','2022-05-11 07:13:08','2022-05-11 07:13:08');
INSERT INTO transactions VALUES('305','1','2022-05-09','1','income','','358','Student','25000.00','cr','2','74','4','641','','','','','2022-05-11 07:13:33','2022-05-11 07:13:33');
INSERT INTO transactions VALUES('306','1','2022-05-10','1','income','','314','Student','15000.00','cr','2','15','4','641','','','','','2022-05-11 07:15:15','2022-05-11 07:15:15');
INSERT INTO transactions VALUES('307','1','2022-05-10','1','income','','359','Student','16500.00','cr','2','75','4','641','','','','','2022-05-11 07:38:08','2022-05-11 07:38:08');
INSERT INTO transactions VALUES('308','1','2022-05-10','1','income','','361','Student','11500.00','cr','2','77','1','641','','','','','2022-05-11 12:40:50','2022-05-11 12:40:50');
INSERT INTO transactions VALUES('309','1','2022-05-10','1','income','','360','Student','11500.00','cr','2','76','4','641','','','','','2022-05-11 12:41:19','2022-05-11 12:41:19');
INSERT INTO transactions VALUES('310','1','2022-05-11','1','income','','353','Student','18500.00','cr','2','70','4','641','','','','','2022-05-11 12:42:32','2022-05-11 12:42:32');
INSERT INTO transactions VALUES('311','1','2022-05-12','1','income','','323','Student','17000.00','cr','2','26','4','641','','','','','2022-05-23 07:43:48','2022-05-23 07:43:48');
INSERT INTO transactions VALUES('312','1','2022-05-12','1','income','','298','Student','15000.00','cr','2','63','4','641','','','','','2022-05-23 07:45:08','2022-05-23 07:45:08');
INSERT INTO transactions VALUES('313','1','2022-05-12','1','income','','330','Student','22000.00','cr','2','36','4','641','','','','','2022-05-23 07:46:12','2022-05-23 07:46:12');
INSERT INTO transactions VALUES('314','1','2022-05-12','1','income','','324','Student','17000.00','cr','2','27','4','641','','','','','2022-05-23 07:47:16','2022-05-23 07:47:16');
INSERT INTO transactions VALUES('315','1','2022-05-12','1','income','','338','Student','17000.00','cr','2','49','4','641','','','','','2022-05-23 07:48:58','2022-05-23 07:48:58');
INSERT INTO transactions VALUES('316','1','2022-05-13','1','income','','352','Student','18500.00','cr','2','69','4','641','','','','','2022-05-23 07:49:32','2022-05-23 07:49:32');
INSERT INTO transactions VALUES('317','1','2022-05-13','1','income','','320','Student','17000.00','cr','2','23','4','641','','','','','2022-05-23 07:50:23','2022-05-23 07:50:23');
INSERT INTO transactions VALUES('318','1','2022-05-13','2','income','','336','Student','17500.00','cr','2','44','1','641','','','','','2022-05-23 07:51:06','2022-05-23 07:51:06');
INSERT INTO transactions VALUES('319','1','2022-05-13','2','income','','341','Student','17500.00','cr','2','53','1','641','','','','','2022-05-23 07:51:50','2022-05-23 07:51:50');
INSERT INTO transactions VALUES('320','1','2022-05-14','1','income','','313','Student','18500.00','cr','2','8','4','641','','','','','2022-05-23 07:52:35','2022-05-23 07:52:35');
INSERT INTO transactions VALUES('321','1','2022-05-14','1','income','','340','Student','18000.00','cr','2','51','4','641','','','','','2022-05-23 07:53:19','2022-05-23 07:53:19');
INSERT INTO transactions VALUES('322','1','2022-05-14','1','income','','329','Student','10000.00','cr','2','35','4','641','','','','','2022-05-23 07:54:08','2022-05-23 07:54:08');
INSERT INTO transactions VALUES('323','1','2022-05-15','1','income','','315','Student','15000.00','cr','2','16','4','641','','','','','2022-05-23 07:54:37','2022-05-23 07:54:37');
INSERT INTO transactions VALUES('324','1','2022-05-15','2','income','','321','Student','17000.00','cr','2','24','1','641','','','','','2022-05-23 07:55:08','2022-05-23 07:55:08');
INSERT INTO transactions VALUES('325','1','2022-05-17','1','income','','362','Student','30000.00','cr','2','78','4','641','','','','','2022-05-23 07:55:51','2022-05-23 07:55:51');
INSERT INTO transactions VALUES('326','1','2022-05-18','1','income','','358','Student','4000.00','cr','2','74','4','641','','','','','2022-05-23 07:56:55','2022-05-23 07:56:55');
INSERT INTO transactions VALUES('327','1','2022-05-22','1','income','','363','Student','5000.00','cr','2','79','4','641','','','','','2022-05-23 07:58:01','2022-05-23 07:58:01');
INSERT INTO transactions VALUES('328','1','2022-05-19','1','income','','331','Student','22000.00','cr','2','37','4','641','','','','','2022-05-23 07:58:30','2022-05-23 07:58:30');
INSERT INTO transactions VALUES('329','1','2022-05-17','1','income','','364','Student','10000.00','cr','2','80','4','641','','','','','2022-05-23 08:13:46','2022-05-23 08:13:46');
INSERT INTO transactions VALUES('330','1','2022-05-23','1','income','','347','Student','6000.00','cr','2','64','4','641','','','','','2022-05-23 11:39:40','2022-05-23 11:39:40');
INSERT INTO transactions VALUES('331','1','2022-05-24','1','income','','332','Student','17000.00','cr','2','38','4','641','','','','','2022-05-25 12:10:33','2022-05-25 12:10:33');
INSERT INTO transactions VALUES('332','1','2022-05-24','2','income','','329','Student','5000.00','cr','2','35','1','641','','','','','2022-05-29 08:40:09','2022-05-29 08:40:09');
INSERT INTO transactions VALUES('333','1','2022-05-24','1','income','','344','Student','10000.00','cr','2','59','4','641','','','','','2022-05-29 08:41:02','2022-05-29 08:41:02');
INSERT INTO transactions VALUES('334','1','2022-05-24','1','income','','345','Student','10000.00','cr','2','60','4','641','','','','','2022-05-29 08:41:46','2022-05-29 08:41:46');
INSERT INTO transactions VALUES('335','1','2022-05-30','1','income','','361','Student','17500.00','cr','2','77','4','641','','','','','2022-05-30 13:27:59','2022-05-30 13:27:59');
INSERT INTO transactions VALUES('336','1','2022-05-29','1','income','','365','Student','5000.00','cr','2','81','4','641','','','','','2022-05-31 07:54:55','2022-05-31 07:54:55');
INSERT INTO transactions VALUES('337','1','2022-05-20','1','income','','366','Student','20000.00','cr','2','82','4','641','','','','','2022-06-02 10:37:56','2022-06-02 10:37:56');
INSERT INTO transactions VALUES('338','1','2022-06-01','1','income','','411','Student','10000.00','cr','2','77','4','641','','','','','2022-06-04 05:47:52','2022-06-04 05:47:52');
INSERT INTO transactions VALUES('339','1','2022-06-01','1','income','','387','Student','19000.00','cr','2','46','4','641','','','','','2022-06-04 05:50:18','2022-06-04 05:50:18');
INSERT INTO transactions VALUES('340','1','2022-06-01','1','income','','384','Student','19000.00','cr','2','42','4','641','','','','','2022-06-04 05:51:58','2022-06-04 05:51:58');
INSERT INTO transactions VALUES('341','1','2022-06-01','2','income','','412','Student','20000.00','cr','2','79','1','641','','','','','2022-06-04 05:53:29','2022-06-04 05:53:29');
INSERT INTO transactions VALUES('342','1','2022-06-01','1','income','','417','Student','30000.00','cr','2','84','4','641','','','','','2022-06-04 06:01:30','2022-06-04 06:01:30');
INSERT INTO transactions VALUES('343','1','2022-06-01','2','income','','419','Student','17000.00','cr','2','83','1','641','','','','','2022-06-04 06:04:19','2022-06-04 06:04:19');
INSERT INTO transactions VALUES('344','1','2022-06-01','2','income','','418','Student','17000.00','cr','2','85','1','641','','','','','2022-06-04 06:05:06','2022-06-04 06:05:06');
INSERT INTO transactions VALUES('345','1','2022-06-01','1','income','','385','Student','17500.00','cr','2','43','4','641','','','','','2022-06-04 06:06:07','2022-06-04 06:06:07');
INSERT INTO transactions VALUES('346','1','2022-06-01','1','income','','368','Student','17500.00','cr','2','4','4','641','','','','','2022-06-04 06:08:23','2022-06-04 06:08:23');
INSERT INTO transactions VALUES('347','1','2022-06-01','1','income','','420','Student','10000.00','cr','2','86','4','641','','','','','2022-06-04 06:12:51','2022-06-04 06:12:51');
INSERT INTO transactions VALUES('348','1','2022-06-03','1','income','','396','Student','17000.00','cr','2','62','4','641','','','','','2022-06-04 06:15:21','2022-06-04 06:15:21');
INSERT INTO transactions VALUES('349','1','2022-06-03','1','income','','410','Student','17500.00','cr','2','76','4','641','','','','','2022-06-04 06:17:49','2022-06-04 06:17:49');
INSERT INTO transactions VALUES('350','1','2022-06-04','1','income','','413','Student','0.00','cr','2','1','4','641','641','','','','2022-06-04 06:35:51','2022-06-12 11:00:05');
INSERT INTO transactions VALUES('351','1','2022-05-30','1','income','','342','Student','1500.00','cr','2','56','4','641','','','','','2022-06-04 06:39:16','2022-06-04 06:39:16');
INSERT INTO transactions VALUES('352','1','2022-06-04','1','income','','413','Student','0.00','cr','2','1','4','641','641','','','','2022-06-04 06:47:00','2022-06-12 10:58:28');
INSERT INTO transactions VALUES('353','1','2022-06-04','1','income','','422','Student','32000.00','cr','2','89','4','641','','','','','2022-06-05 14:58:38','2022-06-05 14:58:38');
INSERT INTO transactions VALUES('354','1','2022-06-04','1','income','','423','Student','22000.00','cr','2','90','4','641','','','','','2022-06-05 14:59:49','2022-06-05 14:59:49');
INSERT INTO transactions VALUES('355','1','2022-06-06','1','income','','393','Student','17500.00','cr','2','58','4','641','','','','','2022-06-06 05:52:03','2022-06-06 05:52:03');
INSERT INTO transactions VALUES('356','1','2022-06-06','1','income','','370','Student','18500.00','cr','2','8','4','641','','','','','2022-06-06 06:43:27','2022-06-06 06:43:27');
INSERT INTO transactions VALUES('357','1','2022-06-06','1','income','','372','Student','15000.00','cr','2','16','4','641','','','','','2022-06-06 12:59:40','2022-06-06 12:59:40');
INSERT INTO transactions VALUES('358','1','2022-06-06','1','income','','379','Student','15000.00','cr','2','35','4','641','','','','','2022-06-06 13:00:12','2022-06-06 13:00:12');
INSERT INTO transactions VALUES('359','1','2022-06-06','1','income','','374','Student','15000.00','cr','2','18','4','641','','','','','2022-06-06 13:00:37','2022-06-06 13:00:37');
INSERT INTO transactions VALUES('360','1','2022-06-06','1','income','','421','Student','17000.00','cr','2','87','1','641','','','','','2022-06-06 13:01:44','2022-06-06 13:01:44');
INSERT INTO transactions VALUES('361','1','2022-06-06','1','income','','376','Student','17000.00','cr','2','25','4','641','','','','','2022-06-06 13:03:04','2022-06-06 13:03:04');
INSERT INTO transactions VALUES('362','1','2022-06-06','1','income','','369','Student','18500.00','cr','2','7','4','641','','','','','2022-06-06 13:04:29','2022-06-06 13:04:29');
INSERT INTO transactions VALUES('363','1','2022-06-06','1','income','','383','Student','17500.00','cr','2','40','4','641','','','','','2022-06-06 13:05:34','2022-06-06 13:05:34');
INSERT INTO transactions VALUES('364','1','2022-06-06','1','income','','424','Student','16500.00','cr','2','60','4','641','','','','','2022-06-06 13:40:12','2022-06-06 13:40:12');
INSERT INTO transactions VALUES('365','1','2022-06-06','1','income','','401','Student','20000.00','cr','2','67','4','641','','','','','2022-06-07 04:45:32','2022-06-07 04:45:32');
INSERT INTO transactions VALUES('366','1','2022-06-07','1','income','','407','Student','17500.00','cr','2','73','4','641','','','','','2022-06-07 09:02:13','2022-06-07 09:02:13');
INSERT INTO transactions VALUES('367','1','2022-06-07','1','income','','420','Student','17000.00','cr','2','86','4','641','','','','','2022-06-07 09:06:07','2022-06-07 09:06:07');
INSERT INTO transactions VALUES('368','1','2022-06-06','1','income','','425','Student','16500.00','cr','2','60','4','641','','','','','2022-06-09 06:53:09','2022-06-09 06:53:09');
INSERT INTO transactions VALUES('369','1','2022-06-07','1','income','','403','Student','18500.00','cr','2','69','4','641','','','','','2022-06-09 13:54:20','2022-06-09 13:54:20');
INSERT INTO transactions VALUES('370','1','2022-06-07','1','income','','426','Student','6000.00','cr','2','71','4','641','','','','','2022-06-09 14:00:24','2022-06-09 14:00:24');
INSERT INTO transactions VALUES('371','1','2022-06-07','1','income','','418','Student','17000.00','cr','2','85','4','641','','','','','2022-06-09 14:01:37','2022-06-09 14:01:37');
INSERT INTO transactions VALUES('372','1','2022-06-07','1','income','','419','Student','17000.00','cr','2','83','4','641','','','','','2022-06-09 14:02:11','2022-06-09 14:02:11');
INSERT INTO transactions VALUES('373','1','2022-06-07','1','income','','402','Student','20000.00','cr','2','68','4','641','','','','','2022-06-09 14:06:06','2022-06-09 14:06:06');
INSERT INTO transactions VALUES('374','1','2022-06-07','1','income','','375','Student','18500.00','cr','2','21','4','641','','','','','2022-06-09 14:07:05','2022-06-09 14:07:05');
INSERT INTO transactions VALUES('375','1','2022-06-09','1','income','','388','Student','17500.00','cr','2','49','4','641','','','','','2022-06-09 14:07:49','2022-06-09 14:07:49');
INSERT INTO transactions VALUES('376','1','2022-06-09','1','income','','404','Student','18500.00','cr','2','70','4','641','','','','','2022-06-09 14:10:10','2022-06-09 14:10:10');
INSERT INTO transactions VALUES('377','1','2022-06-09','1','income','','399','Student','18500.00','cr','2','65','4','641','','','','','2022-06-09 14:10:47','2022-06-09 14:10:47');
INSERT INTO transactions VALUES('378','1','2022-06-09','1','income','','400','Student','18500.00','cr','2','66','4','641','','','','','2022-06-09 14:11:45','2022-06-09 14:11:45');
INSERT INTO transactions VALUES('379','1','2022-06-09','1','income','','406','Student','25000.00','cr','2','72','4','641','','','','','2022-06-09 14:14:56','2022-06-09 14:14:56');
INSERT INTO transactions VALUES('380','1','2022-06-09','1','income','','355','Student','4000.00','cr','2','72','4','641','','','','','2022-06-09 14:15:44','2022-06-09 14:15:44');
INSERT INTO transactions VALUES('381','1','2022-06-06','1','income','','397','Student','18000.00','cr','2','63','4','641','','','','','2022-06-09 14:25:23','2022-06-09 14:25:23');
INSERT INTO transactions VALUES('382','1','2022-06-10','1','income','','367','Student','22430.00','cr','2','3','4','641','','','','','2022-06-10 14:32:37','2022-06-10 14:32:37');
INSERT INTO transactions VALUES('383','1','2022-06-10','1','income','','371','Student','15000.00','cr','2','15','4','641','','','','','2022-06-10 14:35:55','2022-06-10 14:35:55');
INSERT INTO transactions VALUES('384','1','2022-06-10','1','income','','373','Student','15000.00','cr','2','17','4','641','','','','','2022-06-10 14:37:13','2022-06-10 14:37:13');
INSERT INTO transactions VALUES('385','1','2022-06-10','1','income','','391','Student','17500.00','cr','2','53','4','641','','','','','2022-06-10 14:37:51','2022-06-10 14:37:51');
INSERT INTO transactions VALUES('386','1','2022-06-10','1','income','','414','Student','17000.00','cr','2','81','4','641','','','','','2022-06-11 12:59:07','2022-06-11 12:59:07');
INSERT INTO transactions VALUES('387','1','2022-05-30','1','income','','339','Student','18000.00','cr','2','50','4','641','','','','','2022-06-11 13:00:51','2022-06-11 13:00:51');
INSERT INTO transactions VALUES('388','1','2022-06-11','1','income','','389','Student','18000.00','cr','2','50','4','641','','','','','2022-06-11 13:01:10','2022-06-11 13:01:10');
INSERT INTO transactions VALUES('389','1','2022-06-11','1','income','','409','Student','10000.00','cr','2','75','4','641','','','','','2022-06-11 13:04:14','2022-06-11 13:04:14');
INSERT INTO transactions VALUES('390','1','2022-06-11','1','income','','359','Student','12500.00','cr','2','75','4','641','','','','','2022-06-11 13:04:40','2022-06-11 13:04:40');
INSERT INTO transactions VALUES('391','1','2022-06-11','1','income','','408','Student','17500.00','cr','2','74','4','641','','','','','2022-06-11 13:05:13','2022-06-11 13:05:13');
INSERT INTO transactions VALUES('392','1','2022-06-11','1','income','','298','Student','3000.00','cr','2','63','4','641','','','','','2022-06-11 13:12:27','2022-06-11 13:12:27');
INSERT INTO transactions VALUES('393','1','2022-06-07','1','income','','427','Student','3000.00','cr','2','63','4','641','','','','','2022-06-11 13:15:41','2022-06-11 13:15:41');
INSERT INTO transactions VALUES('394','1','2022-06-07','1','income','','428','Student','20000.00','cr','2','78','4','641','','','','','2022-06-11 13:29:02','2022-06-11 13:29:02');
INSERT INTO transactions VALUES('395','1','2022-06-11','1','income','','392','Student','17500.00','cr','2','56','4','641','','','','','2022-06-11 13:35:16','2022-06-11 13:35:16');
INSERT INTO transactions VALUES('396','1','2022-06-14','1','income','','398','Student','16000.00','cr','2','64','4','641','','','','','2022-06-25 15:41:03','2022-06-25 15:41:03');
INSERT INTO transactions VALUES('397','1','2022-06-14','1','income','','386','Student','17500.00','cr','2','44','4','641','','','','','2022-06-25 15:41:58','2022-06-25 15:41:58');
INSERT INTO transactions VALUES('398','1','2022-06-14','1','income','','429','Student','23300.00','cr','2','91','4','641','','','','','2022-06-25 16:04:07','2022-06-25 16:04:07');
INSERT INTO transactions VALUES('399','1','2022-06-14','1','income','','430','Student','30000.00','cr','2','92','4','641','','','','','2022-07-03 07:27:12','2022-07-03 07:27:12');
INSERT INTO transactions VALUES('400','1','2022-06-13','1','income','','431','Student','17000.00','cr','2','93','4','641','','','','','2022-07-03 07:52:10','2022-07-03 07:52:10');
INSERT INTO transactions VALUES('401','1','2022-06-12','1','income','','363','Student','20000.00','cr','2','79','4','641','','','','','2022-07-03 08:04:33','2022-07-03 08:04:33');
INSERT INTO transactions VALUES('402','1','2022-07-01','1','income','','447','Student','19000.00','cr','2','46','4','641','','','','','2022-07-03 11:10:47','2022-07-03 11:10:47');
INSERT INTO transactions VALUES('403','1','2022-07-01','1','income','','444','Student','19000.00','cr','2','42','4','641','','','','','2022-07-03 11:11:16','2022-07-03 11:11:16');
INSERT INTO transactions VALUES('404','1','2022-07-03','2','income','','433','Student','18500.00','cr','2','7','1','641','','','','','2022-07-08 08:50:05','2022-07-08 08:50:05');
INSERT INTO transactions VALUES('405','1','2022-07-04','1','income','','445','Student','17500.00','cr','2','43','4','641','','','','','2022-07-08 10:09:00','2022-07-08 10:09:00');
INSERT INTO transactions VALUES('406','1','2022-07-05','2','income','','476','Student','20000.00','cr','2','91','1','641','','','','','2022-07-08 10:17:20','2022-07-08 10:17:20');
INSERT INTO transactions VALUES('407','1','2022-07-05','1','income','','472','Student','20000.00','cr','2','84','4','641','','','','','2022-07-08 10:18:16','2022-07-08 10:18:16');
INSERT INTO transactions VALUES('408','1','2022-07-05','2','income','','469','Student','20000.00','cr','2','79','1','641','','','','','2022-07-08 10:27:26','2022-07-08 10:27:26');
INSERT INTO transactions VALUES('409','1','2022-07-03','1','income','','468','Student','17500.00','cr','2','77','4','641','','','','','2022-07-08 10:30:03','2022-07-08 10:30:03');
INSERT INTO transactions VALUES('410','1','2022-07-05','2','income','','441','Student','15000.00','cr','2','35','1','641','','','','','2022-07-08 10:37:22','2022-07-08 10:37:22');
INSERT INTO transactions VALUES('411','1','2022-07-05','1','income','','470','Student','17000.00','cr','2','81','4','641','','','','','2022-07-08 10:49:41','2022-07-08 10:49:41');
INSERT INTO transactions VALUES('412','1','2022-07-06','1','income','','460','Student','20000.00','cr','2','68','4','641','','','','','2022-07-08 10:55:27','2022-07-08 10:55:27');
INSERT INTO transactions VALUES('413','1','2022-07-06','1','income','','459','Student','20000.00','cr','2','67','4','641','','','','','2022-07-08 10:56:19','2022-07-08 10:56:19');
INSERT INTO transactions VALUES('414','1','2022-07-06','1','income','','461','Student','18500.00','cr','2','69','4','641','','','','','2022-07-08 10:57:06','2022-07-08 10:57:06');
INSERT INTO transactions VALUES('415','1','2022-07-06','1','income','','455','Student','18000.00','cr','2','63','4','641','','','','','2022-07-08 10:58:05','2022-07-08 10:58:05');
INSERT INTO transactions VALUES('416','1','2022-07-03','1','income','','453','Student','0.00','cr','2','1','4','641','641','','','','2022-07-08 11:06:18','2022-07-16 07:50:55');
INSERT INTO transactions VALUES('417','1','2022-07-06','1','income','','449','Student','18000.00','cr','2','50','4','641','','','','','2022-07-08 11:08:04','2022-07-08 11:08:04');
INSERT INTO transactions VALUES('418','1','2022-07-03','1','income','','443','Student','17500.00','cr','2','40','4','641','','','','','2022-07-08 11:16:25','2022-07-08 11:16:25');
INSERT INTO transactions VALUES('419','1','2022-07-02','1','income','','440','Student','17000.00','cr','2','25','4','641','','','','','2022-07-08 11:17:56','2022-07-08 11:17:56');
INSERT INTO transactions VALUES('420','1','2022-07-05','1','income','','438','Student','15000.00','cr','2','18','4','641','','','','','2022-07-08 11:20:18','2022-07-08 11:20:18');
INSERT INTO transactions VALUES('421','1','2022-07-05','1','income','','437','Student','15000.00','cr','2','17','4','641','','','','','2022-07-08 11:24:34','2022-07-08 11:24:34');
INSERT INTO transactions VALUES('422','1','2022-07-05','2','income','','436','Student','15000.00','cr','2','16','1','641','','','','','2022-07-08 11:25:18','2022-07-08 11:25:18');
INSERT INTO transactions VALUES('423','1','2022-07-05','1','income','','435','Student','15000.00','cr','2','15','4','641','','','','','2022-07-08 11:27:32','2022-07-08 11:27:32');
INSERT INTO transactions VALUES('424','1','2022-07-06','1','income','','448','Student','17000.00','cr','2','49','4','641','','','','','2022-07-08 11:29:07','2022-07-08 11:29:07');
INSERT INTO transactions VALUES('425','1','2022-07-03','1','income','','452','Student','17500.00','cr','2','58','4','641','','','','','2022-07-08 11:35:26','2022-07-08 11:35:26');
INSERT INTO transactions VALUES('426','1','2022-07-06','1','income','','442','Student','17000.00','cr','2','38','4','641','','','','','2022-07-08 11:36:57','2022-07-08 11:36:57');
INSERT INTO transactions VALUES('427','1','2022-07-06','1','income','','466','Student','17000.00','cr','2','75','4','641','','','','','2022-07-08 11:40:29','2022-07-08 11:40:29');
INSERT INTO transactions VALUES('428','1','2022-07-06','1','income','','465','Student','17500.00','cr','2','74','4','641','','','','','2022-07-08 11:41:08','2022-07-08 11:41:08');
INSERT INTO transactions VALUES('429','1','2022-07-06','1','income','','464','Student','17500.00','cr','2','73','4','641','','','','','2022-07-08 11:48:11','2022-07-08 11:48:11');
INSERT INTO transactions VALUES('430','1','2022-07-06','1','income','','450','Student','18000.00','cr','2','51','4','641','','','','','2022-07-08 11:53:57','2022-07-08 11:53:57');
INSERT INTO transactions VALUES('431','1','2022-07-06','1','income','','473','Student','17000.00','cr','2','85','4','641','','','','','2022-07-08 11:55:02','2022-07-08 11:55:02');
INSERT INTO transactions VALUES('432','1','2022-07-06','1','income','','439','Student','18500.00','cr','2','21','4','641','','','','','2022-07-08 11:55:54','2022-07-08 11:55:54');
INSERT INTO transactions VALUES('433','1','2022-07-06','1','income','','434','Student','18500.00','cr','2','8','4','641','','','','','2022-07-08 11:56:42','2022-07-08 11:56:42');
INSERT INTO transactions VALUES('434','1','2022-07-06','1','income','','458','Student','18500.00','cr','2','66','4','641','','','','','2022-07-08 11:57:37','2022-07-08 11:57:37');
INSERT INTO transactions VALUES('435','1','2022-07-07','1','income','','463','Student','25000.00','cr','2','72','4','641','','','','','2022-07-08 12:06:03','2022-07-08 12:06:03');
INSERT INTO transactions VALUES('436','1','2022-07-07','1','income','','390','Student','15000.00','cr','2','51','4','641','','','','','2022-07-08 12:10:21','2022-07-08 12:10:21');
INSERT INTO transactions VALUES('437','1','2022-07-09','1','income','','457','Student','8500.00','cr','2','65','4','641','','','','','2022-07-09 13:49:27','2022-07-09 13:49:27');
INSERT INTO transactions VALUES('438','1','2022-07-03','1','income','','481','Student','20000.00','cr','2','98','4','641','','','','','2022-07-14 11:40:01','2022-07-14 11:40:01');
INSERT INTO transactions VALUES('439','1','2022-07-07','1','income','','478','Student','32000.00','cr','2','95','4','641','','','','','2022-07-14 11:40:51','2022-07-14 11:40:51');
INSERT INTO transactions VALUES('440','1','2022-07-07','1','income','','479','Student','37000.00','cr','2','96','4','641','','','','','2022-07-14 11:41:24','2022-07-14 11:41:24');
INSERT INTO transactions VALUES('441','1','2022-07-05','1','income','','480','Student','32500.00','cr','2','97','4','641','','','','','2022-07-14 11:43:05','2022-07-14 11:43:05');
INSERT INTO transactions VALUES('442','1','2022-07-07','1','income','','482','Student','40000.00','cr','2','99','4','641','','','','','2022-07-16 06:45:10','2022-07-16 06:45:10');
INSERT INTO transactions VALUES('443','1','2022-07-01','1','income','','483','Student','32500.00','cr','2','94','4','641','','','','','2022-07-16 06:57:44','2022-07-16 06:57:44');
INSERT INTO transactions VALUES('444','1','2022-07-04','1','income','','484','Student','17500.00','cr','2','86','4','641','','','','','2022-07-16 08:15:36','2022-07-16 08:15:36');
INSERT INTO transactions VALUES('445','1','2022-07-16','1','income','','432','Student','22400.00','cr','2','3','4','641','','','','','2022-07-16 10:22:41','2022-07-16 10:22:41');
INSERT INTO transactions VALUES('446','1','2022-07-16','1','income','','475','Student','17000.00','cr','2','87','4','641','','','','','2022-07-16 15:10:31','2022-07-16 15:10:31');
INSERT INTO transactions VALUES('447','1','2022-07-19','1','income','','488','Student','17000.00','cr','2','103','4','641','','','','','2022-07-20 06:13:55','2022-07-20 06:13:55');
INSERT INTO transactions VALUES('448','1','2022-07-20','1','income','','489','Student','5000.00','cr','2','89','4','641','','','','','2022-07-21 08:48:58','2022-07-21 08:48:58');
INSERT INTO transactions VALUES('449','1','2022-07-18','1','income','','487','Student','15000.00','cr','2','102','4','641','','','','','2022-07-21 08:56:57','2022-07-21 08:56:57');
INSERT INTO transactions VALUES('450','1','2022-07-18','1','income','','486','Student','16000.00','cr','2','101','4','641','','','','','2022-07-21 08:57:32','2022-07-21 08:57:32');
INSERT INTO transactions VALUES('451','1','2022-07-18','1','income','','477','Student','6000.00','cr','2','92','4','641','','','','','2022-07-21 08:59:18','2022-07-21 08:59:18');
INSERT INTO transactions VALUES('452','1','2022-07-18','1','income','','485','Student','18000.00','cr','2','100','4','641','','','','','2022-07-21 09:00:55','2022-07-21 09:00:55');
INSERT INTO transactions VALUES('453','1','2022-07-21','1','income','','490','Student','17000.00','cr','2','104','4','641','','','','','2022-07-21 09:58:36','2022-07-21 09:58:36');
INSERT INTO transactions VALUES('454','1','2022-07-19','1','income','','446','Student','17500.00','cr','2','44','4','641','','','','','2022-07-21 10:01:34','2022-07-21 10:01:34');
INSERT INTO transactions VALUES('455','1','2022-07-23','1','income','','491','Student','22000.00','cr','2','105','4','641','','','','','2022-07-23 08:39:57','2022-07-23 08:39:57');
INSERT INTO transactions VALUES('456','1','2022-07-23','1','income','','493','Student','21500.00','cr','2','106','4','641','','','','','2022-07-23 08:49:19','2022-07-23 08:49:19');
INSERT INTO transactions VALUES('457','1','2022-07-23','1','income','','495','Student','15250.00','cr','2','108','1','641','','','','','2022-07-24 08:43:05','2022-07-24 08:43:05');
INSERT INTO transactions VALUES('458','1','2022-07-24','1','income','','494','Student','14000.00','cr','2','107','4','641','','','','','2022-07-24 08:45:06','2022-07-24 08:45:06');
INSERT INTO transactions VALUES('459','1','2022-07-23','1','income','','488','Student','7500.00','cr','2','103','4','641','','','','','2022-07-27 10:51:54','2022-07-27 10:51:54');
INSERT INTO transactions VALUES('460','1','2022-07-27','1','income','','427','Student','10000.00','cr','2','63','4','641','','','','','2022-07-28 06:29:26','2022-07-28 06:29:26');
INSERT INTO transactions VALUES('461','1','2022-08-01','1','income','','550','Student','17500.00','cr','2','106','4','641','','','','','2022-08-02 10:09:11','2022-08-02 10:09:11');
INSERT INTO transactions VALUES('462','1','2022-08-01','1','income','','526','Student','20000.00','cr','2','79','4','641','','','','','2022-08-02 10:10:00','2022-08-02 10:10:00');
INSERT INTO transactions VALUES('463','1','2022-08-01','1','income','','525','Student','17500.00','cr','2','77','4','641','','','','','2022-08-02 10:10:38','2022-08-02 10:10:38');
INSERT INTO transactions VALUES('464','1','2022-08-01','1','income','','503','Student','18500.00','cr','2','21','4','641','','','','','2022-08-02 10:11:51','2022-08-02 10:11:51');
INSERT INTO transactions VALUES('465','1','2022-08-02','1','income','','539','Student','20000.00','cr','2','98','4','641','','','','','2022-08-02 10:12:19','2022-08-02 10:12:19');
INSERT INTO transactions VALUES('466','1','2022-08-01','1','income','','552','Student','35000.00','cr','2','109','4','641','','','','','2022-08-03 06:07:12','2022-08-03 06:07:12');
INSERT INTO transactions VALUES('467','1','2022-08-02','1','income','','515','Student','18000.00','cr','2','63','4','641','','','','','2022-08-03 06:08:26','2022-08-03 06:08:26');
INSERT INTO transactions VALUES('468','1','2022-08-02','1','income','','507','Student','19000.00','cr','2','42','4','641','','','','','2022-08-03 06:09:23','2022-08-03 06:09:23');
INSERT INTO transactions VALUES('469','1','2022-08-02','1','income','','510','Student','19000.00','cr','2','46','4','641','','','','','2022-08-03 06:10:19','2022-08-03 06:10:19');
INSERT INTO transactions VALUES('470','1','2022-08-04','1','income','','554','Student','17500.00','cr','2','86','4','641','','','','','2022-08-04 18:36:17','2022-08-04 18:36:17');
INSERT INTO transactions VALUES('471','1','2022-08-04','1','income','','508','Student','17500.00','cr','2','43','4','641','','','','','2022-08-04 18:37:14','2022-08-04 18:37:14');
INSERT INTO transactions VALUES('472','1','2022-08-04','1','income','','542','Student','17500.00','cr','2','101','4','641','','','','','2022-08-04 18:45:08','2022-08-04 18:45:08');
INSERT INTO transactions VALUES('473','1','2022-08-04','1','income','','527','Student','17000.00','cr','2','81','4','641','','','','','2022-08-04 18:45:58','2022-08-04 18:45:58');
INSERT INTO transactions VALUES('474','1','2022-08-04','1','income','','529','Student','17000.00','cr','2','85','4','641','','','','','2022-08-04 18:46:41','2022-08-04 18:46:41');
INSERT INTO transactions VALUES('475','1','2022-08-04','1','income','','523','Student','17500.00','cr','2','74','4','641','','','','','2022-08-04 18:47:35','2022-08-04 18:47:35');
INSERT INTO transactions VALUES('476','1','2022-08-04','1','income','','524','Student','17500.00','cr','2','75','4','641','','','','','2022-08-04 18:48:30','2022-08-04 18:48:30');
INSERT INTO transactions VALUES('477','1','2022-08-04','1','income','','546','Student','17500.00','cr','2','105','4','641','','','','','2022-08-04 18:49:45','2022-08-04 18:49:45');
INSERT INTO transactions VALUES('478','1','2022-08-04','1','income','','538','Student','17500.00','cr','2','97','4','641','','','','','2022-08-04 18:50:30','2022-08-04 18:50:30');
INSERT INTO transactions VALUES('479','1','2022-08-06','1','income','','504','Student','17000.00','cr','2','25','4','641','','','','','2022-08-06 16:36:46','2022-08-06 16:36:46');
INSERT INTO transactions VALUES('480','1','2022-08-06','1','income','','555','Student','35000.00','cr','2','110','4','641','','','','','2022-08-06 16:44:49','2022-08-06 16:44:49');
INSERT INTO transactions VALUES('481','1','2022-08-06','1','income','','551','Student','20000.00','cr','2','83','1','641','','','','','2022-08-06 16:45:45','2022-08-06 16:45:45');
INSERT INTO transactions VALUES('482','1','2022-08-06','1','income','','544','Student','17500.00','cr','2','103','4','641','','','','','2022-08-06 16:47:45','2022-08-06 16:47:45');
INSERT INTO transactions VALUES('483','1','2022-08-05','1','income','','511','Student','17000.00','cr','2','49','4','641','','','','','2022-08-06 16:48:42','2022-08-06 16:48:42');
INSERT INTO transactions VALUES('484','1','2022-08-05','1','income','','535','Student','17500.00','cr','2','94','4','641','','','','','2022-08-06 16:49:36','2022-08-06 16:49:36');
INSERT INTO transactions VALUES('485','1','2022-08-05','1','income','','541','Student','20000.00','cr','2','100','4','641','','','','','2022-08-06 16:50:22','2022-08-06 16:50:22');
INSERT INTO transactions VALUES('486','1','2022-08-05','1','income','','514','Student','17500.00','cr','2','58','4','641','','','','','2022-08-06 16:51:40','2022-08-06 16:51:40');
INSERT INTO transactions VALUES('487','1','2022-08-05','1','income','','536','Student','22000.00','cr','2','95','4','641','','','','','2022-08-06 16:52:12','2022-08-06 16:52:12');
INSERT INTO transactions VALUES('488','1','2022-08-05','2','income','','537','Student','22000.00','cr','2','96','1','641','','','','','2022-08-06 16:52:46','2022-08-06 16:52:46');
INSERT INTO transactions VALUES('489','1','2022-08-05','1','income','','522','Student','17500.00','cr','2','73','4','641','','','','','2022-08-06 16:53:41','2022-08-06 16:53:41');
INSERT INTO transactions VALUES('490','1','2022-08-05','1','income','','497','Student','18500.00','cr','2','7','4','641','','','','','2022-08-06 16:55:25','2022-08-06 16:55:25');
INSERT INTO transactions VALUES('491','1','2022-08-06','1','income','','533','Student','20000.00','cr','2','91','4','641','','','','','2022-08-07 06:55:36','2022-08-07 06:55:36');
INSERT INTO transactions VALUES('492','1','2022-08-06','1','income','','457','Student','5000.00','cr','2','65','1','641','','','','','2022-08-07 06:56:44','2022-08-07 06:56:44');
INSERT INTO transactions VALUES('493','1','2022-08-06','1','income','','516','Student','18500.00','cr','2','65','4','641','','','','','2022-08-07 06:57:10','2022-08-07 06:57:10');
INSERT INTO transactions VALUES('494','1','2022-08-06','1','income','','494','Student','2500.00','cr','2','107','4','641','','','','','2022-08-07 06:58:07','2022-08-07 06:58:07');
INSERT INTO transactions VALUES('495','1','2022-08-06','1','income','','548','Student','17500.00','cr','2','107','4','641','','','','','2022-08-07 06:58:49','2022-08-07 06:58:49');
INSERT INTO transactions VALUES('496','1','2022-08-06','1','income','','487','Student','9000.00','cr','2','102','4','641','','','','','2022-08-07 07:03:34','2022-08-07 07:03:34');
INSERT INTO transactions VALUES('497','1','2022-08-06','1','income','','543','Student','18500.00','cr','2','102','4','641','','','','','2022-08-07 07:04:08','2022-08-07 07:04:08');
INSERT INTO transactions VALUES('498','1','2022-08-06','1','income','','421','Student','13000.00','cr','2','87','4','641','','','','','2022-08-07 07:14:43','2022-08-07 07:14:43');
INSERT INTO transactions VALUES('499','1','2022-08-06','1','income','','531','Student','17000.00','cr','2','87','4','641','','','','','2022-08-07 07:15:47','2022-08-07 07:15:47');
INSERT INTO transactions VALUES('500','1','2022-08-05','1','income','','365','Student','5000.00','cr','2','81','4','641','','','','','2022-08-07 07:47:41','2022-08-07 07:47:41');
INSERT INTO transactions VALUES('501','1','2022-08-07','1','income','','520','Student','9000.00','cr','2','69','4','641','','','','','2022-08-07 07:51:23','2022-08-07 07:51:23');
INSERT INTO transactions VALUES('502','1','2022-08-07','1','income','','545','Student','17000.00','cr','2','104','4','641','','','','','2022-08-07 07:56:18','2022-08-07 07:56:18');
INSERT INTO transactions VALUES('503','1','2022-08-03','1','income','','532','Student','17500.00','cr','2','89','4','641','','','','','2022-08-07 08:10:05','2022-08-07 08:10:05');
INSERT INTO transactions VALUES('504','1','2022-08-07','1','income','','490','Student','6000.00','cr','2','104','4','641','','','','','2022-08-09 09:34:27','2022-08-09 09:34:27');
INSERT INTO transactions VALUES('505','1','2022-08-07','1','income','','517','Student','18500.00','cr','2','66','4','641','','','','','2022-08-09 09:35:00','2022-08-09 09:35:00');
INSERT INTO transactions VALUES('506','1','2022-08-07','1','income','','519','Student','20000.00','cr','2','68','4','641','','','','','2022-08-09 09:35:42','2022-08-09 09:35:42');
INSERT INTO transactions VALUES('507','1','2022-08-07','1','income','','501','Student','15000.00','cr','2','17','4','641','','','','','2022-08-09 09:36:36','2022-08-09 09:36:36');
INSERT INTO transactions VALUES('508','1','2022-08-07','1','income','','502','Student','15000.00','cr','2','18','4','641','','','','','2022-08-09 09:37:10','2022-08-09 09:37:10');
INSERT INTO transactions VALUES('509','1','2022-08-07','1','income','','499','Student','15000.00','cr','2','15','4','641','','','','','2022-08-09 09:37:49','2022-08-09 09:37:49');
INSERT INTO transactions VALUES('510','1','2022-08-11','1','income','','557','Student','30800.00','cr','2','111','4','641','','','','','2022-08-11 06:31:38','2022-08-11 06:31:38');
INSERT INTO transactions VALUES('511','1','2022-08-10','1','income','','540','Student','20000.00','cr','2','99','4','641','','','','','2022-08-11 06:32:03','2022-08-11 06:32:03');
INSERT INTO transactions VALUES('512','1','2022-08-10','1','income','','534','Student','20000.00','cr','2','92','4','641','','','','','2022-08-11 06:32:33','2022-08-11 06:32:33');
INSERT INTO transactions VALUES('513','1','2022-08-10','1','income','','506','Student','17500.00','cr','2','40','4','641','','','','','2022-08-11 06:33:01','2022-08-11 06:33:01');
INSERT INTO transactions VALUES('514','1','2022-08-11','1','income','','485','Student','5000.00','cr','2','100','4','641','','','','','2022-08-12 07:31:35','2022-08-12 07:31:35');
INSERT INTO transactions VALUES('515','1','2022-08-12','1','income','','521','Student','22000.00','cr','2','72','4','641','','','','','2022-08-13 06:44:51','2022-08-13 06:44:51');
INSERT INTO transactions VALUES('516','1','2022-08-11','1','income','','520','Student','9000.00','cr','2','69','4','641','','','','','2022-08-13 06:45:37','2022-08-13 06:45:37');
INSERT INTO transactions VALUES('517','1','2022-08-12','1','income','','509','Student','17500.00','cr','2','44','4','641','','','','','2022-08-13 06:53:39','2022-08-13 06:53:39');
INSERT INTO transactions VALUES('518','1','2022-08-11','1','income','','489','Student','17500.00','cr','2','89','4','641','','','','','2022-08-13 06:54:31','2022-08-13 06:54:31');
INSERT INTO transactions VALUES('519','1','2022-08-11','1','income','','551','Student','3000.00','cr','2','83','4','641','','','','','2022-08-13 07:07:30','2022-08-13 07:07:30');
INSERT INTO transactions VALUES('520','1','2022-08-11','1','income','','390','Student','3000.00','cr','2','51','4','641','','','','','2022-08-13 07:10:08','2022-08-13 07:10:08');
INSERT INTO transactions VALUES('521','1','2022-08-12','1','income','','513','Student','18000.00','cr','2','51','4','641','','','','','2022-08-13 07:10:37','2022-08-13 07:10:37');
INSERT INTO transactions VALUES('522','1','2022-08-11','1','income','','512','Student','18000.00','cr','2','50','4','641','','','','','2022-08-13 07:11:11','2022-08-13 07:11:11');
INSERT INTO transactions VALUES('523','1','2022-08-11','1','income','','496','Student','22500.00','cr','2','3','4','641','','','','','2022-08-13 07:11:56','2022-08-13 07:11:56');
INSERT INTO transactions VALUES('524','1','2022-08-11','1','income','','494','Student','5000.00','cr','2','107','4','641','','','','','2022-08-13 07:13:35','2022-08-13 07:13:35');
INSERT INTO transactions VALUES('525','1','2022-08-11','1','income','','505','Student','15000.00','cr','2','35','4','641','','','','','2022-08-13 07:14:16','2022-08-13 07:14:16');
INSERT INTO transactions VALUES('526','1','2022-08-05','1','income','','558','Student','2185.00','cr','2','42','4','641','','','','','2022-08-13 07:26:23','2022-08-13 07:26:23');
INSERT INTO transactions VALUES('527','1','2022-08-05','1','income','','559','Student','2185.00','cr','2','46','4','641','','','','','2022-08-13 07:26:52','2022-08-13 07:26:52');
INSERT INTO transactions VALUES('528','1','2022-08-05','1','income','','560','Student','2000.00','cr','2','111','4','641','','','','','2022-08-13 07:29:36','2022-08-13 07:29:36');
INSERT INTO transactions VALUES('529','1','2022-08-11','1','income','','518','Student','20000.00','cr','2','67','4','641','','','','','2022-08-14 19:32:51','2022-08-14 19:32:51');
INSERT INTO transactions VALUES('530','1','2022-08-15','1','income','','365','Student','12000.00','cr','2','81','4','641','','','','','2022-08-19 10:24:16','2022-08-19 10:24:16');
INSERT INTO transactions VALUES('531','1','2022-08-23','1','income','','457','Student','5000.00','cr','2','65','4','641','','','','','2022-08-24 06:43:23','2022-08-24 06:43:23');
INSERT INTO transactions VALUES('532','1','2022-08-26','1','income','','521','Student','3000.00','cr','3','72','4','641','','','','','2022-08-29 10:59:10','2022-08-29 10:59:10');
INSERT INTO transactions VALUES('533','1','2022-08-23','1','income','','561','Student','10000.00','cr','2','112','4','641','','','','','2022-09-02 10:29:03','2022-09-02 10:29:03');
INSERT INTO transactions VALUES('534','1','2022-08-20','1','income','','562','Student','10000.00','cr','2','92','4','641','','','','','2022-09-02 10:32:21','2022-09-02 10:32:21');
INSERT INTO transactions VALUES('535','1','2022-09-01','1','income','','644','Student','19000.00','cr','2','74','4','641','','','','','2022-09-03 18:57:47','2022-09-03 18:57:47');
INSERT INTO transactions VALUES('536','1','2022-09-05','1','income','','625','Student','18500.00','cr','2','21','4','641','','','','','2022-09-03 19:00:35','2022-09-03 19:00:35');
INSERT INTO transactions VALUES('537','1','2022-09-01','1','income','','650','Student','19000.00','cr','2','86','4','641','','','','','2022-09-03 19:03:07','2022-09-03 19:03:07');
INSERT INTO transactions VALUES('538','1','2022-09-01','1','income','','637','Student','18000.00','cr','2','1','4','641','641','','','','2022-09-03 19:03:48','2022-09-09 09:33:25');
INSERT INTO transactions VALUES('539','1','2022-09-02','1','income','','664','Student','19000.00','cr','2','104','4','641','','','','','2022-09-03 19:07:24','2022-09-03 19:07:24');
INSERT INTO transactions VALUES('540','1','2022-09-02','1','income','','671','Student','23000.00','cr','2','1','4','641','641','','','','2022-09-03 19:12:40','2022-09-09 09:38:08');
INSERT INTO transactions VALUES('541','1','2022-09-02','1','income','','671','Student','10000.00','cr','2','95','4','641','','','','','2022-09-03 19:13:17','2022-09-03 19:13:17');
INSERT INTO transactions VALUES('542','1','2022-09-02','1','income','','656','Student','23000.00','cr','2','1','4','641','641','','','','2022-09-03 19:14:14','2022-09-09 09:37:30');
INSERT INTO transactions VALUES('543','1','2022-09-03','1','income','','628','Student','19000.00','cr','2','40','4','641','','','','','2022-09-03 19:25:36','2022-09-03 19:25:36');
INSERT INTO transactions VALUES('544','1','2022-09-03','1','income','','645','Student','19000.00','cr','2','75','4','641','','','','','2022-09-03 19:36:59','2022-09-03 19:36:59');
INSERT INTO transactions VALUES('545','1','2022-09-03','1','income','','643','Student','19000.00','cr','2','73','1','641','','','','','2022-09-03 19:37:56','2022-09-03 19:37:56');
INSERT INTO transactions VALUES('546','1','2022-09-03','1','income','','630','Student','19000.00','cr','2','43','4','641','','','','','2022-09-03 19:38:35','2022-09-03 19:38:35');
INSERT INTO transactions VALUES('547','1','2022-09-03','1','income','','657','Student','19000.00','cr','2','97','4','641','','','','','2022-09-03 19:42:50','2022-09-03 19:42:50');
INSERT INTO transactions VALUES('548','1','2022-09-03','1','income','','646','Student','19000.00','cr','2','77','4','641','','','','','2022-09-03 19:44:19','2022-09-03 19:44:19');
INSERT INTO transactions VALUES('549','1','2022-09-03','1','income','','636','Student','19000.00','cr','2','58','1','641','','','','','2022-09-03 19:44:52','2022-09-03 19:44:52');
INSERT INTO transactions VALUES('550','1','2022-09-03','1','income','','621','Student','20000.00','cr','2','7','4','641','','','','','2022-09-03 19:46:20','2022-09-03 19:46:20');
INSERT INTO transactions VALUES('551','1','2022-09-04','1','income','','634','Student','9500.00','cr','2','50','4','641','','','','','2022-09-05 08:46:05','2022-09-05 08:46:05');
INSERT INTO transactions VALUES('552','1','2022-09-04','1','income','','662','Student','19000.00','cr','2','102','4','641','','','','','2022-09-05 08:48:20','2022-09-05 08:48:20');
INSERT INTO transactions VALUES('553','1','2022-09-05','1','income','','666','Student','19000.00','cr','2','106','4','641','','','','','2022-09-05 08:49:17','2022-09-05 08:49:17');
INSERT INTO transactions VALUES('554','1','2022-09-05','1','income','','620','Student','24000.00','cr','2','3','4','641','','','','','2022-09-05 08:50:10','2022-09-05 08:50:10');
INSERT INTO transactions VALUES('555','1','2022-09-05','1','income','','631','Student','19000.00','cr','2','44','4','641','','','','','2022-09-05 19:22:14','2022-09-05 19:22:14');
INSERT INTO transactions VALUES('556','1','2022-09-05','1','income','','665','Student','19000.00','cr','2','105','4','641','','','','','2022-09-05 19:23:45','2022-09-05 19:23:45');
INSERT INTO transactions VALUES('557','1','2022-09-05','1','income','','669','Student','19000.00','cr','2','110','4','641','','','','','2022-09-05 19:24:28','2022-09-05 19:24:28');
INSERT INTO transactions VALUES('558','1','2022-09-05','1','income','','667','Student','19000.00','cr','2','107','4','641','','','','','2022-09-05 20:49:43','2022-09-05 20:49:43');
INSERT INTO transactions VALUES('559','1','2022-09-05','1','income','','672','Student','43000.00','cr','2','113','4','641','','','','','2022-09-05 21:02:28','2022-09-05 21:02:28');
INSERT INTO transactions VALUES('560','1','2022-09-05','2','income','','651','Student','16500.00','cr','2','87','1','641','','','','','2022-09-05 21:08:09','2022-09-05 21:08:09');
INSERT INTO transactions VALUES('561','1','2022-09-05','2','income','','627','Student','16500.00','cr','2','35','1','641','','','','','2022-09-05 21:08:46','2022-09-05 21:08:46');
INSERT INTO transactions VALUES('562','1','2022-09-05','1','income','','640','Student','21500.00','cr','2','67','1','641','','','','','2022-09-05 21:10:37','2022-09-05 21:10:37');
INSERT INTO transactions VALUES('563','1','2022-09-05','1','income','','675','Student','20000.00','cr','2','98','4','641','','','','','2022-09-07 08:21:03','2022-09-07 08:21:03');
INSERT INTO transactions VALUES('564','1','2022-09-06','2','income','','676','Student','26000.00','cr','2','72','1','641','','','','','2022-09-07 08:35:39','2022-09-07 08:35:39');
INSERT INTO transactions VALUES('565','1','2022-09-06','1','income','','639','Student','20000.00','cr','2','66','4','641','','','','','2022-09-07 08:36:17','2022-09-07 08:36:17');
INSERT INTO transactions VALUES('566','1','2022-09-06','1','income','','663','Student','19000.00','cr','2','103','4','641','','','','','2022-09-07 08:36:55','2022-09-07 08:36:55');
INSERT INTO transactions VALUES('567','1','2022-09-06','1','income','','673','Student','40000.00','cr','2','114','4','641','','','','','2022-09-07 08:37:34','2022-09-07 08:37:34');
INSERT INTO transactions VALUES('568','1','2022-09-06','1','income','','674','Student','40000.00','cr','2','115','4','641','','','','','2022-09-07 08:38:15','2022-09-07 08:38:15');
INSERT INTO transactions VALUES('569','1','2022-09-06','2','income','','641','Student','21500.00','cr','2','68','1','641','','','','','2022-09-07 08:38:42','2022-09-07 08:38:42');
INSERT INTO transactions VALUES('570','1','2022-09-06','1','income','','622','Student','16500.00','cr','2','15','1','641','','','','','2022-09-07 08:39:10','2022-09-07 08:39:10');
INSERT INTO transactions VALUES('571','1','2022-09-06','1','income','','623','Student','16500.00','cr','2','17','1','641','','','','','2022-09-07 08:39:34','2022-09-07 08:39:34');
INSERT INTO transactions VALUES('572','1','2022-09-06','1','income','','624','Student','16500.00','cr','2','18','1','641','','','','','2022-09-07 08:39:55','2022-09-07 08:39:55');
INSERT INTO transactions VALUES('573','1','2022-09-06','1','income','','649','Student','18000.00','cr','2','85','1','641','','','','','2022-09-07 08:41:51','2022-09-07 08:41:51');
INSERT INTO transactions VALUES('574','1','2022-09-06','1','income','','647','Student','18500.00','cr','2','81','4','641','','','','','2022-09-07 08:42:42','2022-09-07 08:42:42');
INSERT INTO transactions VALUES('575','1','2022-09-06','2','income','','626','Student','19000.00','cr','2','25','1','641','','','','','2022-09-07 08:46:00','2022-09-07 08:46:00');
INSERT INTO transactions VALUES('576','1','2022-09-06','1','income','','633','Student','17000.00','cr','2','49','1','641','','','','','2022-09-07 08:46:34','2022-09-07 08:46:34');
INSERT INTO transactions VALUES('577','1','2022-09-06','1','income','','654','Student','19000.00','cr','2','94','4','641','','','','','2022-09-07 08:47:02','2022-09-07 08:47:02');
INSERT INTO transactions VALUES('578','1','2022-09-06','1','income','','670','Student','19000.00','cr','2','111','1','641','','','','','2022-09-07 08:47:55','2022-09-07 08:47:55');
INSERT INTO transactions VALUES('579','1','2022-09-06','2','income','','648','Student','21500.00','cr','2','83','1','641','','','','','2022-09-07 08:49:04','2022-09-07 08:49:04');
INSERT INTO transactions VALUES('580','1','2022-09-06','2','income','','652','Student','21500.00','cr','2','91','1','641','','','','','2022-09-07 08:49:44','2022-09-07 08:49:44');
INSERT INTO transactions VALUES('581','1','2022-09-06','1','income','','660','Student','21500.00','cr','2','100','4','641','','','','','2022-09-07 08:50:46','2022-09-07 08:50:46');
INSERT INTO transactions VALUES('582','1','2022-09-06','1','income','','677','Student','23000.00','cr','2','42','1','641','','','','','2022-09-07 09:11:06','2022-09-07 09:11:06');
INSERT INTO transactions VALUES('583','1','2022-09-06','1','income','','678','Student','23000.00','cr','2','46','1','641','','','','','2022-09-07 09:11:31','2022-09-07 09:11:31');
INSERT INTO transactions VALUES('584','1','2022-09-07','1','income','','659','Student','21500.00','cr','2','99','1','641','','','','','2022-09-08 19:01:16','2022-09-08 19:01:16');
INSERT INTO transactions VALUES('585','1','2022-09-08','1','income','','668','Student','18000.00','cr','2','109','1','641','','','','','2022-09-08 19:01:49','2022-09-08 19:01:49');
INSERT INTO transactions VALUES('586','1','2022-09-09','1','income','','634','Student','10000.00','cr','2','50','1','641','','','','','2022-09-10 07:58:00','2022-09-10 07:58:00');
INSERT INTO transactions VALUES('587','1','2022-09-09','1','income','','635','Student','15000.00','cr','2','51','1','641','','','','','2022-09-10 07:58:31','2022-09-10 07:58:31');
INSERT INTO transactions VALUES('588','1','2022-09-05','1','income','','679','Student','12000.00','cr','2','117','1','641','','','','','2022-09-10 08:49:49','2022-09-10 08:49:49');
INSERT INTO transactions VALUES('589','1','2022-09-12','1','income','','661','Student','19000.00','cr','2','101','4','641','','','','','2022-09-12 06:24:49','2022-09-12 06:24:49');
INSERT INTO transactions VALUES('590','1','2022-09-15','1','income','','638','Student','10000.00','cr','2','65','4','641','','','','','2022-09-20 07:01:58','2022-09-20 07:01:58');
INSERT INTO transactions VALUES('591','1','2022-09-15','1','income','','635','Student','4500.00','cr','2','51','4','641','','','','','2022-09-20 07:02:59','2022-09-20 07:02:59');
INSERT INTO transactions VALUES('592','1','2022-09-06','1','income','','653','Student','21500.00','cr','2','92','4','641','','','','','2022-09-22 05:56:04','2022-09-22 05:56:04');
INSERT INTO transactions VALUES('593','1','2022-09-12','1','income','','638','Student','10000.00','cr','2','65','4','641','','','','','2022-09-22 05:57:06','2022-09-22 05:57:06');
INSERT INTO transactions VALUES('594','1','2022-09-24','1','income','','427','Student','5000.00','cr','2','63','4','641','','','','','2022-09-24 12:56:57','2022-09-24 12:56:57');
INSERT INTO transactions VALUES('595','1','2022-09-23','1','income','','649','Student','700.00','cr','2','85','4','641','','','','','2022-09-24 12:58:02','2022-09-24 12:58:02');
INSERT INTO transactions VALUES('596','1','2022-09-22','1','income','','633','Student','2000.00','cr','2','49','4','641','','','','','2022-09-24 12:59:44','2022-09-24 12:59:44');
INSERT INTO transactions VALUES('597','1','2022-09-05','1','income','','737','Student','15000.00','cr','2','116','1','641','','','','','2022-10-05 07:07:30','2022-10-05 07:07:30');
INSERT INTO transactions VALUES('598','1','2022-09-05','1','income','','738','Student','15000.00','cr','2','118','1','641','','','','','2022-10-05 07:07:51','2022-10-05 07:07:51');
INSERT INTO transactions VALUES('599','1','2022-09-05','1','income','','671','Student','1000.00','cr','2','95','1','641','','','','','2022-10-05 07:32:44','2022-10-05 07:32:44');
INSERT INTO transactions VALUES('600','1','2022-10-05','1','income','','741','Student','23000.00','cr','2','95','4','641','','','','','2022-10-05 07:40:15','2022-10-05 07:40:15');
INSERT INTO transactions VALUES('601','1','2022-10-01','1','income','','742','Student','23000.00','cr','2','96','4','641','','','','','2022-10-05 07:41:02','2022-10-05 07:41:02');
INSERT INTO transactions VALUES('602','1','2022-10-01','1','income','','710','Student','19000.00','cr','2','86','1','641','','','','','2022-10-05 07:41:43','2022-10-05 07:41:43');
INSERT INTO transactions VALUES('603','1','2022-10-01','1','income','','718','Student','20000.00','cr','2','98','4','641','','','','','2022-10-05 07:42:26','2022-10-05 07:42:26');
INSERT INTO transactions VALUES('604','1','2022-10-01','1','income','','743','Student','10000.00','cr','2','69','4','641','','','','','2022-10-05 07:51:57','2022-10-05 07:51:57');
INSERT INTO transactions VALUES('605','1','2022-10-02','1','income','','694','Student','8500.00','cr','2','50','4','641','','','','','2022-10-05 07:52:53','2022-10-05 07:52:53');
INSERT INTO transactions VALUES('606','1','2022-10-03','1','income','','733','Student','20000.00','cr','2','115','4','641','','','','','2022-10-05 07:54:35','2022-10-05 07:54:35');
INSERT INTO transactions VALUES('607','1','2022-10-03','1','income','','717','Student','19000.00','cr','2','97','4','641','','','','','2022-10-05 07:55:09','2022-10-05 07:55:09');
INSERT INTO transactions VALUES('608','1','2022-10-03','1','income','','686','Student','19000.00','cr','2','25','4','641','','','','','2022-10-05 07:56:01','2022-10-05 07:56:01');
INSERT INTO transactions VALUES('609','1','2022-10-03','1','income','','704','Student','19000.00','cr','2','74','4','641','','','','','2022-10-05 07:56:29','2022-10-05 07:56:29');
INSERT INTO transactions VALUES('610','1','2022-10-03','1','income','','722','Student','19000.00','cr','2','102','4','641','','','','','2022-10-05 07:57:45','2022-10-05 07:57:45');
INSERT INTO transactions VALUES('611','1','2022-10-04','1','income','','703','Student','19000.00','cr','2','73','4','641','','','','','2022-10-05 07:59:20','2022-10-05 07:59:20');
INSERT INTO transactions VALUES('612','1','2022-10-04','1','income','','706','Student','19000.00','cr','2','77','4','641','','','','','2022-10-05 07:59:49','2022-10-05 07:59:49');
INSERT INTO transactions VALUES('613','1','2022-10-04','1','income','','688','Student','19000.00','cr','2','40','4','641','','','','','2022-10-05 08:00:28','2022-10-05 08:00:28');
INSERT INTO transactions VALUES('614','1','2022-10-04','1','income','','690','Student','19000.00','cr','2','43','4','641','','','','','2022-10-05 08:01:04','2022-10-05 08:01:04');
INSERT INTO transactions VALUES('615','1','2022-10-04','1','income','','677','Student','2000.00','cr','2','42','1','641','','','','','2022-10-05 08:04:41','2022-10-05 08:04:41');
INSERT INTO transactions VALUES('616','1','2022-10-04','1','income','','678','Student','2000.00','cr','2','46','4','641','','','','','2022-10-05 08:05:07','2022-10-05 08:05:07');
INSERT INTO transactions VALUES('617','1','2022-10-04','1','income','','689','Student','21000.00','cr','2','42','4','641','','','','','2022-10-05 08:05:31','2022-10-05 08:05:31');
INSERT INTO transactions VALUES('618','1','2022-10-04','1','income','','692','Student','21000.00','cr','2','46','4','641','','','','','2022-10-05 08:05:53','2022-10-05 08:05:53');
INSERT INTO transactions VALUES('619','1','2022-10-04','1','income','','699','Student','20000.00','cr','2','66','4','641','','','','','2022-10-05 08:07:29','2022-10-05 08:07:29');
INSERT INTO transactions VALUES('620','1','2022-10-04','1','income','','696','Student','19000.00','cr','2','58','4','641','','','','','2022-10-05 08:07:53','2022-10-05 08:07:53');
INSERT INTO transactions VALUES('621','1','2022-10-04','1','income','','713','Student','21500.00','cr','2','92','4','641','','','','','2022-10-05 08:08:15','2022-10-05 08:08:15');
INSERT INTO transactions VALUES('622','1','2022-10-04','1','income','','721','Student','19000.00','cr','2','101','4','641','','','','','2022-10-05 08:08:51','2022-10-05 08:08:51');
INSERT INTO transactions VALUES('623','1','2022-10-05','1','income','','705','Student','19000.00','cr','2','75','1','641','','','','','2022-10-07 07:41:24','2022-10-07 07:41:24');
INSERT INTO transactions VALUES('624','1','2022-10-05','1','income','','727','Student','19000.00','cr','2','107','1','641','','','','','2022-10-07 07:41:58','2022-10-07 07:41:58');
INSERT INTO transactions VALUES('625','1','2022-10-05','1','income','','697','Student','19500.00','cr','2','63','1','641','','','','','2022-10-07 07:42:26','2022-10-07 07:42:26');
INSERT INTO transactions VALUES('626','1','2022-10-05','1','income','','746','Student','24500.00','cr','2','3','1','641','','','','','2022-10-07 07:46:03','2022-10-07 07:46:03');
INSERT INTO transactions VALUES('627','1','2022-10-05','1','income','','747','Student','18500.00','cr','2','104','1','641','','','','','2022-10-07 07:59:57','2022-10-07 07:59:57');
INSERT INTO transactions VALUES('628','1','2022-10-05','1','income','','731','Student','21500.00','cr','2','113','1','641','','','','','2022-10-07 08:00:18','2022-10-07 08:00:18');
INSERT INTO transactions VALUES('629','1','2022-10-06','1','income','','730','Student','19000.00','cr','2','111','1','641','','','','','2022-10-07 08:03:46','2022-10-07 08:03:46');
INSERT INTO transactions VALUES('630','1','2022-10-06','1','income','','700','Student','21500.00','cr','2','67','1','641','','','','','2022-10-07 08:04:12','2022-10-07 08:04:12');
INSERT INTO transactions VALUES('631','1','2022-10-06','1','income','','729','Student','19000.00','cr','2','110','1','641','','','','','2022-10-07 08:04:45','2022-10-07 08:04:45');
INSERT INTO transactions VALUES('632','1','2022-10-06','1','income','','725','Student','19000.00','cr','2','105','1','641','','','','','2022-10-07 08:05:22','2022-10-07 08:05:22');
INSERT INTO transactions VALUES('633','1','2022-10-06','2','income','','681','Student','20000.00','cr','2','7','1','641','','','','','2022-10-07 08:05:59','2022-10-07 08:05:59');
INSERT INTO transactions VALUES('634','1','2022-10-06','1','income','','693','Student','19000.00','cr','2','49','1','641','','','','','2022-10-07 08:06:23','2022-10-07 08:06:23');
INSERT INTO transactions VALUES('635','1','2022-10-06','1','income','','748','Student','18500.00','cr','2','81','1','641','','','','','2022-10-07 08:10:09','2022-10-07 08:10:09');
INSERT INTO transactions VALUES('636','1','2022-10-06','1','income','','720','Student','21500.00','cr','2','100','1','641','','','','','2022-10-07 08:10:50','2022-10-07 08:10:50');
INSERT INTO transactions VALUES('637','1','2022-10-06','1','income','','687','Student','16500.00','cr','2','35','1','641','','','','','2022-10-07 08:13:11','2022-10-07 08:13:11');
INSERT INTO transactions VALUES('638','1','2022-10-06','1','income','','714','Student','19000.00','cr','2','94','1','641','','','','','2022-10-07 08:14:04','2022-10-07 08:14:04');
INSERT INTO transactions VALUES('639','1','2022-10-06','1','income','','719','Student','21500.00','cr','2','99','1','641','','','','','2022-10-07 08:15:40','2022-10-07 08:15:40');
INSERT INTO transactions VALUES('640','1','2022-10-06','1','income','','683','Student','16500.00','cr','2','17','1','641','','','','','2022-10-07 08:16:36','2022-10-07 08:16:36');
INSERT INTO transactions VALUES('641','1','2022-10-06','1','income','','682','Student','16500.00','cr','2','15','1','641','','','','','2022-10-07 08:17:37','2022-10-07 08:17:37');
INSERT INTO transactions VALUES('642','1','2022-10-07','1','income','','749','Student','26000.00','cr','2','72','1','641','','','','','2022-10-07 08:20:00','2022-10-07 08:20:00');
INSERT INTO transactions VALUES('643','1','2022-10-07','1','income','','709','Student','18700.00','cr','2','85','1','641','','','','','2022-10-07 08:20:23','2022-10-07 08:20:23');
INSERT INTO transactions VALUES('644','1','2022-10-07','1','income','','701','Student','21500.00','cr','2','68','1','641','','','','','2022-10-08 07:00:09','2022-10-08 07:00:09');
INSERT INTO transactions VALUES('645','1','2022-10-07','1','income','','723','Student','19000.00','cr','2','103','1','641','','','','','2022-10-08 07:00:39','2022-10-08 07:00:39');
INSERT INTO transactions VALUES('646','1','2022-10-08','1','income','','712','Student','21500.00','cr','2','91','1','641','','','','','2022-10-08 07:01:19','2022-10-08 07:01:19');
INSERT INTO transactions VALUES('647','1','2022-10-08','1','income','','711','Student','16500.00','cr','2','87','1','641','','','','','2022-10-09 05:58:49','2022-10-09 05:58:49');
INSERT INTO transactions VALUES('648','1','2022-10-10','1','income','','684','Student','16500.00','cr','2','18','1','641','','','','','2022-10-13 09:30:09','2022-10-13 09:30:09');
INSERT INTO transactions VALUES('649','1','2022-10-10','1','income','','726','Student','19000.00','cr','2','106','1','641','','','','','2022-10-13 09:30:59','2022-10-13 09:30:59');
INSERT INTO transactions VALUES('650','1','2022-10-10','1','income','','691','Student','19000.00','cr','2','44','1','641','','','','','2022-10-13 09:31:28','2022-10-13 09:31:28');
INSERT INTO transactions VALUES('651','1','2022-10-10','1','income','','694','Student','11000.00','cr','2','50','1','641','','','','','2022-10-13 09:32:01','2022-10-13 09:32:01');
INSERT INTO transactions VALUES('652','1','2022-10-10','1','income','','695','Student','19500.00','cr','2','51','1','641','','','','','2022-10-13 09:32:37','2022-10-13 09:32:37');
INSERT INTO transactions VALUES('653','1','2022-10-10','1','income','','743','Student','21500.00','cr','2','69','1','641','','','','','2022-10-13 09:33:18','2022-10-13 09:33:18');
INSERT INTO transactions VALUES('654','1','2022-10-10','1','income','','625','Student','1000.00','cr','2','21','1','641','','','','','2022-10-13 09:33:53','2022-10-13 09:33:53');
INSERT INTO transactions VALUES('655','1','2022-10-11','1','income','','685','Student','19000.00','cr','2','21','1','641','','','','','2022-10-13 09:34:32','2022-10-13 09:34:32');
INSERT INTO transactions VALUES('656','1','2022-10-13','1','income','','668','Student','2000.00','cr','2','109','1','641','','','','','2022-10-16 13:24:26','2022-10-16 13:24:26');
INSERT INTO transactions VALUES('657','1','2022-10-13','1','income','','698','Student','20000.00','cr','2','65','1','641','','','','','2022-10-16 13:24:56','2022-10-16 13:24:56');
INSERT INTO transactions VALUES('658','1','2022-10-13','1','income','','732','Student','20000.00','cr','2','114','1','641','','','','','2022-10-16 13:25:29','2022-10-16 13:25:29');
INSERT INTO transactions VALUES('659','1','2022-10-14','1','income','','739','Student','15000.00','cr','2','116','1','641','','','','','2022-10-16 13:26:56','2022-10-16 13:26:56');
INSERT INTO transactions VALUES('660','1','2022-10-15','1','income','','735','Student','12000.00','cr','2','117','1','641','','','','','2022-10-16 13:27:36','2022-10-16 13:27:36');
INSERT INTO transactions VALUES('661','1','2022-10-15','1','income','','728','Student','5000.00','cr','2','109','1','641','','','','','2022-10-16 13:28:59','2022-10-16 13:28:59');
INSERT INTO transactions VALUES('662','1','2022-10-16','1','income','','743','Student','5000.00','cr','2','69','1','641','','','','','2022-10-17 12:19:37','2022-10-17 12:19:37');
INSERT INTO transactions VALUES('663','1','2022-10-30','1','income','','728','Student','8000.00','cr','2','109','4','641','','','','','2022-10-31 16:12:18','2022-10-31 16:12:18');
INSERT INTO transactions VALUES('664','1','2022-10-31','1','income','','740','Student','13000.00','cr','2','118','1','641','','','','','2022-10-31 16:13:14','2022-10-31 16:13:14');
INSERT INTO transactions VALUES('665','1','2022-09-05','1','income','','671','Student','0.00','cr','2','95','1','641','','','','','2022-11-01 07:11:34','2022-11-01 07:11:34');
INSERT INTO transactions VALUES('666','1','2022-11-01','1','income','','785','Student','23000.00','cr','2','95','4','641','','','','','2022-11-01 07:11:58','2022-11-01 07:11:58');
INSERT INTO transactions VALUES('667','1','2022-11-01','1','income','','685','Student','500.00','cr','2','21','1','641','','','','','2022-11-01 07:12:24','2022-11-01 07:12:24');
INSERT INTO transactions VALUES('668','1','2022-11-01','1','income','','755','Student','19500.00','cr','2','21','4','641','','','','','2022-11-01 07:13:12','2022-11-01 07:13:12');
INSERT INTO transactions VALUES('669','1','2022-11-01','1','income','','796','Student','19000.00','cr','2','106','4','641','','','','','2022-11-01 07:13:59','2022-11-01 07:13:59');
INSERT INTO transactions VALUES('670','1','2022-11-01','1','income','','744','Student','1200.00','cr','2','42','1','641','','','','','2022-11-02 06:40:40','2022-11-02 06:40:40');
INSERT INTO transactions VALUES('671','1','2022-11-01','1','income','','759','Student','21000.00','cr','2','42','1','641','','','','','2022-11-02 06:41:06','2022-11-02 06:41:06');
INSERT INTO transactions VALUES('672','1','2022-11-01','1','income','','777','Student','19000.00','cr','2','77','4','641','','','','','2022-11-02 06:41:58','2022-11-02 06:41:58');
INSERT INTO transactions VALUES('673','1','2022-11-01','1','income','','758','Student','19000.00','cr','2','40','4','641','','','','','2022-11-02 06:42:35','2022-11-02 06:42:35');
INSERT INTO transactions VALUES('674','1','2022-11-01','1','income','','767','Student','19500.00','cr','2','63','4','641','','','','','2022-11-02 06:43:01','2022-11-02 06:43:01');
INSERT INTO transactions VALUES('675','1','2022-11-02','1','income','','745','Student','1200.00','cr','2','46','4','641','','','','','2022-11-02 16:35:53','2022-11-02 16:35:53');
INSERT INTO transactions VALUES('676','1','2022-11-02','1','income','','762','Student','21000.00','cr','2','46','4','641','','','','','2022-11-02 16:36:29','2022-11-02 16:36:29');
INSERT INTO transactions VALUES('677','1','2022-11-02','1','income','','760','Student','19000.00','cr','2','43','4','641','','','','','2022-11-02 16:36:55','2022-11-02 16:36:55');
INSERT INTO transactions VALUES('678','1','2022-11-02','1','income','','807','Student','18500.00','cr','2','81','4','641','','','','','2022-11-02 16:50:22','2022-11-02 16:50:22');
INSERT INTO transactions VALUES('679','1','2022-11-02','1','income','','775','Student','19000.00','cr','2','74','4','641','','','','','2022-11-02 16:51:04','2022-11-02 16:51:04');
INSERT INTO transactions VALUES('680','1','2022-11-02','1','income','','766','Student','19000.00','cr','2','58','4','641','','','','','2022-11-02 16:51:26','2022-11-02 16:51:26');
INSERT INTO transactions VALUES('681','1','2022-11-02','1','income','','780','Student','19000.00','cr','2','86','4','641','','','','','2022-11-02 16:51:47','2022-11-02 16:51:47');
INSERT INTO transactions VALUES('682','1','2022-11-02','1','income','','808','Student','36000.00','cr','2','119','1','641','','','','','2022-11-03 06:32:02','2022-11-03 06:32:02');
INSERT INTO transactions VALUES('683','1','2022-11-03','2','income','','809','Student','18700.00','cr','2','104','1','641','','','','','2022-11-04 13:01:53','2022-11-04 13:01:53');
INSERT INTO transactions VALUES('684','1','2022-11-03','2','income','','747','Student','200.00','cr','2','104','1','641','','','','','2022-11-04 13:02:32','2022-11-04 13:02:32');
INSERT INTO transactions VALUES('685','1','2022-11-03','2','income','','782','Student','21500.00','cr','2','91','1','641','','','','','2022-11-04 13:04:38','2022-11-04 13:04:38');
INSERT INTO transactions VALUES('686','1','2022-11-03','1','income','','786','Student','22000.00','cr','2','96','1','641','','','','','2022-11-06 14:32:32','2022-11-06 14:32:32');
INSERT INTO transactions VALUES('687','1','2022-11-04','2','income','','751','Student','20000.00','cr','2','7','1','641','','','','','2022-11-06 14:33:23','2022-11-06 14:33:23');
INSERT INTO transactions VALUES('688','1','2022-11-04','1','income','','797','Student','19000.00','cr','2','107','4','641','','','','','2022-11-06 14:33:55','2022-11-06 14:33:55');
INSERT INTO transactions VALUES('689','1','2022-11-04','2','income','','801','Student','21500.00','cr','2','113','1','641','','','','','2022-11-06 14:34:40','2022-11-06 14:34:40');
INSERT INTO transactions VALUES('690','1','2022-11-04','2','income','','800','Student','19000.00','cr','2','111','1','641','','','','','2022-11-06 14:35:25','2022-11-06 14:35:25');
INSERT INTO transactions VALUES('691','1','2022-11-04','1','income','','774','Student','19000.00','cr','2','73','1','641','','','','','2022-11-06 14:36:02','2022-11-06 14:36:02');
INSERT INTO transactions VALUES('692','1','2022-11-04','1','income','','810','Student','10000.00','cr','2','120','1','641','','','','','2022-11-06 14:52:06','2022-11-06 14:52:06');
INSERT INTO transactions VALUES('693','1','2022-11-04','1','income','','805','Student','12000.00','cr','2','117','1','641','','','','','2022-11-06 14:55:14','2022-11-06 14:55:14');
INSERT INTO transactions VALUES('694','1','2022-11-04','2','income','','803','Student','20000.00','cr','2','115','1','641','','','','','2022-11-06 14:55:40','2022-11-06 14:55:40');
INSERT INTO transactions VALUES('695','1','2022-11-04','2','income','','776','Student','19000.00','cr','2','75','1','641','','','','','2022-11-06 14:56:10','2022-11-06 14:56:10');
INSERT INTO transactions VALUES('696','1','2022-11-04','2','income','','787','Student','19000.00','cr','2','97','1','641','','','','','2022-11-06 14:56:44','2022-11-06 14:56:44');
INSERT INTO transactions VALUES('697','1','2022-11-05','1','income','','792','Student','19000.00','cr','2','102','1','641','','','','','2022-11-06 14:58:43','2022-11-06 14:58:43');
INSERT INTO transactions VALUES('698','1','2022-11-05','1','income','','793','Student','19000.00','cr','2','103','1','641','','','','','2022-11-06 15:19:25','2022-11-06 15:19:25');
INSERT INTO transactions VALUES('699','1','2022-11-05','1','income','','757','Student','16500.00','cr','2','35','1','641','','','','','2022-11-06 15:19:48','2022-11-06 15:19:48');
INSERT INTO transactions VALUES('700','1','2022-11-06','1','income','','790','Student','21500.00','cr','2','100','1','641','','','','','2022-11-06 15:20:10','2022-11-06 15:20:10');
INSERT INTO transactions VALUES('701','1','2022-11-06','1','income','','781','Student','16500.00','cr','2','87','1','641','','','','','2022-11-06 15:20:27','2022-11-06 15:20:27');
INSERT INTO transactions VALUES('702','1','2022-11-06','1','income','','753','Student','16500.00','cr','2','17','1','641','','','','','2022-11-06 15:20:46','2022-11-06 15:20:46');
INSERT INTO transactions VALUES('703','1','2022-11-06','1','income','','784','Student','19000.00','cr','2','94','1','641','','','','','2022-11-08 09:54:12','2022-11-08 09:54:12');
INSERT INTO transactions VALUES('704','1','2022-11-06','1','income','','675','Student','2000.00','cr','2','98','1','641','','','','','2022-11-08 09:55:02','2022-11-08 09:55:02');
INSERT INTO transactions VALUES('705','1','2022-11-06','1','income','','788','Student','20000.00','cr','2','98','1','641','','','','','2022-11-08 09:55:24','2022-11-08 09:55:24');
INSERT INTO transactions VALUES('706','1','2022-11-06','1','income','','752','Student','16500.00','cr','2','15','1','641','','','','','2022-11-08 09:55:54','2022-11-08 09:55:54');
INSERT INTO transactions VALUES('707','1','2022-11-06','1','income','','754','Student','16500.00','cr','2','18','1','641','','','','','2022-11-08 09:56:40','2022-11-08 09:56:40');
INSERT INTO transactions VALUES('708','1','2022-11-07','1','income','','799','Student','19000.00','cr','2','110','1','641','','','','','2022-11-08 09:57:12','2022-11-08 09:57:12');
INSERT INTO transactions VALUES('709','1','2022-11-07','1','income','','769','Student','20000.00','cr','2','66','1','641','','','','','2022-11-08 09:57:42','2022-11-08 09:57:42');
INSERT INTO transactions VALUES('710','1','2022-11-07','1','income','','791','Student','19000.00','cr','2','101','1','641','','','','','2022-11-08 09:59:08','2022-11-08 09:59:08');
INSERT INTO transactions VALUES('711','1','2022-11-07','1','income','','779','Student','18700.00','cr','2','85','1','641','','','','','2022-11-08 09:59:37','2022-11-08 09:59:37');
INSERT INTO transactions VALUES('712','1','2022-11-07','1','income','','783','Student','21500.00','cr','2','92','1','641','','','','','2022-11-08 10:00:32','2022-11-08 10:00:32');
INSERT INTO transactions VALUES('713','1','2022-11-07','1','income','','789','Student','21500.00','cr','2','99','1','641','','','','','2022-11-08 10:00:59','2022-11-08 10:00:59');
INSERT INTO transactions VALUES('714','1','2022-11-07','1','income','','795','Student','19000.00','cr','2','105','1','641','','','','','2022-11-08 10:01:50','2022-11-08 10:01:50');
INSERT INTO transactions VALUES('715','1','2022-11-08','1','income','','811','Student','26000.00','cr','2','72','1','641','','','','','2022-11-08 10:04:19','2022-11-08 10:04:19');
INSERT INTO transactions VALUES('716','1','2022-11-08','1','income','','750','Student','24000.00','cr','2','3','1','641','','','','','2022-11-08 12:23:24','2022-11-08 12:23:24');
INSERT INTO transactions VALUES('717','1','2022-11-08','1','income','','761','Student','19000.00','cr','2','44','1','641','','','','','2022-11-16 16:55:07','2022-11-16 16:55:07');
INSERT INTO transactions VALUES('718','1','2022-11-08','1','income','','813','Student','17500.00','cr','2','121','1','641','','','','','2022-11-16 16:55:42','2022-11-16 16:55:42');
INSERT INTO transactions VALUES('719','1','2022-11-10','1','income','','815','Student','18000.00','cr','2','122','1','641','','','','','2022-11-16 17:11:53','2022-11-16 17:11:53');
INSERT INTO transactions VALUES('720','1','2022-11-11','1','income','','802','Student','20000.00','cr','2','114','1','641','','','','','2022-11-16 17:14:38','2022-11-16 17:14:38');
INSERT INTO transactions VALUES('721','1','2022-11-11','1','income','','815','Student','20000.00','cr','2','122','1','641','','','','','2022-11-16 17:15:12','2022-11-16 17:15:12');
INSERT INTO transactions VALUES('722','1','2022-11-11','1','income','','816','Student','33500.00','cr','2','123','1','641','','','','','2022-11-16 17:26:54','2022-11-16 17:26:54');
INSERT INTO transactions VALUES('723','1','2022-11-11','1','income','','756','Student','19000.00','cr','2','25','1','641','','','','','2022-11-21 10:13:45','2022-11-21 10:13:45');
INSERT INTO transactions VALUES('724','1','2022-11-11','1','income','','764','Student','19500.00','cr','2','50','1','641','','','','','2022-11-21 10:14:15','2022-11-21 10:14:15');
INSERT INTO transactions VALUES('725','1','2022-11-11','1','income','','765','Student','19500.00','cr','2','51','1','641','','','','','2022-11-21 10:14:39','2022-11-21 10:14:39');
INSERT INTO transactions VALUES('726','1','2022-11-11','1','income','','772','Student','21500.00','cr','2','69','1','641','','','','','2022-11-21 10:15:09','2022-11-21 10:15:09');
INSERT INTO transactions VALUES('727','1','2022-11-12','1','income','','768','Student','20000.00','cr','2','65','1','641','','','','','2022-11-21 10:16:13','2022-11-21 10:16:13');
INSERT INTO transactions VALUES('728','1','2022-11-13','1','income','','728','Student','7000.00','cr','2','109','1','641','','','','','2022-11-21 10:18:21','2022-11-21 10:18:21');
INSERT INTO transactions VALUES('729','1','2022-11-13','1','income','','798','Student','6600.00','cr','2','109','1','641','','','','','2022-11-21 10:19:11','2022-11-21 10:19:11');
INSERT INTO transactions VALUES('730','1','2022-11-14','1','income','','810','Student','21500.00','cr','2','120','1','641','','','','','2022-11-21 10:21:26','2022-11-21 10:21:26');
INSERT INTO transactions VALUES('731','1','2022-11-26','1','income','','804','Student','15000.00','cr','2','116','1','641','','','','','2022-12-04 08:07:12','2022-12-04 08:07:12');
INSERT INTO transactions VALUES('732','1','2022-11-26','1','income','','806','Student','15000.00','cr','2','118','1','641','','','','','2022-12-04 08:07:39','2022-12-04 08:07:39');
INSERT INTO transactions VALUES('733','1','2022-11-05','1','income','','817','Student','20000.00','cr','2','124','4','641','','','','','2022-12-10 08:30:14','2022-12-10 08:30:14');
INSERT INTO transactions VALUES('734','1','2022-11-05','1','income','','818','Student','20000.00','cr','2','125','4','641','','','','','2022-12-10 08:30:57','2022-12-10 08:30:57');
INSERT INTO transactions VALUES('735','1','2022-12-01','1','income','','851','Student','22000.00','cr','2','95','1','641','','','','','2022-12-22 06:43:54','2022-12-22 06:43:54');
INSERT INTO transactions VALUES('736','1','2022-12-01','1','income','','843','Student','19000.00','cr','2','77','1','641','','','','','2022-12-22 06:44:15','2022-12-22 06:44:15');
INSERT INTO transactions VALUES('737','1','2022-12-01','1','income','','829','Student','21000.00','cr','2','42','1','641','','','','','2022-12-22 06:44:58','2022-12-22 06:44:58');
INSERT INTO transactions VALUES('738','1','2022-12-01','1','income','','832','Student','21000.00','cr','2','46','1','641','','','','','2022-12-22 06:45:33','2022-12-22 06:45:33');
INSERT INTO transactions VALUES('739','1','2022-12-01','1','income','','841','Student','19000.00','cr','2','74','1','641','','','','','2022-12-22 06:46:08','2022-12-22 06:46:08');
INSERT INTO transactions VALUES('740','1','2022-12-01','1','income','','826','Student','19000.00','cr','2','25','1','641','','','','','2022-12-22 06:46:46','2022-12-22 06:46:46');
INSERT INTO transactions VALUES('741','1','2022-12-02','1','income','','830','Student','19000.00','cr','2','43','1','641','','','','','2022-12-22 06:47:13','2022-12-22 06:47:13');
INSERT INTO transactions VALUES('742','1','2022-12-02','1','income','','846','Student','19000.00','cr','2','86','1','641','','','','','2022-12-22 06:47:35','2022-12-22 06:47:35');
INSERT INTO transactions VALUES('743','1','2022-12-02','1','income','','853','Student','9000.00','cr','2','97','1','641','','','','','2022-12-22 06:51:37','2022-12-22 06:51:37');
INSERT INTO transactions VALUES('744','1','2022-12-02','1','income','','825','Student','19500.00','cr','2','21','1','641','','','','','2022-12-22 06:52:04','2022-12-22 06:52:04');
INSERT INTO transactions VALUES('745','1','2022-12-03','2','income','','821','Student','20000.00','cr','2','7','1','641','','','','','2022-12-22 06:52:33','2022-12-22 06:52:33');
INSERT INTO transactions VALUES('746','1','2022-12-03','1','income','','833','Student','9500.00','cr','2','50','1','641','','','','','2022-12-22 06:53:04','2022-12-22 06:53:04');
INSERT INTO transactions VALUES('747','1','2022-12-03','1','income','','852','Student','20000.00','cr','2','96','1','641','','','','','2022-12-22 06:55:14','2022-12-22 06:55:14');
INSERT INTO transactions VALUES('748','1','2022-12-03','1','income','','861','Student','19000.00','cr','2','105','1','641','','','','','2022-12-22 06:56:03','2022-12-22 06:56:03');
INSERT INTO transactions VALUES('749','1','2022-12-03','1','income','','868','Student','20000.00','cr','2','115','1','641','','','','','2022-12-22 06:56:38','2022-12-22 06:56:38');
INSERT INTO transactions VALUES('750','1','2022-12-04','1','income','','842','Student','19000.00','cr','2','75','1','641','','','','','2022-12-22 06:57:36','2022-12-22 06:57:36');
INSERT INTO transactions VALUES('751','1','2022-12-04','1','income','','835','Student','19000.00','cr','2','58','1','641','','','','','2022-12-22 06:58:03','2022-12-22 06:58:03');
INSERT INTO transactions VALUES('752','1','2022-12-05','1','income','','840','Student','19000.00','cr','2','73','1','641','','','','','2022-12-22 06:58:33','2022-12-22 06:58:33');
INSERT INTO transactions VALUES('753','1','2022-12-05','1','income','','828','Student','19000.00','cr','2','40','1','641','','','','','2022-12-22 06:59:07','2022-12-22 06:59:07');
INSERT INTO transactions VALUES('754','1','2022-12-05','1','income','','870','Student','12000.00','cr','2','117','1','641','','','','','2022-12-22 07:00:35','2022-12-22 07:00:35');
INSERT INTO transactions VALUES('755','1','2022-12-05','2','income','','866','Student','21500.00','cr','2','113','1','641','','','','','2022-12-22 07:03:01','2022-12-22 07:03:01');
INSERT INTO transactions VALUES('756','1','2022-12-05','2','income','','838','Student','20000.00','cr','2','66','1','641','','','','','2022-12-22 07:03:59','2022-12-22 07:03:59');
INSERT INTO transactions VALUES('757','1','2022-12-05','1','income','','839','Student','26000.00','cr','2','72','1','641','','','','','2022-12-22 07:08:41','2022-12-22 07:08:41');
INSERT INTO transactions VALUES('758','1','2022-12-05','1','income','','864','Student','19000.00','cr','2','110','1','641','','','','','2022-12-22 07:09:19','2022-12-22 07:09:19');
INSERT INTO transactions VALUES('759','1','2022-12-05','1','income','','863','Student','19000.00','cr','2','107','1','641','','','','','2022-12-22 07:29:54','2022-12-22 07:29:54');
INSERT INTO transactions VALUES('760','1','2022-12-05','1','income','','877','Student','26000.00','cr','2','72','4','641','','','','','2022-12-28 16:20:24','2022-12-28 16:20:24');
INSERT INTO transactions VALUES('761','1','2022-12-05','1','income','','876','Student','20000.00','cr','2','123','1','641','','','','','2022-12-28 16:22:29','2022-12-28 16:22:29');
INSERT INTO transactions VALUES('762','1','2022-12-05','1','income','','865','Student','19000.00','cr','2','111','1','641','','','','','2022-12-28 16:23:10','2022-12-28 16:23:10');
INSERT INTO transactions VALUES('763','1','2022-12-06','1','income','','822','Student','15000.00','cr','2','15','1','641','','','','','2022-12-28 16:23:42','2022-12-28 16:23:42');
INSERT INTO transactions VALUES('764','1','2022-12-06','1','income','','874','Student','15000.00','cr','2','121','1','641','','','','','2022-12-28 16:24:46','2022-12-28 16:24:46');
INSERT INTO transactions VALUES('765','1','2022-12-06','1','income','','824','Student','15000.00','cr','2','18','1','641','','','','','2022-12-28 16:25:15','2022-12-28 16:25:15');
INSERT INTO transactions VALUES('766','1','2022-12-07','1','income','','878','Student','18500.00','cr','2','104','1','641','','','','','2022-12-28 16:28:41','2022-12-28 16:28:41');
INSERT INTO transactions VALUES('767','1','2022-12-07','1','income','','845','Student','18700.00','cr','2','85','1','641','','','','','2022-12-28 16:46:10','2022-12-28 16:46:10');
INSERT INTO transactions VALUES('768','1','2022-12-07','1','income','','831','Student','19000.00','cr','2','44','1','641','','','','','2022-12-28 16:46:56','2022-12-28 16:46:56');
INSERT INTO transactions VALUES('769','1','2022-12-07','1','income','','847','Student','15000.00','cr','2','87','1','641','','','','','2022-12-28 16:47:24','2022-12-28 16:47:24');
INSERT INTO transactions VALUES('770','1','2022-12-07','1','income','','827','Student','15000.00','cr','2','35','1','641','','','','','2022-12-28 16:48:30','2022-12-28 16:48:30');
INSERT INTO transactions VALUES('771','1','2022-12-08','1','income','','873','Student','18500.00','cr','2','120','1','641','','','','','2022-12-28 16:49:01','2022-12-28 16:49:01');
INSERT INTO transactions VALUES('772','1','2022-12-08','1','income','','819','Student','7000.00','cr','2','126','1','641','','','','','2022-12-28 16:50:03','2022-12-28 16:50:03');
INSERT INTO transactions VALUES('773','1','2022-12-08','1','income','','858','Student','19000.00','cr','2','102','1','641','','','','','2022-12-28 16:50:50','2022-12-28 16:50:50');
INSERT INTO transactions VALUES('774','1','2022-12-08','1','income','','862','Student','19000.00','cr','2','106','1','641','','','','','2022-12-28 16:51:27','2022-12-28 16:51:27');
INSERT INTO transactions VALUES('775','1','2022-12-08','1','income','','820','Student','24000.00','cr','2','3','1','641','','','','','2022-12-28 16:52:29','2022-12-28 16:52:29');
INSERT INTO transactions VALUES('776','1','2022-12-08','1','income','','815','Student','5000.00','cr','2','122','1','641','','','','','2022-12-28 16:53:14','2022-12-28 16:53:14');
INSERT INTO transactions VALUES('777','1','2022-12-08','1','income','','875','Student','21500.00','cr','2','122','1','641','','','','','2022-12-28 16:53:32','2022-12-28 16:53:32');
INSERT INTO transactions VALUES('778','1','2022-12-08','1','income','','859','Student','19000.00','cr','2','103','1','641','','','','','2022-12-28 16:54:56','2022-12-28 16:54:56');
INSERT INTO transactions VALUES('779','1','2022-12-08','1','income','','855','Student','21500.00','cr','2','99','1','641','','','','','2022-12-28 16:59:33','2022-12-28 16:59:33');
INSERT INTO transactions VALUES('780','1','2022-12-09','1','income','','836','Student','10000.00','cr','2','63','1','641','','','','','2022-12-28 17:04:44','2022-12-28 17:04:44');
INSERT INTO transactions VALUES('781','1','2022-12-09','1','income','','849','Student','21500.00','cr','2','92','1','641','','','','','2022-12-28 17:05:13','2022-12-28 17:05:13');
INSERT INTO transactions VALUES('782','1','2022-12-09','1','income','','856','Student','21500.00','cr','2','100','1','641','','','','','2022-12-28 17:09:51','2022-12-28 17:09:51');
INSERT INTO transactions VALUES('783','1','2022-12-09','1','income','','854','Student','22000.00','cr','2','98','1','641','','','','','2022-12-28 17:10:24','2022-12-28 17:10:24');
INSERT INTO transactions VALUES('784','1','2022-12-09','1','income','','837','Student','10000.00','cr','2','65','1','641','','','','','2022-12-28 17:11:01','2022-12-28 17:11:01');
INSERT INTO transactions VALUES('785','1','2022-12-09','1','income','','834','Student','19500.00','cr','2','51','1','641','','','','','2022-12-28 17:11:28','2022-12-28 17:11:28');
INSERT INTO transactions VALUES('786','1','2022-12-09','1','income','','853','Student','10000.00','cr','2','97','1','641','','','','','2022-12-28 17:12:24','2022-12-28 17:12:24');
INSERT INTO transactions VALUES('787','1','2022-12-09','1','income','','867','Student','20000.00','cr','2','114','1','641','','','','','2022-12-28 17:12:53','2022-12-28 17:12:53');
INSERT INTO transactions VALUES('788','1','2022-12-09','1','income','','850','Student','19000.00','cr','2','94','1','641','','','','','2022-12-28 17:13:28','2022-12-28 17:13:28');
INSERT INTO transactions VALUES('789','1','2022-12-09','1','income','','872','Student','19000.00','cr','2','119','1','641','','','','','2022-12-28 17:13:56','2022-12-28 17:13:56');
INSERT INTO transactions VALUES('790','1','2022-12-10','1','income','','836','Student','9500.00','cr','2','63','1','641','','','','','2022-12-28 17:14:36','2022-12-28 17:14:36');
INSERT INTO transactions VALUES('791','1','2022-12-10','1','income','','833','Student','10000.00','cr','2','50','1','641','','','','','2022-12-28 17:15:57','2022-12-28 17:15:57');
INSERT INTO transactions VALUES('792','1','2022-12-10','1','income','','848','Student','21500.00','cr','2','91','1','641','','','','','2022-12-28 17:17:41','2022-12-28 17:17:41');
INSERT INTO transactions VALUES('793','1','2022-12-10','1','income','','823','Student','15000.00','cr','2','17','1','641','','','','','2022-12-28 17:18:18','2022-12-28 17:18:18');
INSERT INTO transactions VALUES('794','1','2022-12-13','1','income','','844','Student','18500.00','cr','2','81','1','641','','','','','2022-12-28 17:18:46','2022-12-28 17:18:46');
INSERT INTO transactions VALUES('795','1','2022-12-13','1','income','','857','Student','19000.00','cr','2','101','1','641','','','','','2022-12-28 17:19:11','2022-12-28 17:19:11');
INSERT INTO transactions VALUES('796','1','2022-12-18','1','income','','837','Student','10000.00','cr','2','65','1','641','','','','','2022-12-28 17:19:42','2022-12-28 17:19:42');
INSERT INTO transactions VALUES('797','1','2022-12-19','1','income','','819','Student','20000.00','cr','2','126','1','641','','','','','2022-12-28 17:20:13','2022-12-28 17:20:13');
INSERT INTO transactions VALUES('798','1','2023-01-01','1','income','','910','Student','20000.00','cr','2','95','1','641','','','','','2023-01-06 10:09:45','2023-01-06 10:09:45');
INSERT INTO transactions VALUES('799','1','2023-01-01','1','income','','902','Student','19000.00','cr','2','77','1','641','','','','','2023-01-06 10:10:16','2023-01-06 10:10:16');
INSERT INTO transactions VALUES('800','1','2023-01-01','1','income','','900','Student','19000.00','cr','2','74','1','641','','','','','2023-01-06 10:10:42','2023-01-06 10:10:42');
INSERT INTO transactions VALUES('801','1','2023-01-01','1','income','','888','Student','21000.00','cr','2','42','1','641','','','','','2023-01-06 10:11:21','2023-01-06 10:11:21');
INSERT INTO transactions VALUES('802','1','2023-01-01','1','income','','891','Student','21000.00','cr','2','46','1','641','','','','','2023-01-06 10:11:42','2023-01-06 10:11:42');
INSERT INTO transactions VALUES('803','1','2023-01-01','1','income','','929','Student','12000.00','cr','2','117','1','641','','','','','2023-01-06 10:12:36','2023-01-06 10:12:36');
INSERT INTO transactions VALUES('804','1','2022-12-21','1','income','','871','Student','15000.00','cr','2','118','1','641','','','','','2023-01-06 10:13:17','2023-01-06 10:13:17');
INSERT INTO transactions VALUES('805','1','2022-12-21','1','income','','869','Student','13000.00','cr','2','116','1','641','','','','','2023-01-06 10:13:45','2023-01-06 10:13:45');
INSERT INTO transactions VALUES('806','1','2023-01-01','1','income','','884','Student','17000.00','cr','2','21','1','641','','','','','2023-01-06 10:14:22','2023-01-06 10:14:22');
INSERT INTO transactions VALUES('807','1','2023-01-01','1','income','','880','Student','20000.00','cr','2','7','1','641','','','','','2023-01-06 10:15:08','2023-01-06 10:15:08');
INSERT INTO transactions VALUES('808','1','2023-01-01','1','income','','819','Student','9000.00','cr','2','126','1','641','','','','','2023-01-06 10:22:57','2023-01-06 10:22:57');
INSERT INTO transactions VALUES('809','1','2023-01-03','1','income','','912','Student','19000.00','cr','2','97','1','641','','','','','2023-01-06 10:23:26','2023-01-06 10:23:26');
INSERT INTO transactions VALUES('810','1','2023-01-03','1','income','','905','Student','19000.00','cr','2','86','1','641','','','','','2023-01-06 10:23:58','2023-01-06 10:23:58');
INSERT INTO transactions VALUES('811','1','2023-01-04','1','income','','889','Student','19000.00','cr','2','43','1','641','','','','','2023-01-06 10:24:21','2023-01-06 10:24:21');
INSERT INTO transactions VALUES('812','1','2023-01-04','1','income','','899','Student','19000.00','cr','2','73','1','641','','','','','2023-01-06 10:24:51','2023-01-06 10:24:51');
INSERT INTO transactions VALUES('813','1','2023-01-04','1','income','','895','Student','19500.00','cr','2','63','1','641','','','','','2023-01-06 10:25:31','2023-01-06 10:25:31');
INSERT INTO transactions VALUES('814','1','2023-01-04','1','income','','922','Student','19000.00','cr','2','107','1','641','','','','','2023-01-06 10:26:33','2023-01-06 10:26:33');
INSERT INTO transactions VALUES('815','1','2023-01-04','1','income','','932','Student','21500.00','cr','2','120','1','641','','','','','2023-01-06 10:29:55','2023-01-06 10:29:55');
INSERT INTO transactions VALUES('816','1','2023-01-04','1','income','','873','Student','3000.00','cr','2','120','1','641','','','','','2023-01-06 10:30:47','2023-01-06 10:30:47');
INSERT INTO transactions VALUES('817','1','2023-01-04','1','income','','894','Student','19000.00','cr','2','58','1','641','','','','','2023-01-06 10:31:47','2023-01-06 10:31:47');
INSERT INTO transactions VALUES('818','1','2023-01-04','1','income','','911','Student','20000.00','cr','2','96','1','641','','','','','2023-01-06 10:32:37','2023-01-06 10:32:37');
INSERT INTO transactions VALUES('819','1','2023-01-04','1','income','','939','Student','37000.00','cr','2','127','1','641','','','','','2023-01-06 10:46:35','2023-01-06 10:46:35');
INSERT INTO transactions VALUES('820','1','2023-01-04','1','income','','897','Student','20000.00','cr','2','66','1','641','','','','','2023-01-06 10:47:32','2023-01-06 10:47:32');
INSERT INTO transactions VALUES('821','1','2023-01-05','1','income','','890','Student','19000.00','cr','2','44','1','641','','','','','2023-01-06 10:48:27','2023-01-06 10:48:27');
INSERT INTO transactions VALUES('822','1','2023-01-05','1','income','','916','Student','19000.00','cr','2','101','1','641','','','','','2023-01-06 10:48:56','2023-01-06 10:48:56');
INSERT INTO transactions VALUES('823','1','2023-01-05','1','income','','913','Student','20000.00','cr','2','98','1','641','','','','','2023-01-06 10:49:27','2023-01-06 10:49:27');
INSERT INTO transactions VALUES('824','1','2023-01-05','1','income','','892','Student','5500.00','cr','2','50','1','641','','','','','2023-01-06 10:49:55','2023-01-06 10:49:55');
INSERT INTO transactions VALUES('825','1','2023-01-06','1','income','','882','Student','15000.00','cr','2','17','1','641','','','','','2023-01-06 10:50:14','2023-01-06 10:50:14');
INSERT INTO transactions VALUES('826','1','2023-01-06','1','income','','881','Student','15000.00','cr','2','15','1','641','','','','','2023-01-06 10:50:37','2023-01-06 10:50:37');
INSERT INTO transactions VALUES('827','1','2023-01-06','2','income','','927','Student','20000.00','cr','2','115','1','641','','','','','2023-01-06 10:51:06','2023-01-06 10:51:06');
INSERT INTO transactions VALUES('828','1','2023-01-06','1','income','','923','Student','19000.00','cr','2','110','1','641','','','','','2023-01-06 16:25:05','2023-01-06 16:25:05');
INSERT INTO transactions VALUES('829','1','2023-01-07','1','income','','909','Student','19000.00','cr','2','94','1','641','','','','','2023-01-07 06:28:44','2023-01-07 06:28:44');
INSERT INTO transactions VALUES('830','1','2023-01-07','1','income','','931','Student','19000.00','cr','2','119','1','641','','','','','2023-01-07 16:10:47','2023-01-07 16:10:47');
INSERT INTO transactions VALUES('831','1','2023-01-07','1','income','','935','Student','20000.00','cr','2','123','1','641','','','','','2023-01-07 16:12:34','2023-01-07 16:12:34');
INSERT INTO transactions VALUES('832','1','2023-01-08','1','income','','819','Student','7000.00','cr','2','126','1','641','','','','','2023-01-09 14:29:54','2023-01-09 14:29:54');
INSERT INTO transactions VALUES('833','1','2023-01-08','1','income','','938','Student','16000.00','cr','2','126','4','641','','','','','2023-01-09 14:31:04','2023-01-09 14:31:04');
INSERT INTO transactions VALUES('834','1','2023-01-10','1','income','','915','Student','21500.00','cr','2','100','1','641','','','','','2023-01-09 19:02:26','2023-01-09 19:02:26');
INSERT INTO transactions VALUES('835','1','2023-01-10','1','income','','898','Student','26000.00','cr','2','72','1','641','','','','','2023-01-10 14:31:55','2023-01-10 14:31:55');
INSERT INTO transactions VALUES('836','1','2023-01-10','1','income','','908','Student','21500.00','cr','2','92','1','641','','','','','2023-01-10 17:43:47','2023-01-10 17:43:47');
INSERT INTO transactions VALUES('837','1','2023-01-10','1','income','','907','Student','21500.00','cr','2','91','1','641','','','','','2023-01-10 17:49:04','2023-01-10 17:49:04');
INSERT INTO transactions VALUES('838','1','2023-01-19','1','income','','896','Student','15000.00','cr','2','65','1','641','','','','','2023-01-20 11:42:17','2023-01-20 11:42:17');
INSERT INTO transactions VALUES('839','1','2023-01-07','1','income','','924','Student','19000.00','cr','2','111','1','641','','','','','2023-01-20 11:42:59','2023-01-20 11:42:59');
INSERT INTO transactions VALUES('840','1','2023-01-08','1','income','','883','Student','15000.00','cr','2','18','1','641','','','','','2023-01-20 11:43:57','2023-01-20 11:43:57');
INSERT INTO transactions VALUES('841','1','2023-01-09','1','income','','921','Student','19000.00','cr','2','106','1','641','','','','','2023-01-20 11:44:45','2023-01-20 11:44:45');
INSERT INTO transactions VALUES('842','1','2023-01-10','1','income','','892','Student','14000.00','cr','2','50','1','641','','','','','2023-01-20 11:46:05','2023-01-20 11:46:05');
INSERT INTO transactions VALUES('843','1','2023-01-11','1','income','','906','Student','15000.00','cr','2','87','1','641','','','','','2023-01-20 11:47:20','2023-01-20 11:47:20');
INSERT INTO transactions VALUES('844','1','2023-01-11','1','income','','914','Student','21500.00','cr','2','99','1','641','','','','','2023-01-20 11:48:03','2023-01-20 11:48:03');
INSERT INTO transactions VALUES('845','1','2023-01-11','1','income','','893','Student','19500.00','cr','2','51','1','641','','','','','2023-01-20 11:48:46','2023-01-20 11:48:46');
INSERT INTO transactions VALUES('846','1','2023-01-11','1','income','','904','Student','18700.00','cr','2','85','1','641','','','','','2023-01-20 11:49:25','2023-01-20 11:49:25');
INSERT INTO transactions VALUES('847','1','2023-01-11','1','income','','919','Student','18500.00','cr','2','104','1','641','','','','','2023-01-20 11:50:19','2023-01-20 11:50:19');
INSERT INTO transactions VALUES('848','1','2023-01-11','1','income','','903','Student','18500.00','cr','2','81','1','641','','','','','2023-01-20 11:51:08','2023-01-20 11:51:08');
INSERT INTO transactions VALUES('849','1','2023-01-11','1','income','','918','Student','19000.00','cr','2','103','1','641','','','','','2023-01-20 11:51:48','2023-01-20 11:51:48');
INSERT INTO transactions VALUES('850','1','2023-01-12','1','income','','901','Student','19000.00','cr','2','75','1','641','','','','','2023-01-24 14:16:33','2023-01-24 14:16:33');
INSERT INTO transactions VALUES('851','1','2023-01-14','1','income','','887','Student','19000.00','cr','2','40','1','641','','','','','2023-01-24 14:19:44','2023-01-24 14:19:44');
INSERT INTO transactions VALUES('852','1','2023-01-14','1','income','','940','Student','10000.00','cr','2','124','1','641','','','','','2023-01-24 14:20:29','2023-01-24 14:20:29');
INSERT INTO transactions VALUES('853','1','2023-01-16','1','income','','879','Student','24000.00','cr','2','3','1','641','','','','','2023-01-24 14:21:17','2023-01-24 14:21:17');
INSERT INTO transactions VALUES('854','1','2023-01-14','1','income','','941','Student','10000.00','cr','2','125','1','641','','','','','2023-01-24 14:55:47','2023-01-24 14:55:47');
INSERT INTO transactions VALUES('855','1','2023-01-19','1','income','','928','Student','15000.00','cr','2','116','1','641','','','','','2023-01-24 14:56:30','2023-01-24 14:56:30');
INSERT INTO transactions VALUES('856','1','2023-01-19','1','income','','930','Student','15000.00','cr','2','118','1','641','','','','','2023-01-24 14:56:58','2023-01-24 14:56:58');
INSERT INTO transactions VALUES('857','1','2023-01-19','1','income','','926','Student','17000.00','cr','2','114','1','641','','','','','2023-01-24 14:57:31','2023-01-24 14:57:31');
INSERT INTO transactions VALUES('858','1','2023-01-04','1','income','','886','Student','15000.00','cr','2','35','1','641','','','','','2023-01-24 15:10:05','2023-01-24 15:10:05');
INSERT INTO transactions VALUES('859','1','2023-01-06','1','income','','933','Student','15000.00','cr','2','121','1','641','','','','','2023-01-24 15:12:13','2023-01-24 15:12:13');
INSERT INTO transactions VALUES('860','1','2023-01-07','1','income','','934','Student','21500.00','cr','2','122','1','641','','','','','2023-01-24 15:17:11','2023-01-24 15:17:11');
INSERT INTO transactions VALUES('861','1','2023-01-06','1','income','','920','Student','19000.00','cr','2','105','1','641','','','','','2023-01-26 15:01:06','2023-01-26 15:01:06');
INSERT INTO transactions VALUES('862','1','2023-01-07','1','income','','925','Student','21500.00','cr','2','113','4','641','','','','','2023-01-26 15:08:28','2023-01-26 15:08:28');
INSERT INTO transactions VALUES('863','1','2023-01-12','1','income','','913','Student','2000.00','cr','2','98','1','641','','','','','2023-01-26 15:09:20','2023-01-26 15:09:20');
INSERT INTO transactions VALUES('864','1','2023-02-01','1','income','','991','Student','12000.00','cr','2','117','1','641','','','','','2023-02-03 11:55:26','2023-02-03 11:55:26');
INSERT INTO transactions VALUES('865','1','2023-02-01','1','income','','972','Student','23000.00','cr','2','95','4','641','','','','','2023-02-03 11:56:04','2023-02-03 11:56:04');
INSERT INTO transactions VALUES('866','1','2023-02-01','1','income','','964','Student','19000.00','cr','2','77','4','641','','','','','2023-02-03 11:57:08','2023-02-03 11:57:08');
INSERT INTO transactions VALUES('867','1','2023-02-01','1','income','','967','Student','19000.00','cr','2','86','1','641','','','','','2023-02-03 11:57:53','2023-02-03 11:57:53');
INSERT INTO transactions VALUES('868','1','2023-02-01','1','income','','957','Student','10000.00','cr','2','63','1','641','','','','','2023-02-03 11:58:49','2023-02-03 11:58:49');
INSERT INTO transactions VALUES('869','1','2023-02-01','1','income','','884','Student','2500.00','cr','2','21','1','641','','','','','2023-02-03 11:59:44','2023-02-03 11:59:44');
INSERT INTO transactions VALUES('870','1','2023-02-01','1','income','','947','Student','19500.00','cr','2','21','1','641','','','','','2023-02-03 12:00:21','2023-02-03 12:00:21');
INSERT INTO transactions VALUES('871','1','2023-02-01','1','income','','961','Student','19000.00','cr','2','73','1','641','','','','','2023-02-03 12:04:40','2023-02-03 12:04:40');
INSERT INTO transactions VALUES('872','1','2023-02-01','1','income','','949','Student','19000.00','cr','2','40','1','641','','','','','2023-02-03 12:05:20','2023-02-03 12:05:20');
INSERT INTO transactions VALUES('873','1','2023-02-01','1','income','','926','Student','3000.00','cr','2','114','1','641','','','','','2023-02-03 12:05:53','2023-02-03 12:05:53');
INSERT INTO transactions VALUES('874','1','2023-02-01','1','income','','988','Student','20000.00','cr','2','114','1','641','','','','','2023-02-03 12:06:21','2023-02-03 12:06:21');
INSERT INTO transactions VALUES('875','1','2023-02-01','1','income','','965','Student','18500.00','cr','2','81','1','641','','','','','2023-02-03 12:07:10','2023-02-03 12:07:10');
INSERT INTO transactions VALUES('876','1','2023-02-01','1','income','','962','Student','15000.00','cr','2','74','1','641','','','','','2023-02-03 12:08:02','2023-02-03 12:08:02');
INSERT INTO transactions VALUES('877','1','2023-02-01','1','income','','984','Student','19000.00','cr','2','107','1','641','','','','','2023-02-03 12:08:48','2023-02-03 12:08:48');
INSERT INTO transactions VALUES('878','1','2023-02-02','1','income','','943','Student','20000.00','cr','2','7','1','641','','','','','2023-02-03 12:09:16','2023-02-03 12:09:16');
INSERT INTO transactions VALUES('879','1','2023-02-02','2','income','','989','Student','20000.00','cr','2','115','1','641','','','','','2023-02-03 12:10:46','2023-02-03 12:10:46');
INSERT INTO transactions VALUES('880','1','2023-02-03','1','income','','953','Student','21000.00','cr','2','46','4','641','','','','','2023-02-03 13:58:27','2023-02-03 13:58:27');
INSERT INTO transactions VALUES('881','1','2023-02-03','1','income','','950','Student','21000.00','cr','2','42','4','641','','','','','2023-02-03 14:00:25','2023-02-03 14:00:25');
INSERT INTO transactions VALUES('882','1','2023-02-09','1','income','','962','Student','4000.00','cr','2','74','1','641','','','','','2023-02-09 08:02:35','2023-02-09 08:02:35');
INSERT INTO transactions VALUES('883','1','2023-02-03','1','income','','951','Student','19000.00','cr','2','43','4','641','','','','','2023-02-09 10:12:46','2023-02-09 10:12:46');
INSERT INTO transactions VALUES('884','1','2023-02-03','1','income','','948','Student','15000.00','cr','2','35','4','641','','','','','2023-02-09 10:13:20','2023-02-09 10:13:20');
INSERT INTO transactions VALUES('885','1','2023-02-04','1','income','','982','Student','19000.00','cr','2','105','4','641','','','','','2023-02-09 10:14:01','2023-02-09 10:14:01');
INSERT INTO transactions VALUES('886','1','2023-02-04','1','income','','945','Student','15000.00','cr','2','17','4','641','','','','','2023-02-09 10:14:42','2023-02-09 10:14:42');
INSERT INTO transactions VALUES('887','1','2023-02-04','1','income','','973','Student','20000.00','cr','2','96','4','641','','','','','2023-02-09 10:15:41','2023-02-09 10:15:41');
INSERT INTO transactions VALUES('888','1','2023-02-04','1','income','','944','Student','15000.00','cr','2','15','4','641','','','','','2023-02-09 10:16:21','2023-02-09 10:16:21');
INSERT INTO transactions VALUES('889','1','2023-02-04','1','income','','956','Student','19000.00','cr','2','58','4','641','','','','','2023-02-09 10:17:00','2023-02-09 10:17:00');
INSERT INTO transactions VALUES('890','1','2023-02-05','1','income','','995','Student','15000.00','cr','2','121','1','641','','','','','2023-02-09 10:17:57','2023-02-09 10:17:57');
INSERT INTO transactions VALUES('891','1','2023-02-05','1','income','','974','Student','10000.00','cr','2','97','4','641','','','','','2023-02-09 10:19:01','2023-02-09 10:19:01');
INSERT INTO transactions VALUES('892','1','2023-02-06','1','income','','959','Student','20000.00','cr','2','66','4','641','','','','','2023-02-09 10:19:47','2023-02-09 10:19:47');
INSERT INTO transactions VALUES('893','1','2023-02-06','1','income','','983','Student','19000.00','cr','2','106','4','641','','','','','2023-02-09 10:20:27','2023-02-09 10:20:27');
INSERT INTO transactions VALUES('894','1','2023-02-06','1','income','','987','Student','21500.00','cr','2','113','1','641','','','','','2023-02-09 10:20:57','2023-02-09 10:20:57');
INSERT INTO transactions VALUES('895','1','2023-01-19','1','income','','917','Student','19000.00','cr','2','102','4','641','','','','','2023-02-09 10:30:26','2023-02-09 10:30:26');
INSERT INTO transactions VALUES('896','1','2023-02-06','1','income','','979','Student','19000.00','cr','2','102','4','641','','','','','2023-02-09 10:31:34','2023-02-09 10:31:34');
INSERT INTO transactions VALUES('897','1','2023-02-06','1','income','','946','Student','15000.00','cr','2','18','4','641','','','','','2023-02-09 12:10:55','2023-02-09 12:10:55');
INSERT INTO transactions VALUES('898','1','2023-02-06','1','income','','968','Student','15000.00','cr','2','87','4','641','','','','','2023-02-09 12:11:32','2023-02-09 12:11:32');
INSERT INTO transactions VALUES('899','1','2023-02-06','1','income','','977','Student','20000.00','cr','2','100','4','641','','','','','2023-02-09 12:12:23','2023-02-09 12:12:23');
INSERT INTO transactions VALUES('900','1','2023-02-06','1','income','','1000','Student','21500.00','cr','2','126','4','641','','','','','2023-02-09 12:13:24','2023-02-09 12:13:24');
INSERT INTO transactions VALUES('901','1','2023-02-06','1','income','','980','Student','19000.00','cr','2','103','4','641','','','','','2023-02-09 12:13:58','2023-02-09 12:13:58');
INSERT INTO transactions VALUES('902','1','2023-02-06','1','income','','981','Student','18500.00','cr','2','104','4','641','','','','','2023-02-09 12:14:34','2023-02-09 12:14:34');
INSERT INTO transactions VALUES('903','1','2023-02-07','1','income','','969','Student','21500.00','cr','2','91','4','641','','','','','2023-02-09 12:15:06','2023-02-09 12:15:06');
INSERT INTO transactions VALUES('904','1','2023-02-07','1','income','','986','Student','19000.00','cr','2','111','4','641','','','','','2023-02-09 12:15:46','2023-02-09 12:15:46');
INSERT INTO transactions VALUES('905','1','2023-02-07','1','income','','957','Student','9500.00','cr','2','63','4','641','','','','','2023-02-09 12:16:20','2023-02-09 12:16:20');
INSERT INTO transactions VALUES('906','1','2023-02-07','1','income','','942','Student','24000.00','cr','2','3','4','641','','','','','2023-02-09 12:17:34','2023-02-09 12:17:34');
INSERT INTO transactions VALUES('907','1','2023-02-07','1','income','','960','Student','26000.00','cr','2','72','4','641','','','','','2023-02-09 12:18:39','2023-02-09 12:18:39');
INSERT INTO transactions VALUES('908','1','2023-02-07','1','income','','966','Student','12000.00','cr','2','85','4','641','','','','','2023-02-09 12:19:24','2023-02-09 12:19:24');
INSERT INTO transactions VALUES('909','1','2023-02-07','1','income','','1002','Student','28000.00','cr','2','128','4','641','','','','','2023-02-09 12:20:00','2023-02-09 12:20:00');
INSERT INTO transactions VALUES('910','1','2023-02-08','1','income','','971','Student','19000.00','cr','2','94','4','641','','','','','2023-02-09 12:20:59','2023-02-09 12:20:59');
INSERT INTO transactions VALUES('911','1','2023-02-08','1','income','','1003','Student','17000.00','cr','2','124','4','641','','','','','2023-02-09 12:21:48','2023-02-09 12:21:48');
INSERT INTO transactions VALUES('912','1','2023-02-08','1','income','','1004','Student','18000.00','cr','2','125','4','641','','','','','2023-02-09 12:22:17','2023-02-09 12:22:17');
INSERT INTO transactions VALUES('913','1','2023-02-08','1','income','','1001','Student','19000.00','cr','2','127','4','641','','','','','2023-02-09 12:24:45','2023-02-09 12:24:45');
INSERT INTO transactions VALUES('914','1','2023-02-08','1','income','','985','Student','19000.00','cr','2','110','4','641','','','','','2023-02-09 12:25:33','2023-02-09 12:25:33');
INSERT INTO transactions VALUES('915','1','2023-02-08','1','income','','997','Student','10000.00','cr','2','123','4','641','','','','','2023-02-09 12:26:35','2023-02-09 12:26:35');
INSERT INTO transactions VALUES('916','1','2023-02-09','1','income','','975','Student','19000.00','cr','2','98','4','641','','','','','2023-02-09 12:27:28','2023-02-09 12:27:28');
INSERT INTO transactions VALUES('917','1','2023-02-09','1','income','','952','Student','19000.00','cr','2','44','4','641','','','','','2023-02-09 12:28:01','2023-02-09 12:28:01');
INSERT INTO transactions VALUES('918','1','2023-02-09','1','income','','993','Student','19000.00','cr','2','119','4','641','','','','','2023-02-09 12:28:45','2023-02-09 12:28:45');
INSERT INTO transactions VALUES('919','1','2023-02-10','1','income','','970','Student','21500.00','cr','2','92','4','641','','','','','2023-02-09 19:43:11','2023-02-09 19:43:11');
INSERT INTO transactions VALUES('920','1','2023-02-10','1','income','','994','Student','21500.00','cr','2','120','4','641','','','','','2023-03-07 18:30:35','2023-03-07 18:30:35');
INSERT INTO transactions VALUES('921','1','2023-02-10','1','income','','954','Student','19500.00','cr','3','50','4','641','','','','','2023-03-07 18:37:57','2023-03-07 18:37:57');
INSERT INTO transactions VALUES('922','1','2023-02-11','1','income','','974','Student','9000.00','cr','3','97','4','641','','','','','2023-03-07 18:38:55','2023-03-07 18:38:55');
INSERT INTO transactions VALUES('923','1','2023-02-11','1','income','','955','Student','19500.00','cr','3','51','4','641','','','','','2023-03-07 18:53:33','2023-03-07 18:53:33');
INSERT INTO transactions VALUES('924','1','2023-02-11','1','income','','958','Student','10000.00','cr','3','65','4','641','','','','','2023-03-07 18:54:44','2023-03-07 18:54:44');
INSERT INTO transactions VALUES('925','1','2023-02-12','1','income','','939','Student','1000.00','cr','2','127','4','641','','','','','2023-03-07 18:55:29','2023-03-07 18:55:29');
INSERT INTO transactions VALUES('926','1','2023-02-13','1','income','','966','Student','6700.00','cr','3','85','4','641','','','','','2023-03-07 18:56:50','2023-03-07 18:56:50');
INSERT INTO transactions VALUES('927','1','2023-02-14','1','income','','963','Student','19000.00','cr','3','75','4','641','','','','','2023-03-07 18:57:58','2023-03-07 18:57:58');
INSERT INTO transactions VALUES('928','1','2023-02-21','1','income','','740','Student','2000.00','cr','3','118','4','641','','','','','2023-03-07 18:58:53','2023-03-07 18:58:53');
INSERT INTO transactions VALUES('929','1','2023-02-21','1','income','','992','Student','15000.00','cr','3','118','4','641','','','','','2023-03-07 18:59:34','2023-03-07 18:59:34');
INSERT INTO transactions VALUES('990','1','2023-03-10','1','income','','1019','Student','19500.00','cr','2','50','4','641','','','','','2023-03-12 08:18:56','2023-03-12 08:18:56');
INSERT INTO transactions VALUES('931','1','2023-02-21','1','income','','990','Student','15000.00','cr','3','116','4','641','','','','','2023-03-07 19:01:22','2023-03-07 19:01:22');
INSERT INTO transactions VALUES('932','1','2023-02-13','1','income','','1006','Student','20000.00','cr','2','130','4','641','','','','','2023-03-07 19:05:02','2023-03-07 19:05:02');
INSERT INTO transactions VALUES('933','1','2023-02-13','1','income','','1005','Student','15000.00','cr','2','129','4','641','','','','','2023-03-07 19:06:27','2023-03-07 19:06:27');
INSERT INTO transactions VALUES('934','1','2023-03-01','1','income','','1008','Student','20000.00','cr','3','7','4','641','','','','','2023-03-07 19:17:38','2023-03-07 19:17:38');
INSERT INTO transactions VALUES('935','1','2023-03-01','1','income','','1037','Student','22000.00','cr','3','95','4','641','','','','','2023-03-08 11:00:13','2023-03-08 11:00:13');
INSERT INTO transactions VALUES('936','1','2023-03-01','1','income','','1032','Student','19000.00','cr','2','86','4','641','','','','','2023-03-08 13:05:34','2023-03-08 13:05:34');
INSERT INTO transactions VALUES('937','1','2023-03-01','1','income','','1021','Student','19000.00','cr','2','58','4','641','','','','','2023-03-08 13:06:21','2023-03-08 13:06:21');
INSERT INTO transactions VALUES('938','1','2023-03-01','1','income','','1012','Student','19500.00','cr','2','21','4','641','','','','','2023-03-08 13:11:50','2023-03-08 13:11:50');
INSERT INTO transactions VALUES('939','1','2023-03-01','1','income','','958','Student','10000.00','cr','2','65','4','641','','','','','2023-03-08 13:14:03','2023-03-08 13:14:03');
INSERT INTO transactions VALUES('940','1','2023-03-01','1','income','','1015','Student','21000.00','cr','2','42','4','641','','','','','2023-03-08 13:17:39','2023-03-08 13:17:39');
INSERT INTO transactions VALUES('941','1','2023-03-02','1','income','','1066','Student','19000.00','cr','2','127','4','641','','','','','2023-03-08 13:22:15','2023-03-08 13:22:15');
INSERT INTO transactions VALUES('942','1','2023-03-02','1','income','','1056','Student','12000.00','cr','2','117','4','641','','','','','2023-03-08 13:23:24','2023-03-08 13:23:24');
INSERT INTO transactions VALUES('943','1','2023-03-02','1','income','','1005','Student','5000.00','cr','2','129','4','641','','','','','2023-03-08 13:24:56','2023-03-08 13:24:56');
INSERT INTO transactions VALUES('944','1','2023-03-02','1','income','','1068','Student','21500.00','cr','2','129','4','641','','','','','2023-03-08 13:25:58','2023-03-08 13:25:58');
INSERT INTO transactions VALUES('945','1','2023-03-02','1','income','','1011','Student','15000.00','cr','2','18','4','641','','','','','2023-03-08 13:27:48','2023-03-08 13:27:48');
INSERT INTO transactions VALUES('946','1','2023-03-03','1','income','','1009','Student','15000.00','cr','2','15','4','641','','','','','2023-03-08 13:29:11','2023-03-08 13:29:11');
INSERT INTO transactions VALUES('947','1','2023-03-03','1','income','','1049','Student','19000.00','cr','2','107','4','641','','','','','2023-03-08 13:31:34','2023-03-08 13:31:34');
INSERT INTO transactions VALUES('948','1','2023-03-03','1','income','','1022','Student','19500.00','cr','2','63','4','641','','','','','2023-03-08 13:34:25','2023-03-08 13:34:25');
INSERT INTO transactions VALUES('949','1','2023-03-03','1','income','','1023','Student','20000.00','cr','2','65','4','641','','','','','2023-03-08 13:36:41','2023-03-08 13:36:41');
INSERT INTO transactions VALUES('950','1','2023-03-03','1','income','','1051','Student','19000.00','cr','2','111','4','641','','','','','2023-03-08 13:40:35','2023-03-08 13:40:35');
INSERT INTO transactions VALUES('951','1','2023-03-03','1','income','','1013','Student','15000.00','cr','2','35','4','641','','','','','2023-03-08 13:49:43','2023-03-08 13:49:43');
INSERT INTO transactions VALUES('952','1','2023-03-05','1','income','','1052','Student','21500.00','cr','2','113','4','641','','','','','2023-03-08 13:50:36','2023-03-08 13:50:36');
INSERT INTO transactions VALUES('953','1','2023-03-05','1','income','','786','Student','1000.00','cr','2','96','4','641','','','','','2023-03-08 13:52:49','2023-03-08 13:52:49');
INSERT INTO transactions VALUES('954','1','2023-03-05','1','income','','1033','Student','15000.00','cr','2','87','4','641','','','','','2023-03-08 13:53:36','2023-03-08 13:53:36');
INSERT INTO transactions VALUES('955','1','2023-03-05','1','income','','1062','Student','20000.00','cr','2','123','4','641','','','','','2023-03-08 13:55:27','2023-03-08 13:55:27');
INSERT INTO transactions VALUES('956','1','2023-03-06','1','income','','1027','Student','19000.00','cr','2','74','4','641','','','','','2023-03-09 07:04:05','2023-03-09 07:04:05');
INSERT INTO transactions VALUES('957','1','2023-03-06','1','income','','1010','Student','15000.00','cr','2','17','4','641','','','','','2023-03-09 07:04:58','2023-03-09 07:04:58');
INSERT INTO transactions VALUES('958','1','2023-03-06','1','income','','1034','Student','21500.00','cr','2','91','4','641','','','','','2023-03-09 07:05:42','2023-03-09 07:05:42');
INSERT INTO transactions VALUES('959','1','2023-03-06','1','income','','1035','Student','21500.00','cr','2','92','4','641','','','','','2023-03-09 07:06:24','2023-03-09 07:06:24');
INSERT INTO transactions VALUES('960','1','2023-03-06','1','income','','1046','Student','18500.00','cr','2','104','4','641','','','','','2023-03-09 07:07:19','2023-03-09 07:07:19');
INSERT INTO transactions VALUES('961','1','2023-03-07','1','income','','1014','Student','19000.00','cr','2','40','4','641','','','','','2023-03-09 07:10:55','2023-03-09 07:10:55');
INSERT INTO transactions VALUES('962','1','2023-03-08','1','income','','1039','Student','19000.00','cr','2','97','4','641','','','','','2023-03-09 07:11:44','2023-03-09 07:11:44');
INSERT INTO transactions VALUES('963','1','2023-03-08','1','income','','1045','Student','19000.00','cr','2','103','4','641','','','','','2023-03-09 07:12:38','2023-03-09 07:12:38');
INSERT INTO transactions VALUES('964','1','2023-03-08','1','income','','1016','Student','19000.00','cr','2','43','4','641','','','','','2023-03-09 07:17:26','2023-03-09 07:17:26');
INSERT INTO transactions VALUES('965','1','2023-03-08','1','income','','1060','Student','15000.00','cr','2','121','4','641','','','','','2023-03-09 07:18:14','2023-03-09 07:18:14');
INSERT INTO transactions VALUES('966','1','2023-03-08','1','income','','1041','Student','21500.00','cr','2','99','4','641','','','','','2023-03-09 07:19:35','2023-03-09 07:19:35');
INSERT INTO transactions VALUES('967','1','2023-03-08','1','income','','1040','Student','22000.00','cr','2','98','4','641','','','','','2023-03-09 07:20:46','2023-03-09 07:20:46');
INSERT INTO transactions VALUES('968','1','2023-02-13','1','income','','976','Student','21500.00','cr','2','99','4','641','','','','','2023-03-09 07:23:21','2023-03-09 07:23:21');
INSERT INTO transactions VALUES('969','1','2023-02-09','1','income','','975','Student','3000.00','cr','2','98','4','641','','','','','2023-03-09 07:26:09','2023-03-09 07:26:09');
INSERT INTO transactions VALUES('970','1','2023-02-08','1','income','','1003','Student','1000.00','cr','2','124','4','641','','','','','2023-03-09 07:27:27','2023-03-09 07:27:27');
INSERT INTO transactions VALUES('971','1','2023-03-08','1','income','','1063','Student','18000.00','cr','2','124','4','641','','','','','2023-03-09 07:28:12','2023-03-09 07:28:12');
INSERT INTO transactions VALUES('972','1','2023-03-08','1','income','','1067','Student','18000.00','cr','2','128','4','641','','','','','2023-03-09 07:29:32','2023-03-09 07:29:32');
INSERT INTO transactions VALUES('973','1','2023-03-08','1','income','','1007','Student','24000.00','cr','2','3','4','641','','','','','2023-03-09 07:30:31','2023-03-09 07:30:31');
INSERT INTO transactions VALUES('974','1','2023-03-08','1','income','','1028','Student','10000.00','cr','2','75','4','641','','','','','2023-03-09 07:32:27','2023-03-09 07:32:27');
INSERT INTO transactions VALUES('975','1','2023-03-08','1','income','','1017','Student','19000.00','cr','2','44','4','641','','','','','2023-03-09 07:33:10','2023-03-09 07:33:10');
INSERT INTO transactions VALUES('976','1','2023-03-08','1','income','','1047','Student','19000.00','cr','2','105','4','641','','','','','2023-03-09 07:34:07','2023-03-09 07:34:07');
INSERT INTO transactions VALUES('977','1','2023-03-08','1','income','','1036','Student','19000.00','cr','2','94','4','641','','','','','2023-03-09 07:34:52','2023-03-09 07:34:52');
INSERT INTO transactions VALUES('978','1','2023-03-08','1','income','','1065','Student','21500.00','cr','2','126','4','641','','','','','2023-03-09 07:35:28','2023-03-09 07:35:28');
INSERT INTO transactions VALUES('979','1','2023-03-08','1','income','','1048','Student','19000.00','cr','2','106','4','641','','','','','2023-03-09 08:25:44','2023-03-09 08:25:44');
INSERT INTO transactions VALUES('980','1','2023-03-08','1','income','','1064','Student','18000.00','cr','2','125','4','641','','','','','2023-03-09 08:27:58','2023-03-09 08:27:58');
INSERT INTO transactions VALUES('981','1','2023-03-08','1','income','','1044','Student','19000.00','cr','2','102','4','641','','','','','2023-03-09 09:57:19','2023-03-09 09:57:19');
INSERT INTO transactions VALUES('982','1','2023-03-08','1','income','','1061','Student','21500.00','cr','2','122','4','641','','','','','2023-03-09 09:59:52','2023-03-09 09:59:52');
INSERT INTO transactions VALUES('983','1','2023-03-08','1','income','','1025','Student','26000.00','cr','2','72','4','641','','','','','2023-03-09 10:01:46','2023-03-09 10:01:46');
INSERT INTO transactions VALUES('984','1','2023-03-08','1','income','','1058','Student','19000.00','cr','2','119','4','641','','','','','2023-03-09 10:06:22','2023-03-09 10:06:22');
INSERT INTO transactions VALUES('985','1','2023-03-08','1','income','','1043','Student','19000.00','cr','2','101','4','641','','','','','2023-03-09 10:09:51','2023-03-09 10:09:51');
INSERT INTO transactions VALUES('986','1','2023-03-08','1','income','','1050','Student','19000.00','cr','2','110','4','641','','','','','2023-03-09 10:10:42','2023-03-09 10:10:42');
INSERT INTO transactions VALUES('987','1','2023-03-08','1','income','','978','Student','19000.00','cr','2','101','4','641','','','','','2023-03-09 10:22:05','2023-03-09 10:22:05');
INSERT INTO transactions VALUES('988','1','2023-03-08','1','income','','977','Student','1500.00','cr','2','100','4','641','','','','','2023-03-09 10:27:12','2023-03-09 10:27:12');
INSERT INTO transactions VALUES('989','1','2023-03-08','1','income','','1042','Student','500.00','cr','2','100','4','641','','','','','2023-03-09 10:28:04','2023-03-09 10:28:04');
INSERT INTO transactions VALUES('991','1','2023-03-10','1','income','','1054','Student','20000.00','cr','2','115','4','641','','','','','2023-03-12 08:25:11','2023-03-12 08:25:11');
INSERT INTO transactions VALUES('992','1','2023-03-10','1','income','','1042','Student','21000.00','cr','2','100','4','641','','','','','2023-03-12 08:26:01','2023-03-12 08:26:01');
INSERT INTO transactions VALUES('993','1','2023-03-10','1','income','','1020','Student','10000.00','cr','2','51','4','641','','','','','2023-03-12 08:37:03','2023-03-12 08:37:03');
INSERT INTO transactions VALUES('994','1','2023-03-13','1','income','','1030','Student','18500.00','cr','2','81','4','641','','','','','2023-03-14 12:25:43','2023-03-14 12:25:43');
INSERT INTO transactions VALUES('995','1','2023-03-01','1','income','','1018','Student','21000.00','cr','2','46','4','641','','','','','2023-04-02 07:18:57','2023-04-02 07:18:57');
INSERT INTO transactions VALUES('996','1','2023-03-03','1','income','','1024','Student','20000.00','cr','2','66','4','641','','','','','2023-04-02 07:20:53','2023-04-02 07:20:53');
INSERT INTO transactions VALUES('997','1','2023-03-01','1','income','','1029','Student','19000.00','cr','2','77','4','641','','','','','2023-04-02 07:22:04','2023-04-02 07:22:04');
INSERT INTO transactions VALUES('998','1','2023-03-01','1','income','','1026','Student','19000.00','cr','2','73','4','641','','','','','2023-04-02 07:22:53','2023-04-02 07:22:53');
INSERT INTO transactions VALUES('999','1','2023-03-23','1','income','','1053','Student','10000.00','cr','2','114','4','641','','','','','2023-04-02 07:25:02','2023-04-02 07:25:02');
INSERT INTO transactions VALUES('1000','1','2023-03-05','1','income','','1038','Student','22000.00','cr','2','96','4','641','','','','','2023-04-02 07:26:05','2023-04-02 07:26:05');
INSERT INTO transactions VALUES('1001','1','2023-03-05','1','income','','1059','Student','21500.00','cr','2','120','4','641','','','','','2023-04-02 07:27:54','2023-04-02 07:27:54');
INSERT INTO transactions VALUES('1002','1','2023-03-18','1','income','','1133','Student','9350.00','cr','2','85','4','641','','','','','2023-04-02 08:10:29','2023-04-02 08:10:29');
INSERT INTO transactions VALUES('1003','1','2023-03-21','1','income','','1057','Student','15000.00','cr','2','118','4','641','','','','','2023-04-02 08:16:01','2023-04-02 08:16:01');
INSERT INTO transactions VALUES('1004','1','2023-03-15','1','income','','1055','Student','15000.00','cr','2','116','4','641','','','','','2023-04-02 08:29:21','2023-04-02 08:29:21');
INSERT INTO transactions VALUES('1005','1','2023-04-02','1','income','','1071','Student','20000.00','cr','2','7','4','641','','','','','2023-04-02 14:50:50','2023-04-02 14:50:50');
INSERT INTO transactions VALUES('1006','1','2023-04-01','1','income','','1075','Student','19500.00','cr','2','21','4','641','','','','','2023-04-02 15:11:06','2023-04-02 15:11:06');
INSERT INTO transactions VALUES('1007','1','2023-04-03','1','income','','1084','Student','19000.00','cr','2','58','4','641','','','','','2023-04-03 16:05:39','2023-04-03 16:05:39');
INSERT INTO transactions VALUES('1008','1','2023-04-03','1','income','','1092','Student','19000.00','cr','2','77','4','641','','','','','2023-04-03 16:08:41','2023-04-03 16:08:41');
INSERT INTO transactions VALUES('1009','1','2023-04-03','1','income','','1112','Student','19000.00','cr','2','107','4','641','','','','','2023-04-03 16:10:46','2023-04-03 16:10:46');
INSERT INTO transactions VALUES('1010','1','2023-04-04','1','income','','1097','Student','21500.00','cr','2','91','4','641','','','','','2023-04-04 08:43:55','2023-04-04 08:43:55');
INSERT INTO transactions VALUES('1011','1','2023-04-04','1','income','','1078','Student','21000.00','cr','2','42','4','641','','','','','2023-04-04 11:14:06','2023-04-04 11:14:06');
INSERT INTO transactions VALUES('1012','1','2023-04-04','1','income','','1079','Student','19000.00','cr','2','43','4','641','','','','','2023-04-04 17:01:52','2023-04-04 17:01:52');
INSERT INTO transactions VALUES('1013','1','2023-04-04','1','income','','1076','Student','15000.00','cr','2','35','4','641','','','','','2023-04-04 17:32:50','2023-04-04 17:32:50');
INSERT INTO transactions VALUES('1014','1','2023-04-04','2','income','','1088','Student','26000.00','cr','2','72','1','641','','','','','2023-04-04 17:34:56','2023-04-04 17:34:56');
INSERT INTO transactions VALUES('1015','1','2023-04-01','1','income','','1119','Student','12000.00','cr','2','117','4','641','','','','','2023-04-04 17:44:08','2023-04-04 17:44:08');
INSERT INTO transactions VALUES('1016','1','2023-04-01','2','income','','1101','Student','22000.00','cr','2','96','1','641','','','','','2023-04-04 17:48:45','2023-04-04 17:48:45');
INSERT INTO transactions VALUES('1017','1','2023-04-01','1','income','','1090','Student','19000.00','cr','2','74','4','641','','','','','2023-04-04 17:51:57','2023-04-04 17:51:57');
INSERT INTO transactions VALUES('1018','1','2023-04-01','1','income','','1053','Student','10000.00','cr','2','114','4','641','','','','','2023-04-04 17:54:10','2023-04-04 17:54:10');
INSERT INTO transactions VALUES('1019','1','2023-04-03','1','income','','1116','Student','20000.00','cr','2','114','4','641','','','','','2023-04-04 17:54:46','2023-04-04 17:54:46');
INSERT INTO transactions VALUES('1020','1','2023-04-05','1','income','','1096','Student','10000.00','cr','2','87','4','641','','','','','2023-04-05 14:05:27','2023-04-05 14:05:27');
INSERT INTO transactions VALUES('1021','1','2023-04-05','2','income','','1117','Student','20000.00','cr','2','115','1','641','','','','','2023-04-05 14:06:07','2023-04-05 14:06:07');
INSERT INTO transactions VALUES('1022','1','2023-04-05','1','income','','1102','Student','19000.00','cr','3','97','4','641','','','','','2023-04-05 14:07:09','2023-04-05 14:07:09');
INSERT INTO transactions VALUES('1023','1','2023-04-05','1','income','','1091','Student','19000.00','cr','2','75','4','641','','','','','2023-04-05 14:07:35','2023-04-05 14:07:35');
INSERT INTO transactions VALUES('1024','1','2023-04-05','1','income','','1081','Student','21000.00','cr','2','46','1','641','','','','','2023-04-05 14:08:00','2023-04-05 14:08:00');
INSERT INTO transactions VALUES('1025','1','2023-04-05','1','income','','1077','Student','19000.00','cr','2','40','4','641','','','','','2023-04-05 14:08:46','2023-04-05 14:08:46');
INSERT INTO transactions VALUES('1026','1','2023-04-05','1','income','','1080','Student','19000.00','cr','2','44','4','641','','','','','2023-04-05 14:09:20','2023-04-05 14:09:20');
INSERT INTO transactions VALUES('1027','1','2023-04-05','1','income','','1106','Student','19000.00','cr','2','101','4','641','','','','','2023-04-06 07:21:18','2023-04-06 07:21:18');
INSERT INTO transactions VALUES('1028','1','2023-04-05','1','income','','1122','Student','21500.00','cr','2','120','4','641','','','','','2023-04-06 07:21:48','2023-04-06 07:21:48');
INSERT INTO transactions VALUES('1029','1','2023-04-05','1','income','','1107','Student','19000.00','cr','2','102','4','641','','','','','2023-04-06 07:22:29','2023-04-06 07:22:29');
INSERT INTO transactions VALUES('1030','1','2023-04-06','1','income','','1113','Student','19000.00','cr','2','110','4','641','','','','','2023-04-06 12:07:27','2023-04-06 12:07:27');
INSERT INTO transactions VALUES('1031','1','2023-04-06','1','income','','1096','Student','5000.00','cr','2','87','4','641','','','','','2023-04-07 10:25:59','2023-04-07 10:25:59');
INSERT INTO transactions VALUES('1032','1','2023-04-05','1','income','','1110','Student','19000.00','cr','2','105','4','641','','','','','2023-04-07 10:26:31','2023-04-07 10:26:31');
INSERT INTO transactions VALUES('1033','1','2023-02-10','1','income','','996','Student','21500.00','cr','2','122','1','641','','','','','2023-04-07 10:30:21','2023-04-07 10:30:21');
INSERT INTO transactions VALUES('1034','1','2023-04-06','1','income','','1124','Student','21500.00','cr','2','122','4','641','','','','','2023-04-07 10:30:52','2023-04-07 10:30:52');
INSERT INTO transactions VALUES('1035','1','2023-04-06','1','income','','1123','Student','15000.00','cr','2','121','4','641','','','','','2023-04-07 10:31:30','2023-04-07 10:31:30');
INSERT INTO transactions VALUES('1036','1','2023-01-28','1','income','','896','Student','5000.00','cr','3','65','4','641','','','','','2023-04-07 11:17:47','2023-04-07 11:17:47');
INSERT INTO transactions VALUES('1037','1','2023-04-04','1','income','','1089','Student','18000.00','cr','3','73','4','641','','','','','2023-04-07 11:20:50','2023-04-07 11:20:50');
INSERT INTO transactions VALUES('1038','1','2023-03-15','1','income','','1028','Student','9000.00','cr','2','75','1','641','','','','','2023-04-07 11:22:13','2023-04-07 11:22:13');
INSERT INTO transactions VALUES('1039','1','2023-04-06','1','income','','1114','Student','19000.00','cr','3','111','4','641','','','','','2023-04-07 11:57:42','2023-04-07 11:57:42');
INSERT INTO transactions VALUES('1040','1','2022-05-28','1','income','','355','Student','0.00','cr','2','72','1','641','','','','','2023-04-07 12:12:52','2023-04-07 12:12:52');
INSERT INTO transactions VALUES('1041','1','2023-04-01','1','income','','1100','Student','22000.00','cr','3','95','4','641','','','','','2023-04-07 12:18:41','2023-04-07 12:18:41');
INSERT INTO transactions VALUES('1042','1','2023-03-13','1','income','','1020','Student','9500.00','cr','2','51','1','641','','','','','2023-04-07 12:30:10','2023-04-07 12:30:10');
INSERT INTO transactions VALUES('1043','1','2022-08-11','1','income','','290','Student','3000.00','cr','2','51','1','641','','','','','2023-04-07 12:34:04','2023-04-07 12:34:04');
INSERT INTO transactions VALUES('1044','1','2023-03-31','1','income','','1121','Student','19000.00','cr','2','119','4','641','','','','','2023-04-07 14:44:37','2023-04-07 14:44:37');
INSERT INTO transactions VALUES('1045','1','2023-04-07','1','income','','1099','Student','19000.00','cr','2','94','1','641','','','','','2023-04-07 14:45:01','2023-04-07 14:45:01');
INSERT INTO transactions VALUES('1046','1','2023-04-07','1','income','','1128','Student','21500.00','cr','3','126','4','641','','','','','2023-04-07 14:46:24','2023-04-07 14:46:24');
INSERT INTO transactions VALUES('1047','1','2023-04-05','1','income','','1135','Student','21500.00','cr','3','131','4','641','','','','','2023-04-07 15:22:27','2023-04-07 15:22:27');
INSERT INTO transactions VALUES('1048','1','2023-04-07','1','income','','1109','Student','18500.00','cr','3','104','4','641','','','','','2023-04-08 07:41:19','2023-04-08 07:41:19');
INSERT INTO transactions VALUES('1049','1','2023-04-07','1','income','','1115','Student','21500.00','cr','3','113','4','641','','','','','2023-04-08 07:42:25','2023-04-08 07:42:25');
INSERT INTO transactions VALUES('1050','1','2023-04-08','1','income','','1072','Student','15000.00','cr','2','15','4','641','','','','','2023-04-08 07:43:50','2023-04-08 07:43:50');
INSERT INTO transactions VALUES('1051','1','2023-04-08','1','income','','1073','Student','15000.00','cr','3','17','4','641','','','','','2023-04-08 07:44:49','2023-04-08 07:44:49');
INSERT INTO transactions VALUES('1052','1','2023-04-08','1','income','','1074','Student','15000.00','cr','3','18','4','641','','','','','2023-04-08 07:45:20','2023-04-08 07:45:20');
INSERT INTO transactions VALUES('1053','1','2023-04-09','1','income','','1137','Student','35700.00','cr','3','132','4','641','','','','','2023-04-09 11:20:42','2023-04-09 11:20:42');
INSERT INTO transactions VALUES('1054','1','2023-04-09','1','income','','1138','Student','39000.00','cr','3','133','4','641','','','','','2023-04-09 21:32:34','2023-04-09 21:32:34');
INSERT INTO transactions VALUES('1055','1','2023-04-08','1','income','','1131','Student','21500.00','cr','3','129','4','641','','','','','2023-04-09 21:33:05','2023-04-09 21:33:05');
INSERT INTO transactions VALUES('1056','1','2023-04-10','1','income','','1095','Student','19000.00','cr','2','86','4','641','','','','','2023-04-10 15:42:08','2023-04-10 15:42:08');
INSERT INTO transactions VALUES('1057','1','2023-04-10','1','income','','1105','Student','21500.00','cr','3','100','4','641','','','','','2023-04-11 00:07:51','2023-04-11 00:07:51');
INSERT INTO transactions VALUES('1058','1','2023-04-11','1','income','','1093','Student','18500.00','cr','2','81','4','641','','','','','2023-04-11 15:29:53','2023-04-11 15:29:53');
INSERT INTO transactions VALUES('1059','1','2023-04-11','1','income','','1082','Student','19500.00','cr','3','50','4','641','','','','','2023-04-12 18:16:49','2023-04-12 18:16:49');
INSERT INTO transactions VALUES('1060','1','2023-04-11','1','income','','1083','Student','19500.00','cr','3','51','4','641','','','','','2023-04-12 18:17:52','2023-04-12 18:17:52');
INSERT INTO transactions VALUES('1061','1','2023-04-11','1','income','','1085','Student','18500.00','cr','3','63','4','641','','','','','2023-04-12 18:18:28','2023-04-12 18:18:28');
INSERT INTO transactions VALUES('1062','1','2023-04-12','1','income','','1140','Student','20000.00','cr','3','128','4','641','','','','','2023-04-12 18:23:16','2023-04-12 18:23:16');
INSERT INTO transactions VALUES('1063','1','2023-04-12','1','income','','1086','Student','10000.00','cr','3','65','4','641','','','','','2023-04-12 18:24:17','2023-04-12 18:24:17');
INSERT INTO transactions VALUES('1064','1','2023-04-12','1','income','','1141','Student','24500.00','cr','3','3','4','641','','','','','2023-04-12 18:27:25','2023-04-12 18:27:25');
INSERT INTO transactions VALUES('1065','1','2023-04-11','1','income','','1111','Student','19000.00','cr','3','106','4','641','','','','','2023-04-12 18:28:13','2023-04-12 18:28:13');
INSERT INTO transactions VALUES('1066','1','2023-04-10','1','income','','1103','Student','20000.00','cr','3','98','4','641','','','','','2023-04-12 18:29:04','2023-04-12 18:29:04');
INSERT INTO transactions VALUES('1067','1','2023-04-10','1','income','','1108','Student','19000.00','cr','3','103','4','641','','','','','2023-04-12 18:30:00','2023-04-12 18:30:00');
INSERT INTO transactions VALUES('1068','1','2023-04-10','1','income','','1129','Student','19000.00','cr','3','127','4','641','','','','','2023-04-12 18:30:41','2023-04-12 18:30:41');
INSERT INTO transactions VALUES('1069','1','2023-04-08','1','income','','1087','Student','10000.00','cr','3','66','4','641','','','','','2023-04-12 18:31:38','2023-04-12 18:31:38');
INSERT INTO transactions VALUES('1070','1','2023-04-14','1','income','','1098','Student','19000.00','cr','3','92','4','641','','','','','2023-04-14 09:20:39','2023-04-14 09:20:39');
INSERT INTO transactions VALUES('1071','1','2023-04-16','1','income','','1104','Student','21500.00','cr','3','99','4','641','','','','','2023-04-16 14:47:08','2023-04-16 14:47:08');
INSERT INTO transactions VALUES('1072','1','2023-04-18','1','income','','1120','Student','15000.00','cr','3','118','4','641','','','','','2023-04-27 08:18:10','2023-04-27 08:18:10');
INSERT INTO transactions VALUES('1073','1','2023-04-13','1','income','','1118','Student','15000.00','cr','3','116','1','641','','','','','2023-04-27 08:19:13','2023-04-27 08:19:13');
INSERT INTO transactions VALUES('1074','1','2023-04-26','1','income','','1086','Student','10000.00','cr','3','65','4','641','','','','','2023-04-28 05:54:22','2023-04-28 05:54:22');
INSERT INTO transactions VALUES('1075','1','2023-04-13','1','income','','1087','Student','10000.00','cr','3','66','4','641','','','','','2023-04-28 05:55:46','2023-04-28 05:55:46');
INSERT INTO transactions VALUES('1076','1','2023-04-16','1','income','','1089','Student','1000.00','cr','3','73','4','641','','','','','2023-04-28 06:01:09','2023-04-28 06:01:09');
INSERT INTO transactions VALUES('1077','1','2023-04-16','1','income','','1139','Student','20000.00','cr','3','124','4','641','','','','','2023-04-28 06:02:41','2023-04-28 06:02:41');
INSERT INTO transactions VALUES('1078','1','2023-05-01','1','income','','1147','Student','19500.00','cr','3','21','4','641','','','','','2023-05-07 12:14:28','2023-05-07 12:14:28');
INSERT INTO transactions VALUES('1079','1','2023-05-01','1','income','','1171','Student','18000.00','cr','3','95','4','641','','','','','2023-05-07 12:16:32','2023-05-07 12:16:32');
INSERT INTO transactions VALUES('1080','1','2023-05-01','1','income','','1172','Student','20000.00','cr','3','96','4','641','','','','','2023-05-07 12:17:15','2023-05-07 12:17:15');
INSERT INTO transactions VALUES('1081','1','2023-05-07','1','income','','1143','Student','21000.00','cr','3','7','4','641','','','','','2023-05-07 17:28:03','2023-05-07 17:28:03');
INSERT INTO transactions VALUES('1082','1','2023-05-01','1','income','','1182','Student','19000.00','cr','3','106','4','641','','','','','2023-05-08 17:41:59','2023-05-08 17:41:59');
INSERT INTO transactions VALUES('1083','1','2023-05-08','1','income','','1178','Student','19000.00','cr','3','102','4','641','','','','','2023-05-08 17:44:23','2023-05-08 17:44:23');
INSERT INTO transactions VALUES('1084','1','2023-05-08','1','income','','1152','Student','19000.00','cr','3','44','4','641','','','','','2023-05-08 17:45:43','2023-05-08 17:45:43');
INSERT INTO transactions VALUES('1085','1','2023-05-08','1','income','','1181','Student','19000.00','cr','3','105','4','641','','','','','2023-05-08 17:46:04','2023-05-08 17:46:04');
INSERT INTO transactions VALUES('1086','1','2023-05-09','1','income','','1176','Student','21500.00','cr','3','100','4','641','','','','','2023-05-09 13:26:59','2023-05-09 13:26:59');
INSERT INTO transactions VALUES('1087','1','2023-05-01','1','income','','1164','Student','16000.00','cr','3','77','4','641','','','','','2023-05-11 09:44:18','2023-05-11 09:44:18');
INSERT INTO transactions VALUES('1088','1','2023-05-03','1','income','','1166','Student','19000.00','cr','3','86','4','641','','','','','2023-05-11 09:44:55','2023-05-11 09:44:55');
INSERT INTO transactions VALUES('1089','1','2023-05-03','1','income','','1149','Student','19000.00','cr','3','40','4','641','','','','','2023-05-11 09:45:22','2023-05-11 09:45:22');
INSERT INTO transactions VALUES('1090','1','2023-05-06','2','income','','1160','Student','26000.00','cr','3','72','1','641','','','','','2023-05-11 09:45:57','2023-05-11 09:45:57');
INSERT INTO transactions VALUES('1091','1','2023-05-03','1','income','','1144','Student','15000.00','cr','3','15','4','641','','','','','2023-05-11 09:48:30','2023-05-11 09:48:30');
INSERT INTO transactions VALUES('1092','1','2023-05-03','1','income','','1146','Student','15000.00','cr','3','18','4','641','','','','','2023-05-11 09:49:03','2023-05-11 09:49:03');
INSERT INTO transactions VALUES('1093','1','2023-05-04','1','income','','1145','Student','15000.00','cr','3','17','4','641','','','','','2023-05-11 09:52:42','2023-05-11 09:52:42');
INSERT INTO transactions VALUES('1094','1','2023-05-05','1','income','','1161','Student','17000.00','cr','3','73','4','641','','','','','2023-05-11 09:53:22','2023-05-11 09:53:22');
INSERT INTO transactions VALUES('1095','1','2023-05-05','1','income','','1156','Student','19000.00','cr','3','58','4','641','','','','','2023-05-11 09:54:37','2023-05-11 09:54:37');
INSERT INTO transactions VALUES('1096','1','2023-05-05','1','income','','1194','Student','15000.00','cr','3','121','4','641','','','','','2023-05-11 09:55:04','2023-05-11 09:55:04');
INSERT INTO transactions VALUES('1097','1','2023-05-05','1','income','','1162','Student','19000.00','cr','3','74','4','641','','','','','2023-05-11 09:56:06','2023-05-11 09:56:06');
INSERT INTO transactions VALUES('1098','1','2023-05-05','1','income','','1201','Student','21500.00','cr','3','131','4','641','','','','','2023-05-11 09:56:46','2023-05-11 09:56:46');
INSERT INTO transactions VALUES('1099','1','2023-05-06','1','income','','1174','Student','22000.00','cr','3','98','4','641','','','','','2023-05-11 09:57:41','2023-05-11 09:57:41');
INSERT INTO transactions VALUES('1100','1','2023-05-06','1','income','','1173','Student','19000.00','cr','3','97','4','641','','','','','2023-05-11 09:58:46','2023-05-11 09:58:46');
INSERT INTO transactions VALUES('1101','1','2023-05-06','1','income','','1169','Student','19000.00','cr','3','92','4','641','','','','','2023-05-11 09:59:20','2023-05-11 09:59:20');
INSERT INTO transactions VALUES('1102','1','2023-05-06','1','income','','1183','Student','19000.00','cr','3','107','4','641','','','','','2023-05-11 09:59:46','2023-05-11 09:59:46');
INSERT INTO transactions VALUES('1103','1','2023-05-06','1','income','','1184','Student','19000.00','cr','3','110','4','641','','','','','2023-05-11 10:00:17','2023-05-11 10:00:17');
INSERT INTO transactions VALUES('1104','1','2023-05-06','1','income','','1148','Student','15000.00','cr','3','35','4','641','','','','','2023-05-11 10:00:48','2023-05-11 10:00:48');
INSERT INTO transactions VALUES('1105','1','2023-05-06','1','income','','1167','Student','15000.00','cr','3','87','4','641','','','','','2023-05-11 10:01:17','2023-05-11 10:01:17');
INSERT INTO transactions VALUES('1106','1','2023-05-06','1','income','','1185','Student','19000.00','cr','3','111','4','641','','','','','2023-05-11 10:01:48','2023-05-11 10:01:48');
INSERT INTO transactions VALUES('1107','1','2023-05-06','1','income','','1168','Student','21500.00','cr','3','91','4','641','','','','','2023-05-11 10:03:11','2023-05-11 10:03:11');
INSERT INTO transactions VALUES('1108','1','2023-05-06','1','income','','1206','Student','20000.00','cr','3','128','4','641','','','','','2023-05-11 10:08:42','2023-05-11 10:08:42');
INSERT INTO transactions VALUES('1109','1','2023-05-07','1','income','','1186','Student','21500.00','cr','3','113','4','641','','','','','2023-05-11 10:09:44','2023-05-11 10:09:44');
INSERT INTO transactions VALUES('1110','1','2023-05-07','1','income','','938','Student','2000.00','cr','3','126','4','641','','','','','2023-05-11 10:12:13','2023-05-11 10:12:13');
INSERT INTO transactions VALUES('1111','1','2023-05-07','1','income','','1197','Student','21500.00','cr','3','126','4','641','','','','','2023-05-11 10:12:43','2023-05-11 10:12:43');
INSERT INTO transactions VALUES('1112','1','2023-05-07','1','income','','1170','Student','19000.00','cr','3','94','4','641','','','','','2023-05-11 10:13:23','2023-05-11 10:13:23');
INSERT INTO transactions VALUES('1113','1','2023-05-07','1','income','','1192','Student','19000.00','cr','3','119','4','641','','','','','2023-05-11 10:13:47','2023-05-11 10:13:47');
INSERT INTO transactions VALUES('1114','1','2023-05-07','1','income','','1189','Student','15000.00','cr','3','116','4','641','','','','','2023-05-11 10:14:36','2023-05-11 10:14:36');
INSERT INTO transactions VALUES('1115','1','2023-05-08','1','income','','1180','Student','15000.00','cr','3','104','4','641','','','','','2023-05-11 10:15:40','2023-05-11 10:15:40');
INSERT INTO transactions VALUES('1116','1','2023-05-08','1','income','','1151','Student','15000.00','cr','3','43','4','641','','','','','2023-05-11 10:16:26','2023-05-11 10:16:26');
INSERT INTO transactions VALUES('1117','1','2023-05-08','1','income','','1177','Student','19000.00','cr','3','101','4','641','','','','','2023-05-11 10:17:53','2023-05-11 10:17:53');
INSERT INTO transactions VALUES('1118','1','2023-05-08','1','income','','1175','Student','21500.00','cr','3','99','4','641','','','','','2023-05-11 10:18:28','2023-05-11 10:18:28');
INSERT INTO transactions VALUES('1119','1','2023-05-08','1','income','','1198','Student','19000.00','cr','3','127','4','641','','','','','2023-05-11 10:18:50','2023-05-11 10:18:50');
INSERT INTO transactions VALUES('1120','1','2023-05-09','1','income','','1159','Student','20000.00','cr','3','66','4','641','','','','','2023-05-11 10:19:17','2023-05-11 10:19:17');
INSERT INTO transactions VALUES('1121','1','2023-05-09','1','income','','1203','Student','23000.00','cr','3','133','4','641','','','','','2023-05-11 10:31:33','2023-05-11 10:31:33');
INSERT INTO transactions VALUES('1122','1','2023-05-09','1','income','','1207','Student','24500.00','cr','3','3','4','641','','','','','2023-05-11 10:53:46','2023-05-11 10:53:46');
INSERT INTO transactions VALUES('1123','1','2023-05-10','1','income','','1193','Student','21500.00','cr','3','120','4','641','','','','','2023-05-11 10:54:42','2023-05-11 10:54:42');
INSERT INTO transactions VALUES('1124','1','2023-05-10','1','income','','1200','Student','21500.00','cr','3','129','1','641','','','','','2023-05-11 10:55:16','2023-05-11 10:55:16');
INSERT INTO transactions VALUES('1125','1','2023-05-10','1','income','','1195','Student','10500.00','cr','3','122','4','641','','','','','2023-05-11 10:55:54','2023-05-11 10:55:54');
INSERT INTO transactions VALUES('1126','1','2023-05-10','1','income','','1154','Student','19500.00','cr','3','50','4','641','','','','','2023-05-11 10:57:25','2023-05-11 10:57:25');
INSERT INTO transactions VALUES('1127','1','2023-05-12','1','income','','1157','Student','19500.00','cr','3','63','4','641','','','','','2023-05-13 15:20:05','2023-05-13 15:20:05');
INSERT INTO transactions VALUES('1128','1','2023-05-13','1','income','','1155','Student','19500.00','cr','3','51','4','641','','','','','2023-05-13 15:21:44','2023-05-13 15:21:44');
INSERT INTO transactions VALUES('1129','1','2023-05-14','1','income','','1165','Student','18500.00','cr','3','81','4','641','','','','','2023-05-22 15:44:18','2023-05-22 15:44:18');
INSERT INTO transactions VALUES('1130','1','2023-05-04','1','income','','1208','Student','34000.00','cr','3','135','4','641','','','','','2023-05-23 10:55:47','2023-05-23 10:55:47');
INSERT INTO transactions VALUES('1131','1','2023-05-23','1','income','','1180','Student','3500.00','cr','3','104','1','641','','','','','2023-05-23 16:25:07','2023-05-23 16:25:07');
INSERT INTO transactions VALUES('1132','1','2023-05-24','1','income','','1153','Student','21000.00','cr','3','46','4','641','','','','','2023-05-24 12:30:10','2023-05-24 12:30:10');
INSERT INTO transactions VALUES('1133','1','2023-05-24','1','income','','1150','Student','21000.00','cr','3','42','4','641','','','','','2023-05-24 12:31:15','2023-05-24 12:31:15');
INSERT INTO transactions VALUES('1134','1','2023-05-11','1','income','','1158','Student','20000.00','cr','3','65','4','641','','','','','2023-05-29 14:31:44','2023-05-29 14:31:44');
INSERT INTO transactions VALUES('1135','1','2023-05-21','1','income','','1202','Student','21000.00','cr','3','132','4','641','','','','','2023-05-31 17:20:49','2023-05-31 17:20:49');
INSERT INTO transactions VALUES('1136','1','2023-05-27','1','income','','1151','Student','4000.00','cr','3','43','4','641','','','','','2023-05-31 17:24:14','2023-05-31 17:24:14');
INSERT INTO transactions VALUES('1137','1','2023-05-27','1','income','','1161','Student','2000.00','cr','3','73','4','641','','','','','2023-05-31 17:24:38','2023-05-31 17:24:38');
INSERT INTO transactions VALUES('1138','1','2023-05-27','1','income','','1164','Student','3000.00','cr','3','77','4','641','','','','','2023-05-31 17:25:08','2023-05-31 17:25:08');
INSERT INTO transactions VALUES('1139','1','2023-05-14','1','income','','1188','Student','20000.00','cr','3','115','4','641','','','','','2023-05-31 17:27:39','2023-05-31 17:27:39');
INSERT INTO transactions VALUES('1140','1','2023-05-18','1','income','','1190','Student','12000.00','cr','3','117','4','641','','','','','2023-05-31 17:28:53','2023-05-31 17:28:53');
INSERT INTO transactions VALUES('1141','1','2023-05-07','1','income','','1204','Student','40000.00','cr','3','134','4','641','','','','','2023-05-31 17:29:25','2023-05-31 17:29:25');
INSERT INTO transactions VALUES('1142','1','2023-05-10','1','income','','1205','Student','20000.00','cr','3','124','4','641','','','','','2023-05-31 17:29:59','2023-05-31 17:29:59');
INSERT INTO transactions VALUES('1143','1','2023-05-10','1','income','','1163','Student','19000.00','cr','3','75','4','641','','','','','2023-05-31 17:31:01','2023-05-31 17:31:01');
INSERT INTO transactions VALUES('1144','1','2023-05-15','1','income','','1191','Student','15000.00','cr','3','118','4','641','','','','','2023-05-31 17:31:40','2023-05-31 17:31:40');
INSERT INTO transactions VALUES('1145','1','2023-05-27','1','income','','1195','Student','11000.00','cr','3','122','4','641','','','','','2023-05-31 17:32:12','2023-05-31 17:32:12');
INSERT INTO transactions VALUES('1146','1','2023-05-27','1','income','','1103','Student','2000.00','cr','3','98','4','641','','','','','2023-05-31 17:45:45','2023-05-31 17:45:45');
INSERT INTO transactions VALUES('1147','1','2023-05-27','1','income','','1085','Student','1000.00','cr','3','63','4','641','','','','','2023-05-31 17:46:45','2023-05-31 17:46:45');
INSERT INTO transactions VALUES('1148','1','2023-06-01','1','income','','1232','Student','19000.00','cr','3','86','4','641','','','','','2023-06-01 15:26:22','2023-06-01 15:26:22');
INSERT INTO transactions VALUES('1149','1','2023-06-01','1','income','','1222','Student','19000.00','cr','3','58','4','641','','','','','2023-06-01 15:26:45','2023-06-01 15:26:45');
INSERT INTO transactions VALUES('1150','1','2023-06-01','1','income','','1227','Student','19000.00','cr','3','73','4','641','','','','','2023-06-01 15:27:11','2023-06-01 15:27:11');
INSERT INTO transactions VALUES('1151','1','2023-06-01','1','income','','1215','Student','19000.00','cr','3','40','4','641','','','','','2023-06-01 15:27:32','2023-06-01 15:27:32');
INSERT INTO transactions VALUES('1152','1','2023-06-01','1','income','','1229','Student','19000.00','cr','3','75','4','641','','','','','2023-06-01 15:27:59','2023-06-01 15:27:59');
INSERT INTO transactions VALUES('1153','1','2023-06-01','1','income','','1216','Student','21000.00','cr','3','42','4','641','','','','','2023-06-01 15:28:36','2023-06-01 15:28:36');
INSERT INTO transactions VALUES('1154','1','2023-06-01','1','income','','1219','Student','21000.00','cr','3','46','4','641','','','','','2023-06-01 15:28:59','2023-06-01 15:28:59');
INSERT INTO transactions VALUES('1155','1','2023-06-01','1','income','','1254','Student','12000.00','cr','3','117','4','641','','','','','2023-06-01 15:29:45','2023-06-01 15:29:45');
INSERT INTO transactions VALUES('1156','1','2023-06-01','1','income','','1247','Student','19000.00','cr','3','106','4','641','','','','','2023-06-01 15:30:12','2023-06-01 15:30:12');
INSERT INTO transactions VALUES('1157','1','2023-06-01','1','income','','1239','Student','10000.00','cr','3','97','4','641','','','','','2023-06-01 15:33:51','2023-06-01 15:33:51');
INSERT INTO transactions VALUES('1158','1','2023-06-01','1','income','','1223','Student','5000.00','cr','3','63','4','641','','','','','2023-06-01 15:36:11','2023-06-01 15:36:11');
INSERT INTO transactions VALUES('1159','1','2023-06-01','1','income','','1270','Student','19000.00','cr','3','136','4','641','','','','','2023-06-01 16:42:10','2023-06-01 16:42:10');
INSERT INTO transactions VALUES('1160','1','2023-06-01','1','income','','1271','Student','20000.00','cr','3','137','4','641','','','','','2023-06-01 16:43:22','2023-06-01 16:43:22');
INSERT INTO transactions VALUES('1161','1','2023-06-02','1','income','','1213','Student','19500.00','cr','3','21','4','641','','','','','2023-06-03 07:03:28','2023-06-03 07:03:28');
INSERT INTO transactions VALUES('1162','1','2023-06-05','1','income','','1272','Student','20000.00','cr','3','135','4','641','','','','','2023-06-05 09:08:18','2023-06-05 09:08:18');
INSERT INTO transactions VALUES('1163','1','2023-06-05','1','income','','1244','Student','19000.00','cr','3','102','4','641','','','','','2023-06-05 09:08:42','2023-06-05 09:08:42');
INSERT INTO transactions VALUES('1164','1','2023-06-05','1','income','','1246','Student','19000.00','cr','3','105','4','641','','','','','2023-06-05 09:37:56','2023-06-05 09:37:56');
INSERT INTO transactions VALUES('1165','1','2023-06-05','1','income','','1231','Student','18500.00','cr','3','81','4','641','','','','','2023-06-05 13:24:52','2023-06-05 13:24:52');
INSERT INTO transactions VALUES('1166','1','2023-06-06','1','income','','1258','Student','15000.00','cr','3','121','4','641','','','','','2023-06-06 18:11:37','2023-06-06 18:11:37');
INSERT INTO transactions VALUES('1167','1','2023-06-07','1','income','','1257','Student','21500.00','cr','3','120','4','641','','','','','2023-06-07 10:00:08','2023-06-07 10:00:08');
INSERT INTO transactions VALUES('1168','1','2023-06-07','1','income','','938','Student','3500.00','cr','3','126','4','641','','','','','2023-06-07 16:40:28','2023-06-07 16:40:28');
INSERT INTO transactions VALUES('1169','1','2023-06-07','1','income','','1261','Student','21500.00','cr','3','126','4','641','','','','','2023-06-07 16:40:50','2023-06-07 16:40:50');
INSERT INTO transactions VALUES('1170','1','2023-06-06','1','income','','1217','Student','19000.00','cr','3','43','4','641','','','','','2023-06-07 16:42:04','2023-06-07 16:42:04');
INSERT INTO transactions VALUES('1171','1','2023-06-09','1','income','','1236','Student','19000.00','cr','3','94','4','641','','','','','2023-06-08 19:23:18','2023-06-08 19:23:18');
INSERT INTO transactions VALUES('1172','1','2023-06-07','1','income','','1259','Student','21500.00','cr','3','122','4','641','','','','','2023-06-09 09:27:49','2023-06-09 09:27:49');
INSERT INTO transactions VALUES('1173','1','2023-06-12','1','income','','1228','Student','19000.00','cr','3','74','4','641','','','','','2023-06-12 12:20:05','2023-06-12 12:20:05');
INSERT INTO transactions VALUES('1174','1','2023-06-12','1','income','','1225','Student','10000.00','cr','3','66','4','641','','','','','2023-06-13 15:09:46','2023-06-13 15:09:46');
INSERT INTO transactions VALUES('1175','1','2023-06-12','1','income','','1225','Student','10000.00','cr','3','66','4','641','','','','','2023-06-13 15:09:49','2023-06-13 15:09:49');
INSERT INTO transactions VALUES('1176','1','2023-06-07','1','income','','1226','Student','26000.00','cr','3','72','4','641','','','','','2023-06-13 15:13:14','2023-06-13 15:13:14');
INSERT INTO transactions VALUES('1177','1','2023-06-08','1','income','','1239','Student','9000.00','cr','3','97','4','641','','','','','2023-06-13 15:14:21','2023-06-13 15:14:21');
INSERT INTO transactions VALUES('1178','1','2023-06-05','1','income','','1248','Student','19000.00','cr','3','107','4','641','','','','','2023-06-13 15:15:04','2023-06-13 15:15:04');
INSERT INTO transactions VALUES('1179','1','2023-06-06','1','income','','1249','Student','19000.00','cr','3','110','4','641','','','','','2023-06-13 15:15:54','2023-06-13 15:15:54');
INSERT INTO transactions VALUES('1180','1','2023-06-11','1','income','','1270','Student','19000.00','cr','3','136','4','641','','','','','2023-06-13 15:16:47','2023-06-13 15:16:47');
INSERT INTO transactions VALUES('1181','1','2023-06-12','1','income','','1271','Student','20000.00','cr','3','137','4','641','','','','','2023-06-13 15:18:29','2023-06-13 15:18:29');
INSERT INTO transactions VALUES('1182','1','2023-06-06','1','income','','1252','Student','20000.00','cr','3','115','4','641','','','','','2023-06-13 15:19:01','2023-06-13 15:19:01');
INSERT INTO transactions VALUES('1183','1','2023-06-06','1','income','','1268','Student','20000.00','cr','3','134','4','641','','','','','2023-06-13 15:20:05','2023-06-13 15:20:05');
INSERT INTO transactions VALUES('1184','1','2023-06-05','1','income','','1230','Student','19000.00','cr','3','77','4','641','','','','','2023-06-13 15:23:06','2023-06-13 15:23:06');
INSERT INTO transactions VALUES('1185','1','2023-06-05','1','income','','1210','Student','15000.00','cr','3','15','4','641','','','','','2023-06-13 15:24:37','2023-06-13 15:24:37');
INSERT INTO transactions VALUES('1186','1','2023-06-05','2','income','','1211','Student','15000.00','cr','3','17','1','641','','','','','2023-06-13 15:25:13','2023-06-13 15:25:13');
INSERT INTO transactions VALUES('1187','1','2023-06-06','1','income','','1212','Student','15000.00','cr','3','18','4','641','','','','','2023-06-13 15:26:14','2023-06-13 15:26:14');
INSERT INTO transactions VALUES('1188','1','2023-06-06','1','income','','1214','Student','15000.00','cr','3','35','4','641','','','','','2023-06-13 15:27:28','2023-06-13 15:27:28');
INSERT INTO transactions VALUES('1189','1','2023-06-09','1','income','','1233','Student','15000.00','cr','3','87','4','641','','','','','2023-06-13 15:29:06','2023-06-13 15:29:06');
INSERT INTO transactions VALUES('1190','1','2023-06-07','2','income','','1256','Student','19000.00','cr','3','119','1','641','','','','','2023-06-13 15:31:21','2023-06-13 15:31:21');
INSERT INTO transactions VALUES('1191','1','2023-06-09','1','income','','1220','Student','19500.00','cr','3','50','1','641','','','','','2023-06-13 15:34:15','2023-06-13 15:34:15');
INSERT INTO transactions VALUES('1192','1','2023-06-09','1','income','','1221','Student','19500.00','cr','3','51','4','641','','','','','2023-06-13 15:35:54','2023-06-13 15:35:54');
INSERT INTO transactions VALUES('1193','1','2023-06-13','1','income','','810','Student','0.00','cr','3','120','1','641','','','','','2023-06-13 17:26:22','2023-06-13 17:26:22');
INSERT INTO transactions VALUES('1194','1','2023-06-12','1','income','','1209','Student','24500.00','cr','3','3','4','641','','','','','2023-06-13 17:41:05','2023-06-13 17:41:05');
INSERT INTO transactions VALUES('1195','1','2023-06-05','2','income','','1218','Student','19000.00','cr','3','44','4','641','','','','','2023-06-13 17:42:20','2023-06-13 17:42:20');
INSERT INTO transactions VALUES('1196','1','2023-06-11','1','income','','1260','Student','20000.00','cr','3','124','4','641','','','','','2023-06-13 17:43:31','2023-06-13 17:43:31');
INSERT INTO transactions VALUES('1197','1','2023-06-11','1','income','','1263','Student','20000.00','cr','3','128','4','641','','','','','2023-06-13 17:43:59','2023-06-13 17:43:59');
INSERT INTO transactions VALUES('1198','1','2023-06-05','2','income','','1265','Student','21500.00','cr','3','131','1','641','','','','','2023-06-13 17:46:36','2023-06-13 17:46:36');
INSERT INTO transactions VALUES('1199','1','2023-03-17','1','income','','1273','Student','32300.00','cr','3','131','4','641','','','','','2023-06-13 18:00:15','2023-06-13 18:00:15');
INSERT INTO transactions VALUES('1200','1','2023-06-10','1','income','','1223','Student','14500.00','cr','3','63','4','641','','','','','2023-06-13 18:07:51','2023-06-13 18:07:51');
INSERT INTO transactions VALUES('1201','1','2023-06-14','1','income','','1251','Student','21500.00','cr','3','113','1','641','','','','','2023-06-14 06:38:46','2023-06-14 06:38:46');
INSERT INTO transactions VALUES('1202','1','2023-06-13','1','income','','1242','Student','21500.00','cr','3','100','1','641','','','','','2023-06-14 10:05:49','2023-06-14 10:05:49');
INSERT INTO transactions VALUES('1203','1','2023-06-11','1','income','','1274','Student','37000.00','cr','2','85','1','641','','','','','2023-06-14 15:42:39','2023-06-14 15:42:39');
INSERT INTO transactions VALUES('1204','1','2023-06-15','1','income','','1275','Student','33000.00','cr','2','138','4','641','','','','','2023-06-15 08:37:38','2023-06-15 08:37:38');
INSERT INTO transactions VALUES('1205','1','2023-07-09','1','income','','1235','Student','19000.00','cr','2','92','1','641','','','','','2023-07-09 08:45:12','2023-07-09 08:45:12');
INSERT INTO transactions VALUES('1206','1','2023-07-09','1','income','','1303','Student','19000.00','cr','2','92','1','641','','','','JUNE RENT PAID','2023-07-09 08:46:45','2023-07-09 08:46:45');
INSERT INTO transactions VALUES('1207','1','2023-06-06','1','income','','1240','Student','22000.00','cr','3','98','4','641','','','','','2023-07-09 09:02:22','2023-07-09 09:02:22');
INSERT INTO transactions VALUES('1208','1','2023-07-09','1','income','','1308','Student','36000.00','cr','2','98','1','641','','','','','2023-07-09 09:05:18','2023-07-09 09:05:18');
INSERT INTO transactions VALUES('1209','1','2023-07-09','1','income','','1308','Student','-6000.00','cr','2','98','1','641','','','','','2023-07-09 09:08:01','2023-07-09 09:08:01');
INSERT INTO transactions VALUES('1210','1','2023-07-09','1','income','','1308','Student','0.00','cr','2','98','1','641','','','','','2023-07-09 09:09:18','2023-07-09 09:09:18');
INSERT INTO transactions VALUES('1211','1','2023-07-09','1','income','','1327','Student','20000.00','cr','3','122','4','641','','','','','2023-07-09 17:44:28','2023-07-09 17:44:28');
INSERT INTO transactions VALUES('1212','1','2023-07-10','1','income','','1336','Student','20000.00','cr','3','135','4','641','','','','','2023-07-10 07:02:46','2023-07-10 07:02:46');
INSERT INTO transactions VALUES('1213','1','2023-07-10','1','income','','1333','Student','21000.00','cr','3','131','4','641','','','','','2023-07-10 08:50:15','2023-07-10 08:50:15');
INSERT INTO transactions VALUES('1214','1','2023-07-10','1','income','','1300','Student','19000.00','cr','3','86','4','641','','','','','2023-07-10 14:56:18','2023-07-10 14:56:18');
INSERT INTO transactions VALUES('1215','1','2023-07-10','1','income','','1298','Student','18500.00','cr','3','81','4','641','','','','','2023-07-10 16:25:35','2023-07-10 16:25:35');
INSERT INTO transactions VALUES('1216','1','2023-07-12','1','income','','1307','Student','15000.00','cr','3','97','4','641','','','','','2023-07-12 05:35:54','2023-07-12 05:35:54');
INSERT INTO transactions VALUES('1217','1','2023-07-13','1','income','','1286','Student','21000.00','cr','3','46','4','641','','','','','2023-07-13 19:18:48','2023-07-13 19:18:48');
INSERT INTO transactions VALUES('1218','1','2023-07-04','2','income','','1293','Student','25500.00','cr','3','72','1','641','','','','','2023-07-16 12:24:19','2023-07-16 12:24:19');
INSERT INTO transactions VALUES('1219','1','2023-07-04','2','income','','1280','Student','19500.00','cr','3','21','1','641','','','','','2023-07-16 12:25:48','2023-07-16 12:25:48');
INSERT INTO transactions VALUES('1220','1','2023-07-06','2','income','','1331','Student','20000.00','cr','3','128','1','641','','','','','2023-07-16 12:28:14','2023-07-16 12:28:14');
INSERT INTO transactions VALUES('1221','1','2023-07-04','1','income','','1310','Student','21500.00','cr','2','100','4','641','','','','','2023-07-16 12:30:58','2023-07-16 12:30:58');
INSERT INTO transactions VALUES('1222','1','2023-07-04','1','income','','1317','Student','19000.00','cr','3','110','4','641','','','','','2023-07-16 12:31:52','2023-07-16 12:31:52');
INSERT INTO transactions VALUES('1223','1','2023-07-05','1','income','','1318','Student','19000.00','cr','3','111','4','641','','','','','2023-07-16 12:33:52','2023-07-16 12:33:52');
INSERT INTO transactions VALUES('1224','1','2023-07-05','1','income','','1284','Student','19000.00','cr','3','43','4','641','','','','','2023-07-16 12:34:55','2023-07-16 12:34:55');
INSERT INTO transactions VALUES('1225','1','2023-07-05','1','income','','1282','Student','19000.00','cr','3','40','4','641','','','','','2023-07-16 12:35:30','2023-07-16 12:35:30');
INSERT INTO transactions VALUES('1226','1','2023-07-05','1','income','','1297','Student','19000.00','cr','3','77','4','641','','','','','2023-07-16 12:36:10','2023-07-16 12:36:10');
INSERT INTO transactions VALUES('1227','1','2023-07-05','1','income','','1296','Student','19000.00','cr','3','75','4','641','','','','','2023-07-16 12:36:56','2023-07-16 12:36:56');
INSERT INTO transactions VALUES('1228','1','2023-07-05','1','income','','1314','Student','19000.00','cr','3','105','4','641','','','','','2023-07-16 12:37:42','2023-07-16 12:37:42');
INSERT INTO transactions VALUES('1229','1','2023-07-05','1','income','','1292','Student','20000.00','cr','3','66','4','641','','','','','2023-07-16 12:39:05','2023-07-16 12:39:05');
INSERT INTO transactions VALUES('1230','1','2023-07-05','1','income','','1313','Student','17000.00','cr','3','104','4','641','','','','','2023-07-16 12:41:05','2023-07-16 12:41:05');
INSERT INTO transactions VALUES('1231','1','2023-07-05','1','income','','1278','Student','15000.00','cr','3','17','4','641','','','','','2023-07-16 12:42:45','2023-07-16 12:42:45');
INSERT INTO transactions VALUES('1232','1','2023-07-05','1','income','','1277','Student','15000.00','cr','3','15','4','641','','','','','2023-07-16 12:44:15','2023-07-16 12:44:15');
INSERT INTO transactions VALUES('1233','1','2023-07-08','1','income','','1337','Student','19000.00','cr','3','136','4','641','','','','','2023-07-16 12:46:23','2023-07-16 12:46:23');
INSERT INTO transactions VALUES('1234','1','2023-07-06','1','income','','1315','Student','19000.00','cr','3','106','4','641','','','','','2023-07-16 12:47:33','2023-07-16 12:47:33');
INSERT INTO transactions VALUES('1235','1','2023-07-10','1','income','','1319','Student','21000.00','cr','3','113','4','641','','','','','2023-07-16 12:51:15','2023-07-16 12:51:15');
INSERT INTO transactions VALUES('1236','1','2023-07-07','1','income','','1295','Student','19000.00','cr','3','74','4','641','','','','','2023-07-16 12:53:09','2023-07-16 12:53:09');
INSERT INTO transactions VALUES('1237','1','2023-07-07','1','income','','1283','Student','21000.00','cr','3','42','4','641','','','','','2023-07-16 12:56:15','2023-07-16 12:56:15');
INSERT INTO transactions VALUES('1238','1','2023-07-07','1','income','','1329','Student','21000.00','cr','3','126','4','641','','','','','2023-07-16 12:57:26','2023-07-16 12:57:26');
INSERT INTO transactions VALUES('1239','1','2023-07-07','1','income','','1289','Student','19000.00','cr','3','58','4','641','','','','','2023-07-16 12:58:38','2023-07-16 12:58:38');
INSERT INTO transactions VALUES('1240','1','2023-07-07','1','income','','1294','Student','15000.00','cr','3','73','4','641','','','','','2023-07-16 12:59:36','2023-07-16 12:59:36');
INSERT INTO transactions VALUES('1241','1','2023-07-13','1','income','','1311','Student','19000.00','cr','3','101','4','641','','','','','2023-07-16 13:01:31','2023-07-16 13:01:31');
INSERT INTO transactions VALUES('1242','1','2023-07-05','1','income','','1339','Student','19000.00','cr','3','138','4','641','','','','','2023-07-16 13:05:00','2023-07-16 13:05:00');
INSERT INTO transactions VALUES('1243','1','2023-07-10','1','income','','1330','Student','19000.00','cr','3','127','4','641','','','','','2023-07-19 09:09:28','2023-07-19 09:09:28');
INSERT INTO transactions VALUES('1244','1','2023-07-10','1','income','','1301','Student','15000.00','cr','3','87','4','641','','','','','2023-07-19 09:12:15','2023-07-19 09:12:15');
INSERT INTO transactions VALUES('1245','1','2023-07-10','1','income','','1316','Student','18500.00','cr','3','107','4','641','','','','','2023-07-19 09:14:00','2023-07-19 09:14:00');
INSERT INTO transactions VALUES('1246','1','2023-07-11','1','income','','1324','Student','18500.00','cr','3','119','4','641','','','','','2023-07-19 09:15:45','2023-07-19 09:15:45');
INSERT INTO transactions VALUES('1247','1','2023-07-13','1','income','','1288','Student','19500.00','cr','3','51','4','641','','','','','2023-07-19 09:19:26','2023-07-19 09:19:26');
INSERT INTO transactions VALUES('1248','1','2023-07-14','1','income','','1285','Student','19000.00','cr','3','44','4','641','','','','','2023-07-19 09:22:38','2023-07-19 09:22:38');
INSERT INTO transactions VALUES('1249','1','2023-06-16','1','income','','1224','Student','20000.00','cr','2','65','1','641','','','','','2023-07-22 07:25:41','2023-07-22 07:25:41');
INSERT INTO transactions VALUES('1250','1','2023-07-15','1','income','','1291','Student','18000.00','cr','3','65','1','641','','','','','2023-07-22 07:27:44','2023-07-22 07:27:44');
INSERT INTO transactions VALUES('1251','1','2023-07-22','1','income','','1333','Student','500.00','cr','2','131','1','641','','','','','2023-07-22 07:30:19','2023-07-22 07:30:19');
INSERT INTO transactions VALUES('1252','1','2023-07-20','1','income','','1341','Student','23000.00','cr','2','139','1','641','','','','','2023-07-22 07:47:43','2023-07-22 07:47:43');
INSERT INTO transactions VALUES('1253','1','2023-07-09','2','income','','1328','Student','19000.00','cr','3','124','1','641','','','','','2023-07-24 06:56:42','2023-07-24 06:56:42');
INSERT INTO transactions VALUES('1254','1','2023-07-12','2','income','','1290','Student','18500.00','cr','3','63','1','641','','','','','2023-07-24 06:58:57','2023-07-24 06:58:57');
INSERT INTO transactions VALUES('1255','1','2023-07-26','1','income','','1342','Student','25000.00','cr','2','140','1','641','','','','','2023-07-26 14:38:56','2023-07-26 14:38:56');
INSERT INTO transactions VALUES('1256','1','2023-07-27','1','income','','1299','Student','25000.00','cr','2','85','4','641','','','','','2023-07-28 15:10:41','2023-07-28 15:10:41');
INSERT INTO transactions VALUES('1257','1','2023-07-28','1','income','','1343','Student','20000.00','cr','2','141','4','641','','','','','2023-07-28 15:39:18','2023-07-28 15:39:18');
INSERT INTO transactions VALUES('1258','1','2023-07-11','1','income','','1335','Student','20000.00','cr','2','134','1','641','','','','','2023-07-30 11:23:21','2023-07-30 11:23:21');
INSERT INTO transactions VALUES('1259','1','2023-07-10','1','income','','1338','Student','20000.00','cr','2','137','1','641','','','','','2023-07-30 11:25:05','2023-07-30 11:25:05');
INSERT INTO transactions VALUES('1260','1','2023-07-10','1','income','','1320','Student','15000.00','cr','2','115','1','641','','','','','2023-07-30 11:26:10','2023-07-30 11:26:10');
INSERT INTO transactions VALUES('1261','1','2023-07-10','1','income','','1234','Student','21500.00','cr','2','91','1','641','','','','','2023-07-30 11:41:39','2023-07-30 11:41:39');
INSERT INTO transactions VALUES('1262','1','2023-07-23','1','income','','1302','Student','20500.00','cr','2','91','1','641','','','','','2023-07-30 11:42:11','2023-07-30 11:42:11');
INSERT INTO transactions VALUES('1263','1','2023-07-15','1','income','','1237','Student','23000.00','cr','2','95','1','641','','','','','2023-07-30 11:46:37','2023-07-30 11:46:37');
INSERT INTO transactions VALUES('1264','1','2023-07-12','1','income','','1305','Student','23000.00','cr','2','95','1','641','','','','','2023-07-30 11:47:07','2023-07-30 11:47:07');
INSERT INTO transactions VALUES('1265','1','2023-07-19','1','income','','1306','Student','23000.00','cr','2','96','1','641','','','','','2023-07-30 11:48:01','2023-07-30 11:48:01');
INSERT INTO transactions VALUES('1266','1','2023-07-18','1','income','','1238','Student','23000.00','cr','2','96','1','641','','','','','2023-07-30 11:48:51','2023-07-30 11:48:51');
INSERT INTO transactions VALUES('1267','1','2023-07-21','1','income','','1172','Student','3000.00','cr','2','96','1','641','','','','','2023-07-30 11:49:42','2023-07-30 11:49:42');
INSERT INTO transactions VALUES('1268','1','2023-07-13','1','income','','1101','Student','1000.00','cr','2','96','1','641','','','','','2023-07-30 11:50:36','2023-07-30 11:50:36');
INSERT INTO transactions VALUES('1269','1','2023-07-16','1','income','','1171','Student','4000.00','cr','2','95','1','641','','','','','2023-07-30 11:51:32','2023-07-30 11:51:32');
INSERT INTO transactions VALUES('1270','1','2023-07-15','1','income','','1276','Student','24500.00','cr','2','3','1','641','','','','','2023-07-30 11:53:50','2023-07-30 11:53:50');
INSERT INTO transactions VALUES('1271','1','2023-07-18','1','income','','367','Student','70.00','cr','2','3','1','641','','','','','2023-07-30 11:54:21','2023-07-30 11:54:21');
INSERT INTO transactions VALUES('1272','1','2023-07-13','1','income','','432','Student','100.00','cr','2','3','1','641','','','','','2023-07-30 11:54:43','2023-07-30 11:54:43');
INSERT INTO transactions VALUES('1273','1','2023-07-18','1','income','','677','Student','220.00','cr','2','42','1','641','','','','','2023-07-30 11:56:00','2023-07-30 11:56:00');
INSERT INTO transactions VALUES('1274','1','2023-07-14','1','income','','678','Student','220.00','cr','2','46','1','641','','','','','2023-07-30 11:56:39','2023-07-30 11:56:39');
INSERT INTO transactions VALUES('1275','1','2023-07-13','1','income','','1253','Student','15000.00','cr','2','116','1','641','','','','','2023-07-30 11:57:34','2023-07-30 11:57:34');
INSERT INTO transactions VALUES('1276','1','2023-07-14','1','income','','1255','Student','15000.00','cr','2','118','1','641','','','','','2023-07-30 11:57:54','2023-07-30 11:57:54');
INSERT INTO transactions VALUES('1277','1','2023-07-14','1','income','','1323','Student','15000.00','cr','2','118','1','641','','','','','2023-07-30 11:58:16','2023-07-30 11:58:16');
INSERT INTO transactions VALUES('1278','1','2023-07-15','1','income','','1322','Student','12000.00','cr','2','117','1','641','','','','','2023-07-30 11:58:32','2023-07-30 11:58:32');
INSERT INTO transactions VALUES('1279','1','2023-07-20','1','income','','1307','Student','4000.00','cr','2','97','1','641','','','','','2023-07-30 12:01:42','2023-07-30 12:01:42');
INSERT INTO transactions VALUES('1280','1','2023-07-20','1','income','','411','Student','7500.00','cr','2','77','1','641','','','','','2023-07-30 12:03:12','2023-07-30 12:03:12');
INSERT INTO transactions VALUES('1281','1','2023-07-20','1','income','','1294','Student','4000.00','cr','2','73','1','641','','','','','2023-07-30 12:04:17','2023-07-30 12:04:17');
INSERT INTO transactions VALUES('1282','1','2023-07-17','1','income','','409','Student','7500.00','cr','2','75','1','641','','','','','2023-07-30 12:06:16','2023-07-30 12:06:16');
INSERT INTO transactions VALUES('1283','1','2023-07-15','1','income','','466','Student','500.00','cr','2','75','1','641','','','','','2023-07-30 12:07:32','2023-07-30 12:07:32');
INSERT INTO transactions VALUES('1284','1','2023-07-13','2','income','','1279','Student','15000.00','cr','2','18','1','641','','','','','2023-07-30 12:13:09','2023-07-30 12:13:09');
INSERT INTO transactions VALUES('1285','1','2023-07-19','1','income','','1267','Student','23000.00','cr','2','133','1','641','','','','','2023-07-30 12:15:58','2023-07-30 12:15:58');
INSERT INTO transactions VALUES('1286','1','2023-07-19','1','income','','1334','Student','23000.00','cr','2','133','1','641','','','','','2023-07-30 12:16:28','2023-07-30 12:16:28');
INSERT INTO transactions VALUES('1287','1','2023-07-15','1','income','','1264','Student','21500.00','cr','2','129','1','641','','','','','2023-07-30 12:17:07','2023-07-30 12:17:07');
INSERT INTO transactions VALUES('1288','1','2023-07-15','1','income','','1332','Student','21500.00','cr','2','129','1','641','','','','','2023-07-30 12:18:13','2023-07-30 12:18:13');
INSERT INTO transactions VALUES('1289','1','2023-07-13','1','income','','1262','Student','19000.00','cr','2','127','1','641','','','','','2023-07-30 12:19:01','2023-07-30 12:19:01');
INSERT INTO transactions VALUES('1290','1','2023-07-14','1','income','','1250','Student','19000.00','cr','2','111','1','641','','','','','2023-07-30 12:19:43','2023-07-30 12:19:43');
INSERT INTO transactions VALUES('1291','1','2023-07-15','1','income','','1304','Student','19000.00','cr','2','94','1','641','','','','','2023-07-30 12:20:14','2023-07-30 12:20:14');
INSERT INTO transactions VALUES('1292','1','2023-07-15','1','income','','1312','Student','19000.00','cr','2','102','1','641','','','','','2023-07-30 12:20:41','2023-07-30 12:20:41');
INSERT INTO transactions VALUES('1293','1','2023-07-15','1','income','','1245','Student','18500.00','cr','2','104','1','641','','','','','2023-07-30 12:21:30','2023-07-30 12:21:30');
INSERT INTO transactions VALUES('1294','1','2023-07-15','1','income','','1313','Student','1500.00','cr','2','104','1','641','','','','','2023-07-30 12:22:14','2023-07-30 12:22:14');
INSERT INTO transactions VALUES('1295','1','2023-07-15','1','income','','420','Student','8000.00','cr','2','86','1','641','','','','','2023-07-30 12:22:44','2023-07-30 12:22:44');
INSERT INTO transactions VALUES('1296','1','2023-07-22','1','income','','1243','Student','19000.00','cr','2','101','1','641','','','','','2023-07-30 12:23:26','2023-07-30 12:23:26');
INSERT INTO transactions VALUES('1297','1','2023-07-15','1','income','','1281','Student','15000.00','cr','2','35','1','641','','','','','2023-07-30 12:24:36','2023-07-30 12:24:36');
INSERT INTO transactions VALUES('1298','1','2023-07-15','1','income','','1326','Student','15000.00','cr','2','121','1','641','','','','','2023-07-30 12:25:54','2023-07-30 12:25:54');
INSERT INTO transactions VALUES('1299','1','2023-07-15','2','income','','1325','Student','20000.00','cr','2','120','1','641','','','','','2023-07-30 12:29:00','2023-07-30 12:29:00');
INSERT INTO transactions VALUES('1300','1','2023-07-15','1','income','','1038','Student','1000.00','cr','2','96','1','641','','','','','2023-07-30 12:59:01','2023-07-30 12:59:01');
INSERT INTO transactions VALUES('1301','1','2023-07-20','1','income','','1290','Student','500.00','cr','2','63','1','641','','','','','2023-08-03 18:20:30','2023-08-03 18:20:30');
INSERT INTO transactions VALUES('1302','1','2023-08-02','2','income','','1348','Student','19500.00','cr','3','21','1','641','','','','','2023-08-03 18:21:29','2023-08-03 18:21:29');
INSERT INTO transactions VALUES('1303','1','2023-08-03','2','income','','1357','Student','19500.00','cr','3','63','1','641','','','','','2023-08-03 18:22:31','2023-08-03 18:22:31');
INSERT INTO transactions VALUES('1304','1','2023-08-01','1','income','','1356','Student','19000.00','cr','3','58','1','641','','','','','2023-08-04 19:09:34','2023-08-04 19:09:34');
INSERT INTO transactions VALUES('1305','1','2023-08-01','1','income','','1366','Student','19000.00','cr','3','86','4','641','','','','','2023-08-04 19:10:23','2023-08-04 19:10:23');
INSERT INTO transactions VALUES('1306','1','2023-08-02','1','income','','1351','Student','21000.00','cr','3','42','1','641','','','','','2023-08-04 19:11:08','2023-08-04 19:11:08');
INSERT INTO transactions VALUES('1307','1','2023-08-01','1','income','','1381','Student','19000.00','cr','3','107','1','641','','','','','2023-08-04 19:16:26','2023-08-04 19:16:26');
INSERT INTO transactions VALUES('1308','1','2023-08-02','1','income','','1354','Student','21000.00','cr','3','46','1','641','','','','','2023-08-04 19:16:57','2023-08-04 19:16:57');
INSERT INTO transactions VALUES('1309','1','2023-08-02','1','income','','1352','Student','19000.00','cr','3','43','1','641','','','','','2023-08-04 19:17:35','2023-08-04 19:17:35');
INSERT INTO transactions VALUES('1310','1','2023-08-02','1','income','','1404','Student','20000.00','cr','3','141','1','641','','','','','2023-08-04 19:18:15','2023-08-04 19:18:15');
INSERT INTO transactions VALUES('1311','1','2023-08-02','1','income','','1350','Student','19000.00','cr','3','40','1','641','','','','','2023-08-04 19:18:53','2023-08-04 19:18:53');
INSERT INTO transactions VALUES('1312','1','2023-08-03','1','income','','1407','Student','25000.00','cr','3','144','4','641','','','','','2023-08-04 19:19:46','2023-08-04 19:19:46');
INSERT INTO transactions VALUES('1313','1','2023-08-03','1','income','','1320','Student','5000.00','cr','2','115','4','641','','','','','2023-08-04 19:20:36','2023-08-04 19:20:36');
INSERT INTO transactions VALUES('1314','1','2023-08-03','1','income','','1385','Student','20000.00','cr','3','115','4','641','','','','','2023-08-04 19:22:20','2023-08-04 19:22:20');
INSERT INTO transactions VALUES('1315','1','2023-08-02','1','income','','1371','Student','23000.00','cr','3','95','4','641','','','','','2023-08-04 19:22:57','2023-08-04 19:22:57');
INSERT INTO transactions VALUES('1316','1','2023-08-03','1','income','','1401','Student','19000.00','cr','2','138','4','641','','','','','2023-08-04 19:23:59','2023-08-04 19:23:59');
INSERT INTO transactions VALUES('1317','1','2023-08-03','1','income','','1408','Student','30000.00','cr','3','145','4','641','','','','','2023-08-04 19:24:41','2023-08-04 19:24:41');
INSERT INTO transactions VALUES('1318','1','2023-08-03','1','income','','1399','Student','19000.00','cr','3','136','4','641','','','','','2023-08-04 19:25:10','2023-08-04 19:25:10');
INSERT INTO transactions VALUES('1319','1','2023-08-03','1','income','','1373','Student','19500.00','cr','3','97','4','641','','','','','2023-08-04 19:25:42','2023-08-04 19:25:42');
INSERT INTO transactions VALUES('1320','1','2023-08-04','1','income','','1405','Student','22000.00','cr','3','142','4','641','','','','','2023-08-04 19:26:35','2023-08-04 19:26:35');
INSERT INTO transactions VALUES('1321','1','2023-08-04','1','income','','1406','Student','22000.00','cr','3','143','4','641','','','','','2023-08-04 19:27:08','2023-08-04 19:27:08');
INSERT INTO transactions VALUES('1322','1','2023-08-04','1','income','','1400','Student','20000.00','cr','3','137','4','641','','','','','2023-08-04 19:28:54','2023-08-04 19:28:54');
INSERT INTO transactions VALUES('1323','1','2023-08-04','1','income','','1393','Student','21500.00','cr','3','126','4','641','','','','','2023-08-04 19:29:38','2023-08-04 19:29:38');
INSERT INTO transactions VALUES('1324','1','2023-08-04','1','income','','1382','Student','19000.00','cr','3','110','4','641','','','','','2023-08-04 19:30:22','2023-08-04 19:30:22');
INSERT INTO transactions VALUES('1325','1','2023-08-04','1','income','','1375','Student','21500.00','cr','3','100','4','641','','','','','2023-08-04 19:31:22','2023-08-04 19:31:22');
INSERT INTO transactions VALUES('1326','1','2023-08-04','1','income','','1378','Student','18500.00','cr','3','104','4','641','','','','','2023-08-04 19:32:02','2023-08-04 19:32:02');
INSERT INTO transactions VALUES('1327','1','2023-08-04','1','income','','1355','Student','19500.00','cr','3','51','4','641','','','','','2023-08-04 19:33:45','2023-08-04 19:33:45');
INSERT INTO transactions VALUES('1328','1','2023-08-02','2','income','','1360','Student','26000.00','cr','3','72','4','641','','','','','2023-08-04 19:36:05','2023-08-04 19:36:05');
INSERT INTO transactions VALUES('1329','1','2023-08-04','2','income','','1397','Student','20000.00','cr','2','133','4','641','','','','','2023-08-04 19:39:09','2023-08-04 19:39:09');
INSERT INTO transactions VALUES('1330','1','2023-08-05','1','income','','1409','Student','30000.00','cr','3','146','4','641','','','','','2023-08-05 11:26:01','2023-08-05 11:26:01');
INSERT INTO transactions VALUES('1331','1','2023-08-05','1','income','','1345','Student','15000.00','cr','3','15','4','641','','','','','2023-08-05 18:58:29','2023-08-05 18:58:29');
INSERT INTO transactions VALUES('1332','1','2023-08-05','1','income','','1387','Student','12000.00','cr','3','117','4','641','','','','','2023-08-05 18:59:01','2023-08-05 18:59:01');
INSERT INTO transactions VALUES('1333','1','2023-08-05','1','income','','1346','Student','15000.00','cr','3','17','4','641','','','','','2023-08-05 19:00:07','2023-08-05 19:00:07');
INSERT INTO transactions VALUES('1334','1','2023-08-05','1','income','','1391','Student','15000.00','cr','3','121','4','641','','','','','2023-08-05 19:00:54','2023-08-05 19:00:54');
INSERT INTO transactions VALUES('1335','1','2023-08-05','1','income','','1396','Student','21500.00','cr','3','131','4','641','','','','','2023-08-05 19:01:55','2023-08-05 19:01:55');
INSERT INTO transactions VALUES('1336','1','2023-08-04','2','income','','1349','Student','15000.00','cr','3','35','1','641','','','','','2023-08-05 19:02:34','2023-08-05 19:02:34');
INSERT INTO transactions VALUES('1337','1','2023-08-05','2','income','','1367','Student','15000.00','cr','3','87','1','641','','','','','2023-08-05 19:03:17','2023-08-05 19:03:17');
INSERT INTO transactions VALUES('1338','1','2023-08-06','1','income','','1364','Student','19000.00','cr','3','77','4','641','','','','','2023-08-07 08:13:13','2023-08-07 08:13:13');
INSERT INTO transactions VALUES('1339','1','2023-08-06','1','income','','1362','Student','19000.00','cr','3','74','1','641','','','','','2023-08-07 08:14:22','2023-08-07 08:14:22');
INSERT INTO transactions VALUES('1340','1','2023-08-06','1','income','','1376','Student','19000.00','cr','3','101','1','641','','','','','2023-08-07 09:46:00','2023-08-07 09:46:00');
INSERT INTO transactions VALUES('1341','1','2023-08-06','1','income','','1374','Student','24000.00','cr','3','98','4','641','','','','','2023-08-07 09:49:55','2023-08-07 09:49:55');
INSERT INTO transactions VALUES('1342','1','2023-08-06','1','income','','1308','Student','6000.00','cr','3','98','4','641','','','','','2023-08-07 09:51:54','2023-08-07 09:51:54');
INSERT INTO transactions VALUES('1343','1','2023-08-06','1','income','','1341','Student','7000.00','cr','2','139','4','641','','','','','2023-08-07 09:53:55','2023-08-07 09:53:55');
INSERT INTO transactions VALUES('1344','1','2023-08-06','1','income','','1402','Student','23000.00','cr','2','139','4','641','','','','','2023-08-07 09:54:47','2023-08-07 09:54:47');
INSERT INTO transactions VALUES('1345','1','2023-08-07','1','income','','1344','Student','24500.00','cr','3','3','1','641','','','','','2023-08-07 09:57:09','2023-08-07 09:57:09');
INSERT INTO transactions VALUES('1346','1','2023-08-07','1','income','','1370','Student','19000.00','cr','3','94','4','641','','','','','2023-08-07 10:22:56','2023-08-07 10:22:56');
INSERT INTO transactions VALUES('1347','1','2023-08-08','1','income','','1389','Student','19000.00','cr','3','119','4','641','','','','','2023-08-09 07:24:12','2023-08-09 07:24:12');
INSERT INTO transactions VALUES('1348','1','2023-08-08','1','income','','1394','Student','19000.00','cr','3','127','4','641','','','','','2023-08-09 07:26:38','2023-08-09 07:26:38');
INSERT INTO transactions VALUES('1349','1','2023-08-07','1','income','','1383','Student','19000.00','cr','3','111','4','641','','','','','2023-08-09 07:28:18','2023-08-09 07:28:18');
INSERT INTO transactions VALUES('1350','1','2023-08-08','1','income','','1392','Student','21500.00','cr','3','122','4','641','','','','','2023-08-09 07:29:38','2023-08-09 07:29:38');
INSERT INTO transactions VALUES('1351','1','2023-08-08','1','income','','1359','Student','12000.00','cr','3','66','4','641','','','','','2023-08-09 07:31:16','2023-08-09 07:31:16');



DROP TABLE IF EXISTS transport_members;

CREATE TABLE `transport_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `member_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transport_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS transport_vehicles;

CREATE TABLE `transport_vehicles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `vehicle_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `serial_number` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS transports;

CREATE TABLE `transports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `road_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vehicle_id` int(11) NOT NULL,
  `road_fare` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS user_messages;

CREATE TABLE `user_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(11) NOT NULL,
  `receiver_id` int(11) NOT NULL,
  `read` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS user_notices;

CREATE TABLE `user_notices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `notice_id` int(11) NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO user_notices VALUES('11','3','Accountant','2022-01-19 18:30:49','2022-01-19 18:30:49');
INSERT INTO user_notices VALUES('9','2','Admin','2022-01-19 18:25:50','2022-01-19 18:25:50');
INSERT INTO user_notices VALUES('8','2','Employee','2022-01-19 18:25:50','2022-01-19 18:25:50');
INSERT INTO user_notices VALUES('7','2','Accountant','2022-01-19 18:25:50','2022-01-19 18:25:50');
INSERT INTO user_notices VALUES('6','2','Parent','2022-01-19 18:25:50','2022-01-19 18:25:50');
INSERT INTO user_notices VALUES('12','3','Admin','2022-01-19 18:30:49','2022-01-19 18:30:49');
INSERT INTO user_notices VALUES('13','4','Accountant','2022-01-19 19:21:57','2022-01-19 19:21:57');
INSERT INTO user_notices VALUES('14','4','Admin','2022-01-19 19:21:57','2022-01-19 19:21:57');
INSERT INTO user_notices VALUES('15','5','Accountant','2022-01-19 19:39:25','2022-01-19 19:39:25');
INSERT INTO user_notices VALUES('16','5','Admin','2022-01-19 19:39:25','2022-01-19 19:39:25');
INSERT INTO user_notices VALUES('17','6','Accountant','2022-01-19 19:49:32','2022-01-19 19:49:32');
INSERT INTO user_notices VALUES('18','6','Admin','2022-01-19 19:49:32','2022-01-19 19:49:32');
INSERT INTO user_notices VALUES('19','7','Accountant','2022-01-19 19:52:35','2022-01-19 19:52:35');
INSERT INTO user_notices VALUES('20','7','Admin','2022-01-19 19:52:35','2022-01-19 19:52:35');
INSERT INTO user_notices VALUES('21','8','Accountant','2022-01-19 19:55:14','2022-01-19 19:55:14');
INSERT INTO user_notices VALUES('22','8','Admin','2022-01-19 19:55:14','2022-01-19 19:55:14');
INSERT INTO user_notices VALUES('23','9','Accountant','2022-02-24 10:59:25','2022-02-24 10:59:25');



DROP TABLE IF EXISTS users;

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `school_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL DEFAULT 0,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `facebook` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_plus` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=789 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES('319','1','3','Faraz','faraz@hostalmanager.pk','$2y$10$fOM9QC4iUheZYOOTdr6j8uS.HDmskMOceVsD2xH6lH3kZOiKdLXWu','Admin','03170000352','1','users/profile.png','#','#','#','#','Mn6Joh3l2V12XMpoZWhm2CQGwdJgbTZ5DL7PsqYxXG0xqd37H2MSAPQCoxHt','2021-09-30 13:46:18','2021-10-04 21:43:03');
INSERT INTO users VALUES('703','1','0','HARIS  SOHAIL ','6440489@logic.com','$2y$10$fT5UdeBnA61ijgXB3Jged.PvGrO2/3kcg/YVF0xQ1nGgmdB4FOlK.','Student','923348168438','0','students/profile.png','','','','','','2022-03-05 17:03:46','2022-07-03 08:40:25');
INSERT INTO users VALUES('787','1','0','ELYAS KHAN','elyas@hayatpalace.pk','$2y$10$J7dFNBdRO8GYh080iOUkbu5F7nIDo/xMfzJfZkkZunwqyj.Bu9isu','Teacher','923077178384','1','teachers/profile.png','','','','','','2023-08-04 17:35:56','2023-08-04 17:35:56');
INSERT INTO users VALUES('788','1','0','RASHED ULLAH ','92561995@logic.com','$2y$10$OBEk1w8UGMAHtWqv9ZU7q.HA7wKjd4eUaDpyd6NT8zUUamv9JJrjq','Student','923322196858','1','students/profile.png','','','','','','2023-08-05 11:18:08','2023-08-05 11:18:08');
INSERT INTO users VALUES('710','1','0','ALLAH NAWAZ ','79949505@logic.com','$2y$10$MA66JtZZawOJM.Rczy9/w.midvAIH2MG6i/RQcSXTtcjbv4S5Lp7e','Student','923000678283','0','students/profile.png','','','','','','2022-04-08 09:33:16','2022-12-22 05:34:34');
INSERT INTO users VALUES('699','1','0','ABDULLAH ','11651656@logic.com','$2y$10$oJGSQ36wIgaCuCyPo7UPTuPivE9TlYu0LVTMLW.qM4xR1wZ3GmiJe','Student','923345729390','0','students/profile.png','','','','','','2022-02-22 14:08:12','2022-07-14 07:25:18');
INSERT INTO users VALUES('698','1','0','IMAD KHAN ','5615432@logic.com','$2y$10$E2PKNHmg8SOfAtoMW8qYWuQvmNah/LnUceJk7msjT7TUDTVdGvKJ.','Student','92333874751','0','students/profile.png','','','','','','2022-02-22 14:01:10','2022-07-23 08:27:53');
INSERT INTO users VALUES('697','1','0','JUNAID HABIB ','48331770@logic.com','$2y$10$Q.VyhE3uqODC88jG5l3wI.92pB.5QHtmIRnBaYamETBcn.8mwcKem','Student','923152295884','1','students/profile.png','','','','','','2022-02-20 19:48:18','2022-02-20 19:48:18');
INSERT INTO users VALUES('696','1','0','SAVEED ','84209879@logic.com','$2y$10$6TgszYAgCRULzMq18JFlaeTTwttLkPLPMC294xY2Z/UsJoqh9vJKa','Student','923111672088','0','students/profile.png','','','','','','2022-02-20 19:30:41','2022-04-01 09:05:30');
INSERT INTO users VALUES('695','1','0','SYED MURTAZA ABBAS ','1@logic.com','$2y$10$2U.zRAz1JLiauuMdMoHEC.habREm.mvp0JamOCwFPp4CDrEwW8wwS','Student','923215858598','0','students/profile.png','','','','','','2022-02-20 13:40:11','2022-06-28 08:43:44');
INSERT INTO users VALUES('694','1','0','RASHID JAVED LODHI ','57@logic.com','$2y$10$mFZ78r4YumlO49pXOcU0Xe4M..jhTueEiCaKF6SjzhgMjjyemHNRW','Student','923007427083','0','students/profile.png','','','','','','2022-02-12 20:46:04','2022-04-01 09:05:09');
INSERT INTO users VALUES('693','1','0','MUHAMAMD MUSTAJAB GOHAR ','56@logic.com','$2y$10$ZQ2AidUc2e6DRFDzBMq18eAbhZcgV15dsXDdyxnCAUe7PV6XdOMje','Student','923038499807','0','students/profile.png','','','','','','2022-02-03 17:49:07','2022-03-15 07:31:02');
INSERT INTO users VALUES('702','1','0','UMAMA ZAHOOR ','33184044@logic.com','$2y$10$Va84/kr55Nul.474qKlXSu/wynMkT3zXbdl0KAC1Uxk2s8ugBXvjW','Student','923415937509','0','students/profile.png','','','','','','2022-03-03 12:14:08','2022-04-09 14:09:55');
INSERT INTO users VALUES('691','1','0','MUHAMMAD ASIM KHAN ','54@logic.com','$2y$10$2uuPiKupDyrE8xcABFkEb.irE5dJOd4xK1dhbUtUkAsLu.Ma8Rxd6','Student','0347-9700019','0','students/profile.png','','','','','','2022-01-31 20:25:32','2022-02-26 09:57:50');
INSERT INTO users VALUES('690','1','0','SYED SHAH HUSSAIN ','53@logic.com','$2y$10$3e8r6AIE1OzikLk2Diw/HOW5tatl8l69uDCXO25fmIq0OA9wyAbU6','Student','92334','1','students/profile.png','','','','','','2022-01-28 20:46:21','2022-03-03 11:42:54');
INSERT INTO users VALUES('689','1','0','AIZAZ RAHIM KHAN ','52@logic.com','$2y$10$zglrzPP7yuRKF1vBnFVbhuY/xKNLsu6FuZBoAsN4pHwMPvoNKFAN6','Student','923055500016','0','students/profile.png','','','','','','2022-01-27 20:23:27','2023-07-08 15:53:06');
INSERT INTO users VALUES('688','1','0','AHMAD RAZA ','51@logic.com','$2y$10$y/8pKvTjMHX6hetbdYbD9egYJk.vDQbrP4FNTH1gWz5Xk6aVb6/2q','Student','023441148159','0','students/profile.png','','','','','','2022-01-23 19:11:08','2022-11-03 06:21:43');
INSERT INTO users VALUES('687','1','0','SARDAR SAQIB NAWAZ ','50@logic.com','$2y$10$x2btRQeBKrmLItFyD8KqVeUc76NS/IPwsGk7dXnr2Tm06GSz/lIqq','Student','03335720080','0','students/profile.png','','','','','','2022-01-12 16:22:34','2022-02-02 17:52:46');
INSERT INTO users VALUES('686','1','0','ABDULLAH ALTAF ','49@logic.com','$2y$10$FHcCRpRHhXjqvimMrrSbMed321bQE9OeWhDi37tgVIFwsU5h5aR/6','Student','03168424512','0','students/profile.png','','','','','','2022-01-10 11:23:56','2022-01-20 16:34:24');
INSERT INTO users VALUES('685','1','0','MUHAMMAD IMRAN SIKANDER ','48@logic.com','$2y$10$GzFrgC9tOryor7lAsI7UMOmHrlNDjJ3.f4ejy5aqhoPebYEVSQM2u','Student','923217591121','1','students/profile.png','','','','','','2022-01-03 13:10:11','2022-02-02 16:55:50');
INSERT INTO users VALUES('684','1','0','AFAF AHMAD ','47@logic.com','$2y$10$fUOgF0BuInXMtcMSrP6rBukoYHInjwI5QNlBE0ICRmBbi1Jti3psa','Student','923224455299','0','students/1649319714.png','','','','','','2022-01-02 21:30:17','2022-04-07 08:21:54');
INSERT INTO users VALUES('683','1','0','SHAH FAHAD RAHIM ','46@logic.com','$2y$10$OgOr4OZQYV4lNN7Ez2g0Au3BwcUFKcCnRO8JbxoQq7TTwPb56UaPi','Student','023339147485','1','students/profile.png','','','','','','2022-01-02 17:57:26','2022-09-03 18:19:43');
INSERT INTO users VALUES('682','1','0','NASIR SHABBIR ','45@logic.com','$2y$10$FuWEjVP2cyT2J/oTVa9QPO6bOp7l31HCJ2QpIoDwd.8TYcebXErN.','Student','923007488846','1','students/profile.png','','','','','','2021-12-31 12:46:06','2021-12-31 12:46:06');
INSERT INTO users VALUES('681','1','0','SYED ALI ABBAS GILLANI ','44@logic.com','$2y$10$LjpxwJdE3nxuS9ckglS16ubnNleRwtsaC2egVjPlBjezVOsxOyGRm','Student','923006328500','1','students/profile.png','','','','','','2021-12-31 12:42:24','2021-12-31 12:42:24');
INSERT INTO users VALUES('692','1','0','AHMAD AWAN ','55@logic.com','$2y$10$UjdxsJGoZ21WfNwe/aQJD.qB8pXYwqJYyEXgtkDui3g1TSRTwawxq','Student','923019704767','0','students/profile.png','','','','','','2022-02-02 12:43:33','2022-07-14 10:54:18');
INSERT INTO users VALUES('680','1','0','ZAIN UL ABIDEEN BANGSH ','43@logic.com','$2y$10$bBcvGiWFdyeSAYq4eviSMOXBuccq8K.RjHyZdSYL0GVrAnRGH.t8C','Student','923102329337','0','students/profile.png','','','','','','2021-12-31 12:30:45','2022-02-02 12:40:48');
INSERT INTO users VALUES('679','1','0','JAHANZAIB KHAN ','42@logic.com','$2y$10$e52lgua4.Em0As.PNsxfn.0pA4aiTYKAMzpSGwOOeUoji0LvUIhHq','Student','923007338840','1','students/profile.png','','','','','','2021-12-17 20:44:21','2021-12-17 20:44:21');
INSERT INTO users VALUES('678','1','0','ABDULLAH HUSSAIN ','41@logic.com','$2y$10$mBNJbE1OBAwZD1V/m1PkF.yITr8fTdZbaXtAzMIHNhskqXvReeO.C','Student','923109173987','0','students/profile.png','','','','','','2021-12-17 20:40:39','2022-02-02 16:50:28');
INSERT INTO users VALUES('677','1','0','M ALI ABBAS ','39@logic.com','$2y$10$IrfJ1CgyhM.SvIrukiW6du8CSDdfNiD9ly1HWITwZWUejvArSV56q','Student','03136168223','0','students/profile.png','','','','','','2021-12-09 19:15:12','2022-07-14 10:55:06');
INSERT INTO users VALUES('676','1','0','KAMIL RIAZ ','38@logic.com','$2y$10$0mhxONL2lTXJQ87hH9Osa.cGZXe683OUSc.MIizl/KqaPYQtiE89u','Student','03430934230','0','students/profile.png','','','','','','2021-12-09 10:38:53','2022-06-02 11:10:12');
INSERT INTO users VALUES('675','1','0','SHAHBAZ SALEEM KHAN ','37@logic.com','$2y$10$QJ9zsX9c4kp3LRim/wYq4Om/cRxLVNM0q7TpIvcICkMBiHaCZHx9y','Student','03176218899','0','students/profile.png','','','','','','2021-12-08 18:14:05','2022-06-02 11:12:41');
INSERT INTO users VALUES('674','1','0','MUHAMMAD ALI RAZA ','36@logic.com','$2y$10$QVUzISRdM/rOBbmxrJUTJuMcUb6A05IxKUaEOUwUumS9yU7C08aEG','Student','023085542883','1','students/profile.png','','','','','','2021-12-08 11:27:12','2022-09-03 17:59:28');
INSERT INTO users VALUES('673','1','0','HAMZA LIAQAT ','35@logic.com','$2y$10$dobXMG.5NPuh3Gum.RcOXeJBYYWujV5eiFhVf.PU0YmGe.Jt3CfP2','Student','03028961743','0','students/profile.png','','','','','','2021-12-07 18:29:53','2022-02-02 12:39:36');
INSERT INTO users VALUES('672','1','0','HARIS SHEROZE KHAN ','34@logic.com','$2y$10$BjwEzL/.98tlbVPJuuRLGuroNJ2318uvqR815.kpKc6kGN2O4eshy','Student','03321524601','0','students/profile.png','','','','','','2021-12-07 11:40:21','2022-02-02 12:49:59');
INSERT INTO users VALUES('671','1','0','SHAHZAIN MUSHTAQ ','33@logic.com','$2y$10$ARLQO3hrM0WrRmJOqbONcOXCLqUeSFOktl06c/cJWq2Qoy3gWv./e','Student','923426913900','0','students/profile.png','','','','','','2021-12-05 17:05:29','2022-05-08 13:43:49');
INSERT INTO users VALUES('670','1','0','ZEESHAN MAQBOOL ','32@logic.com','$2y$10$hx8F5LFAXgW1uevsECy/DOKiAy96c0aOiD8dlacFRs9iajB1Gay4y','Student','923012308408','0','students/profile.png','','','','','','2021-12-05 17:01:59','2022-05-08 13:43:25');
INSERT INTO users VALUES('669','1','0','MUHAMMAD AMIN YOUSAF ','31@logic.com','$2y$10$TgABBRwZmpqEcZLMdYIn.OI3XLCGoo0sKZ/PgOaCCQ07JZmnbcopW','Student','923228182152','0','students/profile.png','','','','','','2021-12-05 16:54:57','2022-05-08 13:43:37');
INSERT INTO users VALUES('668','1','0','BAHAR JAN ','30@logic.com','$2y$10$E/xIHTcnsfwSMeNBoIeW5.3jRXM.F4ox/U1OvsW/OLkgZtuh3M2FW','Student','923337563023','0','students/profile.png','','','','','','2021-12-05 16:40:10','2022-05-08 13:43:10');
INSERT INTO users VALUES('667','1','0','ABDUL REHMAN ','29@logic.com','$2y$10$EjmQVoEB0r1cxjbIYmS8K.4AOUQh/arXsFDgvjWhgVKtRNZRCOMlC','Student','923430999666','0','students/profile.png','','','','','','2021-12-05 15:55:02','2021-12-31 12:34:04');
INSERT INTO users VALUES('666','1','0','ZEESHAN MUNIR ','28@logic.com','$2y$10$.QdeJrjAJlZz3f0Pck6bsurQv1BOeproCFl6hHxRl8FL95uE5iOpe','Student','923077837614','0','students/profile.png','','','','','','2021-12-05 12:59:17','2022-06-05 13:56:22');
INSERT INTO users VALUES('665','1','0','SYED MURSALEEN RIAZ ','27@logic.com','$2y$10$VJ8XwIu5GC1eGneD9ztH/Om8UrRPXwBwJo.RLmAaOuXnokx.UA.4O','Student','92301','0','students/profile.png','','','','','','2021-12-05 12:56:03','2022-06-02 11:03:05');
INSERT INTO users VALUES('664','1','0','SAIM AHMED MIAN ','26@logic.com','$2y$10$Qb5FG0JYRrOVb.zGDcHso.LmX1Odzcz2b1gtCVbfW7OyDf3uAOUva','Student','923353064931','0','students/profile.png','','','','','','2021-12-05 12:52:37','2023-01-06 10:34:06');
INSERT INTO users VALUES('663','1','0','DANISH MUKHTAR ','24@logic.com','$2y$10$8MXuZhRFtpZjGTuS0TWKkOgekstDUF1VYvKW7Z62wuSvh5EyTuDby','Student','923317311904','0','students/profile.png','','','','','','2021-12-05 12:39:02','2022-06-02 10:39:32');
INSERT INTO users VALUES('662','1','0','MUHAMMAD TOUSEEF ','23@logic.com','$2y$10$ZcTSUqODuZaIEaYCqUxylOopovulX5Bz53HJY6SCyRdB4rnqmApqS','Student','923233439188','0','students/profile.png','','','','','','2021-12-05 12:35:10','2022-06-02 10:38:55');
INSERT INTO users VALUES('661','1','0','MUHAMMAD BILAL ','22@logic.com','$2y$10$oXgIj8O7LvVnqRt85xJkqONuK.EYd/5GwOjw/Y9yxnEZdnBvHIMiu','Student','923037501835','0','students/profile.png','','','','','','2021-12-05 12:15:43','2022-06-02 10:38:40');
INSERT INTO users VALUES('660','1','0','ALI MURAD ','21@logic.com','$2y$10$6fcmDlmN8hU1Bwh/hln0aOTNY0D8l2ywTtNOwQQ5zemkzjwCWY7N2','Student','923343599900','1','students/profile.png','','','','','','2021-12-05 12:03:45','2021-12-05 14:30:23');
INSERT INTO users VALUES('659','1','0','MUHAMMAD ZEESHAN ','20@logic.com','$2y$10$zN/8UclqYp.IFz52FFLDUuHav3dz/ptjY2Hi1DN2iIc6RT.Fgu43G','Student','923453756634','0','students/profile.png','','','','','','2021-12-05 11:58:29','2022-01-27 20:14:35');
INSERT INTO users VALUES('658','1','0','HASHAM TAYYAB ','19@logic.com','$2y$10$/X0.WM0VNTuzvss6a23uL.EpFra8kkGs/hFMEpIqr73u0LaqNesI6','Student','923207212423','0','students/profile.png','','','','','','2021-12-05 11:54:17','2022-01-27 20:14:48');
INSERT INTO users VALUES('657','1','0','MOIZ AHMED ','18@logic.com','$2y$10$1/sZ/6oeBFZ4FyuChwEGwOo27D24c3UqzSGM3Zb1ogCJ0tyiEG6nO','Student','923024328496','1','students/profile.png','','','','','','2021-12-05 11:47:53','2021-12-05 11:47:53');
INSERT INTO users VALUES('656','1','0','ZAIN BIN KHALID ','17@logic.com','$2y$10$wuWZWEl8eHCQo/2tV2yKM.4I9wUHLdPM1oW09WFGyZjT7uUB4gHLO','Student','923334742698','1','students/profile.png','','','','','','2021-12-05 11:44:34','2021-12-05 13:57:31');
INSERT INTO users VALUES('655','1','0','WALEED AFZAL ','16@logic.com','$2y$10$nMUemjcjB6iRgavv4YEkPeus7UHwe7lRewljISulWbuxrzclyN4FC','Student','923166162629','0','students/profile.png','','','','','','2021-12-05 11:41:52','2022-08-11 06:17:48');
INSERT INTO users VALUES('654','1','0','ALI USMAN ','15@logic.com','$2y$10$a3zWuFg/5ASinZOkjYY4N.oX7SS5pF2aCBRqRQk4pspN.QlJ.SlXu','Student','923245725498','1','students/profile.png','','','','','','2021-12-05 11:37:49','2021-12-05 11:37:49');
INSERT INTO users VALUES('653','1','0','SADAT KHAN ','14@logic.com','$2y$10$TqZ1etpLxTXwcTEI4nOj0u7L2vCkejT5Dm3KIqwyyX9wDb.8A7hFG','Student','923353021543','0','students/profile.png','','','','','','2021-12-05 11:29:59','2022-04-30 14:24:00');
INSERT INTO users VALUES('652','1','0','AHAD NASIR ','13@logic.com','$2y$10$ryDZHcFpsFJkNKyLHzM8t.Dx75p4tACiZK2PWzdjp3xJ138KN.jcS','Student','923222736280','0','students/profile.png','','','','','','2021-12-04 20:38:26','2022-04-08 10:29:43');
INSERT INTO users VALUES('651','1','0','MUHAMMAD TALHA ','12@logic.com','$2y$10$HEAC7VGe1SsNMgskuxiRbuS5gBuDePC0r3vG8lpyxv38oX0v50gmW','Student','923145842415','0','students/profile.png','','','','','','2021-12-04 19:49:14','2021-12-16 23:00:10');
INSERT INTO users VALUES('650','1','0','MUHAMMAD ALI ','11@logic.com','$2y$10$nOsi4IpcbtrLZ7vcLg39EOdJgeGduUpq.CRt.RW/ipSJ3yw5h0XPO','Student','9233314952221','0','students/profile.png','','','','','','2021-12-04 19:41:41','2022-02-02 12:50:10');
INSERT INTO users VALUES('649','1','0','NABEEL AHMED ','10@logic.com','$2y$10$plTMbz1uJRqUH629cYBxRe80ukZzxEPriamRCOAiYxO9yTJ1mu/OW','Student','923228895315','0','students/profile.png','','','','','','2021-12-04 19:36:50','2022-03-15 06:59:28');
INSERT INTO users VALUES('648','1','0','HAAD ZUBAIR ','9@logic.com','$2y$10$TZYwTWXU7ubrgBMPvZ/WDurczABdP/O6aXUP4b91FaWGjhLGYO/3q','Student','92335659033','0','students/profile.png','','','','','','2021-12-04 18:49:17','2022-04-01 16:04:17');
INSERT INTO users VALUES('647','1','0','MAJID ASLAM ','8@logic.com','$2y$10$ptExCmUmpluS/cNhHXtuCei5qP1I8Ui5H5/ebBUlGx9CJuTSOt3fW','Student','9203087381833','0','students/profile.png','','','','','','2021-12-04 18:41:39','2022-08-03 06:00:48');
INSERT INTO users VALUES('646','1','0','SAAD JAVED ','7@logic.com','$2y$10$q11Ciu1pe.arXIFKPeuhi.7r2BhtM5WNb/3ko82C/wWHoWGDeIsPm','Student','920340658928','0','students/profile.png','','','','','','2021-12-04 18:34:10','2023-06-01 15:48:53');
INSERT INTO users VALUES('645','1','0','MUHAMMAD BILAL ','06@logic.com','$2y$10$Wm0Hlqp7epIY0EmkT0OFzuFk9VjX7Osew558vVLG4R818q8EbchqW','Student','923041844802','0','students/profile.png','','','','','','2021-12-04 18:05:01','2022-02-17 15:42:47');
INSERT INTO users VALUES('644','1','0','MAAZ KHAN ','05@logic.com','$2y$10$UGW.kIsnz5rqHTvJL9uihOaSKTlYf9t.UT4QElhtpJGKge3wyxS2m','Student','923419331445','0','students/profile.png','','','','','','2021-12-04 17:51:45','2021-12-05 17:09:19');
INSERT INTO users VALUES('643','1','0','HAMD GHANI ','04@logic.com','$2y$10$BpNNblZ8tR9yntGUzQ0iluhG79RAR.Z5a.CW1zY.ehSfh2LkHXC5y','Student','92314441111','0','students/profile.png','','','','','','2021-12-04 17:47:35','2022-07-03 08:37:29');
INSERT INTO users VALUES('642','1','0','SYED MUHAMMAD ALI ','03@logic.com','$2y$10$7U6eO/XRoftVvZBG6eVWLeZ5lc76zSSBd39AhHqniAqf8RdUl27EO','Student','923478074730','1','students/profile.png','','','','','','2021-12-04 17:38:22','2021-12-04 17:38:22');
INSERT INTO users VALUES('641','1','3','Zubair Arshad','zubair@hayatpalace.pk','$2y$10$iGIgaWXQc4RZY8I0nHD8OO0ju/zElTYJuQUSBYWFHdkroDzwAFPFS','Admin','030010101010','1','users/profile.png','#','#','#','#','wCrQ48NpUUJ6fmTBc9g2LDZ74xWdo43UWdoLeJ0j9hSuQNDGdc9YPfu0JNDo','2021-12-04 03:57:08','2023-06-21 10:16:54');
INSERT INTO users VALUES('640','1','0','MUHAMMAD UMAIR SHAHID ','02@logic.com','$2y$10$cigFdzE3Qr24pJM/LgglaOrVbNdIMZcfjZW1/WkFLlRoxQffPUfSW','Student','923314589200','0','students/profile.png','','','','','','2021-10-05 11:11:35','2022-02-02 12:50:27');
INSERT INTO users VALUES('639','1','0','MONIS ALI ','01@logic.com','$2y$10$Wo5Vs9LJL9oZobrzQubHI.OPrdlFJNI44.8.kfZ8PbcDO.mHDYXlK','Student','923336865901','0','students/profile.png','','','','','','2021-10-05 10:57:05','2022-02-20 12:35:36');
INSERT INTO users VALUES('638','1','0','Default','default.parent@hostalmanager.pk','$2y$10$Y28TRRVVWFc3l8KZw1kctexlxIn1XKtvqZK3qo1MQ1cfvIFMSwfqm','Parent','03111689150','1','parents/profile.png','','','','','','2021-10-05 10:53:50','2021-10-05 10:53:50');
INSERT INTO users VALUES('704','1','0','ATTA ULLAH JAN ','42082225@logic.com','$2y$10$KgHm91RnvgrxcwtGQlfxbuPDM214WmZlsxYKuzLsIXKp.3.daKcx.','Student','923667676767','1','students/profile.png','','','','','','2022-03-12 15:05:51','2022-05-22 12:19:26');
INSERT INTO users VALUES('705','1','0','MUHAMMAD USMAN NASEER ','48237873@logic.com','$2y$10$u/4f0dEUtXyGi2Ji2RdwQ.uXPMRmcYI8Ih1zkoMsEIxEfwKjtyQCC','Student','923218823151','0','students/profile.png','','','','','','2022-03-12 15:30:34','2022-07-14 10:54:38');
INSERT INTO users VALUES('706','1','0','MUHAMMAD UMAR FAHIM ','79273340@logic.com','$2y$10$Y6bfKj/uxDnu7HE0lqT9auOB0pTWVywSKhQY6OQKE3ahUh9ho5EDy','Student','923009002693','1','students/profile.png','','','','','','2022-03-15 07:05:56','2022-03-15 07:05:56');
INSERT INTO users VALUES('707','1','0','AHMAD SUBHAN ','8305630@logic.com','$2y$10$zUF7lSKNBioZbyi2hpaOPucXiacK9ZNtmVFewSbCu89am.MSy.Hs6','Student','923055153606','1','students/profile.png','','','','','','2022-03-15 07:38:43','2022-03-15 07:38:43');
INSERT INTO users VALUES('708','1','0','SHAHID RASHID ','42285228@logic.com','$2y$10$.GilYaeIq6EMm0qdxOx5SuzrsJTBZbSMkcEYi80e4Br5aMywEydUe','Student','923325140706','0','students/profile.png','','','','','','2022-04-04 11:44:25','2022-11-06 14:36:51');
INSERT INTO users VALUES('709','1','0','KASHIF ALI ZAMAN ','69680356@logic.com','$2y$10$T4aHuNvxQjVf2dZsKTxUEe.gGgKasfzEeGbC0JMNdE1Yx35KwiHRO','Student','923055336764','0','students/profile.png','','','','','','2022-04-06 11:49:22','2022-11-16 16:57:32');
INSERT INTO users VALUES('711','1','0','SHAHZAIB KHURSHID ','58640571@logic.com','$2y$10$SKETWz9wO0PLdFToSVlDGeFCNXaskfzxaVQkjoGnijXQKGhdIml.G','Student','923170886491','0','students/profile.png','','','','','','2022-04-08 10:39:35','2022-07-14 10:50:28');
INSERT INTO users VALUES('714','1','0','MURTAZA ZAMAN ','47154611@logic.com','$2y$10$HSiBrrB0Tsqr1sahv0vZked.yMpvC/RPTUAEW1sJ4K81KjWIZpc9G','Student','923007334127','1','students/profile.png','','','','','','2022-05-10 15:28:46','2022-05-10 15:28:46');
INSERT INTO users VALUES('712','1','0','NOUMAN SAFIR ','28339600@logic.com','$2y$10$CObICjhmWiJTR6p3ajrUfup/qFIE3D5.XTgapHGTPmUo2wnLp2262','Student','923178040898','0','students/profile.png','','','','','','2022-04-23 14:54:32','2022-06-13 14:13:43');
INSERT INTO users VALUES('713','1','0','KASHIF KHAN LODHI ','91351692@logic.com','$2y$10$9EalkUu1rBMZaC70vozcjOuU4iAYJJieIlOLvsfYR9R8LiVQH8wC2','Student','922331986639','1','students/profile.png','','','','','','2022-04-28 08:34:36','2022-04-28 08:34:36');
INSERT INTO users VALUES('715','1','0','SYED ASGHAR ABBAS ','63987493@logic.com','$2y$10$tsNBtREmIheurMJhy/va0OQuZO7OBy.bqa31ofvRhRqLBRc6qhY1i','Student','923216311499','1','students/profile.png','','','','','','2022-05-11 07:08:21','2022-05-11 07:08:21');
INSERT INTO users VALUES('716','1','0','SHOUKAT HUSSAIN ','42643245@logic.com','$2y$10$coamcLNcwt60dl/esoSopOhzWjS/41AS79IwkhoB2Y1DxFeLHJN02','Student','923116961723','1','students/profile.png','','','','','','2022-05-11 07:23:42','2022-05-11 07:23:42');
INSERT INTO users VALUES('717','1','0','KASHIF AZIZ ','50163277@logic.com','$2y$10$cjHt8YF4Ee48pKG4.S4WVeoiaAoyZZZi7AHz0tWEtQDVQJ8N14xpC','Student','923146555553','0','students/profile.png','','','','','','2022-05-11 12:11:39','2022-07-14 07:26:12');
INSERT INTO users VALUES('718','1','0','M,WAQAS HASSAN ','96124247@logic.com','$2y$10$MYDQvEejPS1j5OYgr5saIOcXQ89mA8l032Avh9wwHZT0BY/fdkLiG','Student','923249634462','1','students/profile.png','','','','','','2022-05-11 12:35:56','2022-05-11 12:35:56');
INSERT INTO users VALUES('719','1','0','ZAIN UL ABEDIN ','30124821@logic.com','$2y$10$2QndXBheEt9HIQSrENog.uG2Ck70fdTDDo/nyYAbMqNn/SkK4ASpa','Student','923350167670','0','students/profile.png','','','','','','2022-05-22 12:39:58','2022-07-14 10:36:55');
INSERT INTO users VALUES('720','1','0','FARZAUQ JANG ','63360019@logic.com','$2y$10$klNJFZGIW2e20KZWnwcrLuwe8dvadMI0x///1/LjLeFm8YYutowhS','Student','923451200004','0','students/profile.png','','','','','','2022-05-22 13:08:26','2022-09-03 18:29:38');
INSERT INTO users VALUES('721','1','0','MUHAMMAD AMIN ','4135660@logic.com','$2y$10$TCyDxfso0Ebt60eO3RKvou3hoXnAzpz2NHTEmb9ElLyvtWUK5UiPq','Student','923228182152','0','students/profile.png','','','','','','2022-05-23 08:11:00','2022-06-25 15:53:07');
INSERT INTO users VALUES('722','1','0','BILAL ISHAQ ','43082387@logic.com','$2y$10$qxWG6E3qBme4qsguqZKJ0OU2EzS0tdWjpymfD6.xiLpSj3jAMTZXO','Student','923036509371','1','students/profile.png','','','','','','2022-05-31 07:49:48','2022-11-02 16:47:00');
INSERT INTO users VALUES('723','1','0','HASSAN ','20248877@logic.com','$2y$10$5QciUPxbCa51mzYfjToq3.8Ia.YNJRcnohcxzErfnIeMwDwBsrSjm','Student','920245435455','0','students/profile.png','','','','','','2022-06-02 10:34:53','2022-07-03 08:41:33');
INSERT INTO users VALUES('724','1','0','MOHSIN SAJJAD ','33695193@logic.com','$2y$10$zWP8sk95WcqrCLywWjP/IOIoMQN9PaZOsDRL9GtGxZ6ctm8DZL.wO','Student','923037015906','0','students/profile.png','','','','','','2022-06-02 14:47:49','2022-10-05 07:43:41');
INSERT INTO users VALUES('725','1','0','ABDULLAH YOUNIS ','95268246@logic.com','$2y$10$fpdj7KKldxfP9sdmzxupbO64s5mMA3uFLXsK3./d2sU5yI1/989c6','Student','923470962129','0','students/profile.png','','','','','','2022-06-04 05:20:57','2022-08-03 05:51:58');
INSERT INTO users VALUES('726','1','0','FEHNAN MUNIR ','28529082@logic.com','$2y$10$bFIk7P8nyFsHXgmUAz04MeqqctG0OWGHmelAjkNmVofvMBCjOE9Zm','Student','923012626413','0','students/profile.png','','','','','','2022-06-04 05:32:40','2023-07-13 16:03:24');
INSERT INTO users VALUES('727','1','0','FIAZ HUSSAIN BOSIN ','63585278@logic.com','$2y$10$UiJzDjAQkCRkbGMNvYLz/eLjWRWqCwAiwcL6tSmwTz.MJok/MvrqW','Student','923017503247','1','students/profile.png','','','','','','2022-06-04 05:43:50','2022-06-04 05:43:50');
INSERT INTO users VALUES('728','1','0','MUHAMMAD ABID IQBAL ','65356284@logic.com','$2y$10$jjqch2c.eKZWsSU5mXeZNe3FRW6yio8pliSdHDy7ol/Q0hdygIcI2','Student','923009874978','1','students/profile.png','','','','','','2022-06-05 14:01:26','2022-06-05 14:01:26');
INSERT INTO users VALUES('729','1','0','RASHID NAWAZ ','29996850@logic.com','$2y$10$WpCrMa7j0jl.gL7CjHyGjuBW.ra1rarGNkMfZwFI3nmjwrVtfLQHK','Student','923082745020','0','students/profile.png','','','','','','2022-06-05 14:17:02','2022-06-05 14:26:56');
INSERT INTO users VALUES('730','1','0','MUHAMMAD ISRAR KHAN ','17702957@logic.com','$2y$10$43qNHOopXSU0VZrzTE04p.4Ql8NK8BkHkXdxDFP.D6kGAf2pO8NQq','Student','923339696758','0','students/profile.png','','','','','','2022-06-05 14:36:08','2022-09-03 17:43:14');
INSERT INTO users VALUES('731','1','0','RASHID NAWAZ ','21753753@logic.com','$2y$10$ZTlvIHKoiWi1PEZKxx6LMeDdVxzofymKkCwFwWHFfgQ8br0uFIJXe','Student','923082745020','0','students/profile.png','','','','','','2022-06-05 14:46:54','2022-07-03 08:36:54');
INSERT INTO users VALUES('732','1','0','ZAKI HAFEEZ MALIK ','54997139@logic.com','$2y$10$NE4.pdjrPiUpCTZ.YGS/vuJndUCv7QD/lN84Z7NKmkQwRCs.YZlMW','Student','023403394354','1','students/profile.png','','','','','','2022-06-25 15:55:13','2022-06-25 15:55:13');
INSERT INTO users VALUES('733','1','0','HARIS DILDAR ','27519818@logic.com','$2y$10$he06UbS8mq3LTmtgXhTIn.xBGKX2lv2O.kAPH8dxswy3dfHbrQima','Student','923401595604','1','students/profile.png','','','','','','2022-07-03 07:17:54','2022-07-03 07:17:54');
INSERT INTO users VALUES('734','1','0','MALIK MUHARAM ZEB ','15374725@logic.com','$2y$10$G8UzXWAOcOF.kzvNyuo9fu.UEws5ADzO7kQ/METVlpyUbZhS4Wx7.','Student','923109591324','0','students/profile.png','','','','','','2022-07-03 07:47:06','2022-07-03 08:36:36');
INSERT INTO users VALUES('735','1','0','MUHAMMAD SAJID RASHID ','4934095@logic.com','$2y$10$bOhfQo1HZSqC2.plAnS0sOaHB8plAoo00YJA1pivWJsFvUaq4E5NW','Student','923464116882','1','students/profile.png','','','','','','2022-07-03 11:16:56','2022-07-03 11:16:56');
INSERT INTO users VALUES('736','1','0','M WASEEM ASHRAF RANA ','24095334@logic.com','$2y$10$2/VgGi33EU0qAGKthRK0guWYPn.sJ1NGwlVlkdRU64dH4YyL9Kc7u','Student','923016196704','1','students/profile.png','','','','','','2022-07-14 10:11:22','2022-07-14 10:11:22');
INSERT INTO users VALUES('737','1','0','SYED ASIF ALI ','85862693@logic.com','$2y$10$W8LQ/ZQ/RnUHuvFyx0R3werEWhdFNpXFsiNBJWQTMILPWNySbJIuS','Student','923370613479','1','students/profile.png','','','','','','2022-07-14 10:17:49','2022-07-14 10:17:49');
INSERT INTO users VALUES('738','1','0','M HAMZA ','25718045@logic.com','$2y$10$RCPlNPVQtTqQNGWIzWkISeaP6jEG0vlNutU1X5STZHkCjva.Zcyp.','Student','923489666365','1','students/profile.png','','','','','','2022-07-14 10:34:49','2022-07-14 10:34:49');
INSERT INTO users VALUES('739','1','0','HADI HASSAN RAFIQUE ','98020490@logic.com','$2y$10$gBnVYHfuh5XXMfDZgL31HeBggfEDhrh.8honSTJYa1XRS.CbyXV8e','Student','923000881871','1','students/profile.png','','','','','','2022-07-14 10:46:40','2022-07-14 10:46:40');
INSERT INTO users VALUES('740','1','0','SARFRAZ NAWAZ ','35554160@logic.com','$2y$10$7r/thMNtVegTVVAxc2PiI.Svnw4JDg/SEbv.lBvEmKgBcyGbPS3n.','Student','923007377826','0','students/profile.png','','','','','','2022-07-16 06:16:40','2023-07-10 06:21:48');
INSERT INTO users VALUES('741','1','0','ADNAN MASUD ','68329230@logic.com','$2y$10$eB6ulzmLtcxBWOc4f02egeZt0ZSf.o4RHUIUHDtxOQe5u2KiXSVI2','Student','923333201211','1','students/profile.png','','','','','','2022-07-20 05:39:48','2022-07-20 05:39:48');
INSERT INTO users VALUES('742','1','0','ASAD IQBAL ','52468343@logic.com','$2y$10$5sTyrnqip.DnNrYjUH.3SOYFYxHBNxNgryEjyWXoDf5KCEoJ/Phye','Student','923335070107','1','students/profile.png','','','','','','2022-07-20 05:51:52','2022-07-20 05:51:52');
INSERT INTO users VALUES('743','1','0','CH ALI MURTAZA ','34065272@logic.com','$2y$10$7.t0GTPds53Rtq0Q2mzW7uejdz4AAQGxZciNXa86w98yQKKq7up4a','Student','923168527976','1','students/profile.png','','','','','','2022-07-20 05:58:12','2022-07-20 05:58:12');
INSERT INTO users VALUES('744','1','0','AHMAD NAEEM ','76118216@logic.com','$2y$10$xD/QXwjFHHae.mOslvlehe/c5UbmhDCLarU6yzRY6HU/AfP9b7zZK','Student','923378020086','0','students/profile.png','','','','','','2022-07-20 06:07:46','2023-05-11 09:01:36');
INSERT INTO users VALUES('745','1','0','M QAISAR ','85952566@logic.com','$2y$10$5bxJwJy6EuuK2BucFSTBqeIoYHRBGR.Hw9lIlrmtaSl.M6/CwGjqW','Student','923469367146','1','students/profile.png','','','','','','2022-07-21 09:54:14','2022-07-21 09:54:14');
INSERT INTO users VALUES('746','1','0','FAHAD NAEEM BABAR ','85352930@logic.com','$2y$10$OTVE7fWxTj.GTK4M1P9Ovuiv0LgkNN6VnB0ceG2tDK.Q9yrdfJP2G','Student','923075411764','1','students/profile.png','','','','','','2022-07-23 08:36:24','2022-07-23 08:36:24');
INSERT INTO users VALUES('747','1','0','SADDIQUE MUJTABA ','5102696@logic.com','$2y$10$QZGJxVFrPG57I.an8LBtBeZp/nqWtI0XRf9H9ohZeHrbHSqCxpyM2','Student','923359016712','1','students/profile.png','','','','','','2022-07-23 08:45:05','2022-07-23 08:45:05');
INSERT INTO users VALUES('748','1','0','DANIYAL MIR ','20631178@logic.com','$2y$10$q.cd2Ro.V31gN6tznmdeI.peaO2foBqfu//67clDwXyr8bTAMvEWy','Student','923085995390','1','students/profile.png','','','','','','2022-07-24 08:34:34','2022-07-24 08:34:34');
INSERT INTO users VALUES('749','1','0','KAMRAN HUSSAIN ','1536695@logic.com','$2y$10$vYBe.wW7rIqizOIveB0SI.Kgx3qYlwgiuOzH8rMsfD1TIXwhyb9we','Student','923129733366','0','students/profile.png','','','','','','2022-07-24 08:40:43','2022-08-06 16:37:37');
INSERT INTO users VALUES('750','1','0','ABID KHAN ','60307973@logic.com','$2y$10$.miUCicPXPQM.SwoLFypJe7I6kj9iK1WzwT.hDgrS8roEpe/m1bRi','Student','923403231673','0','students/profile.png','','','','','','2022-08-03 06:04:50','2022-11-16 17:16:43');
INSERT INTO users VALUES('751','1','0','M AQIL BHATTI ','37538584@logic.com','$2y$10$DeDFlno0jpkmThx3cXGUOerPSktRpubDnjaz1xI/OHmCE45xuvsJm','Student','923334372705','1','students/profile.png','','','','','','2022-08-06 16:42:44','2022-08-06 16:42:44');
INSERT INTO users VALUES('752','1','0','AHMAD FAROOQ ','87509632@logic.com','$2y$10$C.qsYZU8gPXnsm2VpxwHjuZRGy3OlILqRmQOkE/cUv0f6V2IxMNC6','Student','923409225100','1','students/profile.png','','','','','','2022-08-11 06:28:41','2022-08-11 06:28:41');
INSERT INTO users VALUES('753','1','0','ABDULLAH ','27918780@logic.com','$2y$10$XzZfkCbEFPuoCjFfbxwmDeSUGwLJNdyn01CiyVF1EdxgMrcz9b06a','Student','9233333336','0','students/profile.png','','','','','','2022-09-02 10:26:58','2022-09-03 17:42:12');
INSERT INTO users VALUES('754','1','0','AQEEL AHMAD ABBASI ','51855834@logic.com','$2y$10$ISRSkjiRl4YOZsExrrD2ue0IcwkNTm87cZv/Mr6JAL//FMoA3QQr2','Student','923462200062','1','students/profile.png','','','','','','2022-09-05 20:58:13','2022-09-05 20:58:13');
INSERT INTO users VALUES('755','1','0','NOMAN KHAN ','8683674@logic.com','$2y$10$Q.9a8Kac3HjFjNCZTbmc2.R92ZJOxCB2KeADgyDXMIOdto2GuehwO','Student','923431301146','0','students/profile.png','','','','','OBzXYeWPJm50SyaV9xi1N3SeI2TIGKE2CljvY5kn7xy2okXY5UvXWfRDXU7z','2022-09-05 21:22:51','2023-05-11 09:00:53');
INSERT INTO users VALUES('756','1','0','AMIR SOHAIL ','70654408@logic.com','$2y$10$r8ix1j50cdMGZtMAU0hx1ukf7bWjJosWSl6jhVxCnI9RAsjgP6pGC','Student','923499285597','1','students/profile.png','','','','','','2022-09-05 21:26:01','2022-09-05 21:26:01');
INSERT INTO users VALUES('757','1','0','ZAHID ALI KHAN ','1227354@logic.com','$2y$10$SB7foO5sKo9xQJqxPuQ42OmVuhuEy7EnIMG.GhmwW9X/bR.sbIyMS','Student','923017710200','1','students/profile.png','','','','','','2022-09-07 18:06:38','2022-09-07 18:06:38');
INSERT INTO users VALUES('758','1','0','SHAN ALI ','60678601@logic.com','$2y$10$GZ2AOx5gE.63QwXiDZqp6uagFf5OPKMhTDCr67rUx/0MxrWMQvE0W','Student','923007633339','1','students/profile.png','','','','','NllYkaGYQsXOHQMIYpHqDW4XqMqFgpJf8iWMdI5HDL2xqRvAX3FHf6IBMMea','2022-09-07 18:17:49','2023-04-06 10:04:26');
INSERT INTO users VALUES('759','1','0','SABIH UL HUSNAIN ','57693737@logic.com','$2y$10$c5kZYdomiwlzatPQHlLQ..18U.VfK5r7MuTwlmVDKr2/WlnVluuSu','Student','923331952157','1','students/profile.png','','','','','','2022-09-08 09:53:25','2022-09-08 09:53:25');
INSERT INTO users VALUES('760','1','0','Hassan Nisar ','74678010@logic.com','$2y$10$LT93t6SLvYNrzK/ic3sFI.VeGARW03fVIRLGZnQhCRAzETF.PJF8y','Student','923317891171','1','students/profile.png','','','','','','2022-11-03 06:26:38','2022-11-03 06:26:38');
INSERT INTO users VALUES('761','1','0','YASIR MUSTAFA ','93714518@logic.com','$2y$10$U2gWDQxSPUt8eM39JaLhnOxUyxmZMnknWnhh9ANLEapNMMW.OCgzi','Student','923214001845','1','students/profile.png','','','','','','2022-11-06 14:50:38','2022-11-06 14:50:38');
INSERT INTO users VALUES('762','1','0','Hamza Sahu ','40758331@logic.com','$2y$10$W5L4zezrM7QWKjGY8dczHuuUWoBM7G1BW64MUFnQ2dW1jFiQ6nyiS','Student','923440114254','1','students/profile.png','','','','','','2022-11-16 16:49:35','2022-11-16 16:49:35');
INSERT INTO users VALUES('763','1','0','Danyal Irshad ','21699463@logic.com','$2y$10$PbbktQ5ALPxZ/VJk49KN/OFVA2EqOIdjuZAzxOCKyjV5nRrU4jbEe','Student','923138691484','1','students/profile.png','','','','','','2022-11-16 17:02:12','2022-11-16 17:02:12');
INSERT INTO users VALUES('764','1','0','Waqar Ahmad ','59578682@logic.com','$2y$10$ColITLepMvXmPYXhKS/r3.Paa8fgEj0KuZZepigzRA7eOWEZo.rka','Student','923332515474','0','students/profile.png','','','','','','2022-11-16 17:24:21','2023-04-02 08:35:24');
INSERT INTO users VALUES('765','1','0','Abdul Moiz ','27795405@logic.com','$2y$10$HJLh51b3687x80FNn9VWSOcgejXXDe0Qvetlz2iwrnMhA7/faX1xe','Student','923349115535','1','students/profile.png','','','','','','2022-12-10 08:23:39','2023-08-09 06:55:42');
INSERT INTO users VALUES('766','1','0','Shayan Nasir ','76285198@logic.com','$2y$10$uYJd7v6unEwlwv2Jk2KLSO28BGQ2xUYZuahSrIcoVd/GYtH8DjiBi','Student','923479001960','0','students/profile.png','','','','','','2022-12-10 08:28:00','2023-04-02 08:33:42');
INSERT INTO users VALUES('767','1','0','NAEEM AHMAD SHEIKH ','73783847@logic.com','$2y$10$IMNQts.lXVznIpSzY9eECuZRjq9XlESAU2Eji9YMUOGHofNzBCJnm','Student','923332621996','1','students/profile.png','','','','','','2022-12-22 05:40:56','2022-12-22 05:40:56');
INSERT INTO users VALUES('768','1','0','TAZA GUL ','71637678@logic.com','$2y$10$hiaXoHQostyWVn3t12YiYeIromIlQwZFrF4.qTDQrhIyu/fcRLCDW','Student','923329394438','1','students/profile.png','','','','','','2023-01-06 10:43:31','2023-01-06 10:43:31');
INSERT INTO users VALUES('769','1','0','MUHAMMAD ZOHAIB KHAN ','30885734@logic.com','$2y$10$QNfbpDZVMzqPZf2UKWq.AOnkooN8H/PstpdUCEniak5S3iyLQN8Ny','Student','923241994597','1','students/profile.png','','','','','','2023-02-09 10:40:44','2023-08-09 06:57:08');
INSERT INTO users VALUES('770','1','0','MUHAMMAD TANVER ','70837907@logic.com','$2y$10$UPJBLdgQdg4vRq4a3w2gdumgMIGe05gOyN2GMxtfeB1LGcqSMJ9Hm','Student','923015780559','1','students/profile.png','','','','','','2023-03-07 12:52:23','2023-03-07 12:52:23');
INSERT INTO users VALUES('771','1','0','SALMAN KHAN ','4870141@logic.com','$2y$10$7KnjNAUtiDqpecwxjCj/6e.ND7QM51ZAVyFZ6eAM/XS.TShHpm/uu','Student','923339300881','0','students/profile.png','','','','','','2023-03-07 13:01:25','2023-04-02 08:31:23');
INSERT INTO users VALUES('772','1','0','Umair Ijaz ','96078089@logic.com','$2y$10$R8h8QVLJZQ7XcReDETpdmOSbvM0e738I7acZaIH.Iwe0x8VfySvBO','Student','923410067988','1','students/profile.png','','','','','','2023-04-07 15:16:55','2023-04-07 15:16:55');
INSERT INTO users VALUES('773','1','0','Usama Qayoum Kakar ','usamakakar97@gmail.com','$2y$10$bnyd96t1HsYRB1wBHKusR.sYxKLFbNybQTPRk8Cd2Dv99T9e96pGK','Student','923461234591','0','students/1681040087.PNG','','','','','','2023-04-09 11:15:56','2023-06-01 16:17:26');
INSERT INTO users VALUES('774','1','0','MUHAMMAD SOBAN BEHZAD ','61077864@logic.com','$2y$10$4yReUsvdhRfC37hS53.ofu6D2rMYK/V7.1vBcmHbJjSL1caRn3/MS','Student','923131600693','1','students/profile.png','','','','','','2023-04-09 21:30:16','2023-04-09 21:30:16');
INSERT INTO users VALUES('775','1','0','Adnan Aslam ','7038286@logic.com','$2y$10$vqyTzroV5gdEAriD6uSgzu3HJcmDmS8.1sgdRSASj8N2OZV1iCWdy','Student','923029363101','0','students/profile.png','','','','','','2023-05-11 09:07:23','2023-08-03 09:48:09');
INSERT INTO users VALUES('776','1','0','HASEEB HUSSAIN ','83550831@logic.com','$2y$10$cKYIkRx4WrgcXfyaro.Y8OHFW4CuyuwgwJlMpMda5wpTKXG3PCZWq','Student','929115164268','1','students/profile.png','','','','','','2023-05-23 10:53:47','2023-05-23 10:53:47');
INSERT INTO users VALUES('777','1','0','RASHID BASHIR ','90005674@logic.com','$2y$10$rxJtqdlgbYPfr0BmAAnSs.WXR.ryWXH1WuzwseQRfkDRG5K0axpdu','Student','923125424485','1','students/profile.png','','','','','','2023-06-01 16:09:43','2023-06-01 16:09:43');
INSERT INTO users VALUES('778','1','0','MUDASSAR KAMAL ','1777653@logic.com','$2y$10$KzDMhCMu.3A5TZMaVEUcBOF6Ej12NYTeHx2Q6ASJmHfhIVH4Os8H6','Student','923095092969','1','students/profile.png','','','','','','2023-06-01 16:33:26','2023-06-01 16:33:26');
INSERT INTO users VALUES('779','1','0','AHMED ZAHOOR ','51567738@logic.com','$2y$10$dCvr0Jt8mWIKGSyf.D7WNOHW017e7KUtLkBI584F3QIQmLxy3HIau','Student','923241480822','1','students/profile.png','','','','','','2023-06-15 08:34:15','2023-06-15 08:34:15');
INSERT INTO users VALUES('780','1','0','M Mehboob ','96490401@logic.com','$2y$10$V0FBsojhH1hTyYUIOAPKmuye/pY2vWPl9wncoRNN2B5kpJ6CjXB4m','Student','923048419121','1','students/profile.png','','','','','','2023-07-20 07:28:33','2023-07-20 07:28:33');
INSERT INTO users VALUES('781','1','0','GHULAM ALI ','96040232@logic.com','$2y$10$ptmWJVHmMrxhpXnzXjLypOeFIwQtqcco2qkYsUxuUm94oSS7Qj1Oa','Student','923134210421','1','students/profile.png','','','','','','2023-07-26 14:31:55','2023-07-26 14:31:55');
INSERT INTO users VALUES('782','1','0','MOTASIM BILLAH ','50237368@logic.com','$2y$10$u8WQhRk9YXF161YaFrth0ehlWQTYErgCdvxR.Ad1ewzOy262u3.ya','Student','923068019962','1','students/profile.png','','','','','','2023-07-28 15:32:45','2023-07-28 15:32:45');
INSERT INTO users VALUES('783','1','0','MUHAMMAD IMAD ','55349644@logic.com','$2y$10$VuKtj4O9DJK/Xx0HeJEFJe2HV3MvhDgOf8