@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-4">
            <div class="card card-signin my-5">
			    <div class="card-header text-center">
					{{ 'Sign In' }}
				</div>
                <div class="card-body">
                    <a href="{{url('/')}}"><img class="logo" style="
    width: 180px;" src="{{get_logo()}}"></a>
    <center><h2>{{get_school_name()}}</h2></center>
					<form method="POST" class="form-signin" action="{{ route('login') }}">
                        @csrf

                        <div class="form-group row">
                            <div class="col-md-12">
                                <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" placeholder="{{ 'Email' }}" required autofocus>

                                @if ($errors->has('email'))
                                    <span class="invalid-feedback">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
						    <div class="col-md-12">	

								<input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" placeholder="{{ 'Password' }}" required>

                                @if ($errors->has('password'))
                                    <span class="invalid-feedback">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
						
						<div class="custom-control custom-checkbox mb-3">
							<input type="checkbox" name="remember" class="custom-control-input" id="remember" {{ old('remember') ? 'checked' : '' }}>
							<label class="custom-control-label" for="remember">{{ 'Remember Me' }}</label>
						</div>

                        <div class="form-group row mb-0">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary btn-block">
                                    {{ 'Login' }}
                                </button>

                            </div>
                        </div>
						
						<!-- <div class="form-group row">
                            <div class="col-md-12 text-center">
								<a class="btn btn-link" href="{{ route('password.request') }}">
									{{ 'Forgot Password?' }}
								</a>
							</div>
                        </div> -->
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
