@extends('layouts.backend')

@section('content')

<form action="{{ url('/transactions/expense') }}" method="get" autocomplete="off" target="_blank">
	<div class="row">			
				<div class="col-md-5">
						<div class="form-group">
							<label class="control-label">{{ _lang('Date From') }}</label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="date" class="form-control date_from" name="date_from" id="date_from" value="">
							</div>
						</div>
				</div>
					
				<div class="col-md-5">
						<div class="form-group">
							<label class="control-label">{{ _lang('Date To') }}</label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="date" class="form-control date_to" name="date_to" id="date_to" value="">
							</div>
						</div>
				</div>

			<div class="col-md-2">
				<div class="form-group pull-right">
					<button type="button" onclick="getAllRecordsForTable();" style="margin-top:24px;" class="btn btn-success rect-btn">{{_lang('Generate')}}</button>
				</div>
			</div>
	</div>
</form>

<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			
			<div class="panel-heading"><span class="panel-title">{{ _lang('List Expense') }}</span>
			
		</div>
		<a style="margin:10px;" class="btn btn-primary btn-sm pull-left" data-title="{{ _lang('Add Expense') }}" href="{{ url('transactions/add_expense') }}">{{ _lang('Add New') }}</a>

			<div class="panel-body">
			 <!-- @if (\Session::has('success'))
			  <div class="alert alert-success">
				<p>{{ \Session::get('success') }}</p>
			  </div>
			  <br />
			 @endif -->

				<table id="tblRecords" class="table table-bordered">
						<thead>
							<tr>
								<!-- <th>{{ _lang('ID') }}</th> -->
								<th>{{ _lang('Date') }}</th>
								<th>{{ _lang('Account') }}</th>
								<th>{{ _lang('Expense Type') }}</th>
								<th>{{ _lang('Description') }}</th>
								<th>{{ _lang('Amount') }}</th>
								<th>{{ _lang('Payment Method') }}</th>
								<th>{{ _lang('Action') }}</th>
							</tr>
						</thead>
				</table>
			</div>
		</div>
	</div>
</div>

@endsection



@section('js-script')
<script>

function getAllRecordsForTable() 
{
	$("#preloader").css("display","block");
	var url="{{url('/transactions/expense')}}";
	url += "?date_from="+$('#date_from').val()+"&date_to="+$('#date_to').val();

	$('#tblRecords').DataTable().destroy();
	$.fn.dataTable.ext.errMode = 'none';    //Suppressing Warnings in DataTables
	$("#tblRecords").DataTable(
	{
	"processing": true, // for show progress bar
	// "serverSide": true, // for process server side
	"filter": true, // this is for disable filter (search box)
	"orderMulti": false, // for disable multiple column at once
	"pageLength": 25,               
	"initComplete": function (settings, json) {

		// console.log(json);

		$("#preloader").css("display","none");
	},

	"ajax": {

	"url": url,
	"type": "GET",
	"datatype":"json"
	},
	"columns": [                   
	// { "data": "id", name: 'id' },
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["trans_date"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["account_name"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["c_type"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["reference"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["amount"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["payment_method"]);
		}
	},
	{
		"data": null, class:'',width: '150px',
		"render": function (data, type, full, meta) {

			id = full["id"];
			var url="{{ url('transactions') }}";
			
			var formRoute = url+"/"+id;
			var showRoute = url+"/"+id;
			var editRoute = url+"/"+id+"/edit";

			var form='<form action="'+formRoute+'" method="post">';
			form += '<a href="'+editRoute+'" data-title="Update Expense" class="btn btn-warning btn-sm">Edit</a>';
			form += '<a href="'+showRoute+'" data-title="View Expense" class="btn btn-info btn-sm ajax-modal">View</a>';
			form += '{{ method_field('DELETE') }}';
			form += '@csrf';
			form += '<button type="submit" class="btn btn-danger btn-sm btn-remove" title="Delete Record">Delete</button>';
			form += '</form>';

			return form;
		},
		"orderable": false,
		"searchable": false
	},
	],
	"order": [[0, "asc", ]],
               "dom": '<"top"lf>rt<"bottom"Bip><"clear">',
               "buttons": [
                   {
                       extend: 'copy',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           //columns: ':visible'
                           columns: [0, 1, 2, 3, 4, 5]
                       },
                       text:'<i class="fa fa-clone"></i> Copy'
                   },
                   {
                       extend: 'excel',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           //columns: ':visible'
                           columns: [0, 1, 2, 3, 4, 5]
                       },
                       text: '<i class="fa fa-file-excel-o"></i> Excel'
                   },
                   {
                       extend: 'csv',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           //columns: ':visible'
                           columns: [0, 1, 2, 3, 4, 5]
                       },
                       text: '<i class="fa fa-file"></i> CSV'
                   },
                   {
                       extend: 'pdf',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           //columns: ':visible'
                           columns: [0, 1, 2, 3, 4, 5]
                       },
                       text: '<i class="fa fa-file-pdf-o"></i> PDF'
                   },
                   {
                       extend: 'print',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           //columns: ':visible'
                           columns: [0, 1, 2, 3, 4, 5]
                       },
                       text: '<i class="fa fa-print"></i> Print'
                   },
                   'colvis'

               ],
               //responsive: true

	});
}

$(document).ready(function () {

//Date settings
var now = new Date();
var day = ("0" + now.getDate()).slice(-2);
var month = ("0" + (now.getMonth() + 1)).slice(-2);
var date_from = now.getFullYear()+"-"+(month)+"-"+("01");
var date_to = now.getFullYear()+"-"+(month)+"-"+(day);
$('#date_from').val(date_from);
$('#date_to').val(date_to);

});

</script>
@stop