@extends('layouts.backend')
@section('content')
<style type="text/css">
.table > thead > tr > th, .table > tbody > tr > th, .table > tfoot > tr > th, .table > thead > tr > td, .table > tbody > tr > td, .table > tfoot > tr > td {
    padding: 2px;
    vertical-align: middle;
}
.table {
    margin-bottom: 10px;
}
</style>
<div class="row">
	<div class="col-lg-4 col-sm-6">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-xs-4">
						<div class="icon-big icon-warning text-center">
							<i class="ti-user"></i>
						</div>
					</div>
					<div class="col-xs-8">
						<div class="numbers">
							<p>{{ _lang('Student Capacity') }}</p>
							{{ total_student_capacity() }}
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>	
	<div class="col-lg-4 col-sm-6">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-xs-4">
						<div class="icon-big icon-danger text-center">
							<i class="ti-user"></i>
						</div>
					</div>
					<div class="col-xs-8">
						<div class="numbers">
							<p>{{ _lang('Occupied Seats') }}</p>
							{{ total_student_occupied() }}
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-lg-4 col-sm-6">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-xs-4">
						<div class="icon-big icon-info text-center">
							<i class="ti-user"></i>
						</div>
					</div>
					<div class="col-xs-8">
						<div class="numbers">
							<p>{{ _lang('Vacant Seats') }}</p>
							{{ total_student_vacant() }}
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row">
   <div class="col-md-4">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-md-5">
						<div class="icon-big icon-primary text-center">
							<i class="ti-credit-card"></i>
						</div>
					</div>
					<div class="col-md-7">
						<div class="numbers">
							<p>{{ _lang('Monthly Student Payments') }}</p>
								{{ $currency." ".$student_payments }}
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

   <div class="col-md-4">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-md-5">
						<div class="icon-big icon-success text-center">
							<i class="ti-credit-card"></i>
						</div>
					</div>
					<div class="col-md-7">
						<div class="numbers">
							<p>{{ _lang('Current Others Income') }}</p>
							{{ $currency." ".$monthly_income }}
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

   <div class="col-md-4">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-md-5">
						<div class="icon-big icon-danger text-center">
							<i class="ti-credit-card"></i>
						</div>
					</div>
					<div class="col-md-7">
						<div class="numbers">
							<p>{{ _lang('Current Month Expense') }}</p>
							{{ $currency." ".$monthly_expense }}
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	@foreach($monthly_totals as $total)
		<div class="col-md-4">
			<div class="card">
				<div class="content">
					<div class="row">
						<div class="col-md-5">
							<div class="icon-big icon-warning text-center">
								<i class="ti-credit-card"></i>
							</div>
						</div>
						<div class="col-md-7">
							<div class="numbers">
								<p>Monthly {{ $total->trans_type }} {{ $total->account_name }}</p>
								{{ $currency." ".number_format($total->total, 2) }}
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
    @endforeach

	@foreach($monthly_chart_totals as $total)
		<div class="col-md-4">
			<div class="card">
				<div class="content">
					<div class="row">
						<div class="col-md-5">
							<div class="icon-big icon-warning text-center">
								<i class="ti-credit-card"></i>
							</div>
						</div>
						<div class="col-md-7">
							<div class="numbers">
								<p>Monthly {{ $total->trans_type }} {{ $total->name }}</p>
								{{ $currency." ".number_format($total->total, 2) }}
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	@endforeach
</div>
@if(count($total_class)>0)
<div class="row">
	@foreach($total_class as $class)
	<div class="col-lg-4">
		<div class="card">
			<div class="row">
				<div class="col-md-12">
					<p>{{$class->class_name}}</p>
				</div>
				<div class="col-md-12">
					@if(count($class->class_section)>0)
					<table class="table table-bordered">
						<thead>
							<tr>	
								<th class="text-center">Room</th>
								<th class="text-center">Capacity</th>
								<th class="text-center">Vacant</th>
							</tr>
						</thead>
						<tbody>
							@foreach($class->class_section as $section)
							<tr>	
								<td class="text-center">{{$section->section_name}}</td>
								<td class="text-center">{{$section->capacity}}</td>
								
									@php 
									$per = $section->capacity/100;
									$percentage = ($section->capacity-section_wise_occupied($section->id))/$per;
									@endphp

									@if($percentage<1)
									<td class="text-center" style="background: red;color: #fff;">
										{{$section->capacity-section_wise_occupied($section->id)}}
									</td>
									@elseif($percentage>0 && $percentage<26)
									<td class="text-center" style="background: orange;color: #000;">
									{{$section->capacity-section_wise_occupied($section->id)}}</td>
									@elseif($percentage>25 && $percentage<51)
									<td class="text-center" style="background: yellow;color: #000;">
									{{$section->capacity-section_wise_occupied($section->id)}}</td>
									@elseif($percentage>50 && $percentage<76)
									<td class="text-center" style="background: lightgreen;color: #000;">
									{{$section->capacity-section_wise_occupied($section->id)}}</td>
									@elseif($percentage>75)
									<td class="text-center" style="background:green;color: #fff;">
									{{$section->capacity-section_wise_occupied($section->id)}}</td>
									@else
									<td class="text-center">
									{{$section->capacity-section_wise_occupied($section->id)}}</td>
									@endif
							</tr>
							@endforeach
						</tbody>
					</table>
					@else
					<small class="text-danger">Section not found!</small>
					@endif
				</div>
			</div>
		</div>
	</div>
	@endforeach
</div>
@endif


<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="header">
				<h4 class="title text-center">{{ _lang('Income and Expense Summary of')." ".date("Y") }}</h4>
			</div>
			<div class="content">
				<div id="income_vs_expense_chart" style="width: 100%; height:400px;"></div>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="header">
				<h4 class="title text-center">{{ _lang('Notice') }}</h4>
			</div>
			<div class="content no-export">
				<table class="table table-bordered data-table">
				   <thead>
				     <th>{{ _lang('Notice') }}</th>
				     <th>{{ _lang('Created') }}</th>
				     <th class="text-center">{{ _lang('View') }}</th>
				   </thead>
				   <tbody>
						@foreach(get_notices("Admin",100) as $notice)
						  <tr>
							<td>{{ $notice->heading }}</td>
							<td>{{ date("d M, Y - H:i", strtotime($notice->created_at)) }}</td>
						    <td class="text-center"><a href="{{ action('NoticeController@show', $notice->id) }}" data-title="{{ _lang('View Notice') }}" class="btn btn-primary btn-sm ajax-modal">{{ _lang('View Notice') }}</a></td>
						  </tr>
						@endforeach
				   </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
  var yearly_income = {{ $yearly_income }};
  var yearly_expense = {{ $yearly_expense }};
</script>

@endsection

@section('js-script')
<script>

  $(document).ready(function() {

  });

</script>
@endsection