<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Daily Fee Receipt Report</title>
    @include('backend.pdf.layouts.css')
</head>
<body >
@include('backend.pdf.layouts.report-header')
<main>


    <table class="table" width="100%" cellspacing="0">
        <thead>
        <tr>
        	<th style="text-align: left;" width="10%">{{_lang('Sr.')}}</th>
        	<th style="text-align: left;" width="15%">{{_lang('Reg #')}}</th>
        	<th style="text-align: left;" width="15%">{{_lang('Date')}}</th>
            <th style="text-align: left;" width="40%">{{_lang('Student Information')}}</th>
        	<th class="text-right" width="20%">{{_lang('Amount Received')}}</th>
        </tr>
        </thead>
        <tbody>
            @if(count($accounts)>0)
            @php $total =0; @endphp
            @php $grand_total =0; @endphp
            @foreach($accounts as $account)
            <tr class="bg-account-head text-black">
                <th style="text-align: left;" colspan="5"><h3 style="padding: 0px 0px;margin: 0px;font-size: 17px;font-family: system-ui;letter-spacing: 0.7px;font-weight: 700;">{{$account->account_name}}</h3></th>
            </tr>
            	@if(count($transactions)>0)
            	@foreach($transactions as $key => $transaction)
                @if($account->id ==$transaction->account_id)
                @php $total =$total+$transaction->amount; @endphp
            	<tr>
                    <td style="text-align: left;">{{++$key}}</td>
                    <td style="text-align: left;">{{@$transaction->student_info->register_no}}</td>
                    <td style="text-align: left;">{{date('d-M-Y',strtotime($transaction->trans_date))}}</td>
                    <td style="text-align: left;">{{@$transaction->student_info->id}}-{{@$transaction->student_info->first_name}}</td>
    	        	<td class="text-right">{{number_format($transaction->amount,2)}}</td>
                </tr>
                @endif
                @endforeach
                @endif
                <tr class="bg-account-head text-black">
                    <th style="text-align: right;" colspan="5"><h3 style="padding: 0px 0px;margin: 0px;font-size: 17px;font-family: system-ui;letter-spacing: 0.7px;font-weight: 700;">{{number_format($total,2)}}</h3></th>
                </tr>

            @php 
            $grand_total =$grand_total+$total;
            $total=0; 
            @endphp
            @endforeach
            @endif
        </tbody>
        <tfoot>            
            <tr class="bg-secondary text-white">
                <th style="text-align: right;" colspan="4"><h3 style="padding: 0px 0px;margin: 0px;font-size: 17px;font-family: system-ui;letter-spacing: 0.7px;font-weight: 700;">Grand Total:</h3></th>
                <th style="text-align: right;"><h3 style="padding: 0px 0px;margin: 0px;font-size: 17px;font-family: system-ui;letter-spacing: 0.7px;font-weight: 700;">{{number_format($grand_total,2)}}</h3></th>
            </tr>
        </tfoot>
    </table>


</main>
@include('backend.pdf.layouts.footer')
</body>
</html>
