<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Fee Definition Report(Student Wise)</title>
    @include('backend.pdf.layouts.css')
</head>
<body >
@include('backend.pdf.layouts.report-header')
<main>


    <table class="table" width="100%" cellspacing="0">
        <thead>
        <tr>
        	<th style="text-align: left;" width="15%">{{_lang('SL#')}}</th>
        	<th style="text-align: left;" width="35%">{{_lang('Student Information')}}</th>
            <th style="text-align: left;" width="15%">{{_lang('Father Name')}}</th>
        	@if(count($fees)>0)
        	@foreach($fees as $fee)
        	<th class="text-right" width="8%">{{$fee->fee_type}}</th>
        	@endforeach
        	<th class="text-right" width="10%">{{_lang('Total')}}</th>
        	@endif
        </tr>
        </thead>
        <tbody>
        	@if(count($students)>0)
            @php $grand_total = 0; @endphp
        	@foreach($students as $key=>$student)
        	<tr>
                <th style="text-align: left;">{{++$key}}</th>
                <th style="text-align: left;">{{$student->register_no}}-{{$student->first_name}}-{{$student->class_name}}-{{$student->section_name}}</th>
                <th style="text-align: left;">{{$student->father_name}}</th>
                @if(count($fees)>0)
                @php $total = 0; @endphp
		        @foreach($fees as $fee)
		        	@if(count($student->AssignFees)>0)

			        	@php $item_price=0; @endphp
			        	@foreach($student->AssignFees as $item)
				        	@if($item->fee_id == $fee->id)
				        	@php $item_price = ($item->amount - $item->discount); @endphp
				        	@endif
			        	@endforeach
			        	@if(!empty($item_price))
			        	@php $total = $total+$item_price; @endphp
            			<td class="text-right">{{$item_price}}</td>
			        	@else
			        	<td class="text-right">0</td>
			        	@endif
		        	@else
		        	<td class="text-right">0</td>

		        	@endif
	        	@endforeach
	        	<td class="text-right">{{$total}}</td>
                @php $grand_total = $grand_total+$total; @endphp
	        	@endif
            </tr>
            @endforeach
            <tr>
                @if(count($fees)>0)
                @foreach($fees as $fee)
                <th></th>
                @endforeach
                @endif
                <th class="text-right" colspan="3">Grand Total:</th>
                <th class="text-right">{{$grand_total}}</th>
            </tr>
            @endif
        </tbody>
    </table>


</main>
@include('backend.pdf.layouts.footer')
</body>
</html>
