<form method="post" class="ajax-submit" autocomplete="off" action="{{route('student_payments.store')}}" enctype="multipart/form-data">
	{{ csrf_field() }}
						
	<input type="hidden" class="form-control" name="invoice_id" value="{{ $invoice_id }}" required>
    @php $currency = get_option('currency_symbol'); @endphp
	
	@if(!empty($history))
	<div class="col-md-12">
		<table class="table table-bordered">
		    <thead>
			   <th colspan="3" class="text-center">{{ _lang('Payment History') }}</th>
			</thead>
			<thead>
			   <th>{{ _lang('Date') }}</th>
			   <th>{{ _lang('Amount') }}</th>
			   <th>{{ _lang('Note') }}</th>
			</thead>
			<tbody>
			@foreach($history as $payment)
			   <tr>
			     <td>{{ $payment->date }}</td>
			     <td>{{ $currency." ".$payment->amount }}</td>
			     <td>{{ $payment->note }}</td>
			   </tr>
			@endforeach
			</tbody>
		</table>
	</div>	
	@endif
	@if($invoice->status=="Unpaid")
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label">{{ _lang('Student Total Balance')." ".$currency }}</label>						
		<input type="text" class="form-control" value="{{ \App\Invoice::where('student_id',$invoice->student_id)->sum('total') - \App\Invoice::where('student_id',$invoice->student_id)->sum('paid') }}" readOnly="true">
	  </div>
	</div>
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label">{{ _lang('Total Amount')." ".$currency }}</label>						
		<input type="text" class="form-control" value="{{ $invoice->total }}" readOnly="true">
	  </div>
	</div>
	
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label">{{ _lang('Total Paid')." ".$currency }}</label>						
		<input type="text" class="form-control" value="{{ $invoice->paid }}" readOnly="true">
	  </div>
	</div>

	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label">{{ _lang('Payable Amount')." ".$currency }}</label>						
		<input type="number" class="form-control float-field" name="amount" value="{{ $invoice->total-$invoice->paid }}" max="{{ $invoice->total-$invoice->paid }}" required>
	  </div>
	</div>
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label">{{ _lang('Date') }}</label>						
		<input type="text" class="form-control datepicker" name="date" value="{{ old('date') }}" required>
	  </div>
	</div>
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label">{{ _lang('Account') }}</label>						
		<select class="form-control select2" name="account_id" required>
			{{ create_option("bank_cash_accounts","id","account_name",old('account_id')) }}
		</select>
	  </div>
	</div>
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label">{{ _lang('Income Type') }}</label>						
		<select class="form-control select2" name="chart_id" required>
			{{ create_option("chart_of_accounts","id","name",old('chart_id'),array("type="=>"income")) }}
		</select>
	  </div>
	</div>

	<input type="hidden" name="trans_type" value="income">
	<input type="hidden" name="trans_source_type" value="Student">
	<input type="hidden" name="dr_cr" value="cr">

	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label">{{ _lang('Payment Method') }}</label>						
		<select class="form-control select2" name="payment_method_id">
			{{ create_option("payment_methods","id","name",old('payment_method_id')) }}
		</select>
	  </div>
	</div>
	

	<div class="col-md-12">
	  <div class="form-group">
		<label class="control-label">{{ _lang('Note') }}</label>						
		<textarea class="form-control" name="note">{{ old('note') }}</textarea>
	  </div>
	</div>

				
	<div class="col-md-12">
	  <div class="form-group">
		<button type="submit" class="btn btn-primary">{{ _lang('Save') }}</button>
	  </div>
	</div>
	@endif
</form>
