
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<span class="panel-title" >
					<?php echo e(_lang('Student Attendance')); ?>

				</span>
			</div>
			<div class="panel-body">
				<form id="search_form" class="params-panel validate" action="<?php echo e(url('student/attendance')); ?>" method="post" autocomplete="off" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<div class="col-sm-3">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Floor')); ?></label>
							<select name="class_id" class="form-control select2" onChange="getData(this.value);" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<?php echo e(create_option('classes','id','class_name',$class_id)); ?>

							</select>
						</div>
					</div>
					<div class="col-sm-3">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Room')); ?></label>
							<select name="section_id" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<?php echo e(create_option('sections','id','section_name',$section_id)); ?>

							</select>
						</div>
					</div>
					<div class="col-sm-3">
						<div class="form-group">
							<label for="date" class="control-label">Date</label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="text" class="form-control datepicker" name="date" value="<?php echo e($date); ?>" required>
						    </div>
						</div>
					</div>
					<div class="col-sm-3">
						<div class="form-group">
							<button type="submit" style="margin-top:24px;" class="btn btn-primary btn-block rect-btn"><?php echo e(_lang('Manage Attendance')); ?></button>
						</div>
					</div>
				</form>
				<?php if( !empty($attendance) ): ?>	
				<div class="col-md-12" id="attendance">	
					<div class="panel-heading text-center">
						<div class="panel-title" >
							<?php echo e(_lang('Attendance For Class')); ?> <?php echo e($class); ?><br>
							<?php echo e(_lang('Section')." ".$section); ?> <br>
							<?php echo e(date('d-M-Y', strtotime($date))); ?><br>
						</div>
					</div>
					<form action="<?php echo e(url('student/attendance/save')); ?>" class="appsvan-submit-validate" method="post" accept-charset="utf-8">
						<?php echo csrf_field(); ?>
						<table class="table table-bordered">
							<thead>
								<th><?php echo e(_lang('Name')); ?></th>
								<th><?php echo e(_lang('Roll')); ?></th>
								<th><label class="c-container"><?php echo e(_lang('Present')); ?><input type="checkbox" id="present_all" onclick="present(this)"><span class="checkmark"></span></label></th>
								<th><label class="c-container"><?php echo e(_lang('Absent')); ?><input type="checkbox" id="absent_all" onclick="absent(this)"><span class="checkmark"></span></label></th>
								<th><label class="c-container"><?php echo e(_lang('Late')); ?><input type="checkbox" id="late_all" onclick="late(this)"><span class="checkmark"></span></label></th>
								<th><label class="c-container"><?php echo e(_lang('Holiday')); ?><input type="checkbox" id="holiday_all" onclick="holiday(this)"><span class="checkmark"></span></label></th>
							</thead>
							<tbody>
								<?php $__currentLoopData = $attendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($data->first_name." ".$data->last_name); ?></td>
									<input type="hidden" name="student_id[]" value="<?php echo e($data->student_id); ?>">
									<input type="hidden" name="class_id[]" value="<?php echo e($data->class_id); ?>">
									<input type="hidden" name="section_id[]" value="<?php echo e($data->section_id); ?>">
									<input type="hidden" name="date" value="<?php echo e($date); ?>">
									<input type="hidden" name="attendance_id[]" value="<?php echo e($data->attendance_id); ?>">
									<td><?php echo e($data->roll); ?></td>
									<td><label class="c-container"><input type="checkbox" name="attendance[<?php echo e($key); ?>][]" <?php if($data->attendance=='1'): ?> checked <?php endif; ?> value="1" class="present"><span class="checkmark"></span></label></td>
									<td><label class="c-container"><input type="checkbox" name="attendance[<?php echo e($key); ?>][]" <?php if($data->attendance=='2'): ?> checked <?php endif; ?> value="2" class="absent"><span class="checkmark"></span></label></td>
									<td><label class="c-container"><input type="checkbox" name="attendance[<?php echo e($key); ?>][]" <?php if($data->attendance=='3'): ?> checked <?php endif; ?> value="3" class="late"><span class="checkmark"></span></label></td>
									<td><label class="c-container"><input type="checkbox" name="attendance[<?php echo e($key); ?>][]" <?php if($data->attendance=='4'): ?> checked <?php endif; ?> value="4" class="holiday"><span class="checkmark"></span></label></td>
								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								
								<tr>
								  <td colspan="100"><button type="submit" class="btn btn-primary pull-right"><?php echo e(_lang('Save Attendance')); ?></button></td>
								</tr>
							</tbody>
						</table>
					</form>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script type="text/javascript">
	function getData(val) {
		var _token=$('input[name=_token]').val();
		var class_id=$('select[name=class_id]').val();
		$.ajax({
			type: "POST",
			url: "<?php echo e(url('sections/section')); ?>",
			data:{_token:_token,class_id:class_id},
			beforeSend: function(){
				$("#preloader").css("display","block");
			},success: function(sections){
				$("#preloader").css("display","none");
				$('select[name=section_id]').html(sections);				
			}
		});
	}

	$("input:checkbox").on('click', function() {
		
		var $box = $(this);
		if ($box.is(":checked")) {
			var group = "input:checkbox[name='" + $box.attr("name") + "']";
			$(group).prop("checked", false);
			$box.prop("checked", true);
		} else {
			$box.prop("checked", false);
		}
	});

	function present(source) {
		$(".absent,.late,.present,.holiday,#late_all,#absent_all,#holiday_all").prop("checked",false);
		var checkboxes = document.querySelectorAll('.present');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}
	function absent(source) {
		$(".absent,.late,.present,.holiday,#present_all,#late_all,#holiday_all").prop("checked",false);
		var checkboxes = document.querySelectorAll('.absent');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}
	function late(source) {
		$(".absent,.late,.present,.holiday,#present_all,#absent_all,#holiday_all").prop("checked",false);
		var checkboxes = document.querySelectorAll('.late');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}
	
	function holiday(source) {
		$(".absent,.late,.present,.holiday,#present_all,#absent_all").prop("checked",false);
		var checkboxes = document.querySelectorAll('.holiday');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>