<form method="post" class="ajax-submit" autocomplete="off" action="<?php echo e(route('student_payments.store')); ?>" enctype="multipart/form-data">
	<?php echo e(csrf_field()); ?>

						
	<input type="hidden" class="form-control" name="invoice_id" value="<?php echo e($invoice_id); ?>" required>
    <?php $currency = get_option('currency_symbol'); ?>
	
	<?php if(!empty($history)): ?>
	<div class="col-md-12">
		<table class="table table-bordered">
		    <thead>
			   <th colspan="3" class="text-center"><?php echo e(_lang('Payment History')); ?></th>
			</thead>
			<thead>
			   <th><?php echo e(_lang('Date')); ?></th>
			   <th><?php echo e(_lang('Amount')); ?></th>
			   <th><?php echo e(_lang('Note')); ?></th>
			</thead>
			<tbody>
			<?php $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			   <tr>
			     <td><?php echo e($payment->date); ?></td>
			     <td><?php echo e($currency." ".$payment->amount); ?></td>
			     <td><?php echo e($payment->note); ?></td>
			   </tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		</table>
	</div>	
	<?php endif; ?>
	<?php if($invoice->status=="Unpaid"): ?>
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label"><?php echo e(_lang('Student Total Balance')." ".$currency); ?></label>						
		<input type="text" class="form-control" value="<?php echo e(\App\Invoice::where('student_id',$invoice->student_id)->sum('total') - \App\Invoice::where('student_id',$invoice->student_id)->sum('paid')); ?>" readOnly="true">
	  </div>
	</div>
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label"><?php echo e(_lang('Total Amount')." ".$currency); ?></label>						
		<input type="text" class="form-control" value="<?php echo e($invoice->total); ?>" readOnly="true">
	  </div>
	</div>
	
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label"><?php echo e(_lang('Total Paid')." ".$currency); ?></label>						
		<input type="text" class="form-control" value="<?php echo e($invoice->paid); ?>" readOnly="true">
	  </div>
	</div>

	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label"><?php echo e(_lang('Payable Amount')." ".$currency); ?></label>						
		<input type="number" class="form-control float-field" name="amount" value="<?php echo e($invoice->total-$invoice->paid); ?>" max="<?php echo e($invoice->total-$invoice->paid); ?>" required>
	  </div>
	</div>
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label"><?php echo e(_lang('Date')); ?></label>						
		<input type="text" class="form-control datepicker" name="date" value="<?php echo e(old('date')); ?>" required>
	  </div>
	</div>
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label"><?php echo e(_lang('Account')); ?></label>						
		<select class="form-control select2" name="account_id" required>
			<?php echo e(create_option("bank_cash_accounts","id","account_name",old('account_id'))); ?>

		</select>
	  </div>
	</div>
	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label"><?php echo e(_lang('Income Type')); ?></label>						
		<select class="form-control select2" name="chart_id" required>
			<?php echo e(create_option("chart_of_accounts","id","name",old('chart_id'),array("type="=>"income"))); ?>

		</select>
	  </div>
	</div>

	<input type="hidden" name="trans_type" value="income">
	<input type="hidden" name="trans_source_type" value="Student">
	<input type="hidden" name="dr_cr" value="cr">

	<div class="col-md-6">
	  <div class="form-group">
		<label class="control-label"><?php echo e(_lang('Payment Method')); ?></label>						
		<select class="form-control select2" name="payment_method_id">
			<?php echo e(create_option("payment_methods","id","name",old('payment_method_id'))); ?>

		</select>
	  </div>
	</div>
	

	<div class="col-md-12">
	  <div class="form-group">
		<label class="control-label"><?php echo e(_lang('Note')); ?></label>						
		<textarea class="form-control" name="note"><?php echo e(old('note')); ?></textarea>
	  </div>
	</div>

				
	<div class="col-md-12">
	  <div class="form-group">
		<button type="submit" class="btn btn-primary"><?php echo e(_lang('Save')); ?></button>
	  </div>
	</div>
	<?php endif; ?>
</form>
