<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<div class="panel-title" >
					<?php echo e(_lang('Add New User')); ?>

				</div>
			</div>
			<div class="panel-body">
			  <div class="col-md-8">
				<form action="<?php echo e(route('users.store')); ?>" class="form-horizontal form-groups-bordered validate" autocomplete="off" enctype="multipart/form-data" method="post" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Name')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="name" value="<?php echo e(old('name')); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Email')); ?></label>
						<div class="col-sm-9">
							<input type="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Phone')); ?></label>
						<div class="col-sm-9">
							<input type="phone" class="form-control" name="phone" value="<?php echo e(old('phone')); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Password')); ?></label>
						<div class="col-sm-9">
							<input type="password" class="form-control" name="password" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Confirm Password')); ?></label>
						<div class="col-sm-9">
							<input type="password" class="form-control" name="password_confirmation" required>
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('User Type')); ?></label>
						<div class="col-sm-9">
							<select name="user_type" id="user_type" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<option value="Admin"><?php echo e(_lang('Admin')); ?></option>
								<option value="Accountant"><?php echo e(_lang('Accountant')); ?></option>
								<option value="Librarian"><?php echo e(_lang('Librarian')); ?></option>
								<option value="Employee"><?php echo e(_lang('Employee')); ?></option>
								<option value="Teacher" disabled><?php echo e(_lang('Teacher')); ?></option>
							</select>
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Permission Role')); ?></label>
						<div class="col-sm-9">
							<select name="role_id" id="role_id" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<option value="0"><?php echo e(_lang('Default')); ?></option>
								<?php echo e(create_option("permission_roles","id","role_name")); ?>

							</select>
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Profile')); ?></label>
						<div class="col-sm-9">
							<input type="file" class="form-control dropify" name="image" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Facebook Link')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="facebook" value="<?php echo e(old('facebook')); ?>">
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Twitter Link')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="twitter" value="<?php echo e(old('twitter')); ?>">
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Linkedin Link')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="linkedin" value="<?php echo e(old('linkedin')); ?>">
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Google Plus Link')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="google_plus" value="<?php echo e(old('google_plus')); ?>">
						</div>
					</div>

					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-5">
							<button type="submit" class="btn btn-info"><?php echo e(_lang('Add User')); ?></button>
						</div>
					</div>
				</form>
			  </div>	
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
	$("#user_type").val("<?php echo e(old('user_type')); ?>");
	$("#role_id").val("<?php echo e(old('role_id')); ?>");
</script>	
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>