
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-4 col-sm-6">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-xs-5">
						<div class="icon-big icon-warning text-center">
							<i class="ti-user"></i>
						</div>
					</div>
					<div class="col-xs-7">
						<div class="numbers">
							<p><?php echo e(_lang('Total Student')); ?></p>
							<?php echo e($total_student); ?>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-lg-4 col-sm-6">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-xs-5">
						<div class="icon-big icon-success text-center">
							<i class="ti-ruler-pencil"></i>
						</div>
					</div>
					<div class="col-xs-7">
						<div class="numbers">
							<p><?php echo e(_lang('My Subject')); ?></p>
							<?php echo e($my_subject_count); ?>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-lg-4 col-sm-6">
		<a href="<?php echo e(url('message/inbox')); ?>">
			<div class="card">
				<div class="content">
					<div class="row">
						<div class="col-xs-5">
							<div class="icon-big icon-danger text-center">
								<i class="ti-email"></i>
							</div>
						</div>
						<div class="col-xs-7">
							<div class="numbers">
								<p><?php echo e(_lang('Unread Inbox')); ?></p>
								<?php echo e(count_inbox()); ?>

							</div>
						</div>
					</div>
				</div>
			</div>
		</a>
	</div>

</div>

<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="header">
				<h4 class="title text-center"><?php echo e(_lang('Notice')); ?></h4>
			</div>
			<div class="content no-export">
				<table class="table table-bordered data-table">
				   <thead>
				     <th><?php echo e(_lang('Notice')); ?></th>
				     <th><?php echo e(_lang('Created')); ?></th>
				     <th class="text-center"><?php echo e(_lang('View')); ?></th>
				   </thead>
				   <tbody>
						<?php $__currentLoopData = get_notices("Teacher",100); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						  <tr>
							<td><?php echo e($notice->heading); ?></td>
							<td><?php echo e(date("d M, Y - H:i", strtotime($notice->created_at))); ?></td>
						    <td class="text-center"><a href="<?php echo e(action('NoticeController@show', $notice->id)); ?>" data-title="<?php echo e(_lang('View Notice')); ?>" class="btn btn-primary btn-sm ajax-modal"><?php echo e(_lang('View Notice')); ?></a></td>
						  </tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				   </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="header">
				<h4 class="title text-center"><?php echo e(_lang('Event Calendar')); ?></h4>
			</div>
			<div class="content">
				<div id='event_calendar'></div>
			</div>
		</div>
	</div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>

  $(document).ready(function() {

    $('#event_calendar').fullCalendar({
		themeSystem: 'bootstrap4',	
		header: {
			left: 'prev,next today',
			center: 'title',
			right: 'month,basicWeek,basicDay'
		},
		//defaultDate: '2018-03-12',
		eventBackgroundColor: "#0984e3",
		navLinks: true, // can click day/week names to navigate views
		editable: true,
		eventLimit: true, // allow "more" link when too many events
		timeFormat: 'h:mm',
		events: [
			<?php $__currentLoopData = get_events(100); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				{
				  title: '<?php echo e($event->name); ?>',
				  start: '<?php echo e($event->start_date); ?>',
				  end: '<?php echo e($event->end_date); ?>',
				  url: '<?php echo e(action("EventController@show", $event->id)); ?>'
				},
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	   ],
	   eventRender: function eventRender(event, element, view) {
		   element.addClass('ajax-modal');
		   element.data("title","<?php echo e(_lang('View Event')); ?>");
	   }
    });
	
	

  });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>