
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading">
				<span class="panel-title"><?php echo e(_lang('Students List')); ?></span>
			
				<select id="class" class="select_class pull-right" onchange="showClass(this);">
				   <option value="all"><?php echo e(_lang('Select Floor')); ?></option>
				   <?php echo e(create_option('classes','id','class_name',$class)); ?>

				</select>
				<select id="studentStatus" class="select_class pull-right" onchange="showClass(this);">
				   <option value="all"><?php echo e(_lang('All')); ?></option>
				   <option value="1"><?php echo e(_lang('Active')); ?></option>
				   <option value="0"><?php echo e(_lang('Inactive')); ?></option>
				</select>
				<a href="<?php echo e(route('students.create')); ?>" class="btn btn-primary btn-sm pull-right"><?php echo e(_lang('Add New Student')); ?></a>
			</div>
				
			<div class="panel-body">
				<table class="table table-bordered data-table">
					<thead>
						<th><?php echo e(_lang('Profile')); ?></th>
						<th><?php echo e(_lang('CNIC')); ?></th>
						<th><?php echo e(_lang('Name')); ?></th>
						<th><?php echo e(_lang('Address')); ?></th>
						<th><?php echo e(_lang('Rooms')); ?></th>
						<th><?php echo e(_lang('Cell #')); ?></th>
						<th><?php echo e(_lang('Status')); ?></th>
						<th><?php echo e(_lang('ID Card')); ?></th>
						<th><?php echo e(_lang('Action')); ?></th>
					</thead>
					<tbody>
						<?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td><img src="<?php echo e(asset('public/uploads/images/'.$data->image)); ?>" width="50px" alt=""></td>
							<td><?php echo e($data->activities); ?></td>
							<td><?php echo e($data->name); ?></td>
							<td><?php echo e($data->address); ?></td>
							<td><?php echo e($data->section_name); ?></td>
							<td><?php echo e($data->phone); ?></td>
					    	<?php if($data->status): ?>
						        <th><?php echo e(_lang('Active')); ?></th>
						    <?php else: ?>
						        <th><?php echo e(_lang('Inactive')); ?></th>
							<?php endif; ?>
							<td><a href="<?php echo e(url('students/id_card/'.$data->id)); ?>" class="btn btn-primary btn-sm ajax-modal"><?php echo e(_lang('View')); ?></a></td>
							
							<td>	
								<form action="<?php echo e(route('students.destroy',$data->id)); ?>" method="post">
									<a href="<?php echo e(route('students.show',$data->id)); ?>" class="btn btn-info btn-xs"><i class="fa fa-eye" aria-hidden="true"></i></a>
								    <a href="<?php echo e(route('students.edit',$data->id)); ?>" class="btn btn-warning btn-xs"><i class="fa fa-pencil" aria-hidden="true"></i></a>
									<?php echo e(method_field('DELETE')); ?>

    								<?php echo csrf_field(); ?>
    								<?php if($data->status): ?>
    								<button type="submit" class="btn btn-success btn-xs btn-status-change" data-title="Are you sure you want to student inactive?" title="Active Student"><i class="fa fa-toggle-on" aria-hidden="true"></i></button>
    								<?php else: ?>
    								<button type="submit" class="btn btn-danger btn-xs btn-status-change" data-title="Are you sure you want to student active?" title="Inactive Student"><i class="fa fa-toggle-off" aria-hidden="true"></i></button>
    								<?php endif; ?>
								</form>
							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
function showClass(elem){
	if($(elem).val() == ""){
		return;
	}
		// Storing the student status in local Javascript Stroage
    localStorage.setItem("studentStatus", $('#studentStatus').val());
	window.location = "<?php echo url('students/class') ?>/"+$('#class').val()+"-"+$('#studentStatus').val();
}

$(document).ready(function(){
    
    var url=window.location.href;
   // Selecting the student status option from local Javascript Stroage
    if (url.toLowerCase().indexOf("1") >= 0 || url.toLowerCase().indexOf("0") >= 0)
    $("#studentStatus").val(localStorage.getItem("studentStatus"));
})

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>