
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<div class="panel-title" >
					<?php echo e(_lang('Book Issues')); ?>

				</div>
			</div>
			<div class="panel-body">
				<form id="search_form" class="params-panel validate" action="<?php echo e(url('bookissues/list')); ?>" method="post" autocomplete="off" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<div class="col-md-4 col-md-offset-3">
						<div class="form-group">
							<label for="date" class="control-label"><?php echo e(_lang('Library Id')); ?></label>
							<select name="library_id" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<?php echo e(create_option('library_members','library_id','library_id',$library_id)); ?>

							</select>
						</div>
					</div>
					<div class="col-md-2">
						<input class="btn btn-primary btn-block rect-btn" style="margin-top:24px" value="Search" type="submit">
					</div>
				</form>
				<?php if( !empty($issues) ): ?>
				<div class="col-md-12">
					<div class="panel-heading text-center">
						<div class="panel-title" >
							<?php echo e(_lang('Book Issues Of')); ?><br>
							<?php echo e(_lang('Member Name - ')); ?><?php echo e($member->name); ?><br>
							<?php echo e(_lang('Library Id - ')); ?><?php echo e($member->library_id); ?><br>
						</div>
					</div>

					<table class="table table-bordered data-table">
						<thead>
							<tr>
								<th>#</th>
								<th><?php echo e(_lang('Book Name')); ?></th>
								<th><?php echo e(_lang('Category')); ?></th>
								<th><?php echo e(_lang('Issue Date')); ?></th>
								<th><?php echo e(_lang('Due Date')); ?></th>
								<th><?php echo e(_lang('Return Date')); ?></th>
								<th><?php echo e(_lang('Status')); ?></th>
								<th><?php echo e(_lang('Action')); ?></th>
							</tr>
						</thead>
						<tbody>
							<?php $i=1; ?>
							<?php $__currentLoopData = $issues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($i); ?></td>
								<td><?php echo e($data->name); ?></td>
								<td><?php echo e($data->category_name); ?></td>
								<td><?php echo e(date('d-M-Y', strtotime($data->issue_date))); ?></td>
								<td><?php echo e(date('d-M-Y', strtotime($data->due_date))); ?></td>
								<td><?php if($data->return_date != '' ): ?><?php echo e(date('d-M-Y', strtotime($data->return_date))); ?><?php endif; ?></td>
								<td><?php if($data->status == '1'): ?> <span class="badge badge-danger"><?php echo e(_lang('Not Return')); ?></span> <?php else: ?> <span class="badge badge-success"><?php echo e('Returned'); ?></span> <?php endif; ?></td>
								<td>
									<form action="<?php echo e(route('bookissues.destroy',$data->id)); ?>" method="post">
										<a href="<?php echo e(route('bookissues.show',$data->id)); ?>" class="btn btn-success btn-xs"><i class="fa fa-eye" aria-hidden="true" title="edit book issue"></i></a>
										<a href="<?php echo e(route('bookissues.edit',$data->id)); ?>" class="btn btn-warning btn-xs"><i class="fa fa-pencil" aria-hidden="true" title="edit book issue"></i></a>
										<?php echo e(method_field('DELETE')); ?>

										<?php echo csrf_field(); ?>
										<?php if($data->status == '1'): ?>
										<a href="<?php echo e(route('bookissues.return',$data->id)); ?>" class="btn btn-info btn-xs"><i class="fa fa-share" aria-hidden="true" title="book return"></i></a>
										<?php endif; ?>
										<button type="submit" class="btn btn-danger btn-xs btn-remove"><i class="fa fa-eraser" aria-hidden="true" title="return book"></i></button>
									</form>
								</td>
							</tr>
							<?php $i++; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>