<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading">
			  <span class="panel-title"><?php echo e(_lang('List Invoice')); ?></span>
			    <select id="class" class="select_class pull-right" onchange="showClass(this);">
				   <option value="all"><?php echo e(_lang('All Floors')); ?></option>
				   <?php echo e(create_option('classes','id','class_name',$class)); ?>

				</select>
			  <a class="btn btn-primary btn-sm pull-right" data-title="<?php echo e(_lang('Add New Invoice')); ?>" href="<?php echo e(route('invoices.create')); ?>"><?php echo e(_lang('Add New')); ?></a>
			</div>

			<div class="panel-body">
			 <?php if(\Session::has('success')): ?>
			  <div class="alert alert-success">
				<p><?php echo e(\Session::get('success')); ?></p>
			  </div>
			  <br />
			 <?php endif; ?>
				<table class="table table-bordered data-table">
				<thead>
				  <tr>
					<th><?php echo e(_lang('ID')); ?></th>
					<th><?php echo e(_lang('Student')); ?></th>
					<th><?php echo e(_lang('Floor jack')); ?> / <?php echo e(_lang('Room')); ?></th>
					<th><?php echo e(_lang('Due Date')); ?></th>
					<th><?php echo e(_lang('Title')); ?></th>
					<th><?php echo e(_lang('Total')); ?></th>
					<th><?php echo e(_lang('Paid')); ?></th>
					<th><?php echo e(_lang('Due')); ?></th>
					<th><?php echo e(_lang('Status')); ?></th>
					<th><?php echo e(_lang('Action')); ?></th>
				  </tr>
				</thead>
				<tbody>
				  
				  <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				  <tr id="row_<?php echo e($invoice->id); ?>">
						<td><?php echo e($invoice->id); ?></td>
						<td><?php echo e($invoice->first_name." ".$invoice->last_name); ?></td>
						<td><?php echo e($invoice->class_name); ?> / <?php echo e($invoice->section_name); ?></td>
						<td><?php echo e(date('d-M-Y', strtotime($invoice->due_date))); ?></td>
						<td style='max-width:250px;'><?php echo e($invoice->title); ?></td>
						<td><?php echo e($invoice->total); ?></td>
						<td><?php echo e($invoice->paid); ?></td>
						<td><?php echo e($invoice->total - $invoice->paid); ?></td>
						<td><?php echo $invoice->status=="Paid" ? '<i class="fa fa-circle paid"></i>'.$invoice->status : '<i class="fa fa-circle unpaid"></i>'.$invoice->status; ?></td>		
					<td>
					  <div class="dropdown">
						  <button class="btn btn-primary btn-sm dropdown-toggle" type="button" data-toggle="dropdown"><?php echo e(_lang('Action')); ?>

						  <span class="caret"></span></button>
						  
						  <form action="<?php echo e(action('InvoiceController@destroy', $invoice['id'])); ?>" method="post">			
							<?php echo e(csrf_field()); ?>

							<input name="_method" type="hidden" value="DELETE">
							<ul class="dropdown-menu">
							<?php if($invoice->status=="Paid" || $invoice->paid>0): ?>
							<li><a href="<?php echo e(url('invoices/feebill/'.$invoice['id'].'?type=pay_sllip')); ?>" target="_blank"><?php echo e(_lang('Pay Sllip')); ?></a>
							</li>
							<li>
							  	<a href="<?php echo e(url('student_payments/create/'.$invoice['id'])); ?>" data-title="<?php echo e(_lang('Add Payment')); ?>" class="ajax-modal"><?php echo e(_lang('Payment History')); ?></a>
							</li>
							<?php else: ?>
							  <li><a href="<?php echo e(action('InvoiceController@edit', $invoice['id'])); ?>"><?php echo e(_lang('Edit')); ?></a></li>
							  <li><a href="<?php echo e(url('invoices/feebill/'.$invoice['id'].'?type=fee_bill')); ?>" target="_blank"><?php echo e(_lang('Fee Bill')); ?></a></li>
							  <li>
							  	<a href="<?php echo e(url('student_payments/create/'.$invoice['id'])); ?>" data-title="<?php echo e(_lang('Add Payment')); ?>" class="ajax-modal"><?php echo e(_lang('Take Payment')); ?></a>
							  </li>
							  <li><button class="btn-remove link-btn" type="submit"><?php echo e(_lang('Delete')); ?></button></li>
							  <?php endif; ?>
							</ul>
						  </form>
						</div>
					</td>
				  </tr>
				  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			  </table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
function showClass(elem){
	if($(elem).val() == ""){
		return;
	}
	window.location = "<?php echo url('invoices/class') ?>/"+$(elem).val();
}
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>