<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Fee Invoice</title>
    <?php echo $__env->make('backend.pdf.layouts.feebill_css', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</head>
<body>
<main>
    <?php $department =\App\Department::find($invoices[0]['department_id']); ?>
    <div class="row" style="padding: 0px;margin: 0px;">
        <div class="col-md-12" style="padding: 0px;margin: 0px;">
            <div style="padding: 10px;">
                <table cellpadding="0" cellspacing="0">
                    <tr class="top">
                        <td colspan="2">
                            <table>
                                <tr>
                                    <td class="title" style="width: 20%">
                                        <img src="<?php echo e(get_department_logo(@$department->id,'school_logo')); ?>" style="width:100%;">
                                    </td>
                                    <td style="width: 60%;text-align: center;">
                                        <b><?php echo e(get_option("school_name")); ?></b><br/>
                                        <small><?php echo e(get_option("address")); ?>

                                        <?php echo e(_lang('Ph')." : ".get_option("phone")); ?></small><br/>

                                    </td>
                                    <td style="width: 20%">
                                        <img src="<?php echo e(get_department_logo(@$department->id,'school_logo')); ?>" style="width:100%;">
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2"><h2 class="pm-0" align="center"><?php echo e(_lang('Fee Invoice')); ?></h2></td>
                    </tr>
                    <tr>
                        <td colspan="2" class="text-center pt-3"><span class="pm-0"><?php echo e(@$department->department_name); ?></span></td>
                    </tr>
                    <tr class="brk-10">
                        <td colspan="2"></td>
                    </tr>
                    <tr>
                        <td class="pt-3 pb-3" colspan="2"><b class="pm-0"><?php echo e(_lang("Name")); ?>:</b><strong> <?php echo e($invoices[0]['first_name']." ".$invoices[0]['last_name']); ?></strong></td>
                    </tr>
                    <tr>
                        <td class="pt-3 pb-3" colspan="2"><b class="pm-0"><?php echo e(_lang("Family Head")); ?>:</b> <strong><?php echo e($invoices[0]['parent_name']); ?></strong></td>
                    </tr>
                    <tr>
                        <td class="pt-3 pb-3" class="text-left" width="50%"><b class="pm-0"> <?php echo e(_lang("Class")); ?>:</b> <strong><?php echo e($invoices[0]['class_name']); ?></strong></td>
                        <td class="pt-3 pb-3" class="text-left" width="50%"><b class="pm-0"> <?php echo e(_lang("Section")); ?>:</b> <strong><?php echo e($invoices[0]['section_name']); ?></strong></td>
                    </tr>

                    <tr class="brk-10">
                        <td colspan="2"></td>
                    </tr>
                </table>
                <div style="margin-top: 10px;"> 
                    <fieldset>
                        <legend>Fee Details:</legend>
                        <?php if(count($invoices)>0): ?>
                        <?php $grand_total=0 ?>
                        <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row_period): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <b><?php echo e(_lang('Periods')); ?>:</b> 
                        <span>
                            <?php echo e($row_period['title']); ?>

                        </span>
                        <table class="table-data" style="margin-top: 5px;margin-bottom: 5px;">
                            <tbody>    
                                <?php $__currentLoopData = $row_period['invoice_item']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                
                                   <tr>
                                     <td class="text-left" width="70%"><b><?php echo e(@$item['feetypename']['fee_type']); ?></b></td>
                                     <td class="text-right"><?php echo e($currency." ".decimalPlace($item['amount']-$item['discount'])); ?></td>
                                   </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <?php $grand_total=$grand_total+$row_period['paid']; ?>
                        </table>
                        <hr/>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <p class="text-right" style="margin: 3px;"> 
                        <b>
                            <?php echo e(_lang('Invoice Total')); ?>: <?php echo e($currency." ".decimalPlace($grand_total)); ?>

                        </b>
                        </p>

                        <hr/>
                        <p class="text-left" style="margin: 3px;"> 
                        <b>
                            <?php echo e(_lang('Total Balance')); ?>: <?php echo e($currency." ".decimalPlace(@$tital_balance)); ?>

                        </b>
                        </p>

                        
                        <?php endif; ?>
                    </fieldset>
                </div>
            </div>
        </div>        
    </div>
</main>

</body>
</html>
