
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading">
				<div class="panel-title" >
					<?php echo e(_lang('Update User')); ?>

				</div>
			</div>
			<div class="panel-body">
			  <div class="col-md-8">
				<form action="<?php echo e(route('users.update',$data->id)); ?>" autocomplete="off" class="form-horizontal form-groups-bordered validate" enctype="multipart/form-data" method="post" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<?php echo e(method_field('PATCH')); ?>

					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Name')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="name" value="<?php echo e($data->name); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Email')); ?></label>
						<div class="col-sm-9">
							<input type="email" class="form-control" name="email" value="<?php echo e($data->email); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Phone')); ?></label>
						<div class="col-sm-9">
							<input type="phone" class="form-control" name="phone" value="<?php echo e($data->phone); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Password')); ?></label>
						<div class="col-sm-9">
							<input type="password" class="form-control" name="password">
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Confirm Password')); ?></label>
						<div class="col-sm-9">
							<input type="password" class="form-control" name="password_confirmation">
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('User Type')); ?></label>
						<div class="col-sm-9">
							<select name="user_type" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<option <?php if($data->user_type=='Admin'): ?> selected <?php endif; ?> value="Admin"><?php echo e(_lang('Admin')); ?></option>
								<option <?php if($data->user_type=='Accountant'): ?> selected <?php endif; ?> value="Accountant"><?php echo e(_lang('Accountant')); ?></option>
								<option <?php if($data->user_type=='Librarian'): ?> selected <?php endif; ?> value="Librarian"><?php echo e(_lang('Librarian')); ?></option>
								<option <?php if($data->user_type=='Employee'): ?> selected <?php endif; ?> value="Employee"><?php echo e(_lang('Employee')); ?></option>
							    <option <?php if($data->user_type=='Teacher'): ?> selected <?php endif; ?> value="Teacher" ><?php echo e(_lang('Teacher')); ?></option>
							</select>
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Permission Role')); ?></label>
						<div class="col-sm-9">
							<select name="role_id" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<option value="0" <?php echo e($data->role_id==0 ? "selected" : ""); ?>><?php echo e(_lang('Default')); ?></option>
								<?php echo e(create_option("permission_roles","id","role_name",$data->role_id)); ?>

							</select>
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Profile')); ?></label>
						<div class="col-sm-9">
							<input type="file" class="form-control dropify" name="image" data-default-file="<?php echo e(asset('public/uploads/images/'.$data->image)); ?>" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
						</div>
					</div>
										
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Facebook Link')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="facebook" value="<?php echo e($data->facebook); ?>">
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Twitter Link')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="twitter" value="<?php echo e($data->twitter); ?>">
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Linkedin Link')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="linkedin" value="<?php echo e($data->linkedin); ?>">
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Google Plus Link')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="google_plus" value="<?php echo e($data->google_plus); ?>">
						</div>
					</div>

					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-5">
							<button type="submit" class="btn btn-info"><?php echo e(_lang('Update User')); ?></button>
						</div>
					</div>
				</form>
			  </div>	
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>