<!doctype html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="utf-8" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('public/assets')); ?>/images/fav.png">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('public/assets')); ?>/images/fav.png">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <title><?php echo e(get_school_name()); ?></title>
    <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0' name='viewport' />
    <meta name="viewport" content="width=device-width" />
    <!-- Bootstrap core CSS     -->
    <link href="<?php echo e(asset('public/backend')); ?>/css/bootstrap.min.css" rel="stylesheet" />
    <!-- Datatable core CSS     -->
    <link href="<?php echo e(asset('public/backend')); ?>/css/dataTables.bootstrap.min.css" rel="stylesheet" />
    <!-- Animation library for notifications   -->
    <link href="<?php echo e(asset('public/backend')); ?>/css/animate.min.css" rel="stylesheet"/>
	<!-- bootstrap-datepicker library -->
    <link href="<?php echo e(asset('public/backend')); ?>/css/bootstrap-datepicker.css" rel="stylesheet"/>
	<!-- Select 2 library -->
    <link href="<?php echo e(asset('public/backend')); ?>/css/select2.css" rel="stylesheet"/>
	<!-- Dropify library -->
    <link href="<?php echo e(asset('public/backend')); ?>/css/dropify.min.css" rel="stylesheet"/>
    <!--  Quill editor    -->
    <link href="<?php echo e(asset('public/backend')); ?>/css/summernote.css" rel="stylesheet"/>
    <!--  Fonts and icons     -->
    <link href="<?php echo e(asset('public/backend')); ?>/css/font-awesome.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('public/backend')); ?>/css/fonts.css" rel="stylesheet">
    <link href="<?php echo e(asset('public/backend')); ?>/css/themify-icons.css" rel="stylesheet">
    <link href="<?php echo e(asset('public/backend')); ?>/css/toastr.css" rel="stylesheet">
    <link href="<?php echo e(asset('public/backend')); ?>/css/nice-select.css" rel="stylesheet">
    <link href="<?php echo e(asset('public/backend')); ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo e(asset('public/backend')); ?>/css/fullcalendar.min.css" rel="stylesheet">
	<link href="<?php echo e(asset('public/backend')); ?>/css/metisMenu.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('public/backend')); ?>/css/bootstrap-datetimepicker.min.css" rel="stylesheet">
	<!--  Style CSS -->
    <link href="<?php echo e(asset('public/backend')); ?>/css/style.css" rel="stylesheet" />
    
	<?php if(get_option('backend_direction') == "rtl"): ?>
	<link href="<?php echo e(asset('public/backend')); ?>/css/RTL.css" rel="stylesheet" />
	<?php endif; ?>
	<script type="text/javascript">
	   var direction = "<?php echo e(get_option('backend_direction')); ?>";
	</script>
	
	<?php echo $__env->make('layouts.css.dynamic_css', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</head>
<body>
    <!-- Main Modal -->
	<div id="main_modal" class="modal animated bounceInDown" role="dialog">
	  <div class="modal-dialog">
		<!-- Modal content-->
		<div class="modal-content">
		  <div class="modal-header">
			<button type="button" class="modal-btn btn btn-danger btn-sm pull-right" data-dismiss="modal"><i class="glyphicon glyphicon-remove-circle"></i> <?php echo e(_lang('Exit')); ?></button>
			<button type="button" id="modal-fullscreen" class="modal-btn btn btn-primary btn-sm pull-right"><i class="glyphicon glyphicon-fullscreen"></i> <?php echo e(_lang('Full Screen')); ?></button>
			<h5 class="modal-title"></h5>
		  </div>  
		  <div class="alert alert-danger" style="display:none; margin: 15px;"></div>
		  <div class="alert alert-success" style="display:none; margin: 15px;"></div>			  
		  <div class="modal-body" style="overflow:hidden;"></div>
		</div>

	  </div>
	</div>
	
	<div id="preloader">
		<div class="bar"></div>
	</div>
	
    <div class="wrapper animated fadeIn">
        <div class="sidebar" data-background-color="white" data-active-color="danger">
			<div class="sidebar-wrapper">
				<div class="logo" style="padding: 0px;margin: 0px;">
					<a href="<?php echo e(url('/dashboard')); ?>" class="simple-text">
					<!-- <?php echo e(get_option('school_name')); ?> -->
						<img src="<?php echo e(get_logo()); ?>" alt="Logo" style="display: block;max-height: 66px;width: auto;margin: auto;">
					</a>
				</div>						

				<?php echo $__env->make('layouts.menus.'.Auth::user()->user_type, array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
				
			</div>
		</div>
		<div class="main-panel">
			<nav class="navbar navbar-default">
				<div class="container-fluid">
					<div class="navbar-header">
						<button type="button" class="navbar-toggle mobile-nav">
							<span class="sr-only">Toggle navigation</span>
							<span class="icon-bar bar1"></span>
							<span class="icon-bar bar2"></span>
							<span class="icon-bar bar3"></span>
						</button>
						<a class="navbar-brand" href="#"><?php echo e(get_option('school_name')); ?></a>
					</div>
					<div class="collapse navbar-collapse">
						<ul class="nav navbar-nav navbar-right">
						
							<?php if(Auth::user()->user_type == 'Admin'): ?>
							<li>
								<select class="select_class" onchange="changeSession(this);" style="margin-top: 22px;">
								  <?php $__currentLoopData = get_table('academic_years'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									  <option value="<?php echo e($session->id); ?>" <?php echo e($session->id==get_option('academic_year') ? "selected" : ""); ?>><?php echo e($session->session); ?></option>
								  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</li>
							<?php endif; ?>
							
							<li class="dropdown">
								<a href="#" class="dropdown-toggle" data-toggle="dropdown">
									<p class="notification"><?php echo count_inbox() > 0 ? '<span class="notification-count">'.count_inbox().'</span>' : ""; ?></p>
									<p><?php echo e(_lang('Message')); ?></p>
									<b class="caret"></b>
								</a>
								<ul class="dropdown-menu notification-items">
								    <?php $__currentLoopData = inbox_items(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<li><a class="ajax-modal" href="<?php echo e(url('message/inbox/'.$message->id)); ?>"><?php echo e($message->subject); ?></a></li>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</ul>
							</li>
							<li class="dropdown">
								<a href="#" class="dropdown-toggle" data-toggle="dropdown">
									<i class="ti-user"></i>
									<p><?php echo e(_lang('Hi').", ".Auth::user()->name); ?></p>
									<b class="caret"></b>
								</a>
									<ul class="dropdown-menu">
										<li><a href="<?php echo e(url('profile/my_profile')); ?>" data-title="<?php echo e(_lang('Profile')); ?>"><?php echo e(_lang('Profile')); ?></a></li>
										<li><a href="<?php echo e(url('profile/edit')); ?>" data-title="<?php echo e(_lang('Edit Profile')); ?>"><?php echo e(_lang('Update Profile')); ?></a></li>
										<li><a href="<?php echo e(url('profile/changepassword')); ?>" data-title="<?php echo e(_lang('Change Password')); ?>"><?php echo e(_lang('Change Password')); ?></a></li>
										<li>
											<a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
											onclick="event.preventDefault();
											document.getElementById('logout-form').submit();">
											<?php echo e(__('Logout')); ?>

										</a>
									</li>
									<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
										<?php echo csrf_field(); ?>
									</form>
								</ul>
							</li>
						</ul>
				</div>
			</div>
		</nav>
		<div class="content">
		   <div class="container-fluid">
				
				
				<ol class="breadcrumb">
					<li><a href="<?php echo e(url('dashboard')); ?>"><i class="ti-home"></i> <?php echo e(_lang('Dashboard')); ?></a></li>
					<?php $segments = ''; ?>
					<?php $__currentLoopData = Request::segments(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					    <?php if($segment == "dashboard"): ?>
							<?php continue; ?>
						<?php endif; ?>
						<?php $segments .= '/'.$segment; ?>
						<li>
							<a href="<?php echo e(url($segments)); ?>"><?php echo e(ucwords(str_replace("_"," ",$segment))); ?></a>
						</li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</ol>
			  
			   <?php echo $__env->yieldContent('content'); ?>
		   </div>
	   </div>   
	</div>
	
  </div>
</body>
<!--   Core JS Files   -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/jquery.min.js"></script>

<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/bootstrap.min.js"></script>
<!--  Charts Plugin -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/echarts.min.js"></script>
<!--  Notifications Plugin    -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/bootstrap-notify.js"></script>
<!--  DataTable Plugin    -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/jquery.dataTables.min.js"></script>
<!--  Select 2 Plugin    -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/select2.min.js"></script>
<!--  jQuery Validation   -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/jquery.validate.min.js"></script>
<!--  Bootstrap Datepicker  -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/jquery.mask.min.js"></script>
<!--  Summernote editor    -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/summernote.js"></script>
<!--  Dropify  -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/dropify.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/toastr.js"></script>
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/jquery.nice-select.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/print.js"></script>
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/jquery.nestable.js"></script>

<script src="<?php echo e(asset('public/backend')); ?>/js/metisMenu.min.js"></script>
<script src="<?php echo e(asset('public/backend')); ?>/js/moment.min.js"></script>
<script src="<?php echo e(asset('public/backend')); ?>/js/bootstrap-datetimepicker.min.js"></script>

<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/fullcalendar.min.js"></script>

<!-- Paper Dashboard Core javascript and methods for Demo purpose -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/script.js"></script>
<!-- Paper Dashboard DEMO methods, don't include it in your project! -->
<script type="text/javascript" src="<?php echo e(asset('public/backend')); ?>/js/dashboard.js"></script>

<!-- JS -->
<?php echo $__env->yieldContent('js-script'); ?>

<script type="text/javascript">
$(document).ready(function(){  

     <?php if(Request::is('dashboard') && \Auth::user()->user_type == 'Admin'): ?>
         dashboard.admin_init();
	 <?php elseif(Request::is('dashboard') && \Auth::user()->user_type == 'Accountant'): ?>
	     dashboard.accountant_init();
	 <?php elseif( ! Request::is('dashboard')): ?>
	    $(".navbar-brand").html($(".title").html()); 
	    $(".navbar-brand").html($(".panel-title").html());
		$("#last_link").html($(".navbar-brand").html());
     <?php endif; ?>

    $(".data-table").DataTable({
		responsive: true,
		"bAutoWidth":false,
		"ordering": false,
		"pageLength": 50,
		"language": {
		   "decimal":        "",
		   "emptyTable":     "<?php echo e(_lang('No Data Found')); ?>",
		   "info":           "<?php echo e(_lang('Showing')); ?> _START_ <?php echo e(_lang('to')); ?> _END_ <?php echo e(_lang('of')); ?> _TOTAL_ <?php echo e(_lang('Entries')); ?>",
		   "infoEmpty":      "<?php echo e(_lang('Showing 0 To 0 Of 0 Entries')); ?>",
		   "infoFiltered":   "(filtered from _MAX_ total entries)",
		   "infoPostFix":    "",
		   "thousands":      ",",
		   "lengthMenu":     "<?php echo e(_lang('Show')); ?> _MENU_ <?php echo e(_lang('Entries')); ?>",
		   "loadingRecords": "<?php echo e(_lang('Loading...')); ?>",
		   "processing":     "<?php echo e(_lang('Processing...')); ?>",
		   "search":         "<?php echo e(_lang('Search')); ?>",
		   "zeroRecords":    "<?php echo e(_lang('No matching records found')); ?>",
		   "paginate": {
			  "first":      "<?php echo e(_lang('First')); ?>",
			  "last":       "<?php echo e(_lang('Last')); ?>",
			  "next":       "<?php echo e(_lang('Next')); ?>",
			  "previous":   "<?php echo e(_lang('Previous')); ?>"
		  },
		  "aria": {
			  "sortAscending":  ": activate to sort column ascending",
			  "sortDescending": ": activate to sort column descending"
		  }
	  },
	  dom: 'lfBrtip',
	  buttons: [
	  'copy', 'csv', 'excel', 'pdf', 'print'
	  ],
    });

	//Show Success Message
	<?php if(Session::has('success')): ?>
	   Command: toastr["success"]("<?php echo e(session('success')); ?>")
	<?php endif; ?>
	
	//Show Single Error Message
	<?php if(Session::has('error')): ?>
	   Command: toastr["error"]("<?php echo e(session('error')); ?>")
	<?php endif; ?>

	
	<?php $i =0; ?>

	<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        Command: toastr["error"]("<?php echo e($error); ?>");
		
		var name= "<?php echo e($errors->keys()[$i]); ?>";
		
		$("input[name='"+name+"']").addClass('error');
		$("select[name='"+name+"'] + span").addClass('error');
		
		$("input[name='"+name+"'], select[name='"+name+"']").parent().append("<span class='v-error'><?php echo e($error); ?></span>");
		
		<?php $i++; ?>
	
	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

});

function changeSession(elem){
	if($(elem).val() == ""){
		return;
	}
	window.location = "<?php echo url('administration/change_session') ?>/"+$(elem).val();
}

$("#menu li").each(function(){
	var elem = $(this);
	if($(elem).has("ul").length>0){
		if($(elem).find("ul").has("li").length === 0){
			$(elem).remove();
		}		
	}
});


if($(".notification-items").has("li").length === 0){
	$(".notification-items").append("<li><a href='#'>No Message Found !</a></li>");
}


</script>
</html>