
<?php $__env->startSection('content'); ?>
<style type="text/css">
.table > thead > tr > th, .table > tbody > tr > th, .table > tfoot > tr > th, .table > thead > tr > td, .table > tbody > tr > td, .table > tfoot > tr > td {
    padding: 2px;
    vertical-align: middle;
}
.table {
    margin-bottom: 10px;
}
</style>
<div class="row">
	<div class="col-lg-4 col-sm-6">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-xs-4">
						<div class="icon-big icon-warning text-center">
							<i class="ti-user"></i>
						</div>
					</div>
					<div class="col-xs-8">
						<div class="numbers">
							<p><?php echo e(_lang('Student Capacity')); ?></p>
							<?php echo e(total_student_capacity()); ?>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>	
	<div class="col-lg-4 col-sm-6">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-xs-4">
						<div class="icon-big icon-danger text-center">
							<i class="ti-user"></i>
						</div>
					</div>
					<div class="col-xs-8">
						<div class="numbers">
							<p><?php echo e(_lang('Occupied Seats')); ?></p>
							<?php echo e(total_student_occupied()); ?>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-lg-4 col-sm-6">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-xs-4">
						<div class="icon-big icon-info text-center">
							<i class="ti-user"></i>
						</div>
					</div>
					<div class="col-xs-8">
						<div class="numbers">
							<p><?php echo e(_lang('Vacant Seats')); ?></p>
							<?php echo e(total_student_vacant()); ?>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row">
   <div class="col-md-4">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-md-5">
						<div class="icon-big icon-primary text-center">
							<i class="ti-credit-card"></i>
						</div>
					</div>
					<div class="col-md-7">
						<div class="numbers">
							<p><?php echo e(_lang('Monthly Student Payments')); ?></p>
								<?php echo e($currency." ".$student_payments); ?>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

   <div class="col-md-4">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-md-5">
						<div class="icon-big icon-success text-center">
							<i class="ti-credit-card"></i>
						</div>
					</div>
					<div class="col-md-7">
						<div class="numbers">
							<p><?php echo e(_lang('Current Others Income')); ?></p>
							<?php echo e($currency." ".$monthly_income); ?>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

   <div class="col-md-4">
		<div class="card">
			<div class="content">
				<div class="row">
					<div class="col-md-5">
						<div class="icon-big icon-danger text-center">
							<i class="ti-credit-card"></i>
						</div>
					</div>
					<div class="col-md-7">
						<div class="numbers">
							<p><?php echo e(_lang('Current Month Expense')); ?></p>
							<?php echo e($currency." ".$monthly_expense); ?>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php if(count($total_class)>0): ?>
<div class="row">
	<?php $__currentLoopData = $total_class; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	<div class="col-lg-4">
		<div class="card">
			<div class="row">
				<div class="col-md-12">
					<p><?php echo e($class->class_name); ?></p>
				</div>
				<div class="col-md-12">
					<?php if(count($class->class_section)>0): ?>
					<table class="table table-bordered">
						<thead>
							<tr>	
								<th class="text-center">Section</th>
								<th class="text-center">Capacity</th>
								<th class="text-center">Vacant</th>
							</tr>
						</thead>
						<tbody>
							<?php $__currentLoopData = $class->class_section; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>	
								<td class="text-center"><?php echo e($section->section_name); ?></td>
								<td class="text-center"><?php echo e($section->capacity); ?></td>
								
									<?php 
									$per = $section->capacity/100;
									$percentage = ($section->capacity-section_wise_occupied($section->id))/$per;
									?>

									<?php if($percentage<1): ?>
									<td class="text-center" style="background: red;color: #fff;">
										<?php echo e($section->capacity-section_wise_occupied($section->id)); ?>

									</td>
									<?php elseif($percentage>0 && $percentage<26): ?>
									<td class="text-center" style="background: orange;color: #000;">
									<?php echo e($section->capacity-section_wise_occupied($section->id)); ?></td>
									<?php elseif($percentage>25 && $percentage<51): ?>
									<td class="text-center" style="background: yellow;color: #000;">
									<?php echo e($section->capacity-section_wise_occupied($section->id)); ?></td>
									<?php elseif($percentage>50 && $percentage<76): ?>
									<td class="text-center" style="background: lightgreen;color: #000;">
									<?php echo e($section->capacity-section_wise_occupied($section->id)); ?></td>
									<?php elseif($percentage>75): ?>
									<td class="text-center" style="background:green;color: #fff;">
									<?php echo e($section->capacity-section_wise_occupied($section->id)); ?></td>
									<?php else: ?>
									<td class="text-center">
									<?php echo e($section->capacity-section_wise_occupied($section->id)); ?></td>
									<?php endif; ?>
							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
					<?php else: ?>
					<small class="text-danger">Section not found!</small>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php endif; ?>


<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="header">
				<h4 class="title text-center"><?php echo e(_lang('Income and Expense Summary of')." ".date("Y")); ?></h4>
			</div>
			<div class="content">
				<div id="income_vs_expense_chart" style="width: 100%; height:400px;"></div>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="header">
				<h4 class="title text-center"><?php echo e(_lang('Notice')); ?></h4>
			</div>
			<div class="content no-export">
				<table class="table table-bordered data-table">
				   <thead>
				     <th><?php echo e(_lang('Notice')); ?></th>
				     <th><?php echo e(_lang('Created')); ?></th>
				     <th class="text-center"><?php echo e(_lang('View')); ?></th>
				   </thead>
				   <tbody>
						<?php $__currentLoopData = get_notices("Admin",100); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						  <tr>
							<td><?php echo e($notice->heading); ?></td>
							<td><?php echo e(date("d M, Y - H:i", strtotime($notice->created_at))); ?></td>
						    <td class="text-center"><a href="<?php echo e(action('NoticeController@show', $notice->id)); ?>" data-title="<?php echo e(_lang('View Notice')); ?>" class="btn btn-primary btn-sm ajax-modal"><?php echo e(_lang('View Notice')); ?></a></td>
						  </tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				   </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
  var yearly_income = <?php echo e($yearly_income); ?>;
  var yearly_expense = <?php echo e($yearly_expense); ?>;
</script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>

  $(document).ready(function() {

  });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>