<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading"><?php echo e(_lang('Update Income')); ?></div>

			<div class="panel-body">
			<form method="post" class="validate" autocomplete="off" action="<?php echo e(action('TransactionController@update', $id)); ?>" enctype="multipart/form-data">
				<?php echo e(csrf_field()); ?>

				<input name="_method" type="hidden" value="PATCH">				
				
				<div class="col-md-6">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Trans Date')); ?></label>						
					<input type="text" class="form-control datepicker" name="trans_date" value="<?php echo e($transaction->trans_date); ?>" required>
				 </div>
				</div>

				<div class="col-md-6">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Account')); ?></label>
                    <select class="form-control select2" name="account_id" required>
						<?php echo e(create_option("bank_cash_accounts","id","account_name",$transaction->account_id)); ?>

					</select>					
				 </div>
				</div>


				<div class="col-md-6">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Amount')." ".get_option('currency_symbol')); ?></label>						
					<input type="text" class="form-control float-field" name="amount" value="<?php echo e($transaction->amount); ?>" required>
				 </div>
				</div>


				<div class="col-md-6">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Income Type')); ?></label>						
					<select class="form-control select2" name="chart_id" required>
						<?php echo e(create_option("chart_of_accounts","id","name",$transaction->chart_id,array("type="=>"income"))); ?>

					</select>
				 </div>
				</div>
				
				<input type="hidden" name="trans_type" value="income">
				<input type="hidden" name="dr_cr" value="cr">

				<div class="col-md-6">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Payer')); ?></label>	
                    <select class="form-control select2" name="payee_payer_id" required>
						<?php echo e(create_option("payee_payers","id","name",$transaction->payee_payer_id,array("type="=>"payer"))); ?>

					</select>					
				 </div>
				</div>

				<div class="col-md-6">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Payment Method')); ?></label>						
					<select class="form-control select2" name="payment_method_id" required>
						<?php echo e(create_option("payment_methods","id","name",$transaction->payment_method_id)); ?>

					</select>
				 </div>
				</div>

				<div class="col-md-6">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Reference')); ?></label>						
					<input type="text" class="form-control" name="reference" value="<?php echo e($transaction->reference); ?>">
				 </div>
				</div>

				<div class="col-md-6">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Attachment')); ?></label>						
					<input type="file" class="form-control appsvan-file" data-value="<?php echo e($transaction->attachment); ?>" name="attachment">
				 </div>
				</div>

				<div class="col-md-6">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Note')); ?></label>						
					<textarea class="form-control" name="note"><?php echo e($transaction->note); ?></textarea>
				 </div>
				</div>

				
				<div class="col-md-12">
				  <div class="form-group">
					<button type="submit" class="btn btn-primary"><?php echo e(_lang('Update')); ?></button>
				  </div>
				</div>
			</form>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>