<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading"><?php echo e(_lang('Update Department')); ?></div>

			<div class="panel-body">
			 <form method="post" class="validate" autocomplete="off" action="<?php echo e(action('DepartmentController@update', $id)); ?>" enctype="multipart/form-data">
				<?php echo e(csrf_field()); ?>

				<input name="_method" type="hidden" value="PATCH">				
				<div class="col-md-12">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Department Name')); ?></label>						
					<input type="text" class="form-control" name="department_name" value="<?php echo e($department->department_name); ?>" required>
				  </div>
				</div>
				<div class="col-md-12">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Bank Name')); ?></label>						
					<input type="text" class="form-control" name="bank_name" value="<?php echo e($department->bank_name); ?>" required>
				  </div>
				</div>
				<div class="col-md-12">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Bank Account')); ?></label>						
					<input type="text" class="form-control" name="bank_account" value="<?php echo e($department->bank_account); ?>" required>
				  </div>
				</div>

				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Bank Logo')); ?></label>						
					<input type="file" class="form-control dropify" name="bank_logo" data-default-file="<?php echo e(asset('public/uploads/'.$department->bank_logo)); ?>" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
				  </div>
				</div>
				<div class="col-md-6">
				  <div class="form-group">
					<label class="control-label"><?php echo e(_lang('School Logo')); ?></label>						
					<input type="file" class="form-control dropify" name="school_logo" data-default-file="<?php echo e(asset('public/uploads/'.$department->school_logo)); ?>" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
				  </div>
				</div>

				
				<div class="form-group">
				  <div class="col-md-12">
					<button type="submit" class="btn btn-primary"><?php echo e(_lang('Update')); ?></button>
				  </div>
				</div>
			  </form>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>