<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Daily Fee Receipt Report</title>
    <?php echo $__env->make('backend.pdf.layouts.css', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</head>
<body >
<?php echo $__env->make('backend.pdf.layouts.report-header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<main>


    <table class="table" width="100%" cellspacing="0">
        <thead>
        <tr>
        	<th style="text-align: left;" width="10%"><?php echo e(_lang('Sr.')); ?></th>
        	<th style="text-align: left;" width="15%"><?php echo e(_lang('Reg #')); ?></th>
        	<th style="text-align: left;" width="15%"><?php echo e(_lang('Date')); ?></th>
            <th style="text-align: left;" width="40%"><?php echo e(_lang('Student Information')); ?></th>
        	<th class="text-right" width="20%"><?php echo e(_lang('Amount Received')); ?></th>
        </tr>
        </thead>
        <tbody>
            <?php if(count($accounts)>0): ?>
            <?php $total =0; ?>
            <?php $grand_total =0; ?>
            <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="bg-account-head text-black">
                <th style="text-align: left;" colspan="5"><h3 style="padding: 0px 0px;margin: 0px;font-size: 17px;font-family: system-ui;letter-spacing: 0.7px;font-weight: 700;"><?php echo e($account->account_name); ?></h3></th>
            </tr>
            	<?php if(count($transactions)>0): ?>
            	<?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($account->id ==$transaction->account_id): ?>
                <?php $total =$total+$transaction->amount; ?>
            	<tr>
                    <td style="text-align: left;"><?php echo e(++$key); ?></td>
                    <td style="text-align: left;"><?php echo e(@$transaction->student_info->register_no); ?></td>
                    <td style="text-align: left;"><?php echo e(date('d-M-Y',strtotime($transaction->trans_date))); ?></td>
                    <td style="text-align: left;"><?php echo e(@$transaction->student_info->id); ?>-<?php echo e(@$transaction->student_info->first_name); ?></td>
    	        	<td class="text-right"><?php echo e(number_format($transaction->amount,2)); ?></td>
                </tr>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <tr class="bg-account-head text-black">
                    <th style="text-align: right;" colspan="5"><h3 style="padding: 0px 0px;margin: 0px;font-size: 17px;font-family: system-ui;letter-spacing: 0.7px;font-weight: 700;"><?php echo e(number_format($total,2)); ?></h3></th>
                </tr>

            <?php $grand_total =$grand_total+$total; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </tbody>
        <tfoot>            
            <tr class="bg-secondary text-white">
                <th style="text-align: right;" colspan="4"><h3 style="padding: 0px 0px;margin: 0px;font-size: 17px;font-family: system-ui;letter-spacing: 0.7px;font-weight: 700;">Grand Total:</h3></th>
                <th style="text-align: right;"><h3 style="padding: 0px 0px;margin: 0px;font-size: 17px;font-family: system-ui;letter-spacing: 0.7px;font-weight: 700;"><?php echo e(number_format($grand_total,2)); ?></h3></th>
            </tr>
        </tfoot>
    </table>


</main>
<?php echo $__env->make('backend.pdf.layouts.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</body>
</html>
