<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading">
				<span class="panel-title"><?php echo e(_lang('List Student Payment')); ?></span>
				<select id="class" class="select_class pull-right" onchange="showClass(this);">
				   <option value="all"><?php echo e(_lang('All Class')); ?></option>
				   <?php echo e(create_option('classes','id','class_name',$class)); ?>

				</select>
			</div>

			<div class="panel-body">
			 <?php if(\Session::has('success')): ?>
			  <div class="alert alert-success">
				<p><?php echo e(\Session::get('success')); ?></p>
			  </div>
			  <br />
			 <?php endif; ?>
			<table class="table table-bordered data-table">
			<thead>
			  <tr>
				<th><?php echo e(_lang('Invoice ID')); ?></th>
				<th><?php echo e(_lang('Date')); ?></th>
				<th><?php echo e(_lang('Amount')); ?></th>
				<th><?php echo e(_lang('Note')); ?></th>
				<th><?php echo e(_lang('Action')); ?></th>
			  </tr>
			</thead>
			<tbody>
			  <?php $currency = get_option('currency_symbol') ?>
			  <?php $__currentLoopData = $studentpayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentpayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			    <tr id="row_<?php echo e($studentpayment->id); ?>">
					<td class='invoice_id'><?php echo e($studentpayment->invoice_id); ?></td>
					<td class='date'><?php echo e(date('d-M-Y', strtotime($studentpayment->date))); ?></td>
					<td class='amount'><?php echo e($currency." ".$studentpayment->amount); ?></td>
					<td class='note'><?php echo e($studentpayment->note); ?></td>
					<td>
						<a href="<?php echo e(action('StudentPaymentController@show', $studentpayment['id'])); ?>" data-title="<?php echo e(_lang('View Student Payment')); ?>" class="btn btn-info btn-sm ajax-modal"><?php echo e(_lang('View')); ?></a>
					</td>
			    </tr>
			  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		  </table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
function showClass(elem){
	if($(elem).val() == ""){
		return;
	}
	window.location = "<?php echo url('student_payments/class') ?>/"+$(elem).val();
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>