<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
	<div class="panel panel-default">
	<div class="panel-heading"><?php echo e(_lang('Add Expense')); ?></div>

	<div class="panel-body">
	  <form method="post" class="validate" autocomplete="off" action="<?php echo e(url('transactions')); ?>" enctype="multipart/form-data">
		<?php echo e(csrf_field()); ?>

		
		<div class="col-md-6">
		  <div class="form-group">
			<label class="control-label"><?php echo e(_lang('Date')); ?></label>						
			<input type="text" class="form-control datepicker" name="trans_date" value="<?php echo e(old('trans_date')); ?>" required>
		  </div>
		</div>

		<div class="col-md-6">
		  <div class="form-group">
			<label class="control-label"><?php echo e(_lang('Account')); ?></label>						
			<select class="form-control select2" name="account_id" required>
				<?php echo e(create_option("bank_cash_accounts","id","account_name",old('account_id'))); ?>

			</select>
		  </div>
		</div>


		<div class="col-md-6">
		  <div class="form-group">
			<label class="control-label"><?php echo e(_lang('Amount')." ".get_option('currency_symbol')); ?></label>						
			<input type="text" class="form-control float-field" name="amount" value="<?php echo e(old('amount')); ?>" required>
		  </div>
		</div>

		<div class="col-md-6">
		  <div class="form-group">
			<label class="control-label"><?php echo e(_lang('Expense Type')); ?></label>						
			<select class="form-control select2" name="chart_id" required>
				<?php echo e(create_option("chart_of_accounts","id","name",old('chart_id'),array("type="=>"expense"))); ?>

			</select>
		  </div>
		</div>
		
		<input type="hidden" name="trans_type" value="expense">
		<input type="hidden" name="dr_cr" value="dr">

		<div class="col-md-6">
		  <div class="form-group">
			<label class="control-label"><?php echo e(_lang('Payee')); ?></label>						
			<select class="form-control select2" name="payee_payer_id">
				<?php echo e(create_option("payee_payers","id","name",old('payee_payer_id'),array("type="=>"payee"))); ?>

			</select>
		  </div>
		</div>

		<div class="col-md-6">
		  <div class="form-group">
			<label class="control-label"><?php echo e(_lang('Payment Method')); ?></label>						
			<select class="form-control select2" name="payment_method_id">
				<?php echo e(create_option("payment_methods","id","name",old('payment_method_id'))); ?>

			</select>
		  </div>
		</div>

		<div class="col-md-6">
		  <div class="form-group">
			<label class="control-label"><?php echo e(_lang('Reference')); ?></label>						
			<input type="text" class="form-control" name="reference" value="<?php echo e(old('reference')); ?>">
		  </div>
		</div>

		<div class="col-md-6">
		  <div class="form-group">
			<label class="control-label"><?php echo e(_lang('Attachment')); ?></label>						
			<input type="file" class="form-control appsvan-file" name="attachment" >
		  </div>
		</div>

		<div class="col-md-6">
		  <div class="form-group">
			<label class="control-label"><?php echo e(_lang('Note')); ?></label>						
			<textarea class="form-control" name="note"><?php echo e(old('note')); ?></textarea>
		  </div>
		</div>

				
		<div class="col-md-12">
		  <div class="form-group">
		    <button type="reset" class="btn btn-danger"><?php echo e(_lang('Reset')); ?></button>
			<button type="submit" class="btn btn-primary"><?php echo e(_lang('Save Expense')); ?></button>
		  </div>
		</div>
	  </form>
	</div>
  </div>
 </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>