<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading panel-title"><?php echo e(_lang('Update Notice')); ?></div>

			<div class="panel-body">
			<form method="post" class="validate" autocomplete="off" action="<?php echo e(action('NoticeController@update', $id)); ?>" enctype="multipart/form-data">
				<?php echo e(csrf_field()); ?>

				<input name="_method" type="hidden" value="PATCH">				
				
				<div class="col-md-12">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Heading')); ?></label>						
					<input type="text" class="form-control" name="heading" value="<?php echo e($notice->heading); ?>" required>
				 </div>
				</div>

				<div class="col-md-12">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('Content')); ?></label>						
					<textarea class="form-control summernote" name="content" required><?php echo e($notice->content); ?></textarea>
				 </div>
				</div>

				<div class="col-md-12">
				 <div class="form-group">
					<label class="control-label"><?php echo e(_lang('User Type')); ?></label>						
					<select class="form-control select2" name="user_type[]" id="user_type" multiple="multiple">		
						<option value="Website"><?php echo e(_lang('Website')); ?></option>
						<option value="Student"><?php echo e(_lang('Student')); ?></option>
						<option value="Parent"><?php echo e(_lang('Parent')); ?></option>
						<option value="Teacher"><?php echo e(_lang('Teacher')); ?></option>
						<option value="Accountant"><?php echo e(_lang('Accountant')); ?></option>
						<option value="Librarian"><?php echo e(_lang('Librarian')); ?></option>
						<option value="Employee"><?php echo e(_lang('Employee')); ?></option>
						<option value="Admin"><?php echo e(_lang('Admin')); ?></option>
					</select>
				 </div>
				</div>

				
				<div class="form-group">
				  <div class="col-md-12">
					<button type="submit" class="btn btn-primary"><?php echo e(_lang('Update')); ?></button>
				  </div>
				</div>
			</form>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>

<script>
$("#user_type").val([<?php echo object_to_string($notice->user_type,'user_type',true); ?>]);

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>