<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default no-export">
			<div class="panel-heading"><span class="panel-title"><?php echo e(_lang('List Account')); ?></span>
			<a class="btn btn-primary btn-sm pull-right ajax-modal" data-title="<?php echo e(_lang('Add Account')); ?>" href="<?php echo e(route('accounts.create')); ?>"><?php echo e(_lang('Add New')); ?></a>
			</div>

			<div class="panel-body">
			 <?php if(\Session::has('success')): ?>
			  <div class="alert alert-success">
				<p><?php echo e(\Session::get('success')); ?></p>
			  </div>
			  <br />
			 <?php endif; ?>
			<table class="table table-bordered data-table">
			<thead>
			  <tr>
				<th><?php echo e(_lang('Account Name')); ?></th>
				<th><?php echo e(_lang('Opening Balance')); ?></th>
				<th><?php echo e(_lang('Note')); ?></th>
				<th><?php echo e(_lang('Action')); ?></th>
			  </tr>
			</thead>
			<tbody>
			  <?php $currency = get_option('currency_symbol') ?>
			  <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			  <tr id="row_<?php echo e($account->id); ?>">
				<td class='account_name'><?php echo e($account->account_name); ?></td>
				<td class='opening_balance'><?php echo e($currency." ".decimalPlace($account->opening_balance)); ?></td>
				<td class='note'><?php echo e($account->note); ?></td>
				<td>
				  <form action="<?php echo e(action('AccountController@destroy', $account['id'])); ?>" method="post">
					<a href="<?php echo e(action('AccountController@edit', $account['id'])); ?>" data-title="<?php echo e(_lang('Update Account')); ?>" class="btn btn-warning btn-sm ajax-modal"><?php echo e(_lang('Edit')); ?></a>
					<a href="<?php echo e(action('AccountController@show', $account['id'])); ?>" data-title="<?php echo e(_lang('View Account')); ?>" class="btn btn-info btn-sm ajax-modal"><?php echo e(_lang('View')); ?></a>
					<?php echo e(csrf_field()); ?>

					<input name="_method" type="hidden" value="DELETE">
					<button class="btn btn-danger btn-sm btn-remove" type="submit"><?php echo e(_lang('Delete')); ?></button>
				  </form>
				</td>
			  </tr>
			  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		  </table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>