
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="header">
				<div class="col-md-6">
					<h4 class="title"><?php echo e(_lang('Parents List')); ?></h4>
				</div>
				<div class="col-md-6" style="text-align: right;">
					<a href="<?php echo e(route('parents.create')); ?>" class="btn btn-info btn-sm"><?php echo e(_lang('Add New Parent')); ?></a>
				</div>
			</div>
			<div class="content no-export">
				<table class="table table-bordered data-table">
					<thead>
						<th><?php echo e(_lang('Profile')); ?></th>
						<th><?php echo e(_lang('Name')); ?></th>
						<th><?php echo e(_lang('Student')); ?></th>
						<th><?php echo e(_lang('Email')); ?></th>
						<th><?php echo e(_lang('Action')); ?></th>
					</thead>
					<tbody>
						<?php $__currentLoopData = $parents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td><img src="<?php echo e(asset('public/uploads/images/'.$data->image)); ?>" width="50px" alt=""></td>
							<td><?php echo e($data->name); ?></td>
							<td><?php echo e($data->first_name." ".$data->last_name); ?></td>
							<td><?php echo e($data->email); ?></td>
							<td>	
								<form action="<?php echo e(route('parents.destroy',$data->id)); ?>" method="post">
									<a href="<?php echo e(route('parents.show',$data->id)); ?>" class="btn btn-info btn-xs"><i class="fa fa-eye" aria-hidden="true"></i></a>
								    <a href="<?php echo e(route('parents.edit',$data->id)); ?>" class="btn btn-warning btn-xs"><i class="fa fa-pencil" aria-hidden="true"></i></a>
									<?php echo e(method_field('DELETE')); ?>

    								<?php echo csrf_field(); ?>
    								<button type="submit" class="btn btn-danger btn-xs btn-remove"><i class="fa fa-eraser" aria-hidden="true"></i></button>
								</form>
							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>

$(document).ready(function () {

});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>