

<?php $__env->startSection('content'); ?>

<script>

	var totalIncome = 0;
	var totalExpense = 0;
	
</script>
<form action="<?php echo e(url('/transactions/accounting/cashbook')); ?>" method="get" autocomplete="off" target="_blank">
	<div class="row">			
				<div class="col-md-5">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Date From')); ?></label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="date" class="form-control date_from" name="date_from" id="date_from" value="">
							</div>
						</div>
				</div>
					
				<div class="col-md-5">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Date To')); ?></label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="date" class="form-control date_to" name="date_to" id="date_to" value="">
							</div>
						</div>
				</div>

			<div class="col-md-2">
				<div class="form-group pull-right">
					<button type="button" onclick="getAllRecordsForIncomeTable();" style="margin-top:24px;" class="btn btn-success rect-btn"><?php echo e(_lang('Generate')); ?></button>
				</div>
			</div>
	</div>
</form>

<hr>
<h3 class="text-primary text-center" style="margin-right:150px;">Cash Book</h3>
<div class="row">
	<div class="col-md-6">
		<p class="text-success h3 text-center" style="margin-right:150px;" id="lbIncome">Income</p>	
	</div>  
	<div class="col-md-6">		
		<p class="text-danger h3 text-center" style="margin-right:150px;" id="lbExpenses">Expenses</p>	 
	</div> 
</div> 
<div class="row" style="margin-top:20px;">
        <div class="col-md-5">			 	 
            <table id="tblIncomeRecords" class="table table-bordered">
                <thead>            
                    <tr>
                        <!-- <th><?php echo e(_lang('ID')); ?></th> -->
                        <th><?php echo e(_lang('Date')); ?></th>
                        <th><?php echo e(_lang('Account')); ?></th>
                    	<th><?php echo e(_lang('Description')); ?></th>
                        <th><?php echo e(_lang('Amount')); ?></th>
                        <th><?php echo e(_lang('Total')); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
	 
        <div class="col-md-5" style="margin-left:80px;">	
            <table id="tblExpenseRecords" class="table table-bordered">
                    <thead>
                        <tr>
                            <!-- <th><?php echo e(_lang('ID')); ?></th> -->
                            <th><?php echo e(_lang('Date')); ?></th>
                            <th><?php echo e(_lang('Account')); ?></th>
                            <th><?php echo e(_lang('Description')); ?></th>
                            <th><?php echo e(_lang('Amount')); ?></th>
                        	<th><?php echo e(_lang('Total')); ?></th>
                        </tr>
                    </thead>
            </table>
        </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('js-script'); ?>
<script>

function getAllRecordsForIncomeTable() 
{
	$("#preloader").css("display","block");
	var url="<?php echo e(url('/transactions/income')); ?>";
	url += "?date_from="+$('#date_from').val()+"&date_to="+$('#date_to').val();

	$('#tblIncomeRecords').DataTable().destroy();
	$.fn.dataTable.ext.errMode = 'none';    //Suppressing Warnings in DataTables
	$("#tblIncomeRecords").DataTable(
	{
	"processing": true, // for show progress bar
	// "serverSide": true, // for process server side
	"filter": true, // this is for disable filter (search box)
	"orderMulti": false, // for disable multiple column at once
	"pageLength": 25,         
	"initComplete": function (settings, json) {

		// console.log(json);
        getAllRecordsForExpenseTable();
		$("#preloader").css("display","none");
	},

	"ajax": {

	"url": url,
	"type": "GET",
	"datatype":"json"
	},
	"columns": [                   
	// { "data": "id", name: 'id' },
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["trans_date"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["account_name"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["c_type"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			totalIncome = Number(totalIncome) + Number(full["amount"]);
			return (full["amount"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return totalIncome;
		}
	},
	],
	"order": [[0, "desc", ]],
               "dom": '<"top"lf>rt<"bottom"Bip><"clear">',
               "buttons": [
                   {
                       extend: 'copy',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text:'<i class="fa fa-clone"> </i>'
                   },
                   {
                       extend: 'excel',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text: '<i class="fa fa-file-excel-o"> </i>'
                   },
                   {
                       extend: 'csv',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text: '<i class="fa fa-file"> </i>'
                   },
                   {
                       extend: 'pdf',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text: '<i class="fa fa-file-pdf-o"> </i>'
                   },
                   {
                       extend: 'print',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text: '<i class="fa fa-print"> </i>'
                   },
                   'colvis'

               ],
               //responsive: true

	});
}


function getAllRecordsForExpenseTable() 
{
	$("#preloader").css("display","block");
	var url="<?php echo e(url('/transactions/expense')); ?>";
	url += "?date_from="+$('#date_from').val()+"&date_to="+$('#date_to').val();

	$('#tblExpenseRecords').DataTable().destroy();
	$.fn.dataTable.ext.errMode = 'none';    //Suppressing Warnings in DataTables
	$("#tblExpenseRecords").DataTable(
	{
	"processing": true, // for show progress bar
	// "serverSide": true, // for process server side
	"filter": true, // this is for disable filter (search box)
	"orderMulti": false, // for disable multiple column at once
	"pageLength": 25,               
	"initComplete": function (settings, json) {

		// console.log(json);

		$("#preloader").css("display","none");
	},        
	"fnInitComplete": function (oSettings, json) {
		
		$("#lbIncome").text("Income : "+(totalIncome/4));
		$("#lbExpenses").text("Expenses : "+(totalExpense/4));

		// alert($("#tblExpenseRecords tr:last td:eq(4)").text());
    },

	"ajax": {

	"url": url,
	"type": "GET",
	"datatype":"json"
	},
	"columns": [                   
	// { "data": "id", name: 'id' },
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["trans_date"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["account_name"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return (full["c_type"] + ", " + full["reference"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			totalExpense = Number(totalExpense) + Number(full["amount"]);
			return (full["amount"]);
		}
	},
	{
		"data": null, class:'',width: '5px',
		"render": function (data, type, full, meta) {

			return totalExpense;
		}
	},
	],
	"order": [[0, "desc", ]],
               "dom": '<"top"lf>rt<"bottom"Bip><"clear">',
               "buttons": [
                   {
                       extend: 'copy',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text:'<i class="fa fa-clone"> </i>'
                   },
                   {
                       extend: 'excel',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text: '<i class="fa fa-file-excel-o"> </i>'
                   },
                   {
                       extend: 'csv',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text: '<i class="fa fa-file"> </i>'
                   },
                   {
                       extend: 'pdf',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text: '<i class="fa fa-file-pdf-o"> </i>'
                   },
                   {
                       extend: 'print',
                       messageTop: '\n',
                       messageBottom: '\n',
					   exportOptions: {
                           columns: ':visible'
                        //    columns: [0, 1, 2, 3, 4]
                       },
                       text: '<i class="fa fa-print"> </i>'
                   },
                   'colvis'

               ],
               //responsive: true

	});
}

$(document).ready(function () {

//Date settings
var now = new Date();
var day = ("0" + now.getDate()).slice(-2);
var month = ("0" + (now.getMonth() + 1)).slice(-2);
var date_from = now.getFullYear()+"-"+(month)+"-"+("01");
var date_to = now.getFullYear()+"-"+(month)+"-"+(day);
$('#date_from').val(date_from);
$('#date_to').val(date_to);

});

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>