<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<div class="panel-title" >
					<?php echo e(_lang('Staff Attendance')); ?>

				</div>
			</div>
			<div class="panel-body">
				<form id="search_form" class="params-panel validate" action="<?php echo e(url('staff/attendance')); ?>" method="post" autocomplete="off" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<div class="col-sm-4">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Role')); ?></label>
							<select name="user_type" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<option <?php if($user_type=='Admin'): ?> selected <?php endif; ?> value="Admin"><?php echo e(_lang('Admin')); ?></option>
								<option <?php if($user_type=='Teacher'): ?> selected <?php endif; ?> value="Teacher"><?php echo e(_lang('Teacher')); ?></option>
								<option <?php if($user_type=='Accountant'): ?> selected <?php endif; ?> value="Accountant"><?php echo e(_lang('Accountant')); ?></option>
								<option <?php if($user_type=='Librarian'): ?> selected <?php endif; ?> value="Librarian"><?php echo e(_lang('Librarian')); ?></option>
								<option <?php if($user_type=='Employee'): ?> selected <?php endif; ?> value="Employee"><?php echo e(_lang('Employee')); ?></option>
							</select>
						</div>
					</div>
					<div class="col-sm-4">
						<div class="form-group">
							<label for="date" class="control-label"><?php echo e(_lang('Date')); ?></label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="text" class="form-control datepicker" name="date" value="<?php echo e($date); ?>" required>
						    </div>
						</div>
					</div>
					<div class="col-sm-4">
						<div class="form-group">
							<button type="submit" style="margin-top:24px;" class="btn btn-primary btn-block rect-btn"><?php echo e(_lang('Manage Attendance')); ?></button>
						</div>
					</div>
				</form>
				<?php if( !empty($attendance) ): ?>
				<div class="col-md-12">	
					<div class="panel-heading text-center">
						<div class="panel-title" >
							<?php echo e(_lang('Attendance Details')); ?><br>
							<?php echo e(date('d-M-Y', strtotime($date))); ?><br>
						</div>
					</div>
					<form action="<?php echo e(url('staff/attendance/save')); ?>" class="appsvan-submit-validate" method="post" accept-charset="utf-8">
						<?php echo csrf_field(); ?>
						<table class="table table-bordered">
							<thead>
								<th><?php echo e(_lang('Name')); ?></th>
								<th><label class="c-container"><?php echo e(_lang('Present')); ?><input type="checkbox" id="present_all" onclick="present(this)"><span class="checkmark"></span></label></th>
								<th><label class="c-container"><?php echo e(_lang('Absent')); ?><input type="checkbox" id="absent_all" onclick="absent(this)"><span class="checkmark"></span></label></th>
								<th><label class="c-container"><?php echo e(_lang('Late')); ?><input type="checkbox" id="late_all" onclick="late(this)"><span class="checkmark"></span></label></th>
								<th><label class="c-container"><?php echo e(_lang('Holiday')); ?><input type="checkbox" id="holiday_all" onclick="holiday(this)"><span class="checkmark"></span></label></th>
							</thead>
							<tbody>
								<?php $__currentLoopData = $attendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($data->name); ?></td>
									<input type="hidden" name="date" value="<?php echo e($date); ?>">
									<input type="hidden" name="attendance_id[]" value="<?php echo e($data->attendance_id); ?>">
									<input type="hidden" name="user_id[]" value="<?php echo e($data->user_id); ?>">
									<td><label class="c-container"><input type="checkbox" name="attendance[<?php echo e($key); ?>][]" <?php if($data->attendance=='1'): ?> checked <?php endif; ?> value="1" class="present"><span class="checkmark"></span></td>
									<td><label class="c-container"><input type="checkbox" name="attendance[<?php echo e($key); ?>][]" <?php if($data->attendance=='2'): ?> checked <?php endif; ?> value="2" class="absent"><span class="checkmark"></span></td>
									<td><label class="c-container"><input type="checkbox" name="attendance[<?php echo e($key); ?>][]" <?php if($data->attendance=='3'): ?> checked <?php endif; ?> value="3" class="late"><span class="checkmark"></span></td>
								    <td><label class="c-container"><input type="checkbox" name="attendance[<?php echo e($key); ?>][]" <?php if($data->attendance=='4'): ?> checked <?php endif; ?> value="4" class="holiday"><span class="checkmark"></span></label></td>
								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<tr>
								  <td colspan="100"><button type="submit" class="btn btn-primary pull-right"><?php echo e(_lang('Save Attendance')); ?></button></td>
								</tr>
							</tbody>
						</table>
					</form>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script type="text/javascript">
	$("input:checkbox").on('click', function() {
		var $box = $(this);
		if ($box.is(":checked")) {
			var group = "input:checkbox[name='" + $box.attr("name") + "']";
			$(group).prop("checked", false);
			$box.prop("checked", true);
		} else {
			$box.prop("checked", false);
		}
	});

	function present(source) {
		$(".absent,.late,.present,.holiday,#late_all,#absent_all,#holiday_all").prop("checked",false);
		var checkboxes = document.querySelectorAll('.present');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}
	function absent(source) {
		$(".absent,.late,.present,.holiday,#present_all,#late_all,#holiday_all").prop("checked",false);
		var checkboxes = document.querySelectorAll('.absent');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}
	function late(source) {
		$(".absent,.late,.present,.holiday,#present_all,#absent_all,#holiday_all").prop("checked",false);
		var checkboxes = document.querySelectorAll('.late');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}
	
	function holiday(source) {
		$(".absent,.late,.present,.holiday,#present_all,#absent_all").prop("checked",false);
		var checkboxes = document.querySelectorAll('.holiday');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i] != source)
				checkboxes[i].checked = source.checked;
		}
	}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>