<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			
			<div class="panel-heading"><span class="panel-title"><?php echo e(_lang('List Expense')); ?></span>
			
			<a class="btn btn-primary btn-sm pull-right" data-title="<?php echo e(_lang('Add Expense')); ?>" href="<?php echo e(url('transactions/add_expense')); ?>"><?php echo e(_lang('Add New')); ?></a>
			</div>

			<div class="panel-body">
			 <?php if(\Session::has('success')): ?>
			  <div class="alert alert-success">
				<p><?php echo e(\Session::get('success')); ?></p>
			  </div>
			  <br />
			 <?php endif; ?>
			<table class="table table-bordered data-table">
			<thead>
			  <tr>
				<th><?php echo e(_lang('Date')); ?></th>
				<th><?php echo e(_lang('Account')); ?></th>
				<th><?php echo e(_lang('Amount')); ?></th>
				<th><?php echo e(_lang('Expense Type')); ?></th>
				<th><?php echo e(_lang('Payer')); ?></th>
				<th><?php echo e(_lang('Payment Method')); ?></th>
				<th><?php echo e(_lang('Action')); ?></th>
			  </tr>
			</thead>
			<tbody>
			  
			  <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			  <tr id="row_<?php echo e($transaction->id); ?>">
				<td class='trans_date'><?php echo e($transaction->trans_date); ?></td>
				<td class='account_id'><?php echo e($transaction->account_name); ?></td>
				<td class='amount'><?php echo e($transaction->amount); ?></td>
				<td class='chart_id'><?php echo e($transaction->c_type); ?></td>
				<td class='payee_payer_id'><?php echo e($transaction->payee_payer); ?></td>
				<td class='payment_method_id'><?php echo e($transaction->payment_method); ?></td>
				<td>
				  <form action="<?php echo e(action('TransactionController@destroy', $transaction['id'])); ?>" method="post">
					<a href="<?php echo e(action('TransactionController@edit', $transaction['id'])); ?>" data-title="<?php echo e(_lang('Update Income')); ?>" class="btn btn-warning btn-sm"><?php echo e(_lang('Edit')); ?></a>
					<a href="<?php echo e(action('TransactionController@show', $transaction['id'])); ?>" data-title="<?php echo e(_lang('View Income')); ?>" class="btn btn-info btn-sm ajax-modal"><?php echo e(_lang('View')); ?></a>
					<?php echo e(csrf_field()); ?>

					<input name="_method" type="hidden" value="DELETE">
					<button class="btn btn-danger btn-sm btn-remove" type="submit"><?php echo e(_lang('Delete')); ?></button>
				  </form>
				</td>
			  </tr>
			  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		  </table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>