
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-4">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<div class="panel-title" >
					<?php echo e(_lang('Add New Vehicle')); ?>

				</div>
			</div>
			<div class="panel-body">
				<form action="<?php echo e(route('transportvehicles.store')); ?>" class="form-horizontal validate" enctype="multipart/form-data" method="post" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<div class="form-group">
					    <div class="col-md-12">
						    <label class="control-label"><?php echo e(_lang('Vehicle Name')); ?></label>
							<input type="text" class="form-control" name="vehicle_name" value="<?php echo e(old('vehicle_name')); ?>" placeholder="Vehicle Name" required>
						</div>
					</div>
					<div class="form-group">
					    <div class="col-md-12">
						    <label class="control-label"><?php echo e(_lang('Serial Number')); ?></label>
							<input type="text" class="form-control" name="serial_number" value="<?php echo e(old('serial_number')); ?>" placeholder="Serial Number" required>
						</div>
					</div>
					<div class="form-group">
						<div class="col-md-12">
							<button type="submit" class="btn btn-primary"><?php echo e(_lang('Add Vehicle')); ?></button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
	<div class="col-md-8">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<div class="panel-title" >
					<?php echo e(_lang('Vehicles List')); ?>

				</div>
			</div>
			<div class="panel-body no-export">
				<table class="table table-bordered data-table">
					<thead>
						<th>#</th>		
						<th><?php echo e(_lang('Vehicle Name')); ?></th>
						<th><?php echo e(_lang('Serial Number')); ?></th>
						<th><?php echo e(_lang('Action')); ?></th>
					</thead>
					<tbody>
						<?php $i = 1; ?>
						<?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						 <tr>
							<td><?php echo e($i); ?></td>
							<td><?php echo e($data->vehicle_name); ?></td>
							<td><?php echo e($data->serial_number); ?></td>
							<td>
								<form action="<?php echo e(route('transportvehicles.destroy',$data->id)); ?>" method="post">
								    <a href="<?php echo e(route('transportvehicles.edit',$data->id)); ?>" class="btn btn-warning btn-xs"><i class="fa fa-pencil" aria-hidden="true"></i></a>
									<?php echo e(method_field('DELETE')); ?>

    								<?php echo csrf_field(); ?>
    								<button type="submit" class="btn btn-danger btn-xs btn-remove"><i class="fa fa-eraser" aria-hidden="true"></i></button>
								</form>
							</td>
						</tr>
						<?php $i++; ?>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>