
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading">
				<span class="panel-title" >
					<?php echo e(_lang('Inbox')); ?>

				</span>
				<a href="<?php echo e(url('message/compose')); ?>" class="btn btn-primary btn-sm pull-right"><?php echo e(_lang('New Message')); ?></a>
			</div>
			<div class="panel-body no-export">
				<table class="table table-bordered">
					<thead>
						<th><?php echo e(_lang('Date')); ?></th>
						<th><?php echo e(_lang('Sender')); ?></th>
						<th><?php echo e(_lang('Subject')); ?></th>
						<th><?php echo e(_lang('View')); ?></th>
					</thead>
					<tbody>
						<?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr <?php echo e($data->read =='n' ? "style=font-weight:bold" : ""); ?>>
							<td><?php echo e(date('d/M/Y - H:m', strtotime($data->date))); ?></td>
							<td><?php echo e($data->sender); ?></td>
							<td><?php echo e($data->subject); ?></td>
							<td><a href="<?php echo e(url('message/inbox/'.$data->id)); ?>" data-title="<?php echo e(_lang('View Message')); ?>" class="btn btn-primary btn-sm ajax-modal"><?php echo e(_lang('View')); ?></a></td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
				
				<div class="pull-right">
					<?php echo e($messages->links()); ?>

				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
$(document).on('click','.ajax-modal',function(){
	$(this).parent().parent().css("font-weight","normal");
	var inbox_count = parseInt($(".inbox-count").html());
	if(inbox_count == 1){
	   $(".inbox-count").remove();
	}else{
	   $(".inbox-count").html(inbox_count-1);
	}
	
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>