@extends('layouts.backend')
@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <span class="panel-title">{{ _lang('Student List Report') }}</span>
            </div>
            
            <div class="panel-body">
                <form id="search_form" class="params-panel validate" action="{{ url('reports/student_report/view') }}" method="post" autocomplete="off">
                    @csrf
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="control-label">{{ _lang('Floor') }}</label>
                            <select name="class_id" class="form-control select2" onChange="getData(this.value);" required>
                                <option value="">{{ _lang('Select Floor') }}</option>
                                {{ create_option('classes','id','class_name',$class_id) }}
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="control-label">{{ _lang('Room') }}</label>
                            <select name="section_id" class="form-control select2">
                                <option value="">{{ _lang('All Rooms') }}</option> @if($class_id != 0)
                                    {{ create_option('sections','id','section_name',$section_id, array("class_id="=>$class_id)) }}
                                @endif
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <button type="submit" style="margin-top:24px;" class="btn btn-primary btn-block">{{ _lang('View Report') }}</button>
                        </div>
                    </div>
                </form>

                @if(isset($students))
                <div class="col-md-12 params-panel" id="printable_area">
                    <button type="button" data-print="printable_area" class="btn btn-primary btn-sm pull-right print"><i class="fa fa-print"></i> {{ _lang('Print Report') }}</button>
                    
                    <div class="text-center clear">
                        <h3 style="margin-bottom:0;">{{ get_option('school_name') }}</h3>
                        <h4 style="margin-top:5px; color: #555;">{{ _lang('Student List Report') }}</h4>
                        <p><b>{{ _lang('Floor') }}:</b> {{ $class_name }} | <b>{{ _lang('Room') }}:</b> {{ $section_name }}</p>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center" width="10%">{{ _lang('Photo') }}</th>
                                    <th>{{ _lang('Name') }}</th>
                                    <th>{{ _lang('CNIC / Reg No') }}</th>
                                    <th>{{ _lang('Phone') }}</th>
                                    <th>{{ _lang('Room') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($students as $student)
                                <tr>
                                    <td class="text-center">
                                       <img src="{{ $student->photo ? asset('uploads/images/'.$student->photo) : asset('uploads/images/profile.png') }}" 
     										style="width:50px; height:50px; object-fit:cover; border:1px solid #ddd; border-radius:4px;">
                                    </td>
                                    <td style="vertical-align: middle;">{{ $student->first_name }} {{ $student->last_name }}</td>
                                    <td style="vertical-align: middle;">{{ $student->register_no }}</td>
                                    <td style="vertical-align: middle;">{{ $student->phone }}</td>
                                    <td style="vertical-align: middle;">{{ $student->room_name }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center">{{ _lang('No Records Found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('js-script')
<script type="text/javascript">
    function getData(val) {
        var _token=$('input[name=_token]').val();
        $.ajax({
            type: "POST",
            url: "{{url('sections/section')}}",
            data:{_token:_token, class_id:val},
            beforeSend: function(){
                $("#preloader").css("display","block");
            },success: function(sections){
                $("#preloader").css("display","none");
                // Prepend the "All Rooms" option so it's always available
                $('select[name=section_id]').html('<option value="">{{ _lang("All Rooms") }}</option>' + sections);                
            }
        });
    }
</script>
@stop