<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Fee Summary Report</title>
    <?php echo $__env->make('backend.pdf.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
<?php echo $__env->make('backend.pdf.layouts.report-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<main>

    <table class="table" id="feeSummaryTable" width="100%" cellspacing="0">
        <thead>
        <tr>
            <th style="text-align: left;" width="15%"><?php echo e(_lang('Room#')); ?></th>
            <th style="text-align: left;" width="15%"><?php echo e(_lang('Date')); ?></th>
            <th style="text-align: left;" width="35%"><?php echo e(_lang('Student Information')); ?></th>
            <?php if(count($fees) > 0): ?>
                <?php $__currentLoopData = $fees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th class="text-right" width="7%"><?php echo e($fee->fee_type); ?></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <th class="text-right" width="10%"><?php echo e(_lang('Total')); ?></th>
                <th class="text-right" width="10%"><?php echo e(_lang('Paid')); ?></th>
                <th class="text-right" width="10%"><?php echo e(_lang('Balance')); ?></th>
            <?php endif; ?>
        </tr>
        </thead>
        <tbody>
        <?php
            $tot_Paid = 0;
            $tot_Total = 0;
            $tot_Balance = 0;
            $eachList = [];

            foreach($fees as $fee) {
                $eachList[$fee->id] = 0;
            }
        ?>

        <?php if(count($invoices) > 0): ?>
            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <th style="text-align: left;"><?php echo e($invoice->section_name); ?></th>
                    <th style="text-align: left;"><?php echo e(date('d-M-Y', strtotime($invoice->payment_date))); ?></th>
                    <th style="text-align: left;">
                        <?php echo e($invoice->register_no); ?>-<?php echo e($invoice->first_name); ?>-<?php echo e($invoice->class_name); ?>-<?php echo e($invoice->title); ?>

                    </th>

                    <?php if(count($fees) > 0): ?>
                        <?php $total = 0; ?>

                        <?php $__currentLoopData = $fees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $item_price = 0; ?>

                            <?php if(count($invoice->invoice_item) > 0): ?>
                                <?php $__currentLoopData = $invoice->invoice_item; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($item->fee_id == $fee->id): ?>
                                        <?php
                                            $item_price = $item->amount - $item->discount;
                                            $eachList[$fee->id] += $item_price;
                                        ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                            <?php $total += $item_price; ?>
                            <td class="text-right"><?php echo e($item_price); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <td class="text-right"><?php echo e($total); ?></td>

                        <?php
                            $tot_Total += $total;
                            $tot_Paid += $invoice->paid;
                            $tot_Balance += ($total - $invoice->paid);
                        ?>

                        <td class="text-right"><?php echo e($invoice->paid); ?></td>
                        <td class="text-right"><?php echo e($total - $invoice->paid); ?></td>
                    <?php endif; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <!-- Totals row -->
        <tr>
            <td colspan="3"><b>Totals</b></td>
            <?php $__currentLoopData = $fees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <td class="text-right"><b><?php echo e($eachList[$fee->id]); ?></b></td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <td class="text-right"><b><?php echo e($tot_Total); ?></b></td>
            <td class="text-right"><b><?php echo e($tot_Paid); ?></b></td>
            <td class="text-right"><b><?php echo e($tot_Balance); ?></b></td>
        </tr>
        </tbody>
    </table>
</main>
<?php echo $__env->make('backend.pdf.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH C:\htdocs\hostel\resources\views/backend/pdf/reports/fee_summary.blade.php ENDPATH**/ ?>