<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo e(@$title); ?></title>
    <?php echo $__env->make('backend.pdf.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body >
<?php echo $__env->make('backend.pdf.layouts.report-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<main>
    <?php $grandTotal=0; ?>
    <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class_row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <p><b>Floor : </b> <?php echo e($class_row->class_name); ?></p>
    <table class="table" width="100%" cellspacing="0">
        <thead>
        <tr>
            <th style="text-align: left;" width="5%"><?php echo e(_lang('SL#')); ?></th>
            <th style="text-align: left;" width="10%"><?php echo e(_lang('Reg No#')); ?></th>
            <th style="text-align: left;" width="25%"><?php echo e(_lang('Student Information')); ?></th>
            <th style="text-align: left;" width="15%"><?php echo e(_lang('Room')); ?></th>
            <th style="text-align: left;" width="20%"><?php echo e(_lang('Contact')); ?></th>
            <th class="text-center" width="10%"><?php echo e(_lang('Months')); ?></th>
            <th class="text-right" width="10%"><?php echo e(_lang('Total')); ?></th>
        </tr>
        </thead>
        <tbody>
            <?php $subTotal=0; ?>
            <?php if(count($invoices)>0): ?>
            <?php $count=0; ?>
            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($invoice[0]->class_id==$class_row->id): ?>
            <tr>
                <th style="text-align: left;"><?php echo e(++$count); ?></th>
                <th style="text-align: left;"><?php echo e($invoice[0]->register_no); ?></th>
                <th style="text-align: left;"><?php echo e($invoice[0]->first_name); ?></th>
                <th style="text-align: left;"><?php echo e($invoice[0]->section_name); ?></th>
                <td style="text-align: left;"><?php echo e($invoice[0]->phone); ?><br/>
                    <?php if($invoice[0]->home_phone): ?>
                    <?php echo e(_lang('Home Phone')); ?> : <?php echo e($invoice[0]->home_phone); ?>

                    <?php endif; ?>
                </td>
                <td><?php echo e(count($invoice)); ?> <?php echo e(('months')); ?></td>
                <td class="text-right">
                    <?php echo e(collect($invoice)->sum('total')-collect($invoice)->sum('paid')); ?>

                    <?php $subTotal= $subTotal + (collect($invoice)->sum('total')-collect($invoice)->sum('paid')); ?>
                </td>
            </tr>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>            
            <tr>
                <th colspan="6">Floor Total: </th>
                <th colspan=""><?php echo $subTotal; ?> </th>
                <?php $grandTotal=$grandTotal+$subTotal; ?>
            </tr>
        </tbody>
    </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <br><br>
    <h1><?php echo "Grand Total: ".$grandTotal; ?> </h1>
</main>
<?php echo $__env->make('backend.pdf.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH C:\htdocs\hostel\resources\views/backend/pdf/reports/unpaid_summary.blade.php ENDPATH**/ ?>