
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default" data-collapsed="0">
			<div class="panel-heading">
				<div class="panel-title" >
					<?php echo e(_lang('Update Employee')); ?>

				</div>
			</div>
			<div class="panel-body">
			  <div class="col-md-8">
				<form action="<?php echo e(route('teachers.update',$teacher->id)); ?>" autocomplete="off" class="form-horizontal validate" enctype="multipart/form-data" autocomplete="off" method="post" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<?php echo e(method_field('PATCH')); ?>

					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Name')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="name" value="<?php echo e($teacher->name); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Designation')); ?></label>
						<div class="col-sm-9">
						    <select class="form-control select2" name="designation" required>
							   <option value=""><?php echo e(_lang('Select One')); ?></option>
							   <?php echo e(create_option("picklists","value","value",$teacher->designation,array("type="=>"Designation"))); ?>	
							</select>
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Birthday')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control datepicker" name="birthday" value="<?php echo e($teacher->birthday); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Gender')); ?></label>
						<div class="col-sm-9">
							<select name="gender" class="form-control select2" required>
								<option <?php if($teacher->gender=='Male'): ?> selected <?php endif; ?> value="Male">Male</option>
								<option <?php if($teacher->gender=='Female'): ?> selected <?php endif; ?> value="Female">Female</option>
							</select>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Religion')); ?></label>
						<div class="col-sm-9">
						    <select name="religion" class="form-control niceselect wide" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<?php echo e(create_option("picklists","value","value",$teacher->religion,array("type="=>"Religion"))); ?>	
							</select>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Phone')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control" name="phone" value="<?php echo e($teacher->phone); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Address')); ?></label>
						<div class="col-sm-9">
							<textarea class="form-control" name="address" required><?php echo e($teacher->address); ?></textarea>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Joining Date')); ?></label>
						<div class="col-sm-9">
							<input type="text" class="form-control datepicker" name="joining_date" value="<?php echo e($teacher->joining_date); ?>" required>
						</div>
					</div>
					
					<hr>
					<div class="page-header">
					  <h4>Login Details</h4>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Email')); ?></label>
						<div class="col-sm-9">
							<input type="email" class="form-control" name="email" value="<?php echo e($teacher->email); ?>" required>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Password')); ?></label>
						<div class="col-sm-9">
							<input type="password" class="form-control" name="password">
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Confirm Password')); ?></label>
						<div class="col-sm-9">
							<input type="password" class="form-control" name="password_confirmation">
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-sm-3 control-label"><?php echo e(_lang('Profile Picture')); ?></label>
						<div class="col-sm-9">
							<input type="file" class="form-control dropify" name="image" data-default-file="<?php echo e(asset('uploads/images/'.$teacher->image)); ?>" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG">
						</div>
					</div>

					<div class="form-group">
						<div class="col-sm-offset-3 col-sm-5">
							<button type="submit" class="btn btn-info"><?php echo e(_lang('Update Employee')); ?></button>
						</div>
					</div>
				</form>
			   </div>	
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\hostel\resources\views/backend/teachers/teacher-edit.blade.php ENDPATH**/ ?>