
<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <span class="panel-title"><?php echo e(_lang('Student List Report')); ?></span>
            </div>
            
            <div class="panel-body">
                <form id="search_form" class="params-panel validate" action="<?php echo e(url('reports/student_report/view')); ?>" method="post" autocomplete="off">
                    <?php echo csrf_field(); ?>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="control-label"><?php echo e(_lang('Floor')); ?></label>
                            <select name="class_id" class="form-control select2" onChange="getData(this.value);" required>
                                <option value=""><?php echo e(_lang('Select Floor')); ?></option>
                                <?php echo e(create_option('classes','id','class_name',$class_id)); ?>

                            </select>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="control-label"><?php echo e(_lang('Room')); ?></label>
                            <select name="section_id" class="form-control select2">
                                <option value=""><?php echo e(_lang('All Rooms')); ?></option> <?php if($class_id != 0): ?>
                                    <?php echo e(create_option('sections','id','section_name',$section_id, array("class_id="=>$class_id))); ?>

                                <?php endif; ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="form-group">
                            <button type="submit" style="margin-top:24px;" class="btn btn-primary btn-block"><?php echo e(_lang('View Report')); ?></button>
                        </div>
                    </div>
                </form>

                <?php if(isset($students)): ?>
                <div class="col-md-12 params-panel" id="printable_area">
                    <button type="button" data-print="printable_area" class="btn btn-primary btn-sm pull-right print"><i class="fa fa-print"></i> <?php echo e(_lang('Print Report')); ?></button>
                    
                    <div class="text-center clear">
                        <h3 style="margin-bottom:0;"><?php echo e(get_option('school_name')); ?></h3>
                        <h4 style="margin-top:5px; color: #555;"><?php echo e(_lang('Student List Report')); ?></h4>
                        <p><b><?php echo e(_lang('Floor')); ?>:</b> <?php echo e($class_name); ?> | <b><?php echo e(_lang('Room')); ?>:</b> <?php echo e($section_name); ?></p>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center" width="10%"><?php echo e(_lang('Photo')); ?></th>
                                    <th><?php echo e(_lang('Name')); ?></th>
                                    <th><?php echo e(_lang('CNIC / Reg No')); ?></th>
                                    <th><?php echo e(_lang('Phone')); ?></th>
                                    <th><?php echo e(_lang('Room')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="text-center">
                                       <img src="<?php echo e($student->photo ? asset('uploads/images/'.$student->photo) : asset('uploads/images/profile.png')); ?>" 
     style="width:50px; height:50px; object-fit:cover; border:1px solid #ddd; border-radius:4px;">
                                    </td>
                                    <td style="vertical-align: middle;"><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></td>
                                    <td style="vertical-align: middle;"><?php echo e($student->register_no); ?></td>
                                    <td style="vertical-align: middle;"><?php echo e($student->phone); ?></td>
                                    <td style="vertical-align: middle;"><?php echo e($student->room_name); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center"><?php echo e(_lang('No Records Found')); ?></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script type="text/javascript">
    function getData(val) {
        var _token=$('input[name=_token]').val();
        $.ajax({
            type: "POST",
            url: "<?php echo e(url('sections/section')); ?>",
            data:{_token:_token, class_id:val},
            beforeSend: function(){
                $("#preloader").css("display","block");
            },success: function(sections){
                $("#preloader").css("display","none");
                // Prepend the "All Rooms" option so it's always available
                $('select[name=section_id]').html('<option value=""><?php echo e(_lang("All Rooms")); ?></option>' + sections);                
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\htdocs\hostel\resources\views/backend/reports/student_report.blade.php ENDPATH**/ ?>