

<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default no-export">
			<div class="panel-heading"><span class="panel-title"><?php echo e(_lang('Picklist')); ?></span>
			<select id="type" class="select_class pull-right" onchange="show(this);">
			   <option value="all" ><?php echo e(_lang('-- All Types --')); ?></option>
			   <option>Religion</option>
			   <option>Designation</option>
			</select>
			<a class="btn btn-primary btn-sm pull-right ajax-modal" data-title="<?php echo e(_lang('Add Picklist')); ?>" href="<?php echo e(route('picklists.create')); ?>"><?php echo e(_lang('Add New')); ?></a>
			</div>

			<div class="panel-body">
			 <?php if(\Session::has('success')): ?>
			  <div class="alert alert-success">
				<p><?php echo e(\Session::get('success')); ?></p>
			  </div>
			  <br />
			 <?php endif; ?>
			<table class="table table-bordered data-table">
			<thead>
			  <tr>
				<th>#</th>
				<th><?php echo e(_lang('Type')); ?></th>
				<th><?php echo e(_lang('Value')); ?></th>
				<th><?php echo e(_lang('Action')); ?></th>
			  </tr>
			</thead>
			<tbody>
			  
			  <?php $__currentLoopData = $picklists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $picklist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			  <tr id="row_<?php echo e($picklist->id); ?>">
				<td class='id'><?php echo e($picklist->id); ?></td>
				<td class='type'><?php echo e($picklist->type); ?></td>
				<td class='value'><?php echo e($picklist->value); ?></td>
					
				<td>
				  <form action="<?php echo e(action('PicklistController@destroy', $picklist['id'])); ?>" method="post">
					<a href="<?php echo e(action('PicklistController@edit', $picklist['id'])); ?>" data-title="<?php echo e(_lang('Update Picklist')); ?>" class="btn btn-warning btn-sm ajax-modal"><?php echo e(_lang('Edit')); ?></a>
					<?php echo e(csrf_field()); ?>

					<input name="_method" type="hidden" value="DELETE">
					<button class="btn btn-danger btn-sm btn-remove" type="submit"><?php echo e(_lang('Delete')); ?></button>
				  </form>
				</td>
			  </tr>
			  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		  </table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js-script'); ?>
<script>
	$(document).ready(function() {
		var currentType = "<?php echo e($type ?? 'all'); ?>";
		$("#type").val(currentType);
	});

	function show(elem){
		var value = $(elem).val();
		if(value == "all"){
			window.location = "<?php echo e(url('picklists')); ?>";
		}else{
			window.location = "<?php echo e(url('picklists/type')); ?>/"+value;
		}
	}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\htdocs\hostel\resources\views/backend/administration/picklist/list.blade.php ENDPATH**/ ?>