<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Fee Summary Report</title>
    <?php echo $__env->make('backend.pdf.layouts.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body >
<?php echo $__env->make('backend.pdf.layouts.report-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<main>


    <table class="table" id="feeSummaryTableWithDues" width="100%" cellspacing="0">
        <thead>
        <tr>
            <!--Headings of columns-->
        	<th style="text-align: left;" width="10%"><?php echo e(_lang('RoomNo#')); ?></th>
        	<th style="text-align: left;" width="10%"><?php echo e(_lang('Date')); ?></th>
        	<th style="text-align: left;" width="20%"><?php echo e(_lang('Student Information')); ?></th>
        	<th class="text-right" width="10%"><?php echo e(_lang('Prev.Dues')); ?></th>
        	<?php if(count($fees)>0): ?>
        	<?php $__currentLoopData = $fees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        	<th class="text-right" width="7%"><?php echo e($fee->fee_type); ?></th>
        	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        	<th class="text-right" width="10%"><?php echo e(_lang('Total')); ?></th>
			<th class="text-right" width="10%"><?php echo e(_lang('Paid')); ?></th>
        	<th class="text-right" width="10%"><?php echo e(_lang('Balance')); ?></th>
        	<?php endif; ?>
        </tr>
        </thead>
        <tbody>
            	<?php
            	    $previTotal=0;
            	    $previBottomTotal=0;
                    $tot_Paid = 0;
                    $tot_Total = 0;
                    $tot_Balance = 0;
                    $listLength=count($fees);
                    $eachList = array(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
                ?>
        	<?php if(count($invoices)>0): ?>
        	<?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<tr>
    <td><?php echo e($invoice->section_name); ?></td>
    <td><?php echo e($request->date_from ?? ''); ?></td>
    <td><?php echo e($invoice->register_no); ?>-<?php echo e($invoice->first_name); ?>-<?php echo e($invoice->class_name); ?></td>
    
    <td class="text-right">
        <?php
            $prevDue = $previousInvoices->firstWhere('student_id', $invoice->student_id);
            $prevBalance = $prevDue->total_dues ?? 0;
        ?>
        <?php echo e($prevBalance); ?>

    </td>

    <?php
        $total = 0;
    ?>

    <?php $__currentLoopData = $fees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            // Aggregate fee total from all invoice_items matching this student and fee
            $itemSum = \App\InvoiceItem::whereHas('invoice', function($q) use ($invoice, $request) {
                    $q->where('student_id', $invoice->student_id)
                      ->where('session_id', $request->session)
                      ->where('school_id', schoolId());
                    if (!empty($request->date_from)) {
                        $q->whereDate('due_date', '>=', now()->parse($request->date_from)->format('Y-m-d'));
                    }
                    if (!empty($request->date_to)) {
                        $q->whereDate('due_date', '<=', now()->parse($request->date_to)->format('Y-m-d'));
                    }
                })
                ->where('fee_id', $fee->id)
                ->sum(DB::raw('amount - discount'));

            $eachList[$fee->id] = ($eachList[$fee->id] ?? 0) + $itemSum;
            $total += $itemSum;
        ?>
        <td class="text-right"><?php echo e($itemSum); ?></td>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <td class="text-right"><?php echo e($total + $prevBalance); ?></td>
    <td class="text-right"><?php echo e($invoice->paid); ?></td>
    <td class="text-right"><?php echo e(($total + $prevBalance) - $invoice->paid); ?></td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php endif; ?>
            
            <!--Totals at the end-->
			<tr>
    <td colspan="3"><b>Totals (<?php echo e(count($invoices)); ?>)</b></td>
    <td class="text-right"><b><?php echo $previBottomTotal; ?></b></td>
    <?php
        $totalFeesSum = 0;
        foreach ($fees as $fee) {
            echo "<td class='text-right'><b>".($eachList[$fee->id] ?? 0)."</b></td>";
            $totalFeesSum += ($eachList[$fee->id] ?? 0);
        }
    ?>
    <td class="text-right"><b><?php echo $totalFeesSum + $previBottomTotal; ?></b></td>
    <td class="text-right"><b><?php echo $tot_Paid; ?></b></td>
    <td class="text-right"><b><?php echo ($totalFeesSum + $previBottomTotal) - $tot_Paid; ?></b></td>
</tr>



        </tbody>
    </table>
</main>
<?php echo $__env->make('backend.pdf.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html><?php /**PATH C:\htdocs\hostel\resources\views/backend/pdf/reports/fee_summary_with_dues.blade.php ENDPATH**/ ?>