
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading">
				<span class="panel-title" >
					<?php echo e(_lang('Staff Attendance Report')); ?>

				</span>
			</div>
			<div class="panel-body">
				<form id="search_form" class="params-panel validate" action="<?php echo e(url('reports/staff_attendance_report/view')); ?>" method="post" autocomplete="off" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<div class="col-md-4">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Role')); ?></label>
							<select name="user_type" class="form-control select2" required>
								<option value=""><?php echo e(_lang('Select One')); ?></option>
								<option <?php if($user_type=='Admin'): ?> selected <?php endif; ?> value="Admin"><?php echo e(_lang('Admin')); ?></option>
								<option <?php if($user_type=='Teacher'): ?> selected <?php endif; ?> value="Teacher"><?php echo e(_lang('Teacher')); ?></option>
								<option <?php if($user_type=='Accountant'): ?> selected <?php endif; ?> value="Accountant"><?php echo e(_lang('Accountant')); ?></option>
								<option <?php if($user_type=='Librarian'): ?> selected <?php endif; ?> value="Librarian"><?php echo e(_lang('Librarian')); ?></option>
								<option <?php if($user_type=='Employee'): ?> selected <?php endif; ?> value="Employee"><?php echo e(_lang('Employee')); ?></option>
							</select>
						</div>
					</div>
					<div class="col-md-4">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Month')); ?></label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="text" class="form-control monthpicker" name="month" value="<?php echo e($month); ?>" readOnly="true" required>
						    </div>
						</div>
					</div>
					

					<div class="col-sm-3">
						<div class="form-group">
							<button type="submit" style="margin-top:24px;" class="btn btn-primary btn-block rect-btn"><?php echo e(_lang('View Report')); ?></button>
						</div>
					</div>
				</form>
				
				<?php if( isset($report_data) ): ?>	
				<div class="col-md-12 params-panel" id="attendance">
                    <button type="button" data-print="attendance" class="btn btn-primary btn-sm pull-right print"><i class="fa fa-print"></i> <?php echo e(_lang('Print Report')); ?></button>			
						<div class="text-center clear">
							<?php echo e(get_option('school_name')); ?><br>
							<?php echo e(_lang('Attendance Report for')); ?> <?php echo e($user_type); ?><br>
							<?php echo e($month); ?></br></br>	
						</div>
						
					   <div class="table-responsive"> 
					    <?php if( !empty($report_data) ): ?>
							<table class="table table-bordered">
								<thead>
								   <th><?php echo e($user_type." "._lang('Name')); ?></th>
								   <?php for($day = 1; $day <= $num_of_days; $day++): ?>
									  <th><?php echo e($day); ?></th>
								   <?php endfor; ?>
								</thead>
								<tbody>
								  <?php $__currentLoopData = $report_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								   <tr>
									 <td><?php echo e($users[$key]->name); ?></td>
									 <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user=>$attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<td class="text-center"><?php echo e($attendance); ?></td> 
									 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								   </tr>
								  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						<?php else: ?>	
							<h4 class="text-center"><?php echo e(_lang('No Records Found !')); ?></h4>
						<?php endif; ?>	
					   </div>
						
					</div><!--End panel-->
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\htdocs\hostel\resources\views/backend/reports/staff_attendance_report.blade.php ENDPATH**/ ?>