
<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="panel panel-default">
			<div class="panel-heading">
				<span class="panel-title" >
					<?php echo e(_lang('Expense Report')); ?>

				</span>
			</div>
			<div class="panel-body">
				<form id="search_form" class="params-panel validate" action="<?php echo e(url('reports/expense_report/view')); ?>" method="post" autocomplete="off" accept-charset="utf-8">
					<?php echo csrf_field(); ?>
					<div class="col-md-4">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Date From')); ?></label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="text" class="form-control datepicker" name="date1" value="<?php echo e($date1); ?>" readOnly="true" required>
						    </div>
						</div>
					</div>
					
					<div class="col-md-4">
						<div class="form-group">
							<label class="control-label"><?php echo e(_lang('Date To')); ?></label>
							<div class="input-group">
								<span class="input-group-addon"><i class="glyphicon glyphicon-calendar"></i></span>
								<input type="text" class="form-control datepicker" name="date2" value="<?php echo e($date2); ?>" readOnly="true" required>
						    </div>
						</div>
					</div>
					

					<div class="col-sm-3">
						<div class="form-group">
							<button type="submit" style="margin-top:24px;" class="btn btn-primary btn-block rect-btn"><?php echo e(_lang('View Report')); ?></button>
						</div>
					</div>
				</form>
				
				<?php if( isset($report_data) ): ?>	
				<div class="col-md-12 params-panel" id="report">
                    <button type="button" data-print="report" class="btn btn-primary btn-sm pull-right print"><i class="fa fa-print"></i> <?php echo e(_lang('Print Report')); ?></button>			
						<div class="text-center clear">
							<?php echo e(get_option('school_name')); ?><br>
							<?php echo e(_lang('Expense Report from')); ?> <?php echo e($date1." "._lang("to")." ".$date2); ?><br></br>	
						</div>
						
		
					    <?php if( !empty($report_data) ): ?>
							<?php $currency = get_option('currency_symbol') ?>
							<table class="table table-bordered">
								<thead>
								    <th><?php echo e(_lang('Date')); ?></th>
									<th><?php echo e(_lang('Account')); ?></th>
									<th><?php echo e(_lang('Amount')); ?></th>
									<th><?php echo e(_lang('Income Type')); ?></th>
								</thead>
								<tbody>
								  <?php $__currentLoopData = $report_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($transaction->trans_date); ?></td>
										<td><?php echo e($transaction->account_name); ?></td>
										<td><?php echo e($currency." ".$transaction->amount); ?></td>
										<td><?php echo e($transaction->c_type); ?></td>
								  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td></td>
										<td><?php echo e(_lang('Total')); ?></td>
										<td><?php echo e($currency." ".$summary->total); ?></td>
										<td></td>
									</tr>								  
								</tbody>
							</table>
						<?php else: ?>	
							<h4 class="text-center"><?php echo e(_lang('No Records Found !')); ?></h4>
						<?php endif; ?>		
					</div><!--End panel-->
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\htdocs\hostel\resources\views/backend/reports/expense_report.blade.php ENDPATH**/ ?>